/*
 * @(#)ConsoleWindow.java
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
 
package spec.harness;
import java.awt.*;

/**
 * Console output window
 */ 
public
class ConsoleWindow extends Frame {
    /**
     * The TextField componant
     */
    TextArea text = new TextArea(25,80);

    /**
     * First show() call flag
     */
    boolean firstTime = true;

    /**
     * Constructor
     */   
    public ConsoleWindow(){   
        setTitle("SpecJava Console");
	setLayout(new GridLayout(1,1,2,2));
	add(text);
    }
        
	
    /**
     * Setup the window
     */
    public void show() {
	if (firstTime) {
	    firstTime = false;
	    super.show();
            hide();
            resize(insets().left + insets().right  + 400,
		   insets().top  + insets().bottom + 360);	
	}
	super.show();
    }
    
	    
    /**
     * Append some data
     */
    public void append(String data) {
	if (Context.getCommandLineMode()) {
	    System.out.print(data);
	} else {
	    if (firstTime == false) {
		text.appendText(data);
	    }
	}
    }      
    
    
    /**
     * Handle event
     */
    public boolean handleEvent(Event evt) {
        switch( evt.id ) {
        case Event.WINDOW_DESTROY:
	    Context.stopOutputWindow();
            return true;
        default:
            return super.handleEvent(evt);
        }
    }
}