/**************************************************************
  Java-Lex: A Lexical Analyzer Generator for Java
  Written by Elliot Berk. Copyright 1996.
  Contact at ejberk@princeton.edu.

  Modified N.Shaylor
  08-Sep-96 - Change yy_lookahead, yy_advance(), and YYEOF to be int.
            - Zero yy_char_count every '\n'.
            - Put in a package and define all classes final.
            - Use nshaylor.util.BitSet that checks for the grow
              bug in JDK 1.0.

  07-Oct-96 - Add  yy_getcharArray();

  11-Oct-96 - Use nshaylor.jlx.BitSet that checks for the grow
  
  07-Nov-96 - Make yy_nxt, yy_rmap, yy_cmap, and yy_acpt short arrays
            - Make all constants like YYEOF static

  08-Nov-96 - Change yy_acpt, yy_this_accept, YY_NOT_ACCEPT, and
            - YY_NO_ANCHOR to byte

  11-Nov-96 - Use BufferedOutputStreams to spead things up?
            - Make all final variables static.

  17-Feb-97 - Remove BufferedOutputStreams. Somehow this causes a
              problem and the end of the output file is truncated.
              I don't have the time now to find out why, so we go back
              to the old slow way that works.

  *************************************************************/

/***************************************************************
  Package Declaration
  **************************************************************/
/* UNDONE: Uncomment this. */

//package nshaylor.jlx; //**NS**

/***************************************************************
  Imported Packages
  **************************************************************/
import java.io.InputStream;
import java.io.OutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.DataOutputStream;
import java.io.BufferedOutputStream; //**NS**

import java.lang.System;
import java.lang.Integer;
import java.lang.Character;

import java.util.BitSet; //**NS**
import java.util.Enumeration;
import java.util.Stack;
import java.util.Hashtable;
import java.util.Vector;

/******************************
  Questions:
  2) How should I use the Java package system
  to make my tool more modularized and
  coherent?

  Unimplemented:
  !) Fix BitSet issues -- expand only when necessary.
  2) Repeated accept rules.
  6) Clean up the CAlloc class and use buffered
  allocation.
  7) Reading and writing in Unicode.
  Use DataInputStream and DataOutputStream,
  along with writeUTF???
  8) Fix or at least annotate ^x bug.
  9) Add to spec about extending character set.
  10) making sure newlines are handled correctly
  and consistly with the m_unix flag
  11) m_verbose -- what should be done with it?
  12) turn lexical analyzer into a coherent
  Java package
  13) turn lexical analyzer generator into a
  coherent Java package
  16) pretty up generated code
  17) make it possible to have white space in
  regular expressions
  18) clean up all of the class files the lexer
  generator produces when it is compiled,
  and reduce this number in some way.
  24) character format to and from file: writeup
  and implementation
  25) Debug by testing all arcane regular expression cases.
  26) Look for and fix all UNDONE comments below.
  27) Fix package system.
  28) Clean up unnecessary classes.
  *****************************/

/***************************************************************
  Class: CSpec
 **************************************************************/
final class CSpec //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
    
  /* Lexical States. */
  Hashtable m_states; /* Hashtable taking state indices (Integer) 
                         to state name (String). */

  /* Regular Expression Macros. */ 
  Hashtable m_macros; /* Hashtable taking macro name (String)
                                to corresponding char buffer that
                                holds macro definition. */

  /* NFA Machine. */
  CNfa m_nfa_start; /* Start state of NFA machine. */
  Vector m_nfa_states; /* Vector of states, with index
                                 corresponding to label. */
  
  Vector m_state_rules[]; /* An array of Vectors of Integers.
                                    The ith Vector represents the lexical state
                                    with index i.  The contents of the ith 
                                    Vector are the indices of the NFA start
                                    states that can be matched while in
                                    the ith lexical state. */
                                    

  int m_state_dtrans[];

  /* DFA Machine. */
  Vector m_dfa_states; /* Vector of states, with index
                                 corresponding to label. */
  Hashtable m_dfa_sets; /* Hashtable taking set of NFA states
                                  to corresponding DFA state, 
                                  if the latter exists. */
  
  /* Accept States and Corresponding Anchors. */
  Vector m_accept_vector;
  int m_anchor_array[];

  /* Transition Table. */
  Vector m_dtrans_vector;
  int m_dtrans_ncols;
  int m_row_map[];
  int m_col_map[];

  /* Regular expression token variables. */
  int m_current_token;
  char m_lexeme;
  boolean m_in_quote;

  /* Verbose execturion flag. */
  boolean m_verbose;

  /* Java-Lex directives flags. */
  boolean m_integer_type;
  boolean m_intwrap_type;
  boolean m_yyeof;
  boolean m_count_chars;
  boolean m_count_lines;
  boolean m_cup_compatible;
  boolean m_unix;

  char m_init_code[];
  int m_init_read;

  char m_init_throw_code[];
  int m_init_throw_read;

  char m_class_code[];
  int m_class_read;

  char m_eof_code[];
  int m_eof_read;

  char m_eof_value_code[];
  int m_eof_value_read;

  char m_eof_throw_code[];
  int m_eof_throw_read;

  char m_yylex_throw_code[];
  int m_yylex_throw_read;

  /* Class, function, type names. */
  char m_class_name[] = {          
    'Y', 'y', 'l', 
    'e', 'x' 
    };
  char m_function_name[] = {
    'y', 'y', 'l', 
    'e', 'x' 
    };
  char m_type_name[] = {
    'Y', 'y', 't', 
    'o', 'k', 'e',
    'n'
    };

  /* Lexical Generator. */
  private CLexGen m_lexGen;

  /***************************************************************
    Constants
    ***********************************************************/
  static final int NONE = 0;
  static final int START = 1;
  static final int END = 2;
  
  /***************************************************************
    Function: CSpec
    Description: Constructor.
    **************************************************************/
  CSpec
    (
     CLexGen lexGen
     )
      {
        m_lexGen = lexGen;

        /* Initialize regular expression token variables. */
        m_current_token = m_lexGen.EOS;
        m_lexeme = '\0';
        m_in_quote = false;

        /* Initialize hashtable for lexer states. */
        m_states = new Hashtable();
        m_states.put(new String("YYINITIAL"),new Integer(m_states.size()));

        /* Initialize hashtable for lexical macros. */
        m_macros = new Hashtable();

        /* Initialize variables for lexer options. */
        m_integer_type = false;
        m_intwrap_type = false;
        m_count_lines = false;
        m_count_chars = false;
        m_cup_compatible = false;
        m_unix = true;
        m_yyeof = false;

        /* Initialize variables for Java-Lex runtime options. */
        m_verbose = true;

        m_nfa_start = null;
        m_nfa_states = new Vector();
        
        m_dfa_states = new Vector();
        m_dfa_sets = new Hashtable();

        m_dtrans_vector = new Vector();
        m_dtrans_ncols = CUtility.MAX_SEVEN_BIT + 1;
        m_row_map = null;
        m_col_map = null;

        m_accept_vector = null;
        m_anchor_array = null;

        m_init_code = null;
        m_init_read = 0;

        m_init_throw_code = null;
        m_init_throw_read = 0;

        m_yylex_throw_code = null;
        m_yylex_throw_read = 0;

        m_class_code = null;
        m_class_read = 0;

        m_eof_code = null;
        m_eof_read = 0;

        m_eof_value_code = null;
        m_eof_value_read = 0;

        m_eof_throw_code = null;
        m_eof_throw_read = 0;

        m_state_dtrans = null;

        m_state_rules = null;
      }
}

/***************************************************************
  Class: CEmit
  **************************************************************/
final class CEmit //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private CSpec m_spec;
  private DataOutputStream m_outstream;

  /***************************************************************
    Constants: Anchor Types
    **************************************************************/
  private final int START = 1;
  private final int END = 2;
  private final int NONE = 4;

  /***************************************************************
    Constants
    **************************************************************/
  private final boolean EDBG = true;
  private final boolean NOT_EDBG = false;

  /***************************************************************
    Function: CEmit
    Description: Constructor.
    **************************************************************/
  CEmit
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: reset
    Description: Clears member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_spec = null;
        m_outstream = null;
      }

  /***************************************************************
    Function: set
    Description: Initializes member variables.
    **************************************************************/
  private void set
    (
     CSpec spec,
     OutputStream outstream
     )
      {
        if (CUtility.DEBUG)
          {
            CUtility.assert(null != spec);
            CUtility.assert(null != outstream);
          }

        m_spec = spec;
        m_outstream = new DataOutputStream(
                        /*new BufferedOutputStream(*/ outstream /*)*/ ); //**NS**
      }

  /***************************************************************
    Function: emit_imports
    Description: Emits import packages at top of 
    generated source file.
    **************************************************************/
  /*void emit_imports
    (
     CSpec spec,
     OutputStream outstream
     )
      throws java.io.IOException      
        {
          set(spec,outstream);
          
          if (CUtility.DEBUG)
            {
              CUtility.assert(null != m_spec);
              CUtility.assert(null != m_outstream);
            }*/
          
          /*m_outstream.writeBytes("import java.lang.String;\n");
          m_outstream.writeBytes("import java.lang.System;\n");
          m_outstream.writeBytes("import java.io.DataInputStream;\n");
          m_outstream.writeBytes("import java.io.InputStream;\n");*/
        /*  
          reset();
        }*/
  
  /***************************************************************
    Function: print_details
    Description: Debugging output.
    **************************************************************/
  private void print_details
    (
     )
      {
        int i;
        int j;
        int next;
        int state;
        CDTrans dtrans;
        CAccept accept;
        boolean tr;

        System.out.println("---------------------- Transition Table " 
                           + "----------------------");
        
        for (i = 0; i < m_spec.m_row_map.length; ++i)
          {
            System.out.print("State " + i);
            
            accept = (CAccept) m_spec.m_accept_vector.elementAt(i);
            if (null == accept)
              {
                System.out.println(" [nonaccepting]");
              }
            else
              {
                System.out.println(" [accepting, line "
                                 + accept.m_line_number 
                                 + " <"
                                 + (new java.lang.String(accept.m_action,0,
                                               accept.m_action_read))
                                 + ">]");
              }
            dtrans = (CDTrans) m_spec.m_dtrans_vector.elementAt(m_spec.m_row_map[i]);
            
            tr = false;
            state = dtrans.m_dtrans[m_spec.m_col_map[0]];
            if (CDTrans.F != state)
              {
                tr = true;
                System.out.print("\tgoto " + state + " on [" + ((char) 0));
              }
            for (j = 1; j < m_spec.m_dtrans_ncols; ++j)
              {
                next = dtrans.m_dtrans[m_spec.m_col_map[j]];
                if (state == next)
                  {
                    if (CDTrans.F != state)
                      {
                        System.out.print((char) j);
                      }
                  }
                else
                  {
                    state = next;
                    if (true == tr)
                      {
                        System.out.println("]");
                        tr = false;
                      }
                    if (CDTrans.F != state)
                      {
                        tr = true;
                        System.out.print("\tgoto " + state + " on [" + ((char) j));
                      }
                  }
              }
            if (true == tr)
              {
                System.out.println("]");
              }
          }

        System.out.println("---------------------- Transition Table " 
                           + "----------------------");
      }

  /***************************************************************
    Function: emit
    Description: High-level access function to module.
    **************************************************************/
  void emit
    (
     CSpec spec,
     OutputStream outstream
     )
      throws java.io.IOException      
        {
          set(spec,outstream);
          
          if (CUtility.DEBUG)
            {
              CUtility.assert(null != m_spec);
              CUtility.assert(null != m_outstream);
            }
          
          if (CUtility.OLD_DEBUG) {
            print_details();
          }

          emit_header();
          emit_construct();
          emit_helpers();
          emit_driver();
          emit_footer();
          
          reset();
        }

  /***************************************************************
    Function: emit_construct
    Description: Emits constructor, member variables,
    and constants.
    **************************************************************/
  private void emit_construct
    (
     )
      throws java.io.IOException
        {
          if (CUtility.DEBUG)
          {
            CUtility.assert(null != m_spec);
            CUtility.assert(null != m_outstream);
          }
          
          /* Constants */
          m_outstream.writeBytes("\tprivate static final int YY_BUFFER_SIZE = 512;\n");  //**NS**

          m_outstream.writeBytes("\tprivate static final int YY_F = -1;\n");             //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_NO_STATE = -1;\n");      //**NS**

          m_outstream.writeBytes("\tprivate static final byte YY_NOT_ACCEPT = 0;\n");     //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_START = 1;\n");          //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_END = 2;\n");            //**NS**
          m_outstream.writeBytes("\tprivate static final byte YY_NO_ANCHOR = 4;\n");      //**NS**

          m_outstream.writeBytes("\tpublic static final int YYEOF = -1;\n");             //**NS**
          
          /* User specified class code. */
          if (null != m_spec.m_class_code)
            {
              m_outstream.writeBytes(new String(m_spec.m_class_code,0,
                                                m_spec.m_class_read));
            }

          /* Member Variables */
          m_outstream.writeBytes("\tprivate java.io.DataInputStream yy_instream;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_index;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_read;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_start;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_end;\n");
          m_outstream.writeBytes("\tprivate byte yy_buffer[];\n");
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\tprivate int yy_char_count;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\tprivate int yy_line_count;\n");
            }
          m_outstream.writeBytes("\tprivate int yy_lexical_state;\n");
          /*if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\tprivate int yy_buffer_prev_start;\n");
            }*/
          
          /* Function: constructor */
          m_outstream.writeBytes("\t");
          m_outstream.writeBytes(new String(m_spec.m_class_name));
          m_outstream.writeBytes(" (java.io.InputStream instream)");
          
          if (null != m_spec.m_init_throw_code)
            {
              m_outstream.writeBytes("\n"); 
              m_outstream.writeBytes("\t\tthrows "); 
              m_outstream.writeBytes(new String(m_spec.m_init_throw_code,0,
                                                m_spec.m_init_throw_read));
              m_outstream.writeBytes("\n\t\t{\n");
            }
          else
            {
              m_outstream.writeBytes(" {\n");
            }
          
          m_outstream.writeBytes("\t\tif (null == instream) {\n");
          m_outstream.writeBytes("\t\t\tthrow (new Error(\"Error: Bad input "
                                 + "stream initializer.\"));\n");
          m_outstream.writeBytes("\t\t}\n");
          m_outstream.writeBytes("\t\tyy_instream = new java.io.DataInputStream(instream);\n");
          m_outstream.writeBytes("\t\tyy_buffer = new byte[YY_BUFFER_SIZE];\n");
          m_outstream.writeBytes("\t\tyy_buffer_read = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_index = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_start = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_end = 0;\n");
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tyy_char_count = 0;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\tyy_line_count = 0;\n");
            }
          m_outstream.writeBytes("\t\tyy_lexical_state = YYINITIAL;\n");
          /*if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tyy_buffer_prev_start = 0;\n");
            }*/

          /* User specified constructor code. */
          if (null != m_spec.m_init_code)
            {
              m_outstream.writeBytes(new String(m_spec.m_init_code,0,
                                                m_spec.m_init_read));
            }

          m_outstream.writeBytes("\t}\n");
        }

  /***************************************************************
    Function: emit_states
    Description: Emits constants that serve as lexical states,
    including YYINITIAL.
    **************************************************************/
  private void emit_states
    (
     )
      throws java.io.IOException
        {
          Enumeration states;
          String state;
          int index;

          states = m_spec.m_states.keys();
          /*index = 0;*/
          while (true == states.hasMoreElements())
            {
              state = (String) states.nextElement();
              
              if (CUtility.DEBUG)
                {
                  CUtility.assert(null != state);
                }
              
              m_outstream.writeBytes("\tprivate final int " 
                                     + state 
                                     + " = " 
                                     + (m_spec.m_states.get(state)).toString() 
                                     + ";\n");
              /*++index;*/
            }

          m_outstream.writeBytes("\tprivate final int yy_state_dtrans[] = {\n");
          for (index = 0; index < m_spec.m_state_dtrans.length; ++index)
            {
              m_outstream.writeBytes("\t\t" + m_spec.m_state_dtrans[index]);
              if (index < m_spec.m_state_dtrans.length - 1)
                {
                  m_outstream.writeBytes(",\n");
                }
              else
                {
                  m_outstream.writeBytes("\n");
                }
            }
          m_outstream.writeBytes("\t};\n");
        }

  /***************************************************************
    Function: emit_helpers
    Description: Emits helper functions, particularly 
    error handling and input buffering.
    **************************************************************/
  private void emit_helpers
    (
     )
      throws java.io.IOException
      {
        if (CUtility.DEBUG)
          {
            CUtility.assert(null != m_spec);
            CUtility.assert(null != m_outstream);
          }

        /* Function: yy_do_eof */
        m_outstream.writeBytes("\tprivate boolean yy_eof_done = false;\n");
        if (null != m_spec.m_eof_code)
          {
            m_outstream.writeBytes("\tprivate void yy_do_eof ()");

            if (null != m_spec.m_eof_throw_code)
              {
                m_outstream.writeBytes("\n"); 
                m_outstream.writeBytes("\t\tthrows "); 
                m_outstream.writeBytes(new String(m_spec.m_eof_throw_code,0,
                                                  m_spec.m_eof_throw_read));
                m_outstream.writeBytes("\n\t\t{\n");
              }
            else
              {
                m_outstream.writeBytes(" {\n");
              }

            m_outstream.writeBytes("\t\tif (false == yy_eof_done) {\n");
            m_outstream.writeBytes(new String(m_spec.m_eof_code,0,
                                              m_spec.m_eof_read));
            m_outstream.writeBytes("\t\t}\n");
            m_outstream.writeBytes("\t\tyy_eof_done = true;\n");
            m_outstream.writeBytes("\t}\n");
          }

        emit_states();
        
        /* Function: yybegin */
        m_outstream.writeBytes("\tprivate void yybegin (int state) {\n");
        m_outstream.writeBytes("\t\tyy_lexical_state = state;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_initial_dtrans */
        /*m_outstream.writeBytes("\tprivate int yy_initial_dtrans (int state) {\n");
        m_outstream.writeBytes("\t\treturn yy_state_dtrans[state];\n");
        m_outstream.writeBytes("\t}\n");*/

        /* Function: yy_advance */
        m_outstream.writeBytes("\tprivate int yy_advance ()\n"); //**NS**
        m_outstream.writeBytes("\t\tthrows java.io.IOException {\n");
        /*m_outstream.writeBytes("\t\t{\n");*/
        m_outstream.writeBytes("\t\tint next_read;\n");
        m_outstream.writeBytes("\t\tint i;\n");
        m_outstream.writeBytes("\t\tint j;\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\tif (yy_buffer_index < yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\treturn yy_buffer[yy_buffer_index++] & 0xFF;\n"); //**NS**
        /*m_outstream.writeBytes("\t\t\t++yy_buffer_index;\n");*/
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\tif (0 != yy_buffer_start) {\n");
        m_outstream.writeBytes("\t\t\ti = yy_buffer_start;\n");
        m_outstream.writeBytes("\t\t\tj = 0;\n");
        m_outstream.writeBytes("\t\t\twhile (i < yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\t\tyy_buffer[j] = yy_buffer[i];\n");
        m_outstream.writeBytes("\t\t\t\t++i;\n");
        m_outstream.writeBytes("\t\t\t\t++j;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_end = yy_buffer_end - yy_buffer_start;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_start = 0;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = j;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_index = j;\n");
        m_outstream.writeBytes("\t\t\tnext_read = yy_instream.read(yy_buffer,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        m_outstream.writeBytes("\t\t\t\treturn YYEOF;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\twhile (yy_buffer_index >= yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\tif (yy_buffer_index >= yy_buffer.length) {\n");
        m_outstream.writeBytes("\t\t\t\tyy_buffer = yy_double(yy_buffer);\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tnext_read = yy_instream.read(yy_buffer,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        m_outstream.writeBytes("\t\t\t\treturn YYEOF;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        m_outstream.writeBytes("\t\t}\n");

        m_outstream.writeBytes("\t\treturn yy_buffer[yy_buffer_index++] & 0xFF;\n"); //**NS**
        m_outstream.writeBytes("\t}\n");
        
        /* Function: yy_move_start */
        m_outstream.writeBytes("\tprivate void yy_move_start () {\n");
        if (true == m_spec.m_count_lines)
          {
            if (true == m_spec.m_unix)
              {
                m_outstream.writeBytes("\t\tif ((byte) '\\n' " 
                                       + "== yy_buffer[yy_buffer_start]) {\n");
              }
            else
              {         
                m_outstream.writeBytes("\t\tif ((byte) '\\n' " 
                                       + "== yy_buffer[yy_buffer_start]\n"); 
                m_outstream.writeBytes("\t\t\t|| (byte) '\\r' " 
                                       + "== yy_buffer[yy_buffer_start]) {\n");
              }
            m_outstream.writeBytes("\t\t\t++yy_line_count; yy_char_count = 0;\n"); //**NS**
            m_outstream.writeBytes("\t\t}\n");
          }
        if (true == m_spec.m_count_chars)
          {
            m_outstream.writeBytes("\t\t++yy_char_count;\n");
          }
        m_outstream.writeBytes("\t\t++yy_buffer_start;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_pushback */
        m_outstream.writeBytes("\tprivate void yy_pushback () {\n");
        m_outstream.writeBytes("\t\t--yy_buffer_end;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_mark_start */
        m_outstream.writeBytes("\tprivate void yy_mark_start () {\n");
        if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
          {
            if (true == m_spec.m_count_lines)
              {
                m_outstream.writeBytes("\t\tint i;\n");
                m_outstream.writeBytes("\t\tfor (i = yy_buffer_start; " 
                                       + "i < yy_buffer_index; ++i) {\n");
                if (true == m_spec.m_unix)
                  {
                    m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i]) {\n");
                  }
                else
                  {             
                    m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i] || " 
                                           + "(byte) '\\r' == yy_buffer[i]) {\n");
                  }
                m_outstream.writeBytes("\t\t\t\t++yy_line_count;  yy_char_count = 0;\n"); //**NS**
                m_outstream.writeBytes("\t\t\t}\n");
                m_outstream.writeBytes("\t\t++yy_char_count;\n"); //**NS**               
                m_outstream.writeBytes("\t\t}\n");
              }
            if (true == m_spec.m_count_chars)
              {
//**NS**                m_outstream.writeBytes("\t\tyy_char_count = yy_char_count\n"); 
//**NS**                m_outstream.writeBytes("\t\t\t+ yy_buffer_index - yy_buffer_start;\n");
              }
          }
        m_outstream.writeBytes("\t\tyy_buffer_start = yy_buffer_index;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_mark_end */
        m_outstream.writeBytes("\tprivate void yy_mark_end () {\n");
        m_outstream.writeBytes("\t\tyy_buffer_end = yy_buffer_index;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_to_mark */
        m_outstream.writeBytes("\tprivate void yy_to_mark () {\n");
        m_outstream.writeBytes("\t\tyy_buffer_index = yy_buffer_end;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_gettext */
        m_outstream.writeBytes("\tprivate java.lang.String yy_gettext () {\n");
        m_outstream.writeBytes("\t\treturn (new java.lang.String(yy_buffer,0,\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_start,\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_end - yy_buffer_start));\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_getcharArray */
        m_outstream.writeBytes("private char[] yy_getcharArray()\n"); 
        m_outstream.writeBytes("\t{\n");  	
        m_outstream.writeBytes("\tint  count   = yy_buffer_end - yy_buffer_start;\n");
        m_outstream.writeBytes("\tchar value[] = new char[count];\n");
        m_outstream.writeBytes("\tfor( int i = count ; i-- > 0 ; )\n");
        m_outstream.writeBytes("\t\tvalue[i] = (char) (yy_buffer[i + yy_buffer_start] & 0xff);\n");
        m_outstream.writeBytes("\treturn value;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_getchar */
        if (true == m_spec.m_count_chars)
          {
            m_outstream.writeBytes("\tprivate int yy_getchar () {\n");
            m_outstream.writeBytes("\t\treturn yy_char_count;\n");
            m_outstream.writeBytes("\t}\n");
          }

        /* Function: yy_getline */
        if (true == m_spec.m_count_lines)
          {
            m_outstream.writeBytes("\tprivate int yy_getline () {\n");
            m_outstream.writeBytes("\t\treturn yy_line_count;\n");
            m_outstream.writeBytes("\t}\n");
          }

        /* Function: yy_double */
        m_outstream.writeBytes("\tprivate byte[] yy_double (byte buf[]) {\n");
        m_outstream.writeBytes("\t\tint i;\n\t\tbyte newbuf[];\n");
        m_outstream.writeBytes("\t\tnewbuf = new byte[2*buf.length];\n");
        m_outstream.writeBytes("\t\tfor (i = 0; i < buf.length; ++i) {\n");
        m_outstream.writeBytes("\t\t\tnewbuf[i] = buf[i];\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\t\treturn newbuf;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_error */
        m_outstream.writeBytes("\tprivate final int YY_E_INTERNAL = 0;\n");
        m_outstream.writeBytes("\tprivate final int YY_E_MATCH = 1;\n");
        m_outstream.writeBytes("\tprivate java.lang.String yy_error_string[] = {\n");
        m_outstream.writeBytes("\t\t\"Error: Internal error.\\n\",\n");
        m_outstream.writeBytes("\t\t\"Error: Unmatched input.\\n\"\n");
        m_outstream.writeBytes("\t};\n");
        m_outstream.writeBytes("\tprivate void yy_error (int code,boolean fatal) {\n");
        m_outstream.writeBytes("\t\tjava.lang.System.out.print(yy_error_string[code]);\n");
        m_outstream.writeBytes("\t\tjava.lang.System.out.flush();\n");
        m_outstream.writeBytes("\t\tif (true == fatal) {\n");
        m_outstream.writeBytes("\t\t\tthrow new Error(\"Fatal Error.\\n\");\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_next */
        /*m_outstream.writeBytes("\tprivate int yy_next (int current,byte lookahead) {\n");
        m_outstream.writeBytes("\t\treturn yy_nxt[yy_rmap[current]][yy_cmap[lookahead]];\n");
        m_outstream.writeBytes("\t}\n");*/

        /* Function: yy_accept */
        /*m_outstream.writeBytes("\tprivate int yy_accept (int current) {\n");
        m_outstream.writeBytes("\t\treturn yy_acpt[current];\n");
        m_outstream.writeBytes("\t}\n");*/
      }

  /***************************************************************
    Function: emit_header
    Description: Emits class header.
    **************************************************************/
  private void emit_header
    (
     )
      throws java.io.IOException
      {
        if (CUtility.DEBUG)
          {
            CUtility.assert(null != m_spec);
            CUtility.assert(null != m_outstream);
          }

        m_outstream.writeBytes("\n\nclass ");
        m_outstream.writeBytes(new String(m_spec.m_class_name,0,
                                          m_spec.m_class_name.length));
        m_outstream.writeBytes(" {\n");
      }

  /***************************************************************
    Function: emit_table
    Description: Emits transition table.
    **************************************************************/
  private void emit_table
    (
     )
      throws java.io.IOException
      {
        int i;
        int elem;
        int size;
        CDTrans dtrans;
        boolean is_start;
        boolean is_end;
        CAccept accept;

        if (CUtility.DEBUG)
          {
            CUtility.assert(null != m_spec);
            CUtility.assert(null != m_outstream);
          }

        m_outstream.writeBytes("\tprivate byte yy_acpt[] = {\n");  //**NS**
        size = m_spec.m_accept_vector.size();
        for (elem = 0; elem < size; ++elem)
          {
            accept = (CAccept) m_spec.m_accept_vector.elementAt(elem);
            
            if (null != accept)
              {
                is_start = (0 != (m_spec.m_anchor_array[elem] & CSpec.START));
                is_end = (0 != (m_spec.m_anchor_array[elem] & CSpec.END));
                
                if (true == is_start && true == is_end)
                  {
                    m_outstream.writeBytes("\t\tYY_START | YY_END");
                  }
                else if (true == is_start)
                  {
                    m_outstream.writeBytes("\t\tYY_START");
                  }
                else if (true == is_end)
                  {
                    m_outstream.writeBytes("\t\tYY_END");
                  }
                else
                  {
                    m_outstream.writeBytes("\t\tYY_NO_ANCHOR");
                  }
              }
            else 
              {
                m_outstream.writeBytes("\t\tYY_NOT_ACCEPT");
              }
            
            if (elem < size - 1)
              {
                m_outstream.writeBytes(",");
              }
            
            m_outstream.writeBytes("\n");
          }
        m_outstream.writeBytes("\t};\n");

        m_outstream.writeBytes("\tprivate short yy_cmap[] = {\n\t\t");  //**NS**
        for (i = 0; i < m_spec.m_col_map.length; ++i)
          {
            m_outstream.writeBytes((new Integer(m_spec.m_col_map[i])).toString());
            
            if (i < m_spec.m_col_map.length - 1)
              {
                m_outstream.writeBytes(",");
              }

            if (0 == ((i + 1) % 8))
              {
                m_outstream.writeBytes("\n\t\t");
              }
            else
              {
                m_outstream.writeBytes(" ");
              }
          }
        m_outstream.writeBytes("\n\t};\n");

        m_outstream.writeBytes("\tprivate short yy_rmap[] = {\n\t\t");  //**NS**
        for (i = 0; i < m_spec.m_row_map.length; ++i)
          {
            m_outstream.writeBytes((new Integer(m_spec.m_row_map[i])).toString());
            
            if (i < m_spec.m_row_map.length - 1)
              {
                m_outstream.writeBytes(",");
              }

            if (0 == ((i + 1) % 8))
              {
                m_outstream.writeBytes("\n\t\t");
              }
            else
              {
                m_outstream.writeBytes(" ");
              }
          }
        m_outstream.writeBytes("\n\t};\n");

        m_outstream.writeBytes("\tprivate short yy_nxt[][] = {\n");  //**NS**
        size = m_spec.m_dtrans_vector.size();
        for (elem = 0; elem < size; ++elem)
          {
            dtrans = (CDTrans) m_spec.m_dtrans_vector.elementAt(elem);
            
            m_outstream.writeBytes("\t\t{ ");
        
            for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
              {
                m_outstream.writeBytes((new Integer(dtrans.m_dtrans[i])).toString());
                
                if (i < m_spec.m_dtrans_ncols - 1)
                  {
                    m_outstream.writeBytes(",");
                  }
                
                if (0 == ((i + 1) % 8))
                  {
                    m_outstream.writeBytes("\n\t\t\t");
                  }
                else
                  {
                    m_outstream.writeBytes(" ");
                  }
              }

            m_outstream.writeBytes("\n\t\t}");

            if (elem < size - 1)
              {
                m_outstream.writeBytes(",");
              }

            m_outstream.writeBytes("\n");
          }
        m_outstream.writeBytes("\t};\n");
      }

  /***************************************************************
    Function: emit_driver
    Description: 
    **************************************************************/
  private void emit_driver
    (
     )
      throws java.io.IOException
        {
          if (CUtility.DEBUG)
            {
              CUtility.assert(null != m_spec);
              CUtility.assert(null != m_outstream);
            }
          
          emit_table();

          if (true == m_spec.m_integer_type)
            {
              m_outstream.writeBytes("\tpublic int ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }
          else if (true == m_spec.m_intwrap_type)
            {
              m_outstream.writeBytes("\tpublic java.lang.Integer ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }
          else
            {
              m_outstream.writeBytes("\tpublic ");
              m_outstream.writeBytes(new String(m_spec.m_type_name));
              m_outstream.writeBytes(" ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }

          /*m_outstream.writeBytes("\t\tthrows java.io.IOException {\n");*/
          m_outstream.writeBytes("\t\tthrows java.io.IOException");
          if (null != m_spec.m_yylex_throw_code)
            {
              m_outstream.writeBytes(", "); 
              m_outstream.writeBytes(new String(m_spec.m_yylex_throw_code,0,
                                                m_spec.m_yylex_throw_read));
              m_outstream.writeBytes("\n\t\t{\n");
            }
          else
            {
              m_outstream.writeBytes(" {\n");
            }

          m_outstream.writeBytes("\t\tint yy_lookahead;\n");
          m_outstream.writeBytes("\t\tint yy_anchor = YY_NO_ANCHOR;\n");
          /*m_outstream.writeBytes("\t\tint yy_state "
            + "= yy_initial_dtrans(yy_lexical_state);\n");*/
          m_outstream.writeBytes("\t\tint yy_state " 
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\tint yy_next_state = YY_NO_STATE;\n");
          /*m_outstream.writeBytes("\t\tint yy_prev_state = YY_NO_STATE;\n");*/
          m_outstream.writeBytes("\t\tint yy_last_accept_state = YY_NO_STATE;\n");
          m_outstream.writeBytes("\t\tboolean yy_initial = true;\n");
          m_outstream.writeBytes("\t\tbyte yy_this_accept;\n"); // **NS**
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tint yychar;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\tint yyline;\n");
            }
          m_outstream.writeBytes("\t\tjava.lang.String yytext;\n");
          m_outstream.writeBytes("\n");

          m_outstream.writeBytes("\t\tyy_mark_start();\n");
          /*m_outstream.writeBytes("\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\tyy_mark_end();\n");
          m_outstream.writeBytes("\t\t}\n");

          if (NOT_EDBG)
            {
              m_outstream.writeBytes("\t\tjava.lang.System.out.println(\"Begin\");\n");
            }

          m_outstream.writeBytes("\t\twhile (true) {\n");

          m_outstream.writeBytes("\t\t\tyy_lookahead = yy_advance();\n");
          m_outstream.writeBytes("\t\t\tyy_next_state = YY_F;\n");
          m_outstream.writeBytes("\t\t\tif (YYEOF != yy_lookahead) {\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_next_state = "
                                 + "yy_next(yy_state,yy_lookahead);\n");*/
          m_outstream.writeBytes("\t\t\t\tyy_next_state = "
                                 + "yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];\n");
          
          m_outstream.writeBytes("\t\t\t}\n");

          if (NOT_EDBG)
            {
              m_outstream.writeBytes("java.lang.System.out.println(\"Current state: \"" 
                                     + " + yy_state\n");
              m_outstream.writeBytes("+ \"\tCurrent input: \"\n"); 
              m_outstream.writeBytes(" + ((char) yy_lookahead));\n");
            }
          if (NOT_EDBG)
            {
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"State = \"" 
                                     + "+ yy_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Accepting status = \"" 
                                     + "+ yy_this_accept);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Last accepting state = \"" 
                                     + "+ yy_last_accept_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Next state = \"" 
                                     + "+ yy_next_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Lookahead input = \"" 
                                     + "+ ((char) yy_lookahead));\n");
            }

          m_outstream.writeBytes("\t\t\tif (YY_F != yy_next_state) {\n");
          m_outstream.writeBytes("\t\t\t\tyy_state = yy_next_state;\n");
          m_outstream.writeBytes("\t\t\t\tyy_initial = false;\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_mark_end();\n");
          m_outstream.writeBytes("\t\t\t\t}\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_prev_state = yy_state;\n");*/
          /*m_outstream.writeBytes("\t\t\t\tyy_state = yy_next_state;\n");*/
          m_outstream.writeBytes("\t\t\t}\n");

          m_outstream.writeBytes("\t\t\telse {\n");
          m_outstream.writeBytes("\t\t\t\tif (YYEOF == yy_lookahead " 
                                 + "&& true == yy_initial) {\n");
          if (null != m_spec.m_eof_code)
            {
              m_outstream.writeBytes("\t\t\t\t\tyy_do_eof();\n");
            }

          if (true == m_spec.m_integer_type || true == m_spec.m_yyeof)
            {
              m_outstream.writeBytes("\t\t\t\t\treturn YYEOF;\n");
            }
          else if (null != m_spec.m_eof_value_code) 
            {
              m_outstream.writeBytes(new String(m_spec.m_eof_value_code,0,
                                                m_spec.m_eof_value_read));
            }
          else
            {
              m_outstream.writeBytes("\t\t\t\t\treturn null;\n");
            }

          m_outstream.writeBytes("\t\t\t\t}\n");
          
          m_outstream.writeBytes("\t\t\t\telse if (YY_NO_STATE == yy_last_accept_state) {\n");
          

          /*m_outstream.writeBytes("\t\t\t\t\tyy_error(YY_E_MATCH,false);\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_initial = true;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_state "
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_next_state = YY_NO_STATE;\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_prev_state = YY_NO_STATE;\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_mark_start();\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");*/

          m_outstream.writeBytes("\t\t\t\t\tthrow (new Error(\"Lexical Error: Unmatched Input.\"));\n");
          m_outstream.writeBytes("\t\t\t\t}\n");

          m_outstream.writeBytes("\t\t\t\telse {\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_to_mark();\n");

          m_outstream.writeBytes("\t\t\t\t\tyy_anchor = yy_acpt[yy_last_accept_state];\n");
          /*m_outstream.writeBytes("\t\t\t\t\tyy_anchor " 
            + "= yy_accept(yy_last_accept_state);\n");*/
          m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_END & yy_anchor)) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_pushback();\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");
          m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_START & yy_anchor)) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_move_start();\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");

          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\t\t\t\tyychar = yy_getchar();\n");
            }

          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\t\t\t\tyyline = yy_getline();\n");
            }

          m_outstream.writeBytes("\t\t\t\t\tyytext = yy_gettext();\n");

          m_outstream.writeBytes("\t\t\t\t\tswitch (yy_last_accept_state) {\n");

          emit_actions("\t\t\t\t\t");

          m_outstream.writeBytes("\t\t\t\t\tdefault:\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_error(YY_E_INTERNAL,false);\n");
          /*m_outstream.writeBytes("\t\t\t\t\t\treturn null;\n");*/
          m_outstream.writeBytes("\t\t\t\t\tcase -1:\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");
          
          m_outstream.writeBytes("\t\t\t\t\tyy_initial = true;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_state "
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_next_state = YY_NO_STATE;\n");
          /*m_outstream.writeBytes("\t\t\t\t\tyy_prev_state = YY_NO_STATE;\n");*/
          m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;\n");

          m_outstream.writeBytes("\t\t\t\t\tyy_mark_start();\n");

          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");

          m_outstream.writeBytes("\t\t\t\t}\n");          
          m_outstream.writeBytes("\t\t\t}\n");
          m_outstream.writeBytes("\t\t}\n");
          m_outstream.writeBytes("\t}\n");

          /*m_outstream.writeBytes("\t\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t}\n");*/
        }
  
  /***************************************************************
    Function: emit_actions
    Description:     
    **************************************************************/
  private void emit_actions 
    (
     String tabs
     )
      throws java.io.IOException
        {
          int elem;
          int size;
          int bogus_index;
          CAccept accept;
          
          if (CUtility.DEBUG)
            {
              CUtility.assert(m_spec.m_accept_vector.size() 
                              == m_spec.m_anchor_array.length);
            }

          bogus_index = -2;
          size = m_spec.m_accept_vector.size();
          for (elem = 0; elem < size; ++elem)
            {
              accept = (CAccept) m_spec.m_accept_vector.elementAt(elem);
              if (null != accept) 
                {
                  m_outstream.writeBytes(tabs + "case " + elem 
                                         /*+ (new Integer(elem)).toString()*/
                                         + ":\n");
                  m_outstream.writeBytes(tabs + "\t");
                  m_outstream.writeBytes(new String(accept.m_action,0,
                                                    accept.m_action_read));
                  m_outstream.writeBytes("\n");
                  m_outstream.writeBytes(tabs + "case " + bogus_index + ":\n");
                  m_outstream.writeBytes(tabs + "\tbreak;\n");
                  --bogus_index;
                }
            }
        }
  
  /***************************************************************
    Function: emit_footer
    Description:     
    **************************************************************/
  private void emit_footer
    (
     )
      throws java.io.IOException
      {
        if (CUtility.DEBUG)
          {
            CUtility.assert(null != m_spec);
            CUtility.assert(null != m_outstream);
          }

        m_outstream.writeBytes("}\n");
      }
}

/***************************************************************
  Class: CBunch
  **************************************************************/
final class CBunch //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  Vector m_nfa_set; /* Vector of CNfa states in dfa state. */
  BitSet m_nfa_bit; /* BitSet representation of CNfa labels. */
  CAccept m_accept; /* Accepting actions, or null if nonaccepting state. */
  int m_anchor; /* Anchors on regular expression. */
  int m_accept_index; /* CNfa index corresponding to accepting actions. */

  /***************************************************************
    Function: CBunch
    Description: Constructor.
    **************************************************************/
  CBunch
    (
     )
      {
        m_nfa_set = null;
        m_nfa_bit = null;
        m_accept = null;
        m_anchor = CSpec.NONE;
        m_accept_index = -1;
      }
}

/***************************************************************
  Class: CMakeNfa
  **************************************************************/
final class CMakeNfa //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private CSpec m_spec;
  private CLexGen m_lexGen;
  private CInput m_input;

  /***************************************************************
    Function: CMakeNfa
    Description: Constructor.
    **************************************************************/
  CMakeNfa
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: reset
    Description: Resets CMakeNfa member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_input = null;
        m_lexGen = null;
        m_spec = null;
      }

  /***************************************************************
    Function: set
    Description: Sets CMakeNfa member variables.
    **************************************************************/
  private void set
    (
     CLexGen lexGen,
     CSpec spec,
     CInput input
     )
      {
        if (CUtility.DEBUG)
          {
            CUtility.assert(null != input);
            CUtility.assert(null != lexGen);
            CUtility.assert(null != spec);
          }

        m_input = input;
        m_lexGen = lexGen;
        m_spec = spec;
      }

  /***************************************************************
    Function: thompson
    Description: High level access function to module.
    Deposits result in input CSpec.
    **************************************************************/
  void thompson
    (
     CLexGen lexGen,
     CSpec spec,
     CInput input
     )
      throws java.io.IOException      
        {       
          int i;
          CNfa elem;
          int size;

          /* Set member variables. */
          reset();
          set(lexGen,spec,input);
          size = m_spec.m_states.size();       
          m_spec.m_state_rules = new Vector[size];
          for (i = 0; i < size; ++i)
            {       
              m_spec.m_state_rules[i] = new Vector();
            }

          /* Initialize current token variable 
             and create nfa. */
          /*m_spec.m_current_token = m_lexGen.EOS;
          m_lexGen.advance();*/

          m_spec.m_nfa_start = machine();
          
          /* Set labels in created nfa machine. */
          size = m_spec.m_nfa_states.size();
          for (i = 0; i < size; ++i)
            {        
              elem = (CNfa) m_spec.m_nfa_states.elementAt(i);
              elem.m_label = i;
            }

          /* Debugging output. */
          if (CUtility.DO_DEBUG)
            {
              m_lexGen.print_nfa();
            }

          if (true == m_spec.m_verbose)
            {
              System.out.println("NFA comprised of " 
                                 + (m_spec.m_nfa_states.size() + 1) 
                                 + " states.");
            }

          reset();
        }
     
  /***************************************************************
    Function: discardCNfa
    Description: 
    **************************************************************/
  private void discardCNfa
    (
     CNfa nfa
     )
      {
        m_spec.m_nfa_states.removeElement(nfa);
      }

  /***************************************************************
    Function: processStates
    Description:
    **************************************************************/
  private void processStates
    (
     BitSet states,
     CNfa current
     )
      {
        int size;
        int i;
        
        size = m_spec.m_states.size();
        for (i = 0; i <  size; ++i)
          {
            if (true == states.get(i))
              {
                m_spec.m_state_rules[i].addElement(current);
              }
          }
      }

  /***************************************************************
    Function: machine
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private CNfa machine
    (
     )
      throws java.io.IOException 
      {
        CNfa start;
        CNfa p;
        BitSet states;

        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.enter("machine",m_spec.m_lexeme,m_spec.m_current_token);
          }

        states = m_lexGen.getStates();

        /* Begin: Added for states. */
        m_spec.m_current_token = m_lexGen.EOS;
        m_lexGen.advance();
        /* End: Added for states. */
        
        start = CAlloc.newCNfa(m_spec);
        p = start;
        p.m_next = rule();

        processStates(states,p.m_next);

        while (m_lexGen.END_OF_INPUT != m_spec.m_current_token)
          {
            /* Make state changes HERE. */
            states = m_lexGen.getStates();
        
            /* Begin: Added for states. */
            m_lexGen.advance();
            if (m_lexGen.END_OF_INPUT == m_spec.m_current_token)
              { 
                break;
              }
            /* End: Added for states. */
            
            p.m_next2 = CAlloc.newCNfa(m_spec);
            p = p.m_next2;
            p.m_next = rule();
            
            processStates(states,p.m_next);
          }

        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.leave("machine",m_spec.m_lexeme,m_spec.m_current_token);
          }

        return start;
      }
  
  /***************************************************************
    Function: rule
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private CNfa rule
    (
     )
      throws java.io.IOException 
      {
        CNfaPair pair; 
        CNfa p;
        CNfa start = null;
        CNfa end = null;
        int anchor = CSpec.NONE;

        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.enter("rule",m_spec.m_lexeme,m_spec.m_current_token);
          }

        pair = CAlloc.newCNfaPair();

        if (m_lexGen.AT_BOL == m_spec.m_current_token)
          {
            start = CAlloc.newCNfa(m_spec);
            start.m_edge = '\n';
            anchor = anchor | CSpec.START;
            m_lexGen.advance();

            expr(pair);
            start.m_next = pair.m_start;
            end = pair.m_end;
          }
        else
          {
            expr(pair);
            start = pair.m_start;
            end = pair.m_end;
          }

        if (m_lexGen.AT_EOL == m_spec.m_current_token)
          {
            m_lexGen.advance();
            end.m_next = CAlloc.newCNfa(m_spec);
            
            /* This is the way he does it. */
            end.m_edge = CNfa.CCL;
            end.m_set = new CSet();

            end.m_set.add('\n');

            if (false == m_spec.m_unix)
              {
                end.m_set.add('\r');
              }
                
            end = end.m_next;
            anchor = anchor | CSpec.END;
          }

        /* Handle end of regular expression.  See page 103. */
        end.m_accept = m_lexGen.packAccept();
        end.m_anchor = anchor;

        /* Begin: Removed for states. */
        /*m_lexGen.advance();*/
        /* End: Removed for states. */

        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.leave("rule",m_spec.m_lexeme,m_spec.m_current_token);
          }

        return start;
      }
            
  /***************************************************************
    Function: expr
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void expr
    (
     CNfaPair pair
     )
      throws java.io.IOException 
      {
        CNfaPair e2_pair;
        CNfa p;
        
        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.enter("expr",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (CUtility.DEBUG)
          {
            CUtility.assert(null != pair);
          }

        e2_pair = CAlloc.newCNfaPair();

        cat_expr(pair);
        
        while (m_lexGen.OR == m_spec.m_current_token)
          {
            m_lexGen.advance();
            cat_expr(e2_pair);

            p = CAlloc.newCNfa(m_spec);
            p.m_next2 = e2_pair.m_start;
            p.m_next = pair.m_start;
            pair.m_start = p;
            
            p = CAlloc.newCNfa(m_spec);
            pair.m_end.m_next = p;
            e2_pair.m_end.m_next = p;
            pair.m_end = p;
          }

        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.leave("expr",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
            
  /***************************************************************
    Function: cat_expr
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void cat_expr
    (
     CNfaPair pair
     )
      throws java.io.IOException 
      {
        CNfaPair e2_pair;

        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.enter("cat_expr",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (CUtility.DEBUG)
          {
            CUtility.assert(null != pair);
          }
        
        e2_pair = CAlloc.newCNfaPair();
        
        if (true == first_in_cat(m_spec.m_current_token))
          {
            factor(pair);
          }

        while (true == first_in_cat(m_spec.m_current_token))
          {
            factor(e2_pair);

            /* Destroy */
            pair.m_end.mimic(e2_pair.m_start);
            discardCNfa(e2_pair.m_start);
            
            pair.m_end = e2_pair.m_end;
          }

        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.leave("cat_expr",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
  
  /***************************************************************
    Function: first_in_cat
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private boolean first_in_cat
    (
     int token
     )
      {
        switch (token)
          {
          case m_lexGen.CLOSE_PAREN:
          case m_lexGen.AT_EOL:
          case m_lexGen.OR:
          case m_lexGen.EOS:
            return false;
            
          case m_lexGen.CLOSURE:
          case m_lexGen.PLUS_CLOSE:
          case m_lexGen.OPTIONAL:
            CError.parse_error(CError.E_CLOSE,m_input.m_line_number);
            return false;

          case m_lexGen.CCL_END:
            CError.parse_error(CError.E_BRACKET,m_input.m_line_number);
            return false;

          case m_lexGen.AT_BOL:
            CError.parse_error(CError.E_BOL,m_input.m_line_number);
            return false;

          default:
            break;
          }

        return true;
      }

  /***************************************************************
    Function: factor
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void factor
    (
     CNfaPair pair
     )
      throws java.io.IOException 
      {
        CNfa start = null;
        CNfa end = null;

        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.enter("factor",m_spec.m_lexeme,m_spec.m_current_token);
          }

        term(pair);

        if (m_lexGen.CLOSURE == m_spec.m_current_token
            || m_lexGen.PLUS_CLOSE == m_spec.m_current_token
            || m_lexGen.OPTIONAL == m_spec.m_current_token)
          {
            start = CAlloc.newCNfa(m_spec);
            end = CAlloc.newCNfa(m_spec);
            
            start.m_next = pair.m_start;
            pair.m_end.m_next = end;

            if (m_lexGen.CLOSURE == m_spec.m_current_token
                || m_lexGen.OPTIONAL == m_spec.m_current_token)
              {
                start.m_next2 = end;
              }
            
            if (m_lexGen.CLOSURE == m_spec.m_current_token
                || m_lexGen.PLUS_CLOSE == m_spec.m_current_token)
              {
                pair.m_end.m_next2 = pair.m_start;
              }
            
            pair.m_start = start;
            pair.m_end = end;
            m_lexGen.advance();
          }

        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.leave("factor",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
      
  /***************************************************************
    Function: term
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void term
    (
     CNfaPair pair
     )
      throws java.io.IOException 
      {
        CNfa start;
        int c;

        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.enter("term",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (m_lexGen.OPEN_PAREN == m_spec.m_current_token)
          {
            m_lexGen.advance();
            expr(pair);

            if (m_lexGen.CLOSE_PAREN == m_spec.m_current_token)
              {
                m_lexGen.advance();
              }
            else
              {
                CError.parse_error(CError.E_SYNTAX,m_input.m_line_number);
              }
          }
        else
          {
            start = CAlloc.newCNfa(m_spec);
            pair.m_start = start;

            start.m_next = CAlloc.newCNfa(m_spec);
            pair.m_end = start.m_next;

            if (false == (m_lexGen.ANY == m_spec.m_current_token
                          || m_lexGen.CCL_START == m_spec.m_current_token))
              {
                start.m_edge = m_spec.m_lexeme;
                m_lexGen.advance();
              }
            else
              {
                start.m_edge = CNfa.CCL;
                
                start.m_set = new CSet();

                /* Match dot (.) using character class. */
                if (m_lexGen.ANY == m_spec.m_current_token)
                  {
                    start.m_set.add((byte) '\n');
                    if (false == m_spec.m_unix)
                      {
                        start.m_set.add((byte) '\r');
                      }
                    start.m_set.complement();
                  }
                else
                  {
                    m_lexGen.advance();
                    if (m_lexGen.AT_BOL == m_spec.m_current_token)
                      {
                        m_lexGen.advance();

                        /*start.m_set.add((byte) '\n');
                        if (false == m_spec.m_unix)
                          {
                            start.m_set.add((byte) '\r');
                          }*/
                        start.m_set.complement();
                      }
                    if (false == (m_lexGen.CCL_END == m_spec.m_current_token))
                      {
                        dodash(start.m_set);
                      }
                    /*else
                      {
                        for (c = 0; c <= ' '; ++c)
                          {
                            start.m_set.add((byte) c);
                          }
                      }*/
                  }
                m_lexGen.advance();
              }
          }

        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.leave("term",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }

  /***************************************************************
    Function: dodash
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void dodash
    (
     CSet set
     )
      throws java.io.IOException 
        {
          int first = -1;
          
          if (CUtility.DESCENT_DEBUG)
            {
              CUtility.enter("dodash",m_spec.m_lexeme,m_spec.m_current_token);
            }
          
          while (m_lexGen.EOS != m_spec.m_current_token 
                 && m_lexGen.CCL_END != m_spec.m_current_token)
            {
              if (m_lexGen.DASH == m_spec.m_current_token)
                {
                  if (CUtility.DEBUG)
                    {
                      CUtility.assert(-1 != first);
                    }
                  
                  m_lexGen.advance();
                  for ( ; first <= m_spec.m_lexeme; ++first)
                    {
                      set.add(first);
                    }  
                }
              else
                {
                  first = m_spec.m_lexeme;
                  set.add(m_spec.m_lexeme);
                }

              m_lexGen.advance();
            }
          
        if (CUtility.DESCENT_DEBUG)
          {
            CUtility.leave("dodash",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
}

/***************************************************************
  Class: CMinimize
 **************************************************************/
final class CMinimize //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  CSpec m_spec;
  Vector m_group;
  int m_ingroup[];

  /***************************************************************
    Function: CMinimize
    Description: Constructor.
    **************************************************************/
  CMinimize 
    (
     )
      {
        reset();
      }
  
  /***************************************************************
    Function: reset
    Description: Resets member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_spec = null;
        m_group = null;
        m_ingroup = null;
      }

  /***************************************************************
    Function: set
    Description: Sets member variables.
    **************************************************************/
  private void set
    (
     CSpec spec
     )
      {
        if (CUtility.DEBUG)
          {
            CUtility.assert(null != spec);
          }

        m_spec = spec;
        m_group = null;
        m_ingroup = null;
      }

  /***************************************************************
    Function: min_dfa
    Description: High-level access function to module.
    **************************************************************/
  void min_dfa
    (
     CSpec spec
     )
      {
        set(spec);

        /* Remove redundant states. */
        minimize();

        /* Column and row compression. 
           Save accept states in auxilary vector. */
        reduce();

        reset();
      }

  /***************************************************************
    Function: col_copy
    Description: Copies source column into destination column.
    **************************************************************/
  private void col_copy
    (
     int dest,
     int src
     )
      {
        int n;
        int i;
        CDTrans dtrans;

        n = m_spec.m_dtrans_vector.size();
        for (i = 0; i < n; ++i)
          {
            dtrans = (CDTrans) m_spec.m_dtrans_vector.elementAt(i);
            dtrans.m_dtrans[dest] = dtrans.m_dtrans[src]; 
          }
      } 
        
  /***************************************************************
    Function: row_copy
    Description: Copies source row into destination row.
    **************************************************************/
  private void row_copy
    (
     int dest,
     int src
     )
      {
        CDTrans dtrans;

        dtrans = (CDTrans) m_spec.m_dtrans_vector.elementAt(src);
        m_spec.m_dtrans_vector.setElementAt(dtrans,dest); 
      } 
        
  /***************************************************************
    Function: col_equiv
    Description: 
    **************************************************************/
  private boolean col_equiv
    (
     int col1,
     int col2
     )
      {
        int n;
        int i;
        CDTrans dtrans;

        n = m_spec.m_dtrans_vector.size();
        for (i = 0; i < n; ++i)
          {
            dtrans = (CDTrans) m_spec.m_dtrans_vector.elementAt(i);
            if (dtrans.m_dtrans[col1] != dtrans.m_dtrans[col2]) 
              {
                return false;
              }
          }
        
        return true;
      }

  /***************************************************************
    Function: row_equiv
    Description: 
    **************************************************************/
  private boolean row_equiv
    (
     int row1,
     int row2
     )
      {
        int i;
        CDTrans dtrans1;
        CDTrans dtrans2;

        dtrans1 = (CDTrans) m_spec.m_dtrans_vector.elementAt(row1);
        dtrans2 = (CDTrans) m_spec.m_dtrans_vector.elementAt(row2);
        
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (dtrans1.m_dtrans[i] != dtrans2.m_dtrans[i]) 
              {
                return false;
              }
          }
        
        return true;
      }

  /***************************************************************
    Function: reduce
    Description: 
    **************************************************************/
  private void reduce
    (
     )
      {
        int i;
        int j;
        int k;
        int nrows;
        int reduced_ncols;
        int reduced_nrows;
        BitSet set;
        CDTrans dtrans;
        int size;

        set = new BitSet();
        
        /* Save accept nodes and anchor entries. */
        size = m_spec.m_dtrans_vector.size();
        m_spec.m_anchor_array = new int[size];
        m_spec.m_accept_vector = new Vector();
        for (i = 0; i < size; ++i)
          {
            dtrans = (CDTrans) m_spec.m_dtrans_vector.elementAt(i);
            m_spec.m_accept_vector.addElement(dtrans.m_accept);
            m_spec.m_anchor_array[i] = dtrans.m_anchor;
            dtrans.m_accept = null;
          }
        
        /* Allocate column map. */
        m_spec.m_col_map = new int[m_spec.m_dtrans_ncols];
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            m_spec.m_col_map[i] = -1;
          }

        /* Process columns for reduction. */
        for (reduced_ncols = 0; ; ++reduced_ncols)
          {
            if (true == CUtility.DEBUG)
              {
                for (i = 0; i < reduced_ncols; ++i)
                  {
                    CUtility.assert(-1 != m_spec.m_col_map[i]);
                  }
              }

            for (i = reduced_ncols; i < m_spec.m_dtrans_ncols; ++i)
              {
                if (-1 == m_spec.m_col_map[i])
                  {
                    break;
                  }
              }

            if (i >= m_spec.m_dtrans_ncols)
              {
                break;
              }

            if (true == CUtility.DEBUG)
              {
                CUtility.assert(false == set.get(i));
                CUtility.assert(-1 == m_spec.m_col_map[i]);
              }

            set.set(i);
            
            m_spec.m_col_map[i] = reduced_ncols;
            
            /* UNDONE: Optimize by doing all comparisons in one batch. */
            for (j = i + 1; j < m_spec.m_dtrans_ncols; ++j)
              {
                if (-1 == m_spec.m_col_map[j] && true == col_equiv(i,j))
                  {
                    m_spec.m_col_map[j] = reduced_ncols;
                  }
              }
          }

        /* Reduce columns. */
        k = 0;
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (true == set.get(i))
              {
                ++k;

                set.clear(i);
                
                j = m_spec.m_col_map[i];
                
                if (true == CUtility.DEBUG)
                  {
                    CUtility.assert(j <= i);
                  }
                
                if (j == i)
                  {
                    continue;
                  }
                
                col_copy(j,i);
              }
          }
        m_spec.m_dtrans_ncols = reduced_ncols;

        if (true == CUtility.DEBUG)
          {
            CUtility.assert(k == reduced_ncols);
          }

        /* Allocate row map. */
        nrows = m_spec.m_dtrans_vector.size();
        m_spec.m_row_map = new int[nrows];
        for (i = 0; i < nrows; ++i)
          {
            m_spec.m_row_map[i] = -1;
          }

        /* Process rows to reduce. */
        for (reduced_nrows = 0; ; ++reduced_nrows)
          {
            if (true == CUtility.DEBUG)
              {
                for (i = 0; i < reduced_nrows; ++i)
                  {
                    CUtility.assert(-1 != m_spec.m_row_map[i]);
                  }
              }

            for (i = reduced_nrows; i < nrows; ++i)
              {
                if (-1 == m_spec.m_row_map[i])
                  {
                    break;
                  }
              }

            if (i >= nrows)
              {
                break;
              }

            if (true == CUtility.DEBUG)
              {
                CUtility.assert(false == set.get(i));
                CUtility.assert(-1 == m_spec.m_row_map[i]);
              }

            set.set(i);

            m_spec.m_row_map[i] = reduced_nrows;
            
            /* UNDONE: Optimize by doing all comparisons in one batch. */
            for (j = i + 1; j < nrows; ++j)
              {
                if (-1 == m_spec.m_row_map[j] && true == row_equiv(i,j))
                  {
                    m_spec.m_row_map[j] = reduced_nrows;
                  }
              }
          }

        /* Reduce rows. */
        k = 0;
        for (i = 0; i < nrows; ++i)
          {
            if (true == set.get(i))
              {
                ++k;

                set.clear(i);
                
                j = m_spec.m_row_map[i];
                
                if (true == CUtility.DEBUG)
                  {
                    CUtility.assert(j <= i);
                  }
                
                if (j == i)
                  {
                    continue;
                  }
                
                row_copy(j,i);
              }
          }
        m_spec.m_dtrans_vector.setSize(reduced_nrows);

        if (CUtility.DEBUG)
          {
            /*System.out.print("k = " + k + "\nreduced_nrows = " + reduced_nrows + "\n");*/
            CUtility.assert(k == reduced_nrows);
          }
      }

  /***************************************************************
    Function: fix_dtrans
    Description: Updates CDTrans table after minimization 
    using groups, removing redundant transition table states.
    **************************************************************/
  private void fix_dtrans
    (
     )
      {
        Vector new_vector;
        int i;
        int size;
        Vector dtrans_group;
        CDTrans first;
        int c;

        new_vector = new Vector();

        size = m_spec.m_state_dtrans.length;
        for (i = 0; i < size; ++i)
          {
            if (CDTrans.F != m_spec.m_state_dtrans[i])
              {
                m_spec.m_state_dtrans[i] = m_ingroup[m_spec.m_state_dtrans[i]];
              }
          }

        size = m_group.size();
        for (i = 0; i < size; ++i)
          {
            dtrans_group = (Vector) m_group.elementAt(i);
            first = (CDTrans) dtrans_group.elementAt(0);
            new_vector.addElement(first);

            for (c = 0; c < m_spec.m_dtrans_ncols; ++c)
              {
                if (CDTrans.F != first.m_dtrans[c])
                  {
                    first.m_dtrans[c] = m_ingroup[first.m_dtrans[c]];
                  }
              }
          }

        m_group = null;
        m_spec.m_dtrans_vector = new_vector;
      }

  /***************************************************************
    Function: minimize
    Description: Removes redundant transition table states.
    **************************************************************/
  private void minimize
    (
     )
      {
        Vector dtrans_group;
        Vector new_group;
        int i;
        int j;
        int old_group_count;
        int group_count;
        CDTrans next;
        CDTrans first;
        int goto_first;
        int goto_next;
        int c;
        int group_size;
        boolean added;

        init_groups();

        group_count = m_group.size();
        old_group_count = group_count - 1;

        while (old_group_count != group_count)
          {
            old_group_count = group_count;

            if (CUtility.DEBUG)
              {
                CUtility.assert(m_group.size() == group_count);
              }

            for (i = 0; i < group_count; ++i)
              {
                dtrans_group = (Vector) m_group.elementAt(i);

                group_size = dtrans_group.size();
                if (group_size <= 1)
                  {
                    continue;
                  }

                new_group = new Vector();
                added = false;
                
                first = (CDTrans) dtrans_group.elementAt(0);
                for (j = 1; j < group_size; ++j)
                  {
                    next = (CDTrans) dtrans_group.elementAt(j);

                    for (c = 0; c < m_spec.m_dtrans_ncols; ++c)
                      {
                        goto_first = first.m_dtrans[c];
                        goto_next = next.m_dtrans[c];

                        if (goto_first != goto_next
                            && (goto_first == CDTrans.F
                                || goto_next == CDTrans.F
                                || m_ingroup[goto_next] != m_ingroup[goto_first]))
                          {
                            if (CUtility.DEBUG)
                              {
                                CUtility.assert(dtrans_group.elementAt(j) == next);
                              }
                            
                            dtrans_group.removeElementAt(j);
                            --j;
                            --group_size;
                            new_group.addElement(next);
                            if (false == added)
                              {
                                added = true;
                                ++group_count;
                                m_group.addElement(new_group);
                              }
                            m_ingroup[next.m_label] = m_group.size() - 1;

                            if (CUtility.DEBUG)
                              {
                                CUtility.assert(m_group.contains(new_group)
                                                == true);
                                CUtility.assert(m_group.contains(dtrans_group)
                                                == true);
                                CUtility.assert(dtrans_group.contains(first)
                                                == true);
                                CUtility.assert(dtrans_group.contains(next)
                                                == false);
                                CUtility.assert(new_group.contains(first)
                                                == false);
                                CUtility.assert(new_group.contains(next)
                                                == true);
                                CUtility.assert(dtrans_group.size() == group_size);
                                CUtility.assert(i == m_ingroup[first.m_label]);
                                CUtility.assert((m_group.size() - 1) 
                                                == m_ingroup[next.m_label]);
                              }

                            break;
                          }
                      }
                  }
              }
          }

        System.out.println(m_group.size() + " states after removal of redundant states.");

        if (true == m_spec.m_verbose
            && true == CUtility.OLD_DUMP_DEBUG)
          {
            System.out.println("\nStates grouped as follows after minimization");
            pgroups();
          }

        fix_dtrans();
      }

  /***************************************************************
    Function: init_groups
    Description:
    **************************************************************/
  private void init_groups
    (
     )
      {
        int i;
        int j;
        int group_count;
        int size;
        CAccept accept;
        CDTrans dtrans;
        Vector dtrans_group;
        CDTrans first;
        boolean group_found;

        m_group = new Vector();
        group_count = 0;
        
        size = m_spec.m_dtrans_vector.size();
        m_ingroup = new int[size];
        
        for (i = 0; i < size; ++i)
          {
            group_found = false;
            dtrans = (CDTrans) m_spec.m_dtrans_vector.elementAt(i);

            if (CUtility.DEBUG)
              {
                CUtility.assert(i == dtrans.m_label);
                CUtility.assert(false == group_found);
                CUtility.assert(group_count == m_group.size());
              }
            
            for (j = 0; j < group_count; ++j)
              {
                dtrans_group = (Vector) m_group.elementAt(j);
                
                if (CUtility.DEBUG)
                  {
                    CUtility.assert(false == group_found);
                    CUtility.assert(0 < dtrans_group.size());
                  }

                first = (CDTrans) dtrans_group.elementAt(0);
                
                if (CUtility.SLOW_DEBUG)
                  {
                    CDTrans check;
                    int k;
                    int s;

                    s = dtrans_group.size();
                    CUtility.assert(0 < s);

                    for (k = 1; k < s; ++k)
                      {
                        check = (CDTrans) dtrans_group.elementAt(k);
                        CUtility.assert(check.m_accept == first.m_accept);
                      }
                  }

                if (first.m_accept == dtrans.m_accept)
                  {
                    dtrans_group.addElement(dtrans);
                    m_ingroup[i] = j;
                    group_found = true;
                    
                    if (CUtility.DEBUG)
                      {
                        CUtility.assert(j == m_ingroup[dtrans.m_label]);
                      }

                    break;
                  }
              }
            
            if (false == group_found)
              {
                dtrans_group = new Vector();
                dtrans_group.addElement(dtrans);
                m_ingroup[i] = m_group.size();
                m_group.addElement(dtrans_group);
                ++group_count;
              }
          }
        
        if (true == m_spec.m_verbose
            && true == CUtility.OLD_DUMP_DEBUG)
          {
            System.out.println("Initial grouping:");
            pgroups();
            System.out.println("");
          }
      }

  /***************************************************************
    Function: pset
    **************************************************************/
  private void pset
    (
     Vector dtrans_group
     )
      {
        int i;
        int size;
        CDTrans dtrans;

        size = dtrans_group.size();
        for (i = 0; i < size; ++i)
          {
            dtrans = (CDTrans) dtrans_group.elementAt(i);
            System.out.print(dtrans.m_label + " ");
          }
      }
  
  /***************************************************************
    Function: pgroups
    **************************************************************/
  private void pgroups
    (
     )
      {
        int i;
        int dtrans_size;
        int group_size;
        
        group_size = m_group.size();
        for (i = 0; i < group_size; ++i)
          {
            System.out.print("\tGroup " + i + " {");
            pset((Vector) m_group.elementAt(i));
            System.out.println("}\n");
          }
        
        System.out.println("");
        dtrans_size = m_spec.m_dtrans_vector.size();
        for (i = 0; i < dtrans_size; ++i)
          {
            System.out.println("\tstate " + i 
                               + " is in group " 
                               + m_ingroup[i]);
          }
      }
}

/***************************************************************
  Class: CNfa2Dfa
 **************************************************************/
final class CNfa2Dfa //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private CSpec m_spec;
  private int m_unmarked_dfa;
  private CLexGen m_lexGen;

  /***************************************************************
    Constants
    **************************************************************/
  private static final int NOT_IN_DSTATES = -1;

  /***************************************************************
    Function: CNfa2Dfa
    **************************************************************/
  CNfa2Dfa
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: set 
    Description: 
    **************************************************************/
  private void set
    (
     CLexGen lexGen,
     CSpec spec
     )
      {
        m_lexGen = lexGen;
        m_spec = spec;
        m_unmarked_dfa = 0;
      }

  /***************************************************************
    Function: reset 
    Description: 
    **************************************************************/
  private void reset
    (
     )
      {
        m_lexGen = null;
        m_spec = null;
        m_unmarked_dfa = 0;
      }

  /***************************************************************
    Function: make_dfa
    Description: High-level access function to module.
    **************************************************************/
  void make_dfa
    (
     CLexGen lexGen,
     CSpec spec
     )
      {
        int i;

        reset();
        set(lexGen,spec);

        make_dtrans();
        free_nfa_states();

        if (true == m_spec.m_verbose && true == CUtility.OLD_DUMP_DEBUG)
          {
            System.out.println(m_spec.m_dfa_states.size()
                               + " DFA states in original machine.");
          }

        free_dfa_states();
      }     

   /***************************************************************
    Function: make_dtrans
    Description: Creates uncompressed CDTrans transition table.
    **************************************************************/
  private void make_dtrans
    (
     )
     /* throws java.lang.CloneNotSupportedException*/
      {
        CDfa next;
        CDfa dfa;
        CBunch bunch;
        int i;
        int nextstate;
        int size;
        CDTrans dtrans;
        CNfa nfa;
        int istate;
        int nstates;
        
        System.out.print("Working on DFA states.");

        /* Reference passing type and initializations. */
        bunch = new CBunch();
        m_unmarked_dfa = 0;

        /* Allocate mapping array. */
        nstates = m_spec.m_state_rules.length;
        m_spec.m_state_dtrans = new int[nstates];

        for (istate = 0; nstates > istate; ++istate)
          {
            if (0 == m_spec.m_state_rules[istate].size())
              {
                m_spec.m_state_dtrans[istate] = CDTrans.F;
                continue;
              }
                
            /* Create start state and initialize fields. */
            bunch.m_nfa_set = (Vector) m_spec.m_state_rules[istate].clone();
            sortStates(bunch.m_nfa_set);
            
            bunch.m_nfa_bit = new BitSet();
            
            /* Initialize bit set. */
            size = bunch.m_nfa_set.size();
            for (i = 0; size > i; ++i)
              {
                nfa = (CNfa) bunch.m_nfa_set.elementAt(i);
                bunch.m_nfa_bit.set(nfa.m_label);
              }
            
            bunch.m_accept = null;
            bunch.m_anchor = CSpec.NONE;
            bunch.m_accept_index = CUtility.INT_MAX;
            
            e_closure(bunch);
            add_to_dstates(bunch);
            
            m_spec.m_state_dtrans[istate] = m_spec.m_dtrans_vector.size();

            /* Main loop of CDTrans creation. */
            while (null != (dfa = get_unmarked()))
              {
                System.out.print(".");
                System.out.flush();
                
                if (CUtility.DEBUG)
                  {
                    CUtility.assert(false == dfa.m_mark);
                  }

                /* Get first unmarked node, then mark it. */
                dfa.m_mark = true;
                
                /* Allocate new CDTrans, then initialize fields. */
                dtrans = new CDTrans(m_spec.m_dtrans_vector.size(),m_spec);
                dtrans.m_accept = dfa.m_accept;
                dtrans.m_anchor = dfa.m_anchor;
                
                /* Set CDTrans array for each character transition. */
                for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
                  {
                    if (CUtility.DEBUG)
                      {
                        CUtility.assert(0 <= i);
                        CUtility.assert(m_spec.m_dtrans_ncols > i);
                      }
                    
                    /* Create new dfa set by attempting character transition. */
                    move(dfa.m_nfa_set,dfa.m_nfa_bit,i,bunch);
                    if (null != bunch.m_nfa_set)
                      {
                        e_closure(bunch);
                      }
                    
                    if (CUtility.DEBUG)
                      {
                        CUtility.assert((null == bunch.m_nfa_set 
                                         && null == bunch.m_nfa_bit)
                                        || (null != bunch.m_nfa_set 
                                            && null != bunch.m_nfa_bit));
                      }
                    
                    /* Create new state or set state to empty. */
                    if (null == bunch.m_nfa_set)
                      {
                        nextstate = CDTrans.F;
                      }
                    else 
                      {
                        nextstate = in_dstates(bunch);
                        
                        if (NOT_IN_DSTATES == nextstate)
                          {
                            nextstate = add_to_dstates(bunch);
                          }
                      }
                    
                    if (CUtility.DEBUG)
                      {
                        CUtility.assert(nextstate < m_spec.m_dfa_states.size());
                      }
                    
                    dtrans.m_dtrans[i] = nextstate;
                  }
                
                if (CUtility.DEBUG)
                  {
                    CUtility.assert(m_spec.m_dtrans_vector.size() == dfa.m_label);
                  }
                
                m_spec.m_dtrans_vector.addElement(dtrans);
              }
          }

        System.out.println("");
      }

  /***************************************************************
    Function: free_dfa_states
    **************************************************************/  
  private void free_dfa_states
    (
     )
      {
        m_spec.m_dfa_states = null;
        m_spec.m_dfa_sets = null;
      }

  /***************************************************************
    Function: free_nfa_states
    **************************************************************/  
  private void free_nfa_states
    (
     )
      {
        /* UNDONE: Remove references to nfas from within dfas. */
        /* UNDONE: Don't free CAccepts. */

        m_spec.m_nfa_states = null;
        m_spec.m_nfa_start = null;
        m_spec.m_state_rules = null;
      }

  /***************************************************************
    Function: e_closure
    Description: Alters and returns input set.
    **************************************************************/
  private void e_closure
    (
     CBunch bunch
     )
      {
        Stack nfa_stack;
        int size;
        int i;
        CNfa state;

        /* Debug checks. */
        if (CUtility.DEBUG)
          {
            CUtility.assert(null != bunch);
            CUtility.assert(null != bunch.m_nfa_set);
            CUtility.assert(null != bunch.m_nfa_bit);
          }

        bunch.m_accept = null;
        bunch.m_anchor = CSpec.NONE;
        bunch.m_accept_index = CUtility.INT_MAX;
        
        /* Create initial stack. */
        nfa_stack = new Stack();
        size = bunch.m_nfa_set.size();
        for (i = 0; i < size; ++i)
          {
            state = (CNfa) bunch.m_nfa_set.elementAt(i);
            
            if (CUtility.DEBUG)
              {
                CUtility.assert(true == bunch.m_nfa_bit.get(state.m_label));
              }

            nfa_stack.push(state);
          }

        /* Main loop. */
        while (false == nfa_stack.empty())
          {
            state = (CNfa) nfa_stack.pop();
            
            if (CUtility.OLD_DUMP_DEBUG)
              {
                if (null != state.m_accept)
                  {
                    System.out.println("Looking at accepting state " + state.m_label
                                       + " with <"
                                       + (new String(state.m_accept.m_action,0,
                                                     state.m_accept.m_action_read))
                                       + ">");
                  }
              }

            if (null != state.m_accept 
                && state.m_label < bunch.m_accept_index)
              {
                bunch.m_accept_index = state.m_label;
                bunch.m_accept = state.m_accept;
                bunch.m_anchor = state.m_anchor;

                if (CUtility.OLD_DUMP_DEBUG)
                  {
                    System.out.println("Found accepting state " + state.m_label
                                       + " with <"
                                       + (new String(state.m_accept.m_action,0,
                                                     state.m_accept.m_action_read))
                                       + ">");
                  }

                if (CUtility.DEBUG)
                  {
                    CUtility.assert(null != bunch.m_accept);
                    CUtility.assert(CSpec.NONE == bunch.m_anchor
                                    || 0 != (bunch.m_anchor & CSpec.END)
                                    || 0 != (bunch.m_anchor & CSpec.START));
                  }
              }

            if (CNfa.EPSILON == state.m_edge)
              {
                if (null != state.m_next)
                  {
                    if (false == bunch.m_nfa_set.contains(state.m_next))
                      {
                        if (CUtility.DEBUG)
                          {
                            CUtility.assert(false == bunch.m_nfa_bit.get(state.m_next.m_label));
                          }
                        
                        bunch.m_nfa_bit.set(state.m_next.m_label);
                        bunch.m_nfa_set.addElement(state.m_next);
                        nfa_stack.push(state.m_next);
                      }
                  }

                if (null != state.m_next2)
                  {
                    if (false == bunch.m_nfa_set.contains(state.m_next2))
                      {
                        if (CUtility.DEBUG)
                          {
                            CUtility.assert(false == bunch.m_nfa_bit.get(state.m_next2.m_label));
                          }
                        
                        bunch.m_nfa_bit.set(state.m_next2.m_label);
                        bunch.m_nfa_set.addElement(state.m_next2);
                        nfa_stack.push(state.m_next2);
                      }
                  }
              }
          }

        if (null != bunch.m_nfa_set)
          {
            sortStates(bunch.m_nfa_set);
          }

        return;
      }

  /***************************************************************
    Function: move
    Description: Returns null if resulting NFA set is empty.
    **************************************************************/
  void move
    (
     Vector nfa_set,
     BitSet nfa_bit,
     int b,
     CBunch bunch
     )
      {
        int size;
        int index;
        CNfa state;
        
        bunch.m_nfa_set = null;
        bunch.m_nfa_bit = null;

        size = nfa_set.size();
        for (index = 0; index < size; ++index)
          {
            state = (CNfa) nfa_set.elementAt(index);
            
            if (b == state.m_edge
                || (CNfa.CCL == state.m_edge
                    && true == state.m_set.contains(b)))
              {
                if (null == bunch.m_nfa_set)
                  {
                    if (CUtility.DEBUG)
                      {
                        CUtility.assert(null == bunch.m_nfa_bit);
                      }
                    
                    bunch.m_nfa_set = new Vector();
                    bunch.m_nfa_bit = new BitSet(m_spec.m_nfa_states.size());
                    /*bunch.m_nfa_bit = new BitSet();*/
                  }

                bunch.m_nfa_set.addElement(state.m_next);
                /*System.out.println("Size of bitset: " + bunch.m_nfa_bit.size());
                System.out.println("Reference index: " + state.m_next.m_label);
                System.out.flush();*/
                bunch.m_nfa_bit.set(state.m_next.m_label);
              }
          }
        
        if (null != bunch.m_nfa_set)
          {
            if (CUtility.DEBUG)
              {
                CUtility.assert(null != bunch.m_nfa_bit);
              }
            
            sortStates(bunch.m_nfa_set);
          }

        return;
      }

  /***************************************************************
    Function: sortStates
    **************************************************************/
  private void sortStates
    (
     Vector nfa_set
     )
      {
        CNfa elem;
        int begin;
        int size;
        int index;
        int value;
        int smallest_index;
        int smallest_value;
        CNfa begin_elem;

        size = nfa_set.size();
        for (begin = 0; begin < size; ++begin)
          {
            elem = (CNfa) nfa_set.elementAt(begin);
            smallest_value = elem.m_label;
            smallest_index = begin;

            for (index = begin + 1; index < size; ++index)
              {
                elem = (CNfa) nfa_set.elementAt(index);
                value = elem.m_label;

                if (value < smallest_value)
                  {
                    smallest_index = index;
                    smallest_value = value;
                  }
              }

            begin_elem = (CNfa) nfa_set.elementAt(begin);
            elem = (CNfa) nfa_set.elementAt(smallest_index);
            nfa_set.setElementAt(elem,begin);
            nfa_set.setElementAt(begin_elem,smallest_index);
          }

        if (true == CUtility.OLD_DEBUG)
          {
            System.out.print("NFA vector indices: ");  
            
            for (index = 0; index < size; ++index)
              {
                elem = (CNfa) nfa_set.elementAt(index);
                System.out.print(elem.m_label + " ");
              }
            System.out.print("\n");
          }     

        return;
      }

  /***************************************************************
    Function: get_unmarked
    Description: Returns next unmarked DFA state.
    **************************************************************/
  private CDfa get_unmarked
    (
     )
      {
        int size;
        CDfa dfa;

        size = m_spec.m_dfa_states.size();
        while (m_unmarked_dfa < size)
          {
            dfa = (CDfa) m_spec.m_dfa_states.elementAt(m_unmarked_dfa);

            if (false == dfa.m_mark)
              {
                if (true == CUtility.OLD_DUMP_DEBUG)
                  {
                    System.out.print("*");
                    System.out.flush();
                  }

                if (true == m_spec.m_verbose && true == CUtility.OLD_DUMP_DEBUG)
                  {
                    System.out.println("---------------");
                    System.out.print("working on DFA state " 
                                     + m_unmarked_dfa
                                     + " = NFA states: ");
                    m_lexGen.print_set(dfa.m_nfa_set);
                    System.out.print("\n");
                  }

                return dfa;
              }

            ++m_unmarked_dfa;
          }

        return null;
      }
  
  /***************************************************************
    function: add_to_dstates
    Description: Takes as input a CBunch with details of
    a dfa state that needs to be created.
    1) Allocates a new dfa state and saves it in 
    the appropriate CSpec vector.
    2) Initializes the fields of the dfa state
    with the information in the CBunch.
    3) Returns index of new dfa.
    **************************************************************/
  private int add_to_dstates
    (
     CBunch bunch
     )
      {
        CDfa dfa;
        
        if (CUtility.DEBUG)
          {
            CUtility.assert(null != bunch.m_nfa_set);
            CUtility.assert(null != bunch.m_nfa_bit);
            CUtility.assert(null != bunch.m_accept 
                            || CSpec.NONE == bunch.m_anchor);
          }

        /* Allocate, passing CSpec so dfa label can be set. */
        dfa = CAlloc.newCDfa(m_spec);
        
        /* Initialize fields, including the mark field. */
        dfa.m_nfa_set = (Vector) bunch.m_nfa_set.clone();
        dfa.m_nfa_bit = (BitSet) bunch.m_nfa_bit.clone();
        dfa.m_accept = bunch.m_accept;
        dfa.m_anchor = bunch.m_anchor;
        dfa.m_mark = false;
        
        /* Register dfa state using BitSet in CSpec Hashtable. */
        m_spec.m_dfa_sets.put(dfa.m_nfa_bit,dfa);
        /*registerCDfa(dfa);*/

        if (CUtility.OLD_DUMP_DEBUG)
          {
            System.out.print("Registering set : ");
            m_lexGen.print_set(dfa.m_nfa_set);
            System.out.println("");
          }

        return dfa.m_label;
      }

  /***************************************************************
    Function: in_dstates
    **************************************************************/
  private int in_dstates
    (
     CBunch bunch
     )
      {
        CDfa dfa;
        
        if (CUtility.OLD_DEBUG)
          {
            System.out.print("Looking for set : ");
            m_lexGen.print_set(bunch.m_nfa_set);
          }

        dfa = (CDfa) m_spec.m_dfa_sets.get(bunch.m_nfa_bit);

        if (null != dfa)
          {
            if (CUtility.OLD_DUMP_DEBUG)
              {
                System.out.println(" FOUND!");
              }
            
            return dfa.m_label;
          }

        if (CUtility.OLD_DUMP_DEBUG)
          {
            System.out.println(" NOT FOUND!");
          }
        return NOT_IN_DSTATES;
      }

}

/***************************************************************
  Class: CAlloc
  **************************************************************/
final class CAlloc //**NS**
{
  /***************************************************************
    Function: newCDfa
    **************************************************************/
  static CDfa newCDfa
    (
     CSpec spec
     )
      {
        CDfa dfa;
        
        dfa = new CDfa(spec.m_dfa_states.size());
        spec.m_dfa_states.addElement(dfa);

        return dfa;
      }

  /***************************************************************
    Function: newCNfaPair
    Description: 
    **************************************************************/
  static CNfaPair newCNfaPair
    (
     )
      {
        CNfaPair pair = new CNfaPair();
        
        return pair;
      }

  /***************************************************************
    Function: newCNfa
    Description: 
    **************************************************************/
  static CNfa newCNfa
    (
     CSpec spec
     )
      {
        CNfa p;

        /* UNDONE: Buffer this? */

        p = new CNfa();
        
        /*p.m_label = spec.m_nfa_states.size();*/
        spec.m_nfa_states.addElement(p);
        p.m_edge = CNfa.EPSILON;
        
        return p;
      }
}

/***************************************************************
  Class: JavaLex
  Description: Top-level lexical analyzer generator function.
 **************************************************************/
public final class JavaLex //**NS**
{
  /***************************************************************
    Function: main
    **************************************************************/
  public static void main
    (
     String arg[]
     )
    throws java.io.IOException
      {
        CLexGen lg;

        if (arg.length < 1)
          {
            System.out.println("Usage: JavaLex <filename>");
            return;
          }

        lg = new CLexGen(arg[0]);
        lg.generate();

        spec.benchmarks._202_jess.Main.main(null);
      }
}    

/***************************************************************
  Class: CDTrans
  **************************************************************/
final class CDTrans //**NS**
{
  /*************************************************************
    Member Variables
    ***********************************************************/
  int m_dtrans[];
  CAccept m_accept;
  int m_anchor;
  int m_label;

  /*************************************************************
    Constants
    ***********************************************************/
  static final int F = -1;

  /*************************************************************
    Function: CTrans
    ***********************************************************/
  CDTrans
    (
     int label,
     CSpec spec
     )
      {
        m_dtrans = new int[spec.m_dtrans_ncols];
        m_accept = null;
        m_anchor = CSpec.NONE;
        m_label = label;
      }
}

/***************************************************************
  Class: CDfa
  **************************************************************/
final class CDfa //**NS**
{
  /***************************************************************
    Member Variables
    ***********************************************************/
  int m_group;
  boolean m_mark;
  CAccept m_accept;
  int m_anchor;
  Vector m_nfa_set;
  BitSet m_nfa_bit;
  int m_label;

  /***************************************************************
    Function: CDfa
    **************************************************************/
  CDfa
    (
     int label
     )
      {
        m_group = 0;
        m_mark = false;

        m_accept = null;
        m_anchor = CSpec.NONE;

        m_nfa_set = null;
        m_nfa_bit = null;

        m_label = label;
      }
}

/***************************************************************
  Class: CAccept
 **************************************************************/
final class CAccept //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  char m_action[];
  int m_action_read;
  int m_line_number;

  /***************************************************************
    Function: CAccept
    **************************************************************/
  CAccept
    (
     char action[],
     int action_read,
     int line_number
     )
      {
        int elem;

        m_action_read = action_read;

        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = action[elem];
          }

        m_line_number = line_number;
      }

  /***************************************************************
    Function: CAccept
    **************************************************************/
  CAccept
    (
     CAccept accept
     )
      {
        int elem;

        m_action_read = accept.m_action_read;
        
        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = accept.m_action[elem];
          }

        m_line_number = accept.m_line_number;
      }

  /***************************************************************
    Function: mimic
    **************************************************************/
  void mimic
    (
     CAccept accept
     )
      {
        int elem;

        m_action_read = accept.m_action_read;
        
        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = accept.m_action[elem];
          }
      }
}

/***************************************************************
  Class: CAcceptAnchor
  **************************************************************/
final class CAcceptAnchor //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  CAccept m_accept;
  int m_anchor;

  /***************************************************************
    Function: CAcceptAnchor
    **************************************************************/
  CAcceptAnchor
    (
     )
      {
        m_accept = null;
        m_anchor = CSpec.NONE;
      }
}

/***************************************************************
  Class: CNfaPair
  **************************************************************/
final class CNfaPair //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  CNfa m_start;
  CNfa m_end;
  
  /***************************************************************
    Function: CNfaPair
    **************************************************************/
  CNfaPair
    (
     )
      {
        m_start = null;
        m_end = null;
      }
}

/***************************************************************
  Class: CInput
  Description: 
 **************************************************************/
final class CInput //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private InputStream m_input; /* Java-Lez specification file. */

  private byte m_buffer[]; /* Input buffer. */
  private int m_buffer_read; /* Number of bytes read into input buffer. */
  private int m_buffer_index; /* Current index into input buffer. */

  boolean m_eof_reached; /* Whether EOF has been encountered. */
  boolean m_pushback_line; 

  char m_line[]; /* Line buffer. */
  int m_line_read; /* Number of bytes read into line buffer. */
  int m_line_index; /* Current index into line buffer. */

  int m_line_number; /* Current line number. */

  /***************************************************************
    Constants
    **************************************************************/
  private static final int BUFFER_SIZE = 1024;
  static final boolean EOF = true;
  static final boolean NOT_EOF = false;
  
  /***************************************************************
    Function: CInput
    Description: 
    **************************************************************/
  CInput
    (
     InputStream input
     )
      {
        if (CUtility.DEBUG)
          {
            CUtility.assert(null != input);
          }

        /* Initialize input stream. */
        m_input = input;

        /* Initialize buffers and index counters. */
        m_buffer = new byte[BUFFER_SIZE];
        m_buffer_read = 0;
        m_buffer_index = 0;

        m_line = new char[BUFFER_SIZE];
        m_line_read = 0;
        m_line_index = 0;

        /* Initialize state variables. */
        m_eof_reached = false;
        m_line_number = 0;
        m_pushback_line = false;
      }

  /***************************************************************
    Function: getLine
    Description: Returns true on EOF, false otherwise.
    Guarantees not to return a blank line, or a line
    of zero length.
    **************************************************************/
  boolean getLine 
    (
     )
      throws java.io.IOException
      {
        int elem;
        
        /* Has EOF already been reached? */
        if (true == m_eof_reached)
          {
            if (CUtility.OLD_DEBUG)
              {
                System.out.print("Line 1: ");
                System.out.print(new String(m_line,0,
                                            m_line_read));
              }

            return true;
          }
        
        /* Pushback current line? */
        if (true == m_pushback_line)
          {
            m_pushback_line = false;

            /* Check for empty line. */
            for (elem = 0; elem < m_line_read; ++elem)
              {
                if (false == CUtility.isspace(m_line[elem]))
                  {
                    break;
                  }
              }

            /* Nonempty? */
            if (elem < m_line_read)
              {
                m_line_index = 0;
                return false;
              }

            if (CUtility.OLD_DEBUG)
              {
                System.out.print("Line 2: ");
                System.out.print(new String(m_line,0,
                                            m_line_read));
              }
          }

        while (true)
          {
            /* Refill buffer? */
            if (m_buffer_index >= m_buffer_read)
              {
                m_buffer_read = m_input.read(m_buffer);
                if (-1 == m_buffer_read)
                  {
                    m_eof_reached = true;

                    if (CUtility.OLD_DEBUG)
                      {
                        System.out.print("Line 3: ");
                        System.out.print(new String(m_line,0,
                                                    m_line_read));
                      }
                    
                    m_line_index = 0;
                    return true;
                  }
                m_buffer_index = 0;
              }
            
            m_line_read = 0;
            while ((byte) '\n' != m_buffer[m_buffer_index])
              {
                m_line[m_line_read] = (char) m_buffer[m_buffer_index];

                ++m_buffer_index;
                
                /* Refill buffer? */
                if (m_buffer_index >= m_buffer_read)
                  {
                    m_buffer_read = m_input.read(m_buffer);
                    if (-1 == m_buffer_read)
                      {
                        m_eof_reached = true;

                        /* Check for empty lines and discard them. */
                        elem = 0;
                        while (CUtility.isspace(m_line[elem])) 
                          {
                            ++elem;
                            if (elem == m_line_read)
                              {
                                break;
                              }
                          }
                        
                        if (elem < m_line_read)
                          {                       
                            if (CUtility.OLD_DEBUG)
                              {
                                System.out.print("Line 4:");
                                System.out.print(new String(m_line,
                                                            0,
                                                            m_line_read));
                              }
                            
                              
                            m_line_index = 0;
                            return false;
                          }

                        if (CUtility.OLD_DEBUG)
                          {
                            System.out.print("Line <e>:");
                            System.out.print(new String(m_line,0,
                                                    m_line_read));
                          }

                        m_line_index = 0;
                        return true;
                      }

                    m_buffer_index = 0;
                  }

                ++m_line_read;

                /* Resize line buffer? */
                if (m_line_read >= m_line.length)
                  {
                    m_line = CUtility.doubleSize(m_line);
                  }
              }
            /* Save newline in buffer. */
            m_line[m_line_read] = (char) m_buffer[m_buffer_index];
            ++m_line_read;
            ++m_buffer_index;
            ++m_line_number;
            
            /* Check for empty lines and discard them. */
            elem = 0;
            while (CUtility.isspace(m_line[elem])) 
              {
                ++elem;
                if (elem == m_line_read)
                  {
                    break;
                  }
              }
            
            if (elem < m_line_read)
              {
                break;
              }
          }

        if (CUtility.OLD_DEBUG)
          {
            System.out.print("Line <f>:");
            System.out.print(new String(m_line,0,m_line_read));
          }

        m_line_index = 0;
        return false;
      }
}

/********************************************************
  Class: Utility
  *******************************************************/
final class CUtility  //**NS**
{
  /********************************************************
    Constants
    *******************************************************/
  static final boolean DEBUG = true;
  static final boolean SLOW_DEBUG = true;
  static final boolean DUMP_DEBUG = true;
  /*static final boolean DEBUG = false;
  static final boolean SLOW_DEBUG = false;
  static final boolean DUMP_DEBUG = false;*/
  
  static final boolean DESCENT_DEBUG = false;
  static final boolean OLD_DEBUG = false;
  static final boolean OLD_DUMP_DEBUG = false;
  static final boolean FOODEBUG = false;
  static final boolean DO_DEBUG = false;      
  
  /********************************************************
    Constants: Integer Bounds
    *******************************************************/
  static final int INT_MAX = 2147483647;

  /* UNDONE: What about other character values??? */
  static final int MAX_SEVEN_BIT = 127;
  static final int MAX_EIGHT_BIT = 256;

  /********************************************************
    Function: enter
    Description: Debugging routine.
    *******************************************************/
  static void enter
    (
     String descent,
     char lexeme,
     int token
     )
      {
        System.out.println("Entering " + descent 
                           + " [lexeme: " + lexeme 
                           + "] [token: " + token + "]");
      }

  /********************************************************
    Function: leave
    Description: Debugging routine.
    *******************************************************/
  static void leave
    (
     String descent,
     char lexeme,
     int token
     )
      {
        System.out.println("Leaving " + descent 
                           + " [lexeme:" + lexeme 
                           + "] [token:" + token + "]");
      }

  /********************************************************
    Function: assert
    Description: Debugging routine.
    *******************************************************/
  static void assert
    (
     boolean expr
     )
      {
        if (true == DEBUG && false == expr)
          {
            System.out.println("Assertion Failed");
            throw new Error("Assertion Failed.");
          }
      }

  /***************************************************************
    Function: doubleSize
    **************************************************************/
  static char[] doubleSize
    (
     char oldBuffer[]
     )
      {
        char newBuffer[] = new char[2 * oldBuffer.length];
        int elem;

        for (elem = 0; elem < oldBuffer.length; ++elem)
          {
            newBuffer[elem] = oldBuffer[elem];
          }

        return newBuffer;
      }

  /***************************************************************
    Function: doubleSize
    **************************************************************/
  static byte[] doubleSize
    (
     byte oldBuffer[]
     )
      {
        byte newBuffer[] = new byte[2 * oldBuffer.length];
        int elem;

        for (elem = 0; elem < oldBuffer.length; ++elem)
          {
            newBuffer[elem] = oldBuffer[elem];
          }

        return newBuffer;
      }

  /********************************************************
    Function: hex2bin
    *******************************************************/
  static char hex2bin
    (
     char c
     )
      {
        if ('0' <= c && '9' >= c)
          {
            return (char) (c - '0');
          }
        else if ('a' <= c && 'f' >= c)
          {
            return (char) (c - 'a' + 10);
          }         
        else if ('A' <= c && 'F' >= c)
          {
            return (char) (c - 'A' + 10);
          }
        
        CError.impos("Bad hexidecimal digit" + c);
        return 0;
      }

  /********************************************************
    Function: ishexdigit
    *******************************************************/
  static boolean ishexdigit
    (
     char c
     )
      {
        if (('0' <= c && '9' >= c)
            || ('a' <= c && 'f' >= c)
            || ('A' <= c && 'F' >= c))
          {
            return true;
          }

        return false;
      }

  /********************************************************
    Function: oct2bin
    *******************************************************/
  static char oct2bin
    (
     char c
     )
      {
        if ('0' <= c && '7' >= c)
          {
            return (char) (c - '0');
          }
        
        CError.impos("Bad octal digit " + c);
        return 0;
      }

  /********************************************************
    Function: isoctdigit
    *******************************************************/
  static boolean isoctdigit
    (
     char c
     )
      {
        if ('0' <= c && '7' >= c)
          {
            return true;
          }

        return false;
      }
        
  /********************************************************
    Function: isspace
    *******************************************************/
  static boolean isspace
    (
     char c
     )
      {
        if ('\b' == c 
            || '\t' == c
            || '\n' == c
            || '\f' == c
            || '\r' == c
            || ' ' == c)
          {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: isnewline
    *******************************************************/
  static boolean isnewline
    (
     char c
     )
      {
        if ('\n' == c
            || '\r' == c)
            {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: isalpha
    *******************************************************/
  static boolean isalpha
    (
     char c
     )
      {
        if (('a' <= c && 'z' >= c)
            || ('A' <= c && 'Z' >= c))
          {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: toupper
    *******************************************************/
  static char toupper
    (
     char c
     )
      {
        if (('a' <= c && 'z' >= c))
          {
            return (char) (c - 'a' + 'A');
          }

        return c;
      }

  /********************************************************
    Function: bytencmp
    Description: Compares up to n elements of 
    byte array a[] against byte array b[].
    The first byte comparison is made between 
    a[a_first] and b[b_first].  Comparisons continue
    until the null terminating byte '\0' is reached
    or until n bytes are compared.
    Return Value: Returns 0 if arrays are the 
    same up to and including the null terminating byte 
    or up to and including the first n bytes,
    whichever comes first.
    *******************************************************/
  static int bytencmp
    (
     byte a[],
     int a_first,
     byte b[],
     int b_first,
     int n
     )
      {
        int elem;

        for (elem = 0; elem < n; ++elem)
          {
            /*System.out.print((char) a[a_first + elem]);
            System.out.print((char) b[b_first + elem]);*/
                             
            if ('\0' == a[a_first + elem] && '\0' == b[b_first + elem])
              {
                /*System.out.println("return 0");*/
                return 0;
              }
            if (a[a_first + elem] < b[b_first + elem])
              {
                /*System.out.println("return 1");*/
                return 1;
              }
            else if (a[a_first + elem] > b[b_first + elem])
              {
                /*System.out.println("return -1");*/
                return -1;
              }
          }

        /*System.out.println("return 0");*/
        return 0;
      }

  /********************************************************
    Function: charncmp
    *******************************************************/
  static int charncmp
    (
     char a[],
     int a_first,
     char b[],
     int b_first,
     int n
     )
      {
        int elem;

        for (elem = 0; elem < n; ++elem)
          {
            if ('\0' == a[a_first + elem] && '\0' == b[b_first + elem])
              {
                return 0;
              }
            if (a[a_first + elem] < b[b_first + elem])
              {
                return 1;
              }
            else if (a[a_first + elem] > b[b_first + elem])
              {
                return -1;
              }
          }

        return 0;
      }
}

/********************************************************
  Class: CError
  *******************************************************/
final class CError //**NS**
{
  /********************************************************
    Function: impos
    Description:
    *******************************************************/
  static void impos
    (
     String message
     )
      {
        System.out.println("Java-Lex Error: " + message);
      }

  /********************************************************
    Constants
    Description: Error codes for parse_error().
    *******************************************************/
  static final int E_BADEXPR = 0;
  static final int E_PAREN = 1;
  static final int E_LENGTH = 2;
  static final int E_BRACKET = 3;
  static final int E_BOL = 4;
  static final int E_CLOSE = 5;
  static final int E_NEWLINE = 6;
  static final int E_BADMAC = 7;
  static final int E_NOMAC = 8;
  static final int E_MACDEPTH = 9;
  static final int E_INIT = 10;
  static final int E_EOF = 11;
  static final int E_DIRECT = 12;
  static final int E_INTERNAL = 13;
  static final int E_STATE = 14;
  static final int E_MACDEF = 15;
  static final int E_SYNTAX = 16;
  static final int E_BRACE = 17;
  
  /********************************************************
    Constants
    Description: String messages for parse_error();
    *******************************************************/
  static final String errmsg[] = 
    {
      "Malformed regular expression.",
      "Missing close parenthesis.",
      "Too many regular expressions or expression too long.",
      "Missing [ in character class.",
      "^ must be at start of expression or after [.",
      "+ ? or * must follow an expression or subexpression.",
      "Newline in quoted string.",
      "Missing } in macro expansion.",
      "Macro does not exist.",
      "Macro expansions nested too deeply.",
      "Java-Lex has not been successfully initialized.",
      "Unexpected end-of-file found.",
      "Undefined or badly-formed Java-Lex directive.",
      "Internal Java-Lex error.",
      "Unitialized state name.",
      "Badly formed macro definition.",
      "Syntax error.",
      "Missing brace at start of lexical action."
    };
  
  /********************************************************
    Function: parse_error
    Description:
    *******************************************************/
  static void parse_error
    (
     int error_code,
     int line_number
     )
      {
        System.out.println("Error: Parse error at line " 
                           + line_number + ".");
        System.out.println("Error Description: " + errmsg[error_code]);
        throw new Error("Parse error.");
      }
}

/********************************************************
  Class: CSet
  *******************************************************/
final  class CSet 
{
  /********************************************************
    Member Variables
    *******************************************************/
  private BitSet m_set;
  private boolean m_complement;

  /********************************************************
    Function: CSet
    *******************************************************/
  CSet
    (
     )
    {
      m_set = new BitSet();
      m_complement = false;
    }

  /********************************************************
    Function: complement
    *******************************************************/
  void complement
    (
     )
      {
        m_complement = true;
      }

  /********************************************************
    Function: add
    *******************************************************/
  void add
    (
     int i
     )
      {
        m_set.set(i);
      }
  
  /********************************************************
    Function: contains
    *******************************************************/
  boolean contains
    (
     int i
     )
      {
        boolean result;
        
        result = m_set.get(i);
        
        if (true == m_complement)
          {
            return (false == result);
          }
        
        return result;
      }

  /********************************************************
    Function: mimic
    *******************************************************/
  void mimic
    (
     CSet set
     )
      {
        m_complement = set.m_complement;
        m_set = (BitSet) set.m_set.clone();
      } 
}

/********************************************************
  Class: CNfa
  *******************************************************/
final class CNfa //**NS**
{
  /********************************************************
    Member Variables
    *******************************************************/
  int m_edge;  /* Label for edge type:
                         character code, 
                         CCL (character class), 
                         [STATE,
                         SCL (state class),]
                         EMPTY, 
                         EPSILON. */
  
  CSet m_set;  /* Set to store character classes. */
  CNfa m_next;  /* Next state (or null if none). */
  
  CNfa m_next2;  /* Another state with type == EPSILON
                           and null if not used.  
                           The NFA construction should result in two
                           outgoing edges only if both are EPSILON edges. */
  
  CAccept m_accept;  /* Set to null if nonaccepting state. */
  int m_anchor;  /* Says if and where pattern is anchored. */

  int m_label;

  BitSet m_states;

  /********************************************************
    Constants
    *******************************************************/
  static final int NO_LABEL = -1;

  /********************************************************
    Constants: Edge Types
    Note: Edge transitions on one specific character
    are labelled with the character Ascii (Unicode)
    codes.  So none of the constants below should
    overlap with the natural character codes.
    *******************************************************/
  static final int CCL = -1;
  static final int EMPTY = -2;
  static final int EPSILON = -3;
   
  /********************************************************
    Function: CNfa
    *******************************************************/
 CNfa
    (
     )
    {
      m_edge = EMPTY;
      m_set = null;
      m_next = null;
      m_next2 = null;
      m_accept = null;
      m_anchor = CSpec.NONE;
      m_label = NO_LABEL;
      m_states = null;
    }

  /********************************************************
    Function: mimic
    Description: Converts this NFA state into a copy of
    the input one.
    *******************************************************/
  void mimic
    (
     CNfa nfa
     )
      {
        m_edge = nfa.m_edge;
        
        if (null != nfa.m_set)
          {
            if (null == m_set)
              {
                m_set = new CSet();
              }
            m_set.mimic(nfa.m_set);
          }
        else
          {
            m_set = null;
          }

        m_next = nfa.m_next;
        m_next2 = nfa.m_next2;
        m_accept = nfa.m_accept;
        m_anchor = nfa.m_anchor;

        if (null != nfa.m_states)
          {
            m_states = (BitSet) nfa.m_states.clone();
          }
        else
          {
            m_states = null;
          }
      }
}

/***************************************************************
  Class: CLexGen
  **************************************************************/
final class CLexGen //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private InputStream m_instream; /* Java-Lex specification file. */
  private DataOutputStream m_outstream; /* Lexical analyzer source file. */

  private CInput m_input; /* Input buffer class. */

  private Hashtable m_tokens; /* Hashtable that maps characters to their 
                                 corresponding lexical code for
                                 the internal lexical analyzer. */
  private CSpec m_spec; /* Spec class holds information
                           about the generated lexer. */
  private boolean m_init_flag; /* Flag set to true only upon 
                                  successful initialization. */

  private CMakeNfa m_makeNfa; /* NFA machine generator module. */
  private CNfa2Dfa m_nfa2dfa; /* NFA to DFA machine (transition table) 
                                 conversion module. */
  private CMinimize m_minimize; /* Transition table compressor. */
  private CEmit m_emit; /* Output module that emits source code
                           into the generated lexer file. */


  /********************************************************
    Constants
    *******************************************************/
  private static final boolean ERROR = false;
  private static final boolean NOT_ERROR = true;
  private static final int BUFFER_SIZE = 1024;

  /********************************************************
    Constants: Token Types
    *******************************************************/
  static final int EOS = 1;
  static final int ANY = 2;
  static final int AT_BOL = 3;
  static final int AT_EOL = 4;
  static final int CCL_END = 5;
  static final int CCL_START = 6;
  static final int CLOSE_CURLY = 7;
  static final int CLOSE_PAREN = 8;
  static final int CLOSURE = 9;
  static final int DASH = 10;
  static final int END_OF_INPUT = 11;
  static final int L = 12;
  static final int OPEN_CURLY = 13;
  static final int OPEN_PAREN = 14;
  static final int OPTIONAL = 15;
  static final int OR = 16;
  static final int PLUS_CLOSE = 17;

  /***************************************************************
    Function: CLexGen
    **************************************************************/
  CLexGen 
    (
     String filename
     )
      throws java.io.FileNotFoundException, java.io.IOException
      {
        /* Successful initialization flag. */
        m_init_flag = false;
        
        /* Open input stream. */
        m_instream = new FileInputStream(filename);
        if (null == m_instream)
          {
            System.out.println("Error: Unable to open input file "
                               + filename + ".");
            return;
          }

        /* Open output stream. */
        m_outstream = new DataOutputStream(
                        /*new BufferedOutputStream(*/
                          new FileOutputStream(filename + ".java")/*)*/); //**NS**
        if (null == m_outstream)
          {
            System.out.println("Error: Unable to open output file "
                               + filename + ".java.");
            return;
          }

        /* Create input buffer class. */
        m_input = new CInput(m_instream);

        /* Initialize character hash table. */
        m_tokens = new Hashtable();
        m_tokens.put(new Character('$'),new Integer(AT_EOL));
        m_tokens.put(new Character('('),new Integer(OPEN_PAREN));
        m_tokens.put(new Character(')'),new Integer(CLOSE_PAREN));
        m_tokens.put(new Character('*'),new Integer(CLOSURE));
        m_tokens.put(new Character('+'),new Integer(PLUS_CLOSE));
        m_tokens.put(new Character('-'),new Integer(DASH));
        m_tokens.put(new Character('.'),new Integer(ANY));
        m_tokens.put(new Character('?'),new Integer(OPTIONAL));
        m_tokens.put(new Character('['),new Integer(CCL_START));
        m_tokens.put(new Character(']'),new Integer(CCL_END));
        m_tokens.put(new Character('^'),new Integer(AT_BOL));
        m_tokens.put(new Character('{'),new Integer(OPEN_CURLY));
        m_tokens.put(new Character('|'),new Integer(OR));
        m_tokens.put(new Character('}'),new Integer(CLOSE_CURLY));
      
        /* Initialize spec structure. */
        m_spec = new CSpec(this);
        
        /* Nfa to dfa converter. */
        m_nfa2dfa = new CNfa2Dfa();
        m_minimize = new CMinimize();
        m_makeNfa = new CMakeNfa();

        m_emit = new CEmit();

        /* Successful initialization flag. */
        m_init_flag = true;
      }

  /***************************************************************
    Function: generate
    Description: 
    **************************************************************/
  void generate
    (
     )
      throws java.io.IOException, java.io.FileNotFoundException
      {
        if (false == m_init_flag)
          {
            CError.parse_error(CError.E_INIT,0);
          }

        if (CUtility.DEBUG)
          {
            CUtility.assert(null != this);
            CUtility.assert(null != m_outstream);
            CUtility.assert(null != m_input);
            CUtility.assert(null != m_tokens);
            CUtility.assert(null != m_spec);
            CUtility.assert(true == m_init_flag);
          }

        /*m_emit.emit_imports(m_spec,m_outstream);*/

        if (m_spec.m_verbose)
          {
            System.out.println("Processing first section -- user code.");
          }
        userCode();
        if (true == m_input.m_eof_reached)
          {
            CError.parse_error(CError.E_EOF,m_input.m_line_number);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Processing second section -- " 
                               + "Java-Lex declarations.");
          }
        userDeclare();
        if (true == m_input.m_eof_reached)
          {
            CError.parse_error(CError.E_EOF,m_input.m_line_number);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Processing third section -- lexical rules.");
          }
        userRules();
        if (true == CUtility.DO_DEBUG)
          {
            print_header();
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Outputting lexical analyzer code.");
          }
        m_emit.emit(m_spec,m_outstream);

        if (m_spec.m_verbose && true == CUtility.OLD_DUMP_DEBUG)
          {
            details();
          }
      }

  /***************************************************************
    Function: userCode
    Description: Process first section of specification,
    echoing it into output file.
    **************************************************************/
  private void userCode
    (
     )
      throws java.io.IOException
      {
        int count = 0;

        if (false == m_init_flag)
          {
            CError.parse_error(CError.E_INIT,0);
          }

        if (CUtility.DEBUG)
          {
            CUtility.assert(null != this);
            CUtility.assert(null != m_outstream);
            CUtility.assert(null != m_input);
            CUtility.assert(null != m_tokens);
            CUtility.assert(null != m_spec);
          }

        if (true == m_input.m_eof_reached)
          {
            CError.parse_error(CError.E_EOF,0);
          }

        while (true)
          {
            if (true == m_input.getLine())
              {
                /* Eof reached. */
                CError.parse_error(CError.E_EOF,0);
              }
            
            if (2 <= m_input.m_line_read 
                && '%' == m_input.m_line[0]
                && '%' == m_input.m_line[1])
              {
                /* Discard remainder of line. */
                m_input.m_line_index = m_input.m_line_read;
                return;
              }

            m_outstream.writeBytes(new String(m_input.m_line,0,
                                              m_input.m_line_read));
          }
      }

  /***************************************************************
    Function: getName
    **************************************************************/
  private char[] getName
    (
     )
      {
        char buffer[];
        int elem;

        /* Skip white space. */
        while (m_input.m_line_index < m_input.m_line_read
               && true == CUtility.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
          }

        /* No name? */
        if (m_input.m_line_index >= m_input.m_line_read)
          {
            CError.parse_error(CError.E_DIRECT,0);
          }

        /* Determine length. */
        elem = m_input.m_line_index;
        while (elem < m_input.m_line_read
               && false == CUtility.isnewline(m_input.m_line[elem]))
          {
            ++elem;
          } 

        /* Allocate non-terminated buffer of exact length. */
        buffer = new char[elem - m_input.m_line_index];
        
        /* Copy. */
        elem = 0;
        while (m_input.m_line_index < m_input.m_line_read
               && false == CUtility.isnewline(m_input.m_line[m_input.m_line_index]))
          {
            buffer[elem] = m_input.m_line[m_input.m_line_index];
            ++elem;
            ++m_input.m_line_index;
          }

        return buffer;
      }

  private static final int CLASS_CODE = 0;       //**NS**
  private static final int INIT_CODE = 1;        //**NS**
  private static final int EOF_CODE = 2;         //**NS**
  private static final int INIT_THROW_CODE = 3;  //**NS**
  private static final int YYLEX_THROW_CODE = 4; //**NS**
  private static final int EOF_THROW_CODE = 5;   //**NS**
  private static final int EOF_VALUE_CODE = 6;   //**NS**

  /***************************************************************
    Function: packCode
    Description:
    **************************************************************/
  private char[] packCode
    (
     char start_dir[],
     char end_dir[],
     char prev_code[],
     int prev_read,
     int specified
     )
      throws java.io.IOException
      {
        if (CUtility.DEBUG)
          {
            CUtility.assert(INIT_CODE == specified 
                            || CLASS_CODE == specified
                            || EOF_CODE == specified
                            || EOF_VALUE_CODE == specified
                            || INIT_THROW_CODE == specified
                            || YYLEX_THROW_CODE == specified
                            || EOF_THROW_CODE == specified);
          }

        if (0 != CUtility.charncmp(m_input.m_line,
                                   0,
                                   start_dir,
                                   0,
                                   start_dir.length - 1))
          {
            CError.parse_error(CError.E_INTERNAL,0);
          }
        
        if (null == prev_code)
          {
            prev_code = new char[BUFFER_SIZE];
            prev_read = 0;
          }
        
        if (prev_read >= prev_code.length)
          {
            prev_code = CUtility.doubleSize(prev_code);
          }
        
        m_input.m_line_index = start_dir.length - 1;
        while (true)
          {
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    CError.parse_error(CError.E_EOF,m_input.m_line_number);
                  }
                
                if (0 == CUtility.charncmp(m_input.m_line,
                                           0,
                                           end_dir,
                                           0,
                                           end_dir.length - 1))
                  {
                    m_input.m_line_index = end_dir.length - 1;
                    
                    switch (specified)
                      {
                      case CLASS_CODE:
                        m_spec.m_class_read = prev_read;
                        break;
                        
                      case INIT_CODE:
                        m_spec.m_init_read = prev_read;
                        break;
                        
                      case EOF_CODE:
                        m_spec.m_eof_read = prev_read;
                        break;

                      case EOF_VALUE_CODE:
                        m_spec.m_eof_value_read = prev_read;
                        break;

                      case INIT_THROW_CODE:
                        m_spec.m_init_throw_read = prev_read;
                        break;

                      case YYLEX_THROW_CODE:
                        m_spec.m_yylex_throw_read = prev_read;
                        break;
                        
                      case EOF_THROW_CODE:
                        m_spec.m_eof_throw_read = prev_read;
                        break;
                        
                      default:
                        CError.parse_error(CError.E_INTERNAL,m_input.m_line_number);
                        break;
                      }

                    return prev_code;
                  }
              }

            while (m_input.m_line_index < m_input.m_line_read)
              {
                prev_code[prev_read] = m_input.m_line[m_input.m_line_index];
                ++prev_read;
                ++m_input.m_line_index;

                if (prev_read >= prev_code.length)
                  {
                    prev_code = CUtility.doubleSize(prev_code);
                  }
              }
          }
      }

  /***************************************************************
    Member Variables: Java-Lex directives.
    **************************************************************/
  private char m_state_dir[] = { 
    '%', 's', 't', 
    'a', 't', 'e',
    '\0'
    };
  
  private char m_char_dir[] = { 
    '%', 'c', 'h',
    'a', 'r',
    '\0'
    };

  private char m_line_dir[] = { 
    '%', 'l', 'i',
    'n', 'e',
    '\0'
    };

  private char m_cup_dir[] = { 
    '%', 'c', 'u',
    'p', 
    '\0'
    };

  private char m_class_dir[] = { 
    '%', 'c', 'l', 
    'a', 's', 's',
    '\0'
    };

  private char m_function_dir[] = { 
    '%', 'f', 'u',
    'n', 'c', 't',
    'i', 'o', 'n',
    '\0'
    };

  private char m_type_dir[] = { 
    '%', 't', 'y',
    'p', 'e',
    '\0'
    };

  private char m_integer_dir[] = { 
    '%', 'i', 'n',
    't', 'e', 'g', 
    'e', 'r',
    '\0'
    };

  private char m_intwrap_dir[] = { 
    '%', 'i', 'n',
    't', 'w', 'r', 
    'a', 'p',
    '\0'
    };

  private char m_full_dir[] = { 
    '%', 'f', 'u', 
    'l', 'l',
    '\0'
    };

  private char m_unicode_dir[] = { 
    '%', 'u', 'n', 
    'i', 'c', 'o',
    'd', 'e',
    '\0'
    };

  private char m_notunix_dir[] = { 
    '%', 'n', 'o',
    't', 'u', 'n', 
    'i', 'x',
    '\0'
    };

  private char m_init_code_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', '{',
    '\0'
    };

  private char m_init_code_end_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', '}',
    '\0'
    };

  private char m_init_throw_code_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', 't',
    'h', 'r', 'o',
    'w', '{',
    '\0'
    };

  private char m_init_throw_code_end_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', 't',
    'h', 'r', 'o',
    'w', '}',
    '\0'
    };

  private char m_yylex_throw_code_dir[] = { 
    '%', 'y', 'y', 'l', 
    'e', 'x', 't',
    'h', 'r', 'o',
    'w', '{',
    '\0'
    };

  private char m_yylex_throw_code_end_dir[] = { 
    '%', 'y', 'y', 'l', 
    'e', 'x', 't',
    'h', 'r', 'o',
    'w', '}',
    '\0'
    };

  private char m_eof_code_dir[] = { 
    '%', 'e', 'o', 
    'f', '{',
    '\0'
    };

  private char m_eof_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', '}',
    '\0'
    };

  private char m_eof_value_code_dir[] = { 
    '%', 'e', 'o', 
    'f', 'v', 'a', 
    'l', '{',
    '\0'
    };

  private char m_eof_value_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', 'v', 'a',
    'l', '}',
    '\0'
    };

  private char m_eof_throw_code_dir[] = { 
    '%', 'e', 'o', 
    'f', 't', 'h',
    'r', 'o', 'w',
    '{',
    '\0'
    };

  private char m_eof_throw_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', 't', 'h',
    'r', 'o', 'w',
    '}',
    '\0'
    };

  private char m_class_code_dir[] = { 
    '%', '{',
    '\0'
    };

  private char m_class_code_end_dir[] = { 
    '%', '}',
    '\0'
    };

  private char m_yyeof_dir[] = { 
    '%', 'y', 'y',
    'e', 'o', 'f',
    '\0'
    };
  
  /***************************************************************
    Function: userDeclare
    Description:
    **************************************************************/
  private void userDeclare
    (
     )
      throws java.io.IOException
        {
          int elem;
          
          if (CUtility.DEBUG)
            {
              CUtility.assert(null != this);
              CUtility.assert(null != m_outstream);
              CUtility.assert(null != m_input);
              CUtility.assert(null != m_tokens);
              CUtility.assert(null != m_spec);
            }

          if (true == m_input.m_eof_reached)
            {
              /* End-of-file. */
              CError.parse_error(CError.E_EOF,
                                 m_input.m_line_number);
            }

          while (false == m_input.getLine())
            {
              /* Look for double percent. */
              if (2 <= m_input.m_line_read 
                  && '%' == m_input.m_line[0] 
                  && '%' == m_input.m_line[1])
                {
                  /* Mess around with line. */
                  for (elem = 0; elem < m_input.m_line.length - 2; ++elem)
                    {
                      m_input.m_line[elem] = m_input.m_line[elem + 2];
                    }
                  m_input.m_line_read = m_input.m_line_read - 2;

                  m_input.m_pushback_line = true;
                  /* Check for and discard empty line. */
                  if (0 == m_input.m_line_read 
                      || '\n' == m_input.m_line[0])
                    {
                      m_input.m_pushback_line = false;
                    }

                  return;
                }

              if (0 == m_input.m_line_read)
                {
                  continue;
                }

              if ('%' == m_input.m_line[0])
                {
                  /* Special lex declarations. */
                  if (1 >= m_input.m_line_read)
                    {
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      continue;
                    }

                  switch (m_input.m_line[1])
                    {
                    case '{':
                      if (0 == CUtility.charncmp(m_input.m_line,
                                                 0,
                                                 m_class_code_dir,
                                                 0,
                                                 m_class_code_dir.length - 1))
                        {
                          m_spec.m_class_code = packCode(m_class_code_dir,
                                                         m_class_code_end_dir,
                                                         m_spec.m_class_code,
                                                         m_spec.m_class_read,
                                                         CLASS_CODE);
                          break;
                        }
              
                      /* Bad directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'c':
                      if (0 == CUtility.charncmp(m_input.m_line,
                                                 0,
                                                 m_char_dir,
                                                 0,
                                                 m_char_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_char_dir.length;
                          m_spec.m_count_chars = true;
                          break;
                        }       
                      else if (0 == CUtility.charncmp(m_input.m_line,
                                                      0,
                                                      m_cup_dir,
                                                      0,
                                                      m_cup_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_cup_dir.length;
                          m_spec.m_cup_compatible = true;
                          break;
                        }
                      else if (0 == CUtility.charncmp(m_input.m_line,
                                                      0,
                                                      m_class_dir, 
                                                      0,
                                                      m_class_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_class_dir.length;
                          m_spec.m_class_name = getName();
                          break;
                        }
              
                      /* Bad directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                      
                    case 'e':
                      if (0 == CUtility.charncmp(m_input.m_line,
                                                 0,
                                                 m_eof_code_dir,
                                                 0,
                                                 m_eof_code_dir.length - 1))
                        {
                          m_spec.m_eof_code = packCode(m_eof_code_dir,
                                                       m_eof_code_end_dir,
                                                       m_spec.m_eof_code,
                                                       m_spec.m_eof_read,
                                                       EOF_CODE);
                          break;
                        }
                      else if (0 == CUtility.charncmp(m_input.m_line,
                                                      0,
                                                      m_eof_value_code_dir,
                                                      0,
                                                      m_eof_value_code_dir.length - 1))
                        {
                          m_spec.m_eof_value_code = packCode(m_eof_value_code_dir,
                                                             m_eof_value_code_end_dir,
                                                             m_spec.m_eof_value_code,
                                                             m_spec.m_eof_value_read,
                                                             EOF_VALUE_CODE);
                          break;
                        }
                      else if (0 == CUtility.charncmp(m_input.m_line,
                                                      0,
                                                      m_eof_throw_code_dir,
                                                      0,
                                                      m_eof_throw_code_dir.length - 1))
                        {
                          m_spec.m_eof_throw_code = packCode(m_eof_throw_code_dir,
                                                       m_eof_throw_code_end_dir,
                                                       m_spec.m_eof_throw_code,
                                                       m_spec.m_eof_throw_read,
                                                       EOF_THROW_CODE);
                          break;
                        }
              
                      /* Bad directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'f':
                      if (0 == CUtility.charncmp(m_input.m_line,
                                                 0,
                                                 m_function_dir,
                                                 0,
                                                 m_function_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_function_dir.length;
                          m_spec.m_function_name = getName();
                          break;
                        }
                      else if (0 == CUtility.charncmp(m_input.m_line,
                                                      0,
                                                      m_full_dir,
                                                      0,
                                                      m_full_dir.length - 1))
                        {
                          m_input.m_line_index = m_full_dir.length;
                          m_spec.m_dtrans_ncols = CUtility.MAX_EIGHT_BIT + 1;
                          break;
                        }

                      /* Bad directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'i':
                      if (0 == CUtility.charncmp(m_input.m_line,
                                                 0,
                                                 m_integer_dir,
                                                 0,
                                                 m_integer_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_integer_dir.length;
                          m_spec.m_integer_type = true;
                          break;
                        }
                      else if (0 == CUtility.charncmp(m_input.m_line,
                                                      0,
                                                      m_intwrap_dir,
                                                      0,
                                                      m_intwrap_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_integer_dir.length;
                          m_spec.m_intwrap_type = true;
                          break;
                        }
                      else if (0 == CUtility.charncmp(m_input.m_line,
                                                      0,
                                                      m_init_code_dir,
                                                      0,
                                                      m_init_code_dir.length - 1))
                        {
                          m_spec.m_init_code = packCode(m_init_code_dir,
                                                        m_init_code_end_dir,
                                                        m_spec.m_init_code,
                                                        m_spec.m_init_read,
                                                        INIT_CODE);
                          break;
                        }
                      else if (0 == CUtility.charncmp(m_input.m_line,
                                                      0,
                                                      m_init_throw_code_dir,
                                                      0,
                                                      m_init_throw_code_dir.length - 1))
                        {
                          m_spec.m_init_throw_code = packCode(m_init_throw_code_dir,
                                                       m_init_throw_code_end_dir,
                                                       m_spec.m_init_throw_code,
                                                       m_spec.m_init_throw_read,
                                                       INIT_THROW_CODE);
                          break;
                        }

                      /* Bad directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'l':
                      if (0 == CUtility.charncmp(m_input.m_line,
                                                 0,
                                                 m_line_dir,
                                                 0,
                                                 m_line_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_line_dir.length;
                          m_spec.m_count_lines = true;
                          break;
                        }

                      /* Bad directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'n':
                      if (0 == CUtility.charncmp(m_input.m_line,
                                                 0,
                                                 m_notunix_dir,
                                                 0,
                                                 m_notunix_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_notunix_dir.length;
                          m_spec.m_unix = false;
                          break;
                        }

                      /* Bad directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 's':
                      if (0 == CUtility.charncmp(m_input.m_line,
                                                 0,
                                                 m_state_dir,
                                                 0,
                                                 m_state_dir.length - 1))
                        {
                          /* Recognize state list. */
                          m_input.m_line_index = m_state_dir.length;
                          saveStates();
                          break;
                        }

                      /* Undefined directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                     
                    case 't':
                      if (0 == CUtility.charncmp(m_input.m_line,
                                                 0,
                                                 m_type_dir,
                                                 0,
                                                 m_type_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_type_dir.length;
                          m_spec.m_type_name = getName();
                          break;
                        }

                      /* Undefined directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'u':
                      if (0 == CUtility.charncmp(m_input.m_line,
                                                 0,
                                                 m_unicode_dir,
                                                 0,
                                                 m_unicode_dir.length - 1))
                        {
                          m_input.m_line_index = m_unicode_dir.length;
                          /* UNDONE: What to do here? */
                          break;
                        }

                      /* Bad directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'y':
                      if (0 == CUtility.charncmp(m_input.m_line,
                                                 0,
                                                 m_yyeof_dir,
                                                 0,
                                                 m_yyeof_dir.length - 1))
                        {
                          m_input.m_line_index = m_yyeof_dir.length;
                          m_spec.m_yyeof = true;
                          break;
                        } else if (0 == CUtility.charncmp(m_input.m_line,
                                                          0,
                                                          m_yylex_throw_code_dir,
                                                          0,
                                                          m_yylex_throw_code_dir.length - 1))
                        {
                          m_spec.m_yylex_throw_code = packCode(m_yylex_throw_code_dir,
                                                               m_yylex_throw_code_end_dir,
                                                       m_spec.m_yylex_throw_code,
                                                       m_spec.m_yylex_throw_read,
                                                       YYLEX_THROW_CODE);
                          break;
                        }


                      /* Bad directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    default:
                      /* Undefined directive. */
                      CError.parse_error(CError.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                    }
                }
              else
                {
                  /* Regular expression macro. */
                  m_input.m_line_index = 0;
                  saveMacro();
                }

              if (CUtility.OLD_DEBUG)
                {
                  System.out.println("Line number " 
                                     + m_input.m_line_number + ":"); 
                  System.out.print(new String(m_input.m_line,
                                              0,m_input.m_line_read));
                }
            }
        }
         
  /***************************************************************
    Function: userRules
    Description: Processes third section of Java-Lex 
    specification and creates minimized transition table.
    **************************************************************/
  private void userRules
    (
     )
      throws java.io.IOException
      {
        int code;

        if (false == m_init_flag)
          {
            CError.parse_error(CError.E_INIT,0);
          }

        if (CUtility.DEBUG)
          {
            CUtility.assert(null != this);
            CUtility.assert(null != m_outstream);
            CUtility.assert(null != m_input);
            CUtility.assert(null != m_tokens);
            CUtility.assert(null != m_spec);
          }

        /* UNDONE: Need to handle states preceding rules. */
        
        if (m_spec.m_verbose)
          {
            System.out.println("Creating NFA machine representation.");
          }
        m_makeNfa.thompson(this,m_spec,m_input);
        
        /*print_nfa();*/

        if (CUtility.DEBUG)
          {
            CUtility.assert(END_OF_INPUT == m_spec.m_current_token);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Creating DFA transition table.");
          }
        m_nfa2dfa.make_dfa(this,m_spec);

        if (CUtility.FOODEBUG) {
          print_header();
        }

        if (m_spec.m_verbose)
          {
            System.out.println("Minimizing DFA transition table.");
          }
        m_minimize.min_dfa(m_spec);
      }

  /***************************************************************
    Function: printccl
    Description: Debuggng routine that outputs readable form
    of character class.
    **************************************************************/
  private void printccl
    (
     CSet set
     )
      {
        int i;
        
        System.out.print(" [");
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (true == set.contains(i))
              {
                System.out.print(interp_int(i));
              }
          }
        System.out.print(']');
      }

  /***************************************************************
    Function: plab
    Description:
    **************************************************************/
  private String plab
    (
     CNfa state
     )
      {
        int index;
        
        if (null == state)
          {
            return (new String("--"));
          }

        index = m_spec.m_nfa_states.indexOf(state);
        
        return ((new Integer(index)).toString());
      }

  /***************************************************************
    Function: interp_int
    Description:
    **************************************************************/
  private String interp_int
    (
     int i
     )
      {
        switch (i)
          {
          case (int) '\b':
            return (new String("\\b"));

          case (int) '\t':
            return (new String("\\t"));

          case (int) '\n':
            return (new String("\\n"));

          case (int) '\f':
            return (new String("\\f"));

          case (int) '\r':
            return (new String("\\r"));
            
          case (int) ' ':
            return (new String("\\ "));
            
          default:
            return ((new Character((char) i)).toString());
          }
      }

  /***************************************************************
    Function: print_nfa
    Description:
    **************************************************************/
  void print_nfa
    (
     )
      {
        int elem;
        CNfa nfa;
        int size;
        Enumeration states;
        Integer index;
        int i;
        int j;
        int vsize;
        String state;
     
        System.out.println("--------------------- NFA -----------------------");
        
        size = m_spec.m_nfa_states.size();
        for (elem = 0; elem < size; ++elem)
          {
            nfa = (CNfa) m_spec.m_nfa_states.elementAt(elem);
            
            System.out.print("Nfa state " + plab(nfa) + ": ");
            
            if (null == nfa.m_next)
              {
                System.out.print("(TERMINAL)");
              }
            else
              {
                System.out.print("--> " + plab(nfa.m_next));
                System.out.print("--> " + plab(nfa.m_next2));
                
                switch (nfa.m_edge)
                  {
                  case CNfa.CCL:
                    printccl(nfa.m_set);
                    break;

                  case CNfa.EPSILON:
                    System.out.print(" EPSILON ");
                    break; 
                    
                  default:
                    System.out.print(" " + interp_int(nfa.m_edge));
                    break;
                  }
              }

            if (0 == elem)
              {
                System.out.print(" (START STATE)");
              }
            
            if (null != nfa.m_accept)
              {
                System.out.print(" accepting " 
                                 + ((0 != (nfa.m_anchor & CSpec.START)) ? "^" : "")
                                 + "<" 
                                 + (new String(nfa.m_accept.m_action,0,
                                               nfa.m_accept.m_action_read))
                                 + ">"
                                 + ((0 != (nfa.m_anchor & CSpec.END)) ? "$" : ""));
              }

            System.out.println("");
          }

        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (CUtility.DEBUG)
              {
                CUtility.assert(null != state);
                CUtility.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");
            System.out.print("\tStart states of matching rules: ");
            
            i = index.intValue();
            vsize = m_spec.m_state_rules[i].size();
            
            for (j = 0; j < vsize; ++j)
              {
                nfa = (CNfa) m_spec.m_state_rules[i].elementAt(j);

                System.out.print(m_spec.m_nfa_states.indexOf(nfa) + " ");
              }

            System.out.println("");
          }

        System.out.println("-------------------- NFA ----------------------");
      }

  /***************************************************************
    Function: getStates
    Description: Parses the state area of a rule,
    from the beginning of a line.
    < state1, state2 ... > regular_expression { action }
    Returns null on only EOF.  Returns all_states, 
    initialied properly to correspond to all states,
    if no states are found.
    Special Notes: This function treats commas as optional
    and permits states to be spread over multiple lines.
    **************************************************************/
  private BitSet all_states = null;
  BitSet getStates
    (
     )
      throws java.io.IOException
      {
        int start_state;
        int count_state;
        BitSet states;
        String name;
        Integer index;
        int i;
        int size;
        
        if (CUtility.DEBUG)
          {
            CUtility.assert(null != this);
            CUtility.assert(null != m_outstream);
            CUtility.assert(null != m_input);
            CUtility.assert(null != m_tokens);
            CUtility.assert(null != m_spec);
          }

        states = null;

        /* Skip white space. */
        while (true == CUtility.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
    
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                /* Must just be an empty line. */
                if (true == m_input.getLine())
                  {
                    /* EOF found. */
                    return null;
                  }
              }
          }

        /* Look for states. */
        if ('<' == m_input.m_line[m_input.m_line_index])
          {
            ++m_input.m_line_index;
           
            states = new BitSet();

            /* Parse states. */
            while (true)
              {
                /* We may have reached the end of the line. */
                while (m_input.m_line_index >= m_input.m_line_read)
                  {
                    if (true == m_input.getLine())
                      {
                        /* EOF found. */
                        CError.parse_error(CError.E_EOF,m_input.m_line_number);
                        return states;
                      }
                  }

                while (true)
                  {
                    /* Skip white space. */
                    while (true == CUtility.isspace(m_input.m_line[m_input.m_line_index]))
                      {
                        ++m_input.m_line_index;
                        
                        while (m_input.m_line_index >= m_input.m_line_read)
                          {
                            if (true == m_input.getLine())
                              {
                                /* EOF found. */
                                CError.parse_error(CError.E_EOF,m_input.m_line_number);
                                return states;
                              }
                          }
                      }
                    
                    if (',' != m_input.m_line[m_input.m_line_index])
                      {
                        break;
                      }

                    ++m_input.m_line_index;
                  }

                if ('>' == m_input.m_line[m_input.m_line_index])
                  {
                    ++m_input.m_line_index;
                    if (m_input.m_line_index < m_input.m_line_read)
                      {
                        m_advance_stop = true;
                      }
                    return states;
                  }

                /* Read in state name. */
                start_state = m_input.m_line_index;
                while (false == CUtility.isspace(m_input.m_line[m_input.m_line_index])
                       && ',' != m_input.m_line[m_input.m_line_index]
                       && '>' != m_input.m_line[m_input.m_line_index])
                  {
                    ++m_input.m_line_index;

                    if (m_input.m_line_index >= m_input.m_line_read)
                      {
                        /* End of line means end of state name. */
                        break;
                      }
                  }
                count_state = m_input.m_line_index - start_state;

                /* Save name after checking definition. */
                name = new String(m_input.m_line,
                                  start_state,
                                  count_state);
                index = (Integer) m_spec.m_states.get(name);
                if (null == index)
                  {
                    /* Uninitialized state. */
                    System.out.println("Uninitialized State Name: " + name);
                    CError.parse_error(CError.E_STATE,m_input.m_line_number);
                  }
                states.set(index.intValue());
              }
          }
        
        if (null == all_states)
          {
            all_states = new BitSet();

            size = m_spec.m_states.size();
            for (i = 0; i < size; ++i)
              {
                all_states.set(i);
              }
          }
        
        if (m_input.m_line_index < m_input.m_line_read)
          {
            m_advance_stop = true;
          }
        return all_states;
      }

  /********************************************************
    Function: expandMacro
    Description: Returns false on error, true otherwise. 
    *******************************************************/
  private boolean expandMacro
    (
     )
      {
        int elem;
        int start_macro;
        int end_macro;
        int start_name;
        int count_name;
        String def;
        int def_elem;
        String name;
        char replace[];
        int rep_elem;

        if (CUtility.DEBUG)
          {
            CUtility.assert(null != this);
            CUtility.assert(null != m_outstream);
            CUtility.assert(null != m_input);
            CUtility.assert(null != m_tokens);
            CUtility.assert(null != m_spec);
          }

        /* Check for macro. */
        if ('{' != m_input.m_line[m_input.m_line_index])
          {
            CError.parse_error(CError.E_INTERNAL,m_input.m_line_number);
            return ERROR;
          }
        
        start_macro = m_input.m_line_index;
        elem = m_input.m_line_index + 1;
        if (elem >= m_input.m_line_read)
          {
            CError.impos("Unfinished macro name");
            return ERROR;
          }
        
        /* Get macro name. */
        start_name = elem;
        while ('}' != m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                CError.impos("Unfinished macro name at line " + m_input.m_line_number);
                return ERROR;
              }
          }
        count_name = elem - start_name;
        end_macro = elem;

        /* Check macro name. */
        if (0 == count_name)
          {
            CError.impos("Nonexistent macro name");
            return ERROR;
          }

        /* Debug checks. */
        if (CUtility.DEBUG)
          {
            CUtility.assert(0 < count_name);
          }

        /* Retrieve macro definition. */
        name = new String(m_input.m_line,start_name,count_name);
        def = (String) m_spec.m_macros.get(name);
        if (null == def)
          {
            CError.impos("Undefined macro \"" + name + "\" on line: "+m_input.m_line_number);
            return ERROR;
          }
        if (CUtility.OLD_DUMP_DEBUG)
          {
            System.out.println("expanded escape: " + def);
          }
                
        /* Replace macro in new buffer,
           beginning by copying first part of line buffer. */
        replace = new char[m_input.m_line.length];
        for (rep_elem = 0; rep_elem < start_macro; ++rep_elem)
          {
            replace[rep_elem] = m_input.m_line[rep_elem];

            if (CUtility.DEBUG)
              {
                CUtility.assert(rep_elem < replace.length);
              }
          }
        
        /* Copy macro definition. */
        if (rep_elem >= replace.length)
          {
            replace = CUtility.doubleSize(replace);
          }
        for (def_elem = 0; def_elem < def.length(); ++def_elem)
          {
            replace[rep_elem] = def.charAt(def_elem);
            
            ++rep_elem;
            if (rep_elem >= replace.length)
              {
                replace = CUtility.doubleSize(replace);
              }
          }

        /* Copy last part of line. */
        if (rep_elem >= replace.length)
          {
            replace = CUtility.doubleSize(replace);
          }
        for (elem = end_macro + 1; elem < m_input.m_line_read; ++elem)
          {
            replace[rep_elem] = m_input.m_line[elem];
            
            ++rep_elem;
            if (rep_elem >= replace.length)
              {
                replace = CUtility.doubleSize(replace);
              }
          } 
        
        /* Replace buffer. */
        m_input.m_line = replace;
        m_input.m_line_read = rep_elem;
        
        if (CUtility.OLD_DEBUG)
          {
//nsSystem.out.print("macro expansion is:" );
            System.out.println(new String(m_input.m_line,0,m_input.m_line_read));
          }
        return NOT_ERROR;
      }

  /***************************************************************
    Function: saveMacro
    Description: Saves macro definition of form:
    macro_name = macro_definition
    **************************************************************/
  private void saveMacro
    (
     )
      {
        int elem;
        int start_name;
        int count_name;
        int start_def;
        int count_def;
        boolean saw_escape;
        boolean in_quote;

        if (CUtility.DEBUG)
          {
            CUtility.assert(null != this);
            CUtility.assert(null != m_outstream);
            CUtility.assert(null != m_input);
            CUtility.assert(null != m_tokens);
            CUtility.assert(null != m_spec);
          }

        /* Macro declarations are of the following form:
           macro_name macro_definition */

        elem = 0;
        
        /* Skip white space preceding macro name. */
        while (true == CUtility.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* End of line has been reached,
                   and line was found to be empty. */
                return;
              }
          }

        /* Read macro name. */
        start_name = elem;
        while (false == CUtility.isspace(m_input.m_line[elem])
               && '=' != m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                CError.parse_error(CError.E_MACDEF,m_input.m_line_number);
              }
          }
        count_name = elem - start_name;

        /* Check macro name. */
        if (0 == count_name) 
          {
            /* Nonexistent macro name. */
            CError.parse_error(CError.E_MACDEF,m_input.m_line_number);
          }

        /* Skip white space between name and definition. */
        while (true == CUtility.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                CError.parse_error(CError.E_MACDEF,m_input.m_line_number);
              }
          }

        if ('=' == m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                CError.parse_error(CError.E_MACDEF,m_input.m_line_number);
              }
          }

        /* Skip white space between name and definition. */
        while (true == CUtility.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                CError.parse_error(CError.E_MACDEF,m_input.m_line_number);
              }
          }

        /* Read macro definition. */
        start_def = elem;
        in_quote = false;
        saw_escape = false;
        while (false == CUtility.isspace(m_input.m_line[elem])
               || true == in_quote
               || true == saw_escape)
          {
            if ('\"' == m_input.m_line[elem] && false == saw_escape)
              {
                if (true == in_quote)
                  {
                    in_quote = false;
                  }
                else
                  {
                    in_quote = true;
                  }
              }
            
            if ('\\' == m_input.m_line[elem] && false == saw_escape)
              {
                saw_escape = true;
              }
            else
              {
                saw_escape = false;
              }

            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* End of line. */
                break;
              }
          }
        count_def = elem - start_def;
          
        /* Check macro definition. */
        if (0 == count_def) 
          {
            /* Nonexistent macro name. */
            CError.parse_error(CError.E_MACDEF,m_input.m_line_number);
          }

        /* Debug checks. */
        if (true == CUtility.DEBUG)
          {
            CUtility.assert(0 < count_def);
            CUtility.assert(0 < count_name);
            CUtility.assert(null != m_spec.m_macros);
          }

        if (CUtility.OLD_DEBUG)
          {
            System.out.println("macro name \""
                               + new String(m_input.m_line,start_name,count_name)
                               + "\".");
            System.out.println("macro definition \""
                               + new String(m_input.m_line,start_def,count_def)
                               + "\".");
          }

        /* Add macro name and definition to table. */
        m_spec.m_macros.put(new String(m_input.m_line,start_name,count_name),
                            new String(m_input.m_line,start_def,count_def));
      }

  /***************************************************************
    Function: saveStates
    Description: Takes state declaration and makes entries
    for them in state hashtable in CSpec structure.
    State declaration should be of the form:
    %state name0[, name1, name2 ...]
    (But commas are actually optional as long as there is 
    white space in between them.)
    **************************************************************/
  private void saveStates
    (
     )
      {
        int start_state;
        int count_state;

        if (CUtility.DEBUG)
          {
            CUtility.assert(null != this);
            CUtility.assert(null != m_outstream);
            CUtility.assert(null != m_input);
            CUtility.assert(null != m_tokens);
            CUtility.assert(null != m_spec);
          }

        /* EOF found? */
        if (true == m_input.m_eof_reached)
          {
            return;
          }

        /* Debug checks. */
        if (true == CUtility.DEBUG)
          {
            CUtility.assert('%' == m_input.m_line[0]);
            CUtility.assert('s' == m_input.m_line[1]);
            CUtility.assert(m_input.m_line_index <= m_input.m_line_read);
            CUtility.assert(0 <= m_input.m_line_index);
            CUtility.assert(0 <= m_input.m_line_read);
          }

        /* Blank line?  No states? */
        if (m_input.m_line_index >= m_input.m_line_read)
          {
            return;
          }

        while (m_input.m_line_index < m_input.m_line_read)
          {
            if (CUtility.OLD_DEBUG)
              {
                System.out.println("line read " + m_input.m_line_read 
                                   + "\tline index = " + m_input.m_line_index);
              }

            /* Skip white space. */
            while (true == CUtility.isspace(m_input.m_line[m_input.m_line_index]))
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* No more states to be found. */
                    return;
                  }
              }
            
            /* Look for state name. */
            start_state = m_input.m_line_index;
            while (false == CUtility.isspace(m_input.m_line[m_input.m_line_index])
                   && ',' != m_input.m_line[m_input.m_line_index])
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line and end of state name. */
                    break;
                  }
              }
            count_state = m_input.m_line_index - start_state;

            if (CUtility.OLD_DEBUG)
              {
                System.out.println("State name \"" 
                                   + new String(m_input.m_line,start_state,count_state)
                                   + "\".");
                System.out.println("Integer index \"" 
                                   + m_spec.m_states.size()
                                   + "\".");
              }

            /* Enter new state name, along with unique index. */
            m_spec.m_states.put(new String(m_input.m_line,start_state,count_state),
                                new Integer(m_spec.m_states.size()));
            
            /* Skip comma. */
            if (',' == m_input.m_line[m_input.m_line_index])
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line. */
                    return;
                  }
              }
          }
      }

  /********************************************************
    Function: expandEscape
    Description: Takes escape sequence and returns
    corresponding character code.
    *******************************************************/
  private char expandEscape
    (
     )
      {
        char r;
        
        /* Debug checks. */
        if (true == CUtility.DEBUG)
          {
            CUtility.assert(m_input.m_line_index < m_input.m_line_read);
            CUtility.assert(0 < m_input.m_line_read);
            CUtility.assert(0 <= m_input.m_line_index);
          }

        if ('\\' != m_input.m_line[m_input.m_line_index])
          {
            ++m_input.m_line_index;
            return m_input.m_line[m_input.m_line_index - 1];
          }
        else
          {
            ++m_input.m_line_index;
            switch (CUtility.toupper(m_input.m_line[m_input.m_line_index]))
              {
              case 'B':
                ++m_input.m_line_index;
                return '\b';

              case 'T':
                ++m_input.m_line_index;
                return '\t';

              case 'N':
                ++m_input.m_line_index;
                return '\n';

              case 'F':
                ++m_input.m_line_index;
                return '\f';

              case 'R':
                ++m_input.m_line_index;
                return '\r';

              case '^':
                ++m_input.m_line_index;
                r = (char) (CUtility.toupper(m_input.m_line[m_input.m_line_index]) 
                     - '@');
                ++m_input.m_line_index;
                return r;

              case 'X':
                ++m_input.m_line_index;
                r = 0;
                if (true == CUtility.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = CUtility.hex2bin(m_input.m_line[m_input.m_line_index]);
                    ++m_input.m_line_index;
                  }
                if (true == CUtility.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = (char) (r << 4);
                    r = (char) (r | CUtility.hex2bin(m_input.m_line[m_input.m_line_index]));
                    ++m_input.m_line_index;
                  }
                if (true == CUtility.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = (char) (r << 4);
                    r = (char) (r | CUtility.hex2bin(m_input.m_line[m_input.m_line_index]));
                    ++m_input.m_line_index;
                  }
                return r;
                
              default:
                if (false == CUtility.isoctdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = m_input.m_line[m_input.m_line_index];
                    ++m_input.m_line_index;
                  }
                else
                  {
                    r = CUtility.oct2bin(m_input.m_line[m_input.m_line_index]);
                    ++m_input.m_line_index;
                    
                    if (true == CUtility.isoctdigit(m_input.m_line[m_input.m_line_index]))
                      {
                        r = (char) (r << 3);
                        r = (char) (r | CUtility.oct2bin(m_input.m_line[m_input.m_line_index]));
                        ++m_input.m_line_index;
                      }

                    if (true == CUtility.isoctdigit(m_input.m_line[m_input.m_line_index]))
                      {
                        r = (char) (r << 3);
                        r = (char) (r | CUtility.oct2bin(m_input.m_line[m_input.m_line_index]));
                        ++m_input.m_line_index;
                      }
                  }
                return r;
              }
          }
      }
        
  /********************************************************
    Function: packAccept
    Description: Packages and returns CAccept 
    for action next in input stream.
    *******************************************************/
  CAccept packAccept
    (
     )
      throws java.io.IOException
      {
        CAccept accept;
        char action[];
        int action_index;
        int brackets;

        action = new char[BUFFER_SIZE];
        action_index = 0;

        if (CUtility.DEBUG)
          {
            CUtility.assert(null != this);
            CUtility.assert(null != m_outstream);
            CUtility.assert(null != m_input);
            CUtility.assert(null != m_tokens);
            CUtility.assert(null != m_spec);
          }

        /* Get a new line, if needed. */
        while (m_input.m_line_index >= m_input.m_line_read)
          {
            if (true == m_input.getLine())
              {
                CError.parse_error(CError.E_EOF,m_input.m_line_number);
                return null;
              }
          }
        
        /* Look for beginning of action. */
        while (true == CUtility.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
            
            /* Get a new line, if needed. */
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    CError.parse_error(CError.E_EOF,m_input.m_line_number);
                    return null;
                  }
              }
          }
        
        /* Look for brackets. */
        if ('{' != m_input.m_line[m_input.m_line_index])
          {
            /*System.out.println("<" + m_input.m_line[m_input.m_line_index] + ">");*/
            CError.parse_error(CError.E_BRACE,m_input.m_line_number); 
          }
        
        /* Copy new line into action buffer. */
        brackets = 0;
        while (true)
          {
            action[action_index] = m_input.m_line[m_input.m_line_index];

            /* Look for brackets. */
            if ('{' == m_input.m_line[m_input.m_line_index])
              {
                ++brackets;
              }
            else if ('}' == m_input.m_line[m_input.m_line_index])
              {
                --brackets;
                
                if (0 == brackets)
                  {
                    ++action_index;
                    ++m_input.m_line_index;

                    break;
                  }
              }
            
            ++action_index;
            /* Double the buffer size, if needed. */
            if (action_index > action.length)
              {
                action = CUtility.doubleSize(action);
              }

            ++m_input.m_line_index;
            /* Get a new line, if needed. */
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    CError.parse_error(CError.E_SYNTAX,m_input.m_line_number);
                    return null;
                  }
              }
          }
            
        accept = new CAccept(action,action_index,m_input.m_line_number);

        if (CUtility.DEBUG)
          {
            CUtility.assert(null != accept);
          }

        if (CUtility.DESCENT_DEBUG)
          {
            System.out.print("Accepting action:");
            System.out.println(new String(accept.m_action,0,accept.m_action_read));
          }

        return accept;
      }

  /********************************************************
    Function: advance
    Description: Returns code for next token.
    *******************************************************/
  private boolean m_advance_stop = false;
  int advance
    (
     )
      throws java.io.IOException
      {
        boolean saw_escape = false;
        Integer code;
        
        /*if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          CUtility.assert(m_input.m_line_index <= m_input.m_line_read);
        }*/

        if (true == m_input.m_eof_reached)
          {
            /* EOF has already been reached,
               so return appropriate code. */

            m_spec.m_current_token = END_OF_INPUT;
            m_spec.m_lexeme = '\0';
            return m_spec.m_current_token;
          }

        /* End of previous regular expression?
           Refill line buffer? */
        if (EOS == m_spec.m_current_token
            /* ADDED */
            || m_input.m_line_index >= m_input.m_line_read)
            /* ADDED */
          {
            if (true == m_spec.m_in_quote)
              {
                CError.parse_error(CError.E_SYNTAX,m_input.m_line_number);
              }
            
            while (true)
              {
                if (false == m_advance_stop  
                    || m_input.m_line_index >= m_input.m_line_read)
                  {
                    if (true == m_input.getLine())
                      {
                        /* EOF has already been reached,
                           so return appropriate code. */
                        
                        m_spec.m_current_token = END_OF_INPUT;
                        m_spec.m_lexeme = '\0';
                        return m_spec.m_current_token;
                      }
                    m_input.m_line_index = 0;
                  }
                else
                  {
                    m_advance_stop = false;
                  }

                while (m_input.m_line_index < m_input.m_line_read
                       && true == CUtility.isspace(m_input.m_line[m_input.m_line_index]))
                  {
                    ++m_input.m_line_index;
                  }
                
                if (m_input.m_line_index < m_input.m_line_read)
                  {
                    break;
                  }
              }
          }
        
        /*if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_number = " + m_input.m_line_number);
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          CUtility.assert(m_input.m_line_index <= m_input.m_line_read);
        }*/
        if (CUtility.DEBUG) {
          CUtility.assert(m_input.m_line_index <= m_input.m_line_read);
        }

        /* Look for macro expansions. */
        if (false == m_spec.m_in_quote)
          {
            while ('{' == m_input.m_line[m_input.m_line_index])
              {
                expandMacro();

                /* End of line buffer? */
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line signifies the end of 
                       the current regular expression. */

                    m_spec.m_current_token = EOS;
                    m_spec.m_lexeme = '\0';
                    return m_spec.m_current_token;
                  }
              }
          }
            
        /*if (m_input.m_line_index) {
          System.out.println("**********2");
          System.out.println("m_spec.m_in_quote = " + m_spec.m_in_quote);
        }*/

        /*System.out.println("m_spec.m_in_quote = " + m_spec.m_in_quote);
        System.out.println("m_input.m_line_index = " + m_input.m_line_index);
        System.out.println("m_input.m_line_read = " + m_input.m_line_read);*/
        
        /* Look for quotation mark. */
        /* REMOVED */
        /*if ('\"' == m_input.m_line[m_input.m_line_index])*/
        /* REMOVED */
        /* ADDED */
        while ('\"' == m_input.m_line[m_input.m_line_index])
        /* ADDED */
          {
            /* Toggle in-quote status. */
            if (true == m_spec.m_in_quote)
              {
                m_spec.m_in_quote = false;
              }
            else
              {
                m_spec.m_in_quote = true;
              }
            /* ADDED */
            ++m_input.m_line_index;
            /* ADDED */

            if (m_input.m_line_index >= m_input.m_line_read)
              {
                /* End of line signifies the end of 
                   the current regular expression. */

                m_spec.m_current_token = EOS;
                m_spec.m_lexeme = '\0';
                return m_spec.m_current_token;
              }
          }

        if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          CUtility.assert(m_input.m_line_index <= m_input.m_line_read);
        }

        /* Look for backslash, and corresponding 
           escape sequence. */
        if ('\\' == m_input.m_line[m_input.m_line_index])
          {
            saw_escape = true;
          }
        else
          {
            saw_escape = false;
          }

        if (false == m_spec.m_in_quote)
          {
            if (CUtility.isspace(m_input.m_line[m_input.m_line_index]))
              {
                /* White space means the end of 
                   the current regular expression. */

                m_spec.m_current_token = EOS;
                m_spec.m_lexeme = '\0';
                return m_spec.m_current_token;
              }

            /* Process escape sequence, if needed. */
            if (true == saw_escape)
              {
                m_spec.m_lexeme = expandEscape();
              }
            else
              {
                m_spec.m_lexeme = m_input.m_line[m_input.m_line_index];
                ++m_input.m_line_index;
              }
          }
        else
          {
            if (true == saw_escape 
                && (m_input.m_line_index + 1) < m_input.m_line_read
                && '\"' == m_input.m_line[m_input.m_line_index + 1])
              {
                m_spec.m_lexeme = '\"';
                m_input.m_line_index = m_input.m_line_index + 2;
              }
            else
              {
                m_spec.m_lexeme = m_input.m_line[m_input.m_line_index];
                ++m_input.m_line_index;
              }
          }
        
        code = (Integer) m_tokens.get(new Character(m_spec.m_lexeme));
        if (true == m_spec.m_in_quote || true == saw_escape)
          {
            m_spec.m_current_token = L;
          }
        else
          {
            if (null == code)
              {
                m_spec.m_current_token = L;
              }
            else
              {
                m_spec.m_current_token = code.intValue();
              }
          }

        if (CUtility.FOODEBUG)
          {
            System.out.println("Lexeme: " + m_spec.m_lexeme
                               + "\tToken: " + m_spec.m_current_token
                               + "\tIndex: " + m_input.m_line_index);
          }

        return m_spec.m_current_token;
      }

  /***************************************************************
    Function: details
    Description: High level debugging routine.
    **************************************************************/
  private void details
    (
     )
      {
        Enumeration names;
        String name;
        String def;
        Enumeration states;
        String state;
        Integer index;
        int elem;
        int size;

        System.out.println("\n\t** Macros **");
        names = m_spec.m_macros.keys();
        while (true == names.hasMoreElements())
          {
            name = (String) names.nextElement();
            def = (String) m_spec.m_macros.get(name);

            if (CUtility.DEBUG)
              {
                CUtility.assert(null != name);
                CUtility.assert(null != def);
              }

            System.out.println("Macro name \"" + name 
                               + "\" has definition \"" 
                               + def + "\".");
          }

        System.out.println("\n\t** States **");
        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (CUtility.DEBUG)
              {
                CUtility.assert(null != state);
                CUtility.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");
          }
            
        System.out.println("\n\t** Character Counting **");
        if (false == m_spec.m_count_chars)
          {
            System.out.println("Character counting is off.");
          }
        else
          {
            if (CUtility.DEBUG)
              {
                CUtility.assert(true == m_spec.m_count_lines);
              }

            System.out.println("Character counting is on.");
          }

        System.out.println("\n\t** Line Counting **");
        if (false == m_spec.m_count_lines)
          {
            System.out.println("Line counting is off.");
          }
        else
          {
            if (CUtility.DEBUG)
              {
                CUtility.assert(true == m_spec.m_count_lines);
              }

            System.out.println("Line counting is on.");
          }

        System.out.println("\n\t** Operating System Specificity **");
        if (false == m_spec.m_unix)
          {
            System.out.println("Not generating UNIX-specific code.");
            System.out.println("(This means that \"\\r\\n\" is a "
                               + "newline, rather than \"\\n\".)");
          }
        else
          {
            System.out.println("Generating UNIX-specific code.");
            System.out.println("(This means that \"\\n\" is a " 
                               + "newline, rather than \"\\r\\n\".)");
          }

        System.out.println("\n\t** Java CUP Compatibility **");
        if (false == m_spec.m_cup_compatible)
          {
            System.out.println("Generating CUP compatible code.");
            System.out.println("(No current results.)");
          }
        else
          {
            System.out.println("Not generating CUP compatible code.");
            System.out.println("(No current results.)");
          }
        
        if (CUtility.FOODEBUG) {
          if (null != m_spec.m_nfa_states && null != m_spec.m_nfa_start)
            {
              System.out.println("\n\t** NFA machine **");
              print_nfa();
          }
        }

        if (null != m_spec.m_dtrans_vector)
          {
            System.out.println("\n\t** DFA transition table **");
            /*print_header();*/
          }

        /*if (null != m_spec.m_accept_vector && null != m_spec.m_anchor_array)
          {
            System.out.println("\n\t** Accept States and Anchor Vector **");
            print_accept();
          }*/
      }

  /***************************************************************
    function: print_set
    **************************************************************/
  void print_set
    (
     Vector nfa_set
     )
      {
        int size; 
        int elem;
        CNfa nfa;

        size = nfa_set.size();

        if (0 == size)
          {
            System.out.print("empty ");
          }
        
        for (elem = 0; elem < size; ++elem)
          {
            nfa = (CNfa) nfa_set.elementAt(elem);
            /*System.out.print(m_spec.m_nfa_states.indexOf(nfa) + " ");*/
            System.out.print(nfa.m_label + " ");
          }
      }

   /***************************************************************
     Function: print_header
     **************************************************************/
  private void print_header
    (
     )
      {
        Enumeration states;
        int i;
        int j;
        int chars_printed = 0;
        CDTrans dtrans;
        int last_transition;
        String str;
        CAccept accept;
        String state;
        Integer index;

        System.out.println("/*---------------------- DFA -----------------------");
        
        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (CUtility.DEBUG)
              {
                CUtility.assert(null != state);
                CUtility.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");

            i = index.intValue();
            if (CDTrans.F != m_spec.m_state_dtrans[i])
              {
                System.out.println("\tStart index in transition table: "
                                   + m_spec.m_state_dtrans[i]);
              }
            else
              {
                System.out.println("\tNo associated transition states.");
              }
          }

        for (i = 0; i < m_spec.m_dtrans_vector.size(); ++i)
          {
            dtrans = (CDTrans) m_spec.m_dtrans_vector.elementAt(i);

            if (null == m_spec.m_accept_vector && null == m_spec.m_anchor_array)
              {
                if (null == dtrans.m_accept)
                  {
                    System.out.print(" * State " + i + " [nonaccepting]");
                  }
                else
                  {
                    System.out.print(" * State " + i 
                                     + " [accepting, line "
                                     + dtrans.m_accept.m_line_number 
                                     + " <"
                                     + (new String(dtrans.m_accept.m_action,0,
                                                   dtrans.m_accept.m_action_read))
                                     + ">]");
                    if (CSpec.NONE != dtrans.m_anchor)
                      {
                        System.out.print(" Anchor: "
                                         + ((0 != (dtrans.m_anchor & CSpec.START)) 
                                            ? "start " : "")
                                         + ((0 != (dtrans.m_anchor & CSpec.END)) 
                                            ? "end " : ""));
                      }
                  }
              }
            else
              {
                accept = (CAccept) m_spec.m_accept_vector.elementAt(i);

                if (null == accept)
                  {
                    System.out.print(" * State " + i + " [nonaccepting]");
                  }
                else
                  {
                    System.out.print(" * State " + i 
                                     + " [accepting, line "
                                     + accept.m_line_number 
                                     + " <"
                                     + (new String(accept.m_action,0,
                                                   accept.m_action_read))
                                     + ">]");
                    if (CSpec.NONE != m_spec.m_anchor_array[i])
                      {
                        System.out.print(" Anchor: "
                                         + ((0 != (m_spec.m_anchor_array[i] & CSpec.START)) 
                                            ? "start " : "")
                                         + ((0 != (m_spec.m_anchor_array[i] & CSpec.END)) 
                                            ? "end " : ""));
                      }
                  }
              }

            last_transition = -1;
            for (j = 0; j < m_spec.m_dtrans_ncols; ++j)
              {
                if (CDTrans.F != dtrans.m_dtrans[j])
                  {
                    if (last_transition != dtrans.m_dtrans[j])
                      {
                        System.out.print("\n *    goto " + dtrans.m_dtrans[j]
                                         + " on ");
                        chars_printed = 0;
                      }
                    
                    str = interp_int((int) j);
                    System.out.print(str);
                                
                    chars_printed = chars_printed + str.length(); 
                    if (56 < chars_printed)
                      {
                        System.out.print("\n *             ");
                        chars_printed = 0;
                      }
                    
                    last_transition = dtrans.m_dtrans[j];
                  }
              }
            System.out.println("");
          }
        System.out.println(" */\n");
      }
}

/************************************************************************
  JAVA-LEX COPYRIGHT NOTICE, LICENSE AND DISCLAIMER.
  
  Copyright 1996 by Elliot Joel Berk
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both the copyright notice and this permission notice and warranty
  disclaimer appear in supporting documentation, and that the name of
  Elliot Joel Berk not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.
  
  Elliot Joel Berk disclaims all warranties with regard to this software, 
  including all implied warranties of merchantability and fitness.  In no event
  shall Elliot Joel Berk be liable for any special, indirect or consequential
  damages or any damages whatsoever resulting from loss of use, data or
  profits, whether in an action of contract, negligence or other
  tortious action, arising out of or in connection with the use or
  performance of this software.
  ***********************************************************************/




/**************************************************************
  Java-Lex: A Lexical Analyzer Generator for Java
  Written by Elliot Berk. Copyright 1996.
  Contact at ejberk@princeton.edu.

  Modified N.Shaylor
  08-Sep-96 - Change yy_lookahead, yy_advance(), and YYEOF to be int.
            - Zero yy_char_count every '\n'.
            - Put in a package and define all classes final.
            - Use nshaylor.util.BitSet that checks for the grow
              bug in JDK 1.0.

  07-Oct-96 - Add  yy_getcharArray();

  11-Oct-96 - Use nshaylor.jlx.BitSet that checks for the grow
  
  07-Nov-96 - Make yy_nxt, yy_rmap, yy_cmap, and yy_acpt short arrays
            - Make all constants like YYEOF static

  08-Nov-96 - Change yy_acpt, yy_this_accept, YY_NOT_ACCEPT, and
            - YY_NO_ANCHOR to byte

  11-Nov-96 - Use BufferedOutputStreams to spead things up?
            - Make all final variables static.

  17-Feb-97 - Remove BufferedOutputStreams. Somehow this causes a
              problem and the end of the output file is truncated.
              I don't have the time now to find out why, so we go back
              to the old slow way that works.

  *************************************************************/

/***************************************************************
  Package Declaration
  **************************************************************/
/* UNDONE: Uncomment this. */


/***************************************************************
  Imported Packages
  **************************************************************/



/******************************
  Questions:
  2) How should I use the Java package system
  to make my tool more modularized and
  coherent?

  Unimplemented:
  !) Fix BitSet issues -- expand only when necessary.
  2) Repeated accept rules.
  6) Clean up the BqnbvjuVj class and use buffered
  allocation.
  7) Reading and writing in Unicode.
  Use DataInputStream and DataOutputStream,
  along with writeUTF???
  8) Fix or at least annotate ^x bug.
  9) Add to spec about extending character set.
  10) making sure newlines are handled correctly
  and consistly with the m_unix flag
  11) m_verbose -- what should be done with it?
  12) turn lexical analyzer into a coherent
  Java package
  13) turn lexical analyzer generator into a
  coherent Java package
  16) pretty up generated code
  17) make it possible to have white space in
  regular expressions
  18) clean up all of the class files the lexer
  generator produces when it is compiled,
  and reduce this number in some way.
  24) character format to and from file: writeup
  and implementation
  25) Debug by testing all arcane regular expression cases.
  26) Look for and fix all UNDONE comments below.
  27) Fix package system.
  28) Clean up unnecessary classes.
  *****************************/

/***************************************************************
  Class: mfKigxveL
 **************************************************************/
final class mfKigxveL //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
    
  /* Lexical States. */
  Hashtable m_states; /* Hashtable taking state indices (Integer) 
                         to state name (String). */

  /* Regular Expression Macros. */ 
  Hashtable m_macros; /* Hashtable taking macro name (String)
                                to corresponding char buffer that
                                holds macro definition. */

  /* NFA Machine. */
  vjSXErPeE m_nfa_start; /* Start state of NFA machine. */
  Vector m_nfa_states; /* Vector of states, with index
                                 corresponding to label. */
  
  Vector m_state_rules[]; /* An array of Vectors of Integers.
                                    The ith Vector represents the lexical state
                                    with index i.  The contents of the ith 
                                    Vector are the indices of the NFA start
                                    states that can be matched while in
                                    the ith lexical state. */
                                    

  int m_state_dtrans[];

  /* DFA Machine. */
  Vector m_dfa_states; /* Vector of states, with index
                                 corresponding to label. */
  Hashtable m_dfa_sets; /* Hashtable taking set of NFA states
                                  to corresponding DFA state, 
                                  if the latter exists. */
  
  /* Accept States and Corresponding Anchors. */
  Vector m_accept_vector;
  int m_anchor_array[];

  /* Transition Table. */
  Vector m_dtrans_vector;
  int m_dtrans_ncols;
  int m_row_map[];
  int m_col_map[];

  /* Regular expression token variables. */
  int m_current_token;
  char m_lexeme;
  boolean m_in_quote;

  /* Verbose execturion flag. */
  boolean m_verbose;

  /* Java-Lex directives flags. */
  boolean m_integer_type;
  boolean m_intwrap_type;
  boolean m_yyeof;
  boolean m_count_chars;
  boolean m_count_lines;
  boolean m_cup_compatible;
  boolean m_unix;

  char m_init_code[];
  int m_init_read;

  char m_init_throw_code[];
  int m_init_throw_read;

  char m_class_code[];
  int m_class_read;

  char m_eof_code[];
  int m_eof_read;

  char m_eof_value_code[];
  int m_eof_value_read;

  char m_eof_throw_code[];
  int m_eof_throw_read;

  char m_yylex_throw_code[];
  int m_yylex_throw_read;

  /* Class, function, type names. */
  char m_class_name[] = {          
    'Y', 'y', 'l', 
    'e', 'x' 
    };
  char m_function_name[] = {
    'y', 'y', 'l', 
    'e', 'x' 
    };
  char m_type_name[] = {
    'Y', 'y', 't', 
    'o', 'k', 'e',
    'n'
    };

  /* Lexical Generator. */
  private pVfjIoLBv m_lexGen;

  /***************************************************************
    Constants
    ***********************************************************/
  static final int NONE = 0;
  static final int START = 1;
  static final int END = 2;
  
  /***************************************************************
    Function: mfKigxveL
    Description: Constructor.
    **************************************************************/
  mfKigxveL
    (
     pVfjIoLBv lexGen
     )
      {
        m_lexGen = lexGen;

        /* Initialize regular expression token variables. */
        m_current_token = m_lexGen.EOS;
        m_lexeme = '\0';
        m_in_quote = false;

        /* Initialize hashtable for lexer states. */
        m_states = new Hashtable();
        m_states.put(new String("YYINITIAL"),new Integer(m_states.size()));

        /* Initialize hashtable for lexical macros. */
        m_macros = new Hashtable();

        /* Initialize variables for lexer options. */
        m_integer_type = false;
        m_intwrap_type = false;
        m_count_lines = false;
        m_count_chars = false;
        m_cup_compatible = false;
        m_unix = true;
        m_yyeof = false;

        /* Initialize variables for Java-Lex runtime options. */
        m_verbose = true;

        m_nfa_start = null;
        m_nfa_states = new Vector();
        
        m_dfa_states = new Vector();
        m_dfa_sets = new Hashtable();

        m_dtrans_vector = new Vector();
        m_dtrans_ncols = GKmsrthmG.MAX_SEVEN_BIT + 1;
        m_row_map = null;
        m_col_map = null;

        m_accept_vector = null;
        m_anchor_array = null;

        m_init_code = null;
        m_init_read = 0;

        m_init_throw_code = null;
        m_init_throw_read = 0;

        m_yylex_throw_code = null;
        m_yylex_throw_read = 0;

        m_class_code = null;
        m_class_read = 0;

        m_eof_code = null;
        m_eof_read = 0;

        m_eof_value_code = null;
        m_eof_value_read = 0;

        m_eof_throw_code = null;
        m_eof_throw_read = 0;

        m_state_dtrans = null;

        m_state_rules = null;
      }
}

/***************************************************************
  Class: HNTNIcohS
  **************************************************************/
final class HNTNIcohS //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private mfKigxveL m_spec;
  private DataOutputStream m_outstream;

  /***************************************************************
    Constants: Anchor Types
    **************************************************************/
  private final int START = 1;
  private final int END = 2;
  private final int NONE = 4;

  /***************************************************************
    Constants
    **************************************************************/
  private final boolean EDBG = true;
  private final boolean NOT_EDBG = false;

  /***************************************************************
    Function: HNTNIcohS
    Description: Constructor.
    **************************************************************/
  HNTNIcohS
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: reset
    Description: Clears member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_spec = null;
        m_outstream = null;
      }

  /***************************************************************
    Function: set
    Description: Initializes member variables.
    **************************************************************/
  private void set
    (
     mfKigxveL spec,
     OutputStream outstream
     )
      {
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != spec);
            GKmsrthmG.assert(null != outstream);
          }

        m_spec = spec;
        m_outstream = new DataOutputStream(
                        /*new BufferedOutputStream(*/ outstream /*)*/ ); //**NS**
      }

  /***************************************************************
    Function: emit_imports
    Description: Emits import packages at top of 
    generated source file.
    **************************************************************/
  /*void emit_imports
    (
     mfKigxveL spec,
     OutputStream outstream
     )
      throws java.io.IOException      
        {
          set(spec,outstream);
          
          if (GKmsrthmG.DEBUG)
            {
              GKmsrthmG.assert(null != m_spec);
              GKmsrthmG.assert(null != m_outstream);
            }*/
          
          /*m_outstream.writeBytes("import java.lang.String;\n");
          m_outstream.writeBytes("import java.lang.System;\n");
          m_outstream.writeBytes("import java.io.DataInputStream;\n");
          m_outstream.writeBytes("import java.io.InputStream;\n");*/
        /*  
          reset();
        }*/
  
  /***************************************************************
    Function: print_details
    Description: Debugging output.
    **************************************************************/
  private void print_details
    (
     )
      {
        int i;
        int j;
        int next;
        int state;
        UKEULJtgQ dtrans;
        oNaJmmlAX accept;
        boolean tr;

        System.out.println("---------------------- Transition Table " 
                           + "----------------------");
        
        for (i = 0; i < m_spec.m_row_map.length; ++i)
          {
            System.out.print("State " + i);
            
            accept = (oNaJmmlAX) m_spec.m_accept_vector.elementAt(i);
            if (null == accept)
              {
                System.out.println(" [nonaccepting]");
              }
            else
              {
                System.out.println(" [accepting, line "
                                 + accept.m_line_number 
                                 + " <"
                                 + (new java.lang.String(accept.m_action,0,
                                               accept.m_action_read))
                                 + ">]");
              }
            dtrans = (UKEULJtgQ) m_spec.m_dtrans_vector.elementAt(m_spec.m_row_map[i]);
            
            tr = false;
            state = dtrans.m_dtrans[m_spec.m_col_map[0]];
            if (UKEULJtgQ.F != state)
              {
                tr = true;
                System.out.print("\tgoto " + state + " on [" + ((char) 0));
              }
            for (j = 1; j < m_spec.m_dtrans_ncols; ++j)
              {
                next = dtrans.m_dtrans[m_spec.m_col_map[j]];
                if (state == next)
                  {
                    if (UKEULJtgQ.F != state)
                      {
                        System.out.print((char) j);
                      }
                  }
                else
                  {
                    state = next;
                    if (true == tr)
                      {
                        System.out.println("]");
                        tr = false;
                      }
                    if (UKEULJtgQ.F != state)
                      {
                        tr = true;
                        System.out.print("\tgoto " + state + " on [" + ((char) j));
                      }
                  }
              }
            if (true == tr)
              {
                System.out.println("]");
              }
          }

        System.out.println("---------------------- Transition Table " 
                           + "----------------------");
      }

  /***************************************************************
    Function: emit
    Description: High-level access function to module.
    **************************************************************/
  void emit
    (
     mfKigxveL spec,
     OutputStream outstream
     )
      throws java.io.IOException      
        {
          set(spec,outstream);
          
          if (GKmsrthmG.DEBUG)
            {
              GKmsrthmG.assert(null != m_spec);
              GKmsrthmG.assert(null != m_outstream);
            }
          
          if (GKmsrthmG.OLD_DEBUG) {
            print_details();
          }

          emit_header();
          emit_construct();
          emit_helpers();
          emit_driver();
          emit_footer();
          
          reset();
        }

  /***************************************************************
    Function: emit_construct
    Description: Emits constructor, member variables,
    and constants.
    **************************************************************/
  private void emit_construct
    (
     )
      throws java.io.IOException
        {
          if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != m_spec);
            GKmsrthmG.assert(null != m_outstream);
          }
          
          /* Constants */
          m_outstream.writeBytes("\tprivate static final int YY_BUFFER_SIZE = 512;\n");  //**NS**

          m_outstream.writeBytes("\tprivate static final int YY_F = -1;\n");             //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_NO_STATE = -1;\n");      //**NS**

          m_outstream.writeBytes("\tprivate static final byte YY_NOT_ACCEPT = 0;\n");     //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_START = 1;\n");          //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_END = 2;\n");            //**NS**
          m_outstream.writeBytes("\tprivate static final byte YY_NO_ANCHOR = 4;\n");      //**NS**

          m_outstream.writeBytes("\tpublic static final int YYEOF = -1;\n");             //**NS**
          
          /* User specified class code. */
          if (null != m_spec.m_class_code)
            {
              m_outstream.writeBytes(new String(m_spec.m_class_code,0,
                                                m_spec.m_class_read));
            }

          /* Member Variables */
          m_outstream.writeBytes("\tprivate java.io.DataInputStream yy_instream;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_index;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_read;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_start;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_end;\n");
          m_outstream.writeBytes("\tprivate byte yy_buffer[];\n");
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\tprivate int yy_char_count;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\tprivate int yy_line_count;\n");
            }
          m_outstream.writeBytes("\tprivate int yy_lexical_state;\n");
          /*if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\tprivate int yy_buffer_prev_start;\n");
            }*/
          
          /* Function: constructor */
          m_outstream.writeBytes("\t");
          m_outstream.writeBytes(new String(m_spec.m_class_name));
          m_outstream.writeBytes(" (java.io.InputStream instream)");
          
          if (null != m_spec.m_init_throw_code)
            {
              m_outstream.writeBytes("\n"); 
              m_outstream.writeBytes("\t\tthrows "); 
              m_outstream.writeBytes(new String(m_spec.m_init_throw_code,0,
                                                m_spec.m_init_throw_read));
              m_outstream.writeBytes("\n\t\t{\n");
            }
          else
            {
              m_outstream.writeBytes(" {\n");
            }
          
          m_outstream.writeBytes("\t\tif (null == instream) {\n");
          m_outstream.writeBytes("\t\t\tthrow (new Error(\"Error: Bad input "
                                 + "stream initializer.\"));\n");
          m_outstream.writeBytes("\t\t}\n");
          m_outstream.writeBytes("\t\tyy_instream = new java.io.DataInputStream(instream);\n");
          m_outstream.writeBytes("\t\tyy_buffer = new byte[YY_BUFFER_SIZE];\n");
          m_outstream.writeBytes("\t\tyy_buffer_read = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_index = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_start = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_end = 0;\n");
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tyy_char_count = 0;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\tyy_line_count = 0;\n");
            }
          m_outstream.writeBytes("\t\tyy_lexical_state = YYINITIAL;\n");
          /*if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tyy_buffer_prev_start = 0;\n");
            }*/

          /* User specified constructor code. */
          if (null != m_spec.m_init_code)
            {
              m_outstream.writeBytes(new String(m_spec.m_init_code,0,
                                                m_spec.m_init_read));
            }

          m_outstream.writeBytes("\t}\n");
        }

  /***************************************************************
    Function: emit_states
    Description: Emits constants that serve as lexical states,
    including YYINITIAL.
    **************************************************************/
  private void emit_states
    (
     )
      throws java.io.IOException
        {
          Enumeration states;
          String state;
          int index;

          states = m_spec.m_states.keys();
          /*index = 0;*/
          while (true == states.hasMoreElements())
            {
              state = (String) states.nextElement();
              
              if (GKmsrthmG.DEBUG)
                {
                  GKmsrthmG.assert(null != state);
                }
              
              m_outstream.writeBytes("\tprivate final int " 
                                     + state 
                                     + " = " 
                                     + (m_spec.m_states.get(state)).toString() 
                                     + ";\n");
              /*++index;*/
            }

          m_outstream.writeBytes("\tprivate final int yy_state_dtrans[] = {\n");
          for (index = 0; index < m_spec.m_state_dtrans.length; ++index)
            {
              m_outstream.writeBytes("\t\t" + m_spec.m_state_dtrans[index]);
              if (index < m_spec.m_state_dtrans.length - 1)
                {
                  m_outstream.writeBytes(",\n");
                }
              else
                {
                  m_outstream.writeBytes("\n");
                }
            }
          m_outstream.writeBytes("\t};\n");
        }

  /***************************************************************
    Function: emit_helpers
    Description: Emits helper functions, particularly 
    error handling and input buffering.
    **************************************************************/
  private void emit_helpers
    (
     )
      throws java.io.IOException
      {
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != m_spec);
            GKmsrthmG.assert(null != m_outstream);
          }

        /* Function: yy_do_eof */
        m_outstream.writeBytes("\tprivate boolean yy_eof_done = false;\n");
        if (null != m_spec.m_eof_code)
          {
            m_outstream.writeBytes("\tprivate void yy_do_eof ()");

            if (null != m_spec.m_eof_throw_code)
              {
                m_outstream.writeBytes("\n"); 
                m_outstream.writeBytes("\t\tthrows "); 
                m_outstream.writeBytes(new String(m_spec.m_eof_throw_code,0,
                                                  m_spec.m_eof_throw_read));
                m_outstream.writeBytes("\n\t\t{\n");
              }
            else
              {
                m_outstream.writeBytes(" {\n");
              }

            m_outstream.writeBytes("\t\tif (false == yy_eof_done) {\n");
            m_outstream.writeBytes(new String(m_spec.m_eof_code,0,
                                              m_spec.m_eof_read));
            m_outstream.writeBytes("\t\t}\n");
            m_outstream.writeBytes("\t\tyy_eof_done = true;\n");
            m_outstream.writeBytes("\t}\n");
          }

        emit_states();
        
        /* Function: yybegin */
        m_outstream.writeBytes("\tprivate void yybegin (int state) {\n");
        m_outstream.writeBytes("\t\tyy_lexical_state = state;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_initial_dtrans */
        /*m_outstream.writeBytes("\tprivate int yy_initial_dtrans (int state) {\n");
        m_outstream.writeBytes("\t\treturn yy_state_dtrans[state];\n");
        m_outstream.writeBytes("\t}\n");*/

        /* Function: yy_advance */
        m_outstream.writeBytes("\tprivate int yy_advance ()\n"); //**NS**
        m_outstream.writeBytes("\t\tthrows java.io.IOException {\n");
        /*m_outstream.writeBytes("\t\t{\n");*/
        m_outstream.writeBytes("\t\tint next_read;\n");
        m_outstream.writeBytes("\t\tint i;\n");
        m_outstream.writeBytes("\t\tint j;\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\tif (yy_buffer_index < yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\treturn yy_buffer[yy_buffer_index++] & 0xFF;\n"); //**NS**
        /*m_outstream.writeBytes("\t\t\t++yy_buffer_index;\n");*/
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\tif (0 != yy_buffer_start) {\n");
        m_outstream.writeBytes("\t\t\ti = yy_buffer_start;\n");
        m_outstream.writeBytes("\t\t\tj = 0;\n");
        m_outstream.writeBytes("\t\t\twhile (i < yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\t\tyy_buffer[j] = yy_buffer[i];\n");
        m_outstream.writeBytes("\t\t\t\t++i;\n");
        m_outstream.writeBytes("\t\t\t\t++j;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_end = yy_buffer_end - yy_buffer_start;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_start = 0;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = j;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_index = j;\n");
        m_outstream.writeBytes("\t\t\tnext_read = yy_instream.read(yy_buffer,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        m_outstream.writeBytes("\t\t\t\treturn YYEOF;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\twhile (yy_buffer_index >= yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\tif (yy_buffer_index >= yy_buffer.length) {\n");
        m_outstream.writeBytes("\t\t\t\tyy_buffer = yy_double(yy_buffer);\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tnext_read = yy_instream.read(yy_buffer,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        m_outstream.writeBytes("\t\t\t\treturn YYEOF;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        m_outstream.writeBytes("\t\t}\n");

        m_outstream.writeBytes("\t\treturn yy_buffer[yy_buffer_index++] & 0xFF;\n"); //**NS**
        m_outstream.writeBytes("\t}\n");
        
        /* Function: yy_move_start */
        m_outstream.writeBytes("\tprivate void yy_move_start () {\n");
        if (true == m_spec.m_count_lines)
          {
            if (true == m_spec.m_unix)
              {
                m_outstream.writeBytes("\t\tif ((byte) '\\n' " 
                                       + "== yy_buffer[yy_buffer_start]) {\n");
              }
            else
              {         
                m_outstream.writeBytes("\t\tif ((byte) '\\n' " 
                                       + "== yy_buffer[yy_buffer_start]\n"); 
                m_outstream.writeBytes("\t\t\t|| (byte) '\\r' " 
                                       + "== yy_buffer[yy_buffer_start]) {\n");
              }
            m_outstream.writeBytes("\t\t\t++yy_line_count; yy_char_count = 0;\n"); //**NS**
            m_outstream.writeBytes("\t\t}\n");
          }
        if (true == m_spec.m_count_chars)
          {
            m_outstream.writeBytes("\t\t++yy_char_count;\n");
          }
        m_outstream.writeBytes("\t\t++yy_buffer_start;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_pushback */
        m_outstream.writeBytes("\tprivate void yy_pushback () {\n");
        m_outstream.writeBytes("\t\t--yy_buffer_end;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_mark_start */
        m_outstream.writeBytes("\tprivate void yy_mark_start () {\n");
        if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
          {
            if (true == m_spec.m_count_lines)
              {
                m_outstream.writeBytes("\t\tint i;\n");
                m_outstream.writeBytes("\t\tfor (i = yy_buffer_start; " 
                                       + "i < yy_buffer_index; ++i) {\n");
                if (true == m_spec.m_unix)
                  {
                    m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i]) {\n");
                  }
                else
                  {             
                    m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i] || " 
                                           + "(byte) '\\r' == yy_buffer[i]) {\n");
                  }
                m_outstream.writeBytes("\t\t\t\t++yy_line_count;  yy_char_count = 0;\n"); //**NS**
                m_outstream.writeBytes("\t\t\t}\n");
                m_outstream.writeBytes("\t\t++yy_char_count;\n"); //**NS**               
                m_outstream.writeBytes("\t\t}\n");
              }
            if (true == m_spec.m_count_chars)
              {
//**NS**                m_outstream.writeBytes("\t\tyy_char_count = yy_char_count\n"); 
//**NS**                m_outstream.writeBytes("\t\t\t+ yy_buffer_index - yy_buffer_start;\n");
              }
          }
        m_outstream.writeBytes("\t\tyy_buffer_start = yy_buffer_index;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_mark_end */
        m_outstream.writeBytes("\tprivate void yy_mark_end () {\n");
        m_outstream.writeBytes("\t\tyy_buffer_end = yy_buffer_index;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_to_mark */
        m_outstream.writeBytes("\tprivate void yy_to_mark () {\n");
        m_outstream.writeBytes("\t\tyy_buffer_index = yy_buffer_end;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_gettext */
        m_outstream.writeBytes("\tprivate java.lang.String yy_gettext () {\n");
        m_outstream.writeBytes("\t\treturn (new java.lang.String(yy_buffer,0,\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_start,\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_end - yy_buffer_start));\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_getcharArray */
        m_outstream.writeBytes("private char[] yy_getcharArray()\n"); 
        m_outstream.writeBytes("\t{\n");  	
        m_outstream.writeBytes("\tint  count   = yy_buffer_end - yy_buffer_start;\n");
        m_outstream.writeBytes("\tchar value[] = new char[count];\n");
        m_outstream.writeBytes("\tfor( int i = count ; i-- > 0 ; )\n");
        m_outstream.writeBytes("\t\tvalue[i] = (char) (yy_buffer[i + yy_buffer_start] & 0xff);\n");
        m_outstream.writeBytes("\treturn value;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_getchar */
        if (true == m_spec.m_count_chars)
          {
            m_outstream.writeBytes("\tprivate int yy_getchar () {\n");
            m_outstream.writeBytes("\t\treturn yy_char_count;\n");
            m_outstream.writeBytes("\t}\n");
          }

        /* Function: yy_getline */
        if (true == m_spec.m_count_lines)
          {
            m_outstream.writeBytes("\tprivate int yy_getline () {\n");
            m_outstream.writeBytes("\t\treturn yy_line_count;\n");
            m_outstream.writeBytes("\t}\n");
          }

        /* Function: yy_double */
        m_outstream.writeBytes("\tprivate byte[] yy_double (byte buf[]) {\n");
        m_outstream.writeBytes("\t\tint i;\n\t\tbyte newbuf[];\n");
        m_outstream.writeBytes("\t\tnewbuf = new byte[2*buf.length];\n");
        m_outstream.writeBytes("\t\tfor (i = 0; i < buf.length; ++i) {\n");
        m_outstream.writeBytes("\t\t\tnewbuf[i] = buf[i];\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\t\treturn newbuf;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_error */
        m_outstream.writeBytes("\tprivate final int YY_E_INTERNAL = 0;\n");
        m_outstream.writeBytes("\tprivate final int YY_E_MATCH = 1;\n");
        m_outstream.writeBytes("\tprivate java.lang.String yy_error_string[] = {\n");
        m_outstream.writeBytes("\t\t\"Error: Internal error.\\n\",\n");
        m_outstream.writeBytes("\t\t\"Error: Unmatched input.\\n\"\n");
        m_outstream.writeBytes("\t};\n");
        m_outstream.writeBytes("\tprivate void yy_error (int code,boolean fatal) {\n");
        m_outstream.writeBytes("\t\tjava.lang.System.out.print(yy_error_string[code]);\n");
        m_outstream.writeBytes("\t\tjava.lang.System.out.flush();\n");
        m_outstream.writeBytes("\t\tif (true == fatal) {\n");
        m_outstream.writeBytes("\t\t\tthrow new Error(\"Fatal Error.\\n\");\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_next */
        /*m_outstream.writeBytes("\tprivate int yy_next (int current,byte lookahead) {\n");
        m_outstream.writeBytes("\t\treturn yy_nxt[yy_rmap[current]][yy_cmap[lookahead]];\n");
        m_outstream.writeBytes("\t}\n");*/

        /* Function: yy_accept */
        /*m_outstream.writeBytes("\tprivate int yy_accept (int current) {\n");
        m_outstream.writeBytes("\t\treturn yy_acpt[current];\n");
        m_outstream.writeBytes("\t}\n");*/
      }

  /***************************************************************
    Function: emit_header
    Description: Emits class header.
    **************************************************************/
  private void emit_header
    (
     )
      throws java.io.IOException
      {
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != m_spec);
            GKmsrthmG.assert(null != m_outstream);
          }

        m_outstream.writeBytes("\n\nclass ");
        m_outstream.writeBytes(new String(m_spec.m_class_name,0,
                                          m_spec.m_class_name.length));
        m_outstream.writeBytes(" {\n");
      }

  /***************************************************************
    Function: emit_table
    Description: Emits transition table.
    **************************************************************/
  private void emit_table
    (
     )
      throws java.io.IOException
      {
        int i;
        int elem;
        int size;
        UKEULJtgQ dtrans;
        boolean is_start;
        boolean is_end;
        oNaJmmlAX accept;

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != m_spec);
            GKmsrthmG.assert(null != m_outstream);
          }

        m_outstream.writeBytes("\tprivate byte yy_acpt[] = {\n");  //**NS**
        size = m_spec.m_accept_vector.size();
        for (elem = 0; elem < size; ++elem)
          {
            accept = (oNaJmmlAX) m_spec.m_accept_vector.elementAt(elem);
            
            if (null != accept)
              {
                is_start = (0 != (m_spec.m_anchor_array[elem] & mfKigxveL.START));
                is_end = (0 != (m_spec.m_anchor_array[elem] & mfKigxveL.END));
                
                if (true == is_start && true == is_end)
                  {
                    m_outstream.writeBytes("\t\tYY_START | YY_END");
                  }
                else if (true == is_start)
                  {
                    m_outstream.writeBytes("\t\tYY_START");
                  }
                else if (true == is_end)
                  {
                    m_outstream.writeBytes("\t\tYY_END");
                  }
                else
                  {
                    m_outstream.writeBytes("\t\tYY_NO_ANCHOR");
                  }
              }
            else 
              {
                m_outstream.writeBytes("\t\tYY_NOT_ACCEPT");
              }
            
            if (elem < size - 1)
              {
                m_outstream.writeBytes(",");
              }
            
            m_outstream.writeBytes("\n");
          }
        m_outstream.writeBytes("\t};\n");

        m_outstream.writeBytes("\tprivate short yy_cmap[] = {\n\t\t");  //**NS**
        for (i = 0; i < m_spec.m_col_map.length; ++i)
          {
            m_outstream.writeBytes((new Integer(m_spec.m_col_map[i])).toString());
            
            if (i < m_spec.m_col_map.length - 1)
              {
                m_outstream.writeBytes(",");
              }

            if (0 == ((i + 1) % 8))
              {
                m_outstream.writeBytes("\n\t\t");
              }
            else
              {
                m_outstream.writeBytes(" ");
              }
          }
        m_outstream.writeBytes("\n\t};\n");

        m_outstream.writeBytes("\tprivate short yy_rmap[] = {\n\t\t");  //**NS**
        for (i = 0; i < m_spec.m_row_map.length; ++i)
          {
            m_outstream.writeBytes((new Integer(m_spec.m_row_map[i])).toString());
            
            if (i < m_spec.m_row_map.length - 1)
              {
                m_outstream.writeBytes(",");
              }

            if (0 == ((i + 1) % 8))
              {
                m_outstream.writeBytes("\n\t\t");
              }
            else
              {
                m_outstream.writeBytes(" ");
              }
          }
        m_outstream.writeBytes("\n\t};\n");

        m_outstream.writeBytes("\tprivate short yy_nxt[][] = {\n");  //**NS**
        size = m_spec.m_dtrans_vector.size();
        for (elem = 0; elem < size; ++elem)
          {
            dtrans = (UKEULJtgQ) m_spec.m_dtrans_vector.elementAt(elem);
            
            m_outstream.writeBytes("\t\t{ ");
        
            for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
              {
                m_outstream.writeBytes((new Integer(dtrans.m_dtrans[i])).toString());
                
                if (i < m_spec.m_dtrans_ncols - 1)
                  {
                    m_outstream.writeBytes(",");
                  }
                
                if (0 == ((i + 1) % 8))
                  {
                    m_outstream.writeBytes("\n\t\t\t");
                  }
                else
                  {
                    m_outstream.writeBytes(" ");
                  }
              }

            m_outstream.writeBytes("\n\t\t}");

            if (elem < size - 1)
              {
                m_outstream.writeBytes(",");
              }

            m_outstream.writeBytes("\n");
          }
        m_outstream.writeBytes("\t};\n");
      }

  /***************************************************************
    Function: emit_driver
    Description: 
    **************************************************************/
  private void emit_driver
    (
     )
      throws java.io.IOException
        {
          if (GKmsrthmG.DEBUG)
            {
              GKmsrthmG.assert(null != m_spec);
              GKmsrthmG.assert(null != m_outstream);
            }
          
          emit_table();

          if (true == m_spec.m_integer_type)
            {
              m_outstream.writeBytes("\tpublic int ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }
          else if (true == m_spec.m_intwrap_type)
            {
              m_outstream.writeBytes("\tpublic java.lang.Integer ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }
          else
            {
              m_outstream.writeBytes("\tpublic ");
              m_outstream.writeBytes(new String(m_spec.m_type_name));
              m_outstream.writeBytes(" ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }

          /*m_outstream.writeBytes("\t\tthrows java.io.IOException {\n");*/
          m_outstream.writeBytes("\t\tthrows java.io.IOException");
          if (null != m_spec.m_yylex_throw_code)
            {
              m_outstream.writeBytes(", "); 
              m_outstream.writeBytes(new String(m_spec.m_yylex_throw_code,0,
                                                m_spec.m_yylex_throw_read));
              m_outstream.writeBytes("\n\t\t{\n");
            }
          else
            {
              m_outstream.writeBytes(" {\n");
            }

          m_outstream.writeBytes("\t\tint yy_lookahead;\n");
          m_outstream.writeBytes("\t\tint yy_anchor = YY_NO_ANCHOR;\n");
          /*m_outstream.writeBytes("\t\tint yy_state "
            + "= yy_initial_dtrans(yy_lexical_state);\n");*/
          m_outstream.writeBytes("\t\tint yy_state " 
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\tint yy_next_state = YY_NO_STATE;\n");
          /*m_outstream.writeBytes("\t\tint yy_prev_state = YY_NO_STATE;\n");*/
          m_outstream.writeBytes("\t\tint yy_last_accept_state = YY_NO_STATE;\n");
          m_outstream.writeBytes("\t\tboolean yy_initial = true;\n");
          m_outstream.writeBytes("\t\tbyte yy_this_accept;\n"); // **NS**
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tint yychar;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\tint yyline;\n");
            }
          m_outstream.writeBytes("\t\tjava.lang.String yytext;\n");
          m_outstream.writeBytes("\n");

          m_outstream.writeBytes("\t\tyy_mark_start();\n");
          /*m_outstream.writeBytes("\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\tyy_mark_end();\n");
          m_outstream.writeBytes("\t\t}\n");

          if (NOT_EDBG)
            {
              m_outstream.writeBytes("\t\tjava.lang.System.out.println(\"Begin\");\n");
            }

          m_outstream.writeBytes("\t\twhile (true) {\n");

          m_outstream.writeBytes("\t\t\tyy_lookahead = yy_advance();\n");
          m_outstream.writeBytes("\t\t\tyy_next_state = YY_F;\n");
          m_outstream.writeBytes("\t\t\tif (YYEOF != yy_lookahead) {\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_next_state = "
                                 + "yy_next(yy_state,yy_lookahead);\n");*/
          m_outstream.writeBytes("\t\t\t\tyy_next_state = "
                                 + "yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];\n");
          
          m_outstream.writeBytes("\t\t\t}\n");

          if (NOT_EDBG)
            {
              m_outstream.writeBytes("java.lang.System.out.println(\"Current state: \"" 
                                     + " + yy_state\n");
              m_outstream.writeBytes("+ \"\tCurrent input: \"\n"); 
              m_outstream.writeBytes(" + ((char) yy_lookahead));\n");
            }
          if (NOT_EDBG)
            {
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"State = \"" 
                                     + "+ yy_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Accepting status = \"" 
                                     + "+ yy_this_accept);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Last accepting state = \"" 
                                     + "+ yy_last_accept_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Next state = \"" 
                                     + "+ yy_next_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Lookahead input = \"" 
                                     + "+ ((char) yy_lookahead));\n");
            }

          m_outstream.writeBytes("\t\t\tif (YY_F != yy_next_state) {\n");
          m_outstream.writeBytes("\t\t\t\tyy_state = yy_next_state;\n");
          m_outstream.writeBytes("\t\t\t\tyy_initial = false;\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_mark_end();\n");
          m_outstream.writeBytes("\t\t\t\t}\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_prev_state = yy_state;\n");*/
          /*m_outstream.writeBytes("\t\t\t\tyy_state = yy_next_state;\n");*/
          m_outstream.writeBytes("\t\t\t}\n");

          m_outstream.writeBytes("\t\t\telse {\n");
          m_outstream.writeBytes("\t\t\t\tif (YYEOF == yy_lookahead " 
                                 + "&& true == yy_initial) {\n");
          if (null != m_spec.m_eof_code)
            {
              m_outstream.writeBytes("\t\t\t\t\tyy_do_eof();\n");
            }

          if (true == m_spec.m_integer_type || true == m_spec.m_yyeof)
            {
              m_outstream.writeBytes("\t\t\t\t\treturn YYEOF;\n");
            }
          else if (null != m_spec.m_eof_value_code) 
            {
              m_outstream.writeBytes(new String(m_spec.m_eof_value_code,0,
                                                m_spec.m_eof_value_read));
            }
          else
            {
              m_outstream.writeBytes("\t\t\t\t\treturn null;\n");
            }

          m_outstream.writeBytes("\t\t\t\t}\n");
          
          m_outstream.writeBytes("\t\t\t\telse if (YY_NO_STATE == yy_last_accept_state) {\n");
          

          /*m_outstream.writeBytes("\t\t\t\t\tyy_error(YY_E_MATCH,false);\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_initial = true;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_state "
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_next_state = YY_NO_STATE;\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_prev_state = YY_NO_STATE;\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_mark_start();\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");*/

          m_outstream.writeBytes("\t\t\t\t\tthrow (new Error(\"Lexical Error: Unmatched Input.\"));\n");
          m_outstream.writeBytes("\t\t\t\t}\n");

          m_outstream.writeBytes("\t\t\t\telse {\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_to_mark();\n");

          m_outstream.writeBytes("\t\t\t\t\tyy_anchor = yy_acpt[yy_last_accept_state];\n");
          /*m_outstream.writeBytes("\t\t\t\t\tyy_anchor " 
            + "= yy_accept(yy_last_accept_state);\n");*/
          m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_END & yy_anchor)) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_pushback();\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");
          m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_START & yy_anchor)) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_move_start();\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");

          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\t\t\t\tyychar = yy_getchar();\n");
            }

          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\t\t\t\tyyline = yy_getline();\n");
            }

          m_outstream.writeBytes("\t\t\t\t\tyytext = yy_gettext();\n");

          m_outstream.writeBytes("\t\t\t\t\tswitch (yy_last_accept_state) {\n");

          emit_actions("\t\t\t\t\t");

          m_outstream.writeBytes("\t\t\t\t\tdefault:\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_error(YY_E_INTERNAL,false);\n");
          /*m_outstream.writeBytes("\t\t\t\t\t\treturn null;\n");*/
          m_outstream.writeBytes("\t\t\t\t\tcase -1:\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");
          
          m_outstream.writeBytes("\t\t\t\t\tyy_initial = true;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_state "
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_next_state = YY_NO_STATE;\n");
          /*m_outstream.writeBytes("\t\t\t\t\tyy_prev_state = YY_NO_STATE;\n");*/
          m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;\n");

          m_outstream.writeBytes("\t\t\t\t\tyy_mark_start();\n");

          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");

          m_outstream.writeBytes("\t\t\t\t}\n");          
          m_outstream.writeBytes("\t\t\t}\n");
          m_outstream.writeBytes("\t\t}\n");
          m_outstream.writeBytes("\t}\n");

          /*m_outstream.writeBytes("\t\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t}\n");*/
        }
  
  /***************************************************************
    Function: emit_actions
    Description:     
    **************************************************************/
  private void emit_actions 
    (
     String tabs
     )
      throws java.io.IOException
        {
          int elem;
          int size;
          int bogus_index;
          oNaJmmlAX accept;
          
          if (GKmsrthmG.DEBUG)
            {
              GKmsrthmG.assert(m_spec.m_accept_vector.size() 
                              == m_spec.m_anchor_array.length);
            }

          bogus_index = -2;
          size = m_spec.m_accept_vector.size();
          for (elem = 0; elem < size; ++elem)
            {
              accept = (oNaJmmlAX) m_spec.m_accept_vector.elementAt(elem);
              if (null != accept) 
                {
                  m_outstream.writeBytes(tabs + "case " + elem 
                                         /*+ (new Integer(elem)).toString()*/
                                         + ":\n");
                  m_outstream.writeBytes(tabs + "\t");
                  m_outstream.writeBytes(new String(accept.m_action,0,
                                                    accept.m_action_read));
                  m_outstream.writeBytes("\n");
                  m_outstream.writeBytes(tabs + "case " + bogus_index + ":\n");
                  m_outstream.writeBytes(tabs + "\tbreak;\n");
                  --bogus_index;
                }
            }
        }
  
  /***************************************************************
    Function: emit_footer
    Description:     
    **************************************************************/
  private void emit_footer
    (
     )
      throws java.io.IOException
      {
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != m_spec);
            GKmsrthmG.assert(null != m_outstream);
          }

        m_outstream.writeBytes("}\n");
      }
}

/***************************************************************
  Class: qfijWftDc
  **************************************************************/
final class qfijWftDc //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  Vector m_nfa_set; /* Vector of vjSXErPeE states in dfa state. */
  BitSet m_nfa_bit; /* BitSet representation of vjSXErPeE labels. */
  oNaJmmlAX m_accept; /* Accepting actions, or null if nonaccepting state. */
  int m_anchor; /* Anchors on regular expression. */
  int m_accept_index; /* vjSXErPeE index corresponding to accepting actions. */

  /***************************************************************
    Function: qfijWftDc
    Description: Constructor.
    **************************************************************/
  qfijWftDc
    (
     )
      {
        m_nfa_set = null;
        m_nfa_bit = null;
        m_accept = null;
        m_anchor = mfKigxveL.NONE;
        m_accept_index = -1;
      }
}

/***************************************************************
  Class: hVkqSwgOt
  **************************************************************/
final class hVkqSwgOt //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private mfKigxveL m_spec;
  private pVfjIoLBv m_lexGen;
  private kTqvpQzCV m_input;

  /***************************************************************
    Function: hVkqSwgOt
    Description: Constructor.
    **************************************************************/
  hVkqSwgOt
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: reset
    Description: Resets hVkqSwgOt member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_input = null;
        m_lexGen = null;
        m_spec = null;
      }

  /***************************************************************
    Function: set
    Description: Sets hVkqSwgOt member variables.
    **************************************************************/
  private void set
    (
     pVfjIoLBv lexGen,
     mfKigxveL spec,
     kTqvpQzCV input
     )
      {
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != input);
            GKmsrthmG.assert(null != lexGen);
            GKmsrthmG.assert(null != spec);
          }

        m_input = input;
        m_lexGen = lexGen;
        m_spec = spec;
      }

  /***************************************************************
    Function: thompson
    Description: High level access function to module.
    Deposits result in input mfKigxveL.
    **************************************************************/
  void thompson
    (
     pVfjIoLBv lexGen,
     mfKigxveL spec,
     kTqvpQzCV input
     )
      throws java.io.IOException      
        {       
          int i;
          vjSXErPeE elem;
          int size;

          /* Set member variables. */
          reset();
          set(lexGen,spec,input);
          size = m_spec.m_states.size();       
          m_spec.m_state_rules = new Vector[size];
          for (i = 0; i < size; ++i)
            {       
              m_spec.m_state_rules[i] = new Vector();
            }

          /* Initialize current token variable 
             and create nfa. */
          /*m_spec.m_current_token = m_lexGen.EOS;
          m_lexGen.advance();*/

          m_spec.m_nfa_start = machine();
          
          /* Set labels in created nfa machine. */
          size = m_spec.m_nfa_states.size();
          for (i = 0; i < size; ++i)
            {        
              elem = (vjSXErPeE) m_spec.m_nfa_states.elementAt(i);
              elem.m_label = i;
            }

          /* Debugging output. */
          if (GKmsrthmG.DO_DEBUG)
            {
              m_lexGen.print_nfa();
            }

          if (true == m_spec.m_verbose)
            {
              System.out.println("NFA comprised of " 
                                 + (m_spec.m_nfa_states.size() + 1) 
                                 + " states.");
            }

          reset();
        }
     
  /***************************************************************
    Function: discardvjSXErPeE
    Description: 
    **************************************************************/
  private void discardvjSXErPeE
    (
     vjSXErPeE nfa
     )
      {
        m_spec.m_nfa_states.removeElement(nfa);
      }

  /***************************************************************
    Function: processStates
    Description:
    **************************************************************/
  private void processStates
    (
     BitSet states,
     vjSXErPeE current
     )
      {
        int size;
        int i;
        
        size = m_spec.m_states.size();
        for (i = 0; i <  size; ++i)
          {
            if (true == states.get(i))
              {
                m_spec.m_state_rules[i].addElement(current);
              }
          }
      }

  /***************************************************************
    Function: machine
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private vjSXErPeE machine
    (
     )
      throws java.io.IOException 
      {
        vjSXErPeE start;
        vjSXErPeE p;
        BitSet states;

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.enter("machine",m_spec.m_lexeme,m_spec.m_current_token);
          }

        states = m_lexGen.getStates();

        /* Begin: Added for states. */
        m_spec.m_current_token = m_lexGen.EOS;
        m_lexGen.advance();
        /* End: Added for states. */
        
        start = BqnbvjuVj.newvjSXErPeE(m_spec);
        p = start;
        p.m_next = rule();

        processStates(states,p.m_next);

        while (m_lexGen.END_OF_INPUT != m_spec.m_current_token)
          {
            /* Make state changes HERE. */
            states = m_lexGen.getStates();
        
            /* Begin: Added for states. */
            m_lexGen.advance();
            if (m_lexGen.END_OF_INPUT == m_spec.m_current_token)
              { 
                break;
              }
            /* End: Added for states. */
            
            p.m_next2 = BqnbvjuVj.newvjSXErPeE(m_spec);
            p = p.m_next2;
            p.m_next = rule();
            
            processStates(states,p.m_next);
          }

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.leave("machine",m_spec.m_lexeme,m_spec.m_current_token);
          }

        return start;
      }
  
  /***************************************************************
    Function: rule
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private vjSXErPeE rule
    (
     )
      throws java.io.IOException 
      {
        MXrueHIOC pair; 
        vjSXErPeE p;
        vjSXErPeE start = null;
        vjSXErPeE end = null;
        int anchor = mfKigxveL.NONE;

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.enter("rule",m_spec.m_lexeme,m_spec.m_current_token);
          }

        pair = BqnbvjuVj.newMXrueHIOC();

        if (m_lexGen.AT_BOL == m_spec.m_current_token)
          {
            start = BqnbvjuVj.newvjSXErPeE(m_spec);
            start.m_edge = '\n';
            anchor = anchor | mfKigxveL.START;
            m_lexGen.advance();

            expr(pair);
            start.m_next = pair.m_start;
            end = pair.m_end;
          }
        else
          {
            expr(pair);
            start = pair.m_start;
            end = pair.m_end;
          }

        if (m_lexGen.AT_EOL == m_spec.m_current_token)
          {
            m_lexGen.advance();
            end.m_next = BqnbvjuVj.newvjSXErPeE(m_spec);
            
            /* This is the way he does it. */
            end.m_edge = vjSXErPeE.CCL;
            end.m_set = new JVUKgUbFW();

            end.m_set.add('\n');

            if (false == m_spec.m_unix)
              {
                end.m_set.add('\r');
              }
                
            end = end.m_next;
            anchor = anchor | mfKigxveL.END;
          }

        /* Handle end of regular expression.  See page 103. */
        end.m_accept = m_lexGen.packAccept();
        end.m_anchor = anchor;

        /* Begin: Removed for states. */
        /*m_lexGen.advance();*/
        /* End: Removed for states. */

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.leave("rule",m_spec.m_lexeme,m_spec.m_current_token);
          }

        return start;
      }
            
  /***************************************************************
    Function: expr
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void expr
    (
     MXrueHIOC pair
     )
      throws java.io.IOException 
      {
        MXrueHIOC e2_pair;
        vjSXErPeE p;
        
        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.enter("expr",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != pair);
          }

        e2_pair = BqnbvjuVj.newMXrueHIOC();

        cat_expr(pair);
        
        while (m_lexGen.OR == m_spec.m_current_token)
          {
            m_lexGen.advance();
            cat_expr(e2_pair);

            p = BqnbvjuVj.newvjSXErPeE(m_spec);
            p.m_next2 = e2_pair.m_start;
            p.m_next = pair.m_start;
            pair.m_start = p;
            
            p = BqnbvjuVj.newvjSXErPeE(m_spec);
            pair.m_end.m_next = p;
            e2_pair.m_end.m_next = p;
            pair.m_end = p;
          }

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.leave("expr",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
            
  /***************************************************************
    Function: cat_expr
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void cat_expr
    (
     MXrueHIOC pair
     )
      throws java.io.IOException 
      {
        MXrueHIOC e2_pair;

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.enter("cat_expr",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != pair);
          }
        
        e2_pair = BqnbvjuVj.newMXrueHIOC();
        
        if (true == first_in_cat(m_spec.m_current_token))
          {
            factor(pair);
          }

        while (true == first_in_cat(m_spec.m_current_token))
          {
            factor(e2_pair);

            /* Destroy */
            pair.m_end.mimic(e2_pair.m_start);
            discardvjSXErPeE(e2_pair.m_start);
            
            pair.m_end = e2_pair.m_end;
          }

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.leave("cat_expr",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
  
  /***************************************************************
    Function: first_in_cat
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private boolean first_in_cat
    (
     int token
     )
      {
        switch (token)
          {
          case m_lexGen.CLOSE_PAREN:
          case m_lexGen.AT_EOL:
          case m_lexGen.OR:
          case m_lexGen.EOS:
            return false;
            
          case m_lexGen.CLOSURE:
          case m_lexGen.PLUS_CLOSE:
          case m_lexGen.OPTIONAL:
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_CLOSE,m_input.m_line_number);
            return false;

          case m_lexGen.CCL_END:
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_BRACKET,m_input.m_line_number);
            return false;

          case m_lexGen.AT_BOL:
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_BOL,m_input.m_line_number);
            return false;

          default:
            break;
          }

        return true;
      }

  /***************************************************************
    Function: factor
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void factor
    (
     MXrueHIOC pair
     )
      throws java.io.IOException 
      {
        vjSXErPeE start = null;
        vjSXErPeE end = null;

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.enter("factor",m_spec.m_lexeme,m_spec.m_current_token);
          }

        term(pair);

        if (m_lexGen.CLOSURE == m_spec.m_current_token
            || m_lexGen.PLUS_CLOSE == m_spec.m_current_token
            || m_lexGen.OPTIONAL == m_spec.m_current_token)
          {
            start = BqnbvjuVj.newvjSXErPeE(m_spec);
            end = BqnbvjuVj.newvjSXErPeE(m_spec);
            
            start.m_next = pair.m_start;
            pair.m_end.m_next = end;

            if (m_lexGen.CLOSURE == m_spec.m_current_token
                || m_lexGen.OPTIONAL == m_spec.m_current_token)
              {
                start.m_next2 = end;
              }
            
            if (m_lexGen.CLOSURE == m_spec.m_current_token
                || m_lexGen.PLUS_CLOSE == m_spec.m_current_token)
              {
                pair.m_end.m_next2 = pair.m_start;
              }
            
            pair.m_start = start;
            pair.m_end = end;
            m_lexGen.advance();
          }

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.leave("factor",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
      
  /***************************************************************
    Function: term
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void term
    (
     MXrueHIOC pair
     )
      throws java.io.IOException 
      {
        vjSXErPeE start;
        int c;

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.enter("term",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (m_lexGen.OPEN_PAREN == m_spec.m_current_token)
          {
            m_lexGen.advance();
            expr(pair);

            if (m_lexGen.CLOSE_PAREN == m_spec.m_current_token)
              {
                m_lexGen.advance();
              }
            else
              {
                JJdTyoVCJ.parse_error(JJdTyoVCJ.E_SYNTAX,m_input.m_line_number);
              }
          }
        else
          {
            start = BqnbvjuVj.newvjSXErPeE(m_spec);
            pair.m_start = start;

            start.m_next = BqnbvjuVj.newvjSXErPeE(m_spec);
            pair.m_end = start.m_next;

            if (false == (m_lexGen.ANY == m_spec.m_current_token
                          || m_lexGen.CCL_START == m_spec.m_current_token))
              {
                start.m_edge = m_spec.m_lexeme;
                m_lexGen.advance();
              }
            else
              {
                start.m_edge = vjSXErPeE.CCL;
                
                start.m_set = new JVUKgUbFW();

                /* Match dot (.) using character class. */
                if (m_lexGen.ANY == m_spec.m_current_token)
                  {
                    start.m_set.add((byte) '\n');
                    if (false == m_spec.m_unix)
                      {
                        start.m_set.add((byte) '\r');
                      }
                    start.m_set.complement();
                  }
                else
                  {
                    m_lexGen.advance();
                    if (m_lexGen.AT_BOL == m_spec.m_current_token)
                      {
                        m_lexGen.advance();

                        /*start.m_set.add((byte) '\n');
                        if (false == m_spec.m_unix)
                          {
                            start.m_set.add((byte) '\r');
                          }*/
                        start.m_set.complement();
                      }
                    if (false == (m_lexGen.CCL_END == m_spec.m_current_token))
                      {
                        dodash(start.m_set);
                      }
                    /*else
                      {
                        for (c = 0; c <= ' '; ++c)
                          {
                            start.m_set.add((byte) c);
                          }
                      }*/
                  }
                m_lexGen.advance();
              }
          }

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.leave("term",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }

  /***************************************************************
    Function: dodash
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void dodash
    (
     JVUKgUbFW set
     )
      throws java.io.IOException 
        {
          int first = -1;
          
          if (GKmsrthmG.DESCENT_DEBUG)
            {
              GKmsrthmG.enter("dodash",m_spec.m_lexeme,m_spec.m_current_token);
            }
          
          while (m_lexGen.EOS != m_spec.m_current_token 
                 && m_lexGen.CCL_END != m_spec.m_current_token)
            {
              if (m_lexGen.DASH == m_spec.m_current_token)
                {
                  if (GKmsrthmG.DEBUG)
                    {
                      GKmsrthmG.assert(-1 != first);
                    }
                  
                  m_lexGen.advance();
                  for ( ; first <= m_spec.m_lexeme; ++first)
                    {
                      set.add(first);
                    }  
                }
              else
                {
                  first = m_spec.m_lexeme;
                  set.add(m_spec.m_lexeme);
                }

              m_lexGen.advance();
            }
          
        if (GKmsrthmG.DESCENT_DEBUG)
          {
            GKmsrthmG.leave("dodash",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
}

/***************************************************************
  Class: UHrTGYkQm
 **************************************************************/
final class UHrTGYkQm //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  mfKigxveL m_spec;
  Vector m_group;
  int m_ingroup[];

  /***************************************************************
    Function: UHrTGYkQm
    Description: Constructor.
    **************************************************************/
  UHrTGYkQm 
    (
     )
      {
        reset();
      }
  
  /***************************************************************
    Function: reset
    Description: Resets member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_spec = null;
        m_group = null;
        m_ingroup = null;
      }

  /***************************************************************
    Function: set
    Description: Sets member variables.
    **************************************************************/
  private void set
    (
     mfKigxveL spec
     )
      {
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != spec);
          }

        m_spec = spec;
        m_group = null;
        m_ingroup = null;
      }

  /***************************************************************
    Function: min_dfa
    Description: High-level access function to module.
    **************************************************************/
  void min_dfa
    (
     mfKigxveL spec
     )
      {
        set(spec);

        /* Remove redundant states. */
        minimize();

        /* Column and row compression. 
           Save accept states in auxilary vector. */
        reduce();

        reset();
      }

  /***************************************************************
    Function: col_copy
    Description: Copies source column into destination column.
    **************************************************************/
  private void col_copy
    (
     int dest,
     int src
     )
      {
        int n;
        int i;
        UKEULJtgQ dtrans;

        n = m_spec.m_dtrans_vector.size();
        for (i = 0; i < n; ++i)
          {
            dtrans = (UKEULJtgQ) m_spec.m_dtrans_vector.elementAt(i);
            dtrans.m_dtrans[dest] = dtrans.m_dtrans[src]; 
          }
      } 
        
  /***************************************************************
    Function: row_copy
    Description: Copies source row into destination row.
    **************************************************************/
  private void row_copy
    (
     int dest,
     int src
     )
      {
        UKEULJtgQ dtrans;

        dtrans = (UKEULJtgQ) m_spec.m_dtrans_vector.elementAt(src);
        m_spec.m_dtrans_vector.setElementAt(dtrans,dest); 
      } 
        
  /***************************************************************
    Function: col_equiv
    Description: 
    **************************************************************/
  private boolean col_equiv
    (
     int col1,
     int col2
     )
      {
        int n;
        int i;
        UKEULJtgQ dtrans;

        n = m_spec.m_dtrans_vector.size();
        for (i = 0; i < n; ++i)
          {
            dtrans = (UKEULJtgQ) m_spec.m_dtrans_vector.elementAt(i);
            if (dtrans.m_dtrans[col1] != dtrans.m_dtrans[col2]) 
              {
                return false;
              }
          }
        
        return true;
      }

  /***************************************************************
    Function: row_equiv
    Description: 
    **************************************************************/
  private boolean row_equiv
    (
     int row1,
     int row2
     )
      {
        int i;
        UKEULJtgQ dtrans1;
        UKEULJtgQ dtrans2;

        dtrans1 = (UKEULJtgQ) m_spec.m_dtrans_vector.elementAt(row1);
        dtrans2 = (UKEULJtgQ) m_spec.m_dtrans_vector.elementAt(row2);
        
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (dtrans1.m_dtrans[i] != dtrans2.m_dtrans[i]) 
              {
                return false;
              }
          }
        
        return true;
      }

  /***************************************************************
    Function: reduce
    Description: 
    **************************************************************/
  private void reduce
    (
     )
      {
        int i;
        int j;
        int k;
        int nrows;
        int reduced_ncols;
        int reduced_nrows;
        BitSet set;
        UKEULJtgQ dtrans;
        int size;

        set = new BitSet();
        
        /* Save accept nodes and anchor entries. */
        size = m_spec.m_dtrans_vector.size();
        m_spec.m_anchor_array = new int[size];
        m_spec.m_accept_vector = new Vector();
        for (i = 0; i < size; ++i)
          {
            dtrans = (UKEULJtgQ) m_spec.m_dtrans_vector.elementAt(i);
            m_spec.m_accept_vector.addElement(dtrans.m_accept);
            m_spec.m_anchor_array[i] = dtrans.m_anchor;
            dtrans.m_accept = null;
          }
        
        /* Allocate column map. */
        m_spec.m_col_map = new int[m_spec.m_dtrans_ncols];
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            m_spec.m_col_map[i] = -1;
          }

        /* Process columns for reduction. */
        for (reduced_ncols = 0; ; ++reduced_ncols)
          {
            if (true == GKmsrthmG.DEBUG)
              {
                for (i = 0; i < reduced_ncols; ++i)
                  {
                    GKmsrthmG.assert(-1 != m_spec.m_col_map[i]);
                  }
              }

            for (i = reduced_ncols; i < m_spec.m_dtrans_ncols; ++i)
              {
                if (-1 == m_spec.m_col_map[i])
                  {
                    break;
                  }
              }

            if (i >= m_spec.m_dtrans_ncols)
              {
                break;
              }

            if (true == GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(false == set.get(i));
                GKmsrthmG.assert(-1 == m_spec.m_col_map[i]);
              }

            set.set(i);
            
            m_spec.m_col_map[i] = reduced_ncols;
            
            /* UNDONE: Optimize by doing all comparisons in one batch. */
            for (j = i + 1; j < m_spec.m_dtrans_ncols; ++j)
              {
                if (-1 == m_spec.m_col_map[j] && true == col_equiv(i,j))
                  {
                    m_spec.m_col_map[j] = reduced_ncols;
                  }
              }
          }

        /* Reduce columns. */
        k = 0;
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (true == set.get(i))
              {
                ++k;

                set.clear(i);
                
                j = m_spec.m_col_map[i];
                
                if (true == GKmsrthmG.DEBUG)
                  {
                    GKmsrthmG.assert(j <= i);
                  }
                
                if (j == i)
                  {
                    continue;
                  }
                
                col_copy(j,i);
              }
          }
        m_spec.m_dtrans_ncols = reduced_ncols;

        if (true == GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(k == reduced_ncols);
          }

        /* Allocate row map. */
        nrows = m_spec.m_dtrans_vector.size();
        m_spec.m_row_map = new int[nrows];
        for (i = 0; i < nrows; ++i)
          {
            m_spec.m_row_map[i] = -1;
          }

        /* Process rows to reduce. */
        for (reduced_nrows = 0; ; ++reduced_nrows)
          {
            if (true == GKmsrthmG.DEBUG)
              {
                for (i = 0; i < reduced_nrows; ++i)
                  {
                    GKmsrthmG.assert(-1 != m_spec.m_row_map[i]);
                  }
              }

            for (i = reduced_nrows; i < nrows; ++i)
              {
                if (-1 == m_spec.m_row_map[i])
                  {
                    break;
                  }
              }

            if (i >= nrows)
              {
                break;
              }

            if (true == GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(false == set.get(i));
                GKmsrthmG.assert(-1 == m_spec.m_row_map[i]);
              }

            set.set(i);

            m_spec.m_row_map[i] = reduced_nrows;
            
            /* UNDONE: Optimize by doing all comparisons in one batch. */
            for (j = i + 1; j < nrows; ++j)
              {
                if (-1 == m_spec.m_row_map[j] && true == row_equiv(i,j))
                  {
                    m_spec.m_row_map[j] = reduced_nrows;
                  }
              }
          }

        /* Reduce rows. */
        k = 0;
        for (i = 0; i < nrows; ++i)
          {
            if (true == set.get(i))
              {
                ++k;

                set.clear(i);
                
                j = m_spec.m_row_map[i];
                
                if (true == GKmsrthmG.DEBUG)
                  {
                    GKmsrthmG.assert(j <= i);
                  }
                
                if (j == i)
                  {
                    continue;
                  }
                
                row_copy(j,i);
              }
          }
        m_spec.m_dtrans_vector.setSize(reduced_nrows);

        if (GKmsrthmG.DEBUG)
          {
            /*System.out.print("k = " + k + "\nreduced_nrows = " + reduced_nrows + "\n");*/
            GKmsrthmG.assert(k == reduced_nrows);
          }
      }

  /***************************************************************
    Function: fix_dtrans
    Description: Updates UKEULJtgQ table after minimization 
    using groups, removing redundant transition table states.
    **************************************************************/
  private void fix_dtrans
    (
     )
      {
        Vector new_vector;
        int i;
        int size;
        Vector dtrans_group;
        UKEULJtgQ first;
        int c;

        new_vector = new Vector();

        size = m_spec.m_state_dtrans.length;
        for (i = 0; i < size; ++i)
          {
            if (UKEULJtgQ.F != m_spec.m_state_dtrans[i])
              {
                m_spec.m_state_dtrans[i] = m_ingroup[m_spec.m_state_dtrans[i]];
              }
          }

        size = m_group.size();
        for (i = 0; i < size; ++i)
          {
            dtrans_group = (Vector) m_group.elementAt(i);
            first = (UKEULJtgQ) dtrans_group.elementAt(0);
            new_vector.addElement(first);

            for (c = 0; c < m_spec.m_dtrans_ncols; ++c)
              {
                if (UKEULJtgQ.F != first.m_dtrans[c])
                  {
                    first.m_dtrans[c] = m_ingroup[first.m_dtrans[c]];
                  }
              }
          }

        m_group = null;
        m_spec.m_dtrans_vector = new_vector;
      }

  /***************************************************************
    Function: minimize
    Description: Removes redundant transition table states.
    **************************************************************/
  private void minimize
    (
     )
      {
        Vector dtrans_group;
        Vector new_group;
        int i;
        int j;
        int old_group_count;
        int group_count;
        UKEULJtgQ next;
        UKEULJtgQ first;
        int goto_first;
        int goto_next;
        int c;
        int group_size;
        boolean added;

        init_groups();

        group_count = m_group.size();
        old_group_count = group_count - 1;

        while (old_group_count != group_count)
          {
            old_group_count = group_count;

            if (GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(m_group.size() == group_count);
              }

            for (i = 0; i < group_count; ++i)
              {
                dtrans_group = (Vector) m_group.elementAt(i);

                group_size = dtrans_group.size();
                if (group_size <= 1)
                  {
                    continue;
                  }

                new_group = new Vector();
                added = false;
                
                first = (UKEULJtgQ) dtrans_group.elementAt(0);
                for (j = 1; j < group_size; ++j)
                  {
                    next = (UKEULJtgQ) dtrans_group.elementAt(j);

                    for (c = 0; c < m_spec.m_dtrans_ncols; ++c)
                      {
                        goto_first = first.m_dtrans[c];
                        goto_next = next.m_dtrans[c];

                        if (goto_first != goto_next
                            && (goto_first == UKEULJtgQ.F
                                || goto_next == UKEULJtgQ.F
                                || m_ingroup[goto_next] != m_ingroup[goto_first]))
                          {
                            if (GKmsrthmG.DEBUG)
                              {
                                GKmsrthmG.assert(dtrans_group.elementAt(j) == next);
                              }
                            
                            dtrans_group.removeElementAt(j);
                            --j;
                            --group_size;
                            new_group.addElement(next);
                            if (false == added)
                              {
                                added = true;
                                ++group_count;
                                m_group.addElement(new_group);
                              }
                            m_ingroup[next.m_label] = m_group.size() - 1;

                            if (GKmsrthmG.DEBUG)
                              {
                                GKmsrthmG.assert(m_group.contains(new_group)
                                                == true);
                                GKmsrthmG.assert(m_group.contains(dtrans_group)
                                                == true);
                                GKmsrthmG.assert(dtrans_group.contains(first)
                                                == true);
                                GKmsrthmG.assert(dtrans_group.contains(next)
                                                == false);
                                GKmsrthmG.assert(new_group.contains(first)
                                                == false);
                                GKmsrthmG.assert(new_group.contains(next)
                                                == true);
                                GKmsrthmG.assert(dtrans_group.size() == group_size);
                                GKmsrthmG.assert(i == m_ingroup[first.m_label]);
                                GKmsrthmG.assert((m_group.size() - 1) 
                                                == m_ingroup[next.m_label]);
                              }

                            break;
                          }
                      }
                  }
              }
          }

        System.out.println(m_group.size() + " states after removal of redundant states.");

        if (true == m_spec.m_verbose
            && true == GKmsrthmG.OLD_DUMP_DEBUG)
          {
            System.out.println("\nStates grouped as follows after minimization");
            pgroups();
          }

        fix_dtrans();
      }

  /***************************************************************
    Function: init_groups
    Description:
    **************************************************************/
  private void init_groups
    (
     )
      {
        int i;
        int j;
        int group_count;
        int size;
        oNaJmmlAX accept;
        UKEULJtgQ dtrans;
        Vector dtrans_group;
        UKEULJtgQ first;
        boolean group_found;

        m_group = new Vector();
        group_count = 0;
        
        size = m_spec.m_dtrans_vector.size();
        m_ingroup = new int[size];
        
        for (i = 0; i < size; ++i)
          {
            group_found = false;
            dtrans = (UKEULJtgQ) m_spec.m_dtrans_vector.elementAt(i);

            if (GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(i == dtrans.m_label);
                GKmsrthmG.assert(false == group_found);
                GKmsrthmG.assert(group_count == m_group.size());
              }
            
            for (j = 0; j < group_count; ++j)
              {
                dtrans_group = (Vector) m_group.elementAt(j);
                
                if (GKmsrthmG.DEBUG)
                  {
                    GKmsrthmG.assert(false == group_found);
                    GKmsrthmG.assert(0 < dtrans_group.size());
                  }

                first = (UKEULJtgQ) dtrans_group.elementAt(0);
                
                if (GKmsrthmG.SLOW_DEBUG)
                  {
                    UKEULJtgQ check;
                    int k;
                    int s;

                    s = dtrans_group.size();
                    GKmsrthmG.assert(0 < s);

                    for (k = 1; k < s; ++k)
                      {
                        check = (UKEULJtgQ) dtrans_group.elementAt(k);
                        GKmsrthmG.assert(check.m_accept == first.m_accept);
                      }
                  }

                if (first.m_accept == dtrans.m_accept)
                  {
                    dtrans_group.addElement(dtrans);
                    m_ingroup[i] = j;
                    group_found = true;
                    
                    if (GKmsrthmG.DEBUG)
                      {
                        GKmsrthmG.assert(j == m_ingroup[dtrans.m_label]);
                      }

                    break;
                  }
              }
            
            if (false == group_found)
              {
                dtrans_group = new Vector();
                dtrans_group.addElement(dtrans);
                m_ingroup[i] = m_group.size();
                m_group.addElement(dtrans_group);
                ++group_count;
              }
          }
        
        if (true == m_spec.m_verbose
            && true == GKmsrthmG.OLD_DUMP_DEBUG)
          {
            System.out.println("Initial grouping:");
            pgroups();
            System.out.println("");
          }
      }

  /***************************************************************
    Function: pset
    **************************************************************/
  private void pset
    (
     Vector dtrans_group
     )
      {
        int i;
        int size;
        UKEULJtgQ dtrans;

        size = dtrans_group.size();
        for (i = 0; i < size; ++i)
          {
            dtrans = (UKEULJtgQ) dtrans_group.elementAt(i);
            System.out.print(dtrans.m_label + " ");
          }
      }
  
  /***************************************************************
    Function: pgroups
    **************************************************************/
  private void pgroups
    (
     )
      {
        int i;
        int dtrans_size;
        int group_size;
        
        group_size = m_group.size();
        for (i = 0; i < group_size; ++i)
          {
            System.out.print("\tGroup " + i + " {");
            pset((Vector) m_group.elementAt(i));
            System.out.println("}\n");
          }
        
        System.out.println("");
        dtrans_size = m_spec.m_dtrans_vector.size();
        for (i = 0; i < dtrans_size; ++i)
          {
            System.out.println("\tstate " + i 
                               + " is in group " 
                               + m_ingroup[i]);
          }
      }
}

/***************************************************************
  Class: FOmkezwmz
 **************************************************************/
final class FOmkezwmz //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private mfKigxveL m_spec;
  private int m_unmarked_dfa;
  private pVfjIoLBv m_lexGen;

  /***************************************************************
    Constants
    **************************************************************/
  private static final int NOT_IN_DSTATES = -1;

  /***************************************************************
    Function: FOmkezwmz
    **************************************************************/
  FOmkezwmz
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: set 
    Description: 
    **************************************************************/
  private void set
    (
     pVfjIoLBv lexGen,
     mfKigxveL spec
     )
      {
        m_lexGen = lexGen;
        m_spec = spec;
        m_unmarked_dfa = 0;
      }

  /***************************************************************
    Function: reset 
    Description: 
    **************************************************************/
  private void reset
    (
     )
      {
        m_lexGen = null;
        m_spec = null;
        m_unmarked_dfa = 0;
      }

  /***************************************************************
    Function: make_dfa
    Description: High-level access function to module.
    **************************************************************/
  void make_dfa
    (
     pVfjIoLBv lexGen,
     mfKigxveL spec
     )
      {
        int i;

        reset();
        set(lexGen,spec);

        make_dtrans();
        free_nfa_states();

        if (true == m_spec.m_verbose && true == GKmsrthmG.OLD_DUMP_DEBUG)
          {
            System.out.println(m_spec.m_dfa_states.size()
                               + " DFA states in original machine.");
          }

        free_dfa_states();
      }     

   /***************************************************************
    Function: make_dtrans
    Description: Creates uncompressed UKEULJtgQ transition table.
    **************************************************************/
  private void make_dtrans
    (
     )
     /* throws java.lang.CloneNotSupportedException*/
      {
        GLrwerhps next;
        GLrwerhps dfa;
        qfijWftDc bunch;
        int i;
        int nextstate;
        int size;
        UKEULJtgQ dtrans;
        vjSXErPeE nfa;
        int istate;
        int nstates;
        
        System.out.print("Working on DFA states.");

        /* Reference passing type and initializations. */
        bunch = new qfijWftDc();
        m_unmarked_dfa = 0;

        /* Allocate mapping array. */
        nstates = m_spec.m_state_rules.length;
        m_spec.m_state_dtrans = new int[nstates];

        for (istate = 0; nstates > istate; ++istate)
          {
            if (0 == m_spec.m_state_rules[istate].size())
              {
                m_spec.m_state_dtrans[istate] = UKEULJtgQ.F;
                continue;
              }
                
            /* Create start state and initialize fields. */
            bunch.m_nfa_set = (Vector) m_spec.m_state_rules[istate].clone();
            sortStates(bunch.m_nfa_set);
            
            bunch.m_nfa_bit = new BitSet();
            
            /* Initialize bit set. */
            size = bunch.m_nfa_set.size();
            for (i = 0; size > i; ++i)
              {
                nfa = (vjSXErPeE) bunch.m_nfa_set.elementAt(i);
                bunch.m_nfa_bit.set(nfa.m_label);
              }
            
            bunch.m_accept = null;
            bunch.m_anchor = mfKigxveL.NONE;
            bunch.m_accept_index = GKmsrthmG.INT_MAX;
            
            e_closure(bunch);
            add_to_dstates(bunch);
            
            m_spec.m_state_dtrans[istate] = m_spec.m_dtrans_vector.size();

            /* Main loop of UKEULJtgQ creation. */
            while (null != (dfa = get_unmarked()))
              {
                System.out.print(".");
                System.out.flush();
                
                if (GKmsrthmG.DEBUG)
                  {
                    GKmsrthmG.assert(false == dfa.m_mark);
                  }

                /* Get first unmarked node, then mark it. */
                dfa.m_mark = true;
                
                /* Allocate new UKEULJtgQ, then initialize fields. */
                dtrans = new UKEULJtgQ(m_spec.m_dtrans_vector.size(),m_spec);
                dtrans.m_accept = dfa.m_accept;
                dtrans.m_anchor = dfa.m_anchor;
                
                /* Set UKEULJtgQ array for each character transition. */
                for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
                  {
                    if (GKmsrthmG.DEBUG)
                      {
                        GKmsrthmG.assert(0 <= i);
                        GKmsrthmG.assert(m_spec.m_dtrans_ncols > i);
                      }
                    
                    /* Create new dfa set by attempting character transition. */
                    move(dfa.m_nfa_set,dfa.m_nfa_bit,i,bunch);
                    if (null != bunch.m_nfa_set)
                      {
                        e_closure(bunch);
                      }
                    
                    if (GKmsrthmG.DEBUG)
                      {
                        GKmsrthmG.assert((null == bunch.m_nfa_set 
                                         && null == bunch.m_nfa_bit)
                                        || (null != bunch.m_nfa_set 
                                            && null != bunch.m_nfa_bit));
                      }
                    
                    /* Create new state or set state to empty. */
                    if (null == bunch.m_nfa_set)
                      {
                        nextstate = UKEULJtgQ.F;
                      }
                    else 
                      {
                        nextstate = in_dstates(bunch);
                        
                        if (NOT_IN_DSTATES == nextstate)
                          {
                            nextstate = add_to_dstates(bunch);
                          }
                      }
                    
                    if (GKmsrthmG.DEBUG)
                      {
                        GKmsrthmG.assert(nextstate < m_spec.m_dfa_states.size());
                      }
                    
                    dtrans.m_dtrans[i] = nextstate;
                  }
                
                if (GKmsrthmG.DEBUG)
                  {
                    GKmsrthmG.assert(m_spec.m_dtrans_vector.size() == dfa.m_label);
                  }
                
                m_spec.m_dtrans_vector.addElement(dtrans);
              }
          }

        System.out.println("");
      }

  /***************************************************************
    Function: free_dfa_states
    **************************************************************/  
  private void free_dfa_states
    (
     )
      {
        m_spec.m_dfa_states = null;
        m_spec.m_dfa_sets = null;
      }

  /***************************************************************
    Function: free_nfa_states
    **************************************************************/  
  private void free_nfa_states
    (
     )
      {
        /* UNDONE: Remove references to nfas from within dfas. */
        /* UNDONE: Don't free CAccepts. */

        m_spec.m_nfa_states = null;
        m_spec.m_nfa_start = null;
        m_spec.m_state_rules = null;
      }

  /***************************************************************
    Function: e_closure
    Description: Alters and returns input set.
    **************************************************************/
  private void e_closure
    (
     qfijWftDc bunch
     )
      {
        Stack nfa_stack;
        int size;
        int i;
        vjSXErPeE state;

        /* Debug checks. */
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != bunch);
            GKmsrthmG.assert(null != bunch.m_nfa_set);
            GKmsrthmG.assert(null != bunch.m_nfa_bit);
          }

        bunch.m_accept = null;
        bunch.m_anchor = mfKigxveL.NONE;
        bunch.m_accept_index = GKmsrthmG.INT_MAX;
        
        /* Create initial stack. */
        nfa_stack = new Stack();
        size = bunch.m_nfa_set.size();
        for (i = 0; i < size; ++i)
          {
            state = (vjSXErPeE) bunch.m_nfa_set.elementAt(i);
            
            if (GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(true == bunch.m_nfa_bit.get(state.m_label));
              }

            nfa_stack.push(state);
          }

        /* Main loop. */
        while (false == nfa_stack.empty())
          {
            state = (vjSXErPeE) nfa_stack.pop();
            
            if (GKmsrthmG.OLD_DUMP_DEBUG)
              {
                if (null != state.m_accept)
                  {
                    System.out.println("Looking at accepting state " + state.m_label
                                       + " with <"
                                       + (new String(state.m_accept.m_action,0,
                                                     state.m_accept.m_action_read))
                                       + ">");
                  }
              }

            if (null != state.m_accept 
                && state.m_label < bunch.m_accept_index)
              {
                bunch.m_accept_index = state.m_label;
                bunch.m_accept = state.m_accept;
                bunch.m_anchor = state.m_anchor;

                if (GKmsrthmG.OLD_DUMP_DEBUG)
                  {
                    System.out.println("Found accepting state " + state.m_label
                                       + " with <"
                                       + (new String(state.m_accept.m_action,0,
                                                     state.m_accept.m_action_read))
                                       + ">");
                  }

                if (GKmsrthmG.DEBUG)
                  {
                    GKmsrthmG.assert(null != bunch.m_accept);
                    GKmsrthmG.assert(mfKigxveL.NONE == bunch.m_anchor
                                    || 0 != (bunch.m_anchor & mfKigxveL.END)
                                    || 0 != (bunch.m_anchor & mfKigxveL.START));
                  }
              }

            if (vjSXErPeE.EPSILON == state.m_edge)
              {
                if (null != state.m_next)
                  {
                    if (false == bunch.m_nfa_set.contains(state.m_next))
                      {
                        if (GKmsrthmG.DEBUG)
                          {
                            GKmsrthmG.assert(false == bunch.m_nfa_bit.get(state.m_next.m_label));
                          }
                        
                        bunch.m_nfa_bit.set(state.m_next.m_label);
                        bunch.m_nfa_set.addElement(state.m_next);
                        nfa_stack.push(state.m_next);
                      }
                  }

                if (null != state.m_next2)
                  {
                    if (false == bunch.m_nfa_set.contains(state.m_next2))
                      {
                        if (GKmsrthmG.DEBUG)
                          {
                            GKmsrthmG.assert(false == bunch.m_nfa_bit.get(state.m_next2.m_label));
                          }
                        
                        bunch.m_nfa_bit.set(state.m_next2.m_label);
                        bunch.m_nfa_set.addElement(state.m_next2);
                        nfa_stack.push(state.m_next2);
                      }
                  }
              }
          }

        if (null != bunch.m_nfa_set)
          {
            sortStates(bunch.m_nfa_set);
          }

        return;
      }

  /***************************************************************
    Function: move
    Description: Returns null if resulting NFA set is empty.
    **************************************************************/
  void move
    (
     Vector nfa_set,
     BitSet nfa_bit,
     int b,
     qfijWftDc bunch
     )
      {
        int size;
        int index;
        vjSXErPeE state;
        
        bunch.m_nfa_set = null;
        bunch.m_nfa_bit = null;

        size = nfa_set.size();
        for (index = 0; index < size; ++index)
          {
            state = (vjSXErPeE) nfa_set.elementAt(index);
            
            if (b == state.m_edge
                || (vjSXErPeE.CCL == state.m_edge
                    && true == state.m_set.contains(b)))
              {
                if (null == bunch.m_nfa_set)
                  {
                    if (GKmsrthmG.DEBUG)
                      {
                        GKmsrthmG.assert(null == bunch.m_nfa_bit);
                      }
                    
                    bunch.m_nfa_set = new Vector();
                    bunch.m_nfa_bit = new BitSet(m_spec.m_nfa_states.size());
                    /*bunch.m_nfa_bit = new BitSet();*/
                  }

                bunch.m_nfa_set.addElement(state.m_next);
                /*System.out.println("Size of bitset: " + bunch.m_nfa_bit.size());
                System.out.println("Reference index: " + state.m_next.m_label);
                System.out.flush();*/
                bunch.m_nfa_bit.set(state.m_next.m_label);
              }
          }
        
        if (null != bunch.m_nfa_set)
          {
            if (GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(null != bunch.m_nfa_bit);
              }
            
            sortStates(bunch.m_nfa_set);
          }

        return;
      }

  /***************************************************************
    Function: sortStates
    **************************************************************/
  private void sortStates
    (
     Vector nfa_set
     )
      {
        vjSXErPeE elem;
        int begin;
        int size;
        int index;
        int value;
        int smallest_index;
        int smallest_value;
        vjSXErPeE begin_elem;

        size = nfa_set.size();
        for (begin = 0; begin < size; ++begin)
          {
            elem = (vjSXErPeE) nfa_set.elementAt(begin);
            smallest_value = elem.m_label;
            smallest_index = begin;

            for (index = begin + 1; index < size; ++index)
              {
                elem = (vjSXErPeE) nfa_set.elementAt(index);
                value = elem.m_label;

                if (value < smallest_value)
                  {
                    smallest_index = index;
                    smallest_value = value;
                  }
              }

            begin_elem = (vjSXErPeE) nfa_set.elementAt(begin);
            elem = (vjSXErPeE) nfa_set.elementAt(smallest_index);
            nfa_set.setElementAt(elem,begin);
            nfa_set.setElementAt(begin_elem,smallest_index);
          }

        if (true == GKmsrthmG.OLD_DEBUG)
          {
            System.out.print("NFA vector indices: ");  
            
            for (index = 0; index < size; ++index)
              {
                elem = (vjSXErPeE) nfa_set.elementAt(index);
                System.out.print(elem.m_label + " ");
              }
            System.out.print("\n");
          }     

        return;
      }

  /***************************************************************
    Function: get_unmarked
    Description: Returns next unmarked DFA state.
    **************************************************************/
  private GLrwerhps get_unmarked
    (
     )
      {
        int size;
        GLrwerhps dfa;

        size = m_spec.m_dfa_states.size();
        while (m_unmarked_dfa < size)
          {
            dfa = (GLrwerhps) m_spec.m_dfa_states.elementAt(m_unmarked_dfa);

            if (false == dfa.m_mark)
              {
                if (true == GKmsrthmG.OLD_DUMP_DEBUG)
                  {
                    System.out.print("*");
                    System.out.flush();
                  }

                if (true == m_spec.m_verbose && true == GKmsrthmG.OLD_DUMP_DEBUG)
                  {
                    System.out.println("---------------");
                    System.out.print("working on DFA state " 
                                     + m_unmarked_dfa
                                     + " = NFA states: ");
                    m_lexGen.print_set(dfa.m_nfa_set);
                    System.out.print("\n");
                  }

                return dfa;
              }

            ++m_unmarked_dfa;
          }

        return null;
      }
  
  /***************************************************************
    function: add_to_dstates
    Description: Takes as input a qfijWftDc with details of
    a dfa state that needs to be created.
    1) Allocates a new dfa state and saves it in 
    the appropriate mfKigxveL vector.
    2) Initializes the fields of the dfa state
    with the information in the qfijWftDc.
    3) Returns index of new dfa.
    **************************************************************/
  private int add_to_dstates
    (
     qfijWftDc bunch
     )
      {
        GLrwerhps dfa;
        
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != bunch.m_nfa_set);
            GKmsrthmG.assert(null != bunch.m_nfa_bit);
            GKmsrthmG.assert(null != bunch.m_accept 
                            || mfKigxveL.NONE == bunch.m_anchor);
          }

        /* Allocate, passing mfKigxveL so dfa label can be set. */
        dfa = BqnbvjuVj.newGLrwerhps(m_spec);
        
        /* Initialize fields, including the mark field. */
        dfa.m_nfa_set = (Vector) bunch.m_nfa_set.clone();
        dfa.m_nfa_bit = (BitSet) bunch.m_nfa_bit.clone();
        dfa.m_accept = bunch.m_accept;
        dfa.m_anchor = bunch.m_anchor;
        dfa.m_mark = false;
        
        /* Register dfa state using BitSet in mfKigxveL Hashtable. */
        m_spec.m_dfa_sets.put(dfa.m_nfa_bit,dfa);
        /*registerGLrwerhps(dfa);*/

        if (GKmsrthmG.OLD_DUMP_DEBUG)
          {
            System.out.print("Registering set : ");
            m_lexGen.print_set(dfa.m_nfa_set);
            System.out.println("");
          }

        return dfa.m_label;
      }

  /***************************************************************
    Function: in_dstates
    **************************************************************/
  private int in_dstates
    (
     qfijWftDc bunch
     )
      {
        GLrwerhps dfa;
        
        if (GKmsrthmG.OLD_DEBUG)
          {
            System.out.print("Looking for set : ");
            m_lexGen.print_set(bunch.m_nfa_set);
          }

        dfa = (GLrwerhps) m_spec.m_dfa_sets.get(bunch.m_nfa_bit);

        if (null != dfa)
          {
            if (GKmsrthmG.OLD_DUMP_DEBUG)
              {
                System.out.println(" FOUND!");
              }
            
            return dfa.m_label;
          }

        if (GKmsrthmG.OLD_DUMP_DEBUG)
          {
            System.out.println(" NOT FOUND!");
          }
        return NOT_IN_DSTATES;
      }

}

/***************************************************************
  Class: BqnbvjuVj
  **************************************************************/
final class BqnbvjuVj //**NS**
{
  /***************************************************************
    Function: newGLrwerhps
    **************************************************************/
  static GLrwerhps newGLrwerhps
    (
     mfKigxveL spec
     )
      {
        GLrwerhps dfa;
        
        dfa = new GLrwerhps(spec.m_dfa_states.size());
        spec.m_dfa_states.addElement(dfa);

        return dfa;
      }

  /***************************************************************
    Function: newMXrueHIOC
    Description: 
    **************************************************************/
  static MXrueHIOC newMXrueHIOC
    (
     )
      {
        MXrueHIOC pair = new MXrueHIOC();
        
        return pair;
      }

  /***************************************************************
    Function: newvjSXErPeE
    Description: 
    **************************************************************/
  static vjSXErPeE newvjSXErPeE
    (
     mfKigxveL spec
     )
      {
        vjSXErPeE p;

        /* UNDONE: Buffer this? */

        p = new vjSXErPeE();
        
        /*p.m_label = spec.m_nfa_states.size();*/
        spec.m_nfa_states.addElement(p);
        p.m_edge = vjSXErPeE.EPSILON;
        
        return p;
      }
}

/***************************************************************
  Class: WAHnaXLrJ
  Description: Top-level lexical analyzer generator function.
 **************************************************************/
final class WAHnaXLrJ //**NS**
{
  /***************************************************************
    Function: main
    **************************************************************/
  public static void main
    (
     String arg[]
     )
    throws java.io.IOException
      {
        pVfjIoLBv lg;

        if (arg.length < 1)
          {
            System.out.println("Usage: WAHnaXLrJ <filename>");
            return;
          }

        lg = new pVfjIoLBv(arg[0]);
        lg.generate();
      }
}    

/***************************************************************
  Class: UKEULJtgQ
  **************************************************************/
final class UKEULJtgQ //**NS**
{
  /*************************************************************
    Member Variables
    ***********************************************************/
  int m_dtrans[];
  oNaJmmlAX m_accept;
  int m_anchor;
  int m_label;

  /*************************************************************
    Constants
    ***********************************************************/
  static final int F = -1;

  /*************************************************************
    Function: CTrans
    ***********************************************************/
  UKEULJtgQ
    (
     int label,
     mfKigxveL spec
     )
      {
        m_dtrans = new int[spec.m_dtrans_ncols];
        m_accept = null;
        m_anchor = mfKigxveL.NONE;
        m_label = label;
      }
}

/***************************************************************
  Class: GLrwerhps
  **************************************************************/
final class GLrwerhps //**NS**
{
  /***************************************************************
    Member Variables
    ***********************************************************/
  int m_group;
  boolean m_mark;
  oNaJmmlAX m_accept;
  int m_anchor;
  Vector m_nfa_set;
  BitSet m_nfa_bit;
  int m_label;

  /***************************************************************
    Function: GLrwerhps
    **************************************************************/
  GLrwerhps
    (
     int label
     )
      {
        m_group = 0;
        m_mark = false;

        m_accept = null;
        m_anchor = mfKigxveL.NONE;

        m_nfa_set = null;
        m_nfa_bit = null;

        m_label = label;
      }
}

/***************************************************************
  Class: oNaJmmlAX
 **************************************************************/
final class oNaJmmlAX //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  char m_action[];
  int m_action_read;
  int m_line_number;

  /***************************************************************
    Function: oNaJmmlAX
    **************************************************************/
  oNaJmmlAX
    (
     char action[],
     int action_read,
     int line_number
     )
      {
        int elem;

        m_action_read = action_read;

        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = action[elem];
          }

        m_line_number = line_number;
      }

  /***************************************************************
    Function: oNaJmmlAX
    **************************************************************/
  oNaJmmlAX
    (
     oNaJmmlAX accept
     )
      {
        int elem;

        m_action_read = accept.m_action_read;
        
        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = accept.m_action[elem];
          }

        m_line_number = accept.m_line_number;
      }

  /***************************************************************
    Function: mimic
    **************************************************************/
  void mimic
    (
     oNaJmmlAX accept
     )
      {
        int elem;

        m_action_read = accept.m_action_read;
        
        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = accept.m_action[elem];
          }
      }
}

/***************************************************************
  Class: VTuofpvmd
  **************************************************************/
final class VTuofpvmd //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  oNaJmmlAX m_accept;
  int m_anchor;

  /***************************************************************
    Function: VTuofpvmd
    **************************************************************/
  VTuofpvmd
    (
     )
      {
        m_accept = null;
        m_anchor = mfKigxveL.NONE;
      }
}

/***************************************************************
  Class: MXrueHIOC
  **************************************************************/
final class MXrueHIOC //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  vjSXErPeE m_start;
  vjSXErPeE m_end;
  
  /***************************************************************
    Function: MXrueHIOC
    **************************************************************/
  MXrueHIOC
    (
     )
      {
        m_start = null;
        m_end = null;
      }
}

/***************************************************************
  Class: kTqvpQzCV
  Description: 
 **************************************************************/
final class kTqvpQzCV //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private InputStream m_input; /* Java-Lez specification file. */

  private byte m_buffer[]; /* Input buffer. */
  private int m_buffer_read; /* Number of bytes read into input buffer. */
  private int m_buffer_index; /* Current index into input buffer. */

  boolean m_eof_reached; /* Whether EOF has been encountered. */
  boolean m_pushback_line; 

  char m_line[]; /* Line buffer. */
  int m_line_read; /* Number of bytes read into line buffer. */
  int m_line_index; /* Current index into line buffer. */

  int m_line_number; /* Current line number. */

  /***************************************************************
    Constants
    **************************************************************/
  private static final int BUFFER_SIZE = 1024;
  static final boolean EOF = true;
  static final boolean NOT_EOF = false;
  
  /***************************************************************
    Function: kTqvpQzCV
    Description: 
    **************************************************************/
  kTqvpQzCV
    (
     InputStream input
     )
      {
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != input);
          }

        /* Initialize input stream. */
        m_input = input;

        /* Initialize buffers and index counters. */
        m_buffer = new byte[BUFFER_SIZE];
        m_buffer_read = 0;
        m_buffer_index = 0;

        m_line = new char[BUFFER_SIZE];
        m_line_read = 0;
        m_line_index = 0;

        /* Initialize state variables. */
        m_eof_reached = false;
        m_line_number = 0;
        m_pushback_line = false;
      }

  /***************************************************************
    Function: getLine
    Description: Returns true on EOF, false otherwise.
    Guarantees not to return a blank line, or a line
    of zero length.
    **************************************************************/
  boolean getLine 
    (
     )
      throws java.io.IOException
      {
        int elem;
        
        /* Has EOF already been reached? */
        if (true == m_eof_reached)
          {
            if (GKmsrthmG.OLD_DEBUG)
              {
                System.out.print("Line 1: ");
                System.out.print(new String(m_line,0,
                                            m_line_read));
              }

            return true;
          }
        
        /* Pushback current line? */
        if (true == m_pushback_line)
          {
            m_pushback_line = false;

            /* Check for empty line. */
            for (elem = 0; elem < m_line_read; ++elem)
              {
                if (false == GKmsrthmG.isspace(m_line[elem]))
                  {
                    break;
                  }
              }

            /* Nonempty? */
            if (elem < m_line_read)
              {
                m_line_index = 0;
                return false;
              }

            if (GKmsrthmG.OLD_DEBUG)
              {
                System.out.print("Line 2: ");
                System.out.print(new String(m_line,0,
                                            m_line_read));
              }
          }

        while (true)
          {
            /* Refill buffer? */
            if (m_buffer_index >= m_buffer_read)
              {
                m_buffer_read = m_input.read(m_buffer);
                if (-1 == m_buffer_read)
                  {
                    m_eof_reached = true;

                    if (GKmsrthmG.OLD_DEBUG)
                      {
                        System.out.print("Line 3: ");
                        System.out.print(new String(m_line,0,
                                                    m_line_read));
                      }
                    
                    m_line_index = 0;
                    return true;
                  }
                m_buffer_index = 0;
              }
            
            m_line_read = 0;
            while ((byte) '\n' != m_buffer[m_buffer_index])
              {
                m_line[m_line_read] = (char) m_buffer[m_buffer_index];

                ++m_buffer_index;
                
                /* Refill buffer? */
                if (m_buffer_index >= m_buffer_read)
                  {
                    m_buffer_read = m_input.read(m_buffer);
                    if (-1 == m_buffer_read)
                      {
                        m_eof_reached = true;

                        /* Check for empty lines and discard them. */
                        elem = 0;
                        while (GKmsrthmG.isspace(m_line[elem])) 
                          {
                            ++elem;
                            if (elem == m_line_read)
                              {
                                break;
                              }
                          }
                        
                        if (elem < m_line_read)
                          {                       
                            if (GKmsrthmG.OLD_DEBUG)
                              {
                                System.out.print("Line 4:");
                                System.out.print(new String(m_line,
                                                            0,
                                                            m_line_read));
                              }
                            
                              
                            m_line_index = 0;
                            return false;
                          }

                        if (GKmsrthmG.OLD_DEBUG)
                          {
                            System.out.print("Line <e>:");
                            System.out.print(new String(m_line,0,
                                                    m_line_read));
                          }

                        m_line_index = 0;
                        return true;
                      }

                    m_buffer_index = 0;
                  }

                ++m_line_read;

                /* Resize line buffer? */
                if (m_line_read >= m_line.length)
                  {
                    m_line = GKmsrthmG.doubleSize(m_line);
                  }
              }
            /* Save newline in buffer. */
            m_line[m_line_read] = (char) m_buffer[m_buffer_index];
            ++m_line_read;
            ++m_buffer_index;
            ++m_line_number;
            
            /* Check for empty lines and discard them. */
            elem = 0;
            while (GKmsrthmG.isspace(m_line[elem])) 
              {
                ++elem;
                if (elem == m_line_read)
                  {
                    break;
                  }
              }
            
            if (elem < m_line_read)
              {
                break;
              }
          }

        if (GKmsrthmG.OLD_DEBUG)
          {
            System.out.print("Line <f>:");
            System.out.print(new String(m_line,0,m_line_read));
          }

        m_line_index = 0;
        return false;
      }
}

/********************************************************
  Class: Utility
  *******************************************************/
final class GKmsrthmG  //**NS**
{
  /********************************************************
    Constants
    *******************************************************/
  static final boolean DEBUG = true;
  static final boolean SLOW_DEBUG = true;
  static final boolean DUMP_DEBUG = true;
  /*static final boolean DEBUG = false;
  static final boolean SLOW_DEBUG = false;
  static final boolean DUMP_DEBUG = false;*/
  
  static final boolean DESCENT_DEBUG = false;
  static final boolean OLD_DEBUG = false;
  static final boolean OLD_DUMP_DEBUG = false;
  static final boolean FOODEBUG = false;
  static final boolean DO_DEBUG = false;      
  
  /********************************************************
    Constants: Integer Bounds
    *******************************************************/
  static final int INT_MAX = 2147483647;

  /* UNDONE: What about other character values??? */
  static final int MAX_SEVEN_BIT = 127;
  static final int MAX_EIGHT_BIT = 256;

  /********************************************************
    Function: enter
    Description: Debugging routine.
    *******************************************************/
  static void enter
    (
     String descent,
     char lexeme,
     int token
     )
      {
        System.out.println("Entering " + descent 
                           + " [lexeme: " + lexeme 
                           + "] [token: " + token + "]");
      }

  /********************************************************
    Function: leave
    Description: Debugging routine.
    *******************************************************/
  static void leave
    (
     String descent,
     char lexeme,
     int token
     )
      {
        System.out.println("Leaving " + descent 
                           + " [lexeme:" + lexeme 
                           + "] [token:" + token + "]");
      }

  /********************************************************
    Function: assert
    Description: Debugging routine.
    *******************************************************/
  static void assert
    (
     boolean expr
     )
      {
        if (true == DEBUG && false == expr)
          {
            System.out.println("Assertion Failed");
            throw new Error("Assertion Failed.");
          }
      }

  /***************************************************************
    Function: doubleSize
    **************************************************************/
  static char[] doubleSize
    (
     char oldBuffer[]
     )
      {
        char newBuffer[] = new char[2 * oldBuffer.length];
        int elem;

        for (elem = 0; elem < oldBuffer.length; ++elem)
          {
            newBuffer[elem] = oldBuffer[elem];
          }

        return newBuffer;
      }

  /***************************************************************
    Function: doubleSize
    **************************************************************/
  static byte[] doubleSize
    (
     byte oldBuffer[]
     )
      {
        byte newBuffer[] = new byte[2 * oldBuffer.length];
        int elem;

        for (elem = 0; elem < oldBuffer.length; ++elem)
          {
            newBuffer[elem] = oldBuffer[elem];
          }

        return newBuffer;
      }

  /********************************************************
    Function: hex2bin
    *******************************************************/
  static char hex2bin
    (
     char c
     )
      {
        if ('0' <= c && '9' >= c)
          {
            return (char) (c - '0');
          }
        else if ('a' <= c && 'f' >= c)
          {
            return (char) (c - 'a' + 10);
          }         
        else if ('A' <= c && 'F' >= c)
          {
            return (char) (c - 'A' + 10);
          }
        
        JJdTyoVCJ.impos("Bad hexidecimal digit" + c);
        return 0;
      }

  /********************************************************
    Function: ishexdigit
    *******************************************************/
  static boolean ishexdigit
    (
     char c
     )
      {
        if (('0' <= c && '9' >= c)
            || ('a' <= c && 'f' >= c)
            || ('A' <= c && 'F' >= c))
          {
            return true;
          }

        return false;
      }

  /********************************************************
    Function: oct2bin
    *******************************************************/
  static char oct2bin
    (
     char c
     )
      {
        if ('0' <= c && '7' >= c)
          {
            return (char) (c - '0');
          }
        
        JJdTyoVCJ.impos("Bad octal digit " + c);
        return 0;
      }

  /********************************************************
    Function: isoctdigit
    *******************************************************/
  static boolean isoctdigit
    (
     char c
     )
      {
        if ('0' <= c && '7' >= c)
          {
            return true;
          }

        return false;
      }
        
  /********************************************************
    Function: isspace
    *******************************************************/
  static boolean isspace
    (
     char c
     )
      {
        if ('\b' == c 
            || '\t' == c
            || '\n' == c
            || '\f' == c
            || '\r' == c
            || ' ' == c)
          {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: isnewline
    *******************************************************/
  static boolean isnewline
    (
     char c
     )
      {
        if ('\n' == c
            || '\r' == c)
            {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: isalpha
    *******************************************************/
  static boolean isalpha
    (
     char c
     )
      {
        if (('a' <= c && 'z' >= c)
            || ('A' <= c && 'Z' >= c))
          {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: toupper
    *******************************************************/
  static char toupper
    (
     char c
     )
      {
        if (('a' <= c && 'z' >= c))
          {
            return (char) (c - 'a' + 'A');
          }

        return c;
      }

  /********************************************************
    Function: bytencmp
    Description: Compares up to n elements of 
    byte array a[] against byte array b[].
    The first byte comparison is made between 
    a[a_first] and b[b_first].  Comparisons continue
    until the null terminating byte '\0' is reached
    or until n bytes are compared.
    Return Value: Returns 0 if arrays are the 
    same up to and including the null terminating byte 
    or up to and including the first n bytes,
    whichever comes first.
    *******************************************************/
  static int bytencmp
    (
     byte a[],
     int a_first,
     byte b[],
     int b_first,
     int n
     )
      {
        int elem;

        for (elem = 0; elem < n; ++elem)
          {
            /*System.out.print((char) a[a_first + elem]);
            System.out.print((char) b[b_first + elem]);*/
                             
            if ('\0' == a[a_first + elem] && '\0' == b[b_first + elem])
              {
                /*System.out.println("return 0");*/
                return 0;
              }
            if (a[a_first + elem] < b[b_first + elem])
              {
                /*System.out.println("return 1");*/
                return 1;
              }
            else if (a[a_first + elem] > b[b_first + elem])
              {
                /*System.out.println("return -1");*/
                return -1;
              }
          }

        /*System.out.println("return 0");*/
        return 0;
      }

  /********************************************************
    Function: charncmp
    *******************************************************/
  static int charncmp
    (
     char a[],
     int a_first,
     char b[],
     int b_first,
     int n
     )
      {
        int elem;

        for (elem = 0; elem < n; ++elem)
          {
            if ('\0' == a[a_first + elem] && '\0' == b[b_first + elem])
              {
                return 0;
              }
            if (a[a_first + elem] < b[b_first + elem])
              {
                return 1;
              }
            else if (a[a_first + elem] > b[b_first + elem])
              {
                return -1;
              }
          }

        return 0;
      }
}

/********************************************************
  Class: JJdTyoVCJ
  *******************************************************/
final class JJdTyoVCJ //**NS**
{
  /********************************************************
    Function: impos
    Description:
    *******************************************************/
  static void impos
    (
     String message
     )
      {
        System.out.println("Java-Lex Error: " + message);
      }

  /********************************************************
    Constants
    Description: Error codes for parse_error().
    *******************************************************/
  static final int E_BADEXPR = 0;
  static final int E_PAREN = 1;
  static final int E_LENGTH = 2;
  static final int E_BRACKET = 3;
  static final int E_BOL = 4;
  static final int E_CLOSE = 5;
  static final int E_NEWLINE = 6;
  static final int E_BADMAC = 7;
  static final int E_NOMAC = 8;
  static final int E_MACDEPTH = 9;
  static final int E_INIT = 10;
  static final int E_EOF = 11;
  static final int E_DIRECT = 12;
  static final int E_INTERNAL = 13;
  static final int E_STATE = 14;
  static final int E_MACDEF = 15;
  static final int E_SYNTAX = 16;
  static final int E_BRACE = 17;
  
  /********************************************************
    Constants
    Description: String messages for parse_error();
    *******************************************************/
  static final String errmsg[] = 
    {
      "Malformed regular expression.",
      "Missing close parenthesis.",
      "Too many regular expressions or expression too long.",
      "Missing [ in character class.",
      "^ must be at start of expression or after [.",
      "+ ? or * must follow an expression or subexpression.",
      "Newline in quoted string.",
      "Missing } in macro expansion.",
      "Macro does not exist.",
      "Macro expansions nested too deeply.",
      "Java-Lex has not been successfully initialized.",
      "Unexpected end-of-file found.",
      "Undefined or badly-formed Java-Lex directive.",
      "Internal Java-Lex error.",
      "Unitialized state name.",
      "Badly formed macro definition.",
      "Syntax error.",
      "Missing brace at start of lexical action."
    };
  
  /********************************************************
    Function: parse_error
    Description:
    *******************************************************/
  static void parse_error
    (
     int error_code,
     int line_number
     )
      {
        System.out.println("Error: Parse error at line " 
                           + line_number + ".");
        System.out.println("Error Description: " + errmsg[error_code]);
        throw new Error("Parse error.");
      }
}

/********************************************************
  Class: JVUKgUbFW
  *******************************************************/
final  class JVUKgUbFW 
{
  /********************************************************
    Member Variables
    *******************************************************/
  private BitSet m_set;
  private boolean m_complement;

  /********************************************************
    Function: JVUKgUbFW
    *******************************************************/
  JVUKgUbFW
    (
     )
    {
      m_set = new BitSet();
      m_complement = false;
    }

  /********************************************************
    Function: complement
    *******************************************************/
  void complement
    (
     )
      {
        m_complement = true;
      }

  /********************************************************
    Function: add
    *******************************************************/
  void add
    (
     int i
     )
      {
        m_set.set(i);
      }
  
  /********************************************************
    Function: contains
    *******************************************************/
  boolean contains
    (
     int i
     )
      {
        boolean result;
        
        result = m_set.get(i);
        
        if (true == m_complement)
          {
            return (false == result);
          }
        
        return result;
      }

  /********************************************************
    Function: mimic
    *******************************************************/
  void mimic
    (
     JVUKgUbFW set
     )
      {
        m_complement = set.m_complement;
        m_set = (BitSet) set.m_set.clone();
      } 
}

/********************************************************
  Class: vjSXErPeE
  *******************************************************/
final class vjSXErPeE //**NS**
{
  /********************************************************
    Member Variables
    *******************************************************/
  int m_edge;  /* Label for edge type:
                         character code, 
                         CCL (character class), 
                         [STATE,
                         SCL (state class),]
                         EMPTY, 
                         EPSILON. */
  
  JVUKgUbFW m_set;  /* Set to store character classes. */
  vjSXErPeE m_next;  /* Next state (or null if none). */
  
  vjSXErPeE m_next2;  /* Another state with type == EPSILON
                           and null if not used.  
                           The NFA construction should result in two
                           outgoing edges only if both are EPSILON edges. */
  
  oNaJmmlAX m_accept;  /* Set to null if nonaccepting state. */
  int m_anchor;  /* Says if and where pattern is anchored. */

  int m_label;

  BitSet m_states;

  /********************************************************
    Constants
    *******************************************************/
  static final int NO_LABEL = -1;

  /********************************************************
    Constants: Edge Types
    Note: Edge transitions on one specific character
    are labelled with the character Ascii (Unicode)
    codes.  So none of the constants below should
    overlap with the natural character codes.
    *******************************************************/
  static final int CCL = -1;
  static final int EMPTY = -2;
  static final int EPSILON = -3;
   
  /********************************************************
    Function: vjSXErPeE
    *******************************************************/
 vjSXErPeE
    (
     )
    {
      m_edge = EMPTY;
      m_set = null;
      m_next = null;
      m_next2 = null;
      m_accept = null;
      m_anchor = mfKigxveL.NONE;
      m_label = NO_LABEL;
      m_states = null;
    }

  /********************************************************
    Function: mimic
    Description: Converts this NFA state into a copy of
    the input one.
    *******************************************************/
  void mimic
    (
     vjSXErPeE nfa
     )
      {
        m_edge = nfa.m_edge;
        
        if (null != nfa.m_set)
          {
            if (null == m_set)
              {
                m_set = new JVUKgUbFW();
              }
            m_set.mimic(nfa.m_set);
          }
        else
          {
            m_set = null;
          }

        m_next = nfa.m_next;
        m_next2 = nfa.m_next2;
        m_accept = nfa.m_accept;
        m_anchor = nfa.m_anchor;

        if (null != nfa.m_states)
          {
            m_states = (BitSet) nfa.m_states.clone();
          }
        else
          {
            m_states = null;
          }
      }
}

/***************************************************************
  Class: pVfjIoLBv
  **************************************************************/
final class pVfjIoLBv //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private InputStream m_instream; /* Java-Lex specification file. */
  private DataOutputStream m_outstream; /* Lexical analyzer source file. */

  private kTqvpQzCV m_input; /* Input buffer class. */

  private Hashtable m_tokens; /* Hashtable that maps characters to their 
                                 corresponding lexical code for
                                 the internal lexical analyzer. */
  private mfKigxveL m_spec; /* Spec class holds information
                           about the generated lexer. */
  private boolean m_init_flag; /* Flag set to true only upon 
                                  successful initialization. */

  private hVkqSwgOt m_makeNfa; /* NFA machine generator module. */
  private FOmkezwmz m_nfa2dfa; /* NFA to DFA machine (transition table) 
                                 conversion module. */
  private UHrTGYkQm m_minimize; /* Transition table compressor. */
  private HNTNIcohS m_emit; /* Output module that emits source code
                           into the generated lexer file. */


  /********************************************************
    Constants
    *******************************************************/
  private static final boolean ERROR = false;
  private static final boolean NOT_ERROR = true;
  private static final int BUFFER_SIZE = 1024;

  /********************************************************
    Constants: Token Types
    *******************************************************/
  static final int EOS = 1;
  static final int ANY = 2;
  static final int AT_BOL = 3;
  static final int AT_EOL = 4;
  static final int CCL_END = 5;
  static final int CCL_START = 6;
  static final int CLOSE_CURLY = 7;
  static final int CLOSE_PAREN = 8;
  static final int CLOSURE = 9;
  static final int DASH = 10;
  static final int END_OF_INPUT = 11;
  static final int L = 12;
  static final int OPEN_CURLY = 13;
  static final int OPEN_PAREN = 14;
  static final int OPTIONAL = 15;
  static final int OR = 16;
  static final int PLUS_CLOSE = 17;

  /***************************************************************
    Function: pVfjIoLBv
    **************************************************************/
  pVfjIoLBv 
    (
     String filename
     )
      throws java.io.FileNotFoundException, java.io.IOException
      {
        /* Successful initialization flag. */
        m_init_flag = false;
        
        /* Open input stream. */
        m_instream = new FileInputStream(filename);
        if (null == m_instream)
          {
            System.out.println("Error: Unable to open input file "
                               + filename + ".");
            return;
          }

        /* Open output stream. */
        m_outstream = new DataOutputStream(
                        /*new BufferedOutputStream(*/
                          new FileOutputStream(filename + ".java")/*)*/); //**NS**
        if (null == m_outstream)
          {
            System.out.println("Error: Unable to open output file "
                               + filename + ".java.");
            return;
          }

        /* Create input buffer class. */
        m_input = new kTqvpQzCV(m_instream);

        /* Initialize character hash table. */
        m_tokens = new Hashtable();
        m_tokens.put(new Character('$'),new Integer(AT_EOL));
        m_tokens.put(new Character('('),new Integer(OPEN_PAREN));
        m_tokens.put(new Character(')'),new Integer(CLOSE_PAREN));
        m_tokens.put(new Character('*'),new Integer(CLOSURE));
        m_tokens.put(new Character('+'),new Integer(PLUS_CLOSE));
        m_tokens.put(new Character('-'),new Integer(DASH));
        m_tokens.put(new Character('.'),new Integer(ANY));
        m_tokens.put(new Character('?'),new Integer(OPTIONAL));
        m_tokens.put(new Character('['),new Integer(CCL_START));
        m_tokens.put(new Character(']'),new Integer(CCL_END));
        m_tokens.put(new Character('^'),new Integer(AT_BOL));
        m_tokens.put(new Character('{'),new Integer(OPEN_CURLY));
        m_tokens.put(new Character('|'),new Integer(OR));
        m_tokens.put(new Character('}'),new Integer(CLOSE_CURLY));
      
        /* Initialize spec structure. */
        m_spec = new mfKigxveL(this);
        
        /* Nfa to dfa converter. */
        m_nfa2dfa = new FOmkezwmz();
        m_minimize = new UHrTGYkQm();
        m_makeNfa = new hVkqSwgOt();

        m_emit = new HNTNIcohS();

        /* Successful initialization flag. */
        m_init_flag = true;
      }

  /***************************************************************
    Function: generate
    Description: 
    **************************************************************/
  void generate
    (
     )
      throws java.io.IOException, java.io.FileNotFoundException
      {
        if (false == m_init_flag)
          {
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_INIT,0);
          }

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != this);
            GKmsrthmG.assert(null != m_outstream);
            GKmsrthmG.assert(null != m_input);
            GKmsrthmG.assert(null != m_tokens);
            GKmsrthmG.assert(null != m_spec);
            GKmsrthmG.assert(true == m_init_flag);
          }

        /*m_emit.emit_imports(m_spec,m_outstream);*/

        if (m_spec.m_verbose)
          {
            System.out.println("Processing first section -- user code.");
          }
        userCode();
        if (true == m_input.m_eof_reached)
          {
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_EOF,m_input.m_line_number);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Processing second section -- " 
                               + "Java-Lex declarations.");
          }
        userDeclare();
        if (true == m_input.m_eof_reached)
          {
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_EOF,m_input.m_line_number);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Processing third section -- lexical rules.");
          }
        userRules();
        if (true == GKmsrthmG.DO_DEBUG)
          {
            print_header();
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Outputting lexical analyzer code.");
          }
        m_emit.emit(m_spec,m_outstream);

        if (m_spec.m_verbose && true == GKmsrthmG.OLD_DUMP_DEBUG)
          {
            details();
          }
      }

  /***************************************************************
    Function: userCode
    Description: Process first section of specification,
    echoing it into output file.
    **************************************************************/
  private void userCode
    (
     )
      throws java.io.IOException
      {
        int count = 0;

        if (false == m_init_flag)
          {
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_INIT,0);
          }

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != this);
            GKmsrthmG.assert(null != m_outstream);
            GKmsrthmG.assert(null != m_input);
            GKmsrthmG.assert(null != m_tokens);
            GKmsrthmG.assert(null != m_spec);
          }

        if (true == m_input.m_eof_reached)
          {
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_EOF,0);
          }

        while (true)
          {
            if (true == m_input.getLine())
              {
                /* Eof reached. */
                JJdTyoVCJ.parse_error(JJdTyoVCJ.E_EOF,0);
              }
            
            if (2 <= m_input.m_line_read 
                && '%' == m_input.m_line[0]
                && '%' == m_input.m_line[1])
              {
                /* Discard remainder of line. */
                m_input.m_line_index = m_input.m_line_read;
                return;
              }

            m_outstream.writeBytes(new String(m_input.m_line,0,
                                              m_input.m_line_read));
          }
      }

  /***************************************************************
    Function: getName
    **************************************************************/
  private char[] getName
    (
     )
      {
        char buffer[];
        int elem;

        /* Skip white space. */
        while (m_input.m_line_index < m_input.m_line_read
               && true == GKmsrthmG.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
          }

        /* No name? */
        if (m_input.m_line_index >= m_input.m_line_read)
          {
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,0);
          }

        /* Determine length. */
        elem = m_input.m_line_index;
        while (elem < m_input.m_line_read
               && false == GKmsrthmG.isnewline(m_input.m_line[elem]))
          {
            ++elem;
          } 

        /* Allocate non-terminated buffer of exact length. */
        buffer = new char[elem - m_input.m_line_index];
        
        /* Copy. */
        elem = 0;
        while (m_input.m_line_index < m_input.m_line_read
               && false == GKmsrthmG.isnewline(m_input.m_line[m_input.m_line_index]))
          {
            buffer[elem] = m_input.m_line[m_input.m_line_index];
            ++elem;
            ++m_input.m_line_index;
          }

        return buffer;
      }

  private static final int CLASS_CODE = 0;       //**NS**
  private static final int INIT_CODE = 1;        //**NS**
  private static final int EOF_CODE = 2;         //**NS**
  private static final int INIT_THROW_CODE = 3;  //**NS**
  private static final int YYLEX_THROW_CODE = 4; //**NS**
  private static final int EOF_THROW_CODE = 5;   //**NS**
  private static final int EOF_VALUE_CODE = 6;   //**NS**

  /***************************************************************
    Function: packCode
    Description:
    **************************************************************/
  private char[] packCode
    (
     char start_dir[],
     char end_dir[],
     char prev_code[],
     int prev_read,
     int specified
     )
      throws java.io.IOException
      {
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(INIT_CODE == specified 
                            || CLASS_CODE == specified
                            || EOF_CODE == specified
                            || EOF_VALUE_CODE == specified
                            || INIT_THROW_CODE == specified
                            || YYLEX_THROW_CODE == specified
                            || EOF_THROW_CODE == specified);
          }

        if (0 != GKmsrthmG.charncmp(m_input.m_line,
                                   0,
                                   start_dir,
                                   0,
                                   start_dir.length - 1))
          {
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_INTERNAL,0);
          }
        
        if (null == prev_code)
          {
            prev_code = new char[BUFFER_SIZE];
            prev_read = 0;
          }
        
        if (prev_read >= prev_code.length)
          {
            prev_code = GKmsrthmG.doubleSize(prev_code);
          }
        
        m_input.m_line_index = start_dir.length - 1;
        while (true)
          {
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    JJdTyoVCJ.parse_error(JJdTyoVCJ.E_EOF,m_input.m_line_number);
                  }
                
                if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                           0,
                                           end_dir,
                                           0,
                                           end_dir.length - 1))
                  {
                    m_input.m_line_index = end_dir.length - 1;
                    
                    switch (specified)
                      {
                      case CLASS_CODE:
                        m_spec.m_class_read = prev_read;
                        break;
                        
                      case INIT_CODE:
                        m_spec.m_init_read = prev_read;
                        break;
                        
                      case EOF_CODE:
                        m_spec.m_eof_read = prev_read;
                        break;

                      case EOF_VALUE_CODE:
                        m_spec.m_eof_value_read = prev_read;
                        break;

                      case INIT_THROW_CODE:
                        m_spec.m_init_throw_read = prev_read;
                        break;

                      case YYLEX_THROW_CODE:
                        m_spec.m_yylex_throw_read = prev_read;
                        break;
                        
                      case EOF_THROW_CODE:
                        m_spec.m_eof_throw_read = prev_read;
                        break;
                        
                      default:
                        JJdTyoVCJ.parse_error(JJdTyoVCJ.E_INTERNAL,m_input.m_line_number);
                        break;
                      }

                    return prev_code;
                  }
              }

            while (m_input.m_line_index < m_input.m_line_read)
              {
                prev_code[prev_read] = m_input.m_line[m_input.m_line_index];
                ++prev_read;
                ++m_input.m_line_index;

                if (prev_read >= prev_code.length)
                  {
                    prev_code = GKmsrthmG.doubleSize(prev_code);
                  }
              }
          }
      }

  /***************************************************************
    Member Variables: Java-Lex directives.
    **************************************************************/
  private char m_state_dir[] = { 
    '%', 's', 't', 
    'a', 't', 'e',
    '\0'
    };
  
  private char m_char_dir[] = { 
    '%', 'c', 'h',
    'a', 'r',
    '\0'
    };

  private char m_line_dir[] = { 
    '%', 'l', 'i',
    'n', 'e',
    '\0'
    };

  private char m_cup_dir[] = { 
    '%', 'c', 'u',
    'p', 
    '\0'
    };

  private char m_class_dir[] = { 
    '%', 'c', 'l', 
    'a', 's', 's',
    '\0'
    };

  private char m_function_dir[] = { 
    '%', 'f', 'u',
    'n', 'c', 't',
    'i', 'o', 'n',
    '\0'
    };

  private char m_type_dir[] = { 
    '%', 't', 'y',
    'p', 'e',
    '\0'
    };

  private char m_integer_dir[] = { 
    '%', 'i', 'n',
    't', 'e', 'g', 
    'e', 'r',
    '\0'
    };

  private char m_intwrap_dir[] = { 
    '%', 'i', 'n',
    't', 'w', 'r', 
    'a', 'p',
    '\0'
    };

  private char m_full_dir[] = { 
    '%', 'f', 'u', 
    'l', 'l',
    '\0'
    };

  private char m_unicode_dir[] = { 
    '%', 'u', 'n', 
    'i', 'c', 'o',
    'd', 'e',
    '\0'
    };

  private char m_notunix_dir[] = { 
    '%', 'n', 'o',
    't', 'u', 'n', 
    'i', 'x',
    '\0'
    };

  private char m_init_code_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', '{',
    '\0'
    };

  private char m_init_code_end_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', '}',
    '\0'
    };

  private char m_init_throw_code_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', 't',
    'h', 'r', 'o',
    'w', '{',
    '\0'
    };

  private char m_init_throw_code_end_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', 't',
    'h', 'r', 'o',
    'w', '}',
    '\0'
    };

  private char m_yylex_throw_code_dir[] = { 
    '%', 'y', 'y', 'l', 
    'e', 'x', 't',
    'h', 'r', 'o',
    'w', '{',
    '\0'
    };

  private char m_yylex_throw_code_end_dir[] = { 
    '%', 'y', 'y', 'l', 
    'e', 'x', 't',
    'h', 'r', 'o',
    'w', '}',
    '\0'
    };

  private char m_eof_code_dir[] = { 
    '%', 'e', 'o', 
    'f', '{',
    '\0'
    };

  private char m_eof_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', '}',
    '\0'
    };

  private char m_eof_value_code_dir[] = { 
    '%', 'e', 'o', 
    'f', 'v', 'a', 
    'l', '{',
    '\0'
    };

  private char m_eof_value_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', 'v', 'a',
    'l', '}',
    '\0'
    };

  private char m_eof_throw_code_dir[] = { 
    '%', 'e', 'o', 
    'f', 't', 'h',
    'r', 'o', 'w',
    '{',
    '\0'
    };

  private char m_eof_throw_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', 't', 'h',
    'r', 'o', 'w',
    '}',
    '\0'
    };

  private char m_class_code_dir[] = { 
    '%', '{',
    '\0'
    };

  private char m_class_code_end_dir[] = { 
    '%', '}',
    '\0'
    };

  private char m_yyeof_dir[] = { 
    '%', 'y', 'y',
    'e', 'o', 'f',
    '\0'
    };
  
  /***************************************************************
    Function: userDeclare
    Description:
    **************************************************************/
  private void userDeclare
    (
     )
      throws java.io.IOException
        {
          int elem;
          
          if (GKmsrthmG.DEBUG)
            {
              GKmsrthmG.assert(null != this);
              GKmsrthmG.assert(null != m_outstream);
              GKmsrthmG.assert(null != m_input);
              GKmsrthmG.assert(null != m_tokens);
              GKmsrthmG.assert(null != m_spec);
            }

          if (true == m_input.m_eof_reached)
            {
              /* End-of-file. */
              JJdTyoVCJ.parse_error(JJdTyoVCJ.E_EOF,
                                 m_input.m_line_number);
            }

          while (false == m_input.getLine())
            {
              /* Look for double percent. */
              if (2 <= m_input.m_line_read 
                  && '%' == m_input.m_line[0] 
                  && '%' == m_input.m_line[1])
                {
                  /* Mess around with line. */
                  for (elem = 0; elem < m_input.m_line.length - 2; ++elem)
                    {
                      m_input.m_line[elem] = m_input.m_line[elem + 2];
                    }
                  m_input.m_line_read = m_input.m_line_read - 2;

                  m_input.m_pushback_line = true;
                  /* Check for and discard empty line. */
                  if (0 == m_input.m_line_read 
                      || '\n' == m_input.m_line[0])
                    {
                      m_input.m_pushback_line = false;
                    }

                  return;
                }

              if (0 == m_input.m_line_read)
                {
                  continue;
                }

              if ('%' == m_input.m_line[0])
                {
                  /* Special lex declarations. */
                  if (1 >= m_input.m_line_read)
                    {
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      continue;
                    }

                  switch (m_input.m_line[1])
                    {
                    case '{':
                      if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                 0,
                                                 m_class_code_dir,
                                                 0,
                                                 m_class_code_dir.length - 1))
                        {
                          m_spec.m_class_code = packCode(m_class_code_dir,
                                                         m_class_code_end_dir,
                                                         m_spec.m_class_code,
                                                         m_spec.m_class_read,
                                                         CLASS_CODE);
                          break;
                        }
              
                      /* Bad directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'c':
                      if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                 0,
                                                 m_char_dir,
                                                 0,
                                                 m_char_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_char_dir.length;
                          m_spec.m_count_chars = true;
                          break;
                        }       
                      else if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                      0,
                                                      m_cup_dir,
                                                      0,
                                                      m_cup_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_cup_dir.length;
                          m_spec.m_cup_compatible = true;
                          break;
                        }
                      else if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                      0,
                                                      m_class_dir, 
                                                      0,
                                                      m_class_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_class_dir.length;
                          m_spec.m_class_name = getName();
                          break;
                        }
              
                      /* Bad directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                      
                    case 'e':
                      if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                 0,
                                                 m_eof_code_dir,
                                                 0,
                                                 m_eof_code_dir.length - 1))
                        {
                          m_spec.m_eof_code = packCode(m_eof_code_dir,
                                                       m_eof_code_end_dir,
                                                       m_spec.m_eof_code,
                                                       m_spec.m_eof_read,
                                                       EOF_CODE);
                          break;
                        }
                      else if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                      0,
                                                      m_eof_value_code_dir,
                                                      0,
                                                      m_eof_value_code_dir.length - 1))
                        {
                          m_spec.m_eof_value_code = packCode(m_eof_value_code_dir,
                                                             m_eof_value_code_end_dir,
                                                             m_spec.m_eof_value_code,
                                                             m_spec.m_eof_value_read,
                                                             EOF_VALUE_CODE);
                          break;
                        }
                      else if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                      0,
                                                      m_eof_throw_code_dir,
                                                      0,
                                                      m_eof_throw_code_dir.length - 1))
                        {
                          m_spec.m_eof_throw_code = packCode(m_eof_throw_code_dir,
                                                       m_eof_throw_code_end_dir,
                                                       m_spec.m_eof_throw_code,
                                                       m_spec.m_eof_throw_read,
                                                       EOF_THROW_CODE);
                          break;
                        }
              
                      /* Bad directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'f':
                      if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                 0,
                                                 m_function_dir,
                                                 0,
                                                 m_function_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_function_dir.length;
                          m_spec.m_function_name = getName();
                          break;
                        }
                      else if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                      0,
                                                      m_full_dir,
                                                      0,
                                                      m_full_dir.length - 1))
                        {
                          m_input.m_line_index = m_full_dir.length;
                          m_spec.m_dtrans_ncols = GKmsrthmG.MAX_EIGHT_BIT + 1;
                          break;
                        }

                      /* Bad directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'i':
                      if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                 0,
                                                 m_integer_dir,
                                                 0,
                                                 m_integer_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_integer_dir.length;
                          m_spec.m_integer_type = true;
                          break;
                        }
                      else if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                      0,
                                                      m_intwrap_dir,
                                                      0,
                                                      m_intwrap_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_integer_dir.length;
                          m_spec.m_intwrap_type = true;
                          break;
                        }
                      else if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                      0,
                                                      m_init_code_dir,
                                                      0,
                                                      m_init_code_dir.length - 1))
                        {
                          m_spec.m_init_code = packCode(m_init_code_dir,
                                                        m_init_code_end_dir,
                                                        m_spec.m_init_code,
                                                        m_spec.m_init_read,
                                                        INIT_CODE);
                          break;
                        }
                      else if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                      0,
                                                      m_init_throw_code_dir,
                                                      0,
                                                      m_init_throw_code_dir.length - 1))
                        {
                          m_spec.m_init_throw_code = packCode(m_init_throw_code_dir,
                                                       m_init_throw_code_end_dir,
                                                       m_spec.m_init_throw_code,
                                                       m_spec.m_init_throw_read,
                                                       INIT_THROW_CODE);
                          break;
                        }

                      /* Bad directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'l':
                      if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                 0,
                                                 m_line_dir,
                                                 0,
                                                 m_line_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_line_dir.length;
                          m_spec.m_count_lines = true;
                          break;
                        }

                      /* Bad directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'n':
                      if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                 0,
                                                 m_notunix_dir,
                                                 0,
                                                 m_notunix_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_notunix_dir.length;
                          m_spec.m_unix = false;
                          break;
                        }

                      /* Bad directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 's':
                      if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                 0,
                                                 m_state_dir,
                                                 0,
                                                 m_state_dir.length - 1))
                        {
                          /* Recognize state list. */
                          m_input.m_line_index = m_state_dir.length;
                          saveStates();
                          break;
                        }

                      /* Undefined directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                     
                    case 't':
                      if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                 0,
                                                 m_type_dir,
                                                 0,
                                                 m_type_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_type_dir.length;
                          m_spec.m_type_name = getName();
                          break;
                        }

                      /* Undefined directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'u':
                      if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                 0,
                                                 m_unicode_dir,
                                                 0,
                                                 m_unicode_dir.length - 1))
                        {
                          m_input.m_line_index = m_unicode_dir.length;
                          /* UNDONE: What to do here? */
                          break;
                        }

                      /* Bad directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'y':
                      if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                 0,
                                                 m_yyeof_dir,
                                                 0,
                                                 m_yyeof_dir.length - 1))
                        {
                          m_input.m_line_index = m_yyeof_dir.length;
                          m_spec.m_yyeof = true;
                          break;
                        } else if (0 == GKmsrthmG.charncmp(m_input.m_line,
                                                          0,
                                                          m_yylex_throw_code_dir,
                                                          0,
                                                          m_yylex_throw_code_dir.length - 1))
                        {
                          m_spec.m_yylex_throw_code = packCode(m_yylex_throw_code_dir,
                                                               m_yylex_throw_code_end_dir,
                                                       m_spec.m_yylex_throw_code,
                                                       m_spec.m_yylex_throw_read,
                                                       YYLEX_THROW_CODE);
                          break;
                        }


                      /* Bad directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    default:
                      /* Undefined directive. */
                      JJdTyoVCJ.parse_error(JJdTyoVCJ.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                    }
                }
              else
                {
                  /* Regular expression macro. */
                  m_input.m_line_index = 0;
                  saveMacro();
                }

              if (GKmsrthmG.OLD_DEBUG)
                {
                  System.out.println("Line number " 
                                     + m_input.m_line_number + ":"); 
                  System.out.print(new String(m_input.m_line,
                                              0,m_input.m_line_read));
                }
            }
        }
         
  /***************************************************************
    Function: userRules
    Description: Processes third section of Java-Lex 
    specification and creates minimized transition table.
    **************************************************************/
  private void userRules
    (
     )
      throws java.io.IOException
      {
        int code;

        if (false == m_init_flag)
          {
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_INIT,0);
          }

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != this);
            GKmsrthmG.assert(null != m_outstream);
            GKmsrthmG.assert(null != m_input);
            GKmsrthmG.assert(null != m_tokens);
            GKmsrthmG.assert(null != m_spec);
          }

        /* UNDONE: Need to handle states preceding rules. */
        
        if (m_spec.m_verbose)
          {
            System.out.println("Creating NFA machine representation.");
          }
        m_makeNfa.thompson(this,m_spec,m_input);
        
        /*print_nfa();*/

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(END_OF_INPUT == m_spec.m_current_token);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Creating DFA transition table.");
          }
        m_nfa2dfa.make_dfa(this,m_spec);

        if (GKmsrthmG.FOODEBUG) {
          print_header();
        }

        if (m_spec.m_verbose)
          {
            System.out.println("Minimizing DFA transition table.");
          }
        m_minimize.min_dfa(m_spec);
      }

  /***************************************************************
    Function: printccl
    Description: Debuggng routine that outputs readable form
    of character class.
    **************************************************************/
  private void printccl
    (
     JVUKgUbFW set
     )
      {
        int i;
        
        System.out.print(" [");
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (true == set.contains(i))
              {
                System.out.print(interp_int(i));
              }
          }
        System.out.print(']');
      }

  /***************************************************************
    Function: plab
    Description:
    **************************************************************/
  private String plab
    (
     vjSXErPeE state
     )
      {
        int index;
        
        if (null == state)
          {
            return (new String("--"));
          }

        index = m_spec.m_nfa_states.indexOf(state);
        
        return ((new Integer(index)).toString());
      }

  /***************************************************************
    Function: interp_int
    Description:
    **************************************************************/
  private String interp_int
    (
     int i
     )
      {
        switch (i)
          {
          case (int) '\b':
            return (new String("\\b"));

          case (int) '\t':
            return (new String("\\t"));

          case (int) '\n':
            return (new String("\\n"));

          case (int) '\f':
            return (new String("\\f"));

          case (int) '\r':
            return (new String("\\r"));
            
          case (int) ' ':
            return (new String("\\ "));
            
          default:
            return ((new Character((char) i)).toString());
          }
      }

  /***************************************************************
    Function: print_nfa
    Description:
    **************************************************************/
  void print_nfa
    (
     )
      {
        int elem;
        vjSXErPeE nfa;
        int size;
        Enumeration states;
        Integer index;
        int i;
        int j;
        int vsize;
        String state;
     
        System.out.println("--------------------- NFA -----------------------");
        
        size = m_spec.m_nfa_states.size();
        for (elem = 0; elem < size; ++elem)
          {
            nfa = (vjSXErPeE) m_spec.m_nfa_states.elementAt(elem);
            
            System.out.print("Nfa state " + plab(nfa) + ": ");
            
            if (null == nfa.m_next)
              {
                System.out.print("(TERMINAL)");
              }
            else
              {
                System.out.print("--> " + plab(nfa.m_next));
                System.out.print("--> " + plab(nfa.m_next2));
                
                switch (nfa.m_edge)
                  {
                  case vjSXErPeE.CCL:
                    printccl(nfa.m_set);
                    break;

                  case vjSXErPeE.EPSILON:
                    System.out.print(" EPSILON ");
                    break; 
                    
                  default:
                    System.out.print(" " + interp_int(nfa.m_edge));
                    break;
                  }
              }

            if (0 == elem)
              {
                System.out.print(" (START STATE)");
              }
            
            if (null != nfa.m_accept)
              {
                System.out.print(" accepting " 
                                 + ((0 != (nfa.m_anchor & mfKigxveL.START)) ? "^" : "")
                                 + "<" 
                                 + (new String(nfa.m_accept.m_action,0,
                                               nfa.m_accept.m_action_read))
                                 + ">"
                                 + ((0 != (nfa.m_anchor & mfKigxveL.END)) ? "$" : ""));
              }

            System.out.println("");
          }

        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(null != state);
                GKmsrthmG.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");
            System.out.print("\tStart states of matching rules: ");
            
            i = index.intValue();
            vsize = m_spec.m_state_rules[i].size();
            
            for (j = 0; j < vsize; ++j)
              {
                nfa = (vjSXErPeE) m_spec.m_state_rules[i].elementAt(j);

                System.out.print(m_spec.m_nfa_states.indexOf(nfa) + " ");
              }

            System.out.println("");
          }

        System.out.println("-------------------- NFA ----------------------");
      }

  /***************************************************************
    Function: getStates
    Description: Parses the state area of a rule,
    from the beginning of a line.
    < state1, state2 ... > regular_expression { action }
    Returns null on only EOF.  Returns all_states, 
    initialied properly to correspond to all states,
    if no states are found.
    Special Notes: This function treats commas as optional
    and permits states to be spread over multiple lines.
    **************************************************************/
  private BitSet all_states = null;
  BitSet getStates
    (
     )
      throws java.io.IOException
      {
        int start_state;
        int count_state;
        BitSet states;
        String name;
        Integer index;
        int i;
        int size;
        
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != this);
            GKmsrthmG.assert(null != m_outstream);
            GKmsrthmG.assert(null != m_input);
            GKmsrthmG.assert(null != m_tokens);
            GKmsrthmG.assert(null != m_spec);
          }

        states = null;

        /* Skip white space. */
        while (true == GKmsrthmG.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
    
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                /* Must just be an empty line. */
                if (true == m_input.getLine())
                  {
                    /* EOF found. */
                    return null;
                  }
              }
          }

        /* Look for states. */
        if ('<' == m_input.m_line[m_input.m_line_index])
          {
            ++m_input.m_line_index;
           
            states = new BitSet();

            /* Parse states. */
            while (true)
              {
                /* We may have reached the end of the line. */
                while (m_input.m_line_index >= m_input.m_line_read)
                  {
                    if (true == m_input.getLine())
                      {
                        /* EOF found. */
                        JJdTyoVCJ.parse_error(JJdTyoVCJ.E_EOF,m_input.m_line_number);
                        return states;
                      }
                  }

                while (true)
                  {
                    /* Skip white space. */
                    while (true == GKmsrthmG.isspace(m_input.m_line[m_input.m_line_index]))
                      {
                        ++m_input.m_line_index;
                        
                        while (m_input.m_line_index >= m_input.m_line_read)
                          {
                            if (true == m_input.getLine())
                              {
                                /* EOF found. */
                                JJdTyoVCJ.parse_error(JJdTyoVCJ.E_EOF,m_input.m_line_number);
                                return states;
                              }
                          }
                      }
                    
                    if (',' != m_input.m_line[m_input.m_line_index])
                      {
                        break;
                      }

                    ++m_input.m_line_index;
                  }

                if ('>' == m_input.m_line[m_input.m_line_index])
                  {
                    ++m_input.m_line_index;
                    if (m_input.m_line_index < m_input.m_line_read)
                      {
                        m_advance_stop = true;
                      }
                    return states;
                  }

                /* Read in state name. */
                start_state = m_input.m_line_index;
                while (false == GKmsrthmG.isspace(m_input.m_line[m_input.m_line_index])
                       && ',' != m_input.m_line[m_input.m_line_index]
                       && '>' != m_input.m_line[m_input.m_line_index])
                  {
                    ++m_input.m_line_index;

                    if (m_input.m_line_index >= m_input.m_line_read)
                      {
                        /* End of line means end of state name. */
                        break;
                      }
                  }
                count_state = m_input.m_line_index - start_state;

                /* Save name after checking definition. */
                name = new String(m_input.m_line,
                                  start_state,
                                  count_state);
                index = (Integer) m_spec.m_states.get(name);
                if (null == index)
                  {
                    /* Uninitialized state. */
                    System.out.println("Uninitialized State Name: " + name);
                    JJdTyoVCJ.parse_error(JJdTyoVCJ.E_STATE,m_input.m_line_number);
                  }
                states.set(index.intValue());
              }
          }
        
        if (null == all_states)
          {
            all_states = new BitSet();

            size = m_spec.m_states.size();
            for (i = 0; i < size; ++i)
              {
                all_states.set(i);
              }
          }
        
        if (m_input.m_line_index < m_input.m_line_read)
          {
            m_advance_stop = true;
          }
        return all_states;
      }

  /********************************************************
    Function: expandMacro
    Description: Returns false on error, true otherwise. 
    *******************************************************/
  private boolean expandMacro
    (
     )
      {
        int elem;
        int start_macro;
        int end_macro;
        int start_name;
        int count_name;
        String def;
        int def_elem;
        String name;
        char replace[];
        int rep_elem;

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != this);
            GKmsrthmG.assert(null != m_outstream);
            GKmsrthmG.assert(null != m_input);
            GKmsrthmG.assert(null != m_tokens);
            GKmsrthmG.assert(null != m_spec);
          }

        /* Check for macro. */
        if ('{' != m_input.m_line[m_input.m_line_index])
          {
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_INTERNAL,m_input.m_line_number);
            return ERROR;
          }
        
        start_macro = m_input.m_line_index;
        elem = m_input.m_line_index + 1;
        if (elem >= m_input.m_line_read)
          {
            JJdTyoVCJ.impos("Unfinished macro name");
            return ERROR;
          }
        
        /* Get macro name. */
        start_name = elem;
        while ('}' != m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                JJdTyoVCJ.impos("Unfinished macro name at line " + m_input.m_line_number);
                return ERROR;
              }
          }
        count_name = elem - start_name;
        end_macro = elem;

        /* Check macro name. */
        if (0 == count_name)
          {
            JJdTyoVCJ.impos("Nonexistent macro name");
            return ERROR;
          }

        /* Debug checks. */
        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(0 < count_name);
          }

        /* Retrieve macro definition. */
        name = new String(m_input.m_line,start_name,count_name);
        def = (String) m_spec.m_macros.get(name);
        if (null == def)
          {
            JJdTyoVCJ.impos("Undefined macro \"" + name + "\" on line: "+m_input.m_line_number);
            return ERROR;
          }
        if (GKmsrthmG.OLD_DUMP_DEBUG)
          {
            System.out.println("expanded escape: " + def);
          }
                
        /* Replace macro in new buffer,
           beginning by copying first part of line buffer. */
        replace = new char[m_input.m_line.length];
        for (rep_elem = 0; rep_elem < start_macro; ++rep_elem)
          {
            replace[rep_elem] = m_input.m_line[rep_elem];

            if (GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(rep_elem < replace.length);
              }
          }
        
        /* Copy macro definition. */
        if (rep_elem >= replace.length)
          {
            replace = GKmsrthmG.doubleSize(replace);
          }
        for (def_elem = 0; def_elem < def.length(); ++def_elem)
          {
            replace[rep_elem] = def.charAt(def_elem);
            
            ++rep_elem;
            if (rep_elem >= replace.length)
              {
                replace = GKmsrthmG.doubleSize(replace);
              }
          }

        /* Copy last part of line. */
        if (rep_elem >= replace.length)
          {
            replace = GKmsrthmG.doubleSize(replace);
          }
        for (elem = end_macro + 1; elem < m_input.m_line_read; ++elem)
          {
            replace[rep_elem] = m_input.m_line[elem];
            
            ++rep_elem;
            if (rep_elem >= replace.length)
              {
                replace = GKmsrthmG.doubleSize(replace);
              }
          } 
        
        /* Replace buffer. */
        m_input.m_line = replace;
        m_input.m_line_read = rep_elem;
        
        if (GKmsrthmG.OLD_DEBUG)
          {
//nsSystem.out.print("macro expansion is:" );
            System.out.println(new String(m_input.m_line,0,m_input.m_line_read));
          }
        return NOT_ERROR;
      }

  /***************************************************************
    Function: saveMacro
    Description: Saves macro definition of form:
    macro_name = macro_definition
    **************************************************************/
  private void saveMacro
    (
     )
      {
        int elem;
        int start_name;
        int count_name;
        int start_def;
        int count_def;
        boolean saw_escape;
        boolean in_quote;

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != this);
            GKmsrthmG.assert(null != m_outstream);
            GKmsrthmG.assert(null != m_input);
            GKmsrthmG.assert(null != m_tokens);
            GKmsrthmG.assert(null != m_spec);
          }

        /* Macro declarations are of the following form:
           macro_name macro_definition */

        elem = 0;
        
        /* Skip white space preceding macro name. */
        while (true == GKmsrthmG.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* End of line has been reached,
                   and line was found to be empty. */
                return;
              }
          }

        /* Read macro name. */
        start_name = elem;
        while (false == GKmsrthmG.isspace(m_input.m_line[elem])
               && '=' != m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                JJdTyoVCJ.parse_error(JJdTyoVCJ.E_MACDEF,m_input.m_line_number);
              }
          }
        count_name = elem - start_name;

        /* Check macro name. */
        if (0 == count_name) 
          {
            /* Nonexistent macro name. */
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_MACDEF,m_input.m_line_number);
          }

        /* Skip white space between name and definition. */
        while (true == GKmsrthmG.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                JJdTyoVCJ.parse_error(JJdTyoVCJ.E_MACDEF,m_input.m_line_number);
              }
          }

        if ('=' == m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                JJdTyoVCJ.parse_error(JJdTyoVCJ.E_MACDEF,m_input.m_line_number);
              }
          }

        /* Skip white space between name and definition. */
        while (true == GKmsrthmG.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                JJdTyoVCJ.parse_error(JJdTyoVCJ.E_MACDEF,m_input.m_line_number);
              }
          }

        /* Read macro definition. */
        start_def = elem;
        in_quote = false;
        saw_escape = false;
        while (false == GKmsrthmG.isspace(m_input.m_line[elem])
               || true == in_quote
               || true == saw_escape)
          {
            if ('\"' == m_input.m_line[elem] && false == saw_escape)
              {
                if (true == in_quote)
                  {
                    in_quote = false;
                  }
                else
                  {
                    in_quote = true;
                  }
              }
            
            if ('\\' == m_input.m_line[elem] && false == saw_escape)
              {
                saw_escape = true;
              }
            else
              {
                saw_escape = false;
              }

            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* End of line. */
                break;
              }
          }
        count_def = elem - start_def;
          
        /* Check macro definition. */
        if (0 == count_def) 
          {
            /* Nonexistent macro name. */
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_MACDEF,m_input.m_line_number);
          }

        /* Debug checks. */
        if (true == GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(0 < count_def);
            GKmsrthmG.assert(0 < count_name);
            GKmsrthmG.assert(null != m_spec.m_macros);
          }

        if (GKmsrthmG.OLD_DEBUG)
          {
            System.out.println("macro name \""
                               + new String(m_input.m_line,start_name,count_name)
                               + "\".");
            System.out.println("macro definition \""
                               + new String(m_input.m_line,start_def,count_def)
                               + "\".");
          }

        /* Add macro name and definition to table. */
        m_spec.m_macros.put(new String(m_input.m_line,start_name,count_name),
                            new String(m_input.m_line,start_def,count_def));
      }

  /***************************************************************
    Function: saveStates
    Description: Takes state declaration and makes entries
    for them in state hashtable in mfKigxveL structure.
    State declaration should be of the form:
    %state name0[, name1, name2 ...]
    (But commas are actually optional as long as there is 
    white space in between them.)
    **************************************************************/
  private void saveStates
    (
     )
      {
        int start_state;
        int count_state;

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != this);
            GKmsrthmG.assert(null != m_outstream);
            GKmsrthmG.assert(null != m_input);
            GKmsrthmG.assert(null != m_tokens);
            GKmsrthmG.assert(null != m_spec);
          }

        /* EOF found? */
        if (true == m_input.m_eof_reached)
          {
            return;
          }

        /* Debug checks. */
        if (true == GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert('%' == m_input.m_line[0]);
            GKmsrthmG.assert('s' == m_input.m_line[1]);
            GKmsrthmG.assert(m_input.m_line_index <= m_input.m_line_read);
            GKmsrthmG.assert(0 <= m_input.m_line_index);
            GKmsrthmG.assert(0 <= m_input.m_line_read);
          }

        /* Blank line?  No states? */
        if (m_input.m_line_index >= m_input.m_line_read)
          {
            return;
          }

        while (m_input.m_line_index < m_input.m_line_read)
          {
            if (GKmsrthmG.OLD_DEBUG)
              {
                System.out.println("line read " + m_input.m_line_read 
                                   + "\tline index = " + m_input.m_line_index);
              }

            /* Skip white space. */
            while (true == GKmsrthmG.isspace(m_input.m_line[m_input.m_line_index]))
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* No more states to be found. */
                    return;
                  }
              }
            
            /* Look for state name. */
            start_state = m_input.m_line_index;
            while (false == GKmsrthmG.isspace(m_input.m_line[m_input.m_line_index])
                   && ',' != m_input.m_line[m_input.m_line_index])
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line and end of state name. */
                    break;
                  }
              }
            count_state = m_input.m_line_index - start_state;

            if (GKmsrthmG.OLD_DEBUG)
              {
                System.out.println("State name \"" 
                                   + new String(m_input.m_line,start_state,count_state)
                                   + "\".");
                System.out.println("Integer index \"" 
                                   + m_spec.m_states.size()
                                   + "\".");
              }

            /* Enter new state name, along with unique index. */
            m_spec.m_states.put(new String(m_input.m_line,start_state,count_state),
                                new Integer(m_spec.m_states.size()));
            
            /* Skip comma. */
            if (',' == m_input.m_line[m_input.m_line_index])
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line. */
                    return;
                  }
              }
          }
      }

  /********************************************************
    Function: expandEscape
    Description: Takes escape sequence and returns
    corresponding character code.
    *******************************************************/
  private char expandEscape
    (
     )
      {
        char r;
        
        /* Debug checks. */
        if (true == GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(m_input.m_line_index < m_input.m_line_read);
            GKmsrthmG.assert(0 < m_input.m_line_read);
            GKmsrthmG.assert(0 <= m_input.m_line_index);
          }

        if ('\\' != m_input.m_line[m_input.m_line_index])
          {
            ++m_input.m_line_index;
            return m_input.m_line[m_input.m_line_index - 1];
          }
        else
          {
            ++m_input.m_line_index;
            switch (GKmsrthmG.toupper(m_input.m_line[m_input.m_line_index]))
              {
              case 'B':
                ++m_input.m_line_index;
                return '\b';

              case 'T':
                ++m_input.m_line_index;
                return '\t';

              case 'N':
                ++m_input.m_line_index;
                return '\n';

              case 'F':
                ++m_input.m_line_index;
                return '\f';

              case 'R':
                ++m_input.m_line_index;
                return '\r';

              case '^':
                ++m_input.m_line_index;
                r = (char) (GKmsrthmG.toupper(m_input.m_line[m_input.m_line_index]) 
                     - '@');
                ++m_input.m_line_index;
                return r;

              case 'X':
                ++m_input.m_line_index;
                r = 0;
                if (true == GKmsrthmG.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = GKmsrthmG.hex2bin(m_input.m_line[m_input.m_line_index]);
                    ++m_input.m_line_index;
                  }
                if (true == GKmsrthmG.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = (char) (r << 4);
                    r = (char) (r | GKmsrthmG.hex2bin(m_input.m_line[m_input.m_line_index]));
                    ++m_input.m_line_index;
                  }
                if (true == GKmsrthmG.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = (char) (r << 4);
                    r = (char) (r | GKmsrthmG.hex2bin(m_input.m_line[m_input.m_line_index]));
                    ++m_input.m_line_index;
                  }
                return r;
                
              default:
                if (false == GKmsrthmG.isoctdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = m_input.m_line[m_input.m_line_index];
                    ++m_input.m_line_index;
                  }
                else
                  {
                    r = GKmsrthmG.oct2bin(m_input.m_line[m_input.m_line_index]);
                    ++m_input.m_line_index;
                    
                    if (true == GKmsrthmG.isoctdigit(m_input.m_line[m_input.m_line_index]))
                      {
                        r = (char) (r << 3);
                        r = (char) (r | GKmsrthmG.oct2bin(m_input.m_line[m_input.m_line_index]));
                        ++m_input.m_line_index;
                      }

                    if (true == GKmsrthmG.isoctdigit(m_input.m_line[m_input.m_line_index]))
                      {
                        r = (char) (r << 3);
                        r = (char) (r | GKmsrthmG.oct2bin(m_input.m_line[m_input.m_line_index]));
                        ++m_input.m_line_index;
                      }
                  }
                return r;
              }
          }
      }
        
  /********************************************************
    Function: packAccept
    Description: Packages and returns oNaJmmlAX 
    for action next in input stream.
    *******************************************************/
  oNaJmmlAX packAccept
    (
     )
      throws java.io.IOException
      {
        oNaJmmlAX accept;
        char action[];
        int action_index;
        int brackets;

        action = new char[BUFFER_SIZE];
        action_index = 0;

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != this);
            GKmsrthmG.assert(null != m_outstream);
            GKmsrthmG.assert(null != m_input);
            GKmsrthmG.assert(null != m_tokens);
            GKmsrthmG.assert(null != m_spec);
          }

        /* Get a new line, if needed. */
        while (m_input.m_line_index >= m_input.m_line_read)
          {
            if (true == m_input.getLine())
              {
                JJdTyoVCJ.parse_error(JJdTyoVCJ.E_EOF,m_input.m_line_number);
                return null;
              }
          }
        
        /* Look for beginning of action. */
        while (true == GKmsrthmG.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
            
            /* Get a new line, if needed. */
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    JJdTyoVCJ.parse_error(JJdTyoVCJ.E_EOF,m_input.m_line_number);
                    return null;
                  }
              }
          }
        
        /* Look for brackets. */
        if ('{' != m_input.m_line[m_input.m_line_index])
          {
            /*System.out.println("<" + m_input.m_line[m_input.m_line_index] + ">");*/
            JJdTyoVCJ.parse_error(JJdTyoVCJ.E_BRACE,m_input.m_line_number); 
          }
        
        /* Copy new line into action buffer. */
        brackets = 0;
        while (true)
          {
            action[action_index] = m_input.m_line[m_input.m_line_index];

            /* Look for brackets. */
            if ('{' == m_input.m_line[m_input.m_line_index])
              {
                ++brackets;
              }
            else if ('}' == m_input.m_line[m_input.m_line_index])
              {
                --brackets;
                
                if (0 == brackets)
                  {
                    ++action_index;
                    ++m_input.m_line_index;

                    break;
                  }
              }
            
            ++action_index;
            /* Double the buffer size, if needed. */
            if (action_index > action.length)
              {
                action = GKmsrthmG.doubleSize(action);
              }

            ++m_input.m_line_index;
            /* Get a new line, if needed. */
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    JJdTyoVCJ.parse_error(JJdTyoVCJ.E_SYNTAX,m_input.m_line_number);
                    return null;
                  }
              }
          }
            
        accept = new oNaJmmlAX(action,action_index,m_input.m_line_number);

        if (GKmsrthmG.DEBUG)
          {
            GKmsrthmG.assert(null != accept);
          }

        if (GKmsrthmG.DESCENT_DEBUG)
          {
            System.out.print("Accepting action:");
            System.out.println(new String(accept.m_action,0,accept.m_action_read));
          }

        return accept;
      }

  /********************************************************
    Function: advance
    Description: Returns code for next token.
    *******************************************************/
  private boolean m_advance_stop = false;
  int advance
    (
     )
      throws java.io.IOException
      {
        boolean saw_escape = false;
        Integer code;
        
        /*if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          GKmsrthmG.assert(m_input.m_line_index <= m_input.m_line_read);
        }*/

        if (true == m_input.m_eof_reached)
          {
            /* EOF has already been reached,
               so return appropriate code. */

            m_spec.m_current_token = END_OF_INPUT;
            m_spec.m_lexeme = '\0';
            return m_spec.m_current_token;
          }

        /* End of previous regular expression?
           Refill line buffer? */
        if (EOS == m_spec.m_current_token
            /* ADDED */
            || m_input.m_line_index >= m_input.m_line_read)
            /* ADDED */
          {
            if (true == m_spec.m_in_quote)
              {
                JJdTyoVCJ.parse_error(JJdTyoVCJ.E_SYNTAX,m_input.m_line_number);
              }
            
            while (true)
              {
                if (false == m_advance_stop  
                    || m_input.m_line_index >= m_input.m_line_read)
                  {
                    if (true == m_input.getLine())
                      {
                        /* EOF has already been reached,
                           so return appropriate code. */
                        
                        m_spec.m_current_token = END_OF_INPUT;
                        m_spec.m_lexeme = '\0';
                        return m_spec.m_current_token;
                      }
                    m_input.m_line_index = 0;
                  }
                else
                  {
                    m_advance_stop = false;
                  }

                while (m_input.m_line_index < m_input.m_line_read
                       && true == GKmsrthmG.isspace(m_input.m_line[m_input.m_line_index]))
                  {
                    ++m_input.m_line_index;
                  }
                
                if (m_input.m_line_index < m_input.m_line_read)
                  {
                    break;
                  }
              }
          }
        
        /*if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_number = " + m_input.m_line_number);
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          GKmsrthmG.assert(m_input.m_line_index <= m_input.m_line_read);
        }*/
        if (GKmsrthmG.DEBUG) {
          GKmsrthmG.assert(m_input.m_line_index <= m_input.m_line_read);
        }

        /* Look for macro expansions. */
        if (false == m_spec.m_in_quote)
          {
            while ('{' == m_input.m_line[m_input.m_line_index])
              {
                expandMacro();

                /* End of line buffer? */
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line signifies the end of 
                       the current regular expression. */

                    m_spec.m_current_token = EOS;
                    m_spec.m_lexeme = '\0';
                    return m_spec.m_current_token;
                  }
              }
          }
            
        /*if (m_input.m_line_index) {
          System.out.println("**********2");
          System.out.println("m_spec.m_in_quote = " + m_spec.m_in_quote);
        }*/

        /*System.out.println("m_spec.m_in_quote = " + m_spec.m_in_quote);
        System.out.println("m_input.m_line_index = " + m_input.m_line_index);
        System.out.println("m_input.m_line_read = " + m_input.m_line_read);*/
        
        /* Look for quotation mark. */
        /* REMOVED */
        /*if ('\"' == m_input.m_line[m_input.m_line_index])*/
        /* REMOVED */
        /* ADDED */
        while ('\"' == m_input.m_line[m_input.m_line_index])
        /* ADDED */
          {
            /* Toggle in-quote status. */
            if (true == m_spec.m_in_quote)
              {
                m_spec.m_in_quote = false;
              }
            else
              {
                m_spec.m_in_quote = true;
              }
            /* ADDED */
            ++m_input.m_line_index;
            /* ADDED */

            if (m_input.m_line_index >= m_input.m_line_read)
              {
                /* End of line signifies the end of 
                   the current regular expression. */

                m_spec.m_current_token = EOS;
                m_spec.m_lexeme = '\0';
                return m_spec.m_current_token;
              }
          }

        if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          GKmsrthmG.assert(m_input.m_line_index <= m_input.m_line_read);
        }

        /* Look for backslash, and corresponding 
           escape sequence. */
        if ('\\' == m_input.m_line[m_input.m_line_index])
          {
            saw_escape = true;
          }
        else
          {
            saw_escape = false;
          }

        if (false == m_spec.m_in_quote)
          {
            if (GKmsrthmG.isspace(m_input.m_line[m_input.m_line_index]))
              {
                /* White space means the end of 
                   the current regular expression. */

                m_spec.m_current_token = EOS;
                m_spec.m_lexeme = '\0';
                return m_spec.m_current_token;
              }

            /* Process escape sequence, if needed. */
            if (true == saw_escape)
              {
                m_spec.m_lexeme = expandEscape();
              }
            else
              {
                m_spec.m_lexeme = m_input.m_line[m_input.m_line_index];
                ++m_input.m_line_index;
              }
          }
        else
          {
            if (true == saw_escape 
                && (m_input.m_line_index + 1) < m_input.m_line_read
                && '\"' == m_input.m_line[m_input.m_line_index + 1])
              {
                m_spec.m_lexeme = '\"';
                m_input.m_line_index = m_input.m_line_index + 2;
              }
            else
              {
                m_spec.m_lexeme = m_input.m_line[m_input.m_line_index];
                ++m_input.m_line_index;
              }
          }
        
        code = (Integer) m_tokens.get(new Character(m_spec.m_lexeme));
        if (true == m_spec.m_in_quote || true == saw_escape)
          {
            m_spec.m_current_token = L;
          }
        else
          {
            if (null == code)
              {
                m_spec.m_current_token = L;
              }
            else
              {
                m_spec.m_current_token = code.intValue();
              }
          }

        if (GKmsrthmG.FOODEBUG)
          {
            System.out.println("Lexeme: " + m_spec.m_lexeme
                               + "\tToken: " + m_spec.m_current_token
                               + "\tIndex: " + m_input.m_line_index);
          }

        return m_spec.m_current_token;
      }

  /***************************************************************
    Function: details
    Description: High level debugging routine.
    **************************************************************/
  private void details
    (
     )
      {
        Enumeration names;
        String name;
        String def;
        Enumeration states;
        String state;
        Integer index;
        int elem;
        int size;

        System.out.println("\n\t** Macros **");
        names = m_spec.m_macros.keys();
        while (true == names.hasMoreElements())
          {
            name = (String) names.nextElement();
            def = (String) m_spec.m_macros.get(name);

            if (GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(null != name);
                GKmsrthmG.assert(null != def);
              }

            System.out.println("Macro name \"" + name 
                               + "\" has definition \"" 
                               + def + "\".");
          }

        System.out.println("\n\t** States **");
        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(null != state);
                GKmsrthmG.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");
          }
            
        System.out.println("\n\t** Character Counting **");
        if (false == m_spec.m_count_chars)
          {
            System.out.println("Character counting is off.");
          }
        else
          {
            if (GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(true == m_spec.m_count_lines);
              }

            System.out.println("Character counting is on.");
          }

        System.out.println("\n\t** Line Counting **");
        if (false == m_spec.m_count_lines)
          {
            System.out.println("Line counting is off.");
          }
        else
          {
            if (GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(true == m_spec.m_count_lines);
              }

            System.out.println("Line counting is on.");
          }

        System.out.println("\n\t** Operating System Specificity **");
        if (false == m_spec.m_unix)
          {
            System.out.println("Not generating UNIX-specific code.");
            System.out.println("(This means that \"\\r\\n\" is a "
                               + "newline, rather than \"\\n\".)");
          }
        else
          {
            System.out.println("Generating UNIX-specific code.");
            System.out.println("(This means that \"\\n\" is a " 
                               + "newline, rather than \"\\r\\n\".)");
          }

        System.out.println("\n\t** Java CUP Compatibility **");
        if (false == m_spec.m_cup_compatible)
          {
            System.out.println("Generating CUP compatible code.");
            System.out.println("(No current results.)");
          }
        else
          {
            System.out.println("Not generating CUP compatible code.");
            System.out.println("(No current results.)");
          }
        
        if (GKmsrthmG.FOODEBUG) {
          if (null != m_spec.m_nfa_states && null != m_spec.m_nfa_start)
            {
              System.out.println("\n\t** NFA machine **");
              print_nfa();
          }
        }

        if (null != m_spec.m_dtrans_vector)
          {
            System.out.println("\n\t** DFA transition table **");
            /*print_header();*/
          }

        /*if (null != m_spec.m_accept_vector && null != m_spec.m_anchor_array)
          {
            System.out.println("\n\t** Accept States and Anchor Vector **");
            print_accept();
          }*/
      }

  /***************************************************************
    function: print_set
    **************************************************************/
  void print_set
    (
     Vector nfa_set
     )
      {
        int size; 
        int elem;
        vjSXErPeE nfa;

        size = nfa_set.size();

        if (0 == size)
          {
            System.out.print("empty ");
          }
        
        for (elem = 0; elem < size; ++elem)
          {
            nfa = (vjSXErPeE) nfa_set.elementAt(elem);
            /*System.out.print(m_spec.m_nfa_states.indexOf(nfa) + " ");*/
            System.out.print(nfa.m_label + " ");
          }
      }

   /***************************************************************
     Function: print_header
     **************************************************************/
  private void print_header
    (
     )
      {
        Enumeration states;
        int i;
        int j;
        int chars_printed = 0;
        UKEULJtgQ dtrans;
        int last_transition;
        String str;
        oNaJmmlAX accept;
        String state;
        Integer index;

        System.out.println("/*---------------------- DFA -----------------------");
        
        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (GKmsrthmG.DEBUG)
              {
                GKmsrthmG.assert(null != state);
                GKmsrthmG.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");

            i = index.intValue();
            if (UKEULJtgQ.F != m_spec.m_state_dtrans[i])
              {
                System.out.println("\tStart index in transition table: "
                                   + m_spec.m_state_dtrans[i]);
              }
            else
              {
                System.out.println("\tNo associated transition states.");
              }
          }

        for (i = 0; i < m_spec.m_dtrans_vector.size(); ++i)
          {
            dtrans = (UKEULJtgQ) m_spec.m_dtrans_vector.elementAt(i);

            if (null == m_spec.m_accept_vector && null == m_spec.m_anchor_array)
              {
                if (null == dtrans.m_accept)
                  {
                    System.out.print(" * State " + i + " [nonaccepting]");
                  }
                else
                  {
                    System.out.print(" * State " + i 
                                     + " [accepting, line "
                                     + dtrans.m_accept.m_line_number 
                                     + " <"
                                     + (new String(dtrans.m_accept.m_action,0,
                                                   dtrans.m_accept.m_action_read))
                                     + ">]");
                    if (mfKigxveL.NONE != dtrans.m_anchor)
                      {
                        System.out.print(" Anchor: "
                                         + ((0 != (dtrans.m_anchor & mfKigxveL.START)) 
                                            ? "start " : "")
                                         + ((0 != (dtrans.m_anchor & mfKigxveL.END)) 
                                            ? "end " : ""));
                      }
                  }
              }
            else
              {
                accept = (oNaJmmlAX) m_spec.m_accept_vector.elementAt(i);

                if (null == accept)
                  {
                    System.out.print(" * State " + i + " [nonaccepting]");
                  }
                else
                  {
                    System.out.print(" * State " + i 
                                     + " [accepting, line "
                                     + accept.m_line_number 
                                     + " <"
                                     + (new String(accept.m_action,0,
                                                   accept.m_action_read))
                                     + ">]");
                    if (mfKigxveL.NONE != m_spec.m_anchor_array[i])
                      {
                        System.out.print(" Anchor: "
                                         + ((0 != (m_spec.m_anchor_array[i] & mfKigxveL.START)) 
                                            ? "start " : "")
                                         + ((0 != (m_spec.m_anchor_array[i] & mfKigxveL.END)) 
                                            ? "end " : ""));
                      }
                  }
              }

            last_transition = -1;
            for (j = 0; j < m_spec.m_dtrans_ncols; ++j)
              {
                if (UKEULJtgQ.F != dtrans.m_dtrans[j])
                  {
                    if (last_transition != dtrans.m_dtrans[j])
                      {
                        System.out.print("\n *    goto " + dtrans.m_dtrans[j]
                                         + " on ");
                        chars_printed = 0;
                      }
                    
                    str = interp_int((int) j);
                    System.out.print(str);
                                
                    chars_printed = chars_printed + str.length(); 
                    if (56 < chars_printed)
                      {
                        System.out.print("\n *             ");
                        chars_printed = 0;
                      }
                    
                    last_transition = dtrans.m_dtrans[j];
                  }
              }
            System.out.println("");
          }
        System.out.println(" */\n");
      }
}

/************************************************************************
  JAVA-LEX COPYRIGHT NOTICE, LICENSE AND DISCLAIMER.
  
  Copyright 1996 by Elliot Joel Berk
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both the copyright notice and this permission notice and warranty
  disclaimer appear in supporting documentation, and that the name of
  Elliot Joel Berk not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.
  
  Elliot Joel Berk disclaims all warranties with regard to this software, 
  including all implied warranties of merchantability and fitness.  In no event
  shall Elliot Joel Berk be liable for any special, indirect or consequential
  damages or any damages whatsoever resulting from loss of use, data or
  profits, whether in an action of contract, negligence or other
  tortious action, arising out of or in connection with the use or
  performance of this software.
  ***********************************************************************/




/**************************************************************
  Java-Lex: A Lexical Analyzer Generator for Java
  Written by Elliot Berk. Copyright 1996.
  Contact at ejberk@princeton.edu.

  Modified N.Shaylor
  08-Sep-96 - Change yy_lookahead, yy_advance(), and YYEOF to be int.
            - Zero yy_char_count every '\n'.
            - Put in a package and define all classes final.
            - Use nshaylor.util.BitSet that checks for the grow
              bug in JDK 1.0.

  07-Oct-96 - Add  yy_getcharArray();

  11-Oct-96 - Use nshaylor.jlx.BitSet that checks for the grow
  
  07-Nov-96 - Make yy_nxt, yy_rmap, yy_cmap, and yy_acpt short arrays
            - Make all constants like YYEOF static

  08-Nov-96 - Change yy_acpt, yy_this_accept, YY_NOT_ACCEPT, and
            - YY_NO_ANCHOR to byte

  11-Nov-96 - Use BufferedOutputStreams to spead things up?
            - Make all final variables static.

  17-Feb-97 - Remove BufferedOutputStreams. Somehow this causes a
              problem and the end of the output file is truncated.
              I don't have the time now to find out why, so we go back
              to the old slow way that works.

  *************************************************************/

/***************************************************************
  Package Declaration
  **************************************************************/
/* UNDONE: Uncomment this. */


/***************************************************************
  Imported Packages
  **************************************************************/



/******************************
  Questions:
  2) How should I use the Java package system
  to make my tool more modularized and
  coherent?

  Unimplemented:
  !) Fix BitSet issues -- expand only when necessary.
  2) Repeated accept rules.
  6) Clean up the vNBAqFnCC class and use buffered
  allocation.
  7) Reading and writing in Unicode.
  Use DataInputStream and DataOutputStream,
  along with writeUTF???
  8) Fix or at least annotate ^x bug.
  9) Add to spec about extending character set.
  10) making sure newlines are handled correctly
  and consistly with the m_unix flag
  11) m_verbose -- what should be done with it?
  12) turn lexical analyzer into a coherent
  Java package
  13) turn lexical analyzer generator into a
  coherent Java package
  16) pretty up generated code
  17) make it possible to have white space in
  regular expressions
  18) clean up all of the class files the lexer
  generator produces when it is compiled,
  and reduce this number in some way.
  24) character format to and from file: writeup
  and implementation
  25) Debug by testing all arcane regular expression cases.
  26) Look for and fix all UNDONE comments below.
  27) Fix package system.
  28) Clean up unnecessary classes.
  *****************************/

/***************************************************************
  Class: aYvbfLVVU
 **************************************************************/
final class aYvbfLVVU //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
    
  /* Lexical States. */
  Hashtable m_states; /* Hashtable taking state indices (Integer) 
                         to state name (String). */

  /* Regular Expression Macros. */ 
  Hashtable m_macros; /* Hashtable taking macro name (String)
                                to corresponding char buffer that
                                holds macro definition. */

  /* NFA Machine. */
  layAuDXcf m_nfa_start; /* Start state of NFA machine. */
  Vector m_nfa_states; /* Vector of states, with index
                                 corresponding to label. */
  
  Vector m_state_rules[]; /* An array of Vectors of Integers.
                                    The ith Vector represents the lexical state
                                    with index i.  The contents of the ith 
                                    Vector are the indices of the NFA start
                                    states that can be matched while in
                                    the ith lexical state. */
                                    

  int m_state_dtrans[];

  /* DFA Machine. */
  Vector m_dfa_states; /* Vector of states, with index
                                 corresponding to label. */
  Hashtable m_dfa_sets; /* Hashtable taking set of NFA states
                                  to corresponding DFA state, 
                                  if the latter exists. */
  
  /* Accept States and Corresponding Anchors. */
  Vector m_accept_vector;
  int m_anchor_array[];

  /* Transition Table. */
  Vector m_dtrans_vector;
  int m_dtrans_ncols;
  int m_row_map[];
  int m_col_map[];

  /* Regular expression token variables. */
  int m_current_token;
  char m_lexeme;
  boolean m_in_quote;

  /* Verbose execturion flag. */
  boolean m_verbose;

  /* Java-Lex directives flags. */
  boolean m_integer_type;
  boolean m_intwrap_type;
  boolean m_yyeof;
  boolean m_count_chars;
  boolean m_count_lines;
  boolean m_cup_compatible;
  boolean m_unix;

  char m_init_code[];
  int m_init_read;

  char m_init_throw_code[];
  int m_init_throw_read;

  char m_class_code[];
  int m_class_read;

  char m_eof_code[];
  int m_eof_read;

  char m_eof_value_code[];
  int m_eof_value_read;

  char m_eof_throw_code[];
  int m_eof_throw_read;

  char m_yylex_throw_code[];
  int m_yylex_throw_read;

  /* Class, function, type names. */
  char m_class_name[] = {          
    'Y', 'y', 'l', 
    'e', 'x' 
    };
  char m_function_name[] = {
    'y', 'y', 'l', 
    'e', 'x' 
    };
  char m_type_name[] = {
    'Y', 'y', 't', 
    'o', 'k', 'e',
    'n'
    };

  /* Lexical Generator. */
  private YUydifjdg m_lexGen;

  /***************************************************************
    Constants
    ***********************************************************/
  static final int NONE = 0;
  static final int START = 1;
  static final int END = 2;
  
  /***************************************************************
    Function: aYvbfLVVU
    Description: Constructor.
    **************************************************************/
  aYvbfLVVU
    (
     YUydifjdg lexGen
     )
      {
        m_lexGen = lexGen;

        /* Initialize regular expression token variables. */
        m_current_token = m_lexGen.EOS;
        m_lexeme = '\0';
        m_in_quote = false;

        /* Initialize hashtable for lexer states. */
        m_states = new Hashtable();
        m_states.put(new String("YYINITIAL"),new Integer(m_states.size()));

        /* Initialize hashtable for lexical macros. */
        m_macros = new Hashtable();

        /* Initialize variables for lexer options. */
        m_integer_type = false;
        m_intwrap_type = false;
        m_count_lines = false;
        m_count_chars = false;
        m_cup_compatible = false;
        m_unix = true;
        m_yyeof = false;

        /* Initialize variables for Java-Lex runtime options. */
        m_verbose = true;

        m_nfa_start = null;
        m_nfa_states = new Vector();
        
        m_dfa_states = new Vector();
        m_dfa_sets = new Hashtable();

        m_dtrans_vector = new Vector();
        m_dtrans_ncols = INAhxAQiZ.MAX_SEVEN_BIT + 1;
        m_row_map = null;
        m_col_map = null;

        m_accept_vector = null;
        m_anchor_array = null;

        m_init_code = null;
        m_init_read = 0;

        m_init_throw_code = null;
        m_init_throw_read = 0;

        m_yylex_throw_code = null;
        m_yylex_throw_read = 0;

        m_class_code = null;
        m_class_read = 0;

        m_eof_code = null;
        m_eof_read = 0;

        m_eof_value_code = null;
        m_eof_value_read = 0;

        m_eof_throw_code = null;
        m_eof_throw_read = 0;

        m_state_dtrans = null;

        m_state_rules = null;
      }
}

/***************************************************************
  Class: PepwQHsOl
  **************************************************************/
final class PepwQHsOl //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private aYvbfLVVU m_spec;
  private DataOutputStream m_outstream;

  /***************************************************************
    Constants: Anchor Types
    **************************************************************/
  private final int START = 1;
  private final int END = 2;
  private final int NONE = 4;

  /***************************************************************
    Constants
    **************************************************************/
  private final boolean EDBG = true;
  private final boolean NOT_EDBG = false;

  /***************************************************************
    Function: PepwQHsOl
    Description: Constructor.
    **************************************************************/
  PepwQHsOl
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: reset
    Description: Clears member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_spec = null;
        m_outstream = null;
      }

  /***************************************************************
    Function: set
    Description: Initializes member variables.
    **************************************************************/
  private void set
    (
     aYvbfLVVU spec,
     OutputStream outstream
     )
      {
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != spec);
            INAhxAQiZ.assert(null != outstream);
          }

        m_spec = spec;
        m_outstream = new DataOutputStream(
                        /*new BufferedOutputStream(*/ outstream /*)*/ ); //**NS**
      }

  /***************************************************************
    Function: emit_imports
    Description: Emits import packages at top of 
    generated source file.
    **************************************************************/
  /*void emit_imports
    (
     aYvbfLVVU spec,
     OutputStream outstream
     )
      throws java.io.IOException      
        {
          set(spec,outstream);
          
          if (INAhxAQiZ.DEBUG)
            {
              INAhxAQiZ.assert(null != m_spec);
              INAhxAQiZ.assert(null != m_outstream);
            }*/
          
          /*m_outstream.writeBytes("import java.lang.String;\n");
          m_outstream.writeBytes("import java.lang.System;\n");
          m_outstream.writeBytes("import java.io.DataInputStream;\n");
          m_outstream.writeBytes("import java.io.InputStream;\n");*/
        /*  
          reset();
        }*/
  
  /***************************************************************
    Function: print_details
    Description: Debugging output.
    **************************************************************/
  private void print_details
    (
     )
      {
        int i;
        int j;
        int next;
        int state;
        uQFetIDnd dtrans;
        xAYJWnUkN accept;
        boolean tr;

        System.out.println("---------------------- Transition Table " 
                           + "----------------------");
        
        for (i = 0; i < m_spec.m_row_map.length; ++i)
          {
            System.out.print("State " + i);
            
            accept = (xAYJWnUkN) m_spec.m_accept_vector.elementAt(i);
            if (null == accept)
              {
                System.out.println(" [nonaccepting]");
              }
            else
              {
                System.out.println(" [accepting, line "
                                 + accept.m_line_number 
                                 + " <"
                                 + (new java.lang.String(accept.m_action,0,
                                               accept.m_action_read))
                                 + ">]");
              }
            dtrans = (uQFetIDnd) m_spec.m_dtrans_vector.elementAt(m_spec.m_row_map[i]);
            
            tr = false;
            state = dtrans.m_dtrans[m_spec.m_col_map[0]];
            if (uQFetIDnd.F != state)
              {
                tr = true;
                System.out.print("\tgoto " + state + " on [" + ((char) 0));
              }
            for (j = 1; j < m_spec.m_dtrans_ncols; ++j)
              {
                next = dtrans.m_dtrans[m_spec.m_col_map[j]];
                if (state == next)
                  {
                    if (uQFetIDnd.F != state)
                      {
                        System.out.print((char) j);
                      }
                  }
                else
                  {
                    state = next;
                    if (true == tr)
                      {
                        System.out.println("]");
                        tr = false;
                      }
                    if (uQFetIDnd.F != state)
                      {
                        tr = true;
                        System.out.print("\tgoto " + state + " on [" + ((char) j));
                      }
                  }
              }
            if (true == tr)
              {
                System.out.println("]");
              }
          }

        System.out.println("---------------------- Transition Table " 
                           + "----------------------");
      }

  /***************************************************************
    Function: emit
    Description: High-level access function to module.
    **************************************************************/
  void emit
    (
     aYvbfLVVU spec,
     OutputStream outstream
     )
      throws java.io.IOException      
        {
          set(spec,outstream);
          
          if (INAhxAQiZ.DEBUG)
            {
              INAhxAQiZ.assert(null != m_spec);
              INAhxAQiZ.assert(null != m_outstream);
            }
          
          if (INAhxAQiZ.OLD_DEBUG) {
            print_details();
          }

          emit_header();
          emit_construct();
          emit_helpers();
          emit_driver();
          emit_footer();
          
          reset();
        }

  /***************************************************************
    Function: emit_construct
    Description: Emits constructor, member variables,
    and constants.
    **************************************************************/
  private void emit_construct
    (
     )
      throws java.io.IOException
        {
          if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != m_spec);
            INAhxAQiZ.assert(null != m_outstream);
          }
          
          /* Constants */
          m_outstream.writeBytes("\tprivate static final int YY_BUFFER_SIZE = 512;\n");  //**NS**

          m_outstream.writeBytes("\tprivate static final int YY_F = -1;\n");             //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_NO_STATE = -1;\n");      //**NS**

          m_outstream.writeBytes("\tprivate static final byte YY_NOT_ACCEPT = 0;\n");     //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_START = 1;\n");          //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_END = 2;\n");            //**NS**
          m_outstream.writeBytes("\tprivate static final byte YY_NO_ANCHOR = 4;\n");      //**NS**

          m_outstream.writeBytes("\tpublic static final int YYEOF = -1;\n");             //**NS**
          
          /* User specified class code. */
          if (null != m_spec.m_class_code)
            {
              m_outstream.writeBytes(new String(m_spec.m_class_code,0,
                                                m_spec.m_class_read));
            }

          /* Member Variables */
          m_outstream.writeBytes("\tprivate java.io.DataInputStream yy_instream;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_index;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_read;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_start;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_end;\n");
          m_outstream.writeBytes("\tprivate byte yy_buffer[];\n");
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\tprivate int yy_char_count;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\tprivate int yy_line_count;\n");
            }
          m_outstream.writeBytes("\tprivate int yy_lexical_state;\n");
          /*if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\tprivate int yy_buffer_prev_start;\n");
            }*/
          
          /* Function: constructor */
          m_outstream.writeBytes("\t");
          m_outstream.writeBytes(new String(m_spec.m_class_name));
          m_outstream.writeBytes(" (java.io.InputStream instream)");
          
          if (null != m_spec.m_init_throw_code)
            {
              m_outstream.writeBytes("\n"); 
              m_outstream.writeBytes("\t\tthrows "); 
              m_outstream.writeBytes(new String(m_spec.m_init_throw_code,0,
                                                m_spec.m_init_throw_read));
              m_outstream.writeBytes("\n\t\t{\n");
            }
          else
            {
              m_outstream.writeBytes(" {\n");
            }
          
          m_outstream.writeBytes("\t\tif (null == instream) {\n");
          m_outstream.writeBytes("\t\t\tthrow (new Error(\"Error: Bad input "
                                 + "stream initializer.\"));\n");
          m_outstream.writeBytes("\t\t}\n");
          m_outstream.writeBytes("\t\tyy_instream = new java.io.DataInputStream(instream);\n");
          m_outstream.writeBytes("\t\tyy_buffer = new byte[YY_BUFFER_SIZE];\n");
          m_outstream.writeBytes("\t\tyy_buffer_read = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_index = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_start = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_end = 0;\n");
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tyy_char_count = 0;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\tyy_line_count = 0;\n");
            }
          m_outstream.writeBytes("\t\tyy_lexical_state = YYINITIAL;\n");
          /*if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tyy_buffer_prev_start = 0;\n");
            }*/

          /* User specified constructor code. */
          if (null != m_spec.m_init_code)
            {
              m_outstream.writeBytes(new String(m_spec.m_init_code,0,
                                                m_spec.m_init_read));
            }

          m_outstream.writeBytes("\t}\n");
        }

  /***************************************************************
    Function: emit_states
    Description: Emits constants that serve as lexical states,
    including YYINITIAL.
    **************************************************************/
  private void emit_states
    (
     )
      throws java.io.IOException
        {
          Enumeration states;
          String state;
          int index;

          states = m_spec.m_states.keys();
          /*index = 0;*/
          while (true == states.hasMoreElements())
            {
              state = (String) states.nextElement();
              
              if (INAhxAQiZ.DEBUG)
                {
                  INAhxAQiZ.assert(null != state);
                }
              
              m_outstream.writeBytes("\tprivate final int " 
                                     + state 
                                     + " = " 
                                     + (m_spec.m_states.get(state)).toString() 
                                     + ";\n");
              /*++index;*/
            }

          m_outstream.writeBytes("\tprivate final int yy_state_dtrans[] = {\n");
          for (index = 0; index < m_spec.m_state_dtrans.length; ++index)
            {
              m_outstream.writeBytes("\t\t" + m_spec.m_state_dtrans[index]);
              if (index < m_spec.m_state_dtrans.length - 1)
                {
                  m_outstream.writeBytes(",\n");
                }
              else
                {
                  m_outstream.writeBytes("\n");
                }
            }
          m_outstream.writeBytes("\t};\n");
        }

  /***************************************************************
    Function: emit_helpers
    Description: Emits helper functions, particularly 
    error handling and input buffering.
    **************************************************************/
  private void emit_helpers
    (
     )
      throws java.io.IOException
      {
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != m_spec);
            INAhxAQiZ.assert(null != m_outstream);
          }

        /* Function: yy_do_eof */
        m_outstream.writeBytes("\tprivate boolean yy_eof_done = false;\n");
        if (null != m_spec.m_eof_code)
          {
            m_outstream.writeBytes("\tprivate void yy_do_eof ()");

            if (null != m_spec.m_eof_throw_code)
              {
                m_outstream.writeBytes("\n"); 
                m_outstream.writeBytes("\t\tthrows "); 
                m_outstream.writeBytes(new String(m_spec.m_eof_throw_code,0,
                                                  m_spec.m_eof_throw_read));
                m_outstream.writeBytes("\n\t\t{\n");
              }
            else
              {
                m_outstream.writeBytes(" {\n");
              }

            m_outstream.writeBytes("\t\tif (false == yy_eof_done) {\n");
            m_outstream.writeBytes(new String(m_spec.m_eof_code,0,
                                              m_spec.m_eof_read));
            m_outstream.writeBytes("\t\t}\n");
            m_outstream.writeBytes("\t\tyy_eof_done = true;\n");
            m_outstream.writeBytes("\t}\n");
          }

        emit_states();
        
        /* Function: yybegin */
        m_outstream.writeBytes("\tprivate void yybegin (int state) {\n");
        m_outstream.writeBytes("\t\tyy_lexical_state = state;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_initial_dtrans */
        /*m_outstream.writeBytes("\tprivate int yy_initial_dtrans (int state) {\n");
        m_outstream.writeBytes("\t\treturn yy_state_dtrans[state];\n");
        m_outstream.writeBytes("\t}\n");*/

        /* Function: yy_advance */
        m_outstream.writeBytes("\tprivate int yy_advance ()\n"); //**NS**
        m_outstream.writeBytes("\t\tthrows java.io.IOException {\n");
        /*m_outstream.writeBytes("\t\t{\n");*/
        m_outstream.writeBytes("\t\tint next_read;\n");
        m_outstream.writeBytes("\t\tint i;\n");
        m_outstream.writeBytes("\t\tint j;\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\tif (yy_buffer_index < yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\treturn yy_buffer[yy_buffer_index++] & 0xFF;\n"); //**NS**
        /*m_outstream.writeBytes("\t\t\t++yy_buffer_index;\n");*/
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\tif (0 != yy_buffer_start) {\n");
        m_outstream.writeBytes("\t\t\ti = yy_buffer_start;\n");
        m_outstream.writeBytes("\t\t\tj = 0;\n");
        m_outstream.writeBytes("\t\t\twhile (i < yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\t\tyy_buffer[j] = yy_buffer[i];\n");
        m_outstream.writeBytes("\t\t\t\t++i;\n");
        m_outstream.writeBytes("\t\t\t\t++j;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_end = yy_buffer_end - yy_buffer_start;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_start = 0;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = j;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_index = j;\n");
        m_outstream.writeBytes("\t\t\tnext_read = yy_instream.read(yy_buffer,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        m_outstream.writeBytes("\t\t\t\treturn YYEOF;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\twhile (yy_buffer_index >= yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\tif (yy_buffer_index >= yy_buffer.length) {\n");
        m_outstream.writeBytes("\t\t\t\tyy_buffer = yy_double(yy_buffer);\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tnext_read = yy_instream.read(yy_buffer,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        m_outstream.writeBytes("\t\t\t\treturn YYEOF;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        m_outstream.writeBytes("\t\t}\n");

        m_outstream.writeBytes("\t\treturn yy_buffer[yy_buffer_index++] & 0xFF;\n"); //**NS**
        m_outstream.writeBytes("\t}\n");
        
        /* Function: yy_move_start */
        m_outstream.writeBytes("\tprivate void yy_move_start () {\n");
        if (true == m_spec.m_count_lines)
          {
            if (true == m_spec.m_unix)
              {
                m_outstream.writeBytes("\t\tif ((byte) '\\n' " 
                                       + "== yy_buffer[yy_buffer_start]) {\n");
              }
            else
              {         
                m_outstream.writeBytes("\t\tif ((byte) '\\n' " 
                                       + "== yy_buffer[yy_buffer_start]\n"); 
                m_outstream.writeBytes("\t\t\t|| (byte) '\\r' " 
                                       + "== yy_buffer[yy_buffer_start]) {\n");
              }
            m_outstream.writeBytes("\t\t\t++yy_line_count; yy_char_count = 0;\n"); //**NS**
            m_outstream.writeBytes("\t\t}\n");
          }
        if (true == m_spec.m_count_chars)
          {
            m_outstream.writeBytes("\t\t++yy_char_count;\n");
          }
        m_outstream.writeBytes("\t\t++yy_buffer_start;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_pushback */
        m_outstream.writeBytes("\tprivate void yy_pushback () {\n");
        m_outstream.writeBytes("\t\t--yy_buffer_end;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_mark_start */
        m_outstream.writeBytes("\tprivate void yy_mark_start () {\n");
        if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
          {
            if (true == m_spec.m_count_lines)
              {
                m_outstream.writeBytes("\t\tint i;\n");
                m_outstream.writeBytes("\t\tfor (i = yy_buffer_start; " 
                                       + "i < yy_buffer_index; ++i) {\n");
                if (true == m_spec.m_unix)
                  {
                    m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i]) {\n");
                  }
                else
                  {             
                    m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i] || " 
                                           + "(byte) '\\r' == yy_buffer[i]) {\n");
                  }
                m_outstream.writeBytes("\t\t\t\t++yy_line_count;  yy_char_count = 0;\n"); //**NS**
                m_outstream.writeBytes("\t\t\t}\n");
                m_outstream.writeBytes("\t\t++yy_char_count;\n"); //**NS**               
                m_outstream.writeBytes("\t\t}\n");
              }
            if (true == m_spec.m_count_chars)
              {
//**NS**                m_outstream.writeBytes("\t\tyy_char_count = yy_char_count\n"); 
//**NS**                m_outstream.writeBytes("\t\t\t+ yy_buffer_index - yy_buffer_start;\n");
              }
          }
        m_outstream.writeBytes("\t\tyy_buffer_start = yy_buffer_index;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_mark_end */
        m_outstream.writeBytes("\tprivate void yy_mark_end () {\n");
        m_outstream.writeBytes("\t\tyy_buffer_end = yy_buffer_index;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_to_mark */
        m_outstream.writeBytes("\tprivate void yy_to_mark () {\n");
        m_outstream.writeBytes("\t\tyy_buffer_index = yy_buffer_end;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_gettext */
        m_outstream.writeBytes("\tprivate java.lang.String yy_gettext () {\n");
        m_outstream.writeBytes("\t\treturn (new java.lang.String(yy_buffer,0,\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_start,\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_end - yy_buffer_start));\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_getcharArray */
        m_outstream.writeBytes("private char[] yy_getcharArray()\n"); 
        m_outstream.writeBytes("\t{\n");  	
        m_outstream.writeBytes("\tint  count   = yy_buffer_end - yy_buffer_start;\n");
        m_outstream.writeBytes("\tchar value[] = new char[count];\n");
        m_outstream.writeBytes("\tfor( int i = count ; i-- > 0 ; )\n");
        m_outstream.writeBytes("\t\tvalue[i] = (char) (yy_buffer[i + yy_buffer_start] & 0xff);\n");
        m_outstream.writeBytes("\treturn value;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_getchar */
        if (true == m_spec.m_count_chars)
          {
            m_outstream.writeBytes("\tprivate int yy_getchar () {\n");
            m_outstream.writeBytes("\t\treturn yy_char_count;\n");
            m_outstream.writeBytes("\t}\n");
          }

        /* Function: yy_getline */
        if (true == m_spec.m_count_lines)
          {
            m_outstream.writeBytes("\tprivate int yy_getline () {\n");
            m_outstream.writeBytes("\t\treturn yy_line_count;\n");
            m_outstream.writeBytes("\t}\n");
          }

        /* Function: yy_double */
        m_outstream.writeBytes("\tprivate byte[] yy_double (byte buf[]) {\n");
        m_outstream.writeBytes("\t\tint i;\n\t\tbyte newbuf[];\n");
        m_outstream.writeBytes("\t\tnewbuf = new byte[2*buf.length];\n");
        m_outstream.writeBytes("\t\tfor (i = 0; i < buf.length; ++i) {\n");
        m_outstream.writeBytes("\t\t\tnewbuf[i] = buf[i];\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\t\treturn newbuf;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_error */
        m_outstream.writeBytes("\tprivate final int YY_E_INTERNAL = 0;\n");
        m_outstream.writeBytes("\tprivate final int YY_E_MATCH = 1;\n");
        m_outstream.writeBytes("\tprivate java.lang.String yy_error_string[] = {\n");
        m_outstream.writeBytes("\t\t\"Error: Internal error.\\n\",\n");
        m_outstream.writeBytes("\t\t\"Error: Unmatched input.\\n\"\n");
        m_outstream.writeBytes("\t};\n");
        m_outstream.writeBytes("\tprivate void yy_error (int code,boolean fatal) {\n");
        m_outstream.writeBytes("\t\tjava.lang.System.out.print(yy_error_string[code]);\n");
        m_outstream.writeBytes("\t\tjava.lang.System.out.flush();\n");
        m_outstream.writeBytes("\t\tif (true == fatal) {\n");
        m_outstream.writeBytes("\t\t\tthrow new Error(\"Fatal Error.\\n\");\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_next */
        /*m_outstream.writeBytes("\tprivate int yy_next (int current,byte lookahead) {\n");
        m_outstream.writeBytes("\t\treturn yy_nxt[yy_rmap[current]][yy_cmap[lookahead]];\n");
        m_outstream.writeBytes("\t}\n");*/

        /* Function: yy_accept */
        /*m_outstream.writeBytes("\tprivate int yy_accept (int current) {\n");
        m_outstream.writeBytes("\t\treturn yy_acpt[current];\n");
        m_outstream.writeBytes("\t}\n");*/
      }

  /***************************************************************
    Function: emit_header
    Description: Emits class header.
    **************************************************************/
  private void emit_header
    (
     )
      throws java.io.IOException
      {
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != m_spec);
            INAhxAQiZ.assert(null != m_outstream);
          }

        m_outstream.writeBytes("\n\nclass ");
        m_outstream.writeBytes(new String(m_spec.m_class_name,0,
                                          m_spec.m_class_name.length));
        m_outstream.writeBytes(" {\n");
      }

  /***************************************************************
    Function: emit_table
    Description: Emits transition table.
    **************************************************************/
  private void emit_table
    (
     )
      throws java.io.IOException
      {
        int i;
        int elem;
        int size;
        uQFetIDnd dtrans;
        boolean is_start;
        boolean is_end;
        xAYJWnUkN accept;

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != m_spec);
            INAhxAQiZ.assert(null != m_outstream);
          }

        m_outstream.writeBytes("\tprivate byte yy_acpt[] = {\n");  //**NS**
        size = m_spec.m_accept_vector.size();
        for (elem = 0; elem < size; ++elem)
          {
            accept = (xAYJWnUkN) m_spec.m_accept_vector.elementAt(elem);
            
            if (null != accept)
              {
                is_start = (0 != (m_spec.m_anchor_array[elem] & aYvbfLVVU.START));
                is_end = (0 != (m_spec.m_anchor_array[elem] & aYvbfLVVU.END));
                
                if (true == is_start && true == is_end)
                  {
                    m_outstream.writeBytes("\t\tYY_START | YY_END");
                  }
                else if (true == is_start)
                  {
                    m_outstream.writeBytes("\t\tYY_START");
                  }
                else if (true == is_end)
                  {
                    m_outstream.writeBytes("\t\tYY_END");
                  }
                else
                  {
                    m_outstream.writeBytes("\t\tYY_NO_ANCHOR");
                  }
              }
            else 
              {
                m_outstream.writeBytes("\t\tYY_NOT_ACCEPT");
              }
            
            if (elem < size - 1)
              {
                m_outstream.writeBytes(",");
              }
            
            m_outstream.writeBytes("\n");
          }
        m_outstream.writeBytes("\t};\n");

        m_outstream.writeBytes("\tprivate short yy_cmap[] = {\n\t\t");  //**NS**
        for (i = 0; i < m_spec.m_col_map.length; ++i)
          {
            m_outstream.writeBytes((new Integer(m_spec.m_col_map[i])).toString());
            
            if (i < m_spec.m_col_map.length - 1)
              {
                m_outstream.writeBytes(",");
              }

            if (0 == ((i + 1) % 8))
              {
                m_outstream.writeBytes("\n\t\t");
              }
            else
              {
                m_outstream.writeBytes(" ");
              }
          }
        m_outstream.writeBytes("\n\t};\n");

        m_outstream.writeBytes("\tprivate short yy_rmap[] = {\n\t\t");  //**NS**
        for (i = 0; i < m_spec.m_row_map.length; ++i)
          {
            m_outstream.writeBytes((new Integer(m_spec.m_row_map[i])).toString());
            
            if (i < m_spec.m_row_map.length - 1)
              {
                m_outstream.writeBytes(",");
              }

            if (0 == ((i + 1) % 8))
              {
                m_outstream.writeBytes("\n\t\t");
              }
            else
              {
                m_outstream.writeBytes(" ");
              }
          }
        m_outstream.writeBytes("\n\t};\n");

        m_outstream.writeBytes("\tprivate short yy_nxt[][] = {\n");  //**NS**
        size = m_spec.m_dtrans_vector.size();
        for (elem = 0; elem < size; ++elem)
          {
            dtrans = (uQFetIDnd) m_spec.m_dtrans_vector.elementAt(elem);
            
            m_outstream.writeBytes("\t\t{ ");
        
            for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
              {
                m_outstream.writeBytes((new Integer(dtrans.m_dtrans[i])).toString());
                
                if (i < m_spec.m_dtrans_ncols - 1)
                  {
                    m_outstream.writeBytes(",");
                  }
                
                if (0 == ((i + 1) % 8))
                  {
                    m_outstream.writeBytes("\n\t\t\t");
                  }
                else
                  {
                    m_outstream.writeBytes(" ");
                  }
              }

            m_outstream.writeBytes("\n\t\t}");

            if (elem < size - 1)
              {
                m_outstream.writeBytes(",");
              }

            m_outstream.writeBytes("\n");
          }
        m_outstream.writeBytes("\t};\n");
      }

  /***************************************************************
    Function: emit_driver
    Description: 
    **************************************************************/
  private void emit_driver
    (
     )
      throws java.io.IOException
        {
          if (INAhxAQiZ.DEBUG)
            {
              INAhxAQiZ.assert(null != m_spec);
              INAhxAQiZ.assert(null != m_outstream);
            }
          
          emit_table();

          if (true == m_spec.m_integer_type)
            {
              m_outstream.writeBytes("\tpublic int ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }
          else if (true == m_spec.m_intwrap_type)
            {
              m_outstream.writeBytes("\tpublic java.lang.Integer ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }
          else
            {
              m_outstream.writeBytes("\tpublic ");
              m_outstream.writeBytes(new String(m_spec.m_type_name));
              m_outstream.writeBytes(" ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }

          /*m_outstream.writeBytes("\t\tthrows java.io.IOException {\n");*/
          m_outstream.writeBytes("\t\tthrows java.io.IOException");
          if (null != m_spec.m_yylex_throw_code)
            {
              m_outstream.writeBytes(", "); 
              m_outstream.writeBytes(new String(m_spec.m_yylex_throw_code,0,
                                                m_spec.m_yylex_throw_read));
              m_outstream.writeBytes("\n\t\t{\n");
            }
          else
            {
              m_outstream.writeBytes(" {\n");
            }

          m_outstream.writeBytes("\t\tint yy_lookahead;\n");
          m_outstream.writeBytes("\t\tint yy_anchor = YY_NO_ANCHOR;\n");
          /*m_outstream.writeBytes("\t\tint yy_state "
            + "= yy_initial_dtrans(yy_lexical_state);\n");*/
          m_outstream.writeBytes("\t\tint yy_state " 
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\tint yy_next_state = YY_NO_STATE;\n");
          /*m_outstream.writeBytes("\t\tint yy_prev_state = YY_NO_STATE;\n");*/
          m_outstream.writeBytes("\t\tint yy_last_accept_state = YY_NO_STATE;\n");
          m_outstream.writeBytes("\t\tboolean yy_initial = true;\n");
          m_outstream.writeBytes("\t\tbyte yy_this_accept;\n"); // **NS**
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tint yychar;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\tint yyline;\n");
            }
          m_outstream.writeBytes("\t\tjava.lang.String yytext;\n");
          m_outstream.writeBytes("\n");

          m_outstream.writeBytes("\t\tyy_mark_start();\n");
          /*m_outstream.writeBytes("\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\tyy_mark_end();\n");
          m_outstream.writeBytes("\t\t}\n");

          if (NOT_EDBG)
            {
              m_outstream.writeBytes("\t\tjava.lang.System.out.println(\"Begin\");\n");
            }

          m_outstream.writeBytes("\t\twhile (true) {\n");

          m_outstream.writeBytes("\t\t\tyy_lookahead = yy_advance();\n");
          m_outstream.writeBytes("\t\t\tyy_next_state = YY_F;\n");
          m_outstream.writeBytes("\t\t\tif (YYEOF != yy_lookahead) {\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_next_state = "
                                 + "yy_next(yy_state,yy_lookahead);\n");*/
          m_outstream.writeBytes("\t\t\t\tyy_next_state = "
                                 + "yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];\n");
          
          m_outstream.writeBytes("\t\t\t}\n");

          if (NOT_EDBG)
            {
              m_outstream.writeBytes("java.lang.System.out.println(\"Current state: \"" 
                                     + " + yy_state\n");
              m_outstream.writeBytes("+ \"\tCurrent input: \"\n"); 
              m_outstream.writeBytes(" + ((char) yy_lookahead));\n");
            }
          if (NOT_EDBG)
            {
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"State = \"" 
                                     + "+ yy_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Accepting status = \"" 
                                     + "+ yy_this_accept);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Last accepting state = \"" 
                                     + "+ yy_last_accept_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Next state = \"" 
                                     + "+ yy_next_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Lookahead input = \"" 
                                     + "+ ((char) yy_lookahead));\n");
            }

          m_outstream.writeBytes("\t\t\tif (YY_F != yy_next_state) {\n");
          m_outstream.writeBytes("\t\t\t\tyy_state = yy_next_state;\n");
          m_outstream.writeBytes("\t\t\t\tyy_initial = false;\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_mark_end();\n");
          m_outstream.writeBytes("\t\t\t\t}\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_prev_state = yy_state;\n");*/
          /*m_outstream.writeBytes("\t\t\t\tyy_state = yy_next_state;\n");*/
          m_outstream.writeBytes("\t\t\t}\n");

          m_outstream.writeBytes("\t\t\telse {\n");
          m_outstream.writeBytes("\t\t\t\tif (YYEOF == yy_lookahead " 
                                 + "&& true == yy_initial) {\n");
          if (null != m_spec.m_eof_code)
            {
              m_outstream.writeBytes("\t\t\t\t\tyy_do_eof();\n");
            }

          if (true == m_spec.m_integer_type || true == m_spec.m_yyeof)
            {
              m_outstream.writeBytes("\t\t\t\t\treturn YYEOF;\n");
            }
          else if (null != m_spec.m_eof_value_code) 
            {
              m_outstream.writeBytes(new String(m_spec.m_eof_value_code,0,
                                                m_spec.m_eof_value_read));
            }
          else
            {
              m_outstream.writeBytes("\t\t\t\t\treturn null;\n");
            }

          m_outstream.writeBytes("\t\t\t\t}\n");
          
          m_outstream.writeBytes("\t\t\t\telse if (YY_NO_STATE == yy_last_accept_state) {\n");
          

          /*m_outstream.writeBytes("\t\t\t\t\tyy_error(YY_E_MATCH,false);\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_initial = true;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_state "
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_next_state = YY_NO_STATE;\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_prev_state = YY_NO_STATE;\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_mark_start();\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");*/

          m_outstream.writeBytes("\t\t\t\t\tthrow (new Error(\"Lexical Error: Unmatched Input.\"));\n");
          m_outstream.writeBytes("\t\t\t\t}\n");

          m_outstream.writeBytes("\t\t\t\telse {\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_to_mark();\n");

          m_outstream.writeBytes("\t\t\t\t\tyy_anchor = yy_acpt[yy_last_accept_state];\n");
          /*m_outstream.writeBytes("\t\t\t\t\tyy_anchor " 
            + "= yy_accept(yy_last_accept_state);\n");*/
          m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_END & yy_anchor)) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_pushback();\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");
          m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_START & yy_anchor)) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_move_start();\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");

          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\t\t\t\tyychar = yy_getchar();\n");
            }

          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\t\t\t\tyyline = yy_getline();\n");
            }

          m_outstream.writeBytes("\t\t\t\t\tyytext = yy_gettext();\n");

          m_outstream.writeBytes("\t\t\t\t\tswitch (yy_last_accept_state) {\n");

          emit_actions("\t\t\t\t\t");

          m_outstream.writeBytes("\t\t\t\t\tdefault:\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_error(YY_E_INTERNAL,false);\n");
          /*m_outstream.writeBytes("\t\t\t\t\t\treturn null;\n");*/
          m_outstream.writeBytes("\t\t\t\t\tcase -1:\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");
          
          m_outstream.writeBytes("\t\t\t\t\tyy_initial = true;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_state "
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_next_state = YY_NO_STATE;\n");
          /*m_outstream.writeBytes("\t\t\t\t\tyy_prev_state = YY_NO_STATE;\n");*/
          m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;\n");

          m_outstream.writeBytes("\t\t\t\t\tyy_mark_start();\n");

          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");

          m_outstream.writeBytes("\t\t\t\t}\n");          
          m_outstream.writeBytes("\t\t\t}\n");
          m_outstream.writeBytes("\t\t}\n");
          m_outstream.writeBytes("\t}\n");

          /*m_outstream.writeBytes("\t\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t}\n");*/
        }
  
  /***************************************************************
    Function: emit_actions
    Description:     
    **************************************************************/
  private void emit_actions 
    (
     String tabs
     )
      throws java.io.IOException
        {
          int elem;
          int size;
          int bogus_index;
          xAYJWnUkN accept;
          
          if (INAhxAQiZ.DEBUG)
            {
              INAhxAQiZ.assert(m_spec.m_accept_vector.size() 
                              == m_spec.m_anchor_array.length);
            }

          bogus_index = -2;
          size = m_spec.m_accept_vector.size();
          for (elem = 0; elem < size; ++elem)
            {
              accept = (xAYJWnUkN) m_spec.m_accept_vector.elementAt(elem);
              if (null != accept) 
                {
                  m_outstream.writeBytes(tabs + "case " + elem 
                                         /*+ (new Integer(elem)).toString()*/
                                         + ":\n");
                  m_outstream.writeBytes(tabs + "\t");
                  m_outstream.writeBytes(new String(accept.m_action,0,
                                                    accept.m_action_read));
                  m_outstream.writeBytes("\n");
                  m_outstream.writeBytes(tabs + "case " + bogus_index + ":\n");
                  m_outstream.writeBytes(tabs + "\tbreak;\n");
                  --bogus_index;
                }
            }
        }
  
  /***************************************************************
    Function: emit_footer
    Description:     
    **************************************************************/
  private void emit_footer
    (
     )
      throws java.io.IOException
      {
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != m_spec);
            INAhxAQiZ.assert(null != m_outstream);
          }

        m_outstream.writeBytes("}\n");
      }
}

/***************************************************************
  Class: MXozxsWOU
  **************************************************************/
final class MXozxsWOU //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  Vector m_nfa_set; /* Vector of layAuDXcf states in dfa state. */
  BitSet m_nfa_bit; /* BitSet representation of layAuDXcf labels. */
  xAYJWnUkN m_accept; /* Accepting actions, or null if nonaccepting state. */
  int m_anchor; /* Anchors on regular expression. */
  int m_accept_index; /* layAuDXcf index corresponding to accepting actions. */

  /***************************************************************
    Function: MXozxsWOU
    Description: Constructor.
    **************************************************************/
  MXozxsWOU
    (
     )
      {
        m_nfa_set = null;
        m_nfa_bit = null;
        m_accept = null;
        m_anchor = aYvbfLVVU.NONE;
        m_accept_index = -1;
      }
}

/***************************************************************
  Class: WGsEYKEwb
  **************************************************************/
final class WGsEYKEwb //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private aYvbfLVVU m_spec;
  private YUydifjdg m_lexGen;
  private WiTcXJFSS m_input;

  /***************************************************************
    Function: WGsEYKEwb
    Description: Constructor.
    **************************************************************/
  WGsEYKEwb
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: reset
    Description: Resets WGsEYKEwb member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_input = null;
        m_lexGen = null;
        m_spec = null;
      }

  /***************************************************************
    Function: set
    Description: Sets WGsEYKEwb member variables.
    **************************************************************/
  private void set
    (
     YUydifjdg lexGen,
     aYvbfLVVU spec,
     WiTcXJFSS input
     )
      {
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != input);
            INAhxAQiZ.assert(null != lexGen);
            INAhxAQiZ.assert(null != spec);
          }

        m_input = input;
        m_lexGen = lexGen;
        m_spec = spec;
      }

  /***************************************************************
    Function: thompson
    Description: High level access function to module.
    Deposits result in input aYvbfLVVU.
    **************************************************************/
  void thompson
    (
     YUydifjdg lexGen,
     aYvbfLVVU spec,
     WiTcXJFSS input
     )
      throws java.io.IOException      
        {       
          int i;
          layAuDXcf elem;
          int size;

          /* Set member variables. */
          reset();
          set(lexGen,spec,input);
          size = m_spec.m_states.size();       
          m_spec.m_state_rules = new Vector[size];
          for (i = 0; i < size; ++i)
            {       
              m_spec.m_state_rules[i] = new Vector();
            }

          /* Initialize current token variable 
             and create nfa. */
          /*m_spec.m_current_token = m_lexGen.EOS;
          m_lexGen.advance();*/

          m_spec.m_nfa_start = machine();
          
          /* Set labels in created nfa machine. */
          size = m_spec.m_nfa_states.size();
          for (i = 0; i < size; ++i)
            {        
              elem = (layAuDXcf) m_spec.m_nfa_states.elementAt(i);
              elem.m_label = i;
            }

          /* Debugging output. */
          if (INAhxAQiZ.DO_DEBUG)
            {
              m_lexGen.print_nfa();
            }

          if (true == m_spec.m_verbose)
            {
              System.out.println("NFA comprised of " 
                                 + (m_spec.m_nfa_states.size() + 1) 
                                 + " states.");
            }

          reset();
        }
     
  /***************************************************************
    Function: discardlayAuDXcf
    Description: 
    **************************************************************/
  private void discardlayAuDXcf
    (
     layAuDXcf nfa
     )
      {
        m_spec.m_nfa_states.removeElement(nfa);
      }

  /***************************************************************
    Function: processStates
    Description:
    **************************************************************/
  private void processStates
    (
     BitSet states,
     layAuDXcf current
     )
      {
        int size;
        int i;
        
        size = m_spec.m_states.size();
        for (i = 0; i <  size; ++i)
          {
            if (true == states.get(i))
              {
                m_spec.m_state_rules[i].addElement(current);
              }
          }
      }

  /***************************************************************
    Function: machine
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private layAuDXcf machine
    (
     )
      throws java.io.IOException 
      {
        layAuDXcf start;
        layAuDXcf p;
        BitSet states;

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.enter("machine",m_spec.m_lexeme,m_spec.m_current_token);
          }

        states = m_lexGen.getStates();

        /* Begin: Added for states. */
        m_spec.m_current_token = m_lexGen.EOS;
        m_lexGen.advance();
        /* End: Added for states. */
        
        start = vNBAqFnCC.newlayAuDXcf(m_spec);
        p = start;
        p.m_next = rule();

        processStates(states,p.m_next);

        while (m_lexGen.END_OF_INPUT != m_spec.m_current_token)
          {
            /* Make state changes HERE. */
            states = m_lexGen.getStates();
        
            /* Begin: Added for states. */
            m_lexGen.advance();
            if (m_lexGen.END_OF_INPUT == m_spec.m_current_token)
              { 
                break;
              }
            /* End: Added for states. */
            
            p.m_next2 = vNBAqFnCC.newlayAuDXcf(m_spec);
            p = p.m_next2;
            p.m_next = rule();
            
            processStates(states,p.m_next);
          }

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.leave("machine",m_spec.m_lexeme,m_spec.m_current_token);
          }

        return start;
      }
  
  /***************************************************************
    Function: rule
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private layAuDXcf rule
    (
     )
      throws java.io.IOException 
      {
        owjuLNyxC pair; 
        layAuDXcf p;
        layAuDXcf start = null;
        layAuDXcf end = null;
        int anchor = aYvbfLVVU.NONE;

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.enter("rule",m_spec.m_lexeme,m_spec.m_current_token);
          }

        pair = vNBAqFnCC.newowjuLNyxC();

        if (m_lexGen.AT_BOL == m_spec.m_current_token)
          {
            start = vNBAqFnCC.newlayAuDXcf(m_spec);
            start.m_edge = '\n';
            anchor = anchor | aYvbfLVVU.START;
            m_lexGen.advance();

            expr(pair);
            start.m_next = pair.m_start;
            end = pair.m_end;
          }
        else
          {
            expr(pair);
            start = pair.m_start;
            end = pair.m_end;
          }

        if (m_lexGen.AT_EOL == m_spec.m_current_token)
          {
            m_lexGen.advance();
            end.m_next = vNBAqFnCC.newlayAuDXcf(m_spec);
            
            /* This is the way he does it. */
            end.m_edge = layAuDXcf.CCL;
            end.m_set = new pSbNWjWEi();

            end.m_set.add('\n');

            if (false == m_spec.m_unix)
              {
                end.m_set.add('\r');
              }
                
            end = end.m_next;
            anchor = anchor | aYvbfLVVU.END;
          }

        /* Handle end of regular expression.  See page 103. */
        end.m_accept = m_lexGen.packAccept();
        end.m_anchor = anchor;

        /* Begin: Removed for states. */
        /*m_lexGen.advance();*/
        /* End: Removed for states. */

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.leave("rule",m_spec.m_lexeme,m_spec.m_current_token);
          }

        return start;
      }
            
  /***************************************************************
    Function: expr
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void expr
    (
     owjuLNyxC pair
     )
      throws java.io.IOException 
      {
        owjuLNyxC e2_pair;
        layAuDXcf p;
        
        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.enter("expr",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != pair);
          }

        e2_pair = vNBAqFnCC.newowjuLNyxC();

        cat_expr(pair);
        
        while (m_lexGen.OR == m_spec.m_current_token)
          {
            m_lexGen.advance();
            cat_expr(e2_pair);

            p = vNBAqFnCC.newlayAuDXcf(m_spec);
            p.m_next2 = e2_pair.m_start;
            p.m_next = pair.m_start;
            pair.m_start = p;
            
            p = vNBAqFnCC.newlayAuDXcf(m_spec);
            pair.m_end.m_next = p;
            e2_pair.m_end.m_next = p;
            pair.m_end = p;
          }

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.leave("expr",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
            
  /***************************************************************
    Function: cat_expr
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void cat_expr
    (
     owjuLNyxC pair
     )
      throws java.io.IOException 
      {
        owjuLNyxC e2_pair;

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.enter("cat_expr",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != pair);
          }
        
        e2_pair = vNBAqFnCC.newowjuLNyxC();
        
        if (true == first_in_cat(m_spec.m_current_token))
          {
            factor(pair);
          }

        while (true == first_in_cat(m_spec.m_current_token))
          {
            factor(e2_pair);

            /* Destroy */
            pair.m_end.mimic(e2_pair.m_start);
            discardlayAuDXcf(e2_pair.m_start);
            
            pair.m_end = e2_pair.m_end;
          }

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.leave("cat_expr",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
  
  /***************************************************************
    Function: first_in_cat
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private boolean first_in_cat
    (
     int token
     )
      {
        switch (token)
          {
          case m_lexGen.CLOSE_PAREN:
          case m_lexGen.AT_EOL:
          case m_lexGen.OR:
          case m_lexGen.EOS:
            return false;
            
          case m_lexGen.CLOSURE:
          case m_lexGen.PLUS_CLOSE:
          case m_lexGen.OPTIONAL:
            fdUvxtAVx.parse_error(fdUvxtAVx.E_CLOSE,m_input.m_line_number);
            return false;

          case m_lexGen.CCL_END:
            fdUvxtAVx.parse_error(fdUvxtAVx.E_BRACKET,m_input.m_line_number);
            return false;

          case m_lexGen.AT_BOL:
            fdUvxtAVx.parse_error(fdUvxtAVx.E_BOL,m_input.m_line_number);
            return false;

          default:
            break;
          }

        return true;
      }

  /***************************************************************
    Function: factor
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void factor
    (
     owjuLNyxC pair
     )
      throws java.io.IOException 
      {
        layAuDXcf start = null;
        layAuDXcf end = null;

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.enter("factor",m_spec.m_lexeme,m_spec.m_current_token);
          }

        term(pair);

        if (m_lexGen.CLOSURE == m_spec.m_current_token
            || m_lexGen.PLUS_CLOSE == m_spec.m_current_token
            || m_lexGen.OPTIONAL == m_spec.m_current_token)
          {
            start = vNBAqFnCC.newlayAuDXcf(m_spec);
            end = vNBAqFnCC.newlayAuDXcf(m_spec);
            
            start.m_next = pair.m_start;
            pair.m_end.m_next = end;

            if (m_lexGen.CLOSURE == m_spec.m_current_token
                || m_lexGen.OPTIONAL == m_spec.m_current_token)
              {
                start.m_next2 = end;
              }
            
            if (m_lexGen.CLOSURE == m_spec.m_current_token
                || m_lexGen.PLUS_CLOSE == m_spec.m_current_token)
              {
                pair.m_end.m_next2 = pair.m_start;
              }
            
            pair.m_start = start;
            pair.m_end = end;
            m_lexGen.advance();
          }

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.leave("factor",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
      
  /***************************************************************
    Function: term
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void term
    (
     owjuLNyxC pair
     )
      throws java.io.IOException 
      {
        layAuDXcf start;
        int c;

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.enter("term",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (m_lexGen.OPEN_PAREN == m_spec.m_current_token)
          {
            m_lexGen.advance();
            expr(pair);

            if (m_lexGen.CLOSE_PAREN == m_spec.m_current_token)
              {
                m_lexGen.advance();
              }
            else
              {
                fdUvxtAVx.parse_error(fdUvxtAVx.E_SYNTAX,m_input.m_line_number);
              }
          }
        else
          {
            start = vNBAqFnCC.newlayAuDXcf(m_spec);
            pair.m_start = start;

            start.m_next = vNBAqFnCC.newlayAuDXcf(m_spec);
            pair.m_end = start.m_next;

            if (false == (m_lexGen.ANY == m_spec.m_current_token
                          || m_lexGen.CCL_START == m_spec.m_current_token))
              {
                start.m_edge = m_spec.m_lexeme;
                m_lexGen.advance();
              }
            else
              {
                start.m_edge = layAuDXcf.CCL;
                
                start.m_set = new pSbNWjWEi();

                /* Match dot (.) using character class. */
                if (m_lexGen.ANY == m_spec.m_current_token)
                  {
                    start.m_set.add((byte) '\n');
                    if (false == m_spec.m_unix)
                      {
                        start.m_set.add((byte) '\r');
                      }
                    start.m_set.complement();
                  }
                else
                  {
                    m_lexGen.advance();
                    if (m_lexGen.AT_BOL == m_spec.m_current_token)
                      {
                        m_lexGen.advance();

                        /*start.m_set.add((byte) '\n');
                        if (false == m_spec.m_unix)
                          {
                            start.m_set.add((byte) '\r');
                          }*/
                        start.m_set.complement();
                      }
                    if (false == (m_lexGen.CCL_END == m_spec.m_current_token))
                      {
                        dodash(start.m_set);
                      }
                    /*else
                      {
                        for (c = 0; c <= ' '; ++c)
                          {
                            start.m_set.add((byte) c);
                          }
                      }*/
                  }
                m_lexGen.advance();
              }
          }

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.leave("term",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }

  /***************************************************************
    Function: dodash
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void dodash
    (
     pSbNWjWEi set
     )
      throws java.io.IOException 
        {
          int first = -1;
          
          if (INAhxAQiZ.DESCENT_DEBUG)
            {
              INAhxAQiZ.enter("dodash",m_spec.m_lexeme,m_spec.m_current_token);
            }
          
          while (m_lexGen.EOS != m_spec.m_current_token 
                 && m_lexGen.CCL_END != m_spec.m_current_token)
            {
              if (m_lexGen.DASH == m_spec.m_current_token)
                {
                  if (INAhxAQiZ.DEBUG)
                    {
                      INAhxAQiZ.assert(-1 != first);
                    }
                  
                  m_lexGen.advance();
                  for ( ; first <= m_spec.m_lexeme; ++first)
                    {
                      set.add(first);
                    }  
                }
              else
                {
                  first = m_spec.m_lexeme;
                  set.add(m_spec.m_lexeme);
                }

              m_lexGen.advance();
            }
          
        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            INAhxAQiZ.leave("dodash",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
}

/***************************************************************
  Class: TyWHbCSwu
 **************************************************************/
final class TyWHbCSwu //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  aYvbfLVVU m_spec;
  Vector m_group;
  int m_ingroup[];

  /***************************************************************
    Function: TyWHbCSwu
    Description: Constructor.
    **************************************************************/
  TyWHbCSwu 
    (
     )
      {
        reset();
      }
  
  /***************************************************************
    Function: reset
    Description: Resets member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_spec = null;
        m_group = null;
        m_ingroup = null;
      }

  /***************************************************************
    Function: set
    Description: Sets member variables.
    **************************************************************/
  private void set
    (
     aYvbfLVVU spec
     )
      {
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != spec);
          }

        m_spec = spec;
        m_group = null;
        m_ingroup = null;
      }

  /***************************************************************
    Function: min_dfa
    Description: High-level access function to module.
    **************************************************************/
  void min_dfa
    (
     aYvbfLVVU spec
     )
      {
        set(spec);

        /* Remove redundant states. */
        minimize();

        /* Column and row compression. 
           Save accept states in auxilary vector. */
        reduce();

        reset();
      }

  /***************************************************************
    Function: col_copy
    Description: Copies source column into destination column.
    **************************************************************/
  private void col_copy
    (
     int dest,
     int src
     )
      {
        int n;
        int i;
        uQFetIDnd dtrans;

        n = m_spec.m_dtrans_vector.size();
        for (i = 0; i < n; ++i)
          {
            dtrans = (uQFetIDnd) m_spec.m_dtrans_vector.elementAt(i);
            dtrans.m_dtrans[dest] = dtrans.m_dtrans[src]; 
          }
      } 
        
  /***************************************************************
    Function: row_copy
    Description: Copies source row into destination row.
    **************************************************************/
  private void row_copy
    (
     int dest,
     int src
     )
      {
        uQFetIDnd dtrans;

        dtrans = (uQFetIDnd) m_spec.m_dtrans_vector.elementAt(src);
        m_spec.m_dtrans_vector.setElementAt(dtrans,dest); 
      } 
        
  /***************************************************************
    Function: col_equiv
    Description: 
    **************************************************************/
  private boolean col_equiv
    (
     int col1,
     int col2
     )
      {
        int n;
        int i;
        uQFetIDnd dtrans;

        n = m_spec.m_dtrans_vector.size();
        for (i = 0; i < n; ++i)
          {
            dtrans = (uQFetIDnd) m_spec.m_dtrans_vector.elementAt(i);
            if (dtrans.m_dtrans[col1] != dtrans.m_dtrans[col2]) 
              {
                return false;
              }
          }
        
        return true;
      }

  /***************************************************************
    Function: row_equiv
    Description: 
    **************************************************************/
  private boolean row_equiv
    (
     int row1,
     int row2
     )
      {
        int i;
        uQFetIDnd dtrans1;
        uQFetIDnd dtrans2;

        dtrans1 = (uQFetIDnd) m_spec.m_dtrans_vector.elementAt(row1);
        dtrans2 = (uQFetIDnd) m_spec.m_dtrans_vector.elementAt(row2);
        
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (dtrans1.m_dtrans[i] != dtrans2.m_dtrans[i]) 
              {
                return false;
              }
          }
        
        return true;
      }

  /***************************************************************
    Function: reduce
    Description: 
    **************************************************************/
  private void reduce
    (
     )
      {
        int i;
        int j;
        int k;
        int nrows;
        int reduced_ncols;
        int reduced_nrows;
        BitSet set;
        uQFetIDnd dtrans;
        int size;

        set = new BitSet();
        
        /* Save accept nodes and anchor entries. */
        size = m_spec.m_dtrans_vector.size();
        m_spec.m_anchor_array = new int[size];
        m_spec.m_accept_vector = new Vector();
        for (i = 0; i < size; ++i)
          {
            dtrans = (uQFetIDnd) m_spec.m_dtrans_vector.elementAt(i);
            m_spec.m_accept_vector.addElement(dtrans.m_accept);
            m_spec.m_anchor_array[i] = dtrans.m_anchor;
            dtrans.m_accept = null;
          }
        
        /* Allocate column map. */
        m_spec.m_col_map = new int[m_spec.m_dtrans_ncols];
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            m_spec.m_col_map[i] = -1;
          }

        /* Process columns for reduction. */
        for (reduced_ncols = 0; ; ++reduced_ncols)
          {
            if (true == INAhxAQiZ.DEBUG)
              {
                for (i = 0; i < reduced_ncols; ++i)
                  {
                    INAhxAQiZ.assert(-1 != m_spec.m_col_map[i]);
                  }
              }

            for (i = reduced_ncols; i < m_spec.m_dtrans_ncols; ++i)
              {
                if (-1 == m_spec.m_col_map[i])
                  {
                    break;
                  }
              }

            if (i >= m_spec.m_dtrans_ncols)
              {
                break;
              }

            if (true == INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(false == set.get(i));
                INAhxAQiZ.assert(-1 == m_spec.m_col_map[i]);
              }

            set.set(i);
            
            m_spec.m_col_map[i] = reduced_ncols;
            
            /* UNDONE: Optimize by doing all comparisons in one batch. */
            for (j = i + 1; j < m_spec.m_dtrans_ncols; ++j)
              {
                if (-1 == m_spec.m_col_map[j] && true == col_equiv(i,j))
                  {
                    m_spec.m_col_map[j] = reduced_ncols;
                  }
              }
          }

        /* Reduce columns. */
        k = 0;
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (true == set.get(i))
              {
                ++k;

                set.clear(i);
                
                j = m_spec.m_col_map[i];
                
                if (true == INAhxAQiZ.DEBUG)
                  {
                    INAhxAQiZ.assert(j <= i);
                  }
                
                if (j == i)
                  {
                    continue;
                  }
                
                col_copy(j,i);
              }
          }
        m_spec.m_dtrans_ncols = reduced_ncols;

        if (true == INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(k == reduced_ncols);
          }

        /* Allocate row map. */
        nrows = m_spec.m_dtrans_vector.size();
        m_spec.m_row_map = new int[nrows];
        for (i = 0; i < nrows; ++i)
          {
            m_spec.m_row_map[i] = -1;
          }

        /* Process rows to reduce. */
        for (reduced_nrows = 0; ; ++reduced_nrows)
          {
            if (true == INAhxAQiZ.DEBUG)
              {
                for (i = 0; i < reduced_nrows; ++i)
                  {
                    INAhxAQiZ.assert(-1 != m_spec.m_row_map[i]);
                  }
              }

            for (i = reduced_nrows; i < nrows; ++i)
              {
                if (-1 == m_spec.m_row_map[i])
                  {
                    break;
                  }
              }

            if (i >= nrows)
              {
                break;
              }

            if (true == INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(false == set.get(i));
                INAhxAQiZ.assert(-1 == m_spec.m_row_map[i]);
              }

            set.set(i);

            m_spec.m_row_map[i] = reduced_nrows;
            
            /* UNDONE: Optimize by doing all comparisons in one batch. */
            for (j = i + 1; j < nrows; ++j)
              {
                if (-1 == m_spec.m_row_map[j] && true == row_equiv(i,j))
                  {
                    m_spec.m_row_map[j] = reduced_nrows;
                  }
              }
          }

        /* Reduce rows. */
        k = 0;
        for (i = 0; i < nrows; ++i)
          {
            if (true == set.get(i))
              {
                ++k;

                set.clear(i);
                
                j = m_spec.m_row_map[i];
                
                if (true == INAhxAQiZ.DEBUG)
                  {
                    INAhxAQiZ.assert(j <= i);
                  }
                
                if (j == i)
                  {
                    continue;
                  }
                
                row_copy(j,i);
              }
          }
        m_spec.m_dtrans_vector.setSize(reduced_nrows);

        if (INAhxAQiZ.DEBUG)
          {
            /*System.out.print("k = " + k + "\nreduced_nrows = " + reduced_nrows + "\n");*/
            INAhxAQiZ.assert(k == reduced_nrows);
          }
      }

  /***************************************************************
    Function: fix_dtrans
    Description: Updates uQFetIDnd table after minimization 
    using groups, removing redundant transition table states.
    **************************************************************/
  private void fix_dtrans
    (
     )
      {
        Vector new_vector;
        int i;
        int size;
        Vector dtrans_group;
        uQFetIDnd first;
        int c;

        new_vector = new Vector();

        size = m_spec.m_state_dtrans.length;
        for (i = 0; i < size; ++i)
          {
            if (uQFetIDnd.F != m_spec.m_state_dtrans[i])
              {
                m_spec.m_state_dtrans[i] = m_ingroup[m_spec.m_state_dtrans[i]];
              }
          }

        size = m_group.size();
        for (i = 0; i < size; ++i)
          {
            dtrans_group = (Vector) m_group.elementAt(i);
            first = (uQFetIDnd) dtrans_group.elementAt(0);
            new_vector.addElement(first);

            for (c = 0; c < m_spec.m_dtrans_ncols; ++c)
              {
                if (uQFetIDnd.F != first.m_dtrans[c])
                  {
                    first.m_dtrans[c] = m_ingroup[first.m_dtrans[c]];
                  }
              }
          }

        m_group = null;
        m_spec.m_dtrans_vector = new_vector;
      }

  /***************************************************************
    Function: minimize
    Description: Removes redundant transition table states.
    **************************************************************/
  private void minimize
    (
     )
      {
        Vector dtrans_group;
        Vector new_group;
        int i;
        int j;
        int old_group_count;
        int group_count;
        uQFetIDnd next;
        uQFetIDnd first;
        int goto_first;
        int goto_next;
        int c;
        int group_size;
        boolean added;

        init_groups();

        group_count = m_group.size();
        old_group_count = group_count - 1;

        while (old_group_count != group_count)
          {
            old_group_count = group_count;

            if (INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(m_group.size() == group_count);
              }

            for (i = 0; i < group_count; ++i)
              {
                dtrans_group = (Vector) m_group.elementAt(i);

                group_size = dtrans_group.size();
                if (group_size <= 1)
                  {
                    continue;
                  }

                new_group = new Vector();
                added = false;
                
                first = (uQFetIDnd) dtrans_group.elementAt(0);
                for (j = 1; j < group_size; ++j)
                  {
                    next = (uQFetIDnd) dtrans_group.elementAt(j);

                    for (c = 0; c < m_spec.m_dtrans_ncols; ++c)
                      {
                        goto_first = first.m_dtrans[c];
                        goto_next = next.m_dtrans[c];

                        if (goto_first != goto_next
                            && (goto_first == uQFetIDnd.F
                                || goto_next == uQFetIDnd.F
                                || m_ingroup[goto_next] != m_ingroup[goto_first]))
                          {
                            if (INAhxAQiZ.DEBUG)
                              {
                                INAhxAQiZ.assert(dtrans_group.elementAt(j) == next);
                              }
                            
                            dtrans_group.removeElementAt(j);
                            --j;
                            --group_size;
                            new_group.addElement(next);
                            if (false == added)
                              {
                                added = true;
                                ++group_count;
                                m_group.addElement(new_group);
                              }
                            m_ingroup[next.m_label] = m_group.size() - 1;

                            if (INAhxAQiZ.DEBUG)
                              {
                                INAhxAQiZ.assert(m_group.contains(new_group)
                                                == true);
                                INAhxAQiZ.assert(m_group.contains(dtrans_group)
                                                == true);
                                INAhxAQiZ.assert(dtrans_group.contains(first)
                                                == true);
                                INAhxAQiZ.assert(dtrans_group.contains(next)
                                                == false);
                                INAhxAQiZ.assert(new_group.contains(first)
                                                == false);
                                INAhxAQiZ.assert(new_group.contains(next)
                                                == true);
                                INAhxAQiZ.assert(dtrans_group.size() == group_size);
                                INAhxAQiZ.assert(i == m_ingroup[first.m_label]);
                                INAhxAQiZ.assert((m_group.size() - 1) 
                                                == m_ingroup[next.m_label]);
                              }

                            break;
                          }
                      }
                  }
              }
          }

        System.out.println(m_group.size() + " states after removal of redundant states.");

        if (true == m_spec.m_verbose
            && true == INAhxAQiZ.OLD_DUMP_DEBUG)
          {
            System.out.println("\nStates grouped as follows after minimization");
            pgroups();
          }

        fix_dtrans();
      }

  /***************************************************************
    Function: init_groups
    Description:
    **************************************************************/
  private void init_groups
    (
     )
      {
        int i;
        int j;
        int group_count;
        int size;
        xAYJWnUkN accept;
        uQFetIDnd dtrans;
        Vector dtrans_group;
        uQFetIDnd first;
        boolean group_found;

        m_group = new Vector();
        group_count = 0;
        
        size = m_spec.m_dtrans_vector.size();
        m_ingroup = new int[size];
        
        for (i = 0; i < size; ++i)
          {
            group_found = false;
            dtrans = (uQFetIDnd) m_spec.m_dtrans_vector.elementAt(i);

            if (INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(i == dtrans.m_label);
                INAhxAQiZ.assert(false == group_found);
                INAhxAQiZ.assert(group_count == m_group.size());
              }
            
            for (j = 0; j < group_count; ++j)
              {
                dtrans_group = (Vector) m_group.elementAt(j);
                
                if (INAhxAQiZ.DEBUG)
                  {
                    INAhxAQiZ.assert(false == group_found);
                    INAhxAQiZ.assert(0 < dtrans_group.size());
                  }

                first = (uQFetIDnd) dtrans_group.elementAt(0);
                
                if (INAhxAQiZ.SLOW_DEBUG)
                  {
                    uQFetIDnd check;
                    int k;
                    int s;

                    s = dtrans_group.size();
                    INAhxAQiZ.assert(0 < s);

                    for (k = 1; k < s; ++k)
                      {
                        check = (uQFetIDnd) dtrans_group.elementAt(k);
                        INAhxAQiZ.assert(check.m_accept == first.m_accept);
                      }
                  }

                if (first.m_accept == dtrans.m_accept)
                  {
                    dtrans_group.addElement(dtrans);
                    m_ingroup[i] = j;
                    group_found = true;
                    
                    if (INAhxAQiZ.DEBUG)
                      {
                        INAhxAQiZ.assert(j == m_ingroup[dtrans.m_label]);
                      }

                    break;
                  }
              }
            
            if (false == group_found)
              {
                dtrans_group = new Vector();
                dtrans_group.addElement(dtrans);
                m_ingroup[i] = m_group.size();
                m_group.addElement(dtrans_group);
                ++group_count;
              }
          }
        
        if (true == m_spec.m_verbose
            && true == INAhxAQiZ.OLD_DUMP_DEBUG)
          {
            System.out.println("Initial grouping:");
            pgroups();
            System.out.println("");
          }
      }

  /***************************************************************
    Function: pset
    **************************************************************/
  private void pset
    (
     Vector dtrans_group
     )
      {
        int i;
        int size;
        uQFetIDnd dtrans;

        size = dtrans_group.size();
        for (i = 0; i < size; ++i)
          {
            dtrans = (uQFetIDnd) dtrans_group.elementAt(i);
            System.out.print(dtrans.m_label + " ");
          }
      }
  
  /***************************************************************
    Function: pgroups
    **************************************************************/
  private void pgroups
    (
     )
      {
        int i;
        int dtrans_size;
        int group_size;
        
        group_size = m_group.size();
        for (i = 0; i < group_size; ++i)
          {
            System.out.print("\tGroup " + i + " {");
            pset((Vector) m_group.elementAt(i));
            System.out.println("}\n");
          }
        
        System.out.println("");
        dtrans_size = m_spec.m_dtrans_vector.size();
        for (i = 0; i < dtrans_size; ++i)
          {
            System.out.println("\tstate " + i 
                               + " is in group " 
                               + m_ingroup[i]);
          }
      }
}

/***************************************************************
  Class: lQsXXpbpa
 **************************************************************/
final class lQsXXpbpa //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private aYvbfLVVU m_spec;
  private int m_unmarked_dfa;
  private YUydifjdg m_lexGen;

  /***************************************************************
    Constants
    **************************************************************/
  private static final int NOT_IN_DSTATES = -1;

  /***************************************************************
    Function: lQsXXpbpa
    **************************************************************/
  lQsXXpbpa
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: set 
    Description: 
    **************************************************************/
  private void set
    (
     YUydifjdg lexGen,
     aYvbfLVVU spec
     )
      {
        m_lexGen = lexGen;
        m_spec = spec;
        m_unmarked_dfa = 0;
      }

  /***************************************************************
    Function: reset 
    Description: 
    **************************************************************/
  private void reset
    (
     )
      {
        m_lexGen = null;
        m_spec = null;
        m_unmarked_dfa = 0;
      }

  /***************************************************************
    Function: make_dfa
    Description: High-level access function to module.
    **************************************************************/
  void make_dfa
    (
     YUydifjdg lexGen,
     aYvbfLVVU spec
     )
      {
        int i;

        reset();
        set(lexGen,spec);

        make_dtrans();
        free_nfa_states();

        if (true == m_spec.m_verbose && true == INAhxAQiZ.OLD_DUMP_DEBUG)
          {
            System.out.println(m_spec.m_dfa_states.size()
                               + " DFA states in original machine.");
          }

        free_dfa_states();
      }     

   /***************************************************************
    Function: make_dtrans
    Description: Creates uncompressed uQFetIDnd transition table.
    **************************************************************/
  private void make_dtrans
    (
     )
     /* throws java.lang.CloneNotSupportedException*/
      {
        RnSdHehzX next;
        RnSdHehzX dfa;
        MXozxsWOU bunch;
        int i;
        int nextstate;
        int size;
        uQFetIDnd dtrans;
        layAuDXcf nfa;
        int istate;
        int nstates;
        
        System.out.print("Working on DFA states.");

        /* Reference passing type and initializations. */
        bunch = new MXozxsWOU();
        m_unmarked_dfa = 0;

        /* Allocate mapping array. */
        nstates = m_spec.m_state_rules.length;
        m_spec.m_state_dtrans = new int[nstates];

        for (istate = 0; nstates > istate; ++istate)
          {
            if (0 == m_spec.m_state_rules[istate].size())
              {
                m_spec.m_state_dtrans[istate] = uQFetIDnd.F;
                continue;
              }
                
            /* Create start state and initialize fields. */
            bunch.m_nfa_set = (Vector) m_spec.m_state_rules[istate].clone();
            sortStates(bunch.m_nfa_set);
            
            bunch.m_nfa_bit = new BitSet();
            
            /* Initialize bit set. */
            size = bunch.m_nfa_set.size();
            for (i = 0; size > i; ++i)
              {
                nfa = (layAuDXcf) bunch.m_nfa_set.elementAt(i);
                bunch.m_nfa_bit.set(nfa.m_label);
              }
            
            bunch.m_accept = null;
            bunch.m_anchor = aYvbfLVVU.NONE;
            bunch.m_accept_index = INAhxAQiZ.INT_MAX;
            
            e_closure(bunch);
            add_to_dstates(bunch);
            
            m_spec.m_state_dtrans[istate] = m_spec.m_dtrans_vector.size();

            /* Main loop of uQFetIDnd creation. */
            while (null != (dfa = get_unmarked()))
              {
                System.out.print(".");
                System.out.flush();
                
                if (INAhxAQiZ.DEBUG)
                  {
                    INAhxAQiZ.assert(false == dfa.m_mark);
                  }

                /* Get first unmarked node, then mark it. */
                dfa.m_mark = true;
                
                /* Allocate new uQFetIDnd, then initialize fields. */
                dtrans = new uQFetIDnd(m_spec.m_dtrans_vector.size(),m_spec);
                dtrans.m_accept = dfa.m_accept;
                dtrans.m_anchor = dfa.m_anchor;
                
                /* Set uQFetIDnd array for each character transition. */
                for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
                  {
                    if (INAhxAQiZ.DEBUG)
                      {
                        INAhxAQiZ.assert(0 <= i);
                        INAhxAQiZ.assert(m_spec.m_dtrans_ncols > i);
                      }
                    
                    /* Create new dfa set by attempting character transition. */
                    move(dfa.m_nfa_set,dfa.m_nfa_bit,i,bunch);
                    if (null != bunch.m_nfa_set)
                      {
                        e_closure(bunch);
                      }
                    
                    if (INAhxAQiZ.DEBUG)
                      {
                        INAhxAQiZ.assert((null == bunch.m_nfa_set 
                                         && null == bunch.m_nfa_bit)
                                        || (null != bunch.m_nfa_set 
                                            && null != bunch.m_nfa_bit));
                      }
                    
                    /* Create new state or set state to empty. */
                    if (null == bunch.m_nfa_set)
                      {
                        nextstate = uQFetIDnd.F;
                      }
                    else 
                      {
                        nextstate = in_dstates(bunch);
                        
                        if (NOT_IN_DSTATES == nextstate)
                          {
                            nextstate = add_to_dstates(bunch);
                          }
                      }
                    
                    if (INAhxAQiZ.DEBUG)
                      {
                        INAhxAQiZ.assert(nextstate < m_spec.m_dfa_states.size());
                      }
                    
                    dtrans.m_dtrans[i] = nextstate;
                  }
                
                if (INAhxAQiZ.DEBUG)
                  {
                    INAhxAQiZ.assert(m_spec.m_dtrans_vector.size() == dfa.m_label);
                  }
                
                m_spec.m_dtrans_vector.addElement(dtrans);
              }
          }

        System.out.println("");
      }

  /***************************************************************
    Function: free_dfa_states
    **************************************************************/  
  private void free_dfa_states
    (
     )
      {
        m_spec.m_dfa_states = null;
        m_spec.m_dfa_sets = null;
      }

  /***************************************************************
    Function: free_nfa_states
    **************************************************************/  
  private void free_nfa_states
    (
     )
      {
        /* UNDONE: Remove references to nfas from within dfas. */
        /* UNDONE: Don't free CAccepts. */

        m_spec.m_nfa_states = null;
        m_spec.m_nfa_start = null;
        m_spec.m_state_rules = null;
      }

  /***************************************************************
    Function: e_closure
    Description: Alters and returns input set.
    **************************************************************/
  private void e_closure
    (
     MXozxsWOU bunch
     )
      {
        Stack nfa_stack;
        int size;
        int i;
        layAuDXcf state;

        /* Debug checks. */
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != bunch);
            INAhxAQiZ.assert(null != bunch.m_nfa_set);
            INAhxAQiZ.assert(null != bunch.m_nfa_bit);
          }

        bunch.m_accept = null;
        bunch.m_anchor = aYvbfLVVU.NONE;
        bunch.m_accept_index = INAhxAQiZ.INT_MAX;
        
        /* Create initial stack. */
        nfa_stack = new Stack();
        size = bunch.m_nfa_set.size();
        for (i = 0; i < size; ++i)
          {
            state = (layAuDXcf) bunch.m_nfa_set.elementAt(i);
            
            if (INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(true == bunch.m_nfa_bit.get(state.m_label));
              }

            nfa_stack.push(state);
          }

        /* Main loop. */
        while (false == nfa_stack.empty())
          {
            state = (layAuDXcf) nfa_stack.pop();
            
            if (INAhxAQiZ.OLD_DUMP_DEBUG)
              {
                if (null != state.m_accept)
                  {
                    System.out.println("Looking at accepting state " + state.m_label
                                       + " with <"
                                       + (new String(state.m_accept.m_action,0,
                                                     state.m_accept.m_action_read))
                                       + ">");
                  }
              }

            if (null != state.m_accept 
                && state.m_label < bunch.m_accept_index)
              {
                bunch.m_accept_index = state.m_label;
                bunch.m_accept = state.m_accept;
                bunch.m_anchor = state.m_anchor;

                if (INAhxAQiZ.OLD_DUMP_DEBUG)
                  {
                    System.out.println("Found accepting state " + state.m_label
                                       + " with <"
                                       + (new String(state.m_accept.m_action,0,
                                                     state.m_accept.m_action_read))
                                       + ">");
                  }

                if (INAhxAQiZ.DEBUG)
                  {
                    INAhxAQiZ.assert(null != bunch.m_accept);
                    INAhxAQiZ.assert(aYvbfLVVU.NONE == bunch.m_anchor
                                    || 0 != (bunch.m_anchor & aYvbfLVVU.END)
                                    || 0 != (bunch.m_anchor & aYvbfLVVU.START));
                  }
              }

            if (layAuDXcf.EPSILON == state.m_edge)
              {
                if (null != state.m_next)
                  {
                    if (false == bunch.m_nfa_set.contains(state.m_next))
                      {
                        if (INAhxAQiZ.DEBUG)
                          {
                            INAhxAQiZ.assert(false == bunch.m_nfa_bit.get(state.m_next.m_label));
                          }
                        
                        bunch.m_nfa_bit.set(state.m_next.m_label);
                        bunch.m_nfa_set.addElement(state.m_next);
                        nfa_stack.push(state.m_next);
                      }
                  }

                if (null != state.m_next2)
                  {
                    if (false == bunch.m_nfa_set.contains(state.m_next2))
                      {
                        if (INAhxAQiZ.DEBUG)
                          {
                            INAhxAQiZ.assert(false == bunch.m_nfa_bit.get(state.m_next2.m_label));
                          }
                        
                        bunch.m_nfa_bit.set(state.m_next2.m_label);
                        bunch.m_nfa_set.addElement(state.m_next2);
                        nfa_stack.push(state.m_next2);
                      }
                  }
              }
          }

        if (null != bunch.m_nfa_set)
          {
            sortStates(bunch.m_nfa_set);
          }

        return;
      }

  /***************************************************************
    Function: move
    Description: Returns null if resulting NFA set is empty.
    **************************************************************/
  void move
    (
     Vector nfa_set,
     BitSet nfa_bit,
     int b,
     MXozxsWOU bunch
     )
      {
        int size;
        int index;
        layAuDXcf state;
        
        bunch.m_nfa_set = null;
        bunch.m_nfa_bit = null;

        size = nfa_set.size();
        for (index = 0; index < size; ++index)
          {
            state = (layAuDXcf) nfa_set.elementAt(index);
            
            if (b == state.m_edge
                || (layAuDXcf.CCL == state.m_edge
                    && true == state.m_set.contains(b)))
              {
                if (null == bunch.m_nfa_set)
                  {
                    if (INAhxAQiZ.DEBUG)
                      {
                        INAhxAQiZ.assert(null == bunch.m_nfa_bit);
                      }
                    
                    bunch.m_nfa_set = new Vector();
                    bunch.m_nfa_bit = new BitSet(m_spec.m_nfa_states.size());
                    /*bunch.m_nfa_bit = new BitSet();*/
                  }

                bunch.m_nfa_set.addElement(state.m_next);
                /*System.out.println("Size of bitset: " + bunch.m_nfa_bit.size());
                System.out.println("Reference index: " + state.m_next.m_label);
                System.out.flush();*/
                bunch.m_nfa_bit.set(state.m_next.m_label);
              }
          }
        
        if (null != bunch.m_nfa_set)
          {
            if (INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(null != bunch.m_nfa_bit);
              }
            
            sortStates(bunch.m_nfa_set);
          }

        return;
      }

  /***************************************************************
    Function: sortStates
    **************************************************************/
  private void sortStates
    (
     Vector nfa_set
     )
      {
        layAuDXcf elem;
        int begin;
        int size;
        int index;
        int value;
        int smallest_index;
        int smallest_value;
        layAuDXcf begin_elem;

        size = nfa_set.size();
        for (begin = 0; begin < size; ++begin)
          {
            elem = (layAuDXcf) nfa_set.elementAt(begin);
            smallest_value = elem.m_label;
            smallest_index = begin;

            for (index = begin + 1; index < size; ++index)
              {
                elem = (layAuDXcf) nfa_set.elementAt(index);
                value = elem.m_label;

                if (value < smallest_value)
                  {
                    smallest_index = index;
                    smallest_value = value;
                  }
              }

            begin_elem = (layAuDXcf) nfa_set.elementAt(begin);
            elem = (layAuDXcf) nfa_set.elementAt(smallest_index);
            nfa_set.setElementAt(elem,begin);
            nfa_set.setElementAt(begin_elem,smallest_index);
          }

        if (true == INAhxAQiZ.OLD_DEBUG)
          {
            System.out.print("NFA vector indices: ");  
            
            for (index = 0; index < size; ++index)
              {
                elem = (layAuDXcf) nfa_set.elementAt(index);
                System.out.print(elem.m_label + " ");
              }
            System.out.print("\n");
          }     

        return;
      }

  /***************************************************************
    Function: get_unmarked
    Description: Returns next unmarked DFA state.
    **************************************************************/
  private RnSdHehzX get_unmarked
    (
     )
      {
        int size;
        RnSdHehzX dfa;

        size = m_spec.m_dfa_states.size();
        while (m_unmarked_dfa < size)
          {
            dfa = (RnSdHehzX) m_spec.m_dfa_states.elementAt(m_unmarked_dfa);

            if (false == dfa.m_mark)
              {
                if (true == INAhxAQiZ.OLD_DUMP_DEBUG)
                  {
                    System.out.print("*");
                    System.out.flush();
                  }

                if (true == m_spec.m_verbose && true == INAhxAQiZ.OLD_DUMP_DEBUG)
                  {
                    System.out.println("---------------");
                    System.out.print("working on DFA state " 
                                     + m_unmarked_dfa
                                     + " = NFA states: ");
                    m_lexGen.print_set(dfa.m_nfa_set);
                    System.out.print("\n");
                  }

                return dfa;
              }

            ++m_unmarked_dfa;
          }

        return null;
      }
  
  /***************************************************************
    function: add_to_dstates
    Description: Takes as input a MXozxsWOU with details of
    a dfa state that needs to be created.
    1) Allocates a new dfa state and saves it in 
    the appropriate aYvbfLVVU vector.
    2) Initializes the fields of the dfa state
    with the information in the MXozxsWOU.
    3) Returns index of new dfa.
    **************************************************************/
  private int add_to_dstates
    (
     MXozxsWOU bunch
     )
      {
        RnSdHehzX dfa;
        
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != bunch.m_nfa_set);
            INAhxAQiZ.assert(null != bunch.m_nfa_bit);
            INAhxAQiZ.assert(null != bunch.m_accept 
                            || aYvbfLVVU.NONE == bunch.m_anchor);
          }

        /* Allocate, passing aYvbfLVVU so dfa label can be set. */
        dfa = vNBAqFnCC.newRnSdHehzX(m_spec);
        
        /* Initialize fields, including the mark field. */
        dfa.m_nfa_set = (Vector) bunch.m_nfa_set.clone();
        dfa.m_nfa_bit = (BitSet) bunch.m_nfa_bit.clone();
        dfa.m_accept = bunch.m_accept;
        dfa.m_anchor = bunch.m_anchor;
        dfa.m_mark = false;
        
        /* Register dfa state using BitSet in aYvbfLVVU Hashtable. */
        m_spec.m_dfa_sets.put(dfa.m_nfa_bit,dfa);
        /*registerRnSdHehzX(dfa);*/

        if (INAhxAQiZ.OLD_DUMP_DEBUG)
          {
            System.out.print("Registering set : ");
            m_lexGen.print_set(dfa.m_nfa_set);
            System.out.println("");
          }

        return dfa.m_label;
      }

  /***************************************************************
    Function: in_dstates
    **************************************************************/
  private int in_dstates
    (
     MXozxsWOU bunch
     )
      {
        RnSdHehzX dfa;
        
        if (INAhxAQiZ.OLD_DEBUG)
          {
            System.out.print("Looking for set : ");
            m_lexGen.print_set(bunch.m_nfa_set);
          }

        dfa = (RnSdHehzX) m_spec.m_dfa_sets.get(bunch.m_nfa_bit);

        if (null != dfa)
          {
            if (INAhxAQiZ.OLD_DUMP_DEBUG)
              {
                System.out.println(" FOUND!");
              }
            
            return dfa.m_label;
          }

        if (INAhxAQiZ.OLD_DUMP_DEBUG)
          {
            System.out.println(" NOT FOUND!");
          }
        return NOT_IN_DSTATES;
      }

}

/***************************************************************
  Class: vNBAqFnCC
  **************************************************************/
final class vNBAqFnCC //**NS**
{
  /***************************************************************
    Function: newRnSdHehzX
    **************************************************************/
  static RnSdHehzX newRnSdHehzX
    (
     aYvbfLVVU spec
     )
      {
        RnSdHehzX dfa;
        
        dfa = new RnSdHehzX(spec.m_dfa_states.size());
        spec.m_dfa_states.addElement(dfa);

        return dfa;
      }

  /***************************************************************
    Function: newowjuLNyxC
    Description: 
    **************************************************************/
  static owjuLNyxC newowjuLNyxC
    (
     )
      {
        owjuLNyxC pair = new owjuLNyxC();
        
        return pair;
      }

  /***************************************************************
    Function: newlayAuDXcf
    Description: 
    **************************************************************/
  static layAuDXcf newlayAuDXcf
    (
     aYvbfLVVU spec
     )
      {
        layAuDXcf p;

        /* UNDONE: Buffer this? */

        p = new layAuDXcf();
        
        /*p.m_label = spec.m_nfa_states.size();*/
        spec.m_nfa_states.addElement(p);
        p.m_edge = layAuDXcf.EPSILON;
        
        return p;
      }
}

/***************************************************************
  Class: QJPxdCimP
  Description: Top-level lexical analyzer generator function.
 **************************************************************/
final class QJPxdCimP //**NS**
{
  /***************************************************************
    Function: main
    **************************************************************/
  public static void main
    (
     String arg[]
     )
    throws java.io.IOException
      {
        YUydifjdg lg;

        if (arg.length < 1)
          {
            System.out.println("Usage: QJPxdCimP <filename>");
            return;
          }

        lg = new YUydifjdg(arg[0]);
        lg.generate();
      }
}    

/***************************************************************
  Class: uQFetIDnd
  **************************************************************/
final class uQFetIDnd //**NS**
{
  /*************************************************************
    Member Variables
    ***********************************************************/
  int m_dtrans[];
  xAYJWnUkN m_accept;
  int m_anchor;
  int m_label;

  /*************************************************************
    Constants
    ***********************************************************/
  static final int F = -1;

  /*************************************************************
    Function: CTrans
    ***********************************************************/
  uQFetIDnd
    (
     int label,
     aYvbfLVVU spec
     )
      {
        m_dtrans = new int[spec.m_dtrans_ncols];
        m_accept = null;
        m_anchor = aYvbfLVVU.NONE;
        m_label = label;
      }
}

/***************************************************************
  Class: RnSdHehzX
  **************************************************************/
final class RnSdHehzX //**NS**
{
  /***************************************************************
    Member Variables
    ***********************************************************/
  int m_group;
  boolean m_mark;
  xAYJWnUkN m_accept;
  int m_anchor;
  Vector m_nfa_set;
  BitSet m_nfa_bit;
  int m_label;

  /***************************************************************
    Function: RnSdHehzX
    **************************************************************/
  RnSdHehzX
    (
     int label
     )
      {
        m_group = 0;
        m_mark = false;

        m_accept = null;
        m_anchor = aYvbfLVVU.NONE;

        m_nfa_set = null;
        m_nfa_bit = null;

        m_label = label;
      }
}

/***************************************************************
  Class: xAYJWnUkN
 **************************************************************/
final class xAYJWnUkN //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  char m_action[];
  int m_action_read;
  int m_line_number;

  /***************************************************************
    Function: xAYJWnUkN
    **************************************************************/
  xAYJWnUkN
    (
     char action[],
     int action_read,
     int line_number
     )
      {
        int elem;

        m_action_read = action_read;

        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = action[elem];
          }

        m_line_number = line_number;
      }

  /***************************************************************
    Function: xAYJWnUkN
    **************************************************************/
  xAYJWnUkN
    (
     xAYJWnUkN accept
     )
      {
        int elem;

        m_action_read = accept.m_action_read;
        
        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = accept.m_action[elem];
          }

        m_line_number = accept.m_line_number;
      }

  /***************************************************************
    Function: mimic
    **************************************************************/
  void mimic
    (
     xAYJWnUkN accept
     )
      {
        int elem;

        m_action_read = accept.m_action_read;
        
        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = accept.m_action[elem];
          }
      }
}

/***************************************************************
  Class: izTauOhHS
  **************************************************************/
final class izTauOhHS //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  xAYJWnUkN m_accept;
  int m_anchor;

  /***************************************************************
    Function: izTauOhHS
    **************************************************************/
  izTauOhHS
    (
     )
      {
        m_accept = null;
        m_anchor = aYvbfLVVU.NONE;
      }
}

/***************************************************************
  Class: owjuLNyxC
  **************************************************************/
final class owjuLNyxC //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  layAuDXcf m_start;
  layAuDXcf m_end;
  
  /***************************************************************
    Function: owjuLNyxC
    **************************************************************/
  owjuLNyxC
    (
     )
      {
        m_start = null;
        m_end = null;
      }
}

/***************************************************************
  Class: WiTcXJFSS
  Description: 
 **************************************************************/
final class WiTcXJFSS //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private InputStream m_input; /* Java-Lez specification file. */

  private byte m_buffer[]; /* Input buffer. */
  private int m_buffer_read; /* Number of bytes read into input buffer. */
  private int m_buffer_index; /* Current index into input buffer. */

  boolean m_eof_reached; /* Whether EOF has been encountered. */
  boolean m_pushback_line; 

  char m_line[]; /* Line buffer. */
  int m_line_read; /* Number of bytes read into line buffer. */
  int m_line_index; /* Current index into line buffer. */

  int m_line_number; /* Current line number. */

  /***************************************************************
    Constants
    **************************************************************/
  private static final int BUFFER_SIZE = 1024;
  static final boolean EOF = true;
  static final boolean NOT_EOF = false;
  
  /***************************************************************
    Function: WiTcXJFSS
    Description: 
    **************************************************************/
  WiTcXJFSS
    (
     InputStream input
     )
      {
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != input);
          }

        /* Initialize input stream. */
        m_input = input;

        /* Initialize buffers and index counters. */
        m_buffer = new byte[BUFFER_SIZE];
        m_buffer_read = 0;
        m_buffer_index = 0;

        m_line = new char[BUFFER_SIZE];
        m_line_read = 0;
        m_line_index = 0;

        /* Initialize state variables. */
        m_eof_reached = false;
        m_line_number = 0;
        m_pushback_line = false;
      }

  /***************************************************************
    Function: getLine
    Description: Returns true on EOF, false otherwise.
    Guarantees not to return a blank line, or a line
    of zero length.
    **************************************************************/
  boolean getLine 
    (
     )
      throws java.io.IOException
      {
        int elem;
        
        /* Has EOF already been reached? */
        if (true == m_eof_reached)
          {
            if (INAhxAQiZ.OLD_DEBUG)
              {
                System.out.print("Line 1: ");
                System.out.print(new String(m_line,0,
                                            m_line_read));
              }

            return true;
          }
        
        /* Pushback current line? */
        if (true == m_pushback_line)
          {
            m_pushback_line = false;

            /* Check for empty line. */
            for (elem = 0; elem < m_line_read; ++elem)
              {
                if (false == INAhxAQiZ.isspace(m_line[elem]))
                  {
                    break;
                  }
              }

            /* Nonempty? */
            if (elem < m_line_read)
              {
                m_line_index = 0;
                return false;
              }

            if (INAhxAQiZ.OLD_DEBUG)
              {
                System.out.print("Line 2: ");
                System.out.print(new String(m_line,0,
                                            m_line_read));
              }
          }

        while (true)
          {
            /* Refill buffer? */
            if (m_buffer_index >= m_buffer_read)
              {
                m_buffer_read = m_input.read(m_buffer);
                if (-1 == m_buffer_read)
                  {
                    m_eof_reached = true;

                    if (INAhxAQiZ.OLD_DEBUG)
                      {
                        System.out.print("Line 3: ");
                        System.out.print(new String(m_line,0,
                                                    m_line_read));
                      }
                    
                    m_line_index = 0;
                    return true;
                  }
                m_buffer_index = 0;
              }
            
            m_line_read = 0;
            while ((byte) '\n' != m_buffer[m_buffer_index])
              {
                m_line[m_line_read] = (char) m_buffer[m_buffer_index];

                ++m_buffer_index;
                
                /* Refill buffer? */
                if (m_buffer_index >= m_buffer_read)
                  {
                    m_buffer_read = m_input.read(m_buffer);
                    if (-1 == m_buffer_read)
                      {
                        m_eof_reached = true;

                        /* Check for empty lines and discard them. */
                        elem = 0;
                        while (INAhxAQiZ.isspace(m_line[elem])) 
                          {
                            ++elem;
                            if (elem == m_line_read)
                              {
                                break;
                              }
                          }
                        
                        if (elem < m_line_read)
                          {                       
                            if (INAhxAQiZ.OLD_DEBUG)
                              {
                                System.out.print("Line 4:");
                                System.out.print(new String(m_line,
                                                            0,
                                                            m_line_read));
                              }
                            
                              
                            m_line_index = 0;
                            return false;
                          }

                        if (INAhxAQiZ.OLD_DEBUG)
                          {
                            System.out.print("Line <e>:");
                            System.out.print(new String(m_line,0,
                                                    m_line_read));
                          }

                        m_line_index = 0;
                        return true;
                      }

                    m_buffer_index = 0;
                  }

                ++m_line_read;

                /* Resize line buffer? */
                if (m_line_read >= m_line.length)
                  {
                    m_line = INAhxAQiZ.doubleSize(m_line);
                  }
              }
            /* Save newline in buffer. */
            m_line[m_line_read] = (char) m_buffer[m_buffer_index];
            ++m_line_read;
            ++m_buffer_index;
            ++m_line_number;
            
            /* Check for empty lines and discard them. */
            elem = 0;
            while (INAhxAQiZ.isspace(m_line[elem])) 
              {
                ++elem;
                if (elem == m_line_read)
                  {
                    break;
                  }
              }
            
            if (elem < m_line_read)
              {
                break;
              }
          }

        if (INAhxAQiZ.OLD_DEBUG)
          {
            System.out.print("Line <f>:");
            System.out.print(new String(m_line,0,m_line_read));
          }

        m_line_index = 0;
        return false;
      }
}

/********************************************************
  Class: Utility
  *******************************************************/
final class INAhxAQiZ  //**NS**
{
  /********************************************************
    Constants
    *******************************************************/
  static final boolean DEBUG = true;
  static final boolean SLOW_DEBUG = true;
  static final boolean DUMP_DEBUG = true;
  /*static final boolean DEBUG = false;
  static final boolean SLOW_DEBUG = false;
  static final boolean DUMP_DEBUG = false;*/
  
  static final boolean DESCENT_DEBUG = false;
  static final boolean OLD_DEBUG = false;
  static final boolean OLD_DUMP_DEBUG = false;
  static final boolean FOODEBUG = false;
  static final boolean DO_DEBUG = false;      
  
  /********************************************************
    Constants: Integer Bounds
    *******************************************************/
  static final int INT_MAX = 2147483647;

  /* UNDONE: What about other character values??? */
  static final int MAX_SEVEN_BIT = 127;
  static final int MAX_EIGHT_BIT = 256;

  /********************************************************
    Function: enter
    Description: Debugging routine.
    *******************************************************/
  static void enter
    (
     String descent,
     char lexeme,
     int token
     )
      {
        System.out.println("Entering " + descent 
                           + " [lexeme: " + lexeme 
                           + "] [token: " + token + "]");
      }

  /********************************************************
    Function: leave
    Description: Debugging routine.
    *******************************************************/
  static void leave
    (
     String descent,
     char lexeme,
     int token
     )
      {
        System.out.println("Leaving " + descent 
                           + " [lexeme:" + lexeme 
                           + "] [token:" + token + "]");
      }

  /********************************************************
    Function: assert
    Description: Debugging routine.
    *******************************************************/
  static void assert
    (
     boolean expr
     )
      {
        if (true == DEBUG && false == expr)
          {
            System.out.println("Assertion Failed");
            throw new Error("Assertion Failed.");
          }
      }

  /***************************************************************
    Function: doubleSize
    **************************************************************/
  static char[] doubleSize
    (
     char oldBuffer[]
     )
      {
        char newBuffer[] = new char[2 * oldBuffer.length];
        int elem;

        for (elem = 0; elem < oldBuffer.length; ++elem)
          {
            newBuffer[elem] = oldBuffer[elem];
          }

        return newBuffer;
      }

  /***************************************************************
    Function: doubleSize
    **************************************************************/
  static byte[] doubleSize
    (
     byte oldBuffer[]
     )
      {
        byte newBuffer[] = new byte[2 * oldBuffer.length];
        int elem;

        for (elem = 0; elem < oldBuffer.length; ++elem)
          {
            newBuffer[elem] = oldBuffer[elem];
          }

        return newBuffer;
      }

  /********************************************************
    Function: hex2bin
    *******************************************************/
  static char hex2bin
    (
     char c
     )
      {
        if ('0' <= c && '9' >= c)
          {
            return (char) (c - '0');
          }
        else if ('a' <= c && 'f' >= c)
          {
            return (char) (c - 'a' + 10);
          }         
        else if ('A' <= c && 'F' >= c)
          {
            return (char) (c - 'A' + 10);
          }
        
        fdUvxtAVx.impos("Bad hexidecimal digit" + c);
        return 0;
      }

  /********************************************************
    Function: ishexdigit
    *******************************************************/
  static boolean ishexdigit
    (
     char c
     )
      {
        if (('0' <= c && '9' >= c)
            || ('a' <= c && 'f' >= c)
            || ('A' <= c && 'F' >= c))
          {
            return true;
          }

        return false;
      }

  /********************************************************
    Function: oct2bin
    *******************************************************/
  static char oct2bin
    (
     char c
     )
      {
        if ('0' <= c && '7' >= c)
          {
            return (char) (c - '0');
          }
        
        fdUvxtAVx.impos("Bad octal digit " + c);
        return 0;
      }

  /********************************************************
    Function: isoctdigit
    *******************************************************/
  static boolean isoctdigit
    (
     char c
     )
      {
        if ('0' <= c && '7' >= c)
          {
            return true;
          }

        return false;
      }
        
  /********************************************************
    Function: isspace
    *******************************************************/
  static boolean isspace
    (
     char c
     )
      {
        if ('\b' == c 
            || '\t' == c
            || '\n' == c
            || '\f' == c
            || '\r' == c
            || ' ' == c)
          {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: isnewline
    *******************************************************/
  static boolean isnewline
    (
     char c
     )
      {
        if ('\n' == c
            || '\r' == c)
            {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: isalpha
    *******************************************************/
  static boolean isalpha
    (
     char c
     )
      {
        if (('a' <= c && 'z' >= c)
            || ('A' <= c && 'Z' >= c))
          {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: toupper
    *******************************************************/
  static char toupper
    (
     char c
     )
      {
        if (('a' <= c && 'z' >= c))
          {
            return (char) (c - 'a' + 'A');
          }

        return c;
      }

  /********************************************************
    Function: bytencmp
    Description: Compares up to n elements of 
    byte array a[] against byte array b[].
    The first byte comparison is made between 
    a[a_first] and b[b_first].  Comparisons continue
    until the null terminating byte '\0' is reached
    or until n bytes are compared.
    Return Value: Returns 0 if arrays are the 
    same up to and including the null terminating byte 
    or up to and including the first n bytes,
    whichever comes first.
    *******************************************************/
  static int bytencmp
    (
     byte a[],
     int a_first,
     byte b[],
     int b_first,
     int n
     )
      {
        int elem;

        for (elem = 0; elem < n; ++elem)
          {
            /*System.out.print((char) a[a_first + elem]);
            System.out.print((char) b[b_first + elem]);*/
                             
            if ('\0' == a[a_first + elem] && '\0' == b[b_first + elem])
              {
                /*System.out.println("return 0");*/
                return 0;
              }
            if (a[a_first + elem] < b[b_first + elem])
              {
                /*System.out.println("return 1");*/
                return 1;
              }
            else if (a[a_first + elem] > b[b_first + elem])
              {
                /*System.out.println("return -1");*/
                return -1;
              }
          }

        /*System.out.println("return 0");*/
        return 0;
      }

  /********************************************************
    Function: charncmp
    *******************************************************/
  static int charncmp
    (
     char a[],
     int a_first,
     char b[],
     int b_first,
     int n
     )
      {
        int elem;

        for (elem = 0; elem < n; ++elem)
          {
            if ('\0' == a[a_first + elem] && '\0' == b[b_first + elem])
              {
                return 0;
              }
            if (a[a_first + elem] < b[b_first + elem])
              {
                return 1;
              }
            else if (a[a_first + elem] > b[b_first + elem])
              {
                return -1;
              }
          }

        return 0;
      }
}

/********************************************************
  Class: fdUvxtAVx
  *******************************************************/
final class fdUvxtAVx //**NS**
{
  /********************************************************
    Function: impos
    Description:
    *******************************************************/
  static void impos
    (
     String message
     )
      {
        System.out.println("Java-Lex Error: " + message);
      }

  /********************************************************
    Constants
    Description: Error codes for parse_error().
    *******************************************************/
  static final int E_BADEXPR = 0;
  static final int E_PAREN = 1;
  static final int E_LENGTH = 2;
  static final int E_BRACKET = 3;
  static final int E_BOL = 4;
  static final int E_CLOSE = 5;
  static final int E_NEWLINE = 6;
  static final int E_BADMAC = 7;
  static final int E_NOMAC = 8;
  static final int E_MACDEPTH = 9;
  static final int E_INIT = 10;
  static final int E_EOF = 11;
  static final int E_DIRECT = 12;
  static final int E_INTERNAL = 13;
  static final int E_STATE = 14;
  static final int E_MACDEF = 15;
  static final int E_SYNTAX = 16;
  static final int E_BRACE = 17;
  
  /********************************************************
    Constants
    Description: String messages for parse_error();
    *******************************************************/
  static final String errmsg[] = 
    {
      "Malformed regular expression.",
      "Missing close parenthesis.",
      "Too many regular expressions or expression too long.",
      "Missing [ in character class.",
      "^ must be at start of expression or after [.",
      "+ ? or * must follow an expression or subexpression.",
      "Newline in quoted string.",
      "Missing } in macro expansion.",
      "Macro does not exist.",
      "Macro expansions nested too deeply.",
      "Java-Lex has not been successfully initialized.",
      "Unexpected end-of-file found.",
      "Undefined or badly-formed Java-Lex directive.",
      "Internal Java-Lex error.",
      "Unitialized state name.",
      "Badly formed macro definition.",
      "Syntax error.",
      "Missing brace at start of lexical action."
    };
  
  /********************************************************
    Function: parse_error
    Description:
    *******************************************************/
  static void parse_error
    (
     int error_code,
     int line_number
     )
      {
        System.out.println("Error: Parse error at line " 
                           + line_number + ".");
        System.out.println("Error Description: " + errmsg[error_code]);
        throw new Error("Parse error.");
      }
}

/********************************************************
  Class: pSbNWjWEi
  *******************************************************/
final  class pSbNWjWEi 
{
  /********************************************************
    Member Variables
    *******************************************************/
  private BitSet m_set;
  private boolean m_complement;

  /********************************************************
    Function: pSbNWjWEi
    *******************************************************/
  pSbNWjWEi
    (
     )
    {
      m_set = new BitSet();
      m_complement = false;
    }

  /********************************************************
    Function: complement
    *******************************************************/
  void complement
    (
     )
      {
        m_complement = true;
      }

  /********************************************************
    Function: add
    *******************************************************/
  void add
    (
     int i
     )
      {
        m_set.set(i);
      }
  
  /********************************************************
    Function: contains
    *******************************************************/
  boolean contains
    (
     int i
     )
      {
        boolean result;
        
        result = m_set.get(i);
        
        if (true == m_complement)
          {
            return (false == result);
          }
        
        return result;
      }

  /********************************************************
    Function: mimic
    *******************************************************/
  void mimic
    (
     pSbNWjWEi set
     )
      {
        m_complement = set.m_complement;
        m_set = (BitSet) set.m_set.clone();
      } 
}

/********************************************************
  Class: layAuDXcf
  *******************************************************/
final class layAuDXcf //**NS**
{
  /********************************************************
    Member Variables
    *******************************************************/
  int m_edge;  /* Label for edge type:
                         character code, 
                         CCL (character class), 
                         [STATE,
                         SCL (state class),]
                         EMPTY, 
                         EPSILON. */
  
  pSbNWjWEi m_set;  /* Set to store character classes. */
  layAuDXcf m_next;  /* Next state (or null if none). */
  
  layAuDXcf m_next2;  /* Another state with type == EPSILON
                           and null if not used.  
                           The NFA construction should result in two
                           outgoing edges only if both are EPSILON edges. */
  
  xAYJWnUkN m_accept;  /* Set to null if nonaccepting state. */
  int m_anchor;  /* Says if and where pattern is anchored. */

  int m_label;

  BitSet m_states;

  /********************************************************
    Constants
    *******************************************************/
  static final int NO_LABEL = -1;

  /********************************************************
    Constants: Edge Types
    Note: Edge transitions on one specific character
    are labelled with the character Ascii (Unicode)
    codes.  So none of the constants below should
    overlap with the natural character codes.
    *******************************************************/
  static final int CCL = -1;
  static final int EMPTY = -2;
  static final int EPSILON = -3;
   
  /********************************************************
    Function: layAuDXcf
    *******************************************************/
 layAuDXcf
    (
     )
    {
      m_edge = EMPTY;
      m_set = null;
      m_next = null;
      m_next2 = null;
      m_accept = null;
      m_anchor = aYvbfLVVU.NONE;
      m_label = NO_LABEL;
      m_states = null;
    }

  /********************************************************
    Function: mimic
    Description: Converts this NFA state into a copy of
    the input one.
    *******************************************************/
  void mimic
    (
     layAuDXcf nfa
     )
      {
        m_edge = nfa.m_edge;
        
        if (null != nfa.m_set)
          {
            if (null == m_set)
              {
                m_set = new pSbNWjWEi();
              }
            m_set.mimic(nfa.m_set);
          }
        else
          {
            m_set = null;
          }

        m_next = nfa.m_next;
        m_next2 = nfa.m_next2;
        m_accept = nfa.m_accept;
        m_anchor = nfa.m_anchor;

        if (null != nfa.m_states)
          {
            m_states = (BitSet) nfa.m_states.clone();
          }
        else
          {
            m_states = null;
          }
      }
}

/***************************************************************
  Class: YUydifjdg
  **************************************************************/
final class YUydifjdg //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private InputStream m_instream; /* Java-Lex specification file. */
  private DataOutputStream m_outstream; /* Lexical analyzer source file. */

  private WiTcXJFSS m_input; /* Input buffer class. */

  private Hashtable m_tokens; /* Hashtable that maps characters to their 
                                 corresponding lexical code for
                                 the internal lexical analyzer. */
  private aYvbfLVVU m_spec; /* Spec class holds information
                           about the generated lexer. */
  private boolean m_init_flag; /* Flag set to true only upon 
                                  successful initialization. */

  private WGsEYKEwb m_makeNfa; /* NFA machine generator module. */
  private lQsXXpbpa m_nfa2dfa; /* NFA to DFA machine (transition table) 
                                 conversion module. */
  private TyWHbCSwu m_minimize; /* Transition table compressor. */
  private PepwQHsOl m_emit; /* Output module that emits source code
                           into the generated lexer file. */


  /********************************************************
    Constants
    *******************************************************/
  private static final boolean ERROR = false;
  private static final boolean NOT_ERROR = true;
  private static final int BUFFER_SIZE = 1024;

  /********************************************************
    Constants: Token Types
    *******************************************************/
  static final int EOS = 1;
  static final int ANY = 2;
  static final int AT_BOL = 3;
  static final int AT_EOL = 4;
  static final int CCL_END = 5;
  static final int CCL_START = 6;
  static final int CLOSE_CURLY = 7;
  static final int CLOSE_PAREN = 8;
  static final int CLOSURE = 9;
  static final int DASH = 10;
  static final int END_OF_INPUT = 11;
  static final int L = 12;
  static final int OPEN_CURLY = 13;
  static final int OPEN_PAREN = 14;
  static final int OPTIONAL = 15;
  static final int OR = 16;
  static final int PLUS_CLOSE = 17;

  /***************************************************************
    Function: YUydifjdg
    **************************************************************/
  YUydifjdg 
    (
     String filename
     )
      throws java.io.FileNotFoundException, java.io.IOException
      {
        /* Successful initialization flag. */
        m_init_flag = false;
        
        /* Open input stream. */
        m_instream = new FileInputStream(filename);
        if (null == m_instream)
          {
            System.out.println("Error: Unable to open input file "
                               + filename + ".");
            return;
          }

        /* Open output stream. */
        m_outstream = new DataOutputStream(
                        /*new BufferedOutputStream(*/
                          new FileOutputStream(filename + ".java")/*)*/); //**NS**
        if (null == m_outstream)
          {
            System.out.println("Error: Unable to open output file "
                               + filename + ".java.");
            return;
          }

        /* Create input buffer class. */
        m_input = new WiTcXJFSS(m_instream);

        /* Initialize character hash table. */
        m_tokens = new Hashtable();
        m_tokens.put(new Character('$'),new Integer(AT_EOL));
        m_tokens.put(new Character('('),new Integer(OPEN_PAREN));
        m_tokens.put(new Character(')'),new Integer(CLOSE_PAREN));
        m_tokens.put(new Character('*'),new Integer(CLOSURE));
        m_tokens.put(new Character('+'),new Integer(PLUS_CLOSE));
        m_tokens.put(new Character('-'),new Integer(DASH));
        m_tokens.put(new Character('.'),new Integer(ANY));
        m_tokens.put(new Character('?'),new Integer(OPTIONAL));
        m_tokens.put(new Character('['),new Integer(CCL_START));
        m_tokens.put(new Character(']'),new Integer(CCL_END));
        m_tokens.put(new Character('^'),new Integer(AT_BOL));
        m_tokens.put(new Character('{'),new Integer(OPEN_CURLY));
        m_tokens.put(new Character('|'),new Integer(OR));
        m_tokens.put(new Character('}'),new Integer(CLOSE_CURLY));
      
        /* Initialize spec structure. */
        m_spec = new aYvbfLVVU(this);
        
        /* Nfa to dfa converter. */
        m_nfa2dfa = new lQsXXpbpa();
        m_minimize = new TyWHbCSwu();
        m_makeNfa = new WGsEYKEwb();

        m_emit = new PepwQHsOl();

        /* Successful initialization flag. */
        m_init_flag = true;
      }

  /***************************************************************
    Function: generate
    Description: 
    **************************************************************/
  void generate
    (
     )
      throws java.io.IOException, java.io.FileNotFoundException
      {
        if (false == m_init_flag)
          {
            fdUvxtAVx.parse_error(fdUvxtAVx.E_INIT,0);
          }

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != this);
            INAhxAQiZ.assert(null != m_outstream);
            INAhxAQiZ.assert(null != m_input);
            INAhxAQiZ.assert(null != m_tokens);
            INAhxAQiZ.assert(null != m_spec);
            INAhxAQiZ.assert(true == m_init_flag);
          }

        /*m_emit.emit_imports(m_spec,m_outstream);*/

        if (m_spec.m_verbose)
          {
            System.out.println("Processing first section -- user code.");
          }
        userCode();
        if (true == m_input.m_eof_reached)
          {
            fdUvxtAVx.parse_error(fdUvxtAVx.E_EOF,m_input.m_line_number);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Processing second section -- " 
                               + "Java-Lex declarations.");
          }
        userDeclare();
        if (true == m_input.m_eof_reached)
          {
            fdUvxtAVx.parse_error(fdUvxtAVx.E_EOF,m_input.m_line_number);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Processing third section -- lexical rules.");
          }
        userRules();
        if (true == INAhxAQiZ.DO_DEBUG)
          {
            print_header();
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Outputting lexical analyzer code.");
          }
        m_emit.emit(m_spec,m_outstream);

        if (m_spec.m_verbose && true == INAhxAQiZ.OLD_DUMP_DEBUG)
          {
            details();
          }
      }

  /***************************************************************
    Function: userCode
    Description: Process first section of specification,
    echoing it into output file.
    **************************************************************/
  private void userCode
    (
     )
      throws java.io.IOException
      {
        int count = 0;

        if (false == m_init_flag)
          {
            fdUvxtAVx.parse_error(fdUvxtAVx.E_INIT,0);
          }

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != this);
            INAhxAQiZ.assert(null != m_outstream);
            INAhxAQiZ.assert(null != m_input);
            INAhxAQiZ.assert(null != m_tokens);
            INAhxAQiZ.assert(null != m_spec);
          }

        if (true == m_input.m_eof_reached)
          {
            fdUvxtAVx.parse_error(fdUvxtAVx.E_EOF,0);
          }

        while (true)
          {
            if (true == m_input.getLine())
              {
                /* Eof reached. */
                fdUvxtAVx.parse_error(fdUvxtAVx.E_EOF,0);
              }
            
            if (2 <= m_input.m_line_read 
                && '%' == m_input.m_line[0]
                && '%' == m_input.m_line[1])
              {
                /* Discard remainder of line. */
                m_input.m_line_index = m_input.m_line_read;
                return;
              }

            m_outstream.writeBytes(new String(m_input.m_line,0,
                                              m_input.m_line_read));
          }
      }

  /***************************************************************
    Function: getName
    **************************************************************/
  private char[] getName
    (
     )
      {
        char buffer[];
        int elem;

        /* Skip white space. */
        while (m_input.m_line_index < m_input.m_line_read
               && true == INAhxAQiZ.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
          }

        /* No name? */
        if (m_input.m_line_index >= m_input.m_line_read)
          {
            fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,0);
          }

        /* Determine length. */
        elem = m_input.m_line_index;
        while (elem < m_input.m_line_read
               && false == INAhxAQiZ.isnewline(m_input.m_line[elem]))
          {
            ++elem;
          } 

        /* Allocate non-terminated buffer of exact length. */
        buffer = new char[elem - m_input.m_line_index];
        
        /* Copy. */
        elem = 0;
        while (m_input.m_line_index < m_input.m_line_read
               && false == INAhxAQiZ.isnewline(m_input.m_line[m_input.m_line_index]))
          {
            buffer[elem] = m_input.m_line[m_input.m_line_index];
            ++elem;
            ++m_input.m_line_index;
          }

        return buffer;
      }

  private static final int CLASS_CODE = 0;       //**NS**
  private static final int INIT_CODE = 1;        //**NS**
  private static final int EOF_CODE = 2;         //**NS**
  private static final int INIT_THROW_CODE = 3;  //**NS**
  private static final int YYLEX_THROW_CODE = 4; //**NS**
  private static final int EOF_THROW_CODE = 5;   //**NS**
  private static final int EOF_VALUE_CODE = 6;   //**NS**

  /***************************************************************
    Function: packCode
    Description:
    **************************************************************/
  private char[] packCode
    (
     char start_dir[],
     char end_dir[],
     char prev_code[],
     int prev_read,
     int specified
     )
      throws java.io.IOException
      {
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(INIT_CODE == specified 
                            || CLASS_CODE == specified
                            || EOF_CODE == specified
                            || EOF_VALUE_CODE == specified
                            || INIT_THROW_CODE == specified
                            || YYLEX_THROW_CODE == specified
                            || EOF_THROW_CODE == specified);
          }

        if (0 != INAhxAQiZ.charncmp(m_input.m_line,
                                   0,
                                   start_dir,
                                   0,
                                   start_dir.length - 1))
          {
            fdUvxtAVx.parse_error(fdUvxtAVx.E_INTERNAL,0);
          }
        
        if (null == prev_code)
          {
            prev_code = new char[BUFFER_SIZE];
            prev_read = 0;
          }
        
        if (prev_read >= prev_code.length)
          {
            prev_code = INAhxAQiZ.doubleSize(prev_code);
          }
        
        m_input.m_line_index = start_dir.length - 1;
        while (true)
          {
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    fdUvxtAVx.parse_error(fdUvxtAVx.E_EOF,m_input.m_line_number);
                  }
                
                if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                           0,
                                           end_dir,
                                           0,
                                           end_dir.length - 1))
                  {
                    m_input.m_line_index = end_dir.length - 1;
                    
                    switch (specified)
                      {
                      case CLASS_CODE:
                        m_spec.m_class_read = prev_read;
                        break;
                        
                      case INIT_CODE:
                        m_spec.m_init_read = prev_read;
                        break;
                        
                      case EOF_CODE:
                        m_spec.m_eof_read = prev_read;
                        break;

                      case EOF_VALUE_CODE:
                        m_spec.m_eof_value_read = prev_read;
                        break;

                      case INIT_THROW_CODE:
                        m_spec.m_init_throw_read = prev_read;
                        break;

                      case YYLEX_THROW_CODE:
                        m_spec.m_yylex_throw_read = prev_read;
                        break;
                        
                      case EOF_THROW_CODE:
                        m_spec.m_eof_throw_read = prev_read;
                        break;
                        
                      default:
                        fdUvxtAVx.parse_error(fdUvxtAVx.E_INTERNAL,m_input.m_line_number);
                        break;
                      }

                    return prev_code;
                  }
              }

            while (m_input.m_line_index < m_input.m_line_read)
              {
                prev_code[prev_read] = m_input.m_line[m_input.m_line_index];
                ++prev_read;
                ++m_input.m_line_index;

                if (prev_read >= prev_code.length)
                  {
                    prev_code = INAhxAQiZ.doubleSize(prev_code);
                  }
              }
          }
      }

  /***************************************************************
    Member Variables: Java-Lex directives.
    **************************************************************/
  private char m_state_dir[] = { 
    '%', 's', 't', 
    'a', 't', 'e',
    '\0'
    };
  
  private char m_char_dir[] = { 
    '%', 'c', 'h',
    'a', 'r',
    '\0'
    };

  private char m_line_dir[] = { 
    '%', 'l', 'i',
    'n', 'e',
    '\0'
    };

  private char m_cup_dir[] = { 
    '%', 'c', 'u',
    'p', 
    '\0'
    };

  private char m_class_dir[] = { 
    '%', 'c', 'l', 
    'a', 's', 's',
    '\0'
    };

  private char m_function_dir[] = { 
    '%', 'f', 'u',
    'n', 'c', 't',
    'i', 'o', 'n',
    '\0'
    };

  private char m_type_dir[] = { 
    '%', 't', 'y',
    'p', 'e',
    '\0'
    };

  private char m_integer_dir[] = { 
    '%', 'i', 'n',
    't', 'e', 'g', 
    'e', 'r',
    '\0'
    };

  private char m_intwrap_dir[] = { 
    '%', 'i', 'n',
    't', 'w', 'r', 
    'a', 'p',
    '\0'
    };

  private char m_full_dir[] = { 
    '%', 'f', 'u', 
    'l', 'l',
    '\0'
    };

  private char m_unicode_dir[] = { 
    '%', 'u', 'n', 
    'i', 'c', 'o',
    'd', 'e',
    '\0'
    };

  private char m_notunix_dir[] = { 
    '%', 'n', 'o',
    't', 'u', 'n', 
    'i', 'x',
    '\0'
    };

  private char m_init_code_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', '{',
    '\0'
    };

  private char m_init_code_end_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', '}',
    '\0'
    };

  private char m_init_throw_code_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', 't',
    'h', 'r', 'o',
    'w', '{',
    '\0'
    };

  private char m_init_throw_code_end_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', 't',
    'h', 'r', 'o',
    'w', '}',
    '\0'
    };

  private char m_yylex_throw_code_dir[] = { 
    '%', 'y', 'y', 'l', 
    'e', 'x', 't',
    'h', 'r', 'o',
    'w', '{',
    '\0'
    };

  private char m_yylex_throw_code_end_dir[] = { 
    '%', 'y', 'y', 'l', 
    'e', 'x', 't',
    'h', 'r', 'o',
    'w', '}',
    '\0'
    };

  private char m_eof_code_dir[] = { 
    '%', 'e', 'o', 
    'f', '{',
    '\0'
    };

  private char m_eof_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', '}',
    '\0'
    };

  private char m_eof_value_code_dir[] = { 
    '%', 'e', 'o', 
    'f', 'v', 'a', 
    'l', '{',
    '\0'
    };

  private char m_eof_value_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', 'v', 'a',
    'l', '}',
    '\0'
    };

  private char m_eof_throw_code_dir[] = { 
    '%', 'e', 'o', 
    'f', 't', 'h',
    'r', 'o', 'w',
    '{',
    '\0'
    };

  private char m_eof_throw_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', 't', 'h',
    'r', 'o', 'w',
    '}',
    '\0'
    };

  private char m_class_code_dir[] = { 
    '%', '{',
    '\0'
    };

  private char m_class_code_end_dir[] = { 
    '%', '}',
    '\0'
    };

  private char m_yyeof_dir[] = { 
    '%', 'y', 'y',
    'e', 'o', 'f',
    '\0'
    };
  
  /***************************************************************
    Function: userDeclare
    Description:
    **************************************************************/
  private void userDeclare
    (
     )
      throws java.io.IOException
        {
          int elem;
          
          if (INAhxAQiZ.DEBUG)
            {
              INAhxAQiZ.assert(null != this);
              INAhxAQiZ.assert(null != m_outstream);
              INAhxAQiZ.assert(null != m_input);
              INAhxAQiZ.assert(null != m_tokens);
              INAhxAQiZ.assert(null != m_spec);
            }

          if (true == m_input.m_eof_reached)
            {
              /* End-of-file. */
              fdUvxtAVx.parse_error(fdUvxtAVx.E_EOF,
                                 m_input.m_line_number);
            }

          while (false == m_input.getLine())
            {
              /* Look for double percent. */
              if (2 <= m_input.m_line_read 
                  && '%' == m_input.m_line[0] 
                  && '%' == m_input.m_line[1])
                {
                  /* Mess around with line. */
                  for (elem = 0; elem < m_input.m_line.length - 2; ++elem)
                    {
                      m_input.m_line[elem] = m_input.m_line[elem + 2];
                    }
                  m_input.m_line_read = m_input.m_line_read - 2;

                  m_input.m_pushback_line = true;
                  /* Check for and discard empty line. */
                  if (0 == m_input.m_line_read 
                      || '\n' == m_input.m_line[0])
                    {
                      m_input.m_pushback_line = false;
                    }

                  return;
                }

              if (0 == m_input.m_line_read)
                {
                  continue;
                }

              if ('%' == m_input.m_line[0])
                {
                  /* Special lex declarations. */
                  if (1 >= m_input.m_line_read)
                    {
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      continue;
                    }

                  switch (m_input.m_line[1])
                    {
                    case '{':
                      if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                 0,
                                                 m_class_code_dir,
                                                 0,
                                                 m_class_code_dir.length - 1))
                        {
                          m_spec.m_class_code = packCode(m_class_code_dir,
                                                         m_class_code_end_dir,
                                                         m_spec.m_class_code,
                                                         m_spec.m_class_read,
                                                         CLASS_CODE);
                          break;
                        }
              
                      /* Bad directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'c':
                      if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                 0,
                                                 m_char_dir,
                                                 0,
                                                 m_char_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_char_dir.length;
                          m_spec.m_count_chars = true;
                          break;
                        }       
                      else if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                      0,
                                                      m_cup_dir,
                                                      0,
                                                      m_cup_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_cup_dir.length;
                          m_spec.m_cup_compatible = true;
                          break;
                        }
                      else if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                      0,
                                                      m_class_dir, 
                                                      0,
                                                      m_class_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_class_dir.length;
                          m_spec.m_class_name = getName();
                          break;
                        }
              
                      /* Bad directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                      
                    case 'e':
                      if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                 0,
                                                 m_eof_code_dir,
                                                 0,
                                                 m_eof_code_dir.length - 1))
                        {
                          m_spec.m_eof_code = packCode(m_eof_code_dir,
                                                       m_eof_code_end_dir,
                                                       m_spec.m_eof_code,
                                                       m_spec.m_eof_read,
                                                       EOF_CODE);
                          break;
                        }
                      else if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                      0,
                                                      m_eof_value_code_dir,
                                                      0,
                                                      m_eof_value_code_dir.length - 1))
                        {
                          m_spec.m_eof_value_code = packCode(m_eof_value_code_dir,
                                                             m_eof_value_code_end_dir,
                                                             m_spec.m_eof_value_code,
                                                             m_spec.m_eof_value_read,
                                                             EOF_VALUE_CODE);
                          break;
                        }
                      else if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                      0,
                                                      m_eof_throw_code_dir,
                                                      0,
                                                      m_eof_throw_code_dir.length - 1))
                        {
                          m_spec.m_eof_throw_code = packCode(m_eof_throw_code_dir,
                                                       m_eof_throw_code_end_dir,
                                                       m_spec.m_eof_throw_code,
                                                       m_spec.m_eof_throw_read,
                                                       EOF_THROW_CODE);
                          break;
                        }
              
                      /* Bad directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'f':
                      if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                 0,
                                                 m_function_dir,
                                                 0,
                                                 m_function_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_function_dir.length;
                          m_spec.m_function_name = getName();
                          break;
                        }
                      else if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                      0,
                                                      m_full_dir,
                                                      0,
                                                      m_full_dir.length - 1))
                        {
                          m_input.m_line_index = m_full_dir.length;
                          m_spec.m_dtrans_ncols = INAhxAQiZ.MAX_EIGHT_BIT + 1;
                          break;
                        }

                      /* Bad directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'i':
                      if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                 0,
                                                 m_integer_dir,
                                                 0,
                                                 m_integer_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_integer_dir.length;
                          m_spec.m_integer_type = true;
                          break;
                        }
                      else if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                      0,
                                                      m_intwrap_dir,
                                                      0,
                                                      m_intwrap_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_integer_dir.length;
                          m_spec.m_intwrap_type = true;
                          break;
                        }
                      else if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                      0,
                                                      m_init_code_dir,
                                                      0,
                                                      m_init_code_dir.length - 1))
                        {
                          m_spec.m_init_code = packCode(m_init_code_dir,
                                                        m_init_code_end_dir,
                                                        m_spec.m_init_code,
                                                        m_spec.m_init_read,
                                                        INIT_CODE);
                          break;
                        }
                      else if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                      0,
                                                      m_init_throw_code_dir,
                                                      0,
                                                      m_init_throw_code_dir.length - 1))
                        {
                          m_spec.m_init_throw_code = packCode(m_init_throw_code_dir,
                                                       m_init_throw_code_end_dir,
                                                       m_spec.m_init_throw_code,
                                                       m_spec.m_init_throw_read,
                                                       INIT_THROW_CODE);
                          break;
                        }

                      /* Bad directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'l':
                      if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                 0,
                                                 m_line_dir,
                                                 0,
                                                 m_line_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_line_dir.length;
                          m_spec.m_count_lines = true;
                          break;
                        }

                      /* Bad directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'n':
                      if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                 0,
                                                 m_notunix_dir,
                                                 0,
                                                 m_notunix_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_notunix_dir.length;
                          m_spec.m_unix = false;
                          break;
                        }

                      /* Bad directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 's':
                      if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                 0,
                                                 m_state_dir,
                                                 0,
                                                 m_state_dir.length - 1))
                        {
                          /* Recognize state list. */
                          m_input.m_line_index = m_state_dir.length;
                          saveStates();
                          break;
                        }

                      /* Undefined directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                     
                    case 't':
                      if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                 0,
                                                 m_type_dir,
                                                 0,
                                                 m_type_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_type_dir.length;
                          m_spec.m_type_name = getName();
                          break;
                        }

                      /* Undefined directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'u':
                      if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                 0,
                                                 m_unicode_dir,
                                                 0,
                                                 m_unicode_dir.length - 1))
                        {
                          m_input.m_line_index = m_unicode_dir.length;
                          /* UNDONE: What to do here? */
                          break;
                        }

                      /* Bad directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'y':
                      if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                 0,
                                                 m_yyeof_dir,
                                                 0,
                                                 m_yyeof_dir.length - 1))
                        {
                          m_input.m_line_index = m_yyeof_dir.length;
                          m_spec.m_yyeof = true;
                          break;
                        } else if (0 == INAhxAQiZ.charncmp(m_input.m_line,
                                                          0,
                                                          m_yylex_throw_code_dir,
                                                          0,
                                                          m_yylex_throw_code_dir.length - 1))
                        {
                          m_spec.m_yylex_throw_code = packCode(m_yylex_throw_code_dir,
                                                               m_yylex_throw_code_end_dir,
                                                       m_spec.m_yylex_throw_code,
                                                       m_spec.m_yylex_throw_read,
                                                       YYLEX_THROW_CODE);
                          break;
                        }


                      /* Bad directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    default:
                      /* Undefined directive. */
                      fdUvxtAVx.parse_error(fdUvxtAVx.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                    }
                }
              else
                {
                  /* Regular expression macro. */
                  m_input.m_line_index = 0;
                  saveMacro();
                }

              if (INAhxAQiZ.OLD_DEBUG)
                {
                  System.out.println("Line number " 
                                     + m_input.m_line_number + ":"); 
                  System.out.print(new String(m_input.m_line,
                                              0,m_input.m_line_read));
                }
            }
        }
         
  /***************************************************************
    Function: userRules
    Description: Processes third section of Java-Lex 
    specification and creates minimized transition table.
    **************************************************************/
  private void userRules
    (
     )
      throws java.io.IOException
      {
        int code;

        if (false == m_init_flag)
          {
            fdUvxtAVx.parse_error(fdUvxtAVx.E_INIT,0);
          }

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != this);
            INAhxAQiZ.assert(null != m_outstream);
            INAhxAQiZ.assert(null != m_input);
            INAhxAQiZ.assert(null != m_tokens);
            INAhxAQiZ.assert(null != m_spec);
          }

        /* UNDONE: Need to handle states preceding rules. */
        
        if (m_spec.m_verbose)
          {
            System.out.println("Creating NFA machine representation.");
          }
        m_makeNfa.thompson(this,m_spec,m_input);
        
        /*print_nfa();*/

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(END_OF_INPUT == m_spec.m_current_token);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Creating DFA transition table.");
          }
        m_nfa2dfa.make_dfa(this,m_spec);

        if (INAhxAQiZ.FOODEBUG) {
          print_header();
        }

        if (m_spec.m_verbose)
          {
            System.out.println("Minimizing DFA transition table.");
          }
        m_minimize.min_dfa(m_spec);
      }

  /***************************************************************
    Function: printccl
    Description: Debuggng routine that outputs readable form
    of character class.
    **************************************************************/
  private void printccl
    (
     pSbNWjWEi set
     )
      {
        int i;
        
        System.out.print(" [");
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (true == set.contains(i))
              {
                System.out.print(interp_int(i));
              }
          }
        System.out.print(']');
      }

  /***************************************************************
    Function: plab
    Description:
    **************************************************************/
  private String plab
    (
     layAuDXcf state
     )
      {
        int index;
        
        if (null == state)
          {
            return (new String("--"));
          }

        index = m_spec.m_nfa_states.indexOf(state);
        
        return ((new Integer(index)).toString());
      }

  /***************************************************************
    Function: interp_int
    Description:
    **************************************************************/
  private String interp_int
    (
     int i
     )
      {
        switch (i)
          {
          case (int) '\b':
            return (new String("\\b"));

          case (int) '\t':
            return (new String("\\t"));

          case (int) '\n':
            return (new String("\\n"));

          case (int) '\f':
            return (new String("\\f"));

          case (int) '\r':
            return (new String("\\r"));
            
          case (int) ' ':
            return (new String("\\ "));
            
          default:
            return ((new Character((char) i)).toString());
          }
      }

  /***************************************************************
    Function: print_nfa
    Description:
    **************************************************************/
  void print_nfa
    (
     )
      {
        int elem;
        layAuDXcf nfa;
        int size;
        Enumeration states;
        Integer index;
        int i;
        int j;
        int vsize;
        String state;
     
        System.out.println("--------------------- NFA -----------------------");
        
        size = m_spec.m_nfa_states.size();
        for (elem = 0; elem < size; ++elem)
          {
            nfa = (layAuDXcf) m_spec.m_nfa_states.elementAt(elem);
            
            System.out.print("Nfa state " + plab(nfa) + ": ");
            
            if (null == nfa.m_next)
              {
                System.out.print("(TERMINAL)");
              }
            else
              {
                System.out.print("--> " + plab(nfa.m_next));
                System.out.print("--> " + plab(nfa.m_next2));
                
                switch (nfa.m_edge)
                  {
                  case layAuDXcf.CCL:
                    printccl(nfa.m_set);
                    break;

                  case layAuDXcf.EPSILON:
                    System.out.print(" EPSILON ");
                    break; 
                    
                  default:
                    System.out.print(" " + interp_int(nfa.m_edge));
                    break;
                  }
              }

            if (0 == elem)
              {
                System.out.print(" (START STATE)");
              }
            
            if (null != nfa.m_accept)
              {
                System.out.print(" accepting " 
                                 + ((0 != (nfa.m_anchor & aYvbfLVVU.START)) ? "^" : "")
                                 + "<" 
                                 + (new String(nfa.m_accept.m_action,0,
                                               nfa.m_accept.m_action_read))
                                 + ">"
                                 + ((0 != (nfa.m_anchor & aYvbfLVVU.END)) ? "$" : ""));
              }

            System.out.println("");
          }

        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(null != state);
                INAhxAQiZ.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");
            System.out.print("\tStart states of matching rules: ");
            
            i = index.intValue();
            vsize = m_spec.m_state_rules[i].size();
            
            for (j = 0; j < vsize; ++j)
              {
                nfa = (layAuDXcf) m_spec.m_state_rules[i].elementAt(j);

                System.out.print(m_spec.m_nfa_states.indexOf(nfa) + " ");
              }

            System.out.println("");
          }

        System.out.println("-------------------- NFA ----------------------");
      }

  /***************************************************************
    Function: getStates
    Description: Parses the state area of a rule,
    from the beginning of a line.
    < state1, state2 ... > regular_expression { action }
    Returns null on only EOF.  Returns all_states, 
    initialied properly to correspond to all states,
    if no states are found.
    Special Notes: This function treats commas as optional
    and permits states to be spread over multiple lines.
    **************************************************************/
  private BitSet all_states = null;
  BitSet getStates
    (
     )
      throws java.io.IOException
      {
        int start_state;
        int count_state;
        BitSet states;
        String name;
        Integer index;
        int i;
        int size;
        
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != this);
            INAhxAQiZ.assert(null != m_outstream);
            INAhxAQiZ.assert(null != m_input);
            INAhxAQiZ.assert(null != m_tokens);
            INAhxAQiZ.assert(null != m_spec);
          }

        states = null;

        /* Skip white space. */
        while (true == INAhxAQiZ.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
    
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                /* Must just be an empty line. */
                if (true == m_input.getLine())
                  {
                    /* EOF found. */
                    return null;
                  }
              }
          }

        /* Look for states. */
        if ('<' == m_input.m_line[m_input.m_line_index])
          {
            ++m_input.m_line_index;
           
            states = new BitSet();

            /* Parse states. */
            while (true)
              {
                /* We may have reached the end of the line. */
                while (m_input.m_line_index >= m_input.m_line_read)
                  {
                    if (true == m_input.getLine())
                      {
                        /* EOF found. */
                        fdUvxtAVx.parse_error(fdUvxtAVx.E_EOF,m_input.m_line_number);
                        return states;
                      }
                  }

                while (true)
                  {
                    /* Skip white space. */
                    while (true == INAhxAQiZ.isspace(m_input.m_line[m_input.m_line_index]))
                      {
                        ++m_input.m_line_index;
                        
                        while (m_input.m_line_index >= m_input.m_line_read)
                          {
                            if (true == m_input.getLine())
                              {
                                /* EOF found. */
                                fdUvxtAVx.parse_error(fdUvxtAVx.E_EOF,m_input.m_line_number);
                                return states;
                              }
                          }
                      }
                    
                    if (',' != m_input.m_line[m_input.m_line_index])
                      {
                        break;
                      }

                    ++m_input.m_line_index;
                  }

                if ('>' == m_input.m_line[m_input.m_line_index])
                  {
                    ++m_input.m_line_index;
                    if (m_input.m_line_index < m_input.m_line_read)
                      {
                        m_advance_stop = true;
                      }
                    return states;
                  }

                /* Read in state name. */
                start_state = m_input.m_line_index;
                while (false == INAhxAQiZ.isspace(m_input.m_line[m_input.m_line_index])
                       && ',' != m_input.m_line[m_input.m_line_index]
                       && '>' != m_input.m_line[m_input.m_line_index])
                  {
                    ++m_input.m_line_index;

                    if (m_input.m_line_index >= m_input.m_line_read)
                      {
                        /* End of line means end of state name. */
                        break;
                      }
                  }
                count_state = m_input.m_line_index - start_state;

                /* Save name after checking definition. */
                name = new String(m_input.m_line,
                                  start_state,
                                  count_state);
                index = (Integer) m_spec.m_states.get(name);
                if (null == index)
                  {
                    /* Uninitialized state. */
                    System.out.println("Uninitialized State Name: " + name);
                    fdUvxtAVx.parse_error(fdUvxtAVx.E_STATE,m_input.m_line_number);
                  }
                states.set(index.intValue());
              }
          }
        
        if (null == all_states)
          {
            all_states = new BitSet();

            size = m_spec.m_states.size();
            for (i = 0; i < size; ++i)
              {
                all_states.set(i);
              }
          }
        
        if (m_input.m_line_index < m_input.m_line_read)
          {
            m_advance_stop = true;
          }
        return all_states;
      }

  /********************************************************
    Function: expandMacro
    Description: Returns false on error, true otherwise. 
    *******************************************************/
  private boolean expandMacro
    (
     )
      {
        int elem;
        int start_macro;
        int end_macro;
        int start_name;
        int count_name;
        String def;
        int def_elem;
        String name;
        char replace[];
        int rep_elem;

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != this);
            INAhxAQiZ.assert(null != m_outstream);
            INAhxAQiZ.assert(null != m_input);
            INAhxAQiZ.assert(null != m_tokens);
            INAhxAQiZ.assert(null != m_spec);
          }

        /* Check for macro. */
        if ('{' != m_input.m_line[m_input.m_line_index])
          {
            fdUvxtAVx.parse_error(fdUvxtAVx.E_INTERNAL,m_input.m_line_number);
            return ERROR;
          }
        
        start_macro = m_input.m_line_index;
        elem = m_input.m_line_index + 1;
        if (elem >= m_input.m_line_read)
          {
            fdUvxtAVx.impos("Unfinished macro name");
            return ERROR;
          }
        
        /* Get macro name. */
        start_name = elem;
        while ('}' != m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                fdUvxtAVx.impos("Unfinished macro name at line " + m_input.m_line_number);
                return ERROR;
              }
          }
        count_name = elem - start_name;
        end_macro = elem;

        /* Check macro name. */
        if (0 == count_name)
          {
            fdUvxtAVx.impos("Nonexistent macro name");
            return ERROR;
          }

        /* Debug checks. */
        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(0 < count_name);
          }

        /* Retrieve macro definition. */
        name = new String(m_input.m_line,start_name,count_name);
        def = (String) m_spec.m_macros.get(name);
        if (null == def)
          {
            fdUvxtAVx.impos("Undefined macro \"" + name + "\" on line: "+m_input.m_line_number);
            return ERROR;
          }
        if (INAhxAQiZ.OLD_DUMP_DEBUG)
          {
            System.out.println("expanded escape: " + def);
          }
                
        /* Replace macro in new buffer,
           beginning by copying first part of line buffer. */
        replace = new char[m_input.m_line.length];
        for (rep_elem = 0; rep_elem < start_macro; ++rep_elem)
          {
            replace[rep_elem] = m_input.m_line[rep_elem];

            if (INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(rep_elem < replace.length);
              }
          }
        
        /* Copy macro definition. */
        if (rep_elem >= replace.length)
          {
            replace = INAhxAQiZ.doubleSize(replace);
          }
        for (def_elem = 0; def_elem < def.length(); ++def_elem)
          {
            replace[rep_elem] = def.charAt(def_elem);
            
            ++rep_elem;
            if (rep_elem >= replace.length)
              {
                replace = INAhxAQiZ.doubleSize(replace);
              }
          }

        /* Copy last part of line. */
        if (rep_elem >= replace.length)
          {
            replace = INAhxAQiZ.doubleSize(replace);
          }
        for (elem = end_macro + 1; elem < m_input.m_line_read; ++elem)
          {
            replace[rep_elem] = m_input.m_line[elem];
            
            ++rep_elem;
            if (rep_elem >= replace.length)
              {
                replace = INAhxAQiZ.doubleSize(replace);
              }
          } 
        
        /* Replace buffer. */
        m_input.m_line = replace;
        m_input.m_line_read = rep_elem;
        
        if (INAhxAQiZ.OLD_DEBUG)
          {
//nsSystem.out.print("macro expansion is:" );
            System.out.println(new String(m_input.m_line,0,m_input.m_line_read));
          }
        return NOT_ERROR;
      }

  /***************************************************************
    Function: saveMacro
    Description: Saves macro definition of form:
    macro_name = macro_definition
    **************************************************************/
  private void saveMacro
    (
     )
      {
        int elem;
        int start_name;
        int count_name;
        int start_def;
        int count_def;
        boolean saw_escape;
        boolean in_quote;

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != this);
            INAhxAQiZ.assert(null != m_outstream);
            INAhxAQiZ.assert(null != m_input);
            INAhxAQiZ.assert(null != m_tokens);
            INAhxAQiZ.assert(null != m_spec);
          }

        /* Macro declarations are of the following form:
           macro_name macro_definition */

        elem = 0;
        
        /* Skip white space preceding macro name. */
        while (true == INAhxAQiZ.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* End of line has been reached,
                   and line was found to be empty. */
                return;
              }
          }

        /* Read macro name. */
        start_name = elem;
        while (false == INAhxAQiZ.isspace(m_input.m_line[elem])
               && '=' != m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                fdUvxtAVx.parse_error(fdUvxtAVx.E_MACDEF,m_input.m_line_number);
              }
          }
        count_name = elem - start_name;

        /* Check macro name. */
        if (0 == count_name) 
          {
            /* Nonexistent macro name. */
            fdUvxtAVx.parse_error(fdUvxtAVx.E_MACDEF,m_input.m_line_number);
          }

        /* Skip white space between name and definition. */
        while (true == INAhxAQiZ.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                fdUvxtAVx.parse_error(fdUvxtAVx.E_MACDEF,m_input.m_line_number);
              }
          }

        if ('=' == m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                fdUvxtAVx.parse_error(fdUvxtAVx.E_MACDEF,m_input.m_line_number);
              }
          }

        /* Skip white space between name and definition. */
        while (true == INAhxAQiZ.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                fdUvxtAVx.parse_error(fdUvxtAVx.E_MACDEF,m_input.m_line_number);
              }
          }

        /* Read macro definition. */
        start_def = elem;
        in_quote = false;
        saw_escape = false;
        while (false == INAhxAQiZ.isspace(m_input.m_line[elem])
               || true == in_quote
               || true == saw_escape)
          {
            if ('\"' == m_input.m_line[elem] && false == saw_escape)
              {
                if (true == in_quote)
                  {
                    in_quote = false;
                  }
                else
                  {
                    in_quote = true;
                  }
              }
            
            if ('\\' == m_input.m_line[elem] && false == saw_escape)
              {
                saw_escape = true;
              }
            else
              {
                saw_escape = false;
              }

            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* End of line. */
                break;
              }
          }
        count_def = elem - start_def;
          
        /* Check macro definition. */
        if (0 == count_def) 
          {
            /* Nonexistent macro name. */
            fdUvxtAVx.parse_error(fdUvxtAVx.E_MACDEF,m_input.m_line_number);
          }

        /* Debug checks. */
        if (true == INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(0 < count_def);
            INAhxAQiZ.assert(0 < count_name);
            INAhxAQiZ.assert(null != m_spec.m_macros);
          }

        if (INAhxAQiZ.OLD_DEBUG)
          {
            System.out.println("macro name \""
                               + new String(m_input.m_line,start_name,count_name)
                               + "\".");
            System.out.println("macro definition \""
                               + new String(m_input.m_line,start_def,count_def)
                               + "\".");
          }

        /* Add macro name and definition to table. */
        m_spec.m_macros.put(new String(m_input.m_line,start_name,count_name),
                            new String(m_input.m_line,start_def,count_def));
      }

  /***************************************************************
    Function: saveStates
    Description: Takes state declaration and makes entries
    for them in state hashtable in aYvbfLVVU structure.
    State declaration should be of the form:
    %state name0[, name1, name2 ...]
    (But commas are actually optional as long as there is 
    white space in between them.)
    **************************************************************/
  private void saveStates
    (
     )
      {
        int start_state;
        int count_state;

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != this);
            INAhxAQiZ.assert(null != m_outstream);
            INAhxAQiZ.assert(null != m_input);
            INAhxAQiZ.assert(null != m_tokens);
            INAhxAQiZ.assert(null != m_spec);
          }

        /* EOF found? */
        if (true == m_input.m_eof_reached)
          {
            return;
          }

        /* Debug checks. */
        if (true == INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert('%' == m_input.m_line[0]);
            INAhxAQiZ.assert('s' == m_input.m_line[1]);
            INAhxAQiZ.assert(m_input.m_line_index <= m_input.m_line_read);
            INAhxAQiZ.assert(0 <= m_input.m_line_index);
            INAhxAQiZ.assert(0 <= m_input.m_line_read);
          }

        /* Blank line?  No states? */
        if (m_input.m_line_index >= m_input.m_line_read)
          {
            return;
          }

        while (m_input.m_line_index < m_input.m_line_read)
          {
            if (INAhxAQiZ.OLD_DEBUG)
              {
                System.out.println("line read " + m_input.m_line_read 
                                   + "\tline index = " + m_input.m_line_index);
              }

            /* Skip white space. */
            while (true == INAhxAQiZ.isspace(m_input.m_line[m_input.m_line_index]))
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* No more states to be found. */
                    return;
                  }
              }
            
            /* Look for state name. */
            start_state = m_input.m_line_index;
            while (false == INAhxAQiZ.isspace(m_input.m_line[m_input.m_line_index])
                   && ',' != m_input.m_line[m_input.m_line_index])
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line and end of state name. */
                    break;
                  }
              }
            count_state = m_input.m_line_index - start_state;

            if (INAhxAQiZ.OLD_DEBUG)
              {
                System.out.println("State name \"" 
                                   + new String(m_input.m_line,start_state,count_state)
                                   + "\".");
                System.out.println("Integer index \"" 
                                   + m_spec.m_states.size()
                                   + "\".");
              }

            /* Enter new state name, along with unique index. */
            m_spec.m_states.put(new String(m_input.m_line,start_state,count_state),
                                new Integer(m_spec.m_states.size()));
            
            /* Skip comma. */
            if (',' == m_input.m_line[m_input.m_line_index])
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line. */
                    return;
                  }
              }
          }
      }

  /********************************************************
    Function: expandEscape
    Description: Takes escape sequence and returns
    corresponding character code.
    *******************************************************/
  private char expandEscape
    (
     )
      {
        char r;
        
        /* Debug checks. */
        if (true == INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(m_input.m_line_index < m_input.m_line_read);
            INAhxAQiZ.assert(0 < m_input.m_line_read);
            INAhxAQiZ.assert(0 <= m_input.m_line_index);
          }

        if ('\\' != m_input.m_line[m_input.m_line_index])
          {
            ++m_input.m_line_index;
            return m_input.m_line[m_input.m_line_index - 1];
          }
        else
          {
            ++m_input.m_line_index;
            switch (INAhxAQiZ.toupper(m_input.m_line[m_input.m_line_index]))
              {
              case 'B':
                ++m_input.m_line_index;
                return '\b';

              case 'T':
                ++m_input.m_line_index;
                return '\t';

              case 'N':
                ++m_input.m_line_index;
                return '\n';

              case 'F':
                ++m_input.m_line_index;
                return '\f';

              case 'R':
                ++m_input.m_line_index;
                return '\r';

              case '^':
                ++m_input.m_line_index;
                r = (char) (INAhxAQiZ.toupper(m_input.m_line[m_input.m_line_index]) 
                     - '@');
                ++m_input.m_line_index;
                return r;

              case 'X':
                ++m_input.m_line_index;
                r = 0;
                if (true == INAhxAQiZ.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = INAhxAQiZ.hex2bin(m_input.m_line[m_input.m_line_index]);
                    ++m_input.m_line_index;
                  }
                if (true == INAhxAQiZ.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = (char) (r << 4);
                    r = (char) (r | INAhxAQiZ.hex2bin(m_input.m_line[m_input.m_line_index]));
                    ++m_input.m_line_index;
                  }
                if (true == INAhxAQiZ.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = (char) (r << 4);
                    r = (char) (r | INAhxAQiZ.hex2bin(m_input.m_line[m_input.m_line_index]));
                    ++m_input.m_line_index;
                  }
                return r;
                
              default:
                if (false == INAhxAQiZ.isoctdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = m_input.m_line[m_input.m_line_index];
                    ++m_input.m_line_index;
                  }
                else
                  {
                    r = INAhxAQiZ.oct2bin(m_input.m_line[m_input.m_line_index]);
                    ++m_input.m_line_index;
                    
                    if (true == INAhxAQiZ.isoctdigit(m_input.m_line[m_input.m_line_index]))
                      {
                        r = (char) (r << 3);
                        r = (char) (r | INAhxAQiZ.oct2bin(m_input.m_line[m_input.m_line_index]));
                        ++m_input.m_line_index;
                      }

                    if (true == INAhxAQiZ.isoctdigit(m_input.m_line[m_input.m_line_index]))
                      {
                        r = (char) (r << 3);
                        r = (char) (r | INAhxAQiZ.oct2bin(m_input.m_line[m_input.m_line_index]));
                        ++m_input.m_line_index;
                      }
                  }
                return r;
              }
          }
      }
        
  /********************************************************
    Function: packAccept
    Description: Packages and returns xAYJWnUkN 
    for action next in input stream.
    *******************************************************/
  xAYJWnUkN packAccept
    (
     )
      throws java.io.IOException
      {
        xAYJWnUkN accept;
        char action[];
        int action_index;
        int brackets;

        action = new char[BUFFER_SIZE];
        action_index = 0;

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != this);
            INAhxAQiZ.assert(null != m_outstream);
            INAhxAQiZ.assert(null != m_input);
            INAhxAQiZ.assert(null != m_tokens);
            INAhxAQiZ.assert(null != m_spec);
          }

        /* Get a new line, if needed. */
        while (m_input.m_line_index >= m_input.m_line_read)
          {
            if (true == m_input.getLine())
              {
                fdUvxtAVx.parse_error(fdUvxtAVx.E_EOF,m_input.m_line_number);
                return null;
              }
          }
        
        /* Look for beginning of action. */
        while (true == INAhxAQiZ.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
            
            /* Get a new line, if needed. */
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    fdUvxtAVx.parse_error(fdUvxtAVx.E_EOF,m_input.m_line_number);
                    return null;
                  }
              }
          }
        
        /* Look for brackets. */
        if ('{' != m_input.m_line[m_input.m_line_index])
          {
            /*System.out.println("<" + m_input.m_line[m_input.m_line_index] + ">");*/
            fdUvxtAVx.parse_error(fdUvxtAVx.E_BRACE,m_input.m_line_number); 
          }
        
        /* Copy new line into action buffer. */
        brackets = 0;
        while (true)
          {
            action[action_index] = m_input.m_line[m_input.m_line_index];

            /* Look for brackets. */
            if ('{' == m_input.m_line[m_input.m_line_index])
              {
                ++brackets;
              }
            else if ('}' == m_input.m_line[m_input.m_line_index])
              {
                --brackets;
                
                if (0 == brackets)
                  {
                    ++action_index;
                    ++m_input.m_line_index;

                    break;
                  }
              }
            
            ++action_index;
            /* Double the buffer size, if needed. */
            if (action_index > action.length)
              {
                action = INAhxAQiZ.doubleSize(action);
              }

            ++m_input.m_line_index;
            /* Get a new line, if needed. */
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    fdUvxtAVx.parse_error(fdUvxtAVx.E_SYNTAX,m_input.m_line_number);
                    return null;
                  }
              }
          }
            
        accept = new xAYJWnUkN(action,action_index,m_input.m_line_number);

        if (INAhxAQiZ.DEBUG)
          {
            INAhxAQiZ.assert(null != accept);
          }

        if (INAhxAQiZ.DESCENT_DEBUG)
          {
            System.out.print("Accepting action:");
            System.out.println(new String(accept.m_action,0,accept.m_action_read));
          }

        return accept;
      }

  /********************************************************
    Function: advance
    Description: Returns code for next token.
    *******************************************************/
  private boolean m_advance_stop = false;
  int advance
    (
     )
      throws java.io.IOException
      {
        boolean saw_escape = false;
        Integer code;
        
        /*if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          INAhxAQiZ.assert(m_input.m_line_index <= m_input.m_line_read);
        }*/

        if (true == m_input.m_eof_reached)
          {
            /* EOF has already been reached,
               so return appropriate code. */

            m_spec.m_current_token = END_OF_INPUT;
            m_spec.m_lexeme = '\0';
            return m_spec.m_current_token;
          }

        /* End of previous regular expression?
           Refill line buffer? */
        if (EOS == m_spec.m_current_token
            /* ADDED */
            || m_input.m_line_index >= m_input.m_line_read)
            /* ADDED */
          {
            if (true == m_spec.m_in_quote)
              {
                fdUvxtAVx.parse_error(fdUvxtAVx.E_SYNTAX,m_input.m_line_number);
              }
            
            while (true)
              {
                if (false == m_advance_stop  
                    || m_input.m_line_index >= m_input.m_line_read)
                  {
                    if (true == m_input.getLine())
                      {
                        /* EOF has already been reached,
                           so return appropriate code. */
                        
                        m_spec.m_current_token = END_OF_INPUT;
                        m_spec.m_lexeme = '\0';
                        return m_spec.m_current_token;
                      }
                    m_input.m_line_index = 0;
                  }
                else
                  {
                    m_advance_stop = false;
                  }

                while (m_input.m_line_index < m_input.m_line_read
                       && true == INAhxAQiZ.isspace(m_input.m_line[m_input.m_line_index]))
                  {
                    ++m_input.m_line_index;
                  }
                
                if (m_input.m_line_index < m_input.m_line_read)
                  {
                    break;
                  }
              }
          }
        
        /*if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_number = " + m_input.m_line_number);
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          INAhxAQiZ.assert(m_input.m_line_index <= m_input.m_line_read);
        }*/
        if (INAhxAQiZ.DEBUG) {
          INAhxAQiZ.assert(m_input.m_line_index <= m_input.m_line_read);
        }

        /* Look for macro expansions. */
        if (false == m_spec.m_in_quote)
          {
            while ('{' == m_input.m_line[m_input.m_line_index])
              {
                expandMacro();

                /* End of line buffer? */
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line signifies the end of 
                       the current regular expression. */

                    m_spec.m_current_token = EOS;
                    m_spec.m_lexeme = '\0';
                    return m_spec.m_current_token;
                  }
              }
          }
            
        /*if (m_input.m_line_index) {
          System.out.println("**********2");
          System.out.println("m_spec.m_in_quote = " + m_spec.m_in_quote);
        }*/

        /*System.out.println("m_spec.m_in_quote = " + m_spec.m_in_quote);
        System.out.println("m_input.m_line_index = " + m_input.m_line_index);
        System.out.println("m_input.m_line_read = " + m_input.m_line_read);*/
        
        /* Look for quotation mark. */
        /* REMOVED */
        /*if ('\"' == m_input.m_line[m_input.m_line_index])*/
        /* REMOVED */
        /* ADDED */
        while ('\"' == m_input.m_line[m_input.m_line_index])
        /* ADDED */
          {
            /* Toggle in-quote status. */
            if (true == m_spec.m_in_quote)
              {
                m_spec.m_in_quote = false;
              }
            else
              {
                m_spec.m_in_quote = true;
              }
            /* ADDED */
            ++m_input.m_line_index;
            /* ADDED */

            if (m_input.m_line_index >= m_input.m_line_read)
              {
                /* End of line signifies the end of 
                   the current regular expression. */

                m_spec.m_current_token = EOS;
                m_spec.m_lexeme = '\0';
                return m_spec.m_current_token;
              }
          }

        if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          INAhxAQiZ.assert(m_input.m_line_index <= m_input.m_line_read);
        }

        /* Look for backslash, and corresponding 
           escape sequence. */
        if ('\\' == m_input.m_line[m_input.m_line_index])
          {
            saw_escape = true;
          }
        else
          {
            saw_escape = false;
          }

        if (false == m_spec.m_in_quote)
          {
            if (INAhxAQiZ.isspace(m_input.m_line[m_input.m_line_index]))
              {
                /* White space means the end of 
                   the current regular expression. */

                m_spec.m_current_token = EOS;
                m_spec.m_lexeme = '\0';
                return m_spec.m_current_token;
              }

            /* Process escape sequence, if needed. */
            if (true == saw_escape)
              {
                m_spec.m_lexeme = expandEscape();
              }
            else
              {
                m_spec.m_lexeme = m_input.m_line[m_input.m_line_index];
                ++m_input.m_line_index;
              }
          }
        else
          {
            if (true == saw_escape 
                && (m_input.m_line_index + 1) < m_input.m_line_read
                && '\"' == m_input.m_line[m_input.m_line_index + 1])
              {
                m_spec.m_lexeme = '\"';
                m_input.m_line_index = m_input.m_line_index + 2;
              }
            else
              {
                m_spec.m_lexeme = m_input.m_line[m_input.m_line_index];
                ++m_input.m_line_index;
              }
          }
        
        code = (Integer) m_tokens.get(new Character(m_spec.m_lexeme));
        if (true == m_spec.m_in_quote || true == saw_escape)
          {
            m_spec.m_current_token = L;
          }
        else
          {
            if (null == code)
              {
                m_spec.m_current_token = L;
              }
            else
              {
                m_spec.m_current_token = code.intValue();
              }
          }

        if (INAhxAQiZ.FOODEBUG)
          {
            System.out.println("Lexeme: " + m_spec.m_lexeme
                               + "\tToken: " + m_spec.m_current_token
                               + "\tIndex: " + m_input.m_line_index);
          }

        return m_spec.m_current_token;
      }

  /***************************************************************
    Function: details
    Description: High level debugging routine.
    **************************************************************/
  private void details
    (
     )
      {
        Enumeration names;
        String name;
        String def;
        Enumeration states;
        String state;
        Integer index;
        int elem;
        int size;

        System.out.println("\n\t** Macros **");
        names = m_spec.m_macros.keys();
        while (true == names.hasMoreElements())
          {
            name = (String) names.nextElement();
            def = (String) m_spec.m_macros.get(name);

            if (INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(null != name);
                INAhxAQiZ.assert(null != def);
              }

            System.out.println("Macro name \"" + name 
                               + "\" has definition \"" 
                               + def + "\".");
          }

        System.out.println("\n\t** States **");
        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(null != state);
                INAhxAQiZ.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");
          }
            
        System.out.println("\n\t** Character Counting **");
        if (false == m_spec.m_count_chars)
          {
            System.out.println("Character counting is off.");
          }
        else
          {
            if (INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(true == m_spec.m_count_lines);
              }

            System.out.println("Character counting is on.");
          }

        System.out.println("\n\t** Line Counting **");
        if (false == m_spec.m_count_lines)
          {
            System.out.println("Line counting is off.");
          }
        else
          {
            if (INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(true == m_spec.m_count_lines);
              }

            System.out.println("Line counting is on.");
          }

        System.out.println("\n\t** Operating System Specificity **");
        if (false == m_spec.m_unix)
          {
            System.out.println("Not generating UNIX-specific code.");
            System.out.println("(This means that \"\\r\\n\" is a "
                               + "newline, rather than \"\\n\".)");
          }
        else
          {
            System.out.println("Generating UNIX-specific code.");
            System.out.println("(This means that \"\\n\" is a " 
                               + "newline, rather than \"\\r\\n\".)");
          }

        System.out.println("\n\t** Java CUP Compatibility **");
        if (false == m_spec.m_cup_compatible)
          {
            System.out.println("Generating CUP compatible code.");
            System.out.println("(No current results.)");
          }
        else
          {
            System.out.println("Not generating CUP compatible code.");
            System.out.println("(No current results.)");
          }
        
        if (INAhxAQiZ.FOODEBUG) {
          if (null != m_spec.m_nfa_states && null != m_spec.m_nfa_start)
            {
              System.out.println("\n\t** NFA machine **");
              print_nfa();
          }
        }

        if (null != m_spec.m_dtrans_vector)
          {
            System.out.println("\n\t** DFA transition table **");
            /*print_header();*/
          }

        /*if (null != m_spec.m_accept_vector && null != m_spec.m_anchor_array)
          {
            System.out.println("\n\t** Accept States and Anchor Vector **");
            print_accept();
          }*/
      }

  /***************************************************************
    function: print_set
    **************************************************************/
  void print_set
    (
     Vector nfa_set
     )
      {
        int size; 
        int elem;
        layAuDXcf nfa;

        size = nfa_set.size();

        if (0 == size)
          {
            System.out.print("empty ");
          }
        
        for (elem = 0; elem < size; ++elem)
          {
            nfa = (layAuDXcf) nfa_set.elementAt(elem);
            /*System.out.print(m_spec.m_nfa_states.indexOf(nfa) + " ");*/
            System.out.print(nfa.m_label + " ");
          }
      }

   /***************************************************************
     Function: print_header
     **************************************************************/
  private void print_header
    (
     )
      {
        Enumeration states;
        int i;
        int j;
        int chars_printed = 0;
        uQFetIDnd dtrans;
        int last_transition;
        String str;
        xAYJWnUkN accept;
        String state;
        Integer index;

        System.out.println("/*---------------------- DFA -----------------------");
        
        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (INAhxAQiZ.DEBUG)
              {
                INAhxAQiZ.assert(null != state);
                INAhxAQiZ.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");

            i = index.intValue();
            if (uQFetIDnd.F != m_spec.m_state_dtrans[i])
              {
                System.out.println("\tStart index in transition table: "
                                   + m_spec.m_state_dtrans[i]);
              }
            else
              {
                System.out.println("\tNo associated transition states.");
              }
          }

        for (i = 0; i < m_spec.m_dtrans_vector.size(); ++i)
          {
            dtrans = (uQFetIDnd) m_spec.m_dtrans_vector.elementAt(i);

            if (null == m_spec.m_accept_vector && null == m_spec.m_anchor_array)
              {
                if (null == dtrans.m_accept)
                  {
                    System.out.print(" * State " + i + " [nonaccepting]");
                  }
                else
                  {
                    System.out.print(" * State " + i 
                                     + " [accepting, line "
                                     + dtrans.m_accept.m_line_number 
                                     + " <"
                                     + (new String(dtrans.m_accept.m_action,0,
                                                   dtrans.m_accept.m_action_read))
                                     + ">]");
                    if (aYvbfLVVU.NONE != dtrans.m_anchor)
                      {
                        System.out.print(" Anchor: "
                                         + ((0 != (dtrans.m_anchor & aYvbfLVVU.START)) 
                                            ? "start " : "")
                                         + ((0 != (dtrans.m_anchor & aYvbfLVVU.END)) 
                                            ? "end " : ""));
                      }
                  }
              }
            else
              {
                accept = (xAYJWnUkN) m_spec.m_accept_vector.elementAt(i);

                if (null == accept)
                  {
                    System.out.print(" * State " + i + " [nonaccepting]");
                  }
                else
                  {
                    System.out.print(" * State " + i 
                                     + " [accepting, line "
                                     + accept.m_line_number 
                                     + " <"
                                     + (new String(accept.m_action,0,
                                                   accept.m_action_read))
                                     + ">]");
                    if (aYvbfLVVU.NONE != m_spec.m_anchor_array[i])
                      {
                        System.out.print(" Anchor: "
                                         + ((0 != (m_spec.m_anchor_array[i] & aYvbfLVVU.START)) 
                                            ? "start " : "")
                                         + ((0 != (m_spec.m_anchor_array[i] & aYvbfLVVU.END)) 
                                            ? "end " : ""));
                      }
                  }
              }

            last_transition = -1;
            for (j = 0; j < m_spec.m_dtrans_ncols; ++j)
              {
                if (uQFetIDnd.F != dtrans.m_dtrans[j])
                  {
                    if (last_transition != dtrans.m_dtrans[j])
                      {
                        System.out.print("\n *    goto " + dtrans.m_dtrans[j]
                                         + " on ");
                        chars_printed = 0;
                      }
                    
                    str = interp_int((int) j);
                    System.out.print(str);
                                
                    chars_printed = chars_printed + str.length(); 
                    if (56 < chars_printed)
                      {
                        System.out.print("\n *             ");
                        chars_printed = 0;
                      }
                    
                    last_transition = dtrans.m_dtrans[j];
                  }
              }
            System.out.println("");
          }
        System.out.println(" */\n");
      }
}

/************************************************************************
  JAVA-LEX COPYRIGHT NOTICE, LICENSE AND DISCLAIMER.
  
  Copyright 1996 by Elliot Joel Berk
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both the copyright notice and this permission notice and warranty
  disclaimer appear in supporting documentation, and that the name of
  Elliot Joel Berk not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.
  
  Elliot Joel Berk disclaims all warranties with regard to this software, 
  including all implied warranties of merchantability and fitness.  In no event
  shall Elliot Joel Berk be liable for any special, indirect or consequential
  damages or any damages whatsoever resulting from loss of use, data or
  profits, whether in an action of contract, negligence or other
  tortious action, arising out of or in connection with the use or
  performance of this software.
  ***********************************************************************/




/**************************************************************
  Java-Lex: A Lexical Analyzer Generator for Java
  Written by Elliot Berk. Copyright 1996.
  Contact at ejberk@princeton.edu.

  Modified N.Shaylor
  08-Sep-96 - Change yy_lookahead, yy_advance(), and YYEOF to be int.
            - Zero yy_char_count every '\n'.
            - Put in a package and define all classes final.
            - Use nshaylor.util.BitSet that checks for the grow
              bug in JDK 1.0.

  07-Oct-96 - Add  yy_getcharArray();

  11-Oct-96 - Use nshaylor.jlx.BitSet that checks for the grow
  
  07-Nov-96 - Make yy_nxt, yy_rmap, yy_cmap, and yy_acpt short arrays
            - Make all constants like YYEOF static

  08-Nov-96 - Change yy_acpt, yy_this_accept, YY_NOT_ACCEPT, and
            - YY_NO_ANCHOR to byte

  11-Nov-96 - Use BufferedOutputStreams to spead things up?
            - Make all final variables static.

  17-Feb-97 - Remove BufferedOutputStreams. Somehow this causes a
              problem and the end of the output file is truncated.
              I don't have the time now to find out why, so we go back
              to the old slow way that works.

  *************************************************************/

/***************************************************************
  Package Declaration
  **************************************************************/
/* UNDONE: Uncomment this. */


/***************************************************************
  Imported Packages
  **************************************************************/



/******************************
  Questions:
  2) How should I use the Java package system
  to make my tool more modularized and
  coherent?

  Unimplemented:
  !) Fix BitSet issues -- expand only when necessary.
  2) Repeated accept rules.
  6) Clean up the FdipEadqR class and use buffered
  allocation.
  7) Reading and writing in Unicode.
  Use DataInputStream and DataOutputStream,
  along with writeUTF???
  8) Fix or at least annotate ^x bug.
  9) Add to spec about extending character set.
  10) making sure newlines are handled correctly
  and consistly with the m_unix flag
  11) m_verbose -- what should be done with it?
  12) turn lexical analyzer into a coherent
  Java package
  13) turn lexical analyzer generator into a
  coherent Java package
  16) pretty up generated code
  17) make it possible to have white space in
  regular expressions
  18) clean up all of the class files the lexer
  generator produces when it is compiled,
  and reduce this number in some way.
  24) character format to and from file: writeup
  and implementation
  25) Debug by testing all arcane regular expression cases.
  26) Look for and fix all UNDONE comments below.
  27) Fix package system.
  28) Clean up unnecessary classes.
  *****************************/

/***************************************************************
  Class: drHChFQzb
 **************************************************************/
final class drHChFQzb //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
    
  /* Lexical States. */
  Hashtable m_states; /* Hashtable taking state indices (Integer) 
                         to state name (String). */

  /* Regular Expression Macros. */ 
  Hashtable m_macros; /* Hashtable taking macro name (String)
                                to corresponding char buffer that
                                holds macro definition. */

  /* NFA Machine. */
  CkBxcepSH m_nfa_start; /* Start state of NFA machine. */
  Vector m_nfa_states; /* Vector of states, with index
                                 corresponding to label. */
  
  Vector m_state_rules[]; /* An array of Vectors of Integers.
                                    The ith Vector represents the lexical state
                                    with index i.  The contents of the ith 
                                    Vector are the indices of the NFA start
                                    states that can be matched while in
                                    the ith lexical state. */
                                    

  int m_state_dtrans[];

  /* DFA Machine. */
  Vector m_dfa_states; /* Vector of states, with index
                                 corresponding to label. */
  Hashtable m_dfa_sets; /* Hashtable taking set of NFA states
                                  to corresponding DFA state, 
                                  if the latter exists. */
  
  /* Accept States and Corresponding Anchors. */
  Vector m_accept_vector;
  int m_anchor_array[];

  /* Transition Table. */
  Vector m_dtrans_vector;
  int m_dtrans_ncols;
  int m_row_map[];
  int m_col_map[];

  /* Regular expression token variables. */
  int m_current_token;
  char m_lexeme;
  boolean m_in_quote;

  /* Verbose execturion flag. */
  boolean m_verbose;

  /* Java-Lex directives flags. */
  boolean m_integer_type;
  boolean m_intwrap_type;
  boolean m_yyeof;
  boolean m_count_chars;
  boolean m_count_lines;
  boolean m_cup_compatible;
  boolean m_unix;

  char m_init_code[];
  int m_init_read;

  char m_init_throw_code[];
  int m_init_throw_read;

  char m_class_code[];
  int m_class_read;

  char m_eof_code[];
  int m_eof_read;

  char m_eof_value_code[];
  int m_eof_value_read;

  char m_eof_throw_code[];
  int m_eof_throw_read;

  char m_yylex_throw_code[];
  int m_yylex_throw_read;

  /* Class, function, type names. */
  char m_class_name[] = {          
    'Y', 'y', 'l', 
    'e', 'x' 
    };
  char m_function_name[] = {
    'y', 'y', 'l', 
    'e', 'x' 
    };
  char m_type_name[] = {
    'Y', 'y', 't', 
    'o', 'k', 'e',
    'n'
    };

  /* Lexical Generator. */
  private EpinONEnm m_lexGen;

  /***************************************************************
    Constants
    ***********************************************************/
  static final int NONE = 0;
  static final int START = 1;
  static final int END = 2;
  
  /***************************************************************
    Function: drHChFQzb
    Description: Constructor.
    **************************************************************/
  drHChFQzb
    (
     EpinONEnm lexGen
     )
      {
        m_lexGen = lexGen;

        /* Initialize regular expression token variables. */
        m_current_token = m_lexGen.EOS;
        m_lexeme = '\0';
        m_in_quote = false;

        /* Initialize hashtable for lexer states. */
        m_states = new Hashtable();
        m_states.put(new String("YYINITIAL"),new Integer(m_states.size()));

        /* Initialize hashtable for lexical macros. */
        m_macros = new Hashtable();

        /* Initialize variables for lexer options. */
        m_integer_type = false;
        m_intwrap_type = false;
        m_count_lines = false;
        m_count_chars = false;
        m_cup_compatible = false;
        m_unix = true;
        m_yyeof = false;

        /* Initialize variables for Java-Lex runtime options. */
        m_verbose = true;

        m_nfa_start = null;
        m_nfa_states = new Vector();
        
        m_dfa_states = new Vector();
        m_dfa_sets = new Hashtable();

        m_dtrans_vector = new Vector();
        m_dtrans_ncols = FOVOvCcFg.MAX_SEVEN_BIT + 1;
        m_row_map = null;
        m_col_map = null;

        m_accept_vector = null;
        m_anchor_array = null;

        m_init_code = null;
        m_init_read = 0;

        m_init_throw_code = null;
        m_init_throw_read = 0;

        m_yylex_throw_code = null;
        m_yylex_throw_read = 0;

        m_class_code = null;
        m_class_read = 0;

        m_eof_code = null;
        m_eof_read = 0;

        m_eof_value_code = null;
        m_eof_value_read = 0;

        m_eof_throw_code = null;
        m_eof_throw_read = 0;

        m_state_dtrans = null;

        m_state_rules = null;
      }
}

/***************************************************************
  Class: nZFWRApBo
  **************************************************************/
final class nZFWRApBo //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private drHChFQzb m_spec;
  private DataOutputStream m_outstream;

  /***************************************************************
    Constants: Anchor Types
    **************************************************************/
  private final int START = 1;
  private final int END = 2;
  private final int NONE = 4;

  /***************************************************************
    Constants
    **************************************************************/
  private final boolean EDBG = true;
  private final boolean NOT_EDBG = false;

  /***************************************************************
    Function: nZFWRApBo
    Description: Constructor.
    **************************************************************/
  nZFWRApBo
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: reset
    Description: Clears member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_spec = null;
        m_outstream = null;
      }

  /***************************************************************
    Function: set
    Description: Initializes member variables.
    **************************************************************/
  private void set
    (
     drHChFQzb spec,
     OutputStream outstream
     )
      {
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != spec);
            FOVOvCcFg.assert(null != outstream);
          }

        m_spec = spec;
        m_outstream = new DataOutputStream(
                        /*new BufferedOutputStream(*/ outstream /*)*/ ); //**NS**
      }

  /***************************************************************
    Function: emit_imports
    Description: Emits import packages at top of 
    generated source file.
    **************************************************************/
  /*void emit_imports
    (
     drHChFQzb spec,
     OutputStream outstream
     )
      throws java.io.IOException      
        {
          set(spec,outstream);
          
          if (FOVOvCcFg.DEBUG)
            {
              FOVOvCcFg.assert(null != m_spec);
              FOVOvCcFg.assert(null != m_outstream);
            }*/
          
          /*m_outstream.writeBytes("import java.lang.String;\n");
          m_outstream.writeBytes("import java.lang.System;\n");
          m_outstream.writeBytes("import java.io.DataInputStream;\n");
          m_outstream.writeBytes("import java.io.InputStream;\n");*/
        /*  
          reset();
        }*/
  
  /***************************************************************
    Function: print_details
    Description: Debugging output.
    **************************************************************/
  private void print_details
    (
     )
      {
        int i;
        int j;
        int next;
        int state;
        fhTZXkZqS dtrans;
        IRxqsITZU accept;
        boolean tr;

        System.out.println("---------------------- Transition Table " 
                           + "----------------------");
        
        for (i = 0; i < m_spec.m_row_map.length; ++i)
          {
            System.out.print("State " + i);
            
            accept = (IRxqsITZU) m_spec.m_accept_vector.elementAt(i);
            if (null == accept)
              {
                System.out.println(" [nonaccepting]");
              }
            else
              {
                System.out.println(" [accepting, line "
                                 + accept.m_line_number 
                                 + " <"
                                 + (new java.lang.String(accept.m_action,0,
                                               accept.m_action_read))
                                 + ">]");
              }
            dtrans = (fhTZXkZqS) m_spec.m_dtrans_vector.elementAt(m_spec.m_row_map[i]);
            
            tr = false;
            state = dtrans.m_dtrans[m_spec.m_col_map[0]];
            if (fhTZXkZqS.F != state)
              {
                tr = true;
                System.out.print("\tgoto " + state + " on [" + ((char) 0));
              }
            for (j = 1; j < m_spec.m_dtrans_ncols; ++j)
              {
                next = dtrans.m_dtrans[m_spec.m_col_map[j]];
                if (state == next)
                  {
                    if (fhTZXkZqS.F != state)
                      {
                        System.out.print((char) j);
                      }
                  }
                else
                  {
                    state = next;
                    if (true == tr)
                      {
                        System.out.println("]");
                        tr = false;
                      }
                    if (fhTZXkZqS.F != state)
                      {
                        tr = true;
                        System.out.print("\tgoto " + state + " on [" + ((char) j));
                      }
                  }
              }
            if (true == tr)
              {
                System.out.println("]");
              }
          }

        System.out.println("---------------------- Transition Table " 
                           + "----------------------");
      }

  /***************************************************************
    Function: emit
    Description: High-level access function to module.
    **************************************************************/
  void emit
    (
     drHChFQzb spec,
     OutputStream outstream
     )
      throws java.io.IOException      
        {
          set(spec,outstream);
          
          if (FOVOvCcFg.DEBUG)
            {
              FOVOvCcFg.assert(null != m_spec);
              FOVOvCcFg.assert(null != m_outstream);
            }
          
          if (FOVOvCcFg.OLD_DEBUG) {
            print_details();
          }

          emit_header();
          emit_construct();
          emit_helpers();
          emit_driver();
          emit_footer();
          
          reset();
        }

  /***************************************************************
    Function: emit_construct
    Description: Emits constructor, member variables,
    and constants.
    **************************************************************/
  private void emit_construct
    (
     )
      throws java.io.IOException
        {
          if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != m_spec);
            FOVOvCcFg.assert(null != m_outstream);
          }
          
          /* Constants */
          m_outstream.writeBytes("\tprivate static final int YY_BUFFER_SIZE = 512;\n");  //**NS**

          m_outstream.writeBytes("\tprivate static final int YY_F = -1;\n");             //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_NO_STATE = -1;\n");      //**NS**

          m_outstream.writeBytes("\tprivate static final byte YY_NOT_ACCEPT = 0;\n");     //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_START = 1;\n");          //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_END = 2;\n");            //**NS**
          m_outstream.writeBytes("\tprivate static final byte YY_NO_ANCHOR = 4;\n");      //**NS**

          m_outstream.writeBytes("\tpublic static final int YYEOF = -1;\n");             //**NS**
          
          /* User specified class code. */
          if (null != m_spec.m_class_code)
            {
              m_outstream.writeBytes(new String(m_spec.m_class_code,0,
                                                m_spec.m_class_read));
            }

          /* Member Variables */
          m_outstream.writeBytes("\tprivate java.io.DataInputStream yy_instream;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_index;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_read;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_start;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_end;\n");
          m_outstream.writeBytes("\tprivate byte yy_buffer[];\n");
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\tprivate int yy_char_count;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\tprivate int yy_line_count;\n");
            }
          m_outstream.writeBytes("\tprivate int yy_lexical_state;\n");
          /*if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\tprivate int yy_buffer_prev_start;\n");
            }*/
          
          /* Function: constructor */
          m_outstream.writeBytes("\t");
          m_outstream.writeBytes(new String(m_spec.m_class_name));
          m_outstream.writeBytes(" (java.io.InputStream instream)");
          
          if (null != m_spec.m_init_throw_code)
            {
              m_outstream.writeBytes("\n"); 
              m_outstream.writeBytes("\t\tthrows "); 
              m_outstream.writeBytes(new String(m_spec.m_init_throw_code,0,
                                                m_spec.m_init_throw_read));
              m_outstream.writeBytes("\n\t\t{\n");
            }
          else
            {
              m_outstream.writeBytes(" {\n");
            }
          
          m_outstream.writeBytes("\t\tif (null == instream) {\n");
          m_outstream.writeBytes("\t\t\tthrow (new Error(\"Error: Bad input "
                                 + "stream initializer.\"));\n");
          m_outstream.writeBytes("\t\t}\n");
          m_outstream.writeBytes("\t\tyy_instream = new java.io.DataInputStream(instream);\n");
          m_outstream.writeBytes("\t\tyy_buffer = new byte[YY_BUFFER_SIZE];\n");
          m_outstream.writeBytes("\t\tyy_buffer_read = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_index = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_start = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_end = 0;\n");
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tyy_char_count = 0;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\tyy_line_count = 0;\n");
            }
          m_outstream.writeBytes("\t\tyy_lexical_state = YYINITIAL;\n");
          /*if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tyy_buffer_prev_start = 0;\n");
            }*/

          /* User specified constructor code. */
          if (null != m_spec.m_init_code)
            {
              m_outstream.writeBytes(new String(m_spec.m_init_code,0,
                                                m_spec.m_init_read));
            }

          m_outstream.writeBytes("\t}\n");
        }

  /***************************************************************
    Function: emit_states
    Description: Emits constants that serve as lexical states,
    including YYINITIAL.
    **************************************************************/
  private void emit_states
    (
     )
      throws java.io.IOException
        {
          Enumeration states;
          String state;
          int index;

          states = m_spec.m_states.keys();
          /*index = 0;*/
          while (true == states.hasMoreElements())
            {
              state = (String) states.nextElement();
              
              if (FOVOvCcFg.DEBUG)
                {
                  FOVOvCcFg.assert(null != state);
                }
              
              m_outstream.writeBytes("\tprivate final int " 
                                     + state 
                                     + " = " 
                                     + (m_spec.m_states.get(state)).toString() 
                                     + ";\n");
              /*++index;*/
            }

          m_outstream.writeBytes("\tprivate final int yy_state_dtrans[] = {\n");
          for (index = 0; index < m_spec.m_state_dtrans.length; ++index)
            {
              m_outstream.writeBytes("\t\t" + m_spec.m_state_dtrans[index]);
              if (index < m_spec.m_state_dtrans.length - 1)
                {
                  m_outstream.writeBytes(",\n");
                }
              else
                {
                  m_outstream.writeBytes("\n");
                }
            }
          m_outstream.writeBytes("\t};\n");
        }

  /***************************************************************
    Function: emit_helpers
    Description: Emits helper functions, particularly 
    error handling and input buffering.
    **************************************************************/
  private void emit_helpers
    (
     )
      throws java.io.IOException
      {
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != m_spec);
            FOVOvCcFg.assert(null != m_outstream);
          }

        /* Function: yy_do_eof */
        m_outstream.writeBytes("\tprivate boolean yy_eof_done = false;\n");
        if (null != m_spec.m_eof_code)
          {
            m_outstream.writeBytes("\tprivate void yy_do_eof ()");

            if (null != m_spec.m_eof_throw_code)
              {
                m_outstream.writeBytes("\n"); 
                m_outstream.writeBytes("\t\tthrows "); 
                m_outstream.writeBytes(new String(m_spec.m_eof_throw_code,0,
                                                  m_spec.m_eof_throw_read));
                m_outstream.writeBytes("\n\t\t{\n");
              }
            else
              {
                m_outstream.writeBytes(" {\n");
              }

            m_outstream.writeBytes("\t\tif (false == yy_eof_done) {\n");
            m_outstream.writeBytes(new String(m_spec.m_eof_code,0,
                                              m_spec.m_eof_read));
            m_outstream.writeBytes("\t\t}\n");
            m_outstream.writeBytes("\t\tyy_eof_done = true;\n");
            m_outstream.writeBytes("\t}\n");
          }

        emit_states();
        
        /* Function: yybegin */
        m_outstream.writeBytes("\tprivate void yybegin (int state) {\n");
        m_outstream.writeBytes("\t\tyy_lexical_state = state;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_initial_dtrans */
        /*m_outstream.writeBytes("\tprivate int yy_initial_dtrans (int state) {\n");
        m_outstream.writeBytes("\t\treturn yy_state_dtrans[state];\n");
        m_outstream.writeBytes("\t}\n");*/

        /* Function: yy_advance */
        m_outstream.writeBytes("\tprivate int yy_advance ()\n"); //**NS**
        m_outstream.writeBytes("\t\tthrows java.io.IOException {\n");
        /*m_outstream.writeBytes("\t\t{\n");*/
        m_outstream.writeBytes("\t\tint next_read;\n");
        m_outstream.writeBytes("\t\tint i;\n");
        m_outstream.writeBytes("\t\tint j;\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\tif (yy_buffer_index < yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\treturn yy_buffer[yy_buffer_index++] & 0xFF;\n"); //**NS**
        /*m_outstream.writeBytes("\t\t\t++yy_buffer_index;\n");*/
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\tif (0 != yy_buffer_start) {\n");
        m_outstream.writeBytes("\t\t\ti = yy_buffer_start;\n");
        m_outstream.writeBytes("\t\t\tj = 0;\n");
        m_outstream.writeBytes("\t\t\twhile (i < yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\t\tyy_buffer[j] = yy_buffer[i];\n");
        m_outstream.writeBytes("\t\t\t\t++i;\n");
        m_outstream.writeBytes("\t\t\t\t++j;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_end = yy_buffer_end - yy_buffer_start;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_start = 0;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = j;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_index = j;\n");
        m_outstream.writeBytes("\t\t\tnext_read = yy_instream.read(yy_buffer,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        m_outstream.writeBytes("\t\t\t\treturn YYEOF;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\twhile (yy_buffer_index >= yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\tif (yy_buffer_index >= yy_buffer.length) {\n");
        m_outstream.writeBytes("\t\t\t\tyy_buffer = yy_double(yy_buffer);\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tnext_read = yy_instream.read(yy_buffer,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        m_outstream.writeBytes("\t\t\t\treturn YYEOF;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        m_outstream.writeBytes("\t\t}\n");

        m_outstream.writeBytes("\t\treturn yy_buffer[yy_buffer_index++] & 0xFF;\n"); //**NS**
        m_outstream.writeBytes("\t}\n");
        
        /* Function: yy_move_start */
        m_outstream.writeBytes("\tprivate void yy_move_start () {\n");
        if (true == m_spec.m_count_lines)
          {
            if (true == m_spec.m_unix)
              {
                m_outstream.writeBytes("\t\tif ((byte) '\\n' " 
                                       + "== yy_buffer[yy_buffer_start]) {\n");
              }
            else
              {         
                m_outstream.writeBytes("\t\tif ((byte) '\\n' " 
                                       + "== yy_buffer[yy_buffer_start]\n"); 
                m_outstream.writeBytes("\t\t\t|| (byte) '\\r' " 
                                       + "== yy_buffer[yy_buffer_start]) {\n");
              }
            m_outstream.writeBytes("\t\t\t++yy_line_count; yy_char_count = 0;\n"); //**NS**
            m_outstream.writeBytes("\t\t}\n");
          }
        if (true == m_spec.m_count_chars)
          {
            m_outstream.writeBytes("\t\t++yy_char_count;\n");
          }
        m_outstream.writeBytes("\t\t++yy_buffer_start;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_pushback */
        m_outstream.writeBytes("\tprivate void yy_pushback () {\n");
        m_outstream.writeBytes("\t\t--yy_buffer_end;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_mark_start */
        m_outstream.writeBytes("\tprivate void yy_mark_start () {\n");
        if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
          {
            if (true == m_spec.m_count_lines)
              {
                m_outstream.writeBytes("\t\tint i;\n");
                m_outstream.writeBytes("\t\tfor (i = yy_buffer_start; " 
                                       + "i < yy_buffer_index; ++i) {\n");
                if (true == m_spec.m_unix)
                  {
                    m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i]) {\n");
                  }
                else
                  {             
                    m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i] || " 
                                           + "(byte) '\\r' == yy_buffer[i]) {\n");
                  }
                m_outstream.writeBytes("\t\t\t\t++yy_line_count;  yy_char_count = 0;\n"); //**NS**
                m_outstream.writeBytes("\t\t\t}\n");
                m_outstream.writeBytes("\t\t++yy_char_count;\n"); //**NS**               
                m_outstream.writeBytes("\t\t}\n");
              }
            if (true == m_spec.m_count_chars)
              {
//**NS**                m_outstream.writeBytes("\t\tyy_char_count = yy_char_count\n"); 
//**NS**                m_outstream.writeBytes("\t\t\t+ yy_buffer_index - yy_buffer_start;\n");
              }
          }
        m_outstream.writeBytes("\t\tyy_buffer_start = yy_buffer_index;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_mark_end */
        m_outstream.writeBytes("\tprivate void yy_mark_end () {\n");
        m_outstream.writeBytes("\t\tyy_buffer_end = yy_buffer_index;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_to_mark */
        m_outstream.writeBytes("\tprivate void yy_to_mark () {\n");
        m_outstream.writeBytes("\t\tyy_buffer_index = yy_buffer_end;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_gettext */
        m_outstream.writeBytes("\tprivate java.lang.String yy_gettext () {\n");
        m_outstream.writeBytes("\t\treturn (new java.lang.String(yy_buffer,0,\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_start,\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_end - yy_buffer_start));\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_getcharArray */
        m_outstream.writeBytes("private char[] yy_getcharArray()\n"); 
        m_outstream.writeBytes("\t{\n");  	
        m_outstream.writeBytes("\tint  count   = yy_buffer_end - yy_buffer_start;\n");
        m_outstream.writeBytes("\tchar value[] = new char[count];\n");
        m_outstream.writeBytes("\tfor( int i = count ; i-- > 0 ; )\n");
        m_outstream.writeBytes("\t\tvalue[i] = (char) (yy_buffer[i + yy_buffer_start] & 0xff);\n");
        m_outstream.writeBytes("\treturn value;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_getchar */
        if (true == m_spec.m_count_chars)
          {
            m_outstream.writeBytes("\tprivate int yy_getchar () {\n");
            m_outstream.writeBytes("\t\treturn yy_char_count;\n");
            m_outstream.writeBytes("\t}\n");
          }

        /* Function: yy_getline */
        if (true == m_spec.m_count_lines)
          {
            m_outstream.writeBytes("\tprivate int yy_getline () {\n");
            m_outstream.writeBytes("\t\treturn yy_line_count;\n");
            m_outstream.writeBytes("\t}\n");
          }

        /* Function: yy_double */
        m_outstream.writeBytes("\tprivate byte[] yy_double (byte buf[]) {\n");
        m_outstream.writeBytes("\t\tint i;\n\t\tbyte newbuf[];\n");
        m_outstream.writeBytes("\t\tnewbuf = new byte[2*buf.length];\n");
        m_outstream.writeBytes("\t\tfor (i = 0; i < buf.length; ++i) {\n");
        m_outstream.writeBytes("\t\t\tnewbuf[i] = buf[i];\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\t\treturn newbuf;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_error */
        m_outstream.writeBytes("\tprivate final int YY_E_INTERNAL = 0;\n");
        m_outstream.writeBytes("\tprivate final int YY_E_MATCH = 1;\n");
        m_outstream.writeBytes("\tprivate java.lang.String yy_error_string[] = {\n");
        m_outstream.writeBytes("\t\t\"Error: Internal error.\\n\",\n");
        m_outstream.writeBytes("\t\t\"Error: Unmatched input.\\n\"\n");
        m_outstream.writeBytes("\t};\n");
        m_outstream.writeBytes("\tprivate void yy_error (int code,boolean fatal) {\n");
        m_outstream.writeBytes("\t\tjava.lang.System.out.print(yy_error_string[code]);\n");
        m_outstream.writeBytes("\t\tjava.lang.System.out.flush();\n");
        m_outstream.writeBytes("\t\tif (true == fatal) {\n");
        m_outstream.writeBytes("\t\t\tthrow new Error(\"Fatal Error.\\n\");\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_next */
        /*m_outstream.writeBytes("\tprivate int yy_next (int current,byte lookahead) {\n");
        m_outstream.writeBytes("\t\treturn yy_nxt[yy_rmap[current]][yy_cmap[lookahead]];\n");
        m_outstream.writeBytes("\t}\n");*/

        /* Function: yy_accept */
        /*m_outstream.writeBytes("\tprivate int yy_accept (int current) {\n");
        m_outstream.writeBytes("\t\treturn yy_acpt[current];\n");
        m_outstream.writeBytes("\t}\n");*/
      }

  /***************************************************************
    Function: emit_header
    Description: Emits class header.
    **************************************************************/
  private void emit_header
    (
     )
      throws java.io.IOException
      {
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != m_spec);
            FOVOvCcFg.assert(null != m_outstream);
          }

        m_outstream.writeBytes("\n\nclass ");
        m_outstream.writeBytes(new String(m_spec.m_class_name,0,
                                          m_spec.m_class_name.length));
        m_outstream.writeBytes(" {\n");
      }

  /***************************************************************
    Function: emit_table
    Description: Emits transition table.
    **************************************************************/
  private void emit_table
    (
     )
      throws java.io.IOException
      {
        int i;
        int elem;
        int size;
        fhTZXkZqS dtrans;
        boolean is_start;
        boolean is_end;
        IRxqsITZU accept;

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != m_spec);
            FOVOvCcFg.assert(null != m_outstream);
          }

        m_outstream.writeBytes("\tprivate byte yy_acpt[] = {\n");  //**NS**
        size = m_spec.m_accept_vector.size();
        for (elem = 0; elem < size; ++elem)
          {
            accept = (IRxqsITZU) m_spec.m_accept_vector.elementAt(elem);
            
            if (null != accept)
              {
                is_start = (0 != (m_spec.m_anchor_array[elem] & drHChFQzb.START));
                is_end = (0 != (m_spec.m_anchor_array[elem] & drHChFQzb.END));
                
                if (true == is_start && true == is_end)
                  {
                    m_outstream.writeBytes("\t\tYY_START | YY_END");
                  }
                else if (true == is_start)
                  {
                    m_outstream.writeBytes("\t\tYY_START");
                  }
                else if (true == is_end)
                  {
                    m_outstream.writeBytes("\t\tYY_END");
                  }
                else
                  {
                    m_outstream.writeBytes("\t\tYY_NO_ANCHOR");
                  }
              }
            else 
              {
                m_outstream.writeBytes("\t\tYY_NOT_ACCEPT");
              }
            
            if (elem < size - 1)
              {
                m_outstream.writeBytes(",");
              }
            
            m_outstream.writeBytes("\n");
          }
        m_outstream.writeBytes("\t};\n");

        m_outstream.writeBytes("\tprivate short yy_cmap[] = {\n\t\t");  //**NS**
        for (i = 0; i < m_spec.m_col_map.length; ++i)
          {
            m_outstream.writeBytes((new Integer(m_spec.m_col_map[i])).toString());
            
            if (i < m_spec.m_col_map.length - 1)
              {
                m_outstream.writeBytes(",");
              }

            if (0 == ((i + 1) % 8))
              {
                m_outstream.writeBytes("\n\t\t");
              }
            else
              {
                m_outstream.writeBytes(" ");
              }
          }
        m_outstream.writeBytes("\n\t};\n");

        m_outstream.writeBytes("\tprivate short yy_rmap[] = {\n\t\t");  //**NS**
        for (i = 0; i < m_spec.m_row_map.length; ++i)
          {
            m_outstream.writeBytes((new Integer(m_spec.m_row_map[i])).toString());
            
            if (i < m_spec.m_row_map.length - 1)
              {
                m_outstream.writeBytes(",");
              }

            if (0 == ((i + 1) % 8))
              {
                m_outstream.writeBytes("\n\t\t");
              }
            else
              {
                m_outstream.writeBytes(" ");
              }
          }
        m_outstream.writeBytes("\n\t};\n");

        m_outstream.writeBytes("\tprivate short yy_nxt[][] = {\n");  //**NS**
        size = m_spec.m_dtrans_vector.size();
        for (elem = 0; elem < size; ++elem)
          {
            dtrans = (fhTZXkZqS) m_spec.m_dtrans_vector.elementAt(elem);
            
            m_outstream.writeBytes("\t\t{ ");
        
            for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
              {
                m_outstream.writeBytes((new Integer(dtrans.m_dtrans[i])).toString());
                
                if (i < m_spec.m_dtrans_ncols - 1)
                  {
                    m_outstream.writeBytes(",");
                  }
                
                if (0 == ((i + 1) % 8))
                  {
                    m_outstream.writeBytes("\n\t\t\t");
                  }
                else
                  {
                    m_outstream.writeBytes(" ");
                  }
              }

            m_outstream.writeBytes("\n\t\t}");

            if (elem < size - 1)
              {
                m_outstream.writeBytes(",");
              }

            m_outstream.writeBytes("\n");
          }
        m_outstream.writeBytes("\t};\n");
      }

  /***************************************************************
    Function: emit_driver
    Description: 
    **************************************************************/
  private void emit_driver
    (
     )
      throws java.io.IOException
        {
          if (FOVOvCcFg.DEBUG)
            {
              FOVOvCcFg.assert(null != m_spec);
              FOVOvCcFg.assert(null != m_outstream);
            }
          
          emit_table();

          if (true == m_spec.m_integer_type)
            {
              m_outstream.writeBytes("\tpublic int ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }
          else if (true == m_spec.m_intwrap_type)
            {
              m_outstream.writeBytes("\tpublic java.lang.Integer ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }
          else
            {
              m_outstream.writeBytes("\tpublic ");
              m_outstream.writeBytes(new String(m_spec.m_type_name));
              m_outstream.writeBytes(" ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }

          /*m_outstream.writeBytes("\t\tthrows java.io.IOException {\n");*/
          m_outstream.writeBytes("\t\tthrows java.io.IOException");
          if (null != m_spec.m_yylex_throw_code)
            {
              m_outstream.writeBytes(", "); 
              m_outstream.writeBytes(new String(m_spec.m_yylex_throw_code,0,
                                                m_spec.m_yylex_throw_read));
              m_outstream.writeBytes("\n\t\t{\n");
            }
          else
            {
              m_outstream.writeBytes(" {\n");
            }

          m_outstream.writeBytes("\t\tint yy_lookahead;\n");
          m_outstream.writeBytes("\t\tint yy_anchor = YY_NO_ANCHOR;\n");
          /*m_outstream.writeBytes("\t\tint yy_state "
            + "= yy_initial_dtrans(yy_lexical_state);\n");*/
          m_outstream.writeBytes("\t\tint yy_state " 
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\tint yy_next_state = YY_NO_STATE;\n");
          /*m_outstream.writeBytes("\t\tint yy_prev_state = YY_NO_STATE;\n");*/
          m_outstream.writeBytes("\t\tint yy_last_accept_state = YY_NO_STATE;\n");
          m_outstream.writeBytes("\t\tboolean yy_initial = true;\n");
          m_outstream.writeBytes("\t\tbyte yy_this_accept;\n"); // **NS**
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tint yychar;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\tint yyline;\n");
            }
          m_outstream.writeBytes("\t\tjava.lang.String yytext;\n");
          m_outstream.writeBytes("\n");

          m_outstream.writeBytes("\t\tyy_mark_start();\n");
          /*m_outstream.writeBytes("\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\tyy_mark_end();\n");
          m_outstream.writeBytes("\t\t}\n");

          if (NOT_EDBG)
            {
              m_outstream.writeBytes("\t\tjava.lang.System.out.println(\"Begin\");\n");
            }

          m_outstream.writeBytes("\t\twhile (true) {\n");

          m_outstream.writeBytes("\t\t\tyy_lookahead = yy_advance();\n");
          m_outstream.writeBytes("\t\t\tyy_next_state = YY_F;\n");
          m_outstream.writeBytes("\t\t\tif (YYEOF != yy_lookahead) {\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_next_state = "
                                 + "yy_next(yy_state,yy_lookahead);\n");*/
          m_outstream.writeBytes("\t\t\t\tyy_next_state = "
                                 + "yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];\n");
          
          m_outstream.writeBytes("\t\t\t}\n");

          if (NOT_EDBG)
            {
              m_outstream.writeBytes("java.lang.System.out.println(\"Current state: \"" 
                                     + " + yy_state\n");
              m_outstream.writeBytes("+ \"\tCurrent input: \"\n"); 
              m_outstream.writeBytes(" + ((char) yy_lookahead));\n");
            }
          if (NOT_EDBG)
            {
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"State = \"" 
                                     + "+ yy_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Accepting status = \"" 
                                     + "+ yy_this_accept);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Last accepting state = \"" 
                                     + "+ yy_last_accept_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Next state = \"" 
                                     + "+ yy_next_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Lookahead input = \"" 
                                     + "+ ((char) yy_lookahead));\n");
            }

          m_outstream.writeBytes("\t\t\tif (YY_F != yy_next_state) {\n");
          m_outstream.writeBytes("\t\t\t\tyy_state = yy_next_state;\n");
          m_outstream.writeBytes("\t\t\t\tyy_initial = false;\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_mark_end();\n");
          m_outstream.writeBytes("\t\t\t\t}\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_prev_state = yy_state;\n");*/
          /*m_outstream.writeBytes("\t\t\t\tyy_state = yy_next_state;\n");*/
          m_outstream.writeBytes("\t\t\t}\n");

          m_outstream.writeBytes("\t\t\telse {\n");
          m_outstream.writeBytes("\t\t\t\tif (YYEOF == yy_lookahead " 
                                 + "&& true == yy_initial) {\n");
          if (null != m_spec.m_eof_code)
            {
              m_outstream.writeBytes("\t\t\t\t\tyy_do_eof();\n");
            }

          if (true == m_spec.m_integer_type || true == m_spec.m_yyeof)
            {
              m_outstream.writeBytes("\t\t\t\t\treturn YYEOF;\n");
            }
          else if (null != m_spec.m_eof_value_code) 
            {
              m_outstream.writeBytes(new String(m_spec.m_eof_value_code,0,
                                                m_spec.m_eof_value_read));
            }
          else
            {
              m_outstream.writeBytes("\t\t\t\t\treturn null;\n");
            }

          m_outstream.writeBytes("\t\t\t\t}\n");
          
          m_outstream.writeBytes("\t\t\t\telse if (YY_NO_STATE == yy_last_accept_state) {\n");
          

          /*m_outstream.writeBytes("\t\t\t\t\tyy_error(YY_E_MATCH,false);\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_initial = true;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_state "
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_next_state = YY_NO_STATE;\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_prev_state = YY_NO_STATE;\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_mark_start();\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");*/

          m_outstream.writeBytes("\t\t\t\t\tthrow (new Error(\"Lexical Error: Unmatched Input.\"));\n");
          m_outstream.writeBytes("\t\t\t\t}\n");

          m_outstream.writeBytes("\t\t\t\telse {\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_to_mark();\n");

          m_outstream.writeBytes("\t\t\t\t\tyy_anchor = yy_acpt[yy_last_accept_state];\n");
          /*m_outstream.writeBytes("\t\t\t\t\tyy_anchor " 
            + "= yy_accept(yy_last_accept_state);\n");*/
          m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_END & yy_anchor)) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_pushback();\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");
          m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_START & yy_anchor)) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_move_start();\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");

          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\t\t\t\tyychar = yy_getchar();\n");
            }

          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\t\t\t\tyyline = yy_getline();\n");
            }

          m_outstream.writeBytes("\t\t\t\t\tyytext = yy_gettext();\n");

          m_outstream.writeBytes("\t\t\t\t\tswitch (yy_last_accept_state) {\n");

          emit_actions("\t\t\t\t\t");

          m_outstream.writeBytes("\t\t\t\t\tdefault:\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_error(YY_E_INTERNAL,false);\n");
          /*m_outstream.writeBytes("\t\t\t\t\t\treturn null;\n");*/
          m_outstream.writeBytes("\t\t\t\t\tcase -1:\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");
          
          m_outstream.writeBytes("\t\t\t\t\tyy_initial = true;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_state "
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_next_state = YY_NO_STATE;\n");
          /*m_outstream.writeBytes("\t\t\t\t\tyy_prev_state = YY_NO_STATE;\n");*/
          m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;\n");

          m_outstream.writeBytes("\t\t\t\t\tyy_mark_start();\n");

          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");

          m_outstream.writeBytes("\t\t\t\t}\n");          
          m_outstream.writeBytes("\t\t\t}\n");
          m_outstream.writeBytes("\t\t}\n");
          m_outstream.writeBytes("\t}\n");

          /*m_outstream.writeBytes("\t\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t}\n");*/
        }
  
  /***************************************************************
    Function: emit_actions
    Description:     
    **************************************************************/
  private void emit_actions 
    (
     String tabs
     )
      throws java.io.IOException
        {
          int elem;
          int size;
          int bogus_index;
          IRxqsITZU accept;
          
          if (FOVOvCcFg.DEBUG)
            {
              FOVOvCcFg.assert(m_spec.m_accept_vector.size() 
                              == m_spec.m_anchor_array.length);
            }

          bogus_index = -2;
          size = m_spec.m_accept_vector.size();
          for (elem = 0; elem < size; ++elem)
            {
              accept = (IRxqsITZU) m_spec.m_accept_vector.elementAt(elem);
              if (null != accept) 
                {
                  m_outstream.writeBytes(tabs + "case " + elem 
                                         /*+ (new Integer(elem)).toString()*/
                                         + ":\n");
                  m_outstream.writeBytes(tabs + "\t");
                  m_outstream.writeBytes(new String(accept.m_action,0,
                                                    accept.m_action_read));
                  m_outstream.writeBytes("\n");
                  m_outstream.writeBytes(tabs + "case " + bogus_index + ":\n");
                  m_outstream.writeBytes(tabs + "\tbreak;\n");
                  --bogus_index;
                }
            }
        }
  
  /***************************************************************
    Function: emit_footer
    Description:     
    **************************************************************/
  private void emit_footer
    (
     )
      throws java.io.IOException
      {
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != m_spec);
            FOVOvCcFg.assert(null != m_outstream);
          }

        m_outstream.writeBytes("}\n");
      }
}

/***************************************************************
  Class: YvZqHUyzK
  **************************************************************/
final class YvZqHUyzK //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  Vector m_nfa_set; /* Vector of CkBxcepSH states in dfa state. */
  BitSet m_nfa_bit; /* BitSet representation of CkBxcepSH labels. */
  IRxqsITZU m_accept; /* Accepting actions, or null if nonaccepting state. */
  int m_anchor; /* Anchors on regular expression. */
  int m_accept_index; /* CkBxcepSH index corresponding to accepting actions. */

  /***************************************************************
    Function: YvZqHUyzK
    Description: Constructor.
    **************************************************************/
  YvZqHUyzK
    (
     )
      {
        m_nfa_set = null;
        m_nfa_bit = null;
        m_accept = null;
        m_anchor = drHChFQzb.NONE;
        m_accept_index = -1;
      }
}

/***************************************************************
  Class: CJBXugDII
  **************************************************************/
final class CJBXugDII //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private drHChFQzb m_spec;
  private EpinONEnm m_lexGen;
  private zkBeKJFxt m_input;

  /***************************************************************
    Function: CJBXugDII
    Description: Constructor.
    **************************************************************/
  CJBXugDII
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: reset
    Description: Resets CJBXugDII member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_input = null;
        m_lexGen = null;
        m_spec = null;
      }

  /***************************************************************
    Function: set
    Description: Sets CJBXugDII member variables.
    **************************************************************/
  private void set
    (
     EpinONEnm lexGen,
     drHChFQzb spec,
     zkBeKJFxt input
     )
      {
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != input);
            FOVOvCcFg.assert(null != lexGen);
            FOVOvCcFg.assert(null != spec);
          }

        m_input = input;
        m_lexGen = lexGen;
        m_spec = spec;
      }

  /***************************************************************
    Function: thompson
    Description: High level access function to module.
    Deposits result in input drHChFQzb.
    **************************************************************/
  void thompson
    (
     EpinONEnm lexGen,
     drHChFQzb spec,
     zkBeKJFxt input
     )
      throws java.io.IOException      
        {       
          int i;
          CkBxcepSH elem;
          int size;

          /* Set member variables. */
          reset();
          set(lexGen,spec,input);
          size = m_spec.m_states.size();       
          m_spec.m_state_rules = new Vector[size];
          for (i = 0; i < size; ++i)
            {       
              m_spec.m_state_rules[i] = new Vector();
            }

          /* Initialize current token variable 
             and create nfa. */
          /*m_spec.m_current_token = m_lexGen.EOS;
          m_lexGen.advance();*/

          m_spec.m_nfa_start = machine();
          
          /* Set labels in created nfa machine. */
          size = m_spec.m_nfa_states.size();
          for (i = 0; i < size; ++i)
            {        
              elem = (CkBxcepSH) m_spec.m_nfa_states.elementAt(i);
              elem.m_label = i;
            }

          /* Debugging output. */
          if (FOVOvCcFg.DO_DEBUG)
            {
              m_lexGen.print_nfa();
            }

          if (true == m_spec.m_verbose)
            {
              System.out.println("NFA comprised of " 
                                 + (m_spec.m_nfa_states.size() + 1) 
                                 + " states.");
            }

          reset();
        }
     
  /***************************************************************
    Function: discardCkBxcepSH
    Description: 
    **************************************************************/
  private void discardCkBxcepSH
    (
     CkBxcepSH nfa
     )
      {
        m_spec.m_nfa_states.removeElement(nfa);
      }

  /***************************************************************
    Function: processStates
    Description:
    **************************************************************/
  private void processStates
    (
     BitSet states,
     CkBxcepSH current
     )
      {
        int size;
        int i;
        
        size = m_spec.m_states.size();
        for (i = 0; i <  size; ++i)
          {
            if (true == states.get(i))
              {
                m_spec.m_state_rules[i].addElement(current);
              }
          }
      }

  /***************************************************************
    Function: machine
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private CkBxcepSH machine
    (
     )
      throws java.io.IOException 
      {
        CkBxcepSH start;
        CkBxcepSH p;
        BitSet states;

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.enter("machine",m_spec.m_lexeme,m_spec.m_current_token);
          }

        states = m_lexGen.getStates();

        /* Begin: Added for states. */
        m_spec.m_current_token = m_lexGen.EOS;
        m_lexGen.advance();
        /* End: Added for states. */
        
        start = FdipEadqR.newCkBxcepSH(m_spec);
        p = start;
        p.m_next = rule();

        processStates(states,p.m_next);

        while (m_lexGen.END_OF_INPUT != m_spec.m_current_token)
          {
            /* Make state changes HERE. */
            states = m_lexGen.getStates();
        
            /* Begin: Added for states. */
            m_lexGen.advance();
            if (m_lexGen.END_OF_INPUT == m_spec.m_current_token)
              { 
                break;
              }
            /* End: Added for states. */
            
            p.m_next2 = FdipEadqR.newCkBxcepSH(m_spec);
            p = p.m_next2;
            p.m_next = rule();
            
            processStates(states,p.m_next);
          }

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.leave("machine",m_spec.m_lexeme,m_spec.m_current_token);
          }

        return start;
      }
  
  /***************************************************************
    Function: rule
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private CkBxcepSH rule
    (
     )
      throws java.io.IOException 
      {
        dHBnaZxmQ pair; 
        CkBxcepSH p;
        CkBxcepSH start = null;
        CkBxcepSH end = null;
        int anchor = drHChFQzb.NONE;

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.enter("rule",m_spec.m_lexeme,m_spec.m_current_token);
          }

        pair = FdipEadqR.newdHBnaZxmQ();

        if (m_lexGen.AT_BOL == m_spec.m_current_token)
          {
            start = FdipEadqR.newCkBxcepSH(m_spec);
            start.m_edge = '\n';
            anchor = anchor | drHChFQzb.START;
            m_lexGen.advance();

            expr(pair);
            start.m_next = pair.m_start;
            end = pair.m_end;
          }
        else
          {
            expr(pair);
            start = pair.m_start;
            end = pair.m_end;
          }

        if (m_lexGen.AT_EOL == m_spec.m_current_token)
          {
            m_lexGen.advance();
            end.m_next = FdipEadqR.newCkBxcepSH(m_spec);
            
            /* This is the way he does it. */
            end.m_edge = CkBxcepSH.CCL;
            end.m_set = new IxcsuvWDA();

            end.m_set.add('\n');

            if (false == m_spec.m_unix)
              {
                end.m_set.add('\r');
              }
                
            end = end.m_next;
            anchor = anchor | drHChFQzb.END;
          }

        /* Handle end of regular expression.  See page 103. */
        end.m_accept = m_lexGen.packAccept();
        end.m_anchor = anchor;

        /* Begin: Removed for states. */
        /*m_lexGen.advance();*/
        /* End: Removed for states. */

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.leave("rule",m_spec.m_lexeme,m_spec.m_current_token);
          }

        return start;
      }
            
  /***************************************************************
    Function: expr
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void expr
    (
     dHBnaZxmQ pair
     )
      throws java.io.IOException 
      {
        dHBnaZxmQ e2_pair;
        CkBxcepSH p;
        
        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.enter("expr",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != pair);
          }

        e2_pair = FdipEadqR.newdHBnaZxmQ();

        cat_expr(pair);
        
        while (m_lexGen.OR == m_spec.m_current_token)
          {
            m_lexGen.advance();
            cat_expr(e2_pair);

            p = FdipEadqR.newCkBxcepSH(m_spec);
            p.m_next2 = e2_pair.m_start;
            p.m_next = pair.m_start;
            pair.m_start = p;
            
            p = FdipEadqR.newCkBxcepSH(m_spec);
            pair.m_end.m_next = p;
            e2_pair.m_end.m_next = p;
            pair.m_end = p;
          }

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.leave("expr",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
            
  /***************************************************************
    Function: cat_expr
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void cat_expr
    (
     dHBnaZxmQ pair
     )
      throws java.io.IOException 
      {
        dHBnaZxmQ e2_pair;

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.enter("cat_expr",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != pair);
          }
        
        e2_pair = FdipEadqR.newdHBnaZxmQ();
        
        if (true == first_in_cat(m_spec.m_current_token))
          {
            factor(pair);
          }

        while (true == first_in_cat(m_spec.m_current_token))
          {
            factor(e2_pair);

            /* Destroy */
            pair.m_end.mimic(e2_pair.m_start);
            discardCkBxcepSH(e2_pair.m_start);
            
            pair.m_end = e2_pair.m_end;
          }

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.leave("cat_expr",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
  
  /***************************************************************
    Function: first_in_cat
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private boolean first_in_cat
    (
     int token
     )
      {
        switch (token)
          {
          case m_lexGen.CLOSE_PAREN:
          case m_lexGen.AT_EOL:
          case m_lexGen.OR:
          case m_lexGen.EOS:
            return false;
            
          case m_lexGen.CLOSURE:
          case m_lexGen.PLUS_CLOSE:
          case m_lexGen.OPTIONAL:
            pERmcHeDz.parse_error(pERmcHeDz.E_CLOSE,m_input.m_line_number);
            return false;

          case m_lexGen.CCL_END:
            pERmcHeDz.parse_error(pERmcHeDz.E_BRACKET,m_input.m_line_number);
            return false;

          case m_lexGen.AT_BOL:
            pERmcHeDz.parse_error(pERmcHeDz.E_BOL,m_input.m_line_number);
            return false;

          default:
            break;
          }

        return true;
      }

  /***************************************************************
    Function: factor
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void factor
    (
     dHBnaZxmQ pair
     )
      throws java.io.IOException 
      {
        CkBxcepSH start = null;
        CkBxcepSH end = null;

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.enter("factor",m_spec.m_lexeme,m_spec.m_current_token);
          }

        term(pair);

        if (m_lexGen.CLOSURE == m_spec.m_current_token
            || m_lexGen.PLUS_CLOSE == m_spec.m_current_token
            || m_lexGen.OPTIONAL == m_spec.m_current_token)
          {
            start = FdipEadqR.newCkBxcepSH(m_spec);
            end = FdipEadqR.newCkBxcepSH(m_spec);
            
            start.m_next = pair.m_start;
            pair.m_end.m_next = end;

            if (m_lexGen.CLOSURE == m_spec.m_current_token
                || m_lexGen.OPTIONAL == m_spec.m_current_token)
              {
                start.m_next2 = end;
              }
            
            if (m_lexGen.CLOSURE == m_spec.m_current_token
                || m_lexGen.PLUS_CLOSE == m_spec.m_current_token)
              {
                pair.m_end.m_next2 = pair.m_start;
              }
            
            pair.m_start = start;
            pair.m_end = end;
            m_lexGen.advance();
          }

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.leave("factor",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
      
  /***************************************************************
    Function: term
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void term
    (
     dHBnaZxmQ pair
     )
      throws java.io.IOException 
      {
        CkBxcepSH start;
        int c;

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.enter("term",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (m_lexGen.OPEN_PAREN == m_spec.m_current_token)
          {
            m_lexGen.advance();
            expr(pair);

            if (m_lexGen.CLOSE_PAREN == m_spec.m_current_token)
              {
                m_lexGen.advance();
              }
            else
              {
                pERmcHeDz.parse_error(pERmcHeDz.E_SYNTAX,m_input.m_line_number);
              }
          }
        else
          {
            start = FdipEadqR.newCkBxcepSH(m_spec);
            pair.m_start = start;

            start.m_next = FdipEadqR.newCkBxcepSH(m_spec);
            pair.m_end = start.m_next;

            if (false == (m_lexGen.ANY == m_spec.m_current_token
                          || m_lexGen.CCL_START == m_spec.m_current_token))
              {
                start.m_edge = m_spec.m_lexeme;
                m_lexGen.advance();
              }
            else
              {
                start.m_edge = CkBxcepSH.CCL;
                
                start.m_set = new IxcsuvWDA();

                /* Match dot (.) using character class. */
                if (m_lexGen.ANY == m_spec.m_current_token)
                  {
                    start.m_set.add((byte) '\n');
                    if (false == m_spec.m_unix)
                      {
                        start.m_set.add((byte) '\r');
                      }
                    start.m_set.complement();
                  }
                else
                  {
                    m_lexGen.advance();
                    if (m_lexGen.AT_BOL == m_spec.m_current_token)
                      {
                        m_lexGen.advance();

                        /*start.m_set.add((byte) '\n');
                        if (false == m_spec.m_unix)
                          {
                            start.m_set.add((byte) '\r');
                          }*/
                        start.m_set.complement();
                      }
                    if (false == (m_lexGen.CCL_END == m_spec.m_current_token))
                      {
                        dodash(start.m_set);
                      }
                    /*else
                      {
                        for (c = 0; c <= ' '; ++c)
                          {
                            start.m_set.add((byte) c);
                          }
                      }*/
                  }
                m_lexGen.advance();
              }
          }

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.leave("term",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }

  /***************************************************************
    Function: dodash
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void dodash
    (
     IxcsuvWDA set
     )
      throws java.io.IOException 
        {
          int first = -1;
          
          if (FOVOvCcFg.DESCENT_DEBUG)
            {
              FOVOvCcFg.enter("dodash",m_spec.m_lexeme,m_spec.m_current_token);
            }
          
          while (m_lexGen.EOS != m_spec.m_current_token 
                 && m_lexGen.CCL_END != m_spec.m_current_token)
            {
              if (m_lexGen.DASH == m_spec.m_current_token)
                {
                  if (FOVOvCcFg.DEBUG)
                    {
                      FOVOvCcFg.assert(-1 != first);
                    }
                  
                  m_lexGen.advance();
                  for ( ; first <= m_spec.m_lexeme; ++first)
                    {
                      set.add(first);
                    }  
                }
              else
                {
                  first = m_spec.m_lexeme;
                  set.add(m_spec.m_lexeme);
                }

              m_lexGen.advance();
            }
          
        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            FOVOvCcFg.leave("dodash",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
}

/***************************************************************
  Class: gApUoJlkt
 **************************************************************/
final class gApUoJlkt //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  drHChFQzb m_spec;
  Vector m_group;
  int m_ingroup[];

  /***************************************************************
    Function: gApUoJlkt
    Description: Constructor.
    **************************************************************/
  gApUoJlkt 
    (
     )
      {
        reset();
      }
  
  /***************************************************************
    Function: reset
    Description: Resets member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_spec = null;
        m_group = null;
        m_ingroup = null;
      }

  /***************************************************************
    Function: set
    Description: Sets member variables.
    **************************************************************/
  private void set
    (
     drHChFQzb spec
     )
      {
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != spec);
          }

        m_spec = spec;
        m_group = null;
        m_ingroup = null;
      }

  /***************************************************************
    Function: min_dfa
    Description: High-level access function to module.
    **************************************************************/
  void min_dfa
    (
     drHChFQzb spec
     )
      {
        set(spec);

        /* Remove redundant states. */
        minimize();

        /* Column and row compression. 
           Save accept states in auxilary vector. */
        reduce();

        reset();
      }

  /***************************************************************
    Function: col_copy
    Description: Copies source column into destination column.
    **************************************************************/
  private void col_copy
    (
     int dest,
     int src
     )
      {
        int n;
        int i;
        fhTZXkZqS dtrans;

        n = m_spec.m_dtrans_vector.size();
        for (i = 0; i < n; ++i)
          {
            dtrans = (fhTZXkZqS) m_spec.m_dtrans_vector.elementAt(i);
            dtrans.m_dtrans[dest] = dtrans.m_dtrans[src]; 
          }
      } 
        
  /***************************************************************
    Function: row_copy
    Description: Copies source row into destination row.
    **************************************************************/
  private void row_copy
    (
     int dest,
     int src
     )
      {
        fhTZXkZqS dtrans;

        dtrans = (fhTZXkZqS) m_spec.m_dtrans_vector.elementAt(src);
        m_spec.m_dtrans_vector.setElementAt(dtrans,dest); 
      } 
        
  /***************************************************************
    Function: col_equiv
    Description: 
    **************************************************************/
  private boolean col_equiv
    (
     int col1,
     int col2
     )
      {
        int n;
        int i;
        fhTZXkZqS dtrans;

        n = m_spec.m_dtrans_vector.size();
        for (i = 0; i < n; ++i)
          {
            dtrans = (fhTZXkZqS) m_spec.m_dtrans_vector.elementAt(i);
            if (dtrans.m_dtrans[col1] != dtrans.m_dtrans[col2]) 
              {
                return false;
              }
          }
        
        return true;
      }

  /***************************************************************
    Function: row_equiv
    Description: 
    **************************************************************/
  private boolean row_equiv
    (
     int row1,
     int row2
     )
      {
        int i;
        fhTZXkZqS dtrans1;
        fhTZXkZqS dtrans2;

        dtrans1 = (fhTZXkZqS) m_spec.m_dtrans_vector.elementAt(row1);
        dtrans2 = (fhTZXkZqS) m_spec.m_dtrans_vector.elementAt(row2);
        
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (dtrans1.m_dtrans[i] != dtrans2.m_dtrans[i]) 
              {
                return false;
              }
          }
        
        return true;
      }

  /***************************************************************
    Function: reduce
    Description: 
    **************************************************************/
  private void reduce
    (
     )
      {
        int i;
        int j;
        int k;
        int nrows;
        int reduced_ncols;
        int reduced_nrows;
        BitSet set;
        fhTZXkZqS dtrans;
        int size;

        set = new BitSet();
        
        /* Save accept nodes and anchor entries. */
        size = m_spec.m_dtrans_vector.size();
        m_spec.m_anchor_array = new int[size];
        m_spec.m_accept_vector = new Vector();
        for (i = 0; i < size; ++i)
          {
            dtrans = (fhTZXkZqS) m_spec.m_dtrans_vector.elementAt(i);
            m_spec.m_accept_vector.addElement(dtrans.m_accept);
            m_spec.m_anchor_array[i] = dtrans.m_anchor;
            dtrans.m_accept = null;
          }
        
        /* Allocate column map. */
        m_spec.m_col_map = new int[m_spec.m_dtrans_ncols];
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            m_spec.m_col_map[i] = -1;
          }

        /* Process columns for reduction. */
        for (reduced_ncols = 0; ; ++reduced_ncols)
          {
            if (true == FOVOvCcFg.DEBUG)
              {
                for (i = 0; i < reduced_ncols; ++i)
                  {
                    FOVOvCcFg.assert(-1 != m_spec.m_col_map[i]);
                  }
              }

            for (i = reduced_ncols; i < m_spec.m_dtrans_ncols; ++i)
              {
                if (-1 == m_spec.m_col_map[i])
                  {
                    break;
                  }
              }

            if (i >= m_spec.m_dtrans_ncols)
              {
                break;
              }

            if (true == FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(false == set.get(i));
                FOVOvCcFg.assert(-1 == m_spec.m_col_map[i]);
              }

            set.set(i);
            
            m_spec.m_col_map[i] = reduced_ncols;
            
            /* UNDONE: Optimize by doing all comparisons in one batch. */
            for (j = i + 1; j < m_spec.m_dtrans_ncols; ++j)
              {
                if (-1 == m_spec.m_col_map[j] && true == col_equiv(i,j))
                  {
                    m_spec.m_col_map[j] = reduced_ncols;
                  }
              }
          }

        /* Reduce columns. */
        k = 0;
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (true == set.get(i))
              {
                ++k;

                set.clear(i);
                
                j = m_spec.m_col_map[i];
                
                if (true == FOVOvCcFg.DEBUG)
                  {
                    FOVOvCcFg.assert(j <= i);
                  }
                
                if (j == i)
                  {
                    continue;
                  }
                
                col_copy(j,i);
              }
          }
        m_spec.m_dtrans_ncols = reduced_ncols;

        if (true == FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(k == reduced_ncols);
          }

        /* Allocate row map. */
        nrows = m_spec.m_dtrans_vector.size();
        m_spec.m_row_map = new int[nrows];
        for (i = 0; i < nrows; ++i)
          {
            m_spec.m_row_map[i] = -1;
          }

        /* Process rows to reduce. */
        for (reduced_nrows = 0; ; ++reduced_nrows)
          {
            if (true == FOVOvCcFg.DEBUG)
              {
                for (i = 0; i < reduced_nrows; ++i)
                  {
                    FOVOvCcFg.assert(-1 != m_spec.m_row_map[i]);
                  }
              }

            for (i = reduced_nrows; i < nrows; ++i)
              {
                if (-1 == m_spec.m_row_map[i])
                  {
                    break;
                  }
              }

            if (i >= nrows)
              {
                break;
              }

            if (true == FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(false == set.get(i));
                FOVOvCcFg.assert(-1 == m_spec.m_row_map[i]);
              }

            set.set(i);

            m_spec.m_row_map[i] = reduced_nrows;
            
            /* UNDONE: Optimize by doing all comparisons in one batch. */
            for (j = i + 1; j < nrows; ++j)
              {
                if (-1 == m_spec.m_row_map[j] && true == row_equiv(i,j))
                  {
                    m_spec.m_row_map[j] = reduced_nrows;
                  }
              }
          }

        /* Reduce rows. */
        k = 0;
        for (i = 0; i < nrows; ++i)
          {
            if (true == set.get(i))
              {
                ++k;

                set.clear(i);
                
                j = m_spec.m_row_map[i];
                
                if (true == FOVOvCcFg.DEBUG)
                  {
                    FOVOvCcFg.assert(j <= i);
                  }
                
                if (j == i)
                  {
                    continue;
                  }
                
                row_copy(j,i);
              }
          }
        m_spec.m_dtrans_vector.setSize(reduced_nrows);

        if (FOVOvCcFg.DEBUG)
          {
            /*System.out.print("k = " + k + "\nreduced_nrows = " + reduced_nrows + "\n");*/
            FOVOvCcFg.assert(k == reduced_nrows);
          }
      }

  /***************************************************************
    Function: fix_dtrans
    Description: Updates fhTZXkZqS table after minimization 
    using groups, removing redundant transition table states.
    **************************************************************/
  private void fix_dtrans
    (
     )
      {
        Vector new_vector;
        int i;
        int size;
        Vector dtrans_group;
        fhTZXkZqS first;
        int c;

        new_vector = new Vector();

        size = m_spec.m_state_dtrans.length;
        for (i = 0; i < size; ++i)
          {
            if (fhTZXkZqS.F != m_spec.m_state_dtrans[i])
              {
                m_spec.m_state_dtrans[i] = m_ingroup[m_spec.m_state_dtrans[i]];
              }
          }

        size = m_group.size();
        for (i = 0; i < size; ++i)
          {
            dtrans_group = (Vector) m_group.elementAt(i);
            first = (fhTZXkZqS) dtrans_group.elementAt(0);
            new_vector.addElement(first);

            for (c = 0; c < m_spec.m_dtrans_ncols; ++c)
              {
                if (fhTZXkZqS.F != first.m_dtrans[c])
                  {
                    first.m_dtrans[c] = m_ingroup[first.m_dtrans[c]];
                  }
              }
          }

        m_group = null;
        m_spec.m_dtrans_vector = new_vector;
      }

  /***************************************************************
    Function: minimize
    Description: Removes redundant transition table states.
    **************************************************************/
  private void minimize
    (
     )
      {
        Vector dtrans_group;
        Vector new_group;
        int i;
        int j;
        int old_group_count;
        int group_count;
        fhTZXkZqS next;
        fhTZXkZqS first;
        int goto_first;
        int goto_next;
        int c;
        int group_size;
        boolean added;

        init_groups();

        group_count = m_group.size();
        old_group_count = group_count - 1;

        while (old_group_count != group_count)
          {
            old_group_count = group_count;

            if (FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(m_group.size() == group_count);
              }

            for (i = 0; i < group_count; ++i)
              {
                dtrans_group = (Vector) m_group.elementAt(i);

                group_size = dtrans_group.size();
                if (group_size <= 1)
                  {
                    continue;
                  }

                new_group = new Vector();
                added = false;
                
                first = (fhTZXkZqS) dtrans_group.elementAt(0);
                for (j = 1; j < group_size; ++j)
                  {
                    next = (fhTZXkZqS) dtrans_group.elementAt(j);

                    for (c = 0; c < m_spec.m_dtrans_ncols; ++c)
                      {
                        goto_first = first.m_dtrans[c];
                        goto_next = next.m_dtrans[c];

                        if (goto_first != goto_next
                            && (goto_first == fhTZXkZqS.F
                                || goto_next == fhTZXkZqS.F
                                || m_ingroup[goto_next] != m_ingroup[goto_first]))
                          {
                            if (FOVOvCcFg.DEBUG)
                              {
                                FOVOvCcFg.assert(dtrans_group.elementAt(j) == next);
                              }
                            
                            dtrans_group.removeElementAt(j);
                            --j;
                            --group_size;
                            new_group.addElement(next);
                            if (false == added)
                              {
                                added = true;
                                ++group_count;
                                m_group.addElement(new_group);
                              }
                            m_ingroup[next.m_label] = m_group.size() - 1;

                            if (FOVOvCcFg.DEBUG)
                              {
                                FOVOvCcFg.assert(m_group.contains(new_group)
                                                == true);
                                FOVOvCcFg.assert(m_group.contains(dtrans_group)
                                                == true);
                                FOVOvCcFg.assert(dtrans_group.contains(first)
                                                == true);
                                FOVOvCcFg.assert(dtrans_group.contains(next)
                                                == false);
                                FOVOvCcFg.assert(new_group.contains(first)
                                                == false);
                                FOVOvCcFg.assert(new_group.contains(next)
                                                == true);
                                FOVOvCcFg.assert(dtrans_group.size() == group_size);
                                FOVOvCcFg.assert(i == m_ingroup[first.m_label]);
                                FOVOvCcFg.assert((m_group.size() - 1) 
                                                == m_ingroup[next.m_label]);
                              }

                            break;
                          }
                      }
                  }
              }
          }

        System.out.println(m_group.size() + " states after removal of redundant states.");

        if (true == m_spec.m_verbose
            && true == FOVOvCcFg.OLD_DUMP_DEBUG)
          {
            System.out.println("\nStates grouped as follows after minimization");
            pgroups();
          }

        fix_dtrans();
      }

  /***************************************************************
    Function: init_groups
    Description:
    **************************************************************/
  private void init_groups
    (
     )
      {
        int i;
        int j;
        int group_count;
        int size;
        IRxqsITZU accept;
        fhTZXkZqS dtrans;
        Vector dtrans_group;
        fhTZXkZqS first;
        boolean group_found;

        m_group = new Vector();
        group_count = 0;
        
        size = m_spec.m_dtrans_vector.size();
        m_ingroup = new int[size];
        
        for (i = 0; i < size; ++i)
          {
            group_found = false;
            dtrans = (fhTZXkZqS) m_spec.m_dtrans_vector.elementAt(i);

            if (FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(i == dtrans.m_label);
                FOVOvCcFg.assert(false == group_found);
                FOVOvCcFg.assert(group_count == m_group.size());
              }
            
            for (j = 0; j < group_count; ++j)
              {
                dtrans_group = (Vector) m_group.elementAt(j);
                
                if (FOVOvCcFg.DEBUG)
                  {
                    FOVOvCcFg.assert(false == group_found);
                    FOVOvCcFg.assert(0 < dtrans_group.size());
                  }

                first = (fhTZXkZqS) dtrans_group.elementAt(0);
                
                if (FOVOvCcFg.SLOW_DEBUG)
                  {
                    fhTZXkZqS check;
                    int k;
                    int s;

                    s = dtrans_group.size();
                    FOVOvCcFg.assert(0 < s);

                    for (k = 1; k < s; ++k)
                      {
                        check = (fhTZXkZqS) dtrans_group.elementAt(k);
                        FOVOvCcFg.assert(check.m_accept == first.m_accept);
                      }
                  }

                if (first.m_accept == dtrans.m_accept)
                  {
                    dtrans_group.addElement(dtrans);
                    m_ingroup[i] = j;
                    group_found = true;
                    
                    if (FOVOvCcFg.DEBUG)
                      {
                        FOVOvCcFg.assert(j == m_ingroup[dtrans.m_label]);
                      }

                    break;
                  }
              }
            
            if (false == group_found)
              {
                dtrans_group = new Vector();
                dtrans_group.addElement(dtrans);
                m_ingroup[i] = m_group.size();
                m_group.addElement(dtrans_group);
                ++group_count;
              }
          }
        
        if (true == m_spec.m_verbose
            && true == FOVOvCcFg.OLD_DUMP_DEBUG)
          {
            System.out.println("Initial grouping:");
            pgroups();
            System.out.println("");
          }
      }

  /***************************************************************
    Function: pset
    **************************************************************/
  private void pset
    (
     Vector dtrans_group
     )
      {
        int i;
        int size;
        fhTZXkZqS dtrans;

        size = dtrans_group.size();
        for (i = 0; i < size; ++i)
          {
            dtrans = (fhTZXkZqS) dtrans_group.elementAt(i);
            System.out.print(dtrans.m_label + " ");
          }
      }
  
  /***************************************************************
    Function: pgroups
    **************************************************************/
  private void pgroups
    (
     )
      {
        int i;
        int dtrans_size;
        int group_size;
        
        group_size = m_group.size();
        for (i = 0; i < group_size; ++i)
          {
            System.out.print("\tGroup " + i + " {");
            pset((Vector) m_group.elementAt(i));
            System.out.println("}\n");
          }
        
        System.out.println("");
        dtrans_size = m_spec.m_dtrans_vector.size();
        for (i = 0; i < dtrans_size; ++i)
          {
            System.out.println("\tstate " + i 
                               + " is in group " 
                               + m_ingroup[i]);
          }
      }
}

/***************************************************************
  Class: AMrQFMJUp
 **************************************************************/
final class AMrQFMJUp //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private drHChFQzb m_spec;
  private int m_unmarked_dfa;
  private EpinONEnm m_lexGen;

  /***************************************************************
    Constants
    **************************************************************/
  private static final int NOT_IN_DSTATES = -1;

  /***************************************************************
    Function: AMrQFMJUp
    **************************************************************/
  AMrQFMJUp
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: set 
    Description: 
    **************************************************************/
  private void set
    (
     EpinONEnm lexGen,
     drHChFQzb spec
     )
      {
        m_lexGen = lexGen;
        m_spec = spec;
        m_unmarked_dfa = 0;
      }

  /***************************************************************
    Function: reset 
    Description: 
    **************************************************************/
  private void reset
    (
     )
      {
        m_lexGen = null;
        m_spec = null;
        m_unmarked_dfa = 0;
      }

  /***************************************************************
    Function: make_dfa
    Description: High-level access function to module.
    **************************************************************/
  void make_dfa
    (
     EpinONEnm lexGen,
     drHChFQzb spec
     )
      {
        int i;

        reset();
        set(lexGen,spec);

        make_dtrans();
        free_nfa_states();

        if (true == m_spec.m_verbose && true == FOVOvCcFg.OLD_DUMP_DEBUG)
          {
            System.out.println(m_spec.m_dfa_states.size()
                               + " DFA states in original machine.");
          }

        free_dfa_states();
      }     

   /***************************************************************
    Function: make_dtrans
    Description: Creates uncompressed fhTZXkZqS transition table.
    **************************************************************/
  private void make_dtrans
    (
     )
     /* throws java.lang.CloneNotSupportedException*/
      {
        ECEVWgdOK next;
        ECEVWgdOK dfa;
        YvZqHUyzK bunch;
        int i;
        int nextstate;
        int size;
        fhTZXkZqS dtrans;
        CkBxcepSH nfa;
        int istate;
        int nstates;
        
        System.out.print("Working on DFA states.");

        /* Reference passing type and initializations. */
        bunch = new YvZqHUyzK();
        m_unmarked_dfa = 0;

        /* Allocate mapping array. */
        nstates = m_spec.m_state_rules.length;
        m_spec.m_state_dtrans = new int[nstates];

        for (istate = 0; nstates > istate; ++istate)
          {
            if (0 == m_spec.m_state_rules[istate].size())
              {
                m_spec.m_state_dtrans[istate] = fhTZXkZqS.F;
                continue;
              }
                
            /* Create start state and initialize fields. */
            bunch.m_nfa_set = (Vector) m_spec.m_state_rules[istate].clone();
            sortStates(bunch.m_nfa_set);
            
            bunch.m_nfa_bit = new BitSet();
            
            /* Initialize bit set. */
            size = bunch.m_nfa_set.size();
            for (i = 0; size > i; ++i)
              {
                nfa = (CkBxcepSH) bunch.m_nfa_set.elementAt(i);
                bunch.m_nfa_bit.set(nfa.m_label);
              }
            
            bunch.m_accept = null;
            bunch.m_anchor = drHChFQzb.NONE;
            bunch.m_accept_index = FOVOvCcFg.INT_MAX;
            
            e_closure(bunch);
            add_to_dstates(bunch);
            
            m_spec.m_state_dtrans[istate] = m_spec.m_dtrans_vector.size();

            /* Main loop of fhTZXkZqS creation. */
            while (null != (dfa = get_unmarked()))
              {
                System.out.print(".");
                System.out.flush();
                
                if (FOVOvCcFg.DEBUG)
                  {
                    FOVOvCcFg.assert(false == dfa.m_mark);
                  }

                /* Get first unmarked node, then mark it. */
                dfa.m_mark = true;
                
                /* Allocate new fhTZXkZqS, then initialize fields. */
                dtrans = new fhTZXkZqS(m_spec.m_dtrans_vector.size(),m_spec);
                dtrans.m_accept = dfa.m_accept;
                dtrans.m_anchor = dfa.m_anchor;
                
                /* Set fhTZXkZqS array for each character transition. */
                for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
                  {
                    if (FOVOvCcFg.DEBUG)
                      {
                        FOVOvCcFg.assert(0 <= i);
                        FOVOvCcFg.assert(m_spec.m_dtrans_ncols > i);
                      }
                    
                    /* Create new dfa set by attempting character transition. */
                    move(dfa.m_nfa_set,dfa.m_nfa_bit,i,bunch);
                    if (null != bunch.m_nfa_set)
                      {
                        e_closure(bunch);
                      }
                    
                    if (FOVOvCcFg.DEBUG)
                      {
                        FOVOvCcFg.assert((null == bunch.m_nfa_set 
                                         && null == bunch.m_nfa_bit)
                                        || (null != bunch.m_nfa_set 
                                            && null != bunch.m_nfa_bit));
                      }
                    
                    /* Create new state or set state to empty. */
                    if (null == bunch.m_nfa_set)
                      {
                        nextstate = fhTZXkZqS.F;
                      }
                    else 
                      {
                        nextstate = in_dstates(bunch);
                        
                        if (NOT_IN_DSTATES == nextstate)
                          {
                            nextstate = add_to_dstates(bunch);
                          }
                      }
                    
                    if (FOVOvCcFg.DEBUG)
                      {
                        FOVOvCcFg.assert(nextstate < m_spec.m_dfa_states.size());
                      }
                    
                    dtrans.m_dtrans[i] = nextstate;
                  }
                
                if (FOVOvCcFg.DEBUG)
                  {
                    FOVOvCcFg.assert(m_spec.m_dtrans_vector.size() == dfa.m_label);
                  }
                
                m_spec.m_dtrans_vector.addElement(dtrans);
              }
          }

        System.out.println("");
      }

  /***************************************************************
    Function: free_dfa_states
    **************************************************************/  
  private void free_dfa_states
    (
     )
      {
        m_spec.m_dfa_states = null;
        m_spec.m_dfa_sets = null;
      }

  /***************************************************************
    Function: free_nfa_states
    **************************************************************/  
  private void free_nfa_states
    (
     )
      {
        /* UNDONE: Remove references to nfas from within dfas. */
        /* UNDONE: Don't free CAccepts. */

        m_spec.m_nfa_states = null;
        m_spec.m_nfa_start = null;
        m_spec.m_state_rules = null;
      }

  /***************************************************************
    Function: e_closure
    Description: Alters and returns input set.
    **************************************************************/
  private void e_closure
    (
     YvZqHUyzK bunch
     )
      {
        Stack nfa_stack;
        int size;
        int i;
        CkBxcepSH state;

        /* Debug checks. */
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != bunch);
            FOVOvCcFg.assert(null != bunch.m_nfa_set);
            FOVOvCcFg.assert(null != bunch.m_nfa_bit);
          }

        bunch.m_accept = null;
        bunch.m_anchor = drHChFQzb.NONE;
        bunch.m_accept_index = FOVOvCcFg.INT_MAX;
        
        /* Create initial stack. */
        nfa_stack = new Stack();
        size = bunch.m_nfa_set.size();
        for (i = 0; i < size; ++i)
          {
            state = (CkBxcepSH) bunch.m_nfa_set.elementAt(i);
            
            if (FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(true == bunch.m_nfa_bit.get(state.m_label));
              }

            nfa_stack.push(state);
          }

        /* Main loop. */
        while (false == nfa_stack.empty())
          {
            state = (CkBxcepSH) nfa_stack.pop();
            
            if (FOVOvCcFg.OLD_DUMP_DEBUG)
              {
                if (null != state.m_accept)
                  {
                    System.out.println("Looking at accepting state " + state.m_label
                                       + " with <"
                                       + (new String(state.m_accept.m_action,0,
                                                     state.m_accept.m_action_read))
                                       + ">");
                  }
              }

            if (null != state.m_accept 
                && state.m_label < bunch.m_accept_index)
              {
                bunch.m_accept_index = state.m_label;
                bunch.m_accept = state.m_accept;
                bunch.m_anchor = state.m_anchor;

                if (FOVOvCcFg.OLD_DUMP_DEBUG)
                  {
                    System.out.println("Found accepting state " + state.m_label
                                       + " with <"
                                       + (new String(state.m_accept.m_action,0,
                                                     state.m_accept.m_action_read))
                                       + ">");
                  }

                if (FOVOvCcFg.DEBUG)
                  {
                    FOVOvCcFg.assert(null != bunch.m_accept);
                    FOVOvCcFg.assert(drHChFQzb.NONE == bunch.m_anchor
                                    || 0 != (bunch.m_anchor & drHChFQzb.END)
                                    || 0 != (bunch.m_anchor & drHChFQzb.START));
                  }
              }

            if (CkBxcepSH.EPSILON == state.m_edge)
              {
                if (null != state.m_next)
                  {
                    if (false == bunch.m_nfa_set.contains(state.m_next))
                      {
                        if (FOVOvCcFg.DEBUG)
                          {
                            FOVOvCcFg.assert(false == bunch.m_nfa_bit.get(state.m_next.m_label));
                          }
                        
                        bunch.m_nfa_bit.set(state.m_next.m_label);
                        bunch.m_nfa_set.addElement(state.m_next);
                        nfa_stack.push(state.m_next);
                      }
                  }

                if (null != state.m_next2)
                  {
                    if (false == bunch.m_nfa_set.contains(state.m_next2))
                      {
                        if (FOVOvCcFg.DEBUG)
                          {
                            FOVOvCcFg.assert(false == bunch.m_nfa_bit.get(state.m_next2.m_label));
                          }
                        
                        bunch.m_nfa_bit.set(state.m_next2.m_label);
                        bunch.m_nfa_set.addElement(state.m_next2);
                        nfa_stack.push(state.m_next2);
                      }
                  }
              }
          }

        if (null != bunch.m_nfa_set)
          {
            sortStates(bunch.m_nfa_set);
          }

        return;
      }

  /***************************************************************
    Function: move
    Description: Returns null if resulting NFA set is empty.
    **************************************************************/
  void move
    (
     Vector nfa_set,
     BitSet nfa_bit,
     int b,
     YvZqHUyzK bunch
     )
      {
        int size;
        int index;
        CkBxcepSH state;
        
        bunch.m_nfa_set = null;
        bunch.m_nfa_bit = null;

        size = nfa_set.size();
        for (index = 0; index < size; ++index)
          {
            state = (CkBxcepSH) nfa_set.elementAt(index);
            
            if (b == state.m_edge
                || (CkBxcepSH.CCL == state.m_edge
                    && true == state.m_set.contains(b)))
              {
                if (null == bunch.m_nfa_set)
                  {
                    if (FOVOvCcFg.DEBUG)
                      {
                        FOVOvCcFg.assert(null == bunch.m_nfa_bit);
                      }
                    
                    bunch.m_nfa_set = new Vector();
                    bunch.m_nfa_bit = new BitSet(m_spec.m_nfa_states.size());
                    /*bunch.m_nfa_bit = new BitSet();*/
                  }

                bunch.m_nfa_set.addElement(state.m_next);
                /*System.out.println("Size of bitset: " + bunch.m_nfa_bit.size());
                System.out.println("Reference index: " + state.m_next.m_label);
                System.out.flush();*/
                bunch.m_nfa_bit.set(state.m_next.m_label);
              }
          }
        
        if (null != bunch.m_nfa_set)
          {
            if (FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(null != bunch.m_nfa_bit);
              }
            
            sortStates(bunch.m_nfa_set);
          }

        return;
      }

  /***************************************************************
    Function: sortStates
    **************************************************************/
  private void sortStates
    (
     Vector nfa_set
     )
      {
        CkBxcepSH elem;
        int begin;
        int size;
        int index;
        int value;
        int smallest_index;
        int smallest_value;
        CkBxcepSH begin_elem;

        size = nfa_set.size();
        for (begin = 0; begin < size; ++begin)
          {
            elem = (CkBxcepSH) nfa_set.elementAt(begin);
            smallest_value = elem.m_label;
            smallest_index = begin;

            for (index = begin + 1; index < size; ++index)
              {
                elem = (CkBxcepSH) nfa_set.elementAt(index);
                value = elem.m_label;

                if (value < smallest_value)
                  {
                    smallest_index = index;
                    smallest_value = value;
                  }
              }

            begin_elem = (CkBxcepSH) nfa_set.elementAt(begin);
            elem = (CkBxcepSH) nfa_set.elementAt(smallest_index);
            nfa_set.setElementAt(elem,begin);
            nfa_set.setElementAt(begin_elem,smallest_index);
          }

        if (true == FOVOvCcFg.OLD_DEBUG)
          {
            System.out.print("NFA vector indices: ");  
            
            for (index = 0; index < size; ++index)
              {
                elem = (CkBxcepSH) nfa_set.elementAt(index);
                System.out.print(elem.m_label + " ");
              }
            System.out.print("\n");
          }     

        return;
      }

  /***************************************************************
    Function: get_unmarked
    Description: Returns next unmarked DFA state.
    **************************************************************/
  private ECEVWgdOK get_unmarked
    (
     )
      {
        int size;
        ECEVWgdOK dfa;

        size = m_spec.m_dfa_states.size();
        while (m_unmarked_dfa < size)
          {
            dfa = (ECEVWgdOK) m_spec.m_dfa_states.elementAt(m_unmarked_dfa);

            if (false == dfa.m_mark)
              {
                if (true == FOVOvCcFg.OLD_DUMP_DEBUG)
                  {
                    System.out.print("*");
                    System.out.flush();
                  }

                if (true == m_spec.m_verbose && true == FOVOvCcFg.OLD_DUMP_DEBUG)
                  {
                    System.out.println("---------------");
                    System.out.print("working on DFA state " 
                                     + m_unmarked_dfa
                                     + " = NFA states: ");
                    m_lexGen.print_set(dfa.m_nfa_set);
                    System.out.print("\n");
                  }

                return dfa;
              }

            ++m_unmarked_dfa;
          }

        return null;
      }
  
  /***************************************************************
    function: add_to_dstates
    Description: Takes as input a YvZqHUyzK with details of
    a dfa state that needs to be created.
    1) Allocates a new dfa state and saves it in 
    the appropriate drHChFQzb vector.
    2) Initializes the fields of the dfa state
    with the information in the YvZqHUyzK.
    3) Returns index of new dfa.
    **************************************************************/
  private int add_to_dstates
    (
     YvZqHUyzK bunch
     )
      {
        ECEVWgdOK dfa;
        
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != bunch.m_nfa_set);
            FOVOvCcFg.assert(null != bunch.m_nfa_bit);
            FOVOvCcFg.assert(null != bunch.m_accept 
                            || drHChFQzb.NONE == bunch.m_anchor);
          }

        /* Allocate, passing drHChFQzb so dfa label can be set. */
        dfa = FdipEadqR.newECEVWgdOK(m_spec);
        
        /* Initialize fields, including the mark field. */
        dfa.m_nfa_set = (Vector) bunch.m_nfa_set.clone();
        dfa.m_nfa_bit = (BitSet) bunch.m_nfa_bit.clone();
        dfa.m_accept = bunch.m_accept;
        dfa.m_anchor = bunch.m_anchor;
        dfa.m_mark = false;
        
        /* Register dfa state using BitSet in drHChFQzb Hashtable. */
        m_spec.m_dfa_sets.put(dfa.m_nfa_bit,dfa);
        /*registerECEVWgdOK(dfa);*/

        if (FOVOvCcFg.OLD_DUMP_DEBUG)
          {
            System.out.print("Registering set : ");
            m_lexGen.print_set(dfa.m_nfa_set);
            System.out.println("");
          }

        return dfa.m_label;
      }

  /***************************************************************
    Function: in_dstates
    **************************************************************/
  private int in_dstates
    (
     YvZqHUyzK bunch
     )
      {
        ECEVWgdOK dfa;
        
        if (FOVOvCcFg.OLD_DEBUG)
          {
            System.out.print("Looking for set : ");
            m_lexGen.print_set(bunch.m_nfa_set);
          }

        dfa = (ECEVWgdOK) m_spec.m_dfa_sets.get(bunch.m_nfa_bit);

        if (null != dfa)
          {
            if (FOVOvCcFg.OLD_DUMP_DEBUG)
              {
                System.out.println(" FOUND!");
              }
            
            return dfa.m_label;
          }

        if (FOVOvCcFg.OLD_DUMP_DEBUG)
          {
            System.out.println(" NOT FOUND!");
          }
        return NOT_IN_DSTATES;
      }

}

/***************************************************************
  Class: FdipEadqR
  **************************************************************/
final class FdipEadqR //**NS**
{
  /***************************************************************
    Function: newECEVWgdOK
    **************************************************************/
  static ECEVWgdOK newECEVWgdOK
    (
     drHChFQzb spec
     )
      {
        ECEVWgdOK dfa;
        
        dfa = new ECEVWgdOK(spec.m_dfa_states.size());
        spec.m_dfa_states.addElement(dfa);

        return dfa;
      }

  /***************************************************************
    Function: newdHBnaZxmQ
    Description: 
    **************************************************************/
  static dHBnaZxmQ newdHBnaZxmQ
    (
     )
      {
        dHBnaZxmQ pair = new dHBnaZxmQ();
        
        return pair;
      }

  /***************************************************************
    Function: newCkBxcepSH
    Description: 
    **************************************************************/
  static CkBxcepSH newCkBxcepSH
    (
     drHChFQzb spec
     )
      {
        CkBxcepSH p;

        /* UNDONE: Buffer this? */

        p = new CkBxcepSH();
        
        /*p.m_label = spec.m_nfa_states.size();*/
        spec.m_nfa_states.addElement(p);
        p.m_edge = CkBxcepSH.EPSILON;
        
        return p;
      }
}

/***************************************************************
  Class: jVGZflIaI
  Description: Top-level lexical analyzer generator function.
 **************************************************************/
final class jVGZflIaI //**NS**
{
  /***************************************************************
    Function: main
    **************************************************************/
  public static void main
    (
     String arg[]
     )
    throws java.io.IOException
      {
        EpinONEnm lg;

        if (arg.length < 1)
          {
            System.out.println("Usage: jVGZflIaI <filename>");
            return;
          }

        lg = new EpinONEnm(arg[0]);
        lg.generate();
      }
}    

/***************************************************************
  Class: fhTZXkZqS
  **************************************************************/
final class fhTZXkZqS //**NS**
{
  /*************************************************************
    Member Variables
    ***********************************************************/
  int m_dtrans[];
  IRxqsITZU m_accept;
  int m_anchor;
  int m_label;

  /*************************************************************
    Constants
    ***********************************************************/
  static final int F = -1;

  /*************************************************************
    Function: CTrans
    ***********************************************************/
  fhTZXkZqS
    (
     int label,
     drHChFQzb spec
     )
      {
        m_dtrans = new int[spec.m_dtrans_ncols];
        m_accept = null;
        m_anchor = drHChFQzb.NONE;
        m_label = label;
      }
}

/***************************************************************
  Class: ECEVWgdOK
  **************************************************************/
final class ECEVWgdOK //**NS**
{
  /***************************************************************
    Member Variables
    ***********************************************************/
  int m_group;
  boolean m_mark;
  IRxqsITZU m_accept;
  int m_anchor;
  Vector m_nfa_set;
  BitSet m_nfa_bit;
  int m_label;

  /***************************************************************
    Function: ECEVWgdOK
    **************************************************************/
  ECEVWgdOK
    (
     int label
     )
      {
        m_group = 0;
        m_mark = false;

        m_accept = null;
        m_anchor = drHChFQzb.NONE;

        m_nfa_set = null;
        m_nfa_bit = null;

        m_label = label;
      }
}

/***************************************************************
  Class: IRxqsITZU
 **************************************************************/
final class IRxqsITZU //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  char m_action[];
  int m_action_read;
  int m_line_number;

  /***************************************************************
    Function: IRxqsITZU
    **************************************************************/
  IRxqsITZU
    (
     char action[],
     int action_read,
     int line_number
     )
      {
        int elem;

        m_action_read = action_read;

        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = action[elem];
          }

        m_line_number = line_number;
      }

  /***************************************************************
    Function: IRxqsITZU
    **************************************************************/
  IRxqsITZU
    (
     IRxqsITZU accept
     )
      {
        int elem;

        m_action_read = accept.m_action_read;
        
        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = accept.m_action[elem];
          }

        m_line_number = accept.m_line_number;
      }

  /***************************************************************
    Function: mimic
    **************************************************************/
  void mimic
    (
     IRxqsITZU accept
     )
      {
        int elem;

        m_action_read = accept.m_action_read;
        
        m_action = new char[m_action_read];
        for (elem = 0; elem < m_action_read; ++elem)
          {
            m_action[elem] = accept.m_action[elem];
          }
      }
}

/***************************************************************
  Class: gNErCRCNn
  **************************************************************/
final class gNErCRCNn //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  IRxqsITZU m_accept;
  int m_anchor;

  /***************************************************************
    Function: gNErCRCNn
    **************************************************************/
  gNErCRCNn
    (
     )
      {
        m_accept = null;
        m_anchor = drHChFQzb.NONE;
      }
}

/***************************************************************
  Class: dHBnaZxmQ
  **************************************************************/
final class dHBnaZxmQ //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  CkBxcepSH m_start;
  CkBxcepSH m_end;
  
  /***************************************************************
    Function: dHBnaZxmQ
    **************************************************************/
  dHBnaZxmQ
    (
     )
      {
        m_start = null;
        m_end = null;
      }
}

/***************************************************************
  Class: zkBeKJFxt
  Description: 
 **************************************************************/
final class zkBeKJFxt //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private InputStream m_input; /* Java-Lez specification file. */

  private byte m_buffer[]; /* Input buffer. */
  private int m_buffer_read; /* Number of bytes read into input buffer. */
  private int m_buffer_index; /* Current index into input buffer. */

  boolean m_eof_reached; /* Whether EOF has been encountered. */
  boolean m_pushback_line; 

  char m_line[]; /* Line buffer. */
  int m_line_read; /* Number of bytes read into line buffer. */
  int m_line_index; /* Current index into line buffer. */

  int m_line_number; /* Current line number. */

  /***************************************************************
    Constants
    **************************************************************/
  private static final int BUFFER_SIZE = 1024;
  static final boolean EOF = true;
  static final boolean NOT_EOF = false;
  
  /***************************************************************
    Function: zkBeKJFxt
    Description: 
    **************************************************************/
  zkBeKJFxt
    (
     InputStream input
     )
      {
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != input);
          }

        /* Initialize input stream. */
        m_input = input;

        /* Initialize buffers and index counters. */
        m_buffer = new byte[BUFFER_SIZE];
        m_buffer_read = 0;
        m_buffer_index = 0;

        m_line = new char[BUFFER_SIZE];
        m_line_read = 0;
        m_line_index = 0;

        /* Initialize state variables. */
        m_eof_reached = false;
        m_line_number = 0;
        m_pushback_line = false;
      }

  /***************************************************************
    Function: getLine
    Description: Returns true on EOF, false otherwise.
    Guarantees not to return a blank line, or a line
    of zero length.
    **************************************************************/
  boolean getLine 
    (
     )
      throws java.io.IOException
      {
        int elem;
        
        /* Has EOF already been reached? */
        if (true == m_eof_reached)
          {
            if (FOVOvCcFg.OLD_DEBUG)
              {
                System.out.print("Line 1: ");
                System.out.print(new String(m_line,0,
                                            m_line_read));
              }

            return true;
          }
        
        /* Pushback current line? */
        if (true == m_pushback_line)
          {
            m_pushback_line = false;

            /* Check for empty line. */
            for (elem = 0; elem < m_line_read; ++elem)
              {
                if (false == FOVOvCcFg.isspace(m_line[elem]))
                  {
                    break;
                  }
              }

            /* Nonempty? */
            if (elem < m_line_read)
              {
                m_line_index = 0;
                return false;
              }

            if (FOVOvCcFg.OLD_DEBUG)
              {
                System.out.print("Line 2: ");
                System.out.print(new String(m_line,0,
                                            m_line_read));
              }
          }

        while (true)
          {
            /* Refill buffer? */
            if (m_buffer_index >= m_buffer_read)
              {
                m_buffer_read = m_input.read(m_buffer);
                if (-1 == m_buffer_read)
                  {
                    m_eof_reached = true;

                    if (FOVOvCcFg.OLD_DEBUG)
                      {
                        System.out.print("Line 3: ");
                        System.out.print(new String(m_line,0,
                                                    m_line_read));
                      }
                    
                    m_line_index = 0;
                    return true;
                  }
                m_buffer_index = 0;
              }
            
            m_line_read = 0;
            while ((byte) '\n' != m_buffer[m_buffer_index])
              {
                m_line[m_line_read] = (char) m_buffer[m_buffer_index];

                ++m_buffer_index;
                
                /* Refill buffer? */
                if (m_buffer_index >= m_buffer_read)
                  {
                    m_buffer_read = m_input.read(m_buffer);
                    if (-1 == m_buffer_read)
                      {
                        m_eof_reached = true;

                        /* Check for empty lines and discard them. */
                        elem = 0;
                        while (FOVOvCcFg.isspace(m_line[elem])) 
                          {
                            ++elem;
                            if (elem == m_line_read)
                              {
                                break;
                              }
                          }
                        
                        if (elem < m_line_read)
                          {                       
                            if (FOVOvCcFg.OLD_DEBUG)
                              {
                                System.out.print("Line 4:");
                                System.out.print(new String(m_line,
                                                            0,
                                                            m_line_read));
                              }
                            
                              
                            m_line_index = 0;
                            return false;
                          }

                        if (FOVOvCcFg.OLD_DEBUG)
                          {
                            System.out.print("Line <e>:");
                            System.out.print(new String(m_line,0,
                                                    m_line_read));
                          }

                        m_line_index = 0;
                        return true;
                      }

                    m_buffer_index = 0;
                  }

                ++m_line_read;

                /* Resize line buffer? */
                if (m_line_read >= m_line.length)
                  {
                    m_line = FOVOvCcFg.doubleSize(m_line);
                  }
              }
            /* Save newline in buffer. */
            m_line[m_line_read] = (char) m_buffer[m_buffer_index];
            ++m_line_read;
            ++m_buffer_index;
            ++m_line_number;
            
            /* Check for empty lines and discard them. */
            elem = 0;
            while (FOVOvCcFg.isspace(m_line[elem])) 
              {
                ++elem;
                if (elem == m_line_read)
                  {
                    break;
                  }
              }
            
            if (elem < m_line_read)
              {
                break;
              }
          }

        if (FOVOvCcFg.OLD_DEBUG)
          {
            System.out.print("Line <f>:");
            System.out.print(new String(m_line,0,m_line_read));
          }

        m_line_index = 0;
        return false;
      }
}

/********************************************************
  Class: Utility
  *******************************************************/
final class FOVOvCcFg  //**NS**
{
  /********************************************************
    Constants
    *******************************************************/
  static final boolean DEBUG = true;
  static final boolean SLOW_DEBUG = true;
  static final boolean DUMP_DEBUG = true;
  /*static final boolean DEBUG = false;
  static final boolean SLOW_DEBUG = false;
  static final boolean DUMP_DEBUG = false;*/
  
  static final boolean DESCENT_DEBUG = false;
  static final boolean OLD_DEBUG = false;
  static final boolean OLD_DUMP_DEBUG = false;
  static final boolean FOODEBUG = false;
  static final boolean DO_DEBUG = false;      
  
  /********************************************************
    Constants: Integer Bounds
    *******************************************************/
  static final int INT_MAX = 2147483647;

  /* UNDONE: What about other character values??? */
  static final int MAX_SEVEN_BIT = 127;
  static final int MAX_EIGHT_BIT = 256;

  /********************************************************
    Function: enter
    Description: Debugging routine.
    *******************************************************/
  static void enter
    (
     String descent,
     char lexeme,
     int token
     )
      {
        System.out.println("Entering " + descent 
                           + " [lexeme: " + lexeme 
                           + "] [token: " + token + "]");
      }

  /********************************************************
    Function: leave
    Description: Debugging routine.
    *******************************************************/
  static void leave
    (
     String descent,
     char lexeme,
     int token
     )
      {
        System.out.println("Leaving " + descent 
                           + " [lexeme:" + lexeme 
                           + "] [token:" + token + "]");
      }

  /********************************************************
    Function: assert
    Description: Debugging routine.
    *******************************************************/
  static void assert
    (
     boolean expr
     )
      {
        if (true == DEBUG && false == expr)
          {
            System.out.println("Assertion Failed");
            throw new Error("Assertion Failed.");
          }
      }

  /***************************************************************
    Function: doubleSize
    **************************************************************/
  static char[] doubleSize
    (
     char oldBuffer[]
     )
      {
        char newBuffer[] = new char[2 * oldBuffer.length];
        int elem;

        for (elem = 0; elem < oldBuffer.length; ++elem)
          {
            newBuffer[elem] = oldBuffer[elem];
          }

        return newBuffer;
      }

  /***************************************************************
    Function: doubleSize
    **************************************************************/
  static byte[] doubleSize
    (
     byte oldBuffer[]
     )
      {
        byte newBuffer[] = new byte[2 * oldBuffer.length];
        int elem;

        for (elem = 0; elem < oldBuffer.length; ++elem)
          {
            newBuffer[elem] = oldBuffer[elem];
          }

        return newBuffer;
      }

  /********************************************************
    Function: hex2bin
    *******************************************************/
  static char hex2bin
    (
     char c
     )
      {
        if ('0' <= c && '9' >= c)
          {
            return (char) (c - '0');
          }
        else if ('a' <= c && 'f' >= c)
          {
            return (char) (c - 'a' + 10);
          }         
        else if ('A' <= c && 'F' >= c)
          {
            return (char) (c - 'A' + 10);
          }
        
        pERmcHeDz.impos("Bad hexidecimal digit" + c);
        return 0;
      }

  /********************************************************
    Function: ishexdigit
    *******************************************************/
  static boolean ishexdigit
    (
     char c
     )
      {
        if (('0' <= c && '9' >= c)
            || ('a' <= c && 'f' >= c)
            || ('A' <= c && 'F' >= c))
          {
            return true;
          }

        return false;
      }

  /********************************************************
    Function: oct2bin
    *******************************************************/
  static char oct2bin
    (
     char c
     )
      {
        if ('0' <= c && '7' >= c)
          {
            return (char) (c - '0');
          }
        
        pERmcHeDz.impos("Bad octal digit " + c);
        return 0;
      }

  /********************************************************
    Function: isoctdigit
    *******************************************************/
  static boolean isoctdigit
    (
     char c
     )
      {
        if ('0' <= c && '7' >= c)
          {
            return true;
          }

        return false;
      }
        
  /********************************************************
    Function: isspace
    *******************************************************/
  static boolean isspace
    (
     char c
     )
      {
        if ('\b' == c 
            || '\t' == c
            || '\n' == c
            || '\f' == c
            || '\r' == c
            || ' ' == c)
          {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: isnewline
    *******************************************************/
  static boolean isnewline
    (
     char c
     )
      {
        if ('\n' == c
            || '\r' == c)
            {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: isalpha
    *******************************************************/
  static boolean isalpha
    (
     char c
     )
      {
        if (('a' <= c && 'z' >= c)
            || ('A' <= c && 'Z' >= c))
          {
            return true;
          }
        
        return false;
      }

  /********************************************************
    Function: toupper
    *******************************************************/
  static char toupper
    (
     char c
     )
      {
        if (('a' <= c && 'z' >= c))
          {
            return (char) (c - 'a' + 'A');
          }

        return c;
      }

  /********************************************************
    Function: bytencmp
    Description: Compares up to n elements of 
    byte array a[] against byte array b[].
    The first byte comparison is made between 
    a[a_first] and b[b_first].  Comparisons continue
    until the null terminating byte '\0' is reached
    or until n bytes are compared.
    Return Value: Returns 0 if arrays are the 
    same up to and including the null terminating byte 
    or up to and including the first n bytes,
    whichever comes first.
    *******************************************************/
  static int bytencmp
    (
     byte a[],
     int a_first,
     byte b[],
     int b_first,
     int n
     )
      {
        int elem;

        for (elem = 0; elem < n; ++elem)
          {
            /*System.out.print((char) a[a_first + elem]);
            System.out.print((char) b[b_first + elem]);*/
                             
            if ('\0' == a[a_first + elem] && '\0' == b[b_first + elem])
              {
                /*System.out.println("return 0");*/
                return 0;
              }
            if (a[a_first + elem] < b[b_first + elem])
              {
                /*System.out.println("return 1");*/
                return 1;
              }
            else if (a[a_first + elem] > b[b_first + elem])
              {
                /*System.out.println("return -1");*/
                return -1;
              }
          }

        /*System.out.println("return 0");*/
        return 0;
      }

  /********************************************************
    Function: charncmp
    *******************************************************/
  static int charncmp
    (
     char a[],
     int a_first,
     char b[],
     int b_first,
     int n
     )
      {
        int elem;

        for (elem = 0; elem < n; ++elem)
          {
            if ('\0' == a[a_first + elem] && '\0' == b[b_first + elem])
              {
                return 0;
              }
            if (a[a_first + elem] < b[b_first + elem])
              {
                return 1;
              }
            else if (a[a_first + elem] > b[b_first + elem])
              {
                return -1;
              }
          }

        return 0;
      }
}

/********************************************************
  Class: pERmcHeDz
  *******************************************************/
final class pERmcHeDz //**NS**
{
  /********************************************************
    Function: impos
    Description:
    *******************************************************/
  static void impos
    (
     String message
     )
      {
        System.out.println("Java-Lex Error: " + message);
      }

  /********************************************************
    Constants
    Description: Error codes for parse_error().
    *******************************************************/
  static final int E_BADEXPR = 0;
  static final int E_PAREN = 1;
  static final int E_LENGTH = 2;
  static final int E_BRACKET = 3;
  static final int E_BOL = 4;
  static final int E_CLOSE = 5;
  static final int E_NEWLINE = 6;
  static final int E_BADMAC = 7;
  static final int E_NOMAC = 8;
  static final int E_MACDEPTH = 9;
  static final int E_INIT = 10;
  static final int E_EOF = 11;
  static final int E_DIRECT = 12;
  static final int E_INTERNAL = 13;
  static final int E_STATE = 14;
  static final int E_MACDEF = 15;
  static final int E_SYNTAX = 16;
  static final int E_BRACE = 17;
  
  /********************************************************
    Constants
    Description: String messages for parse_error();
    *******************************************************/
  static final String errmsg[] = 
    {
      "Malformed regular expression.",
      "Missing close parenthesis.",
      "Too many regular expressions or expression too long.",
      "Missing [ in character class.",
      "^ must be at start of expression or after [.",
      "+ ? or * must follow an expression or subexpression.",
      "Newline in quoted string.",
      "Missing } in macro expansion.",
      "Macro does not exist.",
      "Macro expansions nested too deeply.",
      "Java-Lex has not been successfully initialized.",
      "Unexpected end-of-file found.",
      "Undefined or badly-formed Java-Lex directive.",
      "Internal Java-Lex error.",
      "Unitialized state name.",
      "Badly formed macro definition.",
      "Syntax error.",
      "Missing brace at start of lexical action."
    };
  
  /********************************************************
    Function: parse_error
    Description:
    *******************************************************/
  static void parse_error
    (
     int error_code,
     int line_number
     )
      {
        System.out.println("Error: Parse error at line " 
                           + line_number + ".");
        System.out.println("Error Description: " + errmsg[error_code]);
        throw new Error("Parse error.");
      }
}

/********************************************************
  Class: IxcsuvWDA
  *******************************************************/
final  class IxcsuvWDA 
{
  /********************************************************
    Member Variables
    *******************************************************/
  private BitSet m_set;
  private boolean m_complement;

  /********************************************************
    Function: IxcsuvWDA
    *******************************************************/
  IxcsuvWDA
    (
     )
    {
      m_set = new BitSet();
      m_complement = false;
    }

  /********************************************************
    Function: complement
    *******************************************************/
  void complement
    (
     )
      {
        m_complement = true;
      }

  /********************************************************
    Function: add
    *******************************************************/
  void add
    (
     int i
     )
      {
        m_set.set(i);
      }
  
  /********************************************************
    Function: contains
    *******************************************************/
  boolean contains
    (
     int i
     )
      {
        boolean result;
        
        result = m_set.get(i);
        
        if (true == m_complement)
          {
            return (false == result);
          }
        
        return result;
      }

  /********************************************************
    Function: mimic
    *******************************************************/
  void mimic
    (
     IxcsuvWDA set
     )
      {
        m_complement = set.m_complement;
        m_set = (BitSet) set.m_set.clone();
      } 
}

/********************************************************
  Class: CkBxcepSH
  *******************************************************/
final class CkBxcepSH //**NS**
{
  /********************************************************
    Member Variables
    *******************************************************/
  int m_edge;  /* Label for edge type:
                         character code, 
                         CCL (character class), 
                         [STATE,
                         SCL (state class),]
                         EMPTY, 
                         EPSILON. */
  
  IxcsuvWDA m_set;  /* Set to store character classes. */
  CkBxcepSH m_next;  /* Next state (or null if none). */
  
  CkBxcepSH m_next2;  /* Another state with type == EPSILON
                           and null if not used.  
                           The NFA construction should result in two
                           outgoing edges only if both are EPSILON edges. */
  
  IRxqsITZU m_accept;  /* Set to null if nonaccepting state. */
  int m_anchor;  /* Says if and where pattern is anchored. */

  int m_label;

  BitSet m_states;

  /********************************************************
    Constants
    *******************************************************/
  static final int NO_LABEL = -1;

  /********************************************************
    Constants: Edge Types
    Note: Edge transitions on one specific character
    are labelled with the character Ascii (Unicode)
    codes.  So none of the constants below should
    overlap with the natural character codes.
    *******************************************************/
  static final int CCL = -1;
  static final int EMPTY = -2;
  static final int EPSILON = -3;
   
  /********************************************************
    Function: CkBxcepSH
    *******************************************************/
 CkBxcepSH
    (
     )
    {
      m_edge = EMPTY;
      m_set = null;
      m_next = null;
      m_next2 = null;
      m_accept = null;
      m_anchor = drHChFQzb.NONE;
      m_label = NO_LABEL;
      m_states = null;
    }

  /********************************************************
    Function: mimic
    Description: Converts this NFA state into a copy of
    the input one.
    *******************************************************/
  void mimic
    (
     CkBxcepSH nfa
     )
      {
        m_edge = nfa.m_edge;
        
        if (null != nfa.m_set)
          {
            if (null == m_set)
              {
                m_set = new IxcsuvWDA();
              }
            m_set.mimic(nfa.m_set);
          }
        else
          {
            m_set = null;
          }

        m_next = nfa.m_next;
        m_next2 = nfa.m_next2;
        m_accept = nfa.m_accept;
        m_anchor = nfa.m_anchor;

        if (null != nfa.m_states)
          {
            m_states = (BitSet) nfa.m_states.clone();
          }
        else
          {
            m_states = null;
          }
      }
}

/***************************************************************
  Class: EpinONEnm
  **************************************************************/
final class EpinONEnm //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private InputStream m_instream; /* Java-Lex specification file. */
  private DataOutputStream m_outstream; /* Lexical analyzer source file. */

  private zkBeKJFxt m_input; /* Input buffer class. */

  private Hashtable m_tokens; /* Hashtable that maps characters to their 
                                 corresponding lexical code for
                                 the internal lexical analyzer. */
  private drHChFQzb m_spec; /* Spec class holds information
                           about the generated lexer. */
  private boolean m_init_flag; /* Flag set to true only upon 
                                  successful initialization. */

  private CJBXugDII m_makeNfa; /* NFA machine generator module. */
  private AMrQFMJUp m_nfa2dfa; /* NFA to DFA machine (transition table) 
                                 conversion module. */
  private gApUoJlkt m_minimize; /* Transition table compressor. */
  private nZFWRApBo m_emit; /* Output module that emits source code
                           into the generated lexer file. */


  /********************************************************
    Constants
    *******************************************************/
  private static final boolean ERROR = false;
  private static final boolean NOT_ERROR = true;
  private static final int BUFFER_SIZE = 1024;

  /********************************************************
    Constants: Token Types
    *******************************************************/
  static final int EOS = 1;
  static final int ANY = 2;
  static final int AT_BOL = 3;
  static final int AT_EOL = 4;
  static final int CCL_END = 5;
  static final int CCL_START = 6;
  static final int CLOSE_CURLY = 7;
  static final int CLOSE_PAREN = 8;
  static final int CLOSURE = 9;
  static final int DASH = 10;
  static final int END_OF_INPUT = 11;
  static final int L = 12;
  static final int OPEN_CURLY = 13;
  static final int OPEN_PAREN = 14;
  static final int OPTIONAL = 15;
  static final int OR = 16;
  static final int PLUS_CLOSE = 17;

  /***************************************************************
    Function: EpinONEnm
    **************************************************************/
  EpinONEnm 
    (
     String filename
     )
      throws java.io.FileNotFoundException, java.io.IOException
      {
        /* Successful initialization flag. */
        m_init_flag = false;
        
        /* Open input stream. */
        m_instream = new FileInputStream(filename);
        if (null == m_instream)
          {
            System.out.println("Error: Unable to open input file "
                               + filename + ".");
            return;
          }

        /* Open output stream. */
        m_outstream = new DataOutputStream(
                        /*new BufferedOutputStream(*/
                          new FileOutputStream(filename + ".java")/*)*/); //**NS**
        if (null == m_outstream)
          {
            System.out.println("Error: Unable to open output file "
                               + filename + ".java.");
            return;
          }

        /* Create input buffer class. */
        m_input = new zkBeKJFxt(m_instream);

        /* Initialize character hash table. */
        m_tokens = new Hashtable();
        m_tokens.put(new Character('$'),new Integer(AT_EOL));
        m_tokens.put(new Character('('),new Integer(OPEN_PAREN));
        m_tokens.put(new Character(')'),new Integer(CLOSE_PAREN));
        m_tokens.put(new Character('*'),new Integer(CLOSURE));
        m_tokens.put(new Character('+'),new Integer(PLUS_CLOSE));
        m_tokens.put(new Character('-'),new Integer(DASH));
        m_tokens.put(new Character('.'),new Integer(ANY));
        m_tokens.put(new Character('?'),new Integer(OPTIONAL));
        m_tokens.put(new Character('['),new Integer(CCL_START));
        m_tokens.put(new Character(']'),new Integer(CCL_END));
        m_tokens.put(new Character('^'),new Integer(AT_BOL));
        m_tokens.put(new Character('{'),new Integer(OPEN_CURLY));
        m_tokens.put(new Character('|'),new Integer(OR));
        m_tokens.put(new Character('}'),new Integer(CLOSE_CURLY));
      
        /* Initialize spec structure. */
        m_spec = new drHChFQzb(this);
        
        /* Nfa to dfa converter. */
        m_nfa2dfa = new AMrQFMJUp();
        m_minimize = new gApUoJlkt();
        m_makeNfa = new CJBXugDII();

        m_emit = new nZFWRApBo();

        /* Successful initialization flag. */
        m_init_flag = true;
      }

  /***************************************************************
    Function: generate
    Description: 
    **************************************************************/
  void generate
    (
     )
      throws java.io.IOException, java.io.FileNotFoundException
      {
        if (false == m_init_flag)
          {
            pERmcHeDz.parse_error(pERmcHeDz.E_INIT,0);
          }

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != this);
            FOVOvCcFg.assert(null != m_outstream);
            FOVOvCcFg.assert(null != m_input);
            FOVOvCcFg.assert(null != m_tokens);
            FOVOvCcFg.assert(null != m_spec);
            FOVOvCcFg.assert(true == m_init_flag);
          }

        /*m_emit.emit_imports(m_spec,m_outstream);*/

        if (m_spec.m_verbose)
          {
            System.out.println("Processing first section -- user code.");
          }
        userCode();
        if (true == m_input.m_eof_reached)
          {
            pERmcHeDz.parse_error(pERmcHeDz.E_EOF,m_input.m_line_number);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Processing second section -- " 
                               + "Java-Lex declarations.");
          }
        userDeclare();
        if (true == m_input.m_eof_reached)
          {
            pERmcHeDz.parse_error(pERmcHeDz.E_EOF,m_input.m_line_number);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Processing third section -- lexical rules.");
          }
        userRules();
        if (true == FOVOvCcFg.DO_DEBUG)
          {
            print_header();
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Outputting lexical analyzer code.");
          }
        m_emit.emit(m_spec,m_outstream);

        if (m_spec.m_verbose && true == FOVOvCcFg.OLD_DUMP_DEBUG)
          {
            details();
          }
      }

  /***************************************************************
    Function: userCode
    Description: Process first section of specification,
    echoing it into output file.
    **************************************************************/
  private void userCode
    (
     )
      throws java.io.IOException
      {
        int count = 0;

        if (false == m_init_flag)
          {
            pERmcHeDz.parse_error(pERmcHeDz.E_INIT,0);
          }

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != this);
            FOVOvCcFg.assert(null != m_outstream);
            FOVOvCcFg.assert(null != m_input);
            FOVOvCcFg.assert(null != m_tokens);
            FOVOvCcFg.assert(null != m_spec);
          }

        if (true == m_input.m_eof_reached)
          {
            pERmcHeDz.parse_error(pERmcHeDz.E_EOF,0);
          }

        while (true)
          {
            if (true == m_input.getLine())
              {
                /* Eof reached. */
                pERmcHeDz.parse_error(pERmcHeDz.E_EOF,0);
              }
            
            if (2 <= m_input.m_line_read 
                && '%' == m_input.m_line[0]
                && '%' == m_input.m_line[1])
              {
                /* Discard remainder of line. */
                m_input.m_line_index = m_input.m_line_read;
                return;
              }

            m_outstream.writeBytes(new String(m_input.m_line,0,
                                              m_input.m_line_read));
          }
      }

  /***************************************************************
    Function: getName
    **************************************************************/
  private char[] getName
    (
     )
      {
        char buffer[];
        int elem;

        /* Skip white space. */
        while (m_input.m_line_index < m_input.m_line_read
               && true == FOVOvCcFg.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
          }

        /* No name? */
        if (m_input.m_line_index >= m_input.m_line_read)
          {
            pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,0);
          }

        /* Determine length. */
        elem = m_input.m_line_index;
        while (elem < m_input.m_line_read
               && false == FOVOvCcFg.isnewline(m_input.m_line[elem]))
          {
            ++elem;
          } 

        /* Allocate non-terminated buffer of exact length. */
        buffer = new char[elem - m_input.m_line_index];
        
        /* Copy. */
        elem = 0;
        while (m_input.m_line_index < m_input.m_line_read
               && false == FOVOvCcFg.isnewline(m_input.m_line[m_input.m_line_index]))
          {
            buffer[elem] = m_input.m_line[m_input.m_line_index];
            ++elem;
            ++m_input.m_line_index;
          }

        return buffer;
      }

  private static final int CLASS_CODE = 0;       //**NS**
  private static final int INIT_CODE = 1;        //**NS**
  private static final int EOF_CODE = 2;         //**NS**
  private static final int INIT_THROW_CODE = 3;  //**NS**
  private static final int YYLEX_THROW_CODE = 4; //**NS**
  private static final int EOF_THROW_CODE = 5;   //**NS**
  private static final int EOF_VALUE_CODE = 6;   //**NS**

  /***************************************************************
    Function: packCode
    Description:
    **************************************************************/
  private char[] packCode
    (
     char start_dir[],
     char end_dir[],
     char prev_code[],
     int prev_read,
     int specified
     )
      throws java.io.IOException
      {
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(INIT_CODE == specified 
                            || CLASS_CODE == specified
                            || EOF_CODE == specified
                            || EOF_VALUE_CODE == specified
                            || INIT_THROW_CODE == specified
                            || YYLEX_THROW_CODE == specified
                            || EOF_THROW_CODE == specified);
          }

        if (0 != FOVOvCcFg.charncmp(m_input.m_line,
                                   0,
                                   start_dir,
                                   0,
                                   start_dir.length - 1))
          {
            pERmcHeDz.parse_error(pERmcHeDz.E_INTERNAL,0);
          }
        
        if (null == prev_code)
          {
            prev_code = new char[BUFFER_SIZE];
            prev_read = 0;
          }
        
        if (prev_read >= prev_code.length)
          {
            prev_code = FOVOvCcFg.doubleSize(prev_code);
          }
        
        m_input.m_line_index = start_dir.length - 1;
        while (true)
          {
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    pERmcHeDz.parse_error(pERmcHeDz.E_EOF,m_input.m_line_number);
                  }
                
                if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                           0,
                                           end_dir,
                                           0,
                                           end_dir.length - 1))
                  {
                    m_input.m_line_index = end_dir.length - 1;
                    
                    switch (specified)
                      {
                      case CLASS_CODE:
                        m_spec.m_class_read = prev_read;
                        break;
                        
                      case INIT_CODE:
                        m_spec.m_init_read = prev_read;
                        break;
                        
                      case EOF_CODE:
                        m_spec.m_eof_read = prev_read;
                        break;

                      case EOF_VALUE_CODE:
                        m_spec.m_eof_value_read = prev_read;
                        break;

                      case INIT_THROW_CODE:
                        m_spec.m_init_throw_read = prev_read;
                        break;

                      case YYLEX_THROW_CODE:
                        m_spec.m_yylex_throw_read = prev_read;
                        break;
                        
                      case EOF_THROW_CODE:
                        m_spec.m_eof_throw_read = prev_read;
                        break;
                        
                      default:
                        pERmcHeDz.parse_error(pERmcHeDz.E_INTERNAL,m_input.m_line_number);
                        break;
                      }

                    return prev_code;
                  }
              }

            while (m_input.m_line_index < m_input.m_line_read)
              {
                prev_code[prev_read] = m_input.m_line[m_input.m_line_index];
                ++prev_read;
                ++m_input.m_line_index;

                if (prev_read >= prev_code.length)
                  {
                    prev_code = FOVOvCcFg.doubleSize(prev_code);
                  }
              }
          }
      }

  /***************************************************************
    Member Variables: Java-Lex directives.
    **************************************************************/
  private char m_state_dir[] = { 
    '%', 's', 't', 
    'a', 't', 'e',
    '\0'
    };
  
  private char m_char_dir[] = { 
    '%', 'c', 'h',
    'a', 'r',
    '\0'
    };

  private char m_line_dir[] = { 
    '%', 'l', 'i',
    'n', 'e',
    '\0'
    };

  private char m_cup_dir[] = { 
    '%', 'c', 'u',
    'p', 
    '\0'
    };

  private char m_class_dir[] = { 
    '%', 'c', 'l', 
    'a', 's', 's',
    '\0'
    };

  private char m_function_dir[] = { 
    '%', 'f', 'u',
    'n', 'c', 't',
    'i', 'o', 'n',
    '\0'
    };

  private char m_type_dir[] = { 
    '%', 't', 'y',
    'p', 'e',
    '\0'
    };

  private char m_integer_dir[] = { 
    '%', 'i', 'n',
    't', 'e', 'g', 
    'e', 'r',
    '\0'
    };

  private char m_intwrap_dir[] = { 
    '%', 'i', 'n',
    't', 'w', 'r', 
    'a', 'p',
    '\0'
    };

  private char m_full_dir[] = { 
    '%', 'f', 'u', 
    'l', 'l',
    '\0'
    };

  private char m_unicode_dir[] = { 
    '%', 'u', 'n', 
    'i', 'c', 'o',
    'd', 'e',
    '\0'
    };

  private char m_notunix_dir[] = { 
    '%', 'n', 'o',
    't', 'u', 'n', 
    'i', 'x',
    '\0'
    };

  private char m_init_code_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', '{',
    '\0'
    };

  private char m_init_code_end_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', '}',
    '\0'
    };

  private char m_init_throw_code_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', 't',
    'h', 'r', 'o',
    'w', '{',
    '\0'
    };

  private char m_init_throw_code_end_dir[] = { 
    '%', 'i', 'n', 
    'i', 't', 't',
    'h', 'r', 'o',
    'w', '}',
    '\0'
    };

  private char m_yylex_throw_code_dir[] = { 
    '%', 'y', 'y', 'l', 
    'e', 'x', 't',
    'h', 'r', 'o',
    'w', '{',
    '\0'
    };

  private char m_yylex_throw_code_end_dir[] = { 
    '%', 'y', 'y', 'l', 
    'e', 'x', 't',
    'h', 'r', 'o',
    'w', '}',
    '\0'
    };

  private char m_eof_code_dir[] = { 
    '%', 'e', 'o', 
    'f', '{',
    '\0'
    };

  private char m_eof_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', '}',
    '\0'
    };

  private char m_eof_value_code_dir[] = { 
    '%', 'e', 'o', 
    'f', 'v', 'a', 
    'l', '{',
    '\0'
    };

  private char m_eof_value_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', 'v', 'a',
    'l', '}',
    '\0'
    };

  private char m_eof_throw_code_dir[] = { 
    '%', 'e', 'o', 
    'f', 't', 'h',
    'r', 'o', 'w',
    '{',
    '\0'
    };

  private char m_eof_throw_code_end_dir[] = { 
    '%', 'e', 'o', 
    'f', 't', 'h',
    'r', 'o', 'w',
    '}',
    '\0'
    };

  private char m_class_code_dir[] = { 
    '%', '{',
    '\0'
    };

  private char m_class_code_end_dir[] = { 
    '%', '}',
    '\0'
    };

  private char m_yyeof_dir[] = { 
    '%', 'y', 'y',
    'e', 'o', 'f',
    '\0'
    };
  
  /***************************************************************
    Function: userDeclare
    Description:
    **************************************************************/
  private void userDeclare
    (
     )
      throws java.io.IOException
        {
          int elem;
          
          if (FOVOvCcFg.DEBUG)
            {
              FOVOvCcFg.assert(null != this);
              FOVOvCcFg.assert(null != m_outstream);
              FOVOvCcFg.assert(null != m_input);
              FOVOvCcFg.assert(null != m_tokens);
              FOVOvCcFg.assert(null != m_spec);
            }

          if (true == m_input.m_eof_reached)
            {
              /* End-of-file. */
              pERmcHeDz.parse_error(pERmcHeDz.E_EOF,
                                 m_input.m_line_number);
            }

          while (false == m_input.getLine())
            {
              /* Look for double percent. */
              if (2 <= m_input.m_line_read 
                  && '%' == m_input.m_line[0] 
                  && '%' == m_input.m_line[1])
                {
                  /* Mess around with line. */
                  for (elem = 0; elem < m_input.m_line.length - 2; ++elem)
                    {
                      m_input.m_line[elem] = m_input.m_line[elem + 2];
                    }
                  m_input.m_line_read = m_input.m_line_read - 2;

                  m_input.m_pushback_line = true;
                  /* Check for and discard empty line. */
                  if (0 == m_input.m_line_read 
                      || '\n' == m_input.m_line[0])
                    {
                      m_input.m_pushback_line = false;
                    }

                  return;
                }

              if (0 == m_input.m_line_read)
                {
                  continue;
                }

              if ('%' == m_input.m_line[0])
                {
                  /* Special lex declarations. */
                  if (1 >= m_input.m_line_read)
                    {
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      continue;
                    }

                  switch (m_input.m_line[1])
                    {
                    case '{':
                      if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                 0,
                                                 m_class_code_dir,
                                                 0,
                                                 m_class_code_dir.length - 1))
                        {
                          m_spec.m_class_code = packCode(m_class_code_dir,
                                                         m_class_code_end_dir,
                                                         m_spec.m_class_code,
                                                         m_spec.m_class_read,
                                                         CLASS_CODE);
                          break;
                        }
              
                      /* Bad directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'c':
                      if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                 0,
                                                 m_char_dir,
                                                 0,
                                                 m_char_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_char_dir.length;
                          m_spec.m_count_chars = true;
                          break;
                        }       
                      else if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                      0,
                                                      m_cup_dir,
                                                      0,
                                                      m_cup_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_cup_dir.length;
                          m_spec.m_cup_compatible = true;
                          break;
                        }
                      else if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                      0,
                                                      m_class_dir, 
                                                      0,
                                                      m_class_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_class_dir.length;
                          m_spec.m_class_name = getName();
                          break;
                        }
              
                      /* Bad directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                      
                    case 'e':
                      if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                 0,
                                                 m_eof_code_dir,
                                                 0,
                                                 m_eof_code_dir.length - 1))
                        {
                          m_spec.m_eof_code = packCode(m_eof_code_dir,
                                                       m_eof_code_end_dir,
                                                       m_spec.m_eof_code,
                                                       m_spec.m_eof_read,
                                                       EOF_CODE);
                          break;
                        }
                      else if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                      0,
                                                      m_eof_value_code_dir,
                                                      0,
                                                      m_eof_value_code_dir.length - 1))
                        {
                          m_spec.m_eof_value_code = packCode(m_eof_value_code_dir,
                                                             m_eof_value_code_end_dir,
                                                             m_spec.m_eof_value_code,
                                                             m_spec.m_eof_value_read,
                                                             EOF_VALUE_CODE);
                          break;
                        }
                      else if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                      0,
                                                      m_eof_throw_code_dir,
                                                      0,
                                                      m_eof_throw_code_dir.length - 1))
                        {
                          m_spec.m_eof_throw_code = packCode(m_eof_throw_code_dir,
                                                       m_eof_throw_code_end_dir,
                                                       m_spec.m_eof_throw_code,
                                                       m_spec.m_eof_throw_read,
                                                       EOF_THROW_CODE);
                          break;
                        }
              
                      /* Bad directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'f':
                      if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                 0,
                                                 m_function_dir,
                                                 0,
                                                 m_function_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_function_dir.length;
                          m_spec.m_function_name = getName();
                          break;
                        }
                      else if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                      0,
                                                      m_full_dir,
                                                      0,
                                                      m_full_dir.length - 1))
                        {
                          m_input.m_line_index = m_full_dir.length;
                          m_spec.m_dtrans_ncols = FOVOvCcFg.MAX_EIGHT_BIT + 1;
                          break;
                        }

                      /* Bad directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'i':
                      if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                 0,
                                                 m_integer_dir,
                                                 0,
                                                 m_integer_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_integer_dir.length;
                          m_spec.m_integer_type = true;
                          break;
                        }
                      else if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                      0,
                                                      m_intwrap_dir,
                                                      0,
                                                      m_intwrap_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_integer_dir.length;
                          m_spec.m_intwrap_type = true;
                          break;
                        }
                      else if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                      0,
                                                      m_init_code_dir,
                                                      0,
                                                      m_init_code_dir.length - 1))
                        {
                          m_spec.m_init_code = packCode(m_init_code_dir,
                                                        m_init_code_end_dir,
                                                        m_spec.m_init_code,
                                                        m_spec.m_init_read,
                                                        INIT_CODE);
                          break;
                        }
                      else if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                      0,
                                                      m_init_throw_code_dir,
                                                      0,
                                                      m_init_throw_code_dir.length - 1))
                        {
                          m_spec.m_init_throw_code = packCode(m_init_throw_code_dir,
                                                       m_init_throw_code_end_dir,
                                                       m_spec.m_init_throw_code,
                                                       m_spec.m_init_throw_read,
                                                       INIT_THROW_CODE);
                          break;
                        }

                      /* Bad directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'l':
                      if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                 0,
                                                 m_line_dir,
                                                 0,
                                                 m_line_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_line_dir.length;
                          m_spec.m_count_lines = true;
                          break;
                        }

                      /* Bad directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'n':
                      if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                 0,
                                                 m_notunix_dir,
                                                 0,
                                                 m_notunix_dir.length - 1))
                        {
                          /* Set line counting to ON. */
                          m_input.m_line_index = m_notunix_dir.length;
                          m_spec.m_unix = false;
                          break;
                        }

                      /* Bad directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 's':
                      if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                 0,
                                                 m_state_dir,
                                                 0,
                                                 m_state_dir.length - 1))
                        {
                          /* Recognize state list. */
                          m_input.m_line_index = m_state_dir.length;
                          saveStates();
                          break;
                        }

                      /* Undefined directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                     
                    case 't':
                      if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                 0,
                                                 m_type_dir,
                                                 0,
                                                 m_type_dir.length - 1))
                        {
                          /* Set Java CUP compatibility to ON. */
                          m_input.m_line_index = m_type_dir.length;
                          m_spec.m_type_name = getName();
                          break;
                        }

                      /* Undefined directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'u':
                      if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                 0,
                                                 m_unicode_dir,
                                                 0,
                                                 m_unicode_dir.length - 1))
                        {
                          m_input.m_line_index = m_unicode_dir.length;
                          /* UNDONE: What to do here? */
                          break;
                        }

                      /* Bad directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    case 'y':
                      if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                 0,
                                                 m_yyeof_dir,
                                                 0,
                                                 m_yyeof_dir.length - 1))
                        {
                          m_input.m_line_index = m_yyeof_dir.length;
                          m_spec.m_yyeof = true;
                          break;
                        } else if (0 == FOVOvCcFg.charncmp(m_input.m_line,
                                                          0,
                                                          m_yylex_throw_code_dir,
                                                          0,
                                                          m_yylex_throw_code_dir.length - 1))
                        {
                          m_spec.m_yylex_throw_code = packCode(m_yylex_throw_code_dir,
                                                               m_yylex_throw_code_end_dir,
                                                       m_spec.m_yylex_throw_code,
                                                       m_spec.m_yylex_throw_read,
                                                       YYLEX_THROW_CODE);
                          break;
                        }


                      /* Bad directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;

                    default:
                      /* Undefined directive. */
                      pERmcHeDz.parse_error(pERmcHeDz.E_DIRECT,
                                         m_input.m_line_number);
                      break;
                    }
                }
              else
                {
                  /* Regular expression macro. */
                  m_input.m_line_index = 0;
                  saveMacro();
                }

              if (FOVOvCcFg.OLD_DEBUG)
                {
                  System.out.println("Line number " 
                                     + m_input.m_line_number + ":"); 
                  System.out.print(new String(m_input.m_line,
                                              0,m_input.m_line_read));
                }
            }
        }
         
  /***************************************************************
    Function: userRules
    Description: Processes third section of Java-Lex 
    specification and creates minimized transition table.
    **************************************************************/
  private void userRules
    (
     )
      throws java.io.IOException
      {
        int code;

        if (false == m_init_flag)
          {
            pERmcHeDz.parse_error(pERmcHeDz.E_INIT,0);
          }

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != this);
            FOVOvCcFg.assert(null != m_outstream);
            FOVOvCcFg.assert(null != m_input);
            FOVOvCcFg.assert(null != m_tokens);
            FOVOvCcFg.assert(null != m_spec);
          }

        /* UNDONE: Need to handle states preceding rules. */
        
        if (m_spec.m_verbose)
          {
            System.out.println("Creating NFA machine representation.");
          }
        m_makeNfa.thompson(this,m_spec,m_input);
        
        /*print_nfa();*/

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(END_OF_INPUT == m_spec.m_current_token);
          }

        if (m_spec.m_verbose)
          {
            System.out.println("Creating DFA transition table.");
          }
        m_nfa2dfa.make_dfa(this,m_spec);

        if (FOVOvCcFg.FOODEBUG) {
          print_header();
        }

        if (m_spec.m_verbose)
          {
            System.out.println("Minimizing DFA transition table.");
          }
        m_minimize.min_dfa(m_spec);
      }

  /***************************************************************
    Function: printccl
    Description: Debuggng routine that outputs readable form
    of character class.
    **************************************************************/
  private void printccl
    (
     IxcsuvWDA set
     )
      {
        int i;
        
        System.out.print(" [");
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (true == set.contains(i))
              {
                System.out.print(interp_int(i));
              }
          }
        System.out.print(']');
      }

  /***************************************************************
    Function: plab
    Description:
    **************************************************************/
  private String plab
    (
     CkBxcepSH state
     )
      {
        int index;
        
        if (null == state)
          {
            return (new String("--"));
          }

        index = m_spec.m_nfa_states.indexOf(state);
        
        return ((new Integer(index)).toString());
      }

  /***************************************************************
    Function: interp_int
    Description:
    **************************************************************/
  private String interp_int
    (
     int i
     )
      {
        switch (i)
          {
          case (int) '\b':
            return (new String("\\b"));

          case (int) '\t':
            return (new String("\\t"));

          case (int) '\n':
            return (new String("\\n"));

          case (int) '\f':
            return (new String("\\f"));

          case (int) '\r':
            return (new String("\\r"));
            
          case (int) ' ':
            return (new String("\\ "));
            
          default:
            return ((new Character((char) i)).toString());
          }
      }

  /***************************************************************
    Function: print_nfa
    Description:
    **************************************************************/
  void print_nfa
    (
     )
      {
        int elem;
        CkBxcepSH nfa;
        int size;
        Enumeration states;
        Integer index;
        int i;
        int j;
        int vsize;
        String state;
     
        System.out.println("--------------------- NFA -----------------------");
        
        size = m_spec.m_nfa_states.size();
        for (elem = 0; elem < size; ++elem)
          {
            nfa = (CkBxcepSH) m_spec.m_nfa_states.elementAt(elem);
            
            System.out.print("Nfa state " + plab(nfa) + ": ");
            
            if (null == nfa.m_next)
              {
                System.out.print("(TERMINAL)");
              }
            else
              {
                System.out.print("--> " + plab(nfa.m_next));
                System.out.print("--> " + plab(nfa.m_next2));
                
                switch (nfa.m_edge)
                  {
                  case CkBxcepSH.CCL:
                    printccl(nfa.m_set);
                    break;

                  case CkBxcepSH.EPSILON:
                    System.out.print(" EPSILON ");
                    break; 
                    
                  default:
                    System.out.print(" " + interp_int(nfa.m_edge));
                    break;
                  }
              }

            if (0 == elem)
              {
                System.out.print(" (START STATE)");
              }
            
            if (null != nfa.m_accept)
              {
                System.out.print(" accepting " 
                                 + ((0 != (nfa.m_anchor & drHChFQzb.START)) ? "^" : "")
                                 + "<" 
                                 + (new String(nfa.m_accept.m_action,0,
                                               nfa.m_accept.m_action_read))
                                 + ">"
                                 + ((0 != (nfa.m_anchor & drHChFQzb.END)) ? "$" : ""));
              }

            System.out.println("");
          }

        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(null != state);
                FOVOvCcFg.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");
            System.out.print("\tStart states of matching rules: ");
            
            i = index.intValue();
            vsize = m_spec.m_state_rules[i].size();
            
            for (j = 0; j < vsize; ++j)
              {
                nfa = (CkBxcepSH) m_spec.m_state_rules[i].elementAt(j);

                System.out.print(m_spec.m_nfa_states.indexOf(nfa) + " ");
              }

            System.out.println("");
          }

        System.out.println("-------------------- NFA ----------------------");
      }

  /***************************************************************
    Function: getStates
    Description: Parses the state area of a rule,
    from the beginning of a line.
    < state1, state2 ... > regular_expression { action }
    Returns null on only EOF.  Returns all_states, 
    initialied properly to correspond to all states,
    if no states are found.
    Special Notes: This function treats commas as optional
    and permits states to be spread over multiple lines.
    **************************************************************/
  private BitSet all_states = null;
  BitSet getStates
    (
     )
      throws java.io.IOException
      {
        int start_state;
        int count_state;
        BitSet states;
        String name;
        Integer index;
        int i;
        int size;
        
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != this);
            FOVOvCcFg.assert(null != m_outstream);
            FOVOvCcFg.assert(null != m_input);
            FOVOvCcFg.assert(null != m_tokens);
            FOVOvCcFg.assert(null != m_spec);
          }

        states = null;

        /* Skip white space. */
        while (true == FOVOvCcFg.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
    
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                /* Must just be an empty line. */
                if (true == m_input.getLine())
                  {
                    /* EOF found. */
                    return null;
                  }
              }
          }

        /* Look for states. */
        if ('<' == m_input.m_line[m_input.m_line_index])
          {
            ++m_input.m_line_index;
           
            states = new BitSet();

            /* Parse states. */
            while (true)
              {
                /* We may have reached the end of the line. */
                while (m_input.m_line_index >= m_input.m_line_read)
                  {
                    if (true == m_input.getLine())
                      {
                        /* EOF found. */
                        pERmcHeDz.parse_error(pERmcHeDz.E_EOF,m_input.m_line_number);
                        return states;
                      }
                  }

                while (true)
                  {
                    /* Skip white space. */
                    while (true == FOVOvCcFg.isspace(m_input.m_line[m_input.m_line_index]))
                      {
                        ++m_input.m_line_index;
                        
                        while (m_input.m_line_index >= m_input.m_line_read)
                          {
                            if (true == m_input.getLine())
                              {
                                /* EOF found. */
                                pERmcHeDz.parse_error(pERmcHeDz.E_EOF,m_input.m_line_number);
                                return states;
                              }
                          }
                      }
                    
                    if (',' != m_input.m_line[m_input.m_line_index])
                      {
                        break;
                      }

                    ++m_input.m_line_index;
                  }

                if ('>' == m_input.m_line[m_input.m_line_index])
                  {
                    ++m_input.m_line_index;
                    if (m_input.m_line_index < m_input.m_line_read)
                      {
                        m_advance_stop = true;
                      }
                    return states;
                  }

                /* Read in state name. */
                start_state = m_input.m_line_index;
                while (false == FOVOvCcFg.isspace(m_input.m_line[m_input.m_line_index])
                       && ',' != m_input.m_line[m_input.m_line_index]
                       && '>' != m_input.m_line[m_input.m_line_index])
                  {
                    ++m_input.m_line_index;

                    if (m_input.m_line_index >= m_input.m_line_read)
                      {
                        /* End of line means end of state name. */
                        break;
                      }
                  }
                count_state = m_input.m_line_index - start_state;

                /* Save name after checking definition. */
                name = new String(m_input.m_line,
                                  start_state,
                                  count_state);
                index = (Integer) m_spec.m_states.get(name);
                if (null == index)
                  {
                    /* Uninitialized state. */
                    System.out.println("Uninitialized State Name: " + name);
                    pERmcHeDz.parse_error(pERmcHeDz.E_STATE,m_input.m_line_number);
                  }
                states.set(index.intValue());
              }
          }
        
        if (null == all_states)
          {
            all_states = new BitSet();

            size = m_spec.m_states.size();
            for (i = 0; i < size; ++i)
              {
                all_states.set(i);
              }
          }
        
        if (m_input.m_line_index < m_input.m_line_read)
          {
            m_advance_stop = true;
          }
        return all_states;
      }

  /********************************************************
    Function: expandMacro
    Description: Returns false on error, true otherwise. 
    *******************************************************/
  private boolean expandMacro
    (
     )
      {
        int elem;
        int start_macro;
        int end_macro;
        int start_name;
        int count_name;
        String def;
        int def_elem;
        String name;
        char replace[];
        int rep_elem;

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != this);
            FOVOvCcFg.assert(null != m_outstream);
            FOVOvCcFg.assert(null != m_input);
            FOVOvCcFg.assert(null != m_tokens);
            FOVOvCcFg.assert(null != m_spec);
          }

        /* Check for macro. */
        if ('{' != m_input.m_line[m_input.m_line_index])
          {
            pERmcHeDz.parse_error(pERmcHeDz.E_INTERNAL,m_input.m_line_number);
            return ERROR;
          }
        
        start_macro = m_input.m_line_index;
        elem = m_input.m_line_index + 1;
        if (elem >= m_input.m_line_read)
          {
            pERmcHeDz.impos("Unfinished macro name");
            return ERROR;
          }
        
        /* Get macro name. */
        start_name = elem;
        while ('}' != m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                pERmcHeDz.impos("Unfinished macro name at line " + m_input.m_line_number);
                return ERROR;
              }
          }
        count_name = elem - start_name;
        end_macro = elem;

        /* Check macro name. */
        if (0 == count_name)
          {
            pERmcHeDz.impos("Nonexistent macro name");
            return ERROR;
          }

        /* Debug checks. */
        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(0 < count_name);
          }

        /* Retrieve macro definition. */
        name = new String(m_input.m_line,start_name,count_name);
        def = (String) m_spec.m_macros.get(name);
        if (null == def)
          {
            pERmcHeDz.impos("Undefined macro \"" + name + "\" on line: "+m_input.m_line_number);
            return ERROR;
          }
        if (FOVOvCcFg.OLD_DUMP_DEBUG)
          {
            System.out.println("expanded escape: " + def);
          }
                
        /* Replace macro in new buffer,
           beginning by copying first part of line buffer. */
        replace = new char[m_input.m_line.length];
        for (rep_elem = 0; rep_elem < start_macro; ++rep_elem)
          {
            replace[rep_elem] = m_input.m_line[rep_elem];

            if (FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(rep_elem < replace.length);
              }
          }
        
        /* Copy macro definition. */
        if (rep_elem >= replace.length)
          {
            replace = FOVOvCcFg.doubleSize(replace);
          }
        for (def_elem = 0; def_elem < def.length(); ++def_elem)
          {
            replace[rep_elem] = def.charAt(def_elem);
            
            ++rep_elem;
            if (rep_elem >= replace.length)
              {
                replace = FOVOvCcFg.doubleSize(replace);
              }
          }

        /* Copy last part of line. */
        if (rep_elem >= replace.length)
          {
            replace = FOVOvCcFg.doubleSize(replace);
          }
        for (elem = end_macro + 1; elem < m_input.m_line_read; ++elem)
          {
            replace[rep_elem] = m_input.m_line[elem];
            
            ++rep_elem;
            if (rep_elem >= replace.length)
              {
                replace = FOVOvCcFg.doubleSize(replace);
              }
          } 
        
        /* Replace buffer. */
        m_input.m_line = replace;
        m_input.m_line_read = rep_elem;
        
        if (FOVOvCcFg.OLD_DEBUG)
          {
//nsSystem.out.print("macro expansion is:" );
            System.out.println(new String(m_input.m_line,0,m_input.m_line_read));
          }
        return NOT_ERROR;
      }

  /***************************************************************
    Function: saveMacro
    Description: Saves macro definition of form:
    macro_name = macro_definition
    **************************************************************/
  private void saveMacro
    (
     )
      {
        int elem;
        int start_name;
        int count_name;
        int start_def;
        int count_def;
        boolean saw_escape;
        boolean in_quote;

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != this);
            FOVOvCcFg.assert(null != m_outstream);
            FOVOvCcFg.assert(null != m_input);
            FOVOvCcFg.assert(null != m_tokens);
            FOVOvCcFg.assert(null != m_spec);
          }

        /* Macro declarations are of the following form:
           macro_name macro_definition */

        elem = 0;
        
        /* Skip white space preceding macro name. */
        while (true == FOVOvCcFg.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* End of line has been reached,
                   and line was found to be empty. */
                return;
              }
          }

        /* Read macro name. */
        start_name = elem;
        while (false == FOVOvCcFg.isspace(m_input.m_line[elem])
               && '=' != m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                pERmcHeDz.parse_error(pERmcHeDz.E_MACDEF,m_input.m_line_number);
              }
          }
        count_name = elem - start_name;

        /* Check macro name. */
        if (0 == count_name) 
          {
            /* Nonexistent macro name. */
            pERmcHeDz.parse_error(pERmcHeDz.E_MACDEF,m_input.m_line_number);
          }

        /* Skip white space between name and definition. */
        while (true == FOVOvCcFg.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                pERmcHeDz.parse_error(pERmcHeDz.E_MACDEF,m_input.m_line_number);
              }
          }

        if ('=' == m_input.m_line[elem])
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                pERmcHeDz.parse_error(pERmcHeDz.E_MACDEF,m_input.m_line_number);
              }
          }

        /* Skip white space between name and definition. */
        while (true == FOVOvCcFg.isspace(m_input.m_line[elem]))
          {
            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* Macro name but no associated definition. */
                pERmcHeDz.parse_error(pERmcHeDz.E_MACDEF,m_input.m_line_number);
              }
          }

        /* Read macro definition. */
        start_def = elem;
        in_quote = false;
        saw_escape = false;
        while (false == FOVOvCcFg.isspace(m_input.m_line[elem])
               || true == in_quote
               || true == saw_escape)
          {
            if ('\"' == m_input.m_line[elem] && false == saw_escape)
              {
                if (true == in_quote)
                  {
                    in_quote = false;
                  }
                else
                  {
                    in_quote = true;
                  }
              }
            
            if ('\\' == m_input.m_line[elem] && false == saw_escape)
              {
                saw_escape = true;
              }
            else
              {
                saw_escape = false;
              }

            ++elem;
            if (elem >= m_input.m_line_read)
              {
                /* End of line. */
                break;
              }
          }
        count_def = elem - start_def;
          
        /* Check macro definition. */
        if (0 == count_def) 
          {
            /* Nonexistent macro name. */
            pERmcHeDz.parse_error(pERmcHeDz.E_MACDEF,m_input.m_line_number);
          }

        /* Debug checks. */
        if (true == FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(0 < count_def);
            FOVOvCcFg.assert(0 < count_name);
            FOVOvCcFg.assert(null != m_spec.m_macros);
          }

        if (FOVOvCcFg.OLD_DEBUG)
          {
            System.out.println("macro name \""
                               + new String(m_input.m_line,start_name,count_name)
                               + "\".");
            System.out.println("macro definition \""
                               + new String(m_input.m_line,start_def,count_def)
                               + "\".");
          }

        /* Add macro name and definition to table. */
        m_spec.m_macros.put(new String(m_input.m_line,start_name,count_name),
                            new String(m_input.m_line,start_def,count_def));
      }

  /***************************************************************
    Function: saveStates
    Description: Takes state declaration and makes entries
    for them in state hashtable in drHChFQzb structure.
    State declaration should be of the form:
    %state name0[, name1, name2 ...]
    (But commas are actually optional as long as there is 
    white space in between them.)
    **************************************************************/
  private void saveStates
    (
     )
      {
        int start_state;
        int count_state;

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != this);
            FOVOvCcFg.assert(null != m_outstream);
            FOVOvCcFg.assert(null != m_input);
            FOVOvCcFg.assert(null != m_tokens);
            FOVOvCcFg.assert(null != m_spec);
          }

        /* EOF found? */
        if (true == m_input.m_eof_reached)
          {
            return;
          }

        /* Debug checks. */
        if (true == FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert('%' == m_input.m_line[0]);
            FOVOvCcFg.assert('s' == m_input.m_line[1]);
            FOVOvCcFg.assert(m_input.m_line_index <= m_input.m_line_read);
            FOVOvCcFg.assert(0 <= m_input.m_line_index);
            FOVOvCcFg.assert(0 <= m_input.m_line_read);
          }

        /* Blank line?  No states? */
        if (m_input.m_line_index >= m_input.m_line_read)
          {
            return;
          }

        while (m_input.m_line_index < m_input.m_line_read)
          {
            if (FOVOvCcFg.OLD_DEBUG)
              {
                System.out.println("line read " + m_input.m_line_read 
                                   + "\tline index = " + m_input.m_line_index);
              }

            /* Skip white space. */
            while (true == FOVOvCcFg.isspace(m_input.m_line[m_input.m_line_index]))
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* No more states to be found. */
                    return;
                  }
              }
            
            /* Look for state name. */
            start_state = m_input.m_line_index;
            while (false == FOVOvCcFg.isspace(m_input.m_line[m_input.m_line_index])
                   && ',' != m_input.m_line[m_input.m_line_index])
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line and end of state name. */
                    break;
                  }
              }
            count_state = m_input.m_line_index - start_state;

            if (FOVOvCcFg.OLD_DEBUG)
              {
                System.out.println("State name \"" 
                                   + new String(m_input.m_line,start_state,count_state)
                                   + "\".");
                System.out.println("Integer index \"" 
                                   + m_spec.m_states.size()
                                   + "\".");
              }

            /* Enter new state name, along with unique index. */
            m_spec.m_states.put(new String(m_input.m_line,start_state,count_state),
                                new Integer(m_spec.m_states.size()));
            
            /* Skip comma. */
            if (',' == m_input.m_line[m_input.m_line_index])
              {
                ++m_input.m_line_index;
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line. */
                    return;
                  }
              }
          }
      }

  /********************************************************
    Function: expandEscape
    Description: Takes escape sequence and returns
    corresponding character code.
    *******************************************************/
  private char expandEscape
    (
     )
      {
        char r;
        
        /* Debug checks. */
        if (true == FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(m_input.m_line_index < m_input.m_line_read);
            FOVOvCcFg.assert(0 < m_input.m_line_read);
            FOVOvCcFg.assert(0 <= m_input.m_line_index);
          }

        if ('\\' != m_input.m_line[m_input.m_line_index])
          {
            ++m_input.m_line_index;
            return m_input.m_line[m_input.m_line_index - 1];
          }
        else
          {
            ++m_input.m_line_index;
            switch (FOVOvCcFg.toupper(m_input.m_line[m_input.m_line_index]))
              {
              case 'B':
                ++m_input.m_line_index;
                return '\b';

              case 'T':
                ++m_input.m_line_index;
                return '\t';

              case 'N':
                ++m_input.m_line_index;
                return '\n';

              case 'F':
                ++m_input.m_line_index;
                return '\f';

              case 'R':
                ++m_input.m_line_index;
                return '\r';

              case '^':
                ++m_input.m_line_index;
                r = (char) (FOVOvCcFg.toupper(m_input.m_line[m_input.m_line_index]) 
                     - '@');
                ++m_input.m_line_index;
                return r;

              case 'X':
                ++m_input.m_line_index;
                r = 0;
                if (true == FOVOvCcFg.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = FOVOvCcFg.hex2bin(m_input.m_line[m_input.m_line_index]);
                    ++m_input.m_line_index;
                  }
                if (true == FOVOvCcFg.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = (char) (r << 4);
                    r = (char) (r | FOVOvCcFg.hex2bin(m_input.m_line[m_input.m_line_index]));
                    ++m_input.m_line_index;
                  }
                if (true == FOVOvCcFg.ishexdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = (char) (r << 4);
                    r = (char) (r | FOVOvCcFg.hex2bin(m_input.m_line[m_input.m_line_index]));
                    ++m_input.m_line_index;
                  }
                return r;
                
              default:
                if (false == FOVOvCcFg.isoctdigit(m_input.m_line[m_input.m_line_index]))
                  {
                    r = m_input.m_line[m_input.m_line_index];
                    ++m_input.m_line_index;
                  }
                else
                  {
                    r = FOVOvCcFg.oct2bin(m_input.m_line[m_input.m_line_index]);
                    ++m_input.m_line_index;
                    
                    if (true == FOVOvCcFg.isoctdigit(m_input.m_line[m_input.m_line_index]))
                      {
                        r = (char) (r << 3);
                        r = (char) (r | FOVOvCcFg.oct2bin(m_input.m_line[m_input.m_line_index]));
                        ++m_input.m_line_index;
                      }

                    if (true == FOVOvCcFg.isoctdigit(m_input.m_line[m_input.m_line_index]))
                      {
                        r = (char) (r << 3);
                        r = (char) (r | FOVOvCcFg.oct2bin(m_input.m_line[m_input.m_line_index]));
                        ++m_input.m_line_index;
                      }
                  }
                return r;
              }
          }
      }
        
  /********************************************************
    Function: packAccept
    Description: Packages and returns IRxqsITZU 
    for action next in input stream.
    *******************************************************/
  IRxqsITZU packAccept
    (
     )
      throws java.io.IOException
      {
        IRxqsITZU accept;
        char action[];
        int action_index;
        int brackets;

        action = new char[BUFFER_SIZE];
        action_index = 0;

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != this);
            FOVOvCcFg.assert(null != m_outstream);
            FOVOvCcFg.assert(null != m_input);
            FOVOvCcFg.assert(null != m_tokens);
            FOVOvCcFg.assert(null != m_spec);
          }

        /* Get a new line, if needed. */
        while (m_input.m_line_index >= m_input.m_line_read)
          {
            if (true == m_input.getLine())
              {
                pERmcHeDz.parse_error(pERmcHeDz.E_EOF,m_input.m_line_number);
                return null;
              }
          }
        
        /* Look for beginning of action. */
        while (true == FOVOvCcFg.isspace(m_input.m_line[m_input.m_line_index]))
          {
            ++m_input.m_line_index;
            
            /* Get a new line, if needed. */
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    pERmcHeDz.parse_error(pERmcHeDz.E_EOF,m_input.m_line_number);
                    return null;
                  }
              }
          }
        
        /* Look for brackets. */
        if ('{' != m_input.m_line[m_input.m_line_index])
          {
            /*System.out.println("<" + m_input.m_line[m_input.m_line_index] + ">");*/
            pERmcHeDz.parse_error(pERmcHeDz.E_BRACE,m_input.m_line_number); 
          }
        
        /* Copy new line into action buffer. */
        brackets = 0;
        while (true)
          {
            action[action_index] = m_input.m_line[m_input.m_line_index];

            /* Look for brackets. */
            if ('{' == m_input.m_line[m_input.m_line_index])
              {
                ++brackets;
              }
            else if ('}' == m_input.m_line[m_input.m_line_index])
              {
                --brackets;
                
                if (0 == brackets)
                  {
                    ++action_index;
                    ++m_input.m_line_index;

                    break;
                  }
              }
            
            ++action_index;
            /* Double the buffer size, if needed. */
            if (action_index > action.length)
              {
                action = FOVOvCcFg.doubleSize(action);
              }

            ++m_input.m_line_index;
            /* Get a new line, if needed. */
            while (m_input.m_line_index >= m_input.m_line_read)
              {
                if (true == m_input.getLine())
                  {
                    pERmcHeDz.parse_error(pERmcHeDz.E_SYNTAX,m_input.m_line_number);
                    return null;
                  }
              }
          }
            
        accept = new IRxqsITZU(action,action_index,m_input.m_line_number);

        if (FOVOvCcFg.DEBUG)
          {
            FOVOvCcFg.assert(null != accept);
          }

        if (FOVOvCcFg.DESCENT_DEBUG)
          {
            System.out.print("Accepting action:");
            System.out.println(new String(accept.m_action,0,accept.m_action_read));
          }

        return accept;
      }

  /********************************************************
    Function: advance
    Description: Returns code for next token.
    *******************************************************/
  private boolean m_advance_stop = false;
  int advance
    (
     )
      throws java.io.IOException
      {
        boolean saw_escape = false;
        Integer code;
        
        /*if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          FOVOvCcFg.assert(m_input.m_line_index <= m_input.m_line_read);
        }*/

        if (true == m_input.m_eof_reached)
          {
            /* EOF has already been reached,
               so return appropriate code. */

            m_spec.m_current_token = END_OF_INPUT;
            m_spec.m_lexeme = '\0';
            return m_spec.m_current_token;
          }

        /* End of previous regular expression?
           Refill line buffer? */
        if (EOS == m_spec.m_current_token
            /* ADDED */
            || m_input.m_line_index >= m_input.m_line_read)
            /* ADDED */
          {
            if (true == m_spec.m_in_quote)
              {
                pERmcHeDz.parse_error(pERmcHeDz.E_SYNTAX,m_input.m_line_number);
              }
            
            while (true)
              {
                if (false == m_advance_stop  
                    || m_input.m_line_index >= m_input.m_line_read)
                  {
                    if (true == m_input.getLine())
                      {
                        /* EOF has already been reached,
                           so return appropriate code. */
                        
                        m_spec.m_current_token = END_OF_INPUT;
                        m_spec.m_lexeme = '\0';
                        return m_spec.m_current_token;
                      }
                    m_input.m_line_index = 0;
                  }
                else
                  {
                    m_advance_stop = false;
                  }

                while (m_input.m_line_index < m_input.m_line_read
                       && true == FOVOvCcFg.isspace(m_input.m_line[m_input.m_line_index]))
                  {
                    ++m_input.m_line_index;
                  }
                
                if (m_input.m_line_index < m_input.m_line_read)
                  {
                    break;
                  }
              }
          }
        
        /*if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_number = " + m_input.m_line_number);
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          FOVOvCcFg.assert(m_input.m_line_index <= m_input.m_line_read);
        }*/
        if (FOVOvCcFg.DEBUG) {
          FOVOvCcFg.assert(m_input.m_line_index <= m_input.m_line_read);
        }

        /* Look for macro expansions. */
        if (false == m_spec.m_in_quote)
          {
            while ('{' == m_input.m_line[m_input.m_line_index])
              {
                expandMacro();

                /* End of line buffer? */
                if (m_input.m_line_index >= m_input.m_line_read)
                  {
                    /* End of line signifies the end of 
                       the current regular expression. */

                    m_spec.m_current_token = EOS;
                    m_spec.m_lexeme = '\0';
                    return m_spec.m_current_token;
                  }
              }
          }
            
        /*if (m_input.m_line_index) {
          System.out.println("**********2");
          System.out.println("m_spec.m_in_quote = " + m_spec.m_in_quote);
        }*/

        /*System.out.println("m_spec.m_in_quote = " + m_spec.m_in_quote);
        System.out.println("m_input.m_line_index = " + m_input.m_line_index);
        System.out.println("m_input.m_line_read = " + m_input.m_line_read);*/
        
        /* Look for quotation mark. */
        /* REMOVED */
        /*if ('\"' == m_input.m_line[m_input.m_line_index])*/
        /* REMOVED */
        /* ADDED */
        while ('\"' == m_input.m_line[m_input.m_line_index])
        /* ADDED */
          {
            /* Toggle in-quote status. */
            if (true == m_spec.m_in_quote)
              {
                m_spec.m_in_quote = false;
              }
            else
              {
                m_spec.m_in_quote = true;
              }
            /* ADDED */
            ++m_input.m_line_index;
            /* ADDED */

            if (m_input.m_line_index >= m_input.m_line_read)
              {
                /* End of line signifies the end of 
                   the current regular expression. */

                m_spec.m_current_token = EOS;
                m_spec.m_lexeme = '\0';
                return m_spec.m_current_token;
              }
          }

        if (m_input.m_line_index > m_input.m_line_read) {
          System.out.println("m_input.m_line_index = " + m_input.m_line_index);
          System.out.println("m_input.m_line_read = " + m_input.m_line_read);
          FOVOvCcFg.assert(m_input.m_line_index <= m_input.m_line_read);
        }

        /* Look for backslash, and corresponding 
           escape sequence. */
        if ('\\' == m_input.m_line[m_input.m_line_index])
          {
            saw_escape = true;
          }
        else
          {
            saw_escape = false;
          }

        if (false == m_spec.m_in_quote)
          {
            if (FOVOvCcFg.isspace(m_input.m_line[m_input.m_line_index]))
              {
                /* White space means the end of 
                   the current regular expression. */

                m_spec.m_current_token = EOS;
                m_spec.m_lexeme = '\0';
                return m_spec.m_current_token;
              }

            /* Process escape sequence, if needed. */
            if (true == saw_escape)
              {
                m_spec.m_lexeme = expandEscape();
              }
            else
              {
                m_spec.m_lexeme = m_input.m_line[m_input.m_line_index];
                ++m_input.m_line_index;
              }
          }
        else
          {
            if (true == saw_escape 
                && (m_input.m_line_index + 1) < m_input.m_line_read
                && '\"' == m_input.m_line[m_input.m_line_index + 1])
              {
                m_spec.m_lexeme = '\"';
                m_input.m_line_index = m_input.m_line_index + 2;
              }
            else
              {
                m_spec.m_lexeme = m_input.m_line[m_input.m_line_index];
                ++m_input.m_line_index;
              }
          }
        
        code = (Integer) m_tokens.get(new Character(m_spec.m_lexeme));
        if (true == m_spec.m_in_quote || true == saw_escape)
          {
            m_spec.m_current_token = L;
          }
        else
          {
            if (null == code)
              {
                m_spec.m_current_token = L;
              }
            else
              {
                m_spec.m_current_token = code.intValue();
              }
          }

        if (FOVOvCcFg.FOODEBUG)
          {
            System.out.println("Lexeme: " + m_spec.m_lexeme
                               + "\tToken: " + m_spec.m_current_token
                               + "\tIndex: " + m_input.m_line_index);
          }

        return m_spec.m_current_token;
      }

  /***************************************************************
    Function: details
    Description: High level debugging routine.
    **************************************************************/
  private void details
    (
     )
      {
        Enumeration names;
        String name;
        String def;
        Enumeration states;
        String state;
        Integer index;
        int elem;
        int size;

        System.out.println("\n\t** Macros **");
        names = m_spec.m_macros.keys();
        while (true == names.hasMoreElements())
          {
            name = (String) names.nextElement();
            def = (String) m_spec.m_macros.get(name);

            if (FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(null != name);
                FOVOvCcFg.assert(null != def);
              }

            System.out.println("Macro name \"" + name 
                               + "\" has definition \"" 
                               + def + "\".");
          }

        System.out.println("\n\t** States **");
        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(null != state);
                FOVOvCcFg.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");
          }
            
        System.out.println("\n\t** Character Counting **");
        if (false == m_spec.m_count_chars)
          {
            System.out.println("Character counting is off.");
          }
        else
          {
            if (FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(true == m_spec.m_count_lines);
              }

            System.out.println("Character counting is on.");
          }

        System.out.println("\n\t** Line Counting **");
        if (false == m_spec.m_count_lines)
          {
            System.out.println("Line counting is off.");
          }
        else
          {
            if (FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(true == m_spec.m_count_lines);
              }

            System.out.println("Line counting is on.");
          }

        System.out.println("\n\t** Operating System Specificity **");
        if (false == m_spec.m_unix)
          {
            System.out.println("Not generating UNIX-specific code.");
            System.out.println("(This means that \"\\r\\n\" is a "
                               + "newline, rather than \"\\n\".)");
          }
        else
          {
            System.out.println("Generating UNIX-specific code.");
            System.out.println("(This means that \"\\n\" is a " 
                               + "newline, rather than \"\\r\\n\".)");
          }

        System.out.println("\n\t** Java CUP Compatibility **");
        if (false == m_spec.m_cup_compatible)
          {
            System.out.println("Generating CUP compatible code.");
            System.out.println("(No current results.)");
          }
        else
          {
            System.out.println("Not generating CUP compatible code.");
            System.out.println("(No current results.)");
          }
        
        if (FOVOvCcFg.FOODEBUG) {
          if (null != m_spec.m_nfa_states && null != m_spec.m_nfa_start)
            {
              System.out.println("\n\t** NFA machine **");
              print_nfa();
          }
        }

        if (null != m_spec.m_dtrans_vector)
          {
            System.out.println("\n\t** DFA transition table **");
            /*print_header();*/
          }

        /*if (null != m_spec.m_accept_vector && null != m_spec.m_anchor_array)
          {
            System.out.println("\n\t** Accept States and Anchor Vector **");
            print_accept();
          }*/
      }

  /***************************************************************
    function: print_set
    **************************************************************/
  void print_set
    (
     Vector nfa_set
     )
      {
        int size; 
        int elem;
        CkBxcepSH nfa;

        size = nfa_set.size();

        if (0 == size)
          {
            System.out.print("empty ");
          }
        
        for (elem = 0; elem < size; ++elem)
          {
            nfa = (CkBxcepSH) nfa_set.elementAt(elem);
            /*System.out.print(m_spec.m_nfa_states.indexOf(nfa) + " ");*/
            System.out.print(nfa.m_label + " ");
          }
      }

   /***************************************************************
     Function: print_header
     **************************************************************/
  private void print_header
    (
     )
      {
        Enumeration states;
        int i;
        int j;
        int chars_printed = 0;
        fhTZXkZqS dtrans;
        int last_transition;
        String str;
        IRxqsITZU accept;
        String state;
        Integer index;

        System.out.println("/*---------------------- DFA -----------------------");
        
        states = m_spec.m_states.keys();
        while (true == states.hasMoreElements())
          {
            state = (String) states.nextElement();
            index = (Integer) m_spec.m_states.get(state);

            if (FOVOvCcFg.DEBUG)
              {
                FOVOvCcFg.assert(null != state);
                FOVOvCcFg.assert(null != index);
              }

            System.out.println("State \"" + state 
                               + "\" has identifying index " 
                               + index.toString() + ".");

            i = index.intValue();
            if (fhTZXkZqS.F != m_spec.m_state_dtrans[i])
              {
                System.out.println("\tStart index in transition table: "
                                   + m_spec.m_state_dtrans[i]);
              }
            else
              {
                System.out.println("\tNo associated transition states.");
              }
          }

        for (i = 0; i < m_spec.m_dtrans_vector.size(); ++i)
          {
            dtrans = (fhTZXkZqS) m_spec.m_dtrans_vector.elementAt(i);

            if (null == m_spec.m_accept_vector && null == m_spec.m_anchor_array)
              {
                if (null == dtrans.m_accept)
                  {
                    System.out.print(" * State " + i + " [nonaccepting]");
                  }
                else
                  {
                    System.out.print(" * State " + i 
                                     + " [accepting, line "
                                     + dtrans.m_accept.m_line_number 
                                     + " <"
                                     + (new String(dtrans.m_accept.m_action,0,
                                                   dtrans.m_accept.m_action_read))
                                     + ">]");
                    if (drHChFQzb.NONE != dtrans.m_anchor)
                      {
                        System.out.print(" Anchor: "
                                         + ((0 != (dtrans.m_anchor & drHChFQzb.START)) 
                                            ? "start " : "")
                                         + ((0 != (dtrans.m_anchor & drHChFQzb.END)) 
                                            ? "end " : ""));
                      }
                  }
              }
            else
              {
                accept = (IRxqsITZU) m_spec.m_accept_vector.elementAt(i);

                if (null == accept)
                  {
                    System.out.print(" * State " + i + " [nonaccepting]");
                  }
                else
                  {
                    System.out.print(" * State " + i 
                                     + " [accepting, line "
                                     + accept.m_line_number 
                                     + " <"
                                     + (new String(accept.m_action,0,
                                                   accept.m_action_read))
                                     + ">]");
                    if (drHChFQzb.NONE != m_spec.m_anchor_array[i])
                      {
                        System.out.print(" Anchor: "
                                         + ((0 != (m_spec.m_anchor_array[i] & drHChFQzb.START)) 
                                            ? "start " : "")
                                         + ((0 != (m_spec.m_anchor_array[i] & drHChFQzb.END)) 
                                            ? "end " : ""));
                      }
                  }
              }

            last_transition = -1;
            for (j = 0; j < m_spec.m_dtrans_ncols; ++j)
              {
                if (fhTZXkZqS.F != dtrans.m_dtrans[j])
                  {
                    if (last_transition != dtrans.m_dtrans[j])
                      {
                        System.out.print("\n *    goto " + dtrans.m_dtrans[j]
                                         + " on ");
                        chars_printed = 0;
                      }
                    
                    str = interp_int((int) j);
                    System.out.print(str);
                                
                    chars_printed = chars_printed + str.length(); 
                    if (56 < chars_printed)
                      {
                        System.out.print("\n *             ");
                        chars_printed = 0;
                      }
                    
                    last_transition = dtrans.m_dtrans[j];
                  }
              }
            System.out.println("");
          }
        System.out.println(" */\n");
      }
}

/************************************************************************
  JAVA-LEX COPYRIGHT NOTICE, LICENSE AND DISCLAIMER.
  
  Copyright 1996 by Elliot Joel Berk
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both the copyright notice and this permission notice and warranty
  disclaimer appear in supporting documentation, and that the name of
  Elliot Joel Berk not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.
  
  Elliot Joel Berk disclaims all warranties with regard to this software, 
  including all implied warranties of merchantability and fitness.  In no event
  shall Elliot Joel Berk be liable for any special, indirect or consequential
  damages or any damages whatsoever resulting from loss of use, data or
  profits, whether in an action of contract, negligence or other
  tortious action, arising out of or in connection with the use or
  performance of this software.
  ***********************************************************************/




/**************************************************************
  Java-Lex: A Lexical Analyzer Generator for Java
  Written by Elliot Berk. Copyright 1996.
  Contact at ejberk@princeton.edu.

  Modified N.Shaylor
  08-Sep-96 - Change yy_lookahead, yy_advance(), and YYEOF to be int.
            - Zero yy_char_count every '\n'.
            - Put in a package and define all classes final.
            - Use nshaylor.util.BitSet that checks for the grow
              bug in JDK 1.0.

  07-Oct-96 - Add  yy_getcharArray();

  11-Oct-96 - Use nshaylor.jlx.BitSet that checks for the grow
  
  07-Nov-96 - Make yy_nxt, yy_rmap, yy_cmap, and yy_acpt short arrays
            - Make all constants like YYEOF static

  08-Nov-96 - Change yy_acpt, yy_this_accept, YY_NOT_ACCEPT, and
            - YY_NO_ANCHOR to byte

  11-Nov-96 - Use BufferedOutputStreams to spead things up?
            - Make all final variables static.

  17-Feb-97 - Remove BufferedOutputStreams. Somehow this causes a
              problem and the end of the output file is truncated.
              I don't have the time now to find out why, so we go back
              to the old slow way that works.

  *************************************************************/

/***************************************************************
  Package Declaration
  **************************************************************/
/* UNDONE: Uncomment this. */


/***************************************************************
  Imported Packages
  **************************************************************/



/******************************
  Questions:
  2) How should I use the Java package system
  to make my tool more modularized and
  coherent?

  Unimplemented:
  !) Fix BitSet issues -- expand only when necessary.
  2) Repeated accept rules.
  6) Clean up the lgHWDnTtZ class and use buffered
  allocation.
  7) Reading and writing in Unicode.
  Use DataInputStream and DataOutputStream,
  along with writeUTF???
  8) Fix or at least annotate ^x bug.
  9) Add to spec about extending character set.
  10) making sure newlines are handled correctly
  and consistly with the m_unix flag
  11) m_verbose -- what should be done with it?
  12) turn lexical analyzer into a coherent
  Java package
  13) turn lexical analyzer generator into a
  coherent Java package
  16) pretty up generated code
  17) make it possible to have white space in
  regular expressions
  18) clean up all of the class files the lexer
  generator produces when it is compiled,
  and reduce this number in some way.
  24) character format to and from file: writeup
  and implementation
  25) Debug by testing all arcane regular expression cases.
  26) Look for and fix all UNDONE comments below.
  27) Fix package system.
  28) Clean up unnecessary classes.
  *****************************/

/***************************************************************
  Class: yCWZtShZT
 **************************************************************/
final class yCWZtShZT //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
    
  /* Lexical States. */
  Hashtable m_states; /* Hashtable taking state indices (Integer) 
                         to state name (String). */

  /* Regular Expression Macros. */ 
  Hashtable m_macros; /* Hashtable taking macro name (String)
                                to corresponding char buffer that
                                holds macro definition. */

  /* NFA Machine. */
  pHNWlbrmz m_nfa_start; /* Start state of NFA machine. */
  Vector m_nfa_states; /* Vector of states, with index
                                 corresponding to label. */
  
  Vector m_state_rules[]; /* An array of Vectors of Integers.
                                    The ith Vector represents the lexical state
                                    with index i.  The contents of the ith 
                                    Vector are the indices of the NFA start
                                    states that can be matched while in
                                    the ith lexical state. */
                                    

  int m_state_dtrans[];

  /* DFA Machine. */
  Vector m_dfa_states; /* Vector of states, with index
                                 corresponding to label. */
  Hashtable m_dfa_sets; /* Hashtable taking set of NFA states
                                  to corresponding DFA state, 
                                  if the latter exists. */
  
  /* Accept States and Corresponding Anchors. */
  Vector m_accept_vector;
  int m_anchor_array[];

  /* Transition Table. */
  Vector m_dtrans_vector;
  int m_dtrans_ncols;
  int m_row_map[];
  int m_col_map[];

  /* Regular expression token variables. */
  int m_current_token;
  char m_lexeme;
  boolean m_in_quote;

  /* Verbose execturion flag. */
  boolean m_verbose;

  /* Java-Lex directives flags. */
  boolean m_integer_type;
  boolean m_intwrap_type;
  boolean m_yyeof;
  boolean m_count_chars;
  boolean m_count_lines;
  boolean m_cup_compatible;
  boolean m_unix;

  char m_init_code[];
  int m_init_read;

  char m_init_throw_code[];
  int m_init_throw_read;

  char m_class_code[];
  int m_class_read;

  char m_eof_code[];
  int m_eof_read;

  char m_eof_value_code[];
  int m_eof_value_read;

  char m_eof_throw_code[];
  int m_eof_throw_read;

  char m_yylex_throw_code[];
  int m_yylex_throw_read;

  /* Class, function, type names. */
  char m_class_name[] = {          
    'Y', 'y', 'l', 
    'e', 'x' 
    };
  char m_function_name[] = {
    'y', 'y', 'l', 
    'e', 'x' 
    };
  char m_type_name[] = {
    'Y', 'y', 't', 
    'o', 'k', 'e',
    'n'
    };

  /* Lexical Generator. */
  private ctxmGlswy m_lexGen;

  /***************************************************************
    Constants
    ***********************************************************/
  static final int NONE = 0;
  static final int START = 1;
  static final int END = 2;
  
  /***************************************************************
    Function: yCWZtShZT
    Description: Constructor.
    **************************************************************/
  yCWZtShZT
    (
     ctxmGlswy lexGen
     )
      {
        m_lexGen = lexGen;

        /* Initialize regular expression token variables. */
        m_current_token = m_lexGen.EOS;
        m_lexeme = '\0';
        m_in_quote = false;

        /* Initialize hashtable for lexer states. */
        m_states = new Hashtable();
        m_states.put(new String("YYINITIAL"),new Integer(m_states.size()));

        /* Initialize hashtable for lexical macros. */
        m_macros = new Hashtable();

        /* Initialize variables for lexer options. */
        m_integer_type = false;
        m_intwrap_type = false;
        m_count_lines = false;
        m_count_chars = false;
        m_cup_compatible = false;
        m_unix = true;
        m_yyeof = false;

        /* Initialize variables for Java-Lex runtime options. */
        m_verbose = true;

        m_nfa_start = null;
        m_nfa_states = new Vector();
        
        m_dfa_states = new Vector();
        m_dfa_sets = new Hashtable();

        m_dtrans_vector = new Vector();
        m_dtrans_ncols = OAdukKIqY.MAX_SEVEN_BIT + 1;
        m_row_map = null;
        m_col_map = null;

        m_accept_vector = null;
        m_anchor_array = null;

        m_init_code = null;
        m_init_read = 0;

        m_init_throw_code = null;
        m_init_throw_read = 0;

        m_yylex_throw_code = null;
        m_yylex_throw_read = 0;

        m_class_code = null;
        m_class_read = 0;

        m_eof_code = null;
        m_eof_read = 0;

        m_eof_value_code = null;
        m_eof_value_read = 0;

        m_eof_throw_code = null;
        m_eof_throw_read = 0;

        m_state_dtrans = null;

        m_state_rules = null;
      }
}

/***************************************************************
  Class: gXEPnHcKQ
  **************************************************************/
final class gXEPnHcKQ //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private yCWZtShZT m_spec;
  private DataOutputStream m_outstream;

  /***************************************************************
    Constants: Anchor Types
    **************************************************************/
  private final int START = 1;
  private final int END = 2;
  private final int NONE = 4;

  /***************************************************************
    Constants
    **************************************************************/
  private final boolean EDBG = true;
  private final boolean NOT_EDBG = false;

  /***************************************************************
    Function: gXEPnHcKQ
    Description: Constructor.
    **************************************************************/
  gXEPnHcKQ
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: reset
    Description: Clears member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_spec = null;
        m_outstream = null;
      }

  /***************************************************************
    Function: set
    Description: Initializes member variables.
    **************************************************************/
  private void set
    (
     yCWZtShZT spec,
     OutputStream outstream
     )
      {
        if (OAdukKIqY.DEBUG)
          {
            OAdukKIqY.assert(null != spec);
            OAdukKIqY.assert(null != outstream);
          }

        m_spec = spec;
        m_outstream = new DataOutputStream(
                        /*new BufferedOutputStream(*/ outstream /*)*/ ); //**NS**
      }

  /***************************************************************
    Function: emit_imports
    Description: Emits import packages at top of 
    generated source file.
    **************************************************************/
  /*void emit_imports
    (
     yCWZtShZT spec,
     OutputStream outstream
     )
      throws java.io.IOException      
        {
          set(spec,outstream);
          
          if (OAdukKIqY.DEBUG)
            {
              OAdukKIqY.assert(null != m_spec);
              OAdukKIqY.assert(null != m_outstream);
            }*/
          
          /*m_outstream.writeBytes("import java.lang.String;\n");
          m_outstream.writeBytes("import java.lang.System;\n");
          m_outstream.writeBytes("import java.io.DataInputStream;\n");
          m_outstream.writeBytes("import java.io.InputStream;\n");*/
        /*  
          reset();
        }*/
  
  /***************************************************************
    Function: print_details
    Description: Debugging output.
    **************************************************************/
  private void print_details
    (
     )
      {
        int i;
        int j;
        int next;
        int state;
        aeDkYlUOm dtrans;
        TdLZzxjmB accept;
        boolean tr;

        System.out.println("---------------------- Transition Table " 
                           + "----------------------");
        
        for (i = 0; i < m_spec.m_row_map.length; ++i)
          {
            System.out.print("State " + i);
            
            accept = (TdLZzxjmB) m_spec.m_accept_vector.elementAt(i);
            if (null == accept)
              {
                System.out.println(" [nonaccepting]");
              }
            else
              {
                System.out.println(" [accepting, line "
                                 + accept.m_line_number 
                                 + " <"
                                 + (new java.lang.String(accept.m_action,0,
                                               accept.m_action_read))
                                 + ">]");
              }
            dtrans = (aeDkYlUOm) m_spec.m_dtrans_vector.elementAt(m_spec.m_row_map[i]);
            
            tr = false;
            state = dtrans.m_dtrans[m_spec.m_col_map[0]];
            if (aeDkYlUOm.F != state)
              {
                tr = true;
                System.out.print("\tgoto " + state + " on [" + ((char) 0));
              }
            for (j = 1; j < m_spec.m_dtrans_ncols; ++j)
              {
                next = dtrans.m_dtrans[m_spec.m_col_map[j]];
                if (state == next)
                  {
                    if (aeDkYlUOm.F != state)
                      {
                        System.out.print((char) j);
                      }
                  }
                else
                  {
                    state = next;
                    if (true == tr)
                      {
                        System.out.println("]");
                        tr = false;
                      }
                    if (aeDkYlUOm.F != state)
                      {
                        tr = true;
                        System.out.print("\tgoto " + state + " on [" + ((char) j));
                      }
                  }
              }
            if (true == tr)
              {
                System.out.println("]");
              }
          }

        System.out.println("---------------------- Transition Table " 
                           + "----------------------");
      }

  /***************************************************************
    Function: emit
    Description: High-level access function to module.
    **************************************************************/
  void emit
    (
     yCWZtShZT spec,
     OutputStream outstream
     )
      throws java.io.IOException      
        {
          set(spec,outstream);
          
          if (OAdukKIqY.DEBUG)
            {
              OAdukKIqY.assert(null != m_spec);
              OAdukKIqY.assert(null != m_outstream);
            }
          
          if (OAdukKIqY.OLD_DEBUG) {
            print_details();
          }

          emit_header();
          emit_construct();
          emit_helpers();
          emit_driver();
          emit_footer();
          
          reset();
        }

  /***************************************************************
    Function: emit_construct
    Description: Emits constructor, member variables,
    and constants.
    **************************************************************/
  private void emit_construct
    (
     )
      throws java.io.IOException
        {
          if (OAdukKIqY.DEBUG)
          {
            OAdukKIqY.assert(null != m_spec);
            OAdukKIqY.assert(null != m_outstream);
          }
          
          /* Constants */
          m_outstream.writeBytes("\tprivate static final int YY_BUFFER_SIZE = 512;\n");  //**NS**

          m_outstream.writeBytes("\tprivate static final int YY_F = -1;\n");             //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_NO_STATE = -1;\n");      //**NS**

          m_outstream.writeBytes("\tprivate static final byte YY_NOT_ACCEPT = 0;\n");     //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_START = 1;\n");          //**NS**
          m_outstream.writeBytes("\tprivate static final int YY_END = 2;\n");            //**NS**
          m_outstream.writeBytes("\tprivate static final byte YY_NO_ANCHOR = 4;\n");      //**NS**

          m_outstream.writeBytes("\tpublic static final int YYEOF = -1;\n");             //**NS**
          
          /* User specified class code. */
          if (null != m_spec.m_class_code)
            {
              m_outstream.writeBytes(new String(m_spec.m_class_code,0,
                                                m_spec.m_class_read));
            }

          /* Member Variables */
          m_outstream.writeBytes("\tprivate java.io.DataInputStream yy_instream;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_index;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_read;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_start;\n");
          m_outstream.writeBytes("\tprivate int yy_buffer_end;\n");
          m_outstream.writeBytes("\tprivate byte yy_buffer[];\n");
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\tprivate int yy_char_count;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\tprivate int yy_line_count;\n");
            }
          m_outstream.writeBytes("\tprivate int yy_lexical_state;\n");
          /*if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\tprivate int yy_buffer_prev_start;\n");
            }*/
          
          /* Function: constructor */
          m_outstream.writeBytes("\t");
          m_outstream.writeBytes(new String(m_spec.m_class_name));
          m_outstream.writeBytes(" (java.io.InputStream instream)");
          
          if (null != m_spec.m_init_throw_code)
            {
              m_outstream.writeBytes("\n"); 
              m_outstream.writeBytes("\t\tthrows "); 
              m_outstream.writeBytes(new String(m_spec.m_init_throw_code,0,
                                                m_spec.m_init_throw_read));
              m_outstream.writeBytes("\n\t\t{\n");
            }
          else
            {
              m_outstream.writeBytes(" {\n");
            }
          
          m_outstream.writeBytes("\t\tif (null == instream) {\n");
          m_outstream.writeBytes("\t\t\tthrow (new Error(\"Error: Bad input "
                                 + "stream initializer.\"));\n");
          m_outstream.writeBytes("\t\t}\n");
          m_outstream.writeBytes("\t\tyy_instream = new java.io.DataInputStream(instream);\n");
          m_outstream.writeBytes("\t\tyy_buffer = new byte[YY_BUFFER_SIZE];\n");
          m_outstream.writeBytes("\t\tyy_buffer_read = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_index = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_start = 0;\n");
          m_outstream.writeBytes("\t\tyy_buffer_end = 0;\n");
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tyy_char_count = 0;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\tyy_line_count = 0;\n");
            }
          m_outstream.writeBytes("\t\tyy_lexical_state = YYINITIAL;\n");
          /*if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tyy_buffer_prev_start = 0;\n");
            }*/

          /* User specified constructor code. */
          if (null != m_spec.m_init_code)
            {
              m_outstream.writeBytes(new String(m_spec.m_init_code,0,
                                                m_spec.m_init_read));
            }

          m_outstream.writeBytes("\t}\n");
        }

  /***************************************************************
    Function: emit_states
    Description: Emits constants that serve as lexical states,
    including YYINITIAL.
    **************************************************************/
  private void emit_states
    (
     )
      throws java.io.IOException
        {
          Enumeration states;
          String state;
          int index;

          states = m_spec.m_states.keys();
          /*index = 0;*/
          while (true == states.hasMoreElements())
            {
              state = (String) states.nextElement();
              
              if (OAdukKIqY.DEBUG)
                {
                  OAdukKIqY.assert(null != state);
                }
              
              m_outstream.writeBytes("\tprivate final int " 
                                     + state 
                                     + " = " 
                                     + (m_spec.m_states.get(state)).toString() 
                                     + ";\n");
              /*++index;*/
            }

          m_outstream.writeBytes("\tprivate final int yy_state_dtrans[] = {\n");
          for (index = 0; index < m_spec.m_state_dtrans.length; ++index)
            {
              m_outstream.writeBytes("\t\t" + m_spec.m_state_dtrans[index]);
              if (index < m_spec.m_state_dtrans.length - 1)
                {
                  m_outstream.writeBytes(",\n");
                }
              else
                {
                  m_outstream.writeBytes("\n");
                }
            }
          m_outstream.writeBytes("\t};\n");
        }

  /***************************************************************
    Function: emit_helpers
    Description: Emits helper functions, particularly 
    error handling and input buffering.
    **************************************************************/
  private void emit_helpers
    (
     )
      throws java.io.IOException
      {
        if (OAdukKIqY.DEBUG)
          {
            OAdukKIqY.assert(null != m_spec);
            OAdukKIqY.assert(null != m_outstream);
          }

        /* Function: yy_do_eof */
        m_outstream.writeBytes("\tprivate boolean yy_eof_done = false;\n");
        if (null != m_spec.m_eof_code)
          {
            m_outstream.writeBytes("\tprivate void yy_do_eof ()");

            if (null != m_spec.m_eof_throw_code)
              {
                m_outstream.writeBytes("\n"); 
                m_outstream.writeBytes("\t\tthrows "); 
                m_outstream.writeBytes(new String(m_spec.m_eof_throw_code,0,
                                                  m_spec.m_eof_throw_read));
                m_outstream.writeBytes("\n\t\t{\n");
              }
            else
              {
                m_outstream.writeBytes(" {\n");
              }

            m_outstream.writeBytes("\t\tif (false == yy_eof_done) {\n");
            m_outstream.writeBytes(new String(m_spec.m_eof_code,0,
                                              m_spec.m_eof_read));
            m_outstream.writeBytes("\t\t}\n");
            m_outstream.writeBytes("\t\tyy_eof_done = true;\n");
            m_outstream.writeBytes("\t}\n");
          }

        emit_states();
        
        /* Function: yybegin */
        m_outstream.writeBytes("\tprivate void yybegin (int state) {\n");
        m_outstream.writeBytes("\t\tyy_lexical_state = state;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_initial_dtrans */
        /*m_outstream.writeBytes("\tprivate int yy_initial_dtrans (int state) {\n");
        m_outstream.writeBytes("\t\treturn yy_state_dtrans[state];\n");
        m_outstream.writeBytes("\t}\n");*/

        /* Function: yy_advance */
        m_outstream.writeBytes("\tprivate int yy_advance ()\n"); //**NS**
        m_outstream.writeBytes("\t\tthrows java.io.IOException {\n");
        /*m_outstream.writeBytes("\t\t{\n");*/
        m_outstream.writeBytes("\t\tint next_read;\n");
        m_outstream.writeBytes("\t\tint i;\n");
        m_outstream.writeBytes("\t\tint j;\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\tif (yy_buffer_index < yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\treturn yy_buffer[yy_buffer_index++] & 0xFF;\n"); //**NS**
        /*m_outstream.writeBytes("\t\t\t++yy_buffer_index;\n");*/
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\tif (0 != yy_buffer_start) {\n");
        m_outstream.writeBytes("\t\t\ti = yy_buffer_start;\n");
        m_outstream.writeBytes("\t\t\tj = 0;\n");
        m_outstream.writeBytes("\t\t\twhile (i < yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\t\tyy_buffer[j] = yy_buffer[i];\n");
        m_outstream.writeBytes("\t\t\t\t++i;\n");
        m_outstream.writeBytes("\t\t\t\t++j;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_end = yy_buffer_end - yy_buffer_start;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_start = 0;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = j;\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_index = j;\n");
        m_outstream.writeBytes("\t\t\tnext_read = yy_instream.read(yy_buffer,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        m_outstream.writeBytes("\t\t\t\treturn YYEOF;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\n");

        m_outstream.writeBytes("\t\twhile (yy_buffer_index >= yy_buffer_read) {\n");
        m_outstream.writeBytes("\t\t\tif (yy_buffer_index >= yy_buffer.length) {\n");
        m_outstream.writeBytes("\t\t\t\tyy_buffer = yy_double(yy_buffer);\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tnext_read = yy_instream.read(yy_buffer,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        m_outstream.writeBytes("\t\t\t\treturn YYEOF;\n");
        m_outstream.writeBytes("\t\t\t}\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        m_outstream.writeBytes("\t\t}\n");

        m_outstream.writeBytes("\t\treturn yy_buffer[yy_buffer_index++] & 0xFF;\n"); //**NS**
        m_outstream.writeBytes("\t}\n");
        
        /* Function: yy_move_start */
        m_outstream.writeBytes("\tprivate void yy_move_start () {\n");
        if (true == m_spec.m_count_lines)
          {
            if (true == m_spec.m_unix)
              {
                m_outstream.writeBytes("\t\tif ((byte) '\\n' " 
                                       + "== yy_buffer[yy_buffer_start]) {\n");
              }
            else
              {         
                m_outstream.writeBytes("\t\tif ((byte) '\\n' " 
                                       + "== yy_buffer[yy_buffer_start]\n"); 
                m_outstream.writeBytes("\t\t\t|| (byte) '\\r' " 
                                       + "== yy_buffer[yy_buffer_start]) {\n");
              }
            m_outstream.writeBytes("\t\t\t++yy_line_count; yy_char_count = 0;\n"); //**NS**
            m_outstream.writeBytes("\t\t}\n");
          }
        if (true == m_spec.m_count_chars)
          {
            m_outstream.writeBytes("\t\t++yy_char_count;\n");
          }
        m_outstream.writeBytes("\t\t++yy_buffer_start;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_pushback */
        m_outstream.writeBytes("\tprivate void yy_pushback () {\n");
        m_outstream.writeBytes("\t\t--yy_buffer_end;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_mark_start */
        m_outstream.writeBytes("\tprivate void yy_mark_start () {\n");
        if (true == m_spec.m_count_lines || true == m_spec.m_count_chars)
          {
            if (true == m_spec.m_count_lines)
              {
                m_outstream.writeBytes("\t\tint i;\n");
                m_outstream.writeBytes("\t\tfor (i = yy_buffer_start; " 
                                       + "i < yy_buffer_index; ++i) {\n");
                if (true == m_spec.m_unix)
                  {
                    m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i]) {\n");
                  }
                else
                  {             
                    m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i] || " 
                                           + "(byte) '\\r' == yy_buffer[i]) {\n");
                  }
                m_outstream.writeBytes("\t\t\t\t++yy_line_count;  yy_char_count = 0;\n"); //**NS**
                m_outstream.writeBytes("\t\t\t}\n");
                m_outstream.writeBytes("\t\t++yy_char_count;\n"); //**NS**               
                m_outstream.writeBytes("\t\t}\n");
              }
            if (true == m_spec.m_count_chars)
              {
//**NS**                m_outstream.writeBytes("\t\tyy_char_count = yy_char_count\n"); 
//**NS**                m_outstream.writeBytes("\t\t\t+ yy_buffer_index - yy_buffer_start;\n");
              }
          }
        m_outstream.writeBytes("\t\tyy_buffer_start = yy_buffer_index;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_mark_end */
        m_outstream.writeBytes("\tprivate void yy_mark_end () {\n");
        m_outstream.writeBytes("\t\tyy_buffer_end = yy_buffer_index;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_to_mark */
        m_outstream.writeBytes("\tprivate void yy_to_mark () {\n");
        m_outstream.writeBytes("\t\tyy_buffer_index = yy_buffer_end;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_gettext */
        m_outstream.writeBytes("\tprivate java.lang.String yy_gettext () {\n");
        m_outstream.writeBytes("\t\treturn (new java.lang.String(yy_buffer,0,\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_start,\n");
        m_outstream.writeBytes("\t\t\tyy_buffer_end - yy_buffer_start));\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_getcharArray */
        m_outstream.writeBytes("private char[] yy_getcharArray()\n"); 
        m_outstream.writeBytes("\t{\n");  	
        m_outstream.writeBytes("\tint  count   = yy_buffer_end - yy_buffer_start;\n");
        m_outstream.writeBytes("\tchar value[] = new char[count];\n");
        m_outstream.writeBytes("\tfor( int i = count ; i-- > 0 ; )\n");
        m_outstream.writeBytes("\t\tvalue[i] = (char) (yy_buffer[i + yy_buffer_start] & 0xff);\n");
        m_outstream.writeBytes("\treturn value;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_getchar */
        if (true == m_spec.m_count_chars)
          {
            m_outstream.writeBytes("\tprivate int yy_getchar () {\n");
            m_outstream.writeBytes("\t\treturn yy_char_count;\n");
            m_outstream.writeBytes("\t}\n");
          }

        /* Function: yy_getline */
        if (true == m_spec.m_count_lines)
          {
            m_outstream.writeBytes("\tprivate int yy_getline () {\n");
            m_outstream.writeBytes("\t\treturn yy_line_count;\n");
            m_outstream.writeBytes("\t}\n");
          }

        /* Function: yy_double */
        m_outstream.writeBytes("\tprivate byte[] yy_double (byte buf[]) {\n");
        m_outstream.writeBytes("\t\tint i;\n\t\tbyte newbuf[];\n");
        m_outstream.writeBytes("\t\tnewbuf = new byte[2*buf.length];\n");
        m_outstream.writeBytes("\t\tfor (i = 0; i < buf.length; ++i) {\n");
        m_outstream.writeBytes("\t\t\tnewbuf[i] = buf[i];\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\t\treturn newbuf;\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_error */
        m_outstream.writeBytes("\tprivate final int YY_E_INTERNAL = 0;\n");
        m_outstream.writeBytes("\tprivate final int YY_E_MATCH = 1;\n");
        m_outstream.writeBytes("\tprivate java.lang.String yy_error_string[] = {\n");
        m_outstream.writeBytes("\t\t\"Error: Internal error.\\n\",\n");
        m_outstream.writeBytes("\t\t\"Error: Unmatched input.\\n\"\n");
        m_outstream.writeBytes("\t};\n");
        m_outstream.writeBytes("\tprivate void yy_error (int code,boolean fatal) {\n");
        m_outstream.writeBytes("\t\tjava.lang.System.out.print(yy_error_string[code]);\n");
        m_outstream.writeBytes("\t\tjava.lang.System.out.flush();\n");
        m_outstream.writeBytes("\t\tif (true == fatal) {\n");
        m_outstream.writeBytes("\t\t\tthrow new Error(\"Fatal Error.\\n\");\n");
        m_outstream.writeBytes("\t\t}\n");
        m_outstream.writeBytes("\t}\n");

        /* Function: yy_next */
        /*m_outstream.writeBytes("\tprivate int yy_next (int current,byte lookahead) {\n");
        m_outstream.writeBytes("\t\treturn yy_nxt[yy_rmap[current]][yy_cmap[lookahead]];\n");
        m_outstream.writeBytes("\t}\n");*/

        /* Function: yy_accept */
        /*m_outstream.writeBytes("\tprivate int yy_accept (int current) {\n");
        m_outstream.writeBytes("\t\treturn yy_acpt[current];\n");
        m_outstream.writeBytes("\t}\n");*/
      }

  /***************************************************************
    Function: emit_header
    Description: Emits class header.
    **************************************************************/
  private void emit_header
    (
     )
      throws java.io.IOException
      {
        if (OAdukKIqY.DEBUG)
          {
            OAdukKIqY.assert(null != m_spec);
            OAdukKIqY.assert(null != m_outstream);
          }

        m_outstream.writeBytes("\n\nclass ");
        m_outstream.writeBytes(new String(m_spec.m_class_name,0,
                                          m_spec.m_class_name.length));
        m_outstream.writeBytes(" {\n");
      }

  /***************************************************************
    Function: emit_table
    Description: Emits transition table.
    **************************************************************/
  private void emit_table
    (
     )
      throws java.io.IOException
      {
        int i;
        int elem;
        int size;
        aeDkYlUOm dtrans;
        boolean is_start;
        boolean is_end;
        TdLZzxjmB accept;

        if (OAdukKIqY.DEBUG)
          {
            OAdukKIqY.assert(null != m_spec);
            OAdukKIqY.assert(null != m_outstream);
          }

        m_outstream.writeBytes("\tprivate byte yy_acpt[] = {\n");  //**NS**
        size = m_spec.m_accept_vector.size();
        for (elem = 0; elem < size; ++elem)
          {
            accept = (TdLZzxjmB) m_spec.m_accept_vector.elementAt(elem);
            
            if (null != accept)
              {
                is_start = (0 != (m_spec.m_anchor_array[elem] & yCWZtShZT.START));
                is_end = (0 != (m_spec.m_anchor_array[elem] & yCWZtShZT.END));
                
                if (true == is_start && true == is_end)
                  {
                    m_outstream.writeBytes("\t\tYY_START | YY_END");
                  }
                else if (true == is_start)
                  {
                    m_outstream.writeBytes("\t\tYY_START");
                  }
                else if (true == is_end)
                  {
                    m_outstream.writeBytes("\t\tYY_END");
                  }
                else
                  {
                    m_outstream.writeBytes("\t\tYY_NO_ANCHOR");
                  }
              }
            else 
              {
                m_outstream.writeBytes("\t\tYY_NOT_ACCEPT");
              }
            
            if (elem < size - 1)
              {
                m_outstream.writeBytes(",");
              }
            
            m_outstream.writeBytes("\n");
          }
        m_outstream.writeBytes("\t};\n");

        m_outstream.writeBytes("\tprivate short yy_cmap[] = {\n\t\t");  //**NS**
        for (i = 0; i < m_spec.m_col_map.length; ++i)
          {
            m_outstream.writeBytes((new Integer(m_spec.m_col_map[i])).toString());
            
            if (i < m_spec.m_col_map.length - 1)
              {
                m_outstream.writeBytes(",");
              }

            if (0 == ((i + 1) % 8))
              {
                m_outstream.writeBytes("\n\t\t");
              }
            else
              {
                m_outstream.writeBytes(" ");
              }
          }
        m_outstream.writeBytes("\n\t};\n");

        m_outstream.writeBytes("\tprivate short yy_rmap[] = {\n\t\t");  //**NS**
        for (i = 0; i < m_spec.m_row_map.length; ++i)
          {
            m_outstream.writeBytes((new Integer(m_spec.m_row_map[i])).toString());
            
            if (i < m_spec.m_row_map.length - 1)
              {
                m_outstream.writeBytes(",");
              }

            if (0 == ((i + 1) % 8))
              {
                m_outstream.writeBytes("\n\t\t");
              }
            else
              {
                m_outstream.writeBytes(" ");
              }
          }
        m_outstream.writeBytes("\n\t};\n");

        m_outstream.writeBytes("\tprivate short yy_nxt[][] = {\n");  //**NS**
        size = m_spec.m_dtrans_vector.size();
        for (elem = 0; elem < size; ++elem)
          {
            dtrans = (aeDkYlUOm) m_spec.m_dtrans_vector.elementAt(elem);
            
            m_outstream.writeBytes("\t\t{ ");
        
            for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
              {
                m_outstream.writeBytes((new Integer(dtrans.m_dtrans[i])).toString());
                
                if (i < m_spec.m_dtrans_ncols - 1)
                  {
                    m_outstream.writeBytes(",");
                  }
                
                if (0 == ((i + 1) % 8))
                  {
                    m_outstream.writeBytes("\n\t\t\t");
                  }
                else
                  {
                    m_outstream.writeBytes(" ");
                  }
              }

            m_outstream.writeBytes("\n\t\t}");

            if (elem < size - 1)
              {
                m_outstream.writeBytes(",");
              }

            m_outstream.writeBytes("\n");
          }
        m_outstream.writeBytes("\t};\n");
      }

  /***************************************************************
    Function: emit_driver
    Description: 
    **************************************************************/
  private void emit_driver
    (
     )
      throws java.io.IOException
        {
          if (OAdukKIqY.DEBUG)
            {
              OAdukKIqY.assert(null != m_spec);
              OAdukKIqY.assert(null != m_outstream);
            }
          
          emit_table();

          if (true == m_spec.m_integer_type)
            {
              m_outstream.writeBytes("\tpublic int ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }
          else if (true == m_spec.m_intwrap_type)
            {
              m_outstream.writeBytes("\tpublic java.lang.Integer ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }
          else
            {
              m_outstream.writeBytes("\tpublic ");
              m_outstream.writeBytes(new String(m_spec.m_type_name));
              m_outstream.writeBytes(" ");
              m_outstream.writeBytes(new String(m_spec.m_function_name));
              m_outstream.writeBytes(" ()\n");
            }

          /*m_outstream.writeBytes("\t\tthrows java.io.IOException {\n");*/
          m_outstream.writeBytes("\t\tthrows java.io.IOException");
          if (null != m_spec.m_yylex_throw_code)
            {
              m_outstream.writeBytes(", "); 
              m_outstream.writeBytes(new String(m_spec.m_yylex_throw_code,0,
                                                m_spec.m_yylex_throw_read));
              m_outstream.writeBytes("\n\t\t{\n");
            }
          else
            {
              m_outstream.writeBytes(" {\n");
            }

          m_outstream.writeBytes("\t\tint yy_lookahead;\n");
          m_outstream.writeBytes("\t\tint yy_anchor = YY_NO_ANCHOR;\n");
          /*m_outstream.writeBytes("\t\tint yy_state "
            + "= yy_initial_dtrans(yy_lexical_state);\n");*/
          m_outstream.writeBytes("\t\tint yy_state " 
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\tint yy_next_state = YY_NO_STATE;\n");
          /*m_outstream.writeBytes("\t\tint yy_prev_state = YY_NO_STATE;\n");*/
          m_outstream.writeBytes("\t\tint yy_last_accept_state = YY_NO_STATE;\n");
          m_outstream.writeBytes("\t\tboolean yy_initial = true;\n");
          m_outstream.writeBytes("\t\tbyte yy_this_accept;\n"); // **NS**
          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\tint yychar;\n");
            }
          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\tint yyline;\n");
            }
          m_outstream.writeBytes("\t\tjava.lang.String yytext;\n");
          m_outstream.writeBytes("\n");

          m_outstream.writeBytes("\t\tyy_mark_start();\n");
          /*m_outstream.writeBytes("\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\tyy_mark_end();\n");
          m_outstream.writeBytes("\t\t}\n");

          if (NOT_EDBG)
            {
              m_outstream.writeBytes("\t\tjava.lang.System.out.println(\"Begin\");\n");
            }

          m_outstream.writeBytes("\t\twhile (true) {\n");

          m_outstream.writeBytes("\t\t\tyy_lookahead = yy_advance();\n");
          m_outstream.writeBytes("\t\t\tyy_next_state = YY_F;\n");
          m_outstream.writeBytes("\t\t\tif (YYEOF != yy_lookahead) {\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_next_state = "
                                 + "yy_next(yy_state,yy_lookahead);\n");*/
          m_outstream.writeBytes("\t\t\t\tyy_next_state = "
                                 + "yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];\n");
          
          m_outstream.writeBytes("\t\t\t}\n");

          if (NOT_EDBG)
            {
              m_outstream.writeBytes("java.lang.System.out.println(\"Current state: \"" 
                                     + " + yy_state\n");
              m_outstream.writeBytes("+ \"\tCurrent input: \"\n"); 
              m_outstream.writeBytes(" + ((char) yy_lookahead));\n");
            }
          if (NOT_EDBG)
            {
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"State = \"" 
                                     + "+ yy_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Accepting status = \"" 
                                     + "+ yy_this_accept);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Last accepting state = \"" 
                                     + "+ yy_last_accept_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Next state = \"" 
                                     + "+ yy_next_state);\n");
              m_outstream.writeBytes("\t\t\tjava.lang.System.out.println(\"Lookahead input = \"" 
                                     + "+ ((char) yy_lookahead));\n");
            }

          m_outstream.writeBytes("\t\t\tif (YY_F != yy_next_state) {\n");
          m_outstream.writeBytes("\t\t\t\tyy_state = yy_next_state;\n");
          m_outstream.writeBytes("\t\t\t\tyy_initial = false;\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_mark_end();\n");
          m_outstream.writeBytes("\t\t\t\t}\n");
          /*m_outstream.writeBytes("\t\t\t\tyy_prev_state = yy_state;\n");*/
          /*m_outstream.writeBytes("\t\t\t\tyy_state = yy_next_state;\n");*/
          m_outstream.writeBytes("\t\t\t}\n");

          m_outstream.writeBytes("\t\t\telse {\n");
          m_outstream.writeBytes("\t\t\t\tif (YYEOF == yy_lookahead " 
                                 + "&& true == yy_initial) {\n");
          if (null != m_spec.m_eof_code)
            {
              m_outstream.writeBytes("\t\t\t\t\tyy_do_eof();\n");
            }

          if (true == m_spec.m_integer_type || true == m_spec.m_yyeof)
            {
              m_outstream.writeBytes("\t\t\t\t\treturn YYEOF;\n");
            }
          else if (null != m_spec.m_eof_value_code) 
            {
              m_outstream.writeBytes(new String(m_spec.m_eof_value_code,0,
                                                m_spec.m_eof_value_read));
            }
          else
            {
              m_outstream.writeBytes("\t\t\t\t\treturn null;\n");
            }

          m_outstream.writeBytes("\t\t\t\t}\n");
          
          m_outstream.writeBytes("\t\t\t\telse if (YY_NO_STATE == yy_last_accept_state) {\n");
          

          /*m_outstream.writeBytes("\t\t\t\t\tyy_error(YY_E_MATCH,false);\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_initial = true;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_state "
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_next_state = YY_NO_STATE;\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_prev_state = YY_NO_STATE;\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_mark_start();\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");*/

          m_outstream.writeBytes("\t\t\t\t\tthrow (new Error(\"Lexical Error: Unmatched Input.\"));\n");
          m_outstream.writeBytes("\t\t\t\t}\n");

          m_outstream.writeBytes("\t\t\t\telse {\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_to_mark();\n");

          m_outstream.writeBytes("\t\t\t\t\tyy_anchor = yy_acpt[yy_last_accept_state];\n");
          /*m_outstream.writeBytes("\t\t\t\t\tyy_anchor " 
            + "= yy_accept(yy_last_accept_state);\n");*/
          m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_END & yy_anchor)) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_pushback();\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");
          m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_START & yy_anchor)) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_move_start();\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");

          if (true == m_spec.m_count_chars)
            {
              m_outstream.writeBytes("\t\t\t\t\tyychar = yy_getchar();\n");
            }

          if (true == m_spec.m_count_lines)
            {
              m_outstream.writeBytes("\t\t\t\t\tyyline = yy_getline();\n");
            }

          m_outstream.writeBytes("\t\t\t\t\tyytext = yy_gettext();\n");

          m_outstream.writeBytes("\t\t\t\t\tswitch (yy_last_accept_state) {\n");

          emit_actions("\t\t\t\t\t");

          m_outstream.writeBytes("\t\t\t\t\tdefault:\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_error(YY_E_INTERNAL,false);\n");
          /*m_outstream.writeBytes("\t\t\t\t\t\treturn null;\n");*/
          m_outstream.writeBytes("\t\t\t\t\tcase -1:\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");
          
          m_outstream.writeBytes("\t\t\t\t\tyy_initial = true;\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_state "
                                 + "= yy_state_dtrans[yy_lexical_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tyy_next_state = YY_NO_STATE;\n");
          /*m_outstream.writeBytes("\t\t\t\t\tyy_prev_state = YY_NO_STATE;\n");*/
          m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;\n");

          m_outstream.writeBytes("\t\t\t\t\tyy_mark_start();\n");

          /*m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_accept(yy_state);\n");*/
          m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
          m_outstream.writeBytes("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
          m_outstream.writeBytes("\t\t\t\t\t\tyy_last_accept_state = yy_state;\n");
          m_outstream.writeBytes("\t\t\t\t\t}\n");

          m_outstream.writeBytes("\t\t\t\t}\n");          
          m_outstream.writeBytes("\t\t\t}\n");
          m_outstream.writeBytes("\t\t}\n");
          m_outstream.writeBytes("\t}\n");

          /*m_outstream.writeBytes("\t\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t\t\n");
          m_outstream.writeBytes("\t\t}\n");*/
        }
  
  /***************************************************************
    Function: emit_actions
    Description:     
    **************************************************************/
  private void emit_actions 
    (
     String tabs
     )
      throws java.io.IOException
        {
          int elem;
          int size;
          int bogus_index;
          TdLZzxjmB accept;
          
          if (OAdukKIqY.DEBUG)
            {
              OAdukKIqY.assert(m_spec.m_accept_vector.size() 
                              == m_spec.m_anchor_array.length);
            }

          bogus_index = -2;
          size = m_spec.m_accept_vector.size();
          for (elem = 0; elem < size; ++elem)
            {
              accept = (TdLZzxjmB) m_spec.m_accept_vector.elementAt(elem);
              if (null != accept) 
                {
                  m_outstream.writeBytes(tabs + "case " + elem 
                                         /*+ (new Integer(elem)).toString()*/
                                         + ":\n");
                  m_outstream.writeBytes(tabs + "\t");
                  m_outstream.writeBytes(new String(accept.m_action,0,
                                                    accept.m_action_read));
                  m_outstream.writeBytes("\n");
                  m_outstream.writeBytes(tabs + "case " + bogus_index + ":\n");
                  m_outstream.writeBytes(tabs + "\tbreak;\n");
                  --bogus_index;
                }
            }
        }
  
  /***************************************************************
    Function: emit_footer
    Description:     
    **************************************************************/
  private void emit_footer
    (
     )
      throws java.io.IOException
      {
        if (OAdukKIqY.DEBUG)
          {
            OAdukKIqY.assert(null != m_spec);
            OAdukKIqY.assert(null != m_outstream);
          }

        m_outstream.writeBytes("}\n");
      }
}

/***************************************************************
  Class: bSpXVtXss
  **************************************************************/
final class bSpXVtXss //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  Vector m_nfa_set; /* Vector of pHNWlbrmz states in dfa state. */
  BitSet m_nfa_bit; /* BitSet representation of pHNWlbrmz labels. */
  TdLZzxjmB m_accept; /* Accepting actions, or null if nonaccepting state. */
  int m_anchor; /* Anchors on regular expression. */
  int m_accept_index; /* pHNWlbrmz index corresponding to accepting actions. */

  /***************************************************************
    Function: bSpXVtXss
    Description: Constructor.
    **************************************************************/
  bSpXVtXss
    (
     )
      {
        m_nfa_set = null;
        m_nfa_bit = null;
        m_accept = null;
        m_anchor = yCWZtShZT.NONE;
        m_accept_index = -1;
      }
}

/***************************************************************
  Class: bJiLhHQcB
  **************************************************************/
final class bJiLhHQcB //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private yCWZtShZT m_spec;
  private ctxmGlswy m_lexGen;
  private gVugJSDwR m_input;

  /***************************************************************
    Function: bJiLhHQcB
    Description: Constructor.
    **************************************************************/
  bJiLhHQcB
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: reset
    Description: Resets bJiLhHQcB member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_input = null;
        m_lexGen = null;
        m_spec = null;
      }

  /***************************************************************
    Function: set
    Description: Sets bJiLhHQcB member variables.
    **************************************************************/
  private void set
    (
     ctxmGlswy lexGen,
     yCWZtShZT spec,
     gVugJSDwR input
     )
      {
        if (OAdukKIqY.DEBUG)
          {
            OAdukKIqY.assert(null != input);
            OAdukKIqY.assert(null != lexGen);
            OAdukKIqY.assert(null != spec);
          }

        m_input = input;
        m_lexGen = lexGen;
        m_spec = spec;
      }

  /***************************************************************
    Function: thompson
    Description: High level access function to module.
    Deposits result in input yCWZtShZT.
    **************************************************************/
  void thompson
    (
     ctxmGlswy lexGen,
     yCWZtShZT spec,
     gVugJSDwR input
     )
      throws java.io.IOException      
        {       
          int i;
          pHNWlbrmz elem;
          int size;

          /* Set member variables. */
          reset();
          set(lexGen,spec,input);
          size = m_spec.m_states.size();       
          m_spec.m_state_rules = new Vector[size];
          for (i = 0; i < size; ++i)
            {       
              m_spec.m_state_rules[i] = new Vector();
            }

          /* Initialize current token variable 
             and create nfa. */
          /*m_spec.m_current_token = m_lexGen.EOS;
          m_lexGen.advance();*/

          m_spec.m_nfa_start = machine();
          
          /* Set labels in created nfa machine. */
          size = m_spec.m_nfa_states.size();
          for (i = 0; i < size; ++i)
            {        
              elem = (pHNWlbrmz) m_spec.m_nfa_states.elementAt(i);
              elem.m_label = i;
            }

          /* Debugging output. */
          if (OAdukKIqY.DO_DEBUG)
            {
              m_lexGen.print_nfa();
            }

          if (true == m_spec.m_verbose)
            {
              System.out.println("NFA comprised of " 
                                 + (m_spec.m_nfa_states.size() + 1) 
                                 + " states.");
            }

          reset();
        }
     
  /***************************************************************
    Function: discardpHNWlbrmz
    Description: 
    **************************************************************/
  private void discardpHNWlbrmz
    (
     pHNWlbrmz nfa
     )
      {
        m_spec.m_nfa_states.removeElement(nfa);
      }

  /***************************************************************
    Function: processStates
    Description:
    **************************************************************/
  private void processStates
    (
     BitSet states,
     pHNWlbrmz current
     )
      {
        int size;
        int i;
        
        size = m_spec.m_states.size();
        for (i = 0; i <  size; ++i)
          {
            if (true == states.get(i))
              {
                m_spec.m_state_rules[i].addElement(current);
              }
          }
      }

  /***************************************************************
    Function: machine
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private pHNWlbrmz machine
    (
     )
      throws java.io.IOException 
      {
        pHNWlbrmz start;
        pHNWlbrmz p;
        BitSet states;

        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.enter("machine",m_spec.m_lexeme,m_spec.m_current_token);
          }

        states = m_lexGen.getStates();

        /* Begin: Added for states. */
        m_spec.m_current_token = m_lexGen.EOS;
        m_lexGen.advance();
        /* End: Added for states. */
        
        start = lgHWDnTtZ.newpHNWlbrmz(m_spec);
        p = start;
        p.m_next = rule();

        processStates(states,p.m_next);

        while (m_lexGen.END_OF_INPUT != m_spec.m_current_token)
          {
            /* Make state changes HERE. */
            states = m_lexGen.getStates();
        
            /* Begin: Added for states. */
            m_lexGen.advance();
            if (m_lexGen.END_OF_INPUT == m_spec.m_current_token)
              { 
                break;
              }
            /* End: Added for states. */
            
            p.m_next2 = lgHWDnTtZ.newpHNWlbrmz(m_spec);
            p = p.m_next2;
            p.m_next = rule();
            
            processStates(states,p.m_next);
          }

        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.leave("machine",m_spec.m_lexeme,m_spec.m_current_token);
          }

        return start;
      }
  
  /***************************************************************
    Function: rule
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private pHNWlbrmz rule
    (
     )
      throws java.io.IOException 
      {
        ysfxQMQHy pair; 
        pHNWlbrmz p;
        pHNWlbrmz start = null;
        pHNWlbrmz end = null;
        int anchor = yCWZtShZT.NONE;

        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.enter("rule",m_spec.m_lexeme,m_spec.m_current_token);
          }

        pair = lgHWDnTtZ.newysfxQMQHy();

        if (m_lexGen.AT_BOL == m_spec.m_current_token)
          {
            start = lgHWDnTtZ.newpHNWlbrmz(m_spec);
            start.m_edge = '\n';
            anchor = anchor | yCWZtShZT.START;
            m_lexGen.advance();

            expr(pair);
            start.m_next = pair.m_start;
            end = pair.m_end;
          }
        else
          {
            expr(pair);
            start = pair.m_start;
            end = pair.m_end;
          }

        if (m_lexGen.AT_EOL == m_spec.m_current_token)
          {
            m_lexGen.advance();
            end.m_next = lgHWDnTtZ.newpHNWlbrmz(m_spec);
            
            /* This is the way he does it. */
            end.m_edge = pHNWlbrmz.CCL;
            end.m_set = new FYZwuamNE();

            end.m_set.add('\n');

            if (false == m_spec.m_unix)
              {
                end.m_set.add('\r');
              }
                
            end = end.m_next;
            anchor = anchor | yCWZtShZT.END;
          }

        /* Handle end of regular expression.  See page 103. */
        end.m_accept = m_lexGen.packAccept();
        end.m_anchor = anchor;

        /* Begin: Removed for states. */
        /*m_lexGen.advance();*/
        /* End: Removed for states. */

        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.leave("rule",m_spec.m_lexeme,m_spec.m_current_token);
          }

        return start;
      }
            
  /***************************************************************
    Function: expr
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void expr
    (
     ysfxQMQHy pair
     )
      throws java.io.IOException 
      {
        ysfxQMQHy e2_pair;
        pHNWlbrmz p;
        
        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.enter("expr",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (OAdukKIqY.DEBUG)
          {
            OAdukKIqY.assert(null != pair);
          }

        e2_pair = lgHWDnTtZ.newysfxQMQHy();

        cat_expr(pair);
        
        while (m_lexGen.OR == m_spec.m_current_token)
          {
            m_lexGen.advance();
            cat_expr(e2_pair);

            p = lgHWDnTtZ.newpHNWlbrmz(m_spec);
            p.m_next2 = e2_pair.m_start;
            p.m_next = pair.m_start;
            pair.m_start = p;
            
            p = lgHWDnTtZ.newpHNWlbrmz(m_spec);
            pair.m_end.m_next = p;
            e2_pair.m_end.m_next = p;
            pair.m_end = p;
          }

        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.leave("expr",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
            
  /***************************************************************
    Function: cat_expr
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void cat_expr
    (
     ysfxQMQHy pair
     )
      throws java.io.IOException 
      {
        ysfxQMQHy e2_pair;

        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.enter("cat_expr",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (OAdukKIqY.DEBUG)
          {
            OAdukKIqY.assert(null != pair);
          }
        
        e2_pair = lgHWDnTtZ.newysfxQMQHy();
        
        if (true == first_in_cat(m_spec.m_current_token))
          {
            factor(pair);
          }

        while (true == first_in_cat(m_spec.m_current_token))
          {
            factor(e2_pair);

            /* Destroy */
            pair.m_end.mimic(e2_pair.m_start);
            discardpHNWlbrmz(e2_pair.m_start);
            
            pair.m_end = e2_pair.m_end;
          }

        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.leave("cat_expr",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
  
  /***************************************************************
    Function: first_in_cat
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private boolean first_in_cat
    (
     int token
     )
      {
        switch (token)
          {
          case m_lexGen.CLOSE_PAREN:
          case m_lexGen.AT_EOL:
          case m_lexGen.OR:
          case m_lexGen.EOS:
            return false;
            
          case m_lexGen.CLOSURE:
          case m_lexGen.PLUS_CLOSE:
          case m_lexGen.OPTIONAL:
            KzuxJIHqb.parse_error(KzuxJIHqb.E_CLOSE,m_input.m_line_number);
            return false;

          case m_lexGen.CCL_END:
            KzuxJIHqb.parse_error(KzuxJIHqb.E_BRACKET,m_input.m_line_number);
            return false;

          case m_lexGen.AT_BOL:
            KzuxJIHqb.parse_error(KzuxJIHqb.E_BOL,m_input.m_line_number);
            return false;

          default:
            break;
          }

        return true;
      }

  /***************************************************************
    Function: factor
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void factor
    (
     ysfxQMQHy pair
     )
      throws java.io.IOException 
      {
        pHNWlbrmz start = null;
        pHNWlbrmz end = null;

        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.enter("factor",m_spec.m_lexeme,m_spec.m_current_token);
          }

        term(pair);

        if (m_lexGen.CLOSURE == m_spec.m_current_token
            || m_lexGen.PLUS_CLOSE == m_spec.m_current_token
            || m_lexGen.OPTIONAL == m_spec.m_current_token)
          {
            start = lgHWDnTtZ.newpHNWlbrmz(m_spec);
            end = lgHWDnTtZ.newpHNWlbrmz(m_spec);
            
            start.m_next = pair.m_start;
            pair.m_end.m_next = end;

            if (m_lexGen.CLOSURE == m_spec.m_current_token
                || m_lexGen.OPTIONAL == m_spec.m_current_token)
              {
                start.m_next2 = end;
              }
            
            if (m_lexGen.CLOSURE == m_spec.m_current_token
                || m_lexGen.PLUS_CLOSE == m_spec.m_current_token)
              {
                pair.m_end.m_next2 = pair.m_start;
              }
            
            pair.m_start = start;
            pair.m_end = end;
            m_lexGen.advance();
          }

        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.leave("factor",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
      
  /***************************************************************
    Function: term
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void term
    (
     ysfxQMQHy pair
     )
      throws java.io.IOException 
      {
        pHNWlbrmz start;
        int c;

        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.enter("term",m_spec.m_lexeme,m_spec.m_current_token);
          }

        if (m_lexGen.OPEN_PAREN == m_spec.m_current_token)
          {
            m_lexGen.advance();
            expr(pair);

            if (m_lexGen.CLOSE_PAREN == m_spec.m_current_token)
              {
                m_lexGen.advance();
              }
            else
              {
                KzuxJIHqb.parse_error(KzuxJIHqb.E_SYNTAX,m_input.m_line_number);
              }
          }
        else
          {
            start = lgHWDnTtZ.newpHNWlbrmz(m_spec);
            pair.m_start = start;

            start.m_next = lgHWDnTtZ.newpHNWlbrmz(m_spec);
            pair.m_end = start.m_next;

            if (false == (m_lexGen.ANY == m_spec.m_current_token
                          || m_lexGen.CCL_START == m_spec.m_current_token))
              {
                start.m_edge = m_spec.m_lexeme;
                m_lexGen.advance();
              }
            else
              {
                start.m_edge = pHNWlbrmz.CCL;
                
                start.m_set = new FYZwuamNE();

                /* Match dot (.) using character class. */
                if (m_lexGen.ANY == m_spec.m_current_token)
                  {
                    start.m_set.add((byte) '\n');
                    if (false == m_spec.m_unix)
                      {
                        start.m_set.add((byte) '\r');
                      }
                    start.m_set.complement();
                  }
                else
                  {
                    m_lexGen.advance();
                    if (m_lexGen.AT_BOL == m_spec.m_current_token)
                      {
                        m_lexGen.advance();

                        /*start.m_set.add((byte) '\n');
                        if (false == m_spec.m_unix)
                          {
                            start.m_set.add((byte) '\r');
                          }*/
                        start.m_set.complement();
                      }
                    if (false == (m_lexGen.CCL_END == m_spec.m_current_token))
                      {
                        dodash(start.m_set);
                      }
                    /*else
                      {
                        for (c = 0; c <= ' '; ++c)
                          {
                            start.m_set.add((byte) c);
                          }
                      }*/
                  }
                m_lexGen.advance();
              }
          }

        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.leave("term",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }

  /***************************************************************
    Function: dodash
    Description: Recursive descent regular expression parser.
    **************************************************************/
  private void dodash
    (
     FYZwuamNE set
     )
      throws java.io.IOException 
        {
          int first = -1;
          
          if (OAdukKIqY.DESCENT_DEBUG)
            {
              OAdukKIqY.enter("dodash",m_spec.m_lexeme,m_spec.m_current_token);
            }
          
          while (m_lexGen.EOS != m_spec.m_current_token 
                 && m_lexGen.CCL_END != m_spec.m_current_token)
            {
              if (m_lexGen.DASH == m_spec.m_current_token)
                {
                  if (OAdukKIqY.DEBUG)
                    {
                      OAdukKIqY.assert(-1 != first);
                    }
                  
                  m_lexGen.advance();
                  for ( ; first <= m_spec.m_lexeme; ++first)
                    {
                      set.add(first);
                    }  
                }
              else
                {
                  first = m_spec.m_lexeme;
                  set.add(m_spec.m_lexeme);
                }

              m_lexGen.advance();
            }
          
        if (OAdukKIqY.DESCENT_DEBUG)
          {
            OAdukKIqY.leave("dodash",m_spec.m_lexeme,m_spec.m_current_token);
          }
      }
}

/***************************************************************
  Class: cDgCXPvYb
 **************************************************************/
final class cDgCXPvYb //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  yCWZtShZT m_spec;
  Vector m_group;
  int m_ingroup[];

  /***************************************************************
    Function: cDgCXPvYb
    Description: Constructor.
    **************************************************************/
  cDgCXPvYb 
    (
     )
      {
        reset();
      }
  
  /***************************************************************
    Function: reset
    Description: Resets member variables.
    **************************************************************/
  private void reset
    (
     )
      {
        m_spec = null;
        m_group = null;
        m_ingroup = null;
      }

  /***************************************************************
    Function: set
    Description: Sets member variables.
    **************************************************************/
  private void set
    (
     yCWZtShZT spec
     )
      {
        if (OAdukKIqY.DEBUG)
          {
            OAdukKIqY.assert(null != spec);
          }

        m_spec = spec;
        m_group = null;
        m_ingroup = null;
      }

  /***************************************************************
    Function: min_dfa
    Description: High-level access function to module.
    **************************************************************/
  void min_dfa
    (
     yCWZtShZT spec
     )
      {
        set(spec);

        /* Remove redundant states. */
        minimize();

        /* Column and row compression. 
           Save accept states in auxilary vector. */
        reduce();

        reset();
      }

  /***************************************************************
    Function: col_copy
    Description: Copies source column into destination column.
    **************************************************************/
  private void col_copy
    (
     int dest,
     int src
     )
      {
        int n;
        int i;
        aeDkYlUOm dtrans;

        n = m_spec.m_dtrans_vector.size();
        for (i = 0; i < n; ++i)
          {
            dtrans = (aeDkYlUOm) m_spec.m_dtrans_vector.elementAt(i);
            dtrans.m_dtrans[dest] = dtrans.m_dtrans[src]; 
          }
      } 
        
  /***************************************************************
    Function: row_copy
    Description: Copies source row into destination row.
    **************************************************************/
  private void row_copy
    (
     int dest,
     int src
     )
      {
        aeDkYlUOm dtrans;

        dtrans = (aeDkYlUOm) m_spec.m_dtrans_vector.elementAt(src);
        m_spec.m_dtrans_vector.setElementAt(dtrans,dest); 
      } 
        
  /***************************************************************
    Function: col_equiv
    Description: 
    **************************************************************/
  private boolean col_equiv
    (
     int col1,
     int col2
     )
      {
        int n;
        int i;
        aeDkYlUOm dtrans;

        n = m_spec.m_dtrans_vector.size();
        for (i = 0; i < n; ++i)
          {
            dtrans = (aeDkYlUOm) m_spec.m_dtrans_vector.elementAt(i);
            if (dtrans.m_dtrans[col1] != dtrans.m_dtrans[col2]) 
              {
                return false;
              }
          }
        
        return true;
      }

  /***************************************************************
    Function: row_equiv
    Description: 
    **************************************************************/
  private boolean row_equiv
    (
     int row1,
     int row2
     )
      {
        int i;
        aeDkYlUOm dtrans1;
        aeDkYlUOm dtrans2;

        dtrans1 = (aeDkYlUOm) m_spec.m_dtrans_vector.elementAt(row1);
        dtrans2 = (aeDkYlUOm) m_spec.m_dtrans_vector.elementAt(row2);
        
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (dtrans1.m_dtrans[i] != dtrans2.m_dtrans[i]) 
              {
                return false;
              }
          }
        
        return true;
      }

  /***************************************************************
    Function: reduce
    Description: 
    **************************************************************/
  private void reduce
    (
     )
      {
        int i;
        int j;
        int k;
        int nrows;
        int reduced_ncols;
        int reduced_nrows;
        BitSet set;
        aeDkYlUOm dtrans;
        int size;

        set = new BitSet();
        
        /* Save accept nodes and anchor entries. */
        size = m_spec.m_dtrans_vector.size();
        m_spec.m_anchor_array = new int[size];
        m_spec.m_accept_vector = new Vector();
        for (i = 0; i < size; ++i)
          {
            dtrans = (aeDkYlUOm) m_spec.m_dtrans_vector.elementAt(i);
            m_spec.m_accept_vector.addElement(dtrans.m_accept);
            m_spec.m_anchor_array[i] = dtrans.m_anchor;
            dtrans.m_accept = null;
          }
        
        /* Allocate column map. */
        m_spec.m_col_map = new int[m_spec.m_dtrans_ncols];
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            m_spec.m_col_map[i] = -1;
          }

        /* Process columns for reduction. */
        for (reduced_ncols = 0; ; ++reduced_ncols)
          {
            if (true == OAdukKIqY.DEBUG)
              {
                for (i = 0; i < reduced_ncols; ++i)
                  {
                    OAdukKIqY.assert(-1 != m_spec.m_col_map[i]);
                  }
              }

            for (i = reduced_ncols; i < m_spec.m_dtrans_ncols; ++i)
              {
                if (-1 == m_spec.m_col_map[i])
                  {
                    break;
                  }
              }

            if (i >= m_spec.m_dtrans_ncols)
              {
                break;
              }

            if (true == OAdukKIqY.DEBUG)
              {
                OAdukKIqY.assert(false == set.get(i));
                OAdukKIqY.assert(-1 == m_spec.m_col_map[i]);
              }

            set.set(i);
            
            m_spec.m_col_map[i] = reduced_ncols;
            
            /* UNDONE: Optimize by doing all comparisons in one batch. */
            for (j = i + 1; j < m_spec.m_dtrans_ncols; ++j)
              {
                if (-1 == m_spec.m_col_map[j] && true == col_equiv(i,j))
                  {
                    m_spec.m_col_map[j] = reduced_ncols;
                  }
              }
          }

        /* Reduce columns. */
        k = 0;
        for (i = 0; i < m_spec.m_dtrans_ncols; ++i)
          {
            if (true == set.get(i))
              {
                ++k;

                set.clear(i);
                
                j = m_spec.m_col_map[i];
                
                if (true == OAdukKIqY.DEBUG)
                  {
                    OAdukKIqY.assert(j <= i);
                  }
                
                if (j == i)
                  {
                    continue;
                  }
                
                col_copy(j,i);
              }
          }
        m_spec.m_dtrans_ncols = reduced_ncols;

        if (true == OAdukKIqY.DEBUG)
          {
            OAdukKIqY.assert(k == reduced_ncols);
          }

        /* Allocate row map. */
        nrows = m_spec.m_dtrans_vector.size();
        m_spec.m_row_map = new int[nrows];
        for (i = 0; i < nrows; ++i)
          {
            m_spec.m_row_map[i] = -1;
          }

        /* Process rows to reduce. */
        for (reduced_nrows = 0; ; ++reduced_nrows)
          {
            if (true == OAdukKIqY.DEBUG)
              {
                for (i = 0; i < reduced_nrows; ++i)
                  {
                    OAdukKIqY.assert(-1 != m_spec.m_row_map[i]);
                  }
              }

            for (i = reduced_nrows; i < nrows; ++i)
              {
                if (-1 == m_spec.m_row_map[i])
                  {
                    break;
                  }
              }

            if (i >= nrows)
              {
                break;
              }

            if (true == OAdukKIqY.DEBUG)
              {
                OAdukKIqY.assert(false == set.get(i));
                OAdukKIqY.assert(-1 == m_spec.m_row_map[i]);
              }

            set.set(i);

            m_spec.m_row_map[i] = reduced_nrows;
            
            /* UNDONE: Optimize by doing all comparisons in one batch. */
            for (j = i + 1; j < nrows; ++j)
              {
                if (-1 == m_spec.m_row_map[j] && true == row_equiv(i,j))
                  {
                    m_spec.m_row_map[j] = reduced_nrows;
                  }
              }
          }

        /* Reduce rows. */
        k = 0;
        for (i = 0; i < nrows; ++i)
          {
            if (true == set.get(i))
              {
                ++k;

                set.clear(i);
                
                j = m_spec.m_row_map[i];
                
                if (true == OAdukKIqY.DEBUG)
                  {
                    OAdukKIqY.assert(j <= i);
                  }
                
                if (j == i)
                  {
                    continue;
                  }
                
                row_copy(j,i);
              }
          }
        m_spec.m_dtrans_vector.setSize(reduced_nrows);

        if (OAdukKIqY.DEBUG)
          {
            /*System.out.print("k = " + k + "\nreduced_nrows = " + reduced_nrows + "\n");*/
            OAdukKIqY.assert(k == reduced_nrows);
          }
      }

  /***************************************************************
    Function: fix_dtrans
    Description: Updates aeDkYlUOm table after minimization 
    using groups, removing redundant transition table states.
    **************************************************************/
  private void fix_dtrans
    (
     )
      {
        Vector new_vector;
        int i;
        int size;
        Vector dtrans_group;
        aeDkYlUOm first;
        int c;

        new_vector = new Vector();

        size = m_spec.m_state_dtrans.length;
        for (i = 0; i < size; ++i)
          {
            if (aeDkYlUOm.F != m_spec.m_state_dtrans[i])
              {
                m_spec.m_state_dtrans[i] = m_ingroup[m_spec.m_state_dtrans[i]];
              }
          }

        size = m_group.size();
        for (i = 0; i < size; ++i)
          {
            dtrans_group = (Vector) m_group.elementAt(i);
            first = (aeDkYlUOm) dtrans_group.elementAt(0);
            new_vector.addElement(first);

            for (c = 0; c < m_spec.m_dtrans_ncols; ++c)
              {
                if (aeDkYlUOm.F != first.m_dtrans[c])
                  {
                    first.m_dtrans[c] = m_ingroup[first.m_dtrans[c]];
                  }
              }
          }

        m_group = null;
        m_spec.m_dtrans_vector = new_vector;
      }

  /***************************************************************
    Function: minimize
    Description: Removes redundant transition table states.
    **************************************************************/
  private void minimize
    (
     )
      {
        Vector dtrans_group;
        Vector new_group;
        int i;
        int j;
        int old_group_count;
        int group_count;
        aeDkYlUOm next;
        aeDkYlUOm first;
        int goto_first;
        int goto_next;
        int c;
        int group_size;
        boolean added;

        init_groups();

        group_count = m_group.size();
        old_group_count = group_count - 1;

        while (old_group_count != group_count)
          {
            old_group_count = group_count;

            if (OAdukKIqY.DEBUG)
              {
                OAdukKIqY.assert(m_group.size() == group_count);
              }

            for (i = 0; i < group_count; ++i)
              {
                dtrans_group = (Vector) m_group.elementAt(i);

                group_size = dtrans_group.size();
                if (group_size <= 1)
                  {
                    continue;
                  }

                new_group = new Vector();
                added = false;
                
                first = (aeDkYlUOm) dtrans_group.elementAt(0);
                for (j = 1; j < group_size; ++j)
                  {
                    next = (aeDkYlUOm) dtrans_group.elementAt(j);

                    for (c = 0; c < m_spec.m_dtrans_ncols; ++c)
                      {
                        goto_first = first.m_dtrans[c];
                        goto_next = next.m_dtrans[c];

                        if (goto_first != goto_next
                            && (goto_first == aeDkYlUOm.F
                                || goto_next == aeDkYlUOm.F
                                || m_ingroup[goto_next] != m_ingroup[goto_first]))
                          {
                            if (OAdukKIqY.DEBUG)
                              {
                                OAdukKIqY.assert(dtrans_group.elementAt(j) == next);
                              }
                            
                            dtrans_group.removeElementAt(j);
                            --j;
                            --group_size;
                            new_group.addElement(next);
                            if (false == added)
                              {
                                added = true;
                                ++group_count;
                                m_group.addElement(new_group);
                              }
                            m_ingroup[next.m_label] = m_group.size() - 1;

                            if (OAdukKIqY.DEBUG)
                              {
                                OAdukKIqY.assert(m_group.contains(new_group)
                                                == true);
                                OAdukKIqY.assert(m_group.contains(dtrans_group)
                                                == true);
                                OAdukKIqY.assert(dtrans_group.contains(first)
                                                == true);
                                OAdukKIqY.assert(dtrans_group.contains(next)
                                                == false);
                                OAdukKIqY.assert(new_group.contains(first)
                                                == false);
                                OAdukKIqY.assert(new_group.contains(next)
                                                == true);
                                OAdukKIqY.assert(dtrans_group.size() == group_size);
                                OAdukKIqY.assert(i == m_ingroup[first.m_label]);
                                OAdukKIqY.assert((m_group.size() - 1) 
                                                == m_ingroup[next.m_label]);
                              }

                            break;
                          }
                      }
                  }
              }
          }

        System.out.println(m_group.size() + " states after removal of redundant states.");

        if (true == m_spec.m_verbose
            && true == OAdukKIqY.OLD_DUMP_DEBUG)
          {
            System.out.println("\nStates grouped as follows after minimization");
            pgroups();
          }

        fix_dtrans();
      }

  /***************************************************************
    Function: init_groups
    Description:
    **************************************************************/
  private void init_groups
    (
     )
      {
        int i;
        int j;
        int group_count;
        int size;
        TdLZzxjmB accept;
        aeDkYlUOm dtrans;
        Vector dtrans_group;
        aeDkYlUOm first;
        boolean group_found;

        m_group = new Vector();
        group_count = 0;
        
        size = m_spec.m_dtrans_vector.size();
        m_ingroup = new int[size];
        
        for (i = 0; i < size; ++i)
          {
            group_found = false;
            dtrans = (aeDkYlUOm) m_spec.m_dtrans_vector.elementAt(i);

            if (OAdukKIqY.DEBUG)
              {
                OAdukKIqY.assert(i == dtrans.m_label);
                OAdukKIqY.assert(false == group_found);
                OAdukKIqY.assert(group_count == m_group.size());
              }
            
            for (j = 0; j < group_count; ++j)
              {
                dtrans_group = (Vector) m_group.elementAt(j);
                
                if (OAdukKIqY.DEBUG)
                  {
                    OAdukKIqY.assert(false == group_found);
                    OAdukKIqY.assert(0 < dtrans_group.size());
                  }

                first = (aeDkYlUOm) dtrans_group.elementAt(0);
                
                if (OAdukKIqY.SLOW_DEBUG)
                  {
                    aeDkYlUOm check;
                    int k;
                    int s;

                    s = dtrans_group.size();
                    OAdukKIqY.assert(0 < s);

                    for (k = 1; k < s; ++k)
                      {
                        check = (aeDkYlUOm) dtrans_group.elementAt(k);
                        OAdukKIqY.assert(check.m_accept == first.m_accept);
                      }
                  }

                if (first.m_accept == dtrans.m_accept)
                  {
                    dtrans_group.addElement(dtrans);
                    m_ingroup[i] = j;
                    group_found = true;
                    
                    if (OAdukKIqY.DEBUG)
                      {
                        OAdukKIqY.assert(j == m_ingroup[dtrans.m_label]);
                      }

                    break;
                  }
              }
            
            if (false == group_found)
              {
                dtrans_group = new Vector();
                dtrans_group.addElement(dtrans);
                m_ingroup[i] = m_group.size();
                m_group.addElement(dtrans_group);
                ++group_count;
              }
          }
        
        if (true == m_spec.m_verbose
            && true == OAdukKIqY.OLD_DUMP_DEBUG)
          {
            System.out.println("Initial grouping:");
            pgroups();
            System.out.println("");
          }
      }

  /***************************************************************
    Function: pset
    **************************************************************/
  private void pset
    (
     Vector dtrans_group
     )
      {
        int i;
        int size;
        aeDkYlUOm dtrans;

        size = dtrans_group.size();
        for (i = 0; i < size; ++i)
          {
            dtrans = (aeDkYlUOm) dtrans_group.elementAt(i);
            System.out.print(dtrans.m_label + " ");
          }
      }
  
  /***************************************************************
    Function: pgroups
    **************************************************************/
  private void pgroups
    (
     )
      {
        int i;
        int dtrans_size;
        int group_size;
        
        group_size = m_group.size();
        for (i = 0; i < group_size; ++i)
          {
            System.out.print("\tGroup " + i + " {");
            pset((Vector) m_group.elementAt(i));
            System.out.println("}\n");
          }
        
        System.out.println("");
        dtrans_size = m_spec.m_dtrans_vector.size();
        for (i = 0; i < dtrans_size; ++i)
          {
            System.out.println("\tstate " + i 
                               + " is in group " 
                               + m_ingroup[i]);
          }
      }
}

/***************************************************************
  Class: dgAxAuRjX
 **************************************************************/
final class dgAxAuRjX //**NS**
{
  /***************************************************************
    Member Variables
    **************************************************************/
  private yCWZtShZT m_spec;
  private int m_unmarked_dfa;
  private ctxmGlswy m_lexGen;

  /***************************************************************
    Constants
    **************************************************************/
  private static final int NOT_IN_DSTATES = -1;

  /***************************************************************
    Function: dgAxAuRjX
    **************************************************************/
  dgAxAuRjX
    (
     )
      {
        reset();
      }

  /***************************************************************
    Function: set 
    Description: 
    **************************************************************/
  private void set
    (
     ctxmGlswy lexGen,
     yCWZtShZT spec
     )
      {
        m_lexGen = lexGen;
        m_spec = spec;
        m_unmarked_dfa = 0;
      }

  /***************************************************************
    Function: reset 
    Description: 
    **************************************************************/
  private void reset
    (
     )
      {
        m_lexGen = null;
        m_spec = null;
        m_unmarked_dfa = 0;
      }

  /***************************************************************
    Function: make_dfa
    Description: High-level access function to module.
    **************************************************************/
  void make_dfa
    (
     ctxmGlswy lexGen,
     yCWZtShZT spec
     )
      {
        int i;

        reset();
        set(lexGen,spec);

        make_dtrans();
        free_nfa_states();

        if (true == m_spec.m_verbose && true == OAdukKIqY.OLD_DUMP_DEBUG)
          {
            System.out.println(m_spec.m_dfa_states.size()
                               + " DFA states in original machine.");
          }

        free_dfa_states();
      }     

   /***************************************************************
    Function: make_dtrans
    Description: Creates uncompressed aeDkYlUOm transition table.
    **************************************************************/
  private void make_dtrans
    (
     )
     /* throws java.lang.CloneNotSupportedException*/
      {
        LdFBwMgdz next;
        LdFBwMgdz dfa;
        bSpXVtXss bunch;
        int i;
        int nextstate;
        int size;
        aeDkYlUOm dtrans;
        pHNWlbrmz nfa;
        int istate;
        int nstates;
        
        System.out.print("Working on DFA states.");

        /* Reference passing type and initializations. */
        bunch = new bSpXVtXss();
        m_unmarked_dfa = 0;

        /* Allocate mapping array. */
        nstates = m_spec.m_state_rules.length;
        m_spec.m_state_dtrans = new int[nstates];

        for (istate = 0; nstates > istate; ++istate)
          {
            if (0 == m_spec.m_state_rules[istate].size())
              {
                m_spec.m_state_dtrans[istate] = aeDkYlUOm.F;
                continue;
              }
                
            /* Create start state and initialize fields. */
            bunch.m_nfa_set = (Vector) m_spec.m_state_rules[istate].clone();
            sortStates(bunch.m_nfa_set);
            
            bunch.m_nfa_bit = new BitSet();
            
            /* Initialize bit set. */
            size = bunch.m_nfa_set.size();
            for (i = 0; size > 