package spec.benchmarks._239_nih; 
import java.awt.*;

class WindowManager {

	static final int MAXWINDOWS = 200;

	private static ImageWindow[] windowList;
	private static ImageWindow currentWindow = null;
	private static ImageWindow previousWindow = null;
	private static int windowCount = 0;


	synchronized static void setCurrentWindow(ImageWindow win) {
		if (windowCount==0)
			return;
		if (win != currentWindow) {
			if (Info.debugMode) {
				if (win!=null)
					Info.write("setCurrentWindow: " + win.getImagePlus().getTitle() + " (" + (currentWindow!=null?currentWindow.getImagePlus().getTitle():"null") + ")");
				else
					Info.write("setCurrentWindow: null");
			}
			if (currentWindow!=null) {
				ImagePlus imp = currentWindow.getImagePlus();
				if (imp.reserve()) {
					imp.killProcessor();
					imp.unreserve();
				}
			}
			previousWindow = currentWindow;
            Undo.reset();
		}
		currentWindow = win;
		if (currentWindow != null)
			currentWindow.toFront();
		Menus.updateMenus();
	}
	
	
	static ImageWindow getCurrentWindow() {
		return currentWindow;
	}
	

	synchronized static ImagePlus getCurrentImage() {
		if (currentWindow!=null)
			return currentWindow.getImagePlus();
		else
			return null;
	}


	static int getWindowCount() {
		return windowCount;
	}


	synchronized static void addNewWindow(ImageWindow win) {
		if (windowCount == 0) {
			windowList = new ImageWindow[MAXWINDOWS];
			for (int i=0; i<MAXWINDOWS; i++)
				windowList[i] = null;
		}
	    windowCount++;
        setCurrentWindow(win);
        Undo.reset();
		for (int i=0; i<MAXWINDOWS; i++) {
			if (windowList[i] == null) {
				windowList[i] = win;
				break;
				}
		}
    }


	synchronized static void removeWindow(ImageWindow win) {
		windowCount--;
		if (Info.debugMode)
			Info.write(win.getImagePlus().getTitle() + ": closing (" + windowCount + ")");
		if  (windowCount>0 && win!=previousWindow)
			setCurrentWindow(previousWindow);
		else {
			currentWindow = null;
			previousWindow = null;
			Menus.updateMenus();
		}
		for (int i=0; i<MAXWINDOWS; i++) {
			if (windowList[i] == win) {
				windowList[i] = null;
				break;
			}
		}
    }


	synchronized static void closeAllWindows() {
		if (windowCount > 0)
			for (int i=0; i<MAXWINDOWS; i++) {
				if (windowList[i] != null) {
					windowList[i].close();
					try {Thread.sleep(100);}
					catch (InterruptedException e) { }
				}
			}
    }
    
}