package spec.benchmarks._239_nih; 
// The ImageJ toolbar

import java.awt.*;

class Toolbar extends Canvas {

	static final int RECTANGLE = 0;
	static final int OVAL = 1;
	static final int POLYGON = 2;
	static final int FREEHAND = 3;
	static final int MAGNIFYING_GLASS = 5;

	static final int NUM_TOOLS = 16;
	static final int SIZE = 22;
	static final int OFFSET = 3;

	private Dimension ps;
	private boolean[] down;
	private static int current=0;
	private int previous=0;
	private Graphics g;
	private int x,y;
	private int xOffset, yOffset;
	private long mouseDownTime = 0;

	private Color gray = Color.lightGray;
	private Color brighter = gray.brighter();
	private Color darker = gray.darker();
	private Color evenDarker = darker.darker();

	Toolbar() {
		ps = new Dimension(SIZE*NUM_TOOLS, SIZE);
		down = new boolean[NUM_TOOLS];
		resetButtons();
		down[0] = true;
		setBackground(gray);
	}

	public static int getToolId() {
		return current;
	}

	private void drawButtons(Graphics g) {
		for (int i=0; i<NUM_TOOLS; i++)
			drawButton(g, i);
	}

	private void fill3DRect(Graphics g, int x, int y, int width, int height, boolean raised) {
		if (raised)
			g.setColor(gray);
		else
			g.setColor(darker);
		g.fillRect(x+1, y+1, width-2, height-2);
		g.setColor(raised ? brighter : evenDarker);
		g.drawLine(x, y, x, y + height - 1);
		g.drawLine(x + 1, y, x + width - 2, y);
		g.setColor(raised ? evenDarker : brighter);
		g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
		g.drawLine(x + width - 1, y, x + width - 1, y + height - 2);
	}    

	private void drawButton(Graphics g, int tool) {
		fill3DRect(g, tool*SIZE+1, 1, SIZE, SIZE-1, !down[tool]);
		g.setColor(Color.black);
		int x = tool*SIZE+OFFSET;
		int y = OFFSET;
		if (down[tool]) { x++; y++;}
		this.g = g;
		switch (tool) {
			case RECTANGLE:
				g.drawRect(x+1, y+2, 14, 11);
				return;
			case OVAL:
				g.drawOval(x+1, y+3, 14, 11);
				return;
			case POLYGON:
				xOffset = x+1;
				yOffset = y+3;
				m(4,0); d(14,0); d(14,1); d(10,5); d(10,6);
				d(13,9); d(13,10); d(0,10); d(0,4); d(4,0);
				return;
			case FREEHAND:
				xOffset = x+1;
				yOffset = y+3;
				m(3,0); d(5,0); d(7,2); d(9,2); d(11,0); d(13,0); d(14,1); d(15,2);
				d(15,4); d(14,5); d(14,6); d(12,8); d(11,8); d(10,9); d(9,9); d(8,10);
				d(5,10); d(3,8); d(2,8); d(1,7); d(1,6); d(0,5); d(0,2); d(1,1); d(2,1);
				return;
			case MAGNIFYING_GLASS:
				xOffset = x+2;
				yOffset = y+2;
				m(3,0); d(3,0); d(5,0); d(8,3); d(8,5); d(7,6); d(7,7);
				d(6,7); d(5,8); d(3,8); d(0,5); d(0,3); d(3,0);
				m(8,8); d(9,8); d(13,12); d(13,13); d(12,13); d(8,9); d(8,8);
				return;
		}
	}

	private void showMessage(int tool) {
		switch (tool) {
			case RECTANGLE:
				Info.showStatus("Rectangular selections");
				return;
			case OVAL:
				Info.showStatus("Oval selections");
				return;
			case POLYGON:
				Info.showStatus("Polygon selections");
				return;
			case FREEHAND:
				Info.showStatus("Freehand selections");
				return;
			case MAGNIFYING_GLASS:
				Info.showStatus("Magnifying glass");
				return;
			default:
				Info.showStatus("");
				return;
		}
	}

	private void m(int x, int y) {
		this.x = xOffset+x;
		this.y = yOffset+y;
	}

	private void d(int x, int y) {
		x += xOffset;
		y += yOffset;
		g.drawLine(this.x, this.y, x, y);
		this.x = x;
		this.y = y;
	}

	private void resetButtons() {
		for (int i=0; i<NUM_TOOLS; i++)
			down[i] = false;
	}

	void p(String s) {
		System.out.println(s);
	}

	public void paint(Graphics g) {
		drawButtons(g);
	}

	public boolean mouseEnter(Event e, int x, int y){
		//p("enter");
		return true;
	}

	public boolean mouseExit(Event e, int x, int y) {
		//p("exit");
		return true;
	}

	public boolean mouseDown(Event e, int x, int y) {
		boolean doubleClick = (System.currentTimeMillis()-mouseDownTime)<=500;
 		mouseDownTime = System.currentTimeMillis();
		down[previous] = false;
		for (int i=0; i<NUM_TOOLS; i++)
			if (x>i*SIZE && x<i*SIZE+SIZE)
				current = i;
		down[current] = true;
		Graphics g = this.getGraphics();
		drawButton(g, previous);
		drawButton(g, current);
		showMessage(current);
		//p("current=" + current + ", previous=" + previous);
		previous = current;
		if (doubleClick)
			switch (current) {
				case MAGNIFYING_GLASS:
					ImagePlus imp = WindowManager.getCurrentImage();
					if (imp!=null)
						imp.unzoom();
					break;
				default:
			}
		return true;
	}

	public Dimension preferredSize(){
		return ps;
	}

	public Dimension minimumSize(){
		return ps;
	}

}
