package spec.benchmarks._239_nih; 
import java.awt.*;
import java.awt.image.*;


class Stack {
	static final int MAX_SLICES = 4;
	ImagePlus imp;
	private int nSlices = 0;
	private int currentSlice;
	private byte[][] stack;
	private String[] title;
	
	Stack(ImagePlus imp) {
		this.imp = imp;
		stack = new byte[MAX_SLICES+1][];
		title = new String[MAX_SLICES+1];
		nSlices = 0;
		currentSlice = 0;
	}
	
	
	void addSlice(String title, byte[] pixels) {
		nSlices++;
		if (nSlices>MAX_SLICES)
			nSlices = MAX_SLICES;
		currentSlice = nSlices;
		stack[currentSlice] = pixels;
		this.title[currentSlice] = title;
	}
	

	void updatePixels() {
		if (imp.isProcessor()) {
			ByteProcessor ip = (ByteProcessor)imp.getProcessor();
			stack[currentSlice] = (byte[])ip.getPixels();
		}
	}
	
	
	byte[] getPixels(int index) {
		if (index>=1 && index<=nSlices) {
			updatePixels();
			return stack[index];
		}
		else
			return null;
	}
	

	int getSize() {
		return nSlices;
	}


	int getCurrentSlice() {
		return currentSlice;
	}


	String getTitle(int index) {
		if (index>=1 && index<=nSlices)
			return title[index];
		else
			return "";
	}
	
	void setSlice(int index) {
		Image img;
		ColorModel cm;
		int width, height;
		
		if (index>=1 && index<=nSlices) {
			updatePixels();
			imp.killProcessor();
			currentSlice = index;
			width = imp.getWidth();
			height = imp.getHeight();
			cm = Converter.makeGrayscaleColorModel(false);
	    	img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, cm, stack[index], 0, width));
	    	imp.udateImage(img);
	    	imp.draw();
		}
	}

}