package spec.benchmarks._239_nih; 
// This modal dialog box implements the Edit/Scale command

import java.awt.*;

public class ScaleDialog extends Dialog {
    private TextField xField, yField;
    private Label xLabel, yLabel;
    private Checkbox createWindow;
    private Button cancel, okay;
    private ImagePlus imp;
    private ImageProcessor ip;
    private ImageJ ij;
    private static double xScale = 0.5;
    private static double yScale = 0.5;
    private static boolean newWindow = true;

    public ScaleDialog(Frame parent, ImagePlus imp) {
        super(parent, "Scale", true);
        this.imp = imp;
        ij = (ImageJ)parent;
		GridBagLayout grid = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		setLayout(grid);
		
		xLabel = new Label("X Scale (0.05-25):");
		c.gridx = 0; c.gridy = 0;
		c.insets = new Insets(0, 0, 5, 0);
		grid.setConstraints(xLabel, c);
		add(xLabel);

		xField = new TextField(""+xScale, 5);
		c.gridx = 1; c.gridy = 0;
		grid.setConstraints(xField, c);
		xField.setEditable(true);
		xField.selectAll();
		add(xField);

		yLabel = new Label("Y Scale (0.05-25):");
		c.gridx = 0; c.gridy = 1;
		grid.setConstraints(yLabel, c);
		add(yLabel);

		yField = new TextField(""+yScale, 5);
		c.gridx = 1; c.gridy = 1;
		grid.setConstraints(yField, c);
		yField.setEditable(true);
		yField.selectAll();
		add(yField);

		createWindow = new Checkbox("Create New Window");
		c.gridx = 0; c.gridy = 2;
		c.gridwidth = 2;
		c.insets = new Insets(10, 10, 0, 0);
		c.anchor = GridBagConstraints.CENTER;
		grid.setConstraints(createWindow, c);
		createWindow.setState(newWindow);
		add(createWindow);
		
		cancel = new Button("Cancel");
		c.gridx = 0; c.gridy = 3;
		c.gridwidth = 1;
		c.insets = new Insets(20, 3, 15, 3);
		c.anchor = GridBagConstraints.EAST;
		grid.setConstraints(cancel, c);
		add(cancel);
		
		okay = new Button("  OK  ");
		c.gridx = 1; c.gridy = 3;
		c.anchor = GridBagConstraints.WEST;
		grid.setConstraints(okay, c);
		add(okay);
		
		pack();
		Rectangle pBounds = parent.bounds();
		move(pBounds.x+60, pBounds.y+60);
		show();
    }
    

	void makeNewWindow(Image image) {
		ImagePlus imp2 = new ImagePlus("Untitled", image, ij);
		imp2.show();
		imp.killProcessor();
	}


	void scale() {
		Double d;
		try {d = new Double(xField.getText());}
		catch (NumberFormatException e){
			xField.setText(""+xScale);
			d = null;
		}
		if (d!=null)
			xScale = d.doubleValue();
		if (xScale > 25.0)
			xScale = 25.0;
		if (xScale < 0.05)
			xScale = 0.05;
		try {d = new Double(yField.getText());}
		catch (NumberFormatException e){
			yField.setText(""+yScale);
			d = null;
		}
		if (d!=null)
			yScale = d.doubleValue();
		if (yScale > 25.0)
			yScale = 25.0;
		if (yScale < 0.05)
			yScale = 0.05;
		try {
			ip = imp.getProcessor();
			if (!newWindow) {
				ip.snapshot();
				Undo.setup(Undo.FILTER, imp);
			}
			ip.scale(xScale, yScale, newWindow);
	    	Image img = ip.createImage();
	    	if (newWindow)
	    		makeNewWindow(img);
			else
				imp.updateAndDraw();
		}
		catch(OutOfMemoryError o) {
			Info.outOfMemory("Scale");
		}
		hide();
		dispose();
	}
	

	public boolean action(Event event, Object arg) {

        if (event.target==xField) {
        	xField.setText((String)arg);
           return true;
		}
		
        if (event.target==yField) {
        	yField.setText((String)arg);
           return true;
		}
		
        if (event.target==createWindow) {
        	Boolean b = (Boolean)arg;
        	newWindow = b.booleanValue();
           return true;
		}
		
		if (event.target==okay) {
			scale();
            return true;
		}
		
		if (event.target==cancel) {
			hide();
			dispose();
            return true;
		}
		
		return super.action(event, arg);
	}


	public boolean keyDown(Event event, int key) {
		if (key == 13 || key == 10) // CR or LF
			scale();
		return super.keyDown(event, key);
	}


    public Insets insets() {
    	return new Insets(40, 20, 20, 20);
    }

}