package spec.benchmarks._239_nih; 
// This modal dialog box implements the Edit/Rotate command

import java.awt.*;

public class RotateDialog extends Dialog {

	private TextField textfield;
	private Label degrees;
    private Button apply, reset, done;
    private ImagePlus imp;
    private ImageProcessor ip;
    private static double angle = 10.0;
    private double totalRotation = 0.0;
    private boolean firstTime = true;
    private String plusSign = "+";
    private String decimalPoint = ".0";

    public RotateDialog(Frame parent, ImagePlus imp) {
        super(parent, "Rotate", true);
        this.imp = imp;
        ip = imp.getProcessor();
        ip.snapshot();
        setLayout(new BorderLayout());
		
        Panel p1 = new Panel();
        p1.setLayout(new FlowLayout(FlowLayout.CENTER, 4, 10));
		if (angle <= 0.0)
			plusSign = "";
		if (angle != (int)angle)
			decimalPoint = "";
		textfield = new TextField(plusSign+angle+decimalPoint, 5);
		textfield.setEditable(true);
		textfield.selectAll();
        p1.add(textfield);
		degrees = new Label("degrees");
        p1.add(degrees);
        add("Center", p1);

        Panel p2 = new Panel();
        p2.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 10));
		apply = new Button(" Apply ");
		p2.add(apply);
		reset = new Button(" Reset ");
		p2.add(reset);
		done = new Button(" Done ");
		p2.add(done);
        add("South", p2);

		pack();
		Rectangle pBounds = parent.bounds();
		move(pBounds.x+60, pBounds.y+60);
		show();
    }
    

	public boolean action(Event event, Object arg) {
	
        if (event.target==textfield) {
        	textfield.setText((String)arg);
            return true;
		}
		
		if (event.target==apply) {
			Double d;
			try {d = new Double(textfield.getText());}
			catch (NumberFormatException e){
				textfield.setText(""+angle);
				d = null;
			}
			if (d!=null)
				angle = d.doubleValue();
			ip.reset();
			ip.rotate(totalRotation+angle);
			imp.updateAndDraw();
			totalRotation += angle;
			firstTime = false;
            return true;
		}
		
		if (event.target==reset) {
			ip.reset();
			imp.updateAndDraw();
			totalRotation = 0.0;
            return true;
		}
		if (event.target==done) {
			this.hide();
			this.dispose();
            return true;
		}
		
		return super.action(event, arg);
	}


    public Insets insets() {
    	return new Insets(30, 20, 20, 20);
    }

}