package spec.benchmarks._239_nih; 
// Progress bar

// Bar is not displayed if the time between the first and
// second calls to 'show' is less than 50 milliseconds.
// Bar is erased when percent is 1.0.

import java.awt.*;
import java.awt.image.*;

class ProgressBar extends Canvas {

	private int canvasWidth, canvasHeight;
	private int x, y, width, height;
	private double percent;
	private long startTime;
	private int count;
	private boolean showBar;
	private boolean negativeProgress;
	ImageJ ij;


	ProgressBar(int canvasWidth, int canvasHeight, ImageJ ij) {
		this.canvasWidth = canvasWidth;
		this.canvasHeight = canvasHeight;
		x = 3;
		y = 3;
		width = canvasWidth - 8;
		height = canvasHeight - 5;
		showBar = false;
		negativeProgress = false;
		count = 0;
		percent = 0.0;
		this.ij = ij;
	}
	
	
	public void show(double percent) {
		count++;
    	if (count==1) {
    		startTime = System.currentTimeMillis();
    		showBar = false;
    	}
		else if (count==2) {
			long time2 = System.currentTimeMillis();
			if (Info.debugMode) Info.write("Progress: " + (time2 - startTime) + "ms");
			if ((time2 - startTime) >= 50) {
				showBar = true;
				getGraphics().drawRect(x-1, y-1, width+1, height+1);
			}
		}
		negativeProgress = percent<this.percent;
		this.percent = percent;
    	if (percent>=1.0) {
			count = 0;
			percent = 0.0;
    		erase(getGraphics());
			showBar = false;
			return;
    	}
		if (showBar)
			paint(getGraphics());
	}


	public void erase(Graphics g) {
		g.setColor(Color.white);
		g.fillRect(0, 0, canvasWidth, canvasHeight);
	}


	public void update(Graphics g) {
		paint(g);
	}


    public void paint(Graphics g) {
    	int barEnd = (int)(width*percent);
		if (showBar) {
			if (negativeProgress) {
				g.setColor(Color.white);
				g.fillRect(barEnd+2, y, width-barEnd, height);
			}
			else {
				g.setColor(Color.gray);
				g.fillRect(x, y, barEnd, height);
			}
		}
    }


    public Dimension preferredSize() {
        return new Dimension(canvasWidth, canvasHeight);
    }

}