package spec.benchmarks._239_nih; 
// Density profile plot

import java.awt.*;

class ProfilePlot {

	private ImagePlus imp;
	private Roi roi;
	private Rectangle rect;
	private ImageProcessor ip;


	ProfilePlot(ImagePlus imp) {
		this.imp = imp;
		this.roi = imp.getRoi();
		float[] profile;
		
		if (roi==null || (roi!=null && roi.getType()!=roi.RECTANGLE)) {
			Info.error("Rectangular selection required");
			return;
		}
		
		rect = roi.getBoundingRect();
		ip = imp.getProcessor();
		if (rect.width>=rect.height)
			profile = getColumnAverageProfile();
		else
			profile = getColumnAverageProfile();
		PlotWindow pw = new PlotWindow(profile, imp.getImageJ());
	}


	private float[] getColumnAverageProfile() {
		float[] profile = new float[rect.width];
		float[] aLine;
		
		for (int y=rect.y; y<rect.y+rect.height; y++) {
			aLine = ip.getLine(rect.x, y, rect.width);
			for (int i=0; i<rect.width; i++) {
				profile[i] += aLine[i];
			}
		}
		for (int i=0; i<rect.width; i++)
			profile[i] /= rect.height;
		return profile;
	}
	
	
}