package spec.benchmarks._239_nih; 
// Polygon region of interest

import java.awt.*;
import java.awt.image.*;

class PolygonRoi extends Roi {

	static final int MAX_POINTS = 5000;
	
	protected int[] xp, yp;		// coordinates are relative to origin of roi bounding box
	protected int[] xp2, yp2;	// absolute screen coordinates
	protected int nPoints;
	protected Graphics g;
	
	private int lastX, lastY;
	long mouseUpTime = 0;

	PolygonRoi(int xx, int yy, ImagePlus imp) {
		super(xx, yy, imp);
		type = POLYGON;
		xp = new int[MAX_POINTS];
		yp = new int[MAX_POINTS];
		xp2 = new int[MAX_POINTS];
		yp2 = new int[MAX_POINTS];
		nPoints = 1;
		xp2[0]=imp.screenX(xx);
		yp2[0]=imp.screenY(yy);
		x = xx;
		y = yy;
		width=1;
		height=1;
		clipX = xx;
		clipY = yy;
		clipWidth = 1;
		clipHeight = 1;
		ImageWindow win = imp.getWindow();
		if (win!=null) {
			ImageCanvas ic = win.getCanvas();
			g = ic.getGraphics();
		}
		state = CONSTRUCTING;
	}


	PolygonRoi(int x, int y, ImagePlus imp, int tool) {
	// This constructor is used for polygon ROIs but not for freehand ROIs
		this(x, y, imp);
		g.setColor(Color.yellow);
		lastX = x;
		lastY = y;
		drawStartBox();
	}


	private void drawStartBox() {
		//startBox = new Rectangle(x-4, y-4, 8, 8);
		//biggerStartBox = new Rectangle(x-5, y-5, 10, 10);
		g.drawRect(imp.screenX(startX)-4, imp.screenY(startY)-4, 8, 8);
	}
	
	
	public void draw(Graphics g) {
		if (state!=CONSTRUCTING) {
			updatePolygon();
			g.setColor(Color.yellow);
			g.drawPolygon(xp2, yp2, nPoints);
			showStatus();
		}
	}


	protected void grow(int x, int y) {
	// Overrides grow() in Roi class
	}


	void updatePolygon() {
		double mag = imp.getMagnification();
		if (mag==1.0)
			for (int i=0; i<nPoints; i++) {
				xp2[i] = xp[i]+x;
				yp2[i] = yp[i]+y;
			}
		else
			for (int i=0; i<nPoints; i++) {
				xp2[i] = imp.screenX(xp[i]+x);
				yp2[i] = imp.screenY(yp[i]+y);
			}
	}


	void handleMouseMove(int x, int y) {
	// Do rubber banding
		if (Toolbar.getToolId()!=Toolbar.POLYGON) {
			imp.killRoi();
			imp.draw();
			return;
		}
		g.setXORMode(Color.black);
		g.drawLine(xp2[nPoints-1], yp2[nPoints-1], imp.screenX(lastX), imp.screenY(lastY));
		g.drawLine(xp2[nPoints-1], yp2[nPoints-1], imp.screenX(x), imp.screenY(y));
		lastX = x;
		lastY = y;
		Info.showStatus("  (" + x + "," + y + ")");
	}


	void finishPolygon() {
		xp2[nPoints] = imp.screenX(startX);
		yp2[nPoints] = imp.screenY(startY);
		nPoints++;
		Polygon poly = new Polygon(xp2, yp2, nPoints);
		Rectangle r = poly.getBoundingBox();
		double mag = imp.getMagnification();
		x = imp.offScreenX(r.x);
		y = imp.offScreenY(r.y);
		width = (int)(r.width/mag);
		height = (int)(r.height/mag);
		if (nPoints<3 || width==0 || height==0) {
			imp.killRoi();
			return;
		}
		if (mag==1.0)
			for (int i=0; i<nPoints; i++) {
				xp[i] = xp2[i]-x;
				yp[i] = yp2[i]-y;
			}
		else
			for (int i=0; i<nPoints; i++) {
				xp[i] = imp.offScreenX(xp2[i])-x;
				yp[i] = imp.offScreenY(yp2[i])-y;
				//Info.write(i + " " + xp[i] + " " + yp[i]);
			}
		state = NORMAL;
		imp.draw(x-5, y-5, width+10, height+10);
		oldX=x; oldY=y; oldWidth=width; oldHeight=height;
	}
	
	
	void drawLineSegments() {
		Polygon poly = new Polygon(xp2, yp2, nPoints);
		Rectangle r = poly.getBoundingBox();
		x = imp.offScreenX(r.x);
		y = imp.offScreenY(r.y);
		width = (int)(r.width/imp.getMagnification());
		height = (int)(r.height/imp.getMagnification());
		imp.draw(x-5, y-5, width+10, height+10);
		g.setPaintMode();
		g.setColor(Color.yellow);
		drawStartBox();
		for (int i=0; i<(nPoints-1); i++)
			g.drawLine(xp2[i], yp2[i], xp2[i+1], yp2[i+1]);
	}
	
	
	void handleMouseUp(int screenX, int screenY) {
		if (state!=CONSTRUCTING)
			return;
		boolean samePoint = (xp2[nPoints-1]==imp.screenX(lastX) && yp2[nPoints-1]==imp.screenY(lastY));
		Rectangle biggerStartBox = new Rectangle(imp.screenX(startX)-5, imp.screenY(startY)-5, 10, 10);
		if (nPoints>2 && (biggerStartBox.inside(screenX, screenY)
		|| (imp.offScreenX(screenX)==startX && imp.offScreenY(screenY)==startY)
		|| (samePoint && (System.currentTimeMillis()-mouseUpTime)<=500))) {
			finishPolygon();
			return;
		}
		else if (!samePoint) {
			//add point to polygon
			xp2[nPoints] = imp.screenX(lastX);
			yp2[nPoints] = imp.screenY(lastY);
			nPoints++;
			drawLineSegments();
 			mouseUpTime = System.currentTimeMillis();		}
	}


	void move(int xNew, int yNew) {
		x += xNew - startX;
		y += yNew - startY;
		if (x < 0) x = 0;
		if (y < 0) y = 0;
		if ((x + width) >= xMax) x = xMax - width - 1;
		if ((y + height) >= yMax) y = yMax - height - 1;
		startX = xNew;
		startY = yNew;
		updateClipRect();
		imp.draw(clipX, clipY, clipWidth, clipHeight);
		oldX = x;
		oldY = y;
		oldWidth = width;
		oldHeight=height;
	}


	public boolean contains(int x, int y) {
		if (!super.contains(x, y))
			return false;
		else {
			Polygon poly = new Polygon(xp2, yp2, nPoints);
			return poly.inside(imp.screenX(x), imp.screenY(y));
		}
	}
	
	
	public int[] getMask() {
		Image img = imp.getImageJ().createImage(width, height);
		Graphics g = img.getGraphics();
		g.setColor(Color.black);
		g.fillPolygon(xp, yp, nPoints);
        //ImagePlus mask = new ImagePlus("Mask", img, imp.getImageJ());
        //mask.show();
		ColorProcessor cp = new ColorProcessor(img);
		return (int[])cp.getPixels();
	}

}