package spec.benchmarks._239_nih; 
import java.awt.*;
import java.awt.image.*;

class PlotWindow extends ImageWindow {

	static final int WINDOW_WIDTH = 325;
	static final int WINDOW_HEIGHT = 175;
	static final int LEFT_MARGIN = 15;
	static final int RIGHT_MARGIN = 15;
	static final int TOP_MARGIN = 15;
	static final int BOTTOM_MARGIN = 50;

	private int frameWidth = WINDOW_WIDTH - (LEFT_MARGIN+RIGHT_MARGIN);
	private int frameHeight = WINDOW_HEIGHT - (TOP_MARGIN+BOTTOM_MARGIN);
	private int xloc = LEFT_MARGIN + frameWidth/2;
	private int yloc = TOP_MARGIN + frameHeight + 20;

	private Rectangle frame = null;
	private Image img;
	private float[] data;
    private float xScale, yScale;
    private float xMin, xMax, yMin, yMax;
    

    public PlotWindow(float[] data, ImageJ ij) {
		super(new ImagePlus("Profile Plot", ij.createImage(WINDOW_WIDTH, WINDOW_HEIGHT), ij));

        this.data = data;
        img = imp.getImage();
        drawPlot(img.getGraphics());
    }


    public boolean handleEvent(Event event) {
		if (event.id == Event.MOUSE_MOVE) {
			updateCursorCoordinates(event.x, event.y);
        	return true;
		}
		else
        	return super.handleEvent(event);
    }


    void updateCursorCoordinates(int x, int y) {
    	if ((frame!=null)  && (imp.getImage() == img)) {
	    	Graphics g = imp.getImage().getGraphics();
			Point canvasLoc = ic.location();
			x -= canvasLoc.x;
			y -= canvasLoc.y;
			g.clearRect(xloc, yloc, frameWidth/2, 20);
	    	if (frame.inside(x, y)) {
	    		int xValue = (int)((x - frame.x)/xScale);
				float yValue = data[xValue];
				g.drawString("(" + xValue + ", " + yValue + ")", xloc, yloc+15);
			}
			imp.draw(xloc, yloc, frameWidth/2, 20);
		}
    }
    
    
    void drawPlot(Graphics g) {
    	int x, y;
    	float v;
		    	
		g.setColor(Color.black);
		g.setFont(new Font("Helvetica", Font.PLAIN, 12));
		
		yMin = Float.MAX_VALUE;
		yMax = Float.MIN_VALUE;
		for (int i = 0; i<data.length; i++) {
			v = data[i];
			if (v<yMin) yMin = v;
			if (v>yMax) yMax = v;
		}
			        
        frame = new Rectangle(LEFT_MARGIN, TOP_MARGIN, frameWidth, frameHeight);
        g.drawRect(frame.x, frame.y, frame.width, frame.height);

		xScale = (float)frame.width/data.length;
		if ((yMax-yMin)==0f)
			yScale = 1f;
		else
			yScale = (float)(frame.height/(yMax-yMin));
		Polygon p = new Polygon(new int[data.length+2], new int[data.length+2], data.length+2);
		for (int i = 0; i < data.length; i++) {
			p.xpoints[i] = LEFT_MARGIN + (int)(i*xScale);
			p.ypoints[i] = TOP_MARGIN + frame.height - (int)((data[i]-yMin)*yScale);
 		}
		p.xpoints[data.length] = LEFT_MARGIN + frame.width;
		p.ypoints[data.length] = TOP_MARGIN + frame.height;
		p.xpoints[data.length+1] = LEFT_MARGIN;
		p.ypoints[data.length+1] = TOP_MARGIN + frame.height;
 		
 		g.drawPolygon(p); 
 		//System.out.println("data.length" + data.length + ", xScale=" + xScale);     

        x = LEFT_MARGIN;
        y = TOP_MARGIN + frame.height + 15;
        xMin = 0f;
        xMax = data.length;
        g.drawString(""+xMin, x - 4, y);
        g.drawString(""+xMax, x + frame.width - getWidth(xMax, g) + 10, y);
        y += 15;
        g.drawString("Min: "+yMin, x, y);
        y += 15;
        g.drawString("Max: "+yMax, x, y);
	}
	

	int getWidth(double d, Graphics g) {
		//FontMetrics fm = g.getFontMetrics();
		//return fm.stringWidth(""+d);
		String s = ""+d;
		return (""+d).length()*6;
	}

}
