package spec.benchmarks._239_nih; 
import java.awt.*;
import java.awt.image.*;

class LookUpTable extends Object {
	private ImageJ ij;
	private int width, height;
	private byte[] pixels;
	private int mapSize = 0;
	private ColorModel cm;
	private byte[] rLUT, gLUT,bLUT;

	LookUpTable(Image img, ImageJ ij) {
//ij.write("LookUpTable");
		this.ij = ij;
		BytePixelGrabber pg = new BytePixelGrabber(img, 0, 0, width, height, pixels, 0, width);
		try {
			pg.grabPixels();
			cm = pg.getColorModel();
		}
		catch (InterruptedException e){};

//ij.write("grabPixels");
    	if (cm instanceof IndexColorModel) {
    		IndexColorModel m = (IndexColorModel)cm;
    		mapSize = m.getMapSize();
    		rLUT = new byte[mapSize];
    		gLUT = new byte[mapSize];
    		bLUT = new byte[mapSize];
    		m.getReds(rLUT); 
    		m.getGreens(gLUT); 
    		m.getBlues(bLUT); 
    	}
//ij.write("LookUpTable done");
	}


    int getMapSize() {
    	return mapSize;
    }
    
    
    byte[] getColors() {
    	byte[] colors = new byte[mapSize*3];
    	for (int i=0; i<mapSize; i++) {
    		colors[i*3+0] = rLUT[i];
    		colors[i*3+1] = gLUT[i];
    		colors[i*3+2] = bLUT[i];
    	}
    	return colors;
    }


    ColorModel getColorModel() {
    	return cm;
    }


	boolean isGrayscale() {
		boolean isGray = true;
		
		if (mapSize < 256)
			return false;
		for (int i=0; i<mapSize; i++)
			if ((rLUT[i] != gLUT[i]) || (gLUT[i] != bLUT[i]))
				isGray = false;
		return isGray;
	}
	
	
	boolean isInverted() {
		boolean inverted = true;
		int r1, g1, b1, r2, g2, b2;
		
		if (mapSize < 256)
			return false;
		r1 = rLUT[0]&0xff;
		g1 = gLUT[0]&0xff;
		b1 = bLUT[0]&0xff;
		for (int i=1; i<mapSize; i++) {
			r2 = rLUT[i]&0xff;
			g2 = gLUT[i]&0xff;
			b2 = bLUT[i]&0xff;
			if (r1<r2 || g1<g2 || b1<b2)
				inverted = false;
			r1 = r2; g1 = g2; b1 = b2;
		}
		return inverted;
	}
	
	
	void show() {
		Image img;
		ImagePlus LUTImage;
		Graphics g;
		int xMargin = 35;
		int yMargin = 20;
		int width = 256;
		int height = 128;
		int x, y, x1, y1, x2, y2;
		int imageWidth, imageHeight;
		int barHeight = 12;
		boolean isGray;
		double scale;

//ij.write("show");
		if (mapSize == 0)
			return;
		imageWidth = width + 2*xMargin;
		imageHeight = height + 4*yMargin;
		img = ij.createImage(imageWidth, imageHeight);
//ij.write("createImage");
		g = img.getGraphics();
		g.setColor(Color.white);
		g.fillRect(0, 0, imageWidth, imageHeight);
		g.setColor(Color.black);
		g.drawRect(xMargin, yMargin, width, height);

		scale = 256.0/mapSize;
		isGray  = isGrayscale();
//ij.write("isGrayscale");
		if (isGray)
			g.setColor(Color.black);
		else
			g.setColor(Color.red);
		x1 = xMargin;
		y1 = yMargin + height - (rLUT[0]&0xff)/2;
		for (int i = 1; i<256; i++) {
			x2 = xMargin + i;
			y2 = yMargin + height - (rLUT[(int)(i/scale)]&0xff)/2;
			g.drawLine(x1, y1, x2, y2);
			x1 = x2;
			y1 = y2;
		}

		if (!isGray) {
			g.setColor(Color.green);
			x1 = xMargin;
			y1 = yMargin + height - (gLUT[0]&0xff)/2;
			for (int i = 1; i<256; i++) {
				x2 = xMargin + i;
				y2 = yMargin + height - (gLUT[(int)(i/scale)]&0xff)/2;
				g.drawLine(x1, y1, x2, y2);
				x1 = x2;
				y1 = y2;
			}
		}

		if (!isGray) {
			g.setColor(Color.blue);
			x1 = xMargin;
			y1 = yMargin + height - (bLUT[0]&0xff)/2;
			for (int i = 1; i<255; i++) {
				x2 = xMargin + i;
				y2 = yMargin + height - (bLUT[(int)(i/scale)]&0xff)/2;
				g.drawLine(x1, y1, x2, y2);
				x1 = x2;
				y1 = y2;
			}
		}

		x = xMargin;
		y = yMargin + height + 2;
		drawColorBar(g, x, y, 256, barHeight);
		
		y += barHeight + 15;
		g.setColor(Color.black);
		g.drawString("0", x - 4, y);
		g.drawString(""+(mapSize-1), x + width - 10, y);
		g.drawString("255", 7, yMargin + 4);
		
        LUTImage = new ImagePlus("ColorMap", img, ij);
//ij.write("new ImagePlus");
        LUTImage.show();
	}
	

	void drawColorBar(Graphics g, int x, int y, int width, int height) {
		if (mapSize == 0)
			return;
		double scale = 256.0/mapSize;
		for (int i = 0; i < 256; i++) {
			int index = (int)(i/scale);
			g.setColor(new Color(rLUT[index]&0xff, gLUT[index]&0xff, bLUT[index]&0xff));
			g.drawLine(x+i, y, x+i, y + height);
		}
		g.setColor(Color.black);
		g.drawRect(x, y, width, height);
	}


	void drawUnscaledColorBar(Graphics g, int x, int y, int width, int height) {
		if (mapSize == 0) {  //no color table; draw a grayscale bar
			for (int i = 0; i < 256; i++) {
				g.setColor(new Color(i, i, i));
				g.drawLine(x+i, y, x+i, y + height);
			}
		}
		else {
			for (int i = 0; i < mapSize; i++) {
				g.setColor(new Color(rLUT[i]&0xff, gLUT[i]&0xff, bLUT[i]&0xff));
				g.drawLine(x+i, y, x+i, y + height);
			}
		}
		g.setColor(Color.black);
		g.drawRect(x, y, width, height);
	}
}

