package spec.benchmarks._239_nih; 
// Displays messages in the Image/J window and in dialog boxes

class Info {
	static final String VERSION = "0.55e";

	public static boolean debugMode = false;
	
	private static ImageJ ij;
	private static ProgressBar progressBar;
	
	static final int SHOWING = 0, OKAY = 1, CANCEL = 2;
	static int ModalDialogState;

	public static void init(ImageJ imagej) {
		ij = imagej;
		progressBar = ij.getProgressBar();
	}

	public static void showStatus(String s) {
		ij.showStatus(s);
	}

	public static void write(String s) {
		ij.write(s);
	}

	public static void noImage() {
		showMessage("No Image", "There are no images open.");
	}

	public static ImageJ getImageJ() {
		return ij;
	}
	
	public static void outOfMemory(String name) {
		ij.write("<<" + name + ": out of memory>>");
	}

	public static void showTime(ImagePlus imp, long start, String str) {
	    long elapsedTime = System.currentTimeMillis() - start;
		double seconds = elapsedTime / 1000.0;
		long pixels = imp.getWidth() * imp.getHeight();
		write(str + seconds + " seconds" +
			", " + (int)((double)pixels / seconds) + " pixels/second");
	}
	
	public static void showProgress(double progress) {
        progressBar.show(progress);
	}

	public static void showMessage(String title, String msg) {
		MessageDialog d = new MessageDialog(ij, title, msg);
	}

	public static void showMessage(String msg) {
		MessageDialog d = new MessageDialog(ij, "Message", msg);
	}

	public static boolean showMessageWithCancel(String title, String msg) {
		ModalDialogState = SHOWING;
		MessageWithCancelDialog d = new MessageWithCancelDialog(ij, title, msg);
		while (ModalDialogState==SHOWING) {wait(50);}
		wait(100);
		return (ModalDialogState==OKAY);
	}

	public static void error(String msg) {
		MessageDialog d = new MessageDialog(ij, "Error", msg);
	}
	
	static void showAboutBox() {
		MessageDialog d = new MessageDialog(ij, "About...",
			"      Image/J, Version " + VERSION + "\n" +
			" \n" +
			"Wayne Rasband (wayne@codon.nih.gov)\n" +
			"National Institutes of Health, USA\n" +
			" \n" +
			"Image/J is in the public domain"
		);
	}
	
	public static String freeMemory() {
		System.gc();
		long freeMem = Runtime.getRuntime().freeMemory();
		long totMem = Runtime.getRuntime().totalMemory();
		return  "Memory: " + (totMem-freeMem)/1024 + "K (" + (int)(freeMem*100.0/totMem) + "% free)";
		//return  "Memory: " + totMem/1024 + "K (" + (int)(freeMem*100.0/totMem) + "% free)";
	}
	
	
	public static void wait(int msecs) {
		try {Thread.sleep(msecs);}
		catch (InterruptedException e) { }
	}
	

}