package spec.benchmarks._239_nih; 
// Writes raw image data to a file

import java.io.*;

public class ImageWriter {
	FileInfo fi;
	

	ImageWriter (FileInfo fi) {
		this.fi = fi;
	}
	

	void write8BitImage(OutputStream out)  throws IOException {
		int bytesWritten = 0;
		int size = fi.width*fi.height;
		int count = 8192;
		
		while (bytesWritten<size) {
			if ((bytesWritten + count)>size)
				count = size - bytesWritten;
			//System.out.println(bytesWritten + " " + count + " " + size);
			out.write((byte[])fi.pixels, bytesWritten, count);
			bytesWritten += count;
			Info.showProgress((double)bytesWritten/size);
		}
	}
	
	
	void write16BitImage(OutputStream out)  throws IOException {
		int bytesWritten = 0;
		int size = fi.width*fi.height*2;
		int count = 8192;
		byte[] buffer = new byte[count];
		short[] pixels = (short[])fi.pixels;

		while (bytesWritten<size) {
			if ((bytesWritten + count)>size)
				count = size - bytesWritten;
			int j = bytesWritten/2;
			for (int i=0; i < count; i+=2) {
				buffer[i] = (byte)((pixels[j]>>>8)&0xff);
				buffer[i+1] = (byte)(pixels[j]&0xff);
				j++;
			}
			out.write(buffer, 0, count);
			bytesWritten += count;
			Info.showProgress((double)bytesWritten/size);
		}
	}
	
	
	void writeFloatImage(OutputStream out)  throws IOException {
		int bytesWritten = 0;
		int size = fi.width*fi.height*4;
		int count = 8192;
		byte[] buffer = new byte[count];
		float[] pixels = (float[])fi.pixels;
		int tmp;

		while (bytesWritten<size) {
			if ((bytesWritten + count)>size)
				count = size - bytesWritten;
			int j = bytesWritten/4;
			for (int i=0; i < count; i+=4) {
				tmp = Float.floatToIntBits(pixels[j]);
				buffer[i]   = (byte)((tmp>>24)&0xff);
				buffer[i+1] = (byte)((tmp>>16)&0xff);
				buffer[i+2] = (byte)((tmp>>8)&0xff);
				buffer[i+3] = (byte)(tmp&0xff);
				j++;
			}
			out.write(buffer, 0, count);
			bytesWritten += count;
			Info.showProgress((double)bytesWritten/size);
		}
	}
	
	
	void writeRGBImage(OutputStream out)  throws IOException {
		int bytesWritten = 0;
		int size = fi.width*fi.height*3;
		int count = fi.width*24;
		byte[] buffer = new byte[count];
		int[] pixels = (int[])fi.pixels;

		while (bytesWritten<size) {
			if ((bytesWritten + count)>size)
				count = size - bytesWritten;
			int j = bytesWritten/3;
			for (int i=0; i < count; i+=3) {
				buffer[i]   = (byte)((pixels[j]>>16)&0xff);	//red
				buffer[i+1] = (byte)((pixels[j]>>8)&0xff);	//green
				buffer[i+2] = (byte)(pixels[j]&0xff);		//blue
				j++;
			}
			out.write(buffer, 0, count);
			bytesWritten += count;
			Info.showProgress((double)bytesWritten/size);
		}
	}
	
	
	void write(OutputStream out) throws IOException {
		switch (fi.fileType) {
			case FileInfo.GRAY8:
			case FileInfo.COLOR8:
				write8BitImage(out);
				break;
			case FileInfo.GRAY16:
				write16BitImage(out);
				break;
			case FileInfo.GRAY32_FLOAT:
				writeFloatImage(out);
				break;
			case FileInfo.RGB:
				writeRGBImage(out);
				break;
			default:
		}
	}
	
}

