package spec.benchmarks._239_nih; 
import java.awt.*;
import java.awt.image.*;

public class ImageWindow extends Frame {

	protected ImagePlus imp;
	protected ImageJ ij;
	protected ImageCanvas ic;
	
	private int j = 0;

    public ImageWindow(ImagePlus imp) {
		super(imp.getTitle());
        setBackground(Color.white);
        setForeground(Color.black);
		ij = imp.getImageJ();
		this.imp = imp;
		this.imp.setWindow(this);
		ic = new ImageCanvas(imp);
		setLayout(new FlowLayout());
		add(ic);
		setResizable(true);
		pack();
		//show();
    	repaint();
		WindowManager.addNewWindow(this);
		Menus.updateMenus();
		hide();
    }
    
	public void update(Graphics g) {
	}


    public void paint(Graphics g) {
    }
    

	public void close() {
		WindowManager.removeWindow(this);
        hide();
        dispose();
	}
	

	ImagePlus getImagePlus() {
		return imp;
	}
	

	void setImagePlus(ImagePlus imp) {
		this.imp = imp;
		repaint();
	}
	

	ImageCanvas getCanvas() {
		return ic;
	}
	

    public boolean handleEvent(Event event) {
    	String title = imp.getTitle();
		switch(event.id) {
			case Event.GOT_FOCUS:
				if (Info.debugMode) ij.write(title + ": Got focus");
				WindowManager.setCurrentWindow(this);
	            break;
			case Event.WINDOW_MOVED:
				if (Info.debugMode) ij.write(title + ": Moved");
				WindowManager.setCurrentWindow(this);
	            break;
			case Event.WINDOW_EXPOSE:
				if (Info.debugMode) ij.write(title + ": Expose");
				WindowManager.setCurrentWindow(this);
	            break;
			case Event.WINDOW_DESTROY:
				if (Info.debugMode) ij.write(title + ": Destroy");
				close();
				break;
	        case Event.MOUSE_DOWN:
				WindowManager.setCurrentWindow(this);
	        default:
	            break;
        }
        return true;
    }


	void scale() {
		imp.unzoom();
		ScaleDialog d = new ScaleDialog(ij, imp);
	}
	
	
	void rotate() {
		imp.unzoom();
		RotateDialog d = new RotateDialog(ij, imp);
	}
	
	
	void math() {
		ConstantMath d = new ConstantMath(ij, imp);
	}
	
	

	void duplicate() {
		int newWidth, newHeight;
		Image newImg;
		String title, newTitle;
		ImageProcessor ip;
		ImagePlus imp2;
	
    	Roi roi = imp.getRoi();
    	if (roi != null) {
    		Rectangle r = roi.getBoundingRect();
    		newWidth = r.width;
    		newHeight = r.height;
    	}
    	else {
    		newWidth = imp.getWidth();
    		newHeight = imp.getHeight();
    	}
        ip = imp.getProcessor();
        ip.crop();
        newImg = ip.createImage();
        imp.killRoi();
        title = imp.getTitle();
		if (!title.endsWith("-copy"))
			newTitle = title + "-copy";
		else
			newTitle = title;
		imp2 = new ImagePlus(newTitle, newImg, ij);
		imp2.show();
    }
                
	
} //class ImageWindow

