package spec.benchmarks._239_nih; 
import spec.harness.Context; 
import java.awt.*;
import java.net.URL;
import java.awt.image.*;
import java.io.*;
import java.util.Properties;

public class ImageJ extends Frame {

	private Toolbar toolbar;
	private Panel statusBar;
	private ProgressBar progressBar;
	private Label statusLine;
	private TextArea textArea;
	private boolean firstTime = true;
	private ImageJApplet applet;
	private String[] plugIns;
	private static int newWindowType = 0;
	

	public ImageJ(ImageJApplet applet, String demoImagesURL, String[] plugIns) {
		super("Image/J");
		this.applet = applet;
		Executer.demoImagesURL = demoImagesURL;
		this.plugIns = plugIns;
			
		setBackground(Color.white);
		setForeground(Color.black);

		Menus.addMenuBar(this);

		// Tool bar
		toolbar = new Toolbar();
		add("North", toolbar);

		// Status bar
		statusBar = new Panel();
		statusBar.setLayout(new BorderLayout());
		statusLine = new Label();
		statusBar.add("Center", statusLine);
		progressBar = new ProgressBar(100, 14, this);
		statusBar.add("East", progressBar);
		add("South", statusBar);

		// Text area
		textArea = new TextArea(12, 60);
		add("Center", textArea);
		textArea.setFont(new Font("Courier", Font.PLAIN, 12));
		textArea.setEditable(true);
		write("Image/J " + Info.VERSION);
		write("-------------");
		
		Info.init(this);
		PlugIns.install(plugIns, applet);
		
		setResizable(true);
		pack();
		int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
		int windowWidth = bounds().width;
		double percent;
		if (screenWidth > 832)
		percent = 0.8;
		else
		percent = 0.9;
		int windowX = (int)(percent * (screenWidth - windowWidth));
		if (windowX < 10)
		windowX = 10;
		move(windowX, 40);
		//show();
		
		if(spec.harness.Context.getSpeed() == 100) {
			doCommand("Baboon [70K]");
			doCommand("Macro1");
			doCommand("Macro2");
			doCommand("Benchmark");
		}

		if(spec.harness.Context.getSpeed() == 10) {
			doCommand(Menus.gif3);
			doCommand("Macro1");
			doCommand("Macro2");
		}

		if(spec.harness.Context.getSpeed() == 1) {
			doCommand(Menus.gif3);
			doCommand("Macro1");
		}
		
		doCommand("Close"); 
		this.dispose(); 
	}
    

	void quit() {
		WindowManager.closeAllWindows();
        hide();
        dispose();
    	if (applet==null)
    		System.exit(0);
	}
	
	void write(String s) {
        textArea.appendText("  " + s + "\n");
	}


	void showStatus(String s) {
        statusLine.setText(s);
	}


	ProgressBar getProgressBar() {
        return progressBar;
	}


    public void doCommand(String name) {

		/*if ((name.equals("Benchmark")) 
			|| (name.equals("IP_Demo"))
			|| (name.equals("Macro1"))
			|| (name.equals("macro2")))
		while(WindowManager.getCurrentImage() == null); */

		Executer f = new Executer(name, WindowManager.getCurrentImage());
    }
    
    
	// Return the current list of modifier keys
	static String modifiers(int flags) {
		String s = " [ ";
		if (flags == 0) return "";
		if ((flags & Event.SHIFT_MASK) != 0) s += "Shift ";
		if ((flags & Event.CTRL_MASK) != 0) s += "Control ";
		if ((flags & Event.META_MASK) != 0) s += "Meta ";
		if ((flags & Event.ALT_MASK) != 0) s += "Alt ";
		s += "] ";
		return s;
	}


	synchronized void doMenuShortcut(int key, int flags) {
        boolean shift = (flags & Event.SHIFT_MASK) != 0;
        boolean control = (flags & Event.CTRL_MASK) != 0;
        String c = "";
    	ImagePlus imp = WindowManager.getCurrentImage();
    	boolean isStack = (imp!=null) && (imp.getDepth()>1);
        
		switch(key) {
        	case 14: c="New"; break;
        	case 15: c="Open..."; break;
        	case 23: c="Close"; break;
        	case 19: c=shift?"Smooth":"Tiff..."; break;
        	case 4: case 1001: c="Duplicate"; break;
        	case 18: c="Revert"; break;
        	case 9: if (control) {c=shift?"Invert":"Get Info...";} else c=""; break;
        	case 26: c="Undo"; break;
        	case 24: c="Clear"; break;
        	case 6: c=shift?"Find Edges":"Fill"; break;
        	case 5: c="Scale..."; break;
        	case 8: c=control?"Histogram":"Clear"; break; // ^H or delete
        	case 11: case 1002: c="Plot Profile"; break;
        	case 12: case 1003: c=Menus.gif5; break;
        	case 49: if (isStack) c=shift?Menus.channel.getItem(0).paramString():""; break;
        	case 50: if (isStack) c=shift?Menus.channel.getItem(1).paramString():""; break;
        	case 51: if (isStack) c=shift?Menus.channel.getItem(2).paramString():""; break;
        	default: break;
        }
        if (!c.equals("")) {
        	try {doCommand(c);}
        	catch(OutOfMemoryError e) {Info.outOfMemory(c);}
        }
	}
	
	
	void preloadClassFiles() {
	// See "Creating download progress bars for applets" by Mark Roulo
	// (www.javaworld.com/javaworld/jw-12-1996/jw-12-progressbar.html).

		String classes[] = {
			"Executer",
			"WindowManager",
			"BytePixelGrabber",
			"ImageWindow",
			"ImagePlus",
			"ImageProcessor",
			"ShortProcessor",
			"FloatProcessor",
			"ByteProcessor",
			"ColorProcessor",
			"ImageCanvas",
			"LookUpTable",
			"Undo",
			"Stack",
			"Roi",
			"OvalRoi",
			"PolygonRoi",
			"FreehandRoi"
		};

		showStatus("Loading .class files...");
		progressBar.show(0.0);
		for (int i = 0; i < classes.length; ++ i) {
			try {
				if (Info.debugMode)
					showStatus(classes[i]);
				Class c = Class.forName(classes[i]);
				progressBar.show((double)(i+1)/classes.length);
			}
			catch (Exception e) { }
		}
		showStatus("");
	}
        
        
	public boolean handleEvent(Event event) {
	// handle events

		switch(event.id) {
			case Event.ACTION_EVENT:
				String item;
				if (event.target instanceof MenuItem) {
					if (!(event.arg instanceof String)) {
						// hack needed for JDK 1.1
						write("Event handling error");
						write("   Event=" + event);
						if (event.target instanceof CheckboxMenuItem) {
							CheckboxMenuItem c = (CheckboxMenuItem)event.target;
							item = c.getLabel();
						}
						else
							break;
					}
					else
						item = (String)event.arg;
					if (firstTime && (applet!=null)) {
						if (item.equals("Debug Mode"))
        					Info.debugMode = Menus.debugMenuItem.getState();
						preloadClassFiles();
						firstTime = false;
					}
        			doCommand(item);
				}
				break;
			case Event.WINDOW_DESTROY:
				quit();
				break;
			case Event.KEY_PRESS:
			case Event.KEY_ACTION:
				int key = event.key;
				int flags = event.modifiers;
				doMenuShortcut(key, flags);
				return false;
			case Event.KEY_RELEASE:
			case Event.KEY_ACTION_RELEASE:
				if (Info.debugMode) write("Key release");
				return false;
	        case Event.MOUSE_DOWN:
				if (Info.debugMode) write("Mouse down: ");
				Info.showStatus(Info.freeMemory());
			default:
				break;
		}
		return true;
	}
    

	void newImageWindow(String title, int width, int height) {
		Image img;
		byte[] pixels;
		ImageWindow w;
		ColorModel cm;
		ImagePlus imp;

		pixels = new byte[width * height];
		if ((newWindowType % 2) == 0)
			for (int i=0; i<width*height; i++)
				pixels[i] = 0x64;
		else
			for (int y=0; y<height; y++)
				for (int x=0; x<width; x++)
					pixels[x + y * width] = (byte)(x&0xff);
		cm = Converter.makeGrayscaleColorModel(false);
		img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, cm, pixels, 0, width));
		imp = new ImagePlus(title, img, this);
		imp.show();
		newWindowType++;
	}


	//int getNumber(String prompt, int defaultNumber) {
	//	GetNumberDialog d = new GetNumberDialog(this, prompt, defaultNumber);
	//	d.show();
	//	for (int i=0; i<50; i++)
	//		wait(100);
	//	return 128;
	//}


    public static long inst_main(String args[]) {
		String[] plugIns = {"Benchmark", "IP_Demo", "Macro1", "Macro2", "-", "Thread_Lister", "Timer", "Memory_Test"};
		ImageJ ij = new ImageJ(null, args[0], plugIns);

		return 1;
    }


} //class ImageJ

