package spec.benchmarks._239_nih; 
import java.awt.*;
import java.awt.image.*;

class ImageCanvas extends Canvas {

	private ImagePlus imp;
	private ImageJ ij;
	private int width, height;


	ImageCanvas(ImagePlus imp) {
		this.imp = imp;
		ij = imp.getImageJ();
		setSize(imp.getWidth(), imp.getHeight());
	}
	
	
	public void setSize(int width, int height) {
	    this.width = width;
	    this.height = height;
		resize(width, height);
	}
	
	
	public void update(Graphics g) {
		if (Info.debugMode) Info.write("Update: " + imp.getTitle());
		paint(g);
	}


    public void paint(Graphics g) {
		if (Info.debugMode) {
			Info.write("Paint: " + imp.getTitle());
			Dimension d = imp.getWindow().size();
			Info.write("  Frame size: " + d.width + "x" + d.height);
			d = size();
			Info.write("  Canvas size: " + d.width + "x" + d.height);
		}
		try {imp.draw();}
		catch(OutOfMemoryError e) {Info.outOfMemory("Paint");}
    }
    

    public Dimension preferredSize() {
        return new Dimension(width, height);
    }


	void setCursor(int x, int y) {
		Roi roi = imp.getRoi();
		ImageWindow win = imp.getWindow();
		switch (Toolbar.getToolId()) {
			case Toolbar.MAGNIFYING_GLASS:
				win.setCursor(win.MOVE_CURSOR);
				break;
			default:  //selection tool
				if (roi!=null && roi.state!=roi.CONSTRUCTING && roi.contains(x, y))
					win.setCursor(win.DEFAULT_CURSOR);
				else
					win.setCursor(win.CROSSHAIR_CURSOR);
		}
	}
	
	
    public boolean handleEvent(Event event) {
		switch(event.id) {
	        case Event.MOUSE_DOWN:
				if (Info.debugMode) Info.write("Mouse down: (" + event.x + "," + event.y + ")" + ij.modifiers(event.modifiers));
	        	imp.handleMouseDown(event);
	            break;
	        case Event.MOUSE_UP:
	        	imp.handleMouseUp(event);
	            break;
	        case Event.MOUSE_DRAG:
	        	imp.handleMouseDrag(event);
	            break;
	        case Event.MOUSE_EXIT:
				ImageWindow win = imp.getWindow();
				if (win!=null) win.setCursor(win.DEFAULT_CURSOR);
				Info.showStatus("");
	            break;
	        case Event.MOUSE_MOVE:
				int x = imp.offScreenX(event.x);
				int y = imp.offScreenY(event.y);
				setCursor(x, y);
	        	imp.handleMouseMove(x, y);
	            break;
	        case Event.KEY_PRESS:
	        case Event.KEY_ACTION:
        		if (Info.debugMode) Info.write("Key press: " + event.key + ij.modifiers(event.modifiers));
	        	ij.doMenuShortcut(event.key, event.modifiers);
	            break;
	        default:
	            break;
        }
        return false;
    }

}