package spec.benchmarks._239_nih; 
import java.awt.*;
import java.awt.image.*;

class HistogramWindow extends ImageWindow {
	static final int WIN_WIDTH = 300;
	static final int WIN_HEIGHT = 280;
    static final int HIST_WIDTH = 257;
    static final int HIST_HEIGHT = 128;
	static final int BAR_HEIGHT = 12;
	static final int XMARGIN = 20;
	static final int YMARGIN = 10;
	
	private ImageStatistics stats;
	private int[] histogram;
	private LookUpTable lut;
	private Rectangle frame = null;
	private Image img;
    

    public HistogramWindow(ImagePlus imp) {
		super(new ImagePlus("Histogram", imp.getImageJ().createImage(WIN_WIDTH, WIN_HEIGHT), imp.getImageJ()));

		stats = imp.getStatistics();
		histogram = stats.histogram;
        lut = imp.getLUT();
        img = this.imp.getImage();
        drawHistogram(img.getGraphics());
    }


    public boolean handleEvent(Event event) {
		if (event.id == Event.MOUSE_MOVE) {
			updateValueAndCount(event.x, event.y);
        	return true;
		}
		else
        	return super.handleEvent(event);
    }


    void updateValueAndCount(int x, int y) {
    	if ((frame!=null)  && (imp.getImage() == img)) {
	    	Graphics g = imp.getImage().getGraphics();
			int xloc = XMARGIN + 11;
			int yloc = YMARGIN + HIST_HEIGHT + BAR_HEIGHT + 22;
			Point canvasLoc = ic.location();
			x -= canvasLoc.x;
			y -= canvasLoc.y;
			g.clearRect(xloc, yloc, HIST_WIDTH, 30);
			frame.grow(0, BAR_HEIGHT+2);
	    	if (frame.inside(x, y)) {
	    		x = x - frame.x;
	    		if (x>255)
	    			x = 255;
	    		double value = stats.histMin + x*stats.binSize;
				g.drawString("Value: " + value, xloc, yloc+15);
				g.drawString("Count: " + histogram[x], xloc, yloc+30);
			}
			else {
				g.drawString("Value:", xloc, yloc+15);
				yloc += 15;
				g.drawString("Count:", xloc, yloc+15);
			}
			imp.draw(xloc, yloc, HIST_WIDTH, 30);
		}
    }
    
    
    void drawHistogram(Graphics g) {
    	int x, y;
    	int maxCount2 = 0, newMaxCount;
    	int mode2 = 0;
    	int saveModalCount;
		    	
		g.setColor(Color.black);
			        
        saveModalCount = histogram[stats.mode];
        for (int i = 0; i < stats.nBins; i++)
            if ((histogram[i] > maxCount2) && (i != stats.mode)) {
                maxCount2 = histogram[i];
                mode2 = i;
            }
        newMaxCount = stats.maxCount;
        if ((newMaxCount > (maxCount2 * 2)) && (maxCount2 != 0)) {
        	newMaxCount = (int)(maxCount2 * 1.5);
        	histogram[stats.mode] = newMaxCount;
        }
        
        frame = new Rectangle(XMARGIN, YMARGIN, HIST_WIDTH, HIST_HEIGHT);
        g.drawRect(frame.x, frame.y, frame.width, frame.height);
        x = XMARGIN + 1;
		for (int i = 0; i < stats.nBins; i++)
            g.drawLine(i + XMARGIN, YMARGIN + HIST_HEIGHT, i + XMARGIN, YMARGIN + HIST_HEIGHT - ((int)(HIST_HEIGHT * histogram[i]) / newMaxCount));
        histogram[stats.mode] = saveModalCount;
        
        
        y = YMARGIN + HIST_HEIGHT + 2;
        lut.drawUnscaledColorBar(g, x, y, 256, BAR_HEIGHT);
        y += BAR_HEIGHT;
        
        y += 15;
        g.drawString(""+stats.histMin, x - 4, y);
        g.drawString(""+stats.histMax, x + HIST_WIDTH - getWidth(stats.histMax, g) + 10, y);
        
		x += 10;
		y += 20;
		g.drawString("Value:", x, y);
		y += 15;
		g.drawString("Count:", x, y);

		y += 20;
		g.drawString("Pixels: " + stats.pixelCount, x, y);
		y += 15;
		g.drawString("Mean: " + stats.mean, x, y);
		y += 15;
		g.drawString("Mode: " + (stats.histMin+stats.mode*stats.binSize) + " (" + stats.maxCount + " pixels)", x, y);
		y += 15;
		g.drawString("Min: " + stats.min + ",  Max: " + stats.max, x, y);
	}


	int getWidth(double d, Graphics g) {
		//FontMetrics fm = g.getFontMetrics();
		//return fm.stringWidth(""+d);
		String s = ""+d;
		return (""+d).length()*8;
	}

}
