package spec.benchmarks._239_nih; 
// Runs a menu command in a separate thread

import java.awt.*;
import java.net.URL;
import java.awt.image.*;
import java.io.*;

class Executer {

	private String name;
	private ImagePlus imp;
	private ImageJ ij;
	private boolean imageReserved = false;
	
	static String demoImagesURL;
	

	Executer(String name, ImagePlus imp) {
	//	super(name);
		this.name = name;
		this.imp = imp;
		ij = Info.getImageJ();
		start();
	}


    public void start() {
		try {runCommand(name);}
		catch(OutOfMemoryError e) {Info.outOfMemory(name);}
		if (imageReserved && imp!=null)
			imp.unreserve();
			
    }


    public void runCommand(String name) {

		//Info.write(" In runcommand");
	
		if (name.equals("Quit"))
			ij.quit();
		else if (name.equals("New"))
			ij.newImageWindow("Untitled", 400, 400);
		else if (name.equals("Open..."))
			openImage();
		else if (name.equals(Menus.gif0))
			openDemoImage("logo.gif");
		else if (name.equals(Menus.gif1))
			openDemoImage("cer-sag.gif");
		else if (name.equals(Menus.gif11))
			openDemoImage("enhance-me.gif");
		else if (name.equals(Menus.gif2))
			openDemoImage("cat.jpg");
		else if (name.equals(Menus.gif3))
			openDemoImage("lena.jpg");
		else if (name.equals(Menus.gif4))
			openDemoImage("little-girl.gif");
		else if (name.equals(Menus.gif5))
			openDemoImage("lena.gif");
		else if (name.equals(Menus.gif6))
			openDemoImage("mri.gif");
		else if (name.equals(Menus.gif7))
			openDemoImage("face.gif");
		else if (name.equals(Menus.gif8))
			openDemoImage("baboon.jpg");
		else if (name.equals("Import..."))
			importImage();
		else if (name.equals("Get Info..."))
			getInfo();
		else if (name.equals("Debug Mode")) {
			Info.debugMode = Menus.debugMenuItem.getState();
			Info.write("Debug mode: " + (Info.debugMode?"on":"off"));
		}
		else if (name.equals("About..."))
			Info.showAboutBox();
		else runImageCommand(name);
    }


    public void runImageCommand(String name) {
    // run commands that process images
    
    	ImageWindow win = null;
    	ImageProcessor ip = null;
    	
    	if (imp!=null) {
			if (!imp.reserve()) {
				Info.showStatus(name + ": image is in use");
				return;     // Exit if image is busy
			}
			imageReserved = true;
			if (Info.debugMode) Info.write(imp.getTitle() + ": reserved by " + name);
    		win = imp.getWindow();
			ip = imp.getProcessor();
    	}

		if (name.equals("Close"))
			{if (win!=null) win.close(); else Info.noImage();}
		else if (name.equals("Revert"))
			{if (win!=null) imp.revert(); else Info.noImage();}
		else if (name.equals("Save") || name.equals("Gif..."))
			{if (win!=null) saveAsGif(imp); else Info.noImage();}
		else if (name.equals("Tiff..."))
			{if (win!=null) saveAsTiff(imp); else Info.noImage();}
		else if (name.equals("Raw Data..."))
			{if (win!=null) saveAsRaw(imp); else Info.noImage();}
		else if (name.equals("8-bit Grayscale") || name.equals("16-bit Grayscale")
		|| name.equals("32-bit Grayscale") || name.equals("8-bit Color")
		|| name.equals("RGB Color") || name.equals("RGBA") || name.equals("HSB"))
			{if (win!=null) Converter.convert(name, imp); else Info.noImage();}
		else if (name.equals("Duplicate"))
			{if (win!=null) win.duplicate(); else Info.noImage();}
		else if (name.equals("Histogram"))
			{if (win!=null) {HistogramWindow hw = new HistogramWindow(imp);} else Info.noImage();}
		else if (name.equals("Show Map"))
			{if (win!=null) showMap(imp); else Info.noImage();}
		else if (name.equals("Plot Profile"))
			{if (win!=null) {ProfilePlot pp = new ProfilePlot(imp);} else Info.noImage();}
		else if (name.equals("Undo"))
			{if (win!=null) Undo.undo(); else Info.noImage();}
		else if (name.equals("Scale..."))
			{if (win!=null) win.scale(); else Info.noImage();}
		else if (name.equals("Rotate..."))
			{if (win!=null) win.rotate(); else Info.noImage();}
		else if (name.equals("Math..."))
			{if (win!=null) win.math(); else Info.noImage();}
		else if ((imp!=null) && Menus.isChannelEvent(name, imp))
		;
		else
			runFilterOrPlugIn();
			
		if (imageReserved) {
			imp.unreserve();
			if (Info.debugMode) Info.write(imp.getTitle() + ": unreserved by " + name);
		}
    }


	void runFilterOrPlugIn() {
		long start;

	 	start = System.currentTimeMillis();
	 	//setPriority(MIN_PRIORITY);
		Info.showStatus(name + "...");
		if (imp!=null)
			Undo.setup(Undo.FILTER, imp);

	 	if (name.equals("Clear") || name.equals("Fill") || name.equals("Invert") || name.equals("Vertical") ||
		name.equals("Horizontal") || name.equals("Smooth") || name.equals("Sharpen") ||
		name.equals("Find Edges") || name.equals("Add Noise") || name.equals("Threshold") ||
		name.equals("Enhance Contrast") || name.equals("Reduce Noise"))
			runFilter(name);
		else
	 		loadPlugIn(name, imp);
	 	
	 	if (imp!=null) {
			Info.showTime(imp, start, name + ": ");
		 	imp.updateAndDraw();
		}
	}
	  

	private void runFilter(String name) {
		ImageProcessor ip;
		
	 	if (imp==null) {
	 		Info.noImage();
	 		return;
	 	}
		ip = imp.getProcessor();
		ip.snapshot();
		 
	 	if (name.equals("Clear"))
	 		ip.clear();
	 	else if (name.equals("Fill"))
	 		ip.fill();
	 	else if (name.equals("Invert"))
	 		ip.invert();
	 	else if (name.equals("Vertical"))
	 		ip.flipVertical();
	 	else if (name.equals("Horizontal"))
	 		ip.flipHorizontal();
	 	else if (name.equals("Smooth"))
	 		ip.smooth();
	 	else if (name.equals("Sharpen"))
	 		ip.sharpen();
	 	else if (name.equals("Find Edges"))
	 		ip.findEdges();
	 	else if (name.equals("Add Noise"))
	 		ip.noise(20.0);
	 	else if (name.equals("Threshold"))
	 		{ip.setMask(imp.getMask()); ip.autoThreshold(); ip.setMask(null); imp.killRoi();}
	 	else if (name.equals("Enhance Contrast"))
	 		{ip.setMask(imp.getMask()); ip.enhanceContrast(); ip.setMask(null); imp.killRoi();}
	 	else if (name.equals("Reduce Noise"))
	 		ip.medianFilter();
		Roi roi = imp.getRoi();
		if (roi!=null) {
			int[] mask = roi.getMask();
			if (mask!=null)
				ip.reset(mask);
		}
	}
	
	
	void loadPlugIn(String name, ImagePlus imp) {
		if (imageReserved) { // plug-ins may or may not want to reserve image
			imp.unreserve(); 
			imageReserved = false;
			if (Info.debugMode) Info.write(imp.getTitle() + ": unreserved by " + name);
		}
		//try {
		//	Class c = Class.forName("spec.benchmarks._239_nih."+name);
 		//	PlugIn thePlugIn = (PlugIn)c.newInstance();
		//	thePlugIn.run(imp);
		//}
		//catch (ClassNotFoundException e) {Info.write("PlugIn not found: " + name + ".class");}
		//catch (InstantiationException e) {Info.write("Unable to load plugin");}
		//catch (IllegalAccessException e) {Info.write("Unable to load plugin");}
		//catch (FileNotFoundException e) {}
		if(name.equals("Macro1")) {
			Macro1 macro1 = new Macro1(); 
			macro1.run(imp); 
		}

		if(name.equals("Macro2")) {
			Macro2 macro2 = new Macro2(); 
			macro2.run(imp); 
		}

		if(name.equals("Benchmark")) {
			Benchmark benchmark = new Benchmark(); 
			benchmark.run(imp); 
		}

	}
	

	void openImage() {
		FileDialog fd = new FileDialog(ij, "Open...");
		fd.show();
		String name = fd.getFile();
		String directory = fd.getDirectory();
		fd.dispose();
		if (name == null)
			return;
		String path = directory + name;
		Info.showStatus("Loading: " + path);
		TiffDecoder t = new TiffDecoder(path, ij);
		try {
			if (t.open())
				return;
		}
		catch (IOException e) {
			Info.write("" + e);
		}
		Image img = Toolkit.getDefaultToolkit().getImage(path);
    	ImagePlus imp = new ImagePlus(name, img, ij);
    	imp.show();
		
	}


	void openDemoImage(String name) {
		ImagePlus imp = new ImagePlus(name, demoImagesURL + name, ij);
		imp.show();
	}
	

	void importImage() {
		FileDialog fd = new FileDialog(ij, "Import...");
		fd.show();
		String fileName = fd.getFile();
		String directory = fd.getDirectory();
		fd.dispose();
		if (fileName == null)
			return;
		ImportDialog d = new ImportDialog(ij, fileName, directory);
	}


	void saveAsGif(ImagePlus imp) {
		if (imp.getType()==imp.COLOR_RGB) {
			Info.error("The GIF format is limited to 8-bits.");
			return;
		}
		FileDialog fd = new FileDialog(ij, "Save As GIF...", FileDialog.SAVE);
		fd.show();
		String name = fd.getFile();
		String directory = fd.getDirectory();
		fd.dispose();
		if (name == null)
			return;
		Info.showStatus("Saving as Gif: " + directory + name);
		try {
			GIFEncoder encode = new GIFEncoder(imp);
			OutputStream output = new BufferedOutputStream(new FileOutputStream(directory + name));
			encode.Write(output);
			output.close();
		}
		catch (IOException e) {
			Info.write("" + e);
		}
	}
	
	
	void saveAsTiff(ImagePlus imp) {
		FileDialog fd = new FileDialog(ij, "Save As TIFF...", FileDialog.SAVE);
		fd.show();
		String name = fd.getFile();
		String directory = fd.getDirectory();
		fd.dispose();
		if (name == null)
			return;
		Info.showStatus("Saving as TIFF: " + directory + name);
		try {
			TiffEncoder file = new TiffEncoder(imp.getInfo());
			DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(directory + name)));
			file.write(out);
			out.close();
		}
		catch (IOException e) {
			Info.write("" + e);
		}
	}
	
	
	void saveAsRaw(ImagePlus imp) {
		FileDialog fd = new FileDialog(ij, "Save As Raw Data...", FileDialog.SAVE);
		fd.show();
		String name = fd.getFile();
		String directory = fd.getDirectory();
		fd.dispose();
		if (name == null)
			return;
		Info.showStatus("Saving as raw data: " + directory + name);
		try {
			ImageWriter file = new ImageWriter(imp.getInfo());
			OutputStream out = new BufferedOutputStream(new FileOutputStream(directory + name));
			file.write(out);
			out.close();
		}
		catch (IOException e) {
			Info.write("" + e);
		}
	}
	
	
	void getInfo() {
		String s;
		int type;
		ImageWindow win;
		ImagePlus imp;
		
		s = new String("");
    	win = WindowManager.getCurrentWindow();
		if (win == null)
			s += "No image windows open\n";
		else {
    		imp = win.getImagePlus();
			s += "Title: '" + imp.getTitle() + "'\n";
	    	s += "Width:  " + imp.getWidth() + " pixels\n";
	    	s += "Height:  " + imp.getHeight() + " pixels\n";
	    	type = imp.getType();
	    	switch (type) {
		    	case imp.GRAY8:
		    		s += "Depth: " + imp.getDepth() + "\n";
		    		s += "Pixel size: 8-bits with grayscale map\n";
		    		break;
		    	case imp.GRAY16:
		    		s += "Pixel size: 16-bits\n";
		    		break;
		    	case imp.GRAY32:
		    		s += "Pixel size: 32-bit real\n";
		    		break;
		    	case imp.COLOR_256:
		    		s += "Depth: " + imp.getDepth() + "\n";
		    		s += "Pixel size: 8-bits with color map\n";
		    		break;
		    	case imp.COLOR_RGB:
		    		s += "Depth: " + imp.getDepth() + "\n";
		    		s += "Pixel size: 32-bits (RGB)\n";
		    		break;
		    	case imp.RGBA:
		    	case imp.HSB:
		    		s += "Depth: " + imp.getDepth() + "\n";
		    		s += "Pixel size: 8-bits\n";
		    		break;
	    	}
	    	Roi roi = imp.getRoi();
	    	if (roi == null)
	    		s += "No ROI\n";
	    	else {
	    		switch (roi.getType()) {
	    			case roi.RECTANGLE: s += "Rectangular ROI\n"; break;
	    			case roi.OVAL: s += "Oval ROI\n"; break;
	    			case roi.POLYGON: s += "Polygon ROI\n"; break;
	    			case roi.FREEHAND: s += "Freehand ROI\n"; break;
	    		}
	    		Rectangle r = roi.getBoundingRect();
	    		s += "  X: " + r.x + "\n";
	    		s += "  Y: " + r.y + "\n";
	    		s += "  Width: " + r.width + "\n";
	    		s += "  Height: " + r.height + "\n";
	    	}
	    }

		s += " \n";
		s += Info.freeMemory() + "\n";
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		s += "Screen Size: " + d.width + "x" + d.height;

		Info.showMessage("Info", s);
	}


	void showMap(ImagePlus imp) {
		LookUpTable lut = imp.getLUT();
		if ((lut!=null) && (lut.getMapSize() > 0))
			lut.show();
		else
			Info.showMessage("No Map", "This is a 32-bit RGB image. This type\n"
			+ "of image does not have a color map.");
	}
    
}


