package spec.benchmarks._239_nih; 
// This modal dialog box implements the Process/Math command

import java.awt.*;

public class ConstantMath extends Dialog {
	static final int ADD = 1;
	static final int SUBTRACT = 2;
	static final int MULTIPLY = 3;
	static final int DIVIDE = 4;
	static final int AND = 5;
	static final int OR = 6;
	static final int XOR = 7;
	static final int GAMMA = 8;
	static final int LOG = 9;
	
    private Choice choice;
	private TextField textfield;
    private Button apply, reset, done;
    private ImagePlus imp;
    private ImageProcessor ip;
    private int mathOp = ADD;
    private static double value = 25;

    public ConstantMath(Frame parent, ImagePlus imp) {
        super(parent, "Math", true);
        this.imp = imp;
        ip = imp.getProcessor();
        ip.snapshot();
		GridBagLayout grid = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		setLayout(grid);
		
		choice = new Choice();
		choice.addItem("Add");
		choice.addItem("Subtract");
		choice.addItem("Multiply");
		choice.addItem("Divide");
		choice.addItem("AND");
		choice.addItem("OR");
		choice.addItem("XOR");
		choice.addItem("Gamma");
		choice.addItem("Log");
		c.fill = GridBagConstraints.NONE;
		c.anchor = GridBagConstraints.WEST;
		c.insets = new Insets(12, 0, 6, 0);
		c.gridwidth = 3;
		c.gridx = 2; c.gridy = 1;
		grid.setConstraints(choice, c);
		add(choice);

		textfield = new TextField(""+value, 6);
		c.gridx = 2; c.gridy = 2;
		c.insets = new Insets(0, 0, 0, 0);
		grid.setConstraints(textfield, c);
		textfield.setEditable(true);
		textfield.selectAll();
		add(textfield);

		apply = new Button(" Apply ");
		c.insets = new Insets(20, 5, 15, 5);
		c.gridwidth = 1;
		c.gridx = 1; c.gridy = 3;
		grid.setConstraints(apply, c);
		add(apply);
		
		reset = new Button(" Reset ");
		c.gridx = 2; c.gridy = 3;
		grid.setConstraints(reset, c);
		add(reset);
		
		done = new Button(" Done ");
		c.gridx = 3; c.gridy = 3;
		grid.setConstraints(done, c);
		add(done);
		
		pack();
		Rectangle pBounds = parent.bounds();
		move(pBounds.x+60, pBounds.y+60);
        show();
    }
    

	public boolean action(Event event, Object arg) {

        if (event.target==choice) {
        	String item = (String)arg;
            if (item.equals("Add")) {
        		mathOp = ADD;
        	}else if (item.equals("Subtract")) {
        		mathOp = SUBTRACT;
            }else if (item.equals("Multiply")) {
        		mathOp = MULTIPLY;
            }else if (item.equals("Divide")) {
        		mathOp = DIVIDE;
        	}else if (item.equals("AND")) {
        		mathOp = AND;
            }else if (item.equals("OR")) {
        		mathOp = OR;
            }else if (item.equals("XOR")) {
        		mathOp = XOR;
            }else if (item.equals("Gamma")) {
        		mathOp = GAMMA;
            }else if (item.equals("Log"))
        		mathOp = LOG;
            return true;
		}
		
        if (event.target==textfield) {
        	//System.out.println("TextField ; " + (String)event.arg);
        	textfield.setText((String)event.arg);
            return true;
		}
		
		if (event.target==apply) {
			Double d;
			try {d = new Double(textfield.getText());}
			catch (NumberFormatException e){
				textfield.setText(""+value);
				d = null;
			}
			if (d!=null)
				value = d.doubleValue();
			switch(mathOp)  {
				case ADD:
					ip.add((int)value);
					break;
				case SUBTRACT:
					ip.add((int)-value);
					break;
				case MULTIPLY:
					ip.multiply(value);
					break;
				case DIVIDE:
					ip.multiply(1/value);
					break;
				case AND:
					ip.and((int)value);
					break;
				case OR:
					ip.or((int)value);
					break;
				case XOR:
					ip.xor((int)value);
					break;
				case GAMMA:
					value = (value>3.0)?3.0:value;
					value = (value<0.1)?0.1:value;
					textfield.setText(""+value);
					ip.gamma(value);
					break;
				case LOG:
					ip.log();
					break;
			}
			imp.updateAndDraw();
            return true;
		}
		
		if (event.target==reset) {
			ip.reset();
			imp.updateAndDraw();
            return true;
		}
		
		if (event.target==done) {
			this.hide();
			this.dispose();
            return true;
		}
		
		return super.action(event, arg);
	}


    public Insets insets() {
    	return new Insets(30, 20, 20, 20);
    }

}