package spec.benchmarks._239_nih; 
// Color image statistics, including histogram

class ColorStatistics extends ImageStatistics {

	ColorStatistics(ImageProcessor ip) {
		this.width = ip.getWidth();
		this.height = ip.getHeight();
		setRoiLimits(ip.getRoi());
		int[] mask = ip.getMask();
		if (mask!=null)
			getHistogram(ip, mask);
		else
			getHistogram(ip);
		getMinAndMax();
		getStatistics();
	}


	void getHistogram(ImageProcessor ip) {
		int c, r, g, b, v;
		int[] pixels = (int[])ip.getPixels();
		histogram = new int[nBins];
		for (int y=roiY; y<(roiY+roiHeight); y++) {
			int i = y * width + roiX;
			for (int x=roiX; x<(roiX+roiWidth); x++) {
				c = pixels[i++];
				r = (c&0xff0000)>>16;
				g = (c&0xff00)>>8;
				b = c&0xff;
				v = (int)(r*0.30 + g*0.59 + b*0.11);
				histogram[v]++;
			}
		}
	}

	void getHistogram(ImageProcessor ip, int[] mask) {
		int c, r, g, b, v;
		int[] pixels = (int[])ip.getPixels();
		histogram = new int[nBins];
		for (int y=roiY, my=0; y<(roiY+roiHeight); y++, my++) {
			int i = y * width + roiX;
			int mi = my * roiWidth;
			for (int x=roiX; x<(roiX+roiWidth); x++) {
				if (mask[mi++]!=-1) {
					c = pixels[i];
					r = (c&0xff0000)>>16;
					g = (c&0xff00)>>8;
					b = c&0xff;
					v = (int)(r*0.30 + g*0.59 + b*0.11);
					histogram[v]++;
				}
				i++;
			}
		}
	}

}