package spec.benchmarks._239_nih; 
import java.util.Hashtable;
import java.awt.image.ImageProducer;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ColorModel;
import java.awt.Image;

public class BytePixelGrabber implements ImageConsumer {

    ImageProducer producer;

    int dstX;
    int dstY;
    int dstW;
    int dstH;

    byte[] pixelbuf;
    int dstOff;
    int dstScan;
    
   	ColorModel cm;

    private boolean grabbing;
    private int flags;

    private final int GRABBEDBITS = (ImageObserver.FRAMEBITS
				     | ImageObserver.ALLBITS);
    private final int DONEBITS = (GRABBEDBITS
				  | ImageObserver.ERROR);

    public BytePixelGrabber(Image img, int x, int y, int w, int h,
			byte[] pix, int off, int scansize) {
	this(img.getSource(), x, y, w, h, pix, off, scansize);
    }

    public BytePixelGrabber(ImageProducer ip, int x, int y, int w, int h,
			byte[] pix, int off, int scansize) {
	producer = ip;
	dstX = x;
	dstY = y;
	dstW = w;
	dstH = h;
	dstOff = off;
	dstScan = scansize;
	pixelbuf = pix;
    }

    public ColorModel getColorModel() {
	return cm;
    }

    public boolean grabPixels() throws InterruptedException {
	return grabPixels(0);
    }

    public synchronized boolean grabPixels(long ms)
	throws InterruptedException
    {
	if ((flags & DONEBITS) != 0) {
	    return (flags & GRABBEDBITS) != 0;
	}
	long end = ms + System.currentTimeMillis();
	if (!grabbing) {
	    grabbing = true;
	    flags &= ~(ImageObserver.ABORT);
	    producer.startProduction(this);
	}
	while (grabbing) {
	    long timeout;
	    if (ms == 0) {
		timeout = 0;
	    } else {
		timeout = end - System.currentTimeMillis();
		if (timeout <= 0) {
		    break;
		}
	    }
	    wait(timeout);
	}
	return (flags & GRABBEDBITS) != 0;
    }

    public synchronized int status() {
	return flags;
    }

    public void setDimensions(int width, int height) {
	return;
    }

    public void setHints(int hints) {
	return;
    }

    public void setProperties(Hashtable props) {
	return;
    }

    public void setColorModel(ColorModel model) {
    	cm = model;
    }

    public void setPixels(int srcX, int srcY, int srcW, int srcH,
			  ColorModel model,
			  byte pixels[], int srcOff, int srcScan) {
	if (srcY < dstY) {
	    int diff = dstY - srcY;
	    if (diff >= srcH) {
		return;
	    }
	    srcOff += srcScan * diff;
	    srcY += diff;
	    srcH -= diff;
	}
	if (srcY + srcH > dstY + dstH) {
	    srcH = (dstY + dstH) - srcY;
	    if (srcH <= 0) {
		return;
	    }
	}
	if (srcX < dstX) {
	    int diff = dstX - srcX;
	    if (diff >= srcW) {
		return;
	    }
	    srcOff += diff;
	    srcX += diff;
	    srcW -= diff;
	}
	if (srcX + srcW > dstX + dstW) {
	    srcW = (dstX + dstW) - srcX;
	    if (srcW <= 0) {
		return;
	    }
	}
	int dstPtr = dstOff + (srcY - dstY) * dstScan + (srcX - dstX);
	int dstRem = dstScan - dstW;
	int srcRem = srcScan - srcW;
	for (int h = srcH; h > 0; h--) {
	    for (int w = srcW; w > 0; w--) {
		pixelbuf[dstPtr++] = pixels[srcOff++];
	    }
	    srcOff += srcRem;
	    dstPtr += dstRem;
	}
	flags |= ImageObserver.SOMEBITS;
    }

    public void setPixels(int srcX, int srcY, int srcW, int srcH,
			  ColorModel model,
			  int pixels[], int srcOff, int srcScan) {
    }

    public synchronized void imageComplete(int status) {
	grabbing = false;
	switch (status) {
	default:
	case IMAGEERROR:
	    flags |= ImageObserver.ERROR | ImageObserver.ABORT;
	    break;
	case IMAGEABORTED:
	    flags |= ImageObserver.ABORT;
	    break;
	case STATICIMAGEDONE:
	    flags |= ImageObserver.ALLBITS;
	    break;
	case SINGLEFRAMEDONE:
	    flags |= ImageObserver.FRAMEBITS;
	    break;
	}
	producer.removeConsumer(this);
	notifyAll();
    }
}
