/*
 * TriangleObj.java
 *
 * Copyright (c) 1996 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * The class for a triangle. It has a function which tells if a point lies
 * within the triangle.
 *
 */
package spec.benchmarks._205_raytrace;

//import IntersectPt;
//import Material;
//import Point;
//import PolyTypeObj;
//import Ray;
//import Vector;

/**
 * class TriangleObj
 */
public class TriangleObj extends PolyTypeObj {
    private Vector S1;
    private Vector S2;
    private Vector S3;

    /**
     * Check
     * @param ray
     * @param pt
     * @return boolean
     */
    protected
    boolean Check(Ray ray, IntersectPt pt) { 

	 Vector intersectVec = new Vector(pt.GetIntersection().GetX(),
						pt.GetIntersection().GetY(),
						pt.GetIntersection().GetZ());
	 float check = S1.Dot(intersectVec);
	 if (check < 0.0f || check > 1.0f) return (false);
	 check = S2.Dot(intersectVec);
	 if (check < 0.0f || check > 1.0f) return (false);
	 check = S3.Dot(intersectVec);
	 if (check < 0.0f || check > 1.0f) return (false);
	 return (true);
    }

    /**
     * TriangleObj
     * @param objmaterial
     * @param newobjID
     * @param numverts
     * @param vertices
     * @param MaxX
     * @param MinX
     * @param MaxY
     * @param MinY
     * @param MaxZ
     * @param MinZ
     */
    public
    TriangleObj(Material objmaterial, int newobjID, int numverts,
		Point[] vertices, Point max, Point min) {
	 super(objmaterial,newobjID,numverts,vertices,max,min);
	

	 Vector[] temp = new Vector[3];
	 for (int i = 0; i < 3; i++) temp[i] = new Vector(vertices[i].GetX(),
							vertices[i].GetY(),
							vertices[i].GetZ());

	 S1 = new Vector();
	 S2 = new Vector();
	 S3 = new Vector();
	 S1.Cross(temp[1], temp[2]);
	 S2.Cross(temp[2], temp[0]);
	 S3.Cross(temp[0], temp[1]);
	 float delta = 1.0f / S1.Dot(temp[0]);
	 S1.Scale(delta * S1.Length());
	 S2.Scale(delta * S2.Length());
	 S3.Scale(delta * S3.Length());
    }

};
