/*
 * ObjectType.java
 *
 * Copyright (c) 1996 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * The base class for all objects. Holds the material for the object, its
 * ID and bounding box and the ray intersection cache.
 *
 */
package spec.benchmarks._205_raytrace;
//import CacheIntersectPt;
//import IntersectPt;
//import Material;
//import Point;
//import Ray;
//import Vector;

/**
 * class ObjectType
 */
public abstract class ObjectType  {
    private Material objMaterial;
    private int objID;
    private Point Max;
    private Point Min;
    private CacheIntersectPt IntersectCache;

    /**
     * ObjectType
     * @param newmaterial
     * @param newID
     */
    protected
    ObjectType(Material newmaterial, int newID) { 
	objMaterial=newmaterial;
	objID=newID;

	Max = new Point();
	Min = new Point();
	IntersectCache = new CacheIntersectPt();
    }

    /**
     * GetMax
     * @return Point
     */
    public
    Point GetMax() { 

	 return (Max);
    }

    /**
     * GetMin
     * @return Point
     */
    public
    Point GetMin() { 

	 return (Min);
    }

    /**
     * GetCachePt
     * @return CacheIntersectPt
     */
    public
    CacheIntersectPt GetCachePt() { 

	 return (IntersectCache);
    }

    /**
     * GetMaterial
     * @return Material
     */
    public
    Material GetMaterial() { 

	 return (objMaterial);
    }

    /**
     * GetObjID
     * @return int
     */
    public
    int GetObjID() { 

	 return (objID);
    }

    /**
     * Intersect
     * @param ray
     * @param pt
     * @return boolean
     */
    public abstract
    boolean Intersect(Ray ray, IntersectPt pt);

    /**
     * FindNormal
     * @param point
     * @param normal
     */
    public abstract
    void FindNormal(Point point, Vector normal);

};
