/*
 * Camera.java
 *
 * Copyright (c) 1996 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Stores the camera characteristics.
 *
 */
package spec.benchmarks._205_raytrace;
//import Point;
//import Vector;

/**
 * class Camera
 */
public class Camera  {
    private Point position;
    private Vector viewDirection;
    private float focalDistance;
    private Vector orthoUp;
    private float verticalFOV;

    /**
     * Camera
     * @param newpos
     * @param newview
     * @param newfdist
     * @param newortho
     * @param newFOV
     */
    public 
    Camera(Point newpos, Vector newview, float newfdist, Vector newortho,
	float newFOV) { 
	position=newpos;
	viewDirection=newview;
	focalDistance=newfdist;
	orthoUp=newortho;
	verticalFOV=newFOV;
	

    }

    /**
     * GetViewDir
     * @return Vector
     */
    public
    Vector GetViewDir() { 

	 return (viewDirection);
    }

    /**
     * GetOrthoUp
     * @return Vector
     */
    public
    Vector GetOrthoUp() { 

	 return (orthoUp);
    }

    /**
     * GetFocalDist
     * @return float
     */
    public
    float GetFocalDist() { 

	 return (focalDistance);
    }

    /**
     * GetFOV
     * @return float
     */
    public
    float GetFOV() { 

	 return (verticalFOV);
    }

    /**
     * GetPosition
     * @return Point
     */
    public
    Point GetPosition() { 

	 return (position);
    }

};
