<?xml version="1.0"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:key name="ParametersDistinct" match="//Execution" use="@parameters"></xsl:key>
    <xsl:key name="BenchmarksDistinct" match="//Execution" use="@benchmark"></xsl:key>
    <xsl:template match="/Executions">
        <html>
            <style>
                table {
                    width: 100%;
                }
            </style>
            <body>
                <h2>Results</h2>
                <!-- XSLT 2.0 needed for this, and XSLT 2.0 is not supported by many browsers -->
                <!--
                <xsl:for-each-group select="//Execution" group-by="@parameters">
                    <p>
                        <xsl:value-of select="@parameters"></xsl:value-of>
                        <xsl:for-each select="current-group()">
                            <p>
                                <xsl:value-of select="." />
                            </p>
                        </xsl:for-each>
                    </p>
                </xsl:for-each-group>
                -->
                <!-- XSLT 1.0 version: XSLT/Muenchian grouping -->
                <table border="1">
                    <!--
                    	-fx-color-50:  #eceff1;
                        -fx-color-100: #cfd8dc;
                        -fx-color-200: #b0bec5;
                        -fx-color-300: #90a4ae;
                        -fx-color-400: #78909c;
                        -fx-color-500: #607d8b;
                        -fx-color-600: #546e7a;
                        -fx-color-700: #455a64;
                        -fx-color-800: #37474f;
                        -fx-color-900: #263238;
                    -->
                    <tr bgcolor="#b0bec5">
                        <th>Suite</th>
                        <th>Benchmark</th>
                        <xsl:for-each select="Execution[generate-id() = generate-id(key('ParametersDistinct', @parameters)[1])]">
                            <th><xsl:value-of select="@parameters" /></th>
                        </xsl:for-each>
                    </tr>
                    <xsl:for-each select="Execution[generate-id() = generate-id(key('BenchmarksDistinct', @benchmark)[1])]">
                        <tr bgcolor="eceff1">
                            <td><xsl:value-of select="@suite"/></td>
                            <td><xsl:value-of select="@benchmark"/></td>
                            <xsl:for-each select="key('BenchmarksDistinct', @benchmark)">
                                <td>
                                    <table border="1">
                                        <tr>
                                            <xsl:for-each select="*">
                                                <xsl:variable name="color">
                                                    <xsl:choose>
                                                        <xsl:when test="text() = 'succeeded'">
                                                            <xsl:value-of select="'#9ACD32'" />
                                                        </xsl:when>
                                                        <xsl:when test="text() = 'unable'">
                                                            <xsl:value-of select="'#FFFF00'" />
                                                        </xsl:when>
                                                        <xsl:when test="text() = 'failed'">
                                                            <xsl:value-of select="'#FF0000'" />
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:value-of select="'#9ACD32'" />
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </xsl:variable>
                                                <td>
                                                    <xsl:attribute name="bgcolor">
                                                        <xsl:value-of select="$color" />
                                                    </xsl:attribute>
                                                    <xsl:attribute name="title">
                                                        <xsl:value-of select="concat(current(), ': ', node())" />
                                                    </xsl:attribute>
                                                    <xsl:attribute name="height">
                                                        10
                                                    </xsl:attribute>
                                                </td>
                                            </xsl:for-each>
                                        </tr>
                                    </table>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </xsl:for-each>
                </table>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
