
import java.io.File;
import java.lang.reflect.Method;

import at.ptasat.Main;
import at.ptasat.Configuration;

public class Harness {

	public static void main(String[] args) {
		int warmups = Integer.parseInt(args[0]);
		String[] files = new String[args.length - 1];
		for(int i = 0; i < files.length; i++) {
			files[i] = args[1 + i];
		}

		String[] arguments = new String[] {
			"--threads",
			"--seed=42",
			"--max=" + Runtime.getRuntime().availableProcessors(),
			"--global=--threads=1"
		};
		Configuration config = Configuration.get(arguments);
		
		boolean passed = true;
		for(int i = 0; i < warmups + 1; i++) {
			System.err.println("starting run #" + i);
			boolean runPassed = run(config, files);
			System.err.println("run #" + i + " " + (runPassed ? "passed" : "failed"));
			passed |= runPassed;
		}
		System.err.println("runs " + (passed ? "PASSED" : "FAILED"));
	}

	private static boolean run(Configuration config, String[] files) {
		boolean passed = true;
		for(String name : files) {
			File file = new File(name);
			System.out.println("c " + file.getName());
			config.setIn(file);
			int error = Main.main(config);
			passed &= error == 0;
		}
		return passed;
	}
}
