<?xml version="1.0" encoding='UTF-8'?>
<!-- Modified for XSLT Benchmark by Kevin Jones -->

<!-- 
  This is a small example XSLT stylesheet transforming ArticleML documents into HTML.
  The example is incomplete: important things like citation references
  are still missing. (Exercise to the reader: use xsl:variable,
  xsl:sort, and xsl:number to finish the parts about citation references.)
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html" indent="no" encoding='UTF-8'/>

<xsl:key name="idkey" match="*[@id]" use="@id"/>

<!-- MAIN TEMPLATE -->

<xsl:template match="article">
<html>
  <head>
    <title><xsl:apply-templates select="title" mode="raw"/></title>
    <xsl:call-template name="my-style"/>
  </head>
  <body>
    <xsl:call-template name="header"/>
    <h1><xsl:apply-templates select="title" mode="raw"/></h1>
    <xsl:apply-templates select="authors"/>
    <xsl:apply-templates select="abstract"/>
    <xsl:apply-templates select="section"/>
    <xsl:apply-templates select="references"/>
    <xsl:apply-templates select="vitae"/>
  </body>
</html> 
<xsl:text>
</xsl:text>
<xsl:comment>this HTML page was generated by article2html.xsl</xsl:comment>
</xsl:template>

<!-- FANCY HEADER TO OTHER VERSIONS -->

<xsl:template name="header">
<xsl:if test="@postscript|@pdf">
  <small><i>
    This paper is also available in 
    <a><xsl:attribute name="href">
    <xsl:apply-templates select="@postscript"/></xsl:attribute>Postscript</a>
    and 
    <a><xsl:attribute name="href">
    <xsl:apply-templates select="@pdf"/></xsl:attribute>PDF</a>
    for printing.
  </i></small><p/><br/><p/><br/>
</xsl:if>
</xsl:template>

<!-- ABSTRACT + NUMBERED SECTION/SUBSECTION -->

<xsl:template match="abstract">
<table width="80%" align="center"><tr><td>
<h4>Abstract</h4>
<xsl:apply-templates/>
</td></tr></table>
</xsl:template>

<xsl:template match="section">
<h3>
  <xsl:number format="1. "/>
  <xsl:apply-templates select="title" mode="raw"/>
</h3>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="subsection">
<h4>
  <xsl:number level="multiple" count="section|subsection" format="1.1 "/>
  <xsl:apply-templates select="title" mode="raw"/>
</h4>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="title" mode="raw">
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="title"/> <!--ignore-->

<!-- CITATION REFERENCES -->

<xsl:template match="references">
<h3>References</h3>
[...<!--incomplete-->]  
</xsl:template>

<!-- VITAE -->

<xsl:template match="authors">
<h4 class="title">
<xsl:apply-templates select="names"/><br/>
<i><xsl:apply-templates select="affiliation"/></i><br/>
<xsl:apply-templates select="link"/>
</h4>
</xsl:template>

<xsl:template match="vitae">
<p/><br/><br/>
<table>
<xsl:apply-templates/>
</table>
</xsl:template>

<xsl:template match="person">
<tr><td>
<img src="{@img}" alt="{@alt}" width="{@width}"/></td>
<td><xsl:apply-templates/></td></tr>
</xsl:template>

<!-- SECTION/SUBSECTION REFERENCES -->

<xsl:template match="ref[@section]">
  <xsl:for-each select="key('idkey',@section)">
    <xsl:number level="single" count="section" format="1"/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="ref[@subsection]">
  <xsl:for-each select="key('idkey',@subsection)">
    <xsl:number level="multiple" count="section|subsection" format="1.1"/>
  </xsl:for-each>
</xsl:template>

<!-- CITATION REFERENCES -->

<xsl:template match="cite">
[<!--incomplete-->]
</xsl:template>

<!-- ITEMIZE -->

<xsl:template match="itemize">
<ul><xsl:apply-templates/></ul>
</xsl:template>

<xsl:template match="itemize/item">
<li><xsl:apply-templates/></li>
</xsl:template>

<!-- EXAMPLE CODE ETC. -->

<xsl:template match="oneline">
<p/><br/>
<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text><xsl:apply-templates/><br/>
<p/><br/>
</xsl:template>

<xsl:template match="example">
<p/><br/>
<table border="1" cellpadding="5" width="100%" bgcolor="#f5dcb3"><tr><td><pre>
<xsl:apply-templates/>
</pre></td></tr></table>
<br/>
</xsl:template>

<!-- LITERAL LINKS -->

<xsl:template match="link">
<xsl:choose>
  <xsl:when test="@href">
    <tt><a href="{@href}"><xsl:apply-templates/></a></tt>
  </xsl:when>
  <xsl:when test="not(@href)">
    <tt><a href="{text()[1]}"><xsl:apply-templates/></a></tt>
  </xsl:when>
</xsl:choose>
</xsl:template>

<!-- EDITORIAL COMMENTS (curently not allowed in the DSD) -->

<xsl:template match="note">
<b>[<font color="red"><xsl:apply-templates/></font>]</b>
</xsl:template>

<!-- MINOR TYPOGRAPHICAL STUFF -->

<xsl:template match="p">
<p><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="it">
<i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="tt">
<tt><xsl:apply-templates/></tt>
</xsl:template>

<xsl:template match="bf">
<b><xsl:apply-templates/></b>
</xsl:template>

<xsl:template match="newline">
<br/>
</xsl:template>

<xsl:template match="percent">
<xsl:text>%</xsl:text>
</xsl:template>

<xsl:template match="nbsp">
<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
</xsl:template>

<xsl:template match="amp">
<xsl:text disable-output-escaping="yes">&amp;amp;</xsl:text>
</xsl:template>

<xsl:template match="lt">
<xsl:text disable-output-escaping="yes">&amp;lt;</xsl:text>
</xsl:template>

<xsl:template match="gt">
<xsl:text disable-output-escaping="yes">&amp;gt;</xsl:text>
</xsl:template>

<xsl:template match="br">
<br/>
</xsl:template>

<xsl:template match="tilde">
<xsl:text disable-output-escaping="yes">~</xsl:text>
</xsl:template>

<!-- CSS STYLE SHEET -->

<xsl:template name="my-style">
<xsl:text disable-output-escaping="yes"><![CDATA[
  <STYLE TYPE="text/css">
  <!--
  BODY { BACKGROUND-COLOR: #ffffff; }
  A:link, A:visited, A:active { TEXT-DECORATION: none; FONT-WEIGHT: bold; COLOR: #0000FF}
  
  H1, H2 { TEXT-ALIGN: center; FONT-WEIGHT: bold; }
  H3, H4, H5 { TEXT-ALIGN: left; FONT-WEIGHT: bold; }
  H4.title { TEXT-ALIGN: center; }

  P { TEXT-INDENT: 1em; MARGIN-TOP: 0; MARGIN-BOTTOM: 0}
  P.CODE { TEXT-INDENT: 0; COLOR: #FF0000; }

  UL, OL { MARGIN-LEFT: 1em; FONT-SIZE: medium;}
  UL { list-style: square; }
  LI { FONT-SIZE: small; }
  UL EM, OL EM { FONT-WEIGHT: bold; }
  CODE, CITE { FONT-WEIGHT: bold; }
  
  BLOCKQUOTE { MARGIN-LEFT: 1em; MARGIN-RIGHT: 1em }
  IMG { VERTICAL-ALIGN: top; ALIGN: center; }
  SUP { COLOR: #0000FF; FONT-SIZE: small; }
  TT { FONT-FAMILY: monospace; }
  -->
  </STYLE>
]]></xsl:text>
</xsl:template>

</xsl:stylesheet>
