
import java.lang.reflect.Method;
import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public final class IdentityHashCodeBenchmark {
	
	public static void main(String[] args) {
		int index = 0;
		int iterations = Integer.parseInt(args[index++]);
		int size = Integer.parseInt(args[index++]);
		Runnable benchmark;
		switch(args[index++]) {
			case "generate": benchmark = () -> run_generate(size); break;
			case "map": benchmark = () -> run_map(size, () -> create()); break;
			default: System.err.println("No such benchmark: " + args[index-1]); System.exit(1); return;
		}

		long fastest = Long.MAX_VALUE;
		for(int i = 0; i < iterations; i++) {
			long start = System.currentTimeMillis();
			benchmark.run();
			long duration = System.currentTimeMillis() - start;
			System.err.println("# iteration " + i + " took " + duration + "ms");
			fastest = Math.min(fastest, duration);
		}
		System.out.println("# final score is " + fastest + "ms");
	}
	
	private static long run_generate(int size) {
		long consumer = 0;
		for(int i = 0; i < size; i++) {
			consumer += new Object().hashCode();
		}
		return consumer;
	}

	private static long run_map(int size, Callable<Object> factory) {
		try {
			int lookups = (int) (size * 0.1);
			Set<Object> set = new HashSet<>();
			List<Object> list = new ArrayList<Object>(lookups);
			for(int i = 0; i < size; i++) {
				Object o = factory.call();
				set.add(o);
				if(i % (size / lookups) == 0) {
					list.add(o);
				}
			}
			long found = 0, notFound = 0;
			for(Object o : list) {
				if(set.contains(o)) found++; else notFound++;
				if(set.contains(factory.call())) found++; else notFound++;
			}
			return found * notFound;
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	private static Object create() {
		return new Object();
	}

	private static Object createSmall() {
		return new SmallHashCodeObject();
	}

	private static final class SmallHashCodeObject extends Object {

		private static final int SHIFT = 0;

		@Override
		public int hashCode() {
			return super.hashCode() & (0xFFFF << SHIFT);
		}
	}

}
