package benchmark;


public class DucktracksBenchmark {
	private static final int ITERATIONS = 100_000_000;	
	public static volatile int BRANCH_DECIDER = 0;
	
	public static void main(String[] args) {
		int warmups = 0;
		if(args.length > 0) {
			try{
				warmups = Integer.parseInt(args[0]);
			} catch (NumberFormatException e) {
				warmups = 0;
			}		
		}
		for(int i = 0; i < warmups; i++) {
			testRuntime();
		}		
		testRuntime();
		System.out.println("Benchmark concluded successfully");
	}
	
	public static int testRuntime() {
		int result = 0;
		for(int i = 0; i < ITERATIONS; i++) {	
			result = result ^ testMethod(i);
			BRANCH_DECIDER = BRANCH_DECIDER == 8 ? 0 : BRANCH_DECIDER + 1;
		}
		return result;
	}	
	
	//multiple allocations in sequential branch-->takes sequential path most of the time
	private static int testMethod(int i) {		
		try {	
			int result = 0;
//			if(Math.random() < .9) {
			if(BRANCH_DECIDER < 8) {
				//default avoided, sequential successor
				result += new Object().hashCode();
				result *= new Object().hashCode();
				result -= new Object().hashCode();
				result += new Object().hashCode();				
				
			} else {
				//->default taken, jump target
				result = new Object().hashCode() + new Object().hashCode() + new Object().hashCode() + new Object().hashCode();				
			}		
			return result;
		} catch(Throwable e) {
			//just here so the compiler cannot do something fishy
			return -1;
		}		
	}
	
	
	
	

}
