--
--   Licensed to the Apache Software Foundation (ASF) under one or more
--   contributor license agreements.  See the NOTICE file distributed with
--   this work for additional information regarding copyright ownership.
--   The ASF licenses this file to You under the Apache License, Version 2.0
--   (the "License"); you may not use this file except in compliance with
--   the License.  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--   Unless required by applicable law or agreed to in writing, software
--   distributed under the License is distributed on an "AS IS" BASIS,
--   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--   See the License for the specific language governing permissions and
--   limitations under the License.
--

--
-- this test is for basic insert functionality
--

-- NOTE: drop, create, select from the same table doesn't work yet either.

-- create the tables
create table t1 (i int, j int);
create table t2 (k int, l int);

-- populate t2
insert into t2 values (1, 2);
insert into t2 values (3, 4);

-- select * from t2
insert into t1 select * from t2;
insert into t1 (i, j) select * from t2;
insert into t1 (j, i) select * from t2;
select * from t1;

-- drop and recreate t1
drop table t1;
create table t1 (i int, j int);

-- select column list from t2
insert into t1 select k, l from t2;
insert into t1 select l, k from t2;
insert into t1 (i, j) select k, l from t2;
insert into t1 (j, i) select k, l from t2;
select * from t1;

-- drop and recreate t1
drop table t1;
create table t1 (i int, j int);

-- select constants from t2
insert into t1 select 5, 6 from t2;
insert into t1 (i, j) select 5, 6 from t2;
insert into t1 (j, i) select 6, 5 from t2;
select * from t1;

-- drop and recreate t1
drop table t1;
create table t1 (i int, j int);
insert into t1 (i) select 666 from t2;
insert into t1 (j) select 666 from t2;
select * from t1 where i = 666 or j = 666;

-- drop and recreate t1
drop table t1;
create table t1 (i int, j int);

-- Negative test cases - column references in values clause
insert into t1 values(1, c1);
insert into t1 values("asdf asdf", 2);

-- Negative test case - syntax error
insert into t1 values;

-- Too many values in values clause
insert into t1 values(1,1,1);
-- insert select with too many result columns in select
insert into t1 select 1, 2, 3 from t2;
-- multiple instances of same column in colum list
insert into t1 (i, i) values(2,2);

-- target column list size != source size
insert into t1 (i, j) values(1);
insert into t1 (i) values (1, 2);

-- Negative test cases - column name not specified
insert into t1 select 666 from t2;

-- target table in source - deferred mode
insert into t1 values (1,1);
insert into t1 values (2,2);
delete from t2;
insert into t2 select * from t1;

autocommit off;

select * from t1;
insert into t1 select t1.* from t1, t2;
select * from t1 order by 1, 2;
rollback;

insert into t1 (i) select (select i from t1 where i = 1) from t2;
select * from t1;
rollback;

insert into t1 (i) select 1 from t2 where 1 = (select i from t1 where i = 1);
select * from t1;
rollback;

insert into t1 select * from (select * from t1) a;
select * from t1;
rollback;

-- bug 5638
insert into t1 select * from t2 union select * from t1;
select * from t1;
rollback;

-- bug 5638
insert into t1 select * from t2 union select * from (select * from t1) a;
select * from t1;
rollback;

-- single-row deferred insert
insert into t1 select * from t1 where i = 1;
select * from t1;
rollback;

-- zero-row deferred insert - degenerate case
insert into t1 select * from t1 where i = 17;
select * from t1;
rollback;

-- insert-select with ? parameters
prepare i1 as 'insert into t1 (j, i) select 101,102 from t1 where i = ?';
execute i1 using 'values (1)';
select * from t1;
rollback;


autocommit on;

-- test atomicity of multi row inserts
create table atom_test_target (c1 smallint);
create table atom_test_source (c1 smallint);
insert into atom_test_source values 1, 30000,0, 2;

-- overflow
insert into atom_test_target select c1 + c1 from atom_test_source;
select * from atom_test_target;

-- divide by 0
insert into atom_test_target select c1 / c1 from atom_test_source;
select * from atom_test_target;

-- Derby-34
create table tchar( i int, c char(1) for bit data default x'02');
create table tchar1 (i int, c char(5) for bit data default x'2020202020',
			v varchar(5) for bit data default x'2020',
			l long varchar for bit data default x'303030');

drop table tchar;
drop table tchar1;

-- insert various numeric types into other numeric types
create table i1 (i int, t int, s smallint, l bigint, r real, dp double, dc dec);
create table i2 (i int, t int, s smallint, l bigint, r real, dp double, dc dec);
create table tab1 (
				i integer, 
				t integer, 
				s integer, 
				l bigint,
				r real, 
				dp double,
				dc decimal);

insert into i1 values (1, 2, 3, 4, 5.5, 6.6, 7.7);
insert into i1 values (null, null, null, null, null, null, null);

insert into tab1 values(1, 
				cast(2 as int), 
				cast(3 as smallint), 
				cast(4 as bigint), 
				cast(5.5 as real), 
				cast(6.6 as double), 
				7.7);
insert into tab1 values (null, null, null, null, null, null, null);

insert into i2 select i, i, i, i, i, i, i from i1;
insert into i2 select t, t, t, t, t, t, t from i1;
insert into i2 select s, s, s, s, s, s, s from i1;
insert into i2 select l, l, l, l, l, l, l from i1;
insert into i2 select r, r, r, r, r, r, r from i1;
insert into i2 select dp, dp, dp, dp, dp, dp, dp from i1;
insert into i2 select dc, dc, dc, dc, dc, dc, dc from i1;
select * from i2;
delete from i2;

insert into i2 select i, t, s, l, r, dp, dc from tab1;
select * from i2;

-- get the rest
create table i3 (b char(1) for bit data, 
			bv varchar(1) for bit data, 
			lbv long varchar for bit data,
			c char(10),
			cv varchar(10),
			lvc long varchar,
			dt date,
			t time,
			ts timestamp);

create table i4 (b char (1) for bit data, 
			bv varchar(1) for bit data, 
			lbv long varchar for bit data,
			c char(10),
			cv varchar(10),
			lvc long varchar,
			dt date,
			t time,
			ts timestamp);

insert into i3 values (X'11', X'22', X'25', '3', '4', '5', '1990-10-10', 
			'11:11:11', '1990-11-11 11:11:11');
insert into i3 values (null, null, null, null, null, null, null, null, null);

insert into i4 select * from i3;
select * from i4;
delete from i4;

create table tab2 (
	c char,
	cv varchar(10),
	lvc long varchar,
	dt date,	
	t time,	
	ts timestamp);

insert into tab2 values ('3', '4', '5', '1990-10-10', 
			'11:11:11', '1990-11-11 11:11:11');
insert into tab2 values (null, null, null, null, null, null);
insert into i4 (c, cv, lvc, dt, t, ts) select c, cv, lvc, dt, t, ts from tab2;
select * from i4;


-- drop the tables
drop table t1;
drop table t2;
drop table atom_test_target;
drop table atom_test_source;
drop table i1;
drop table i2;
drop table i3;
drop table i4;
drop table tab1;
drop table tab2;

-- test bug 4293, extremely huge insert statement, not using FileImport.

create table POLICY_STATEMENTS (c1 int, c2 int, c3 int, c4 long varchar, c5 long varchar, c6 int, c7 int, c8 int, c9 int, c10 int, c11 int);

INSERT INTO POLICY_STATEMENTS VALUES
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 101,1,null,'All information systems within %%short_company_name%% are the property of %%short_company_name%% and will be used in compliance with %%short_company_name%% policy statements.','This is a specific and clear statement about ownership of corporate assets.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets.',null,1,1,null,null,1),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 102,1,null,'Any personal information placed on %%short_company_name%% information system resources becomes the property of %%short_company_name%%.','This is a specific and clear statement about who owns information residing on corporate assets.  Failure to include this statement would lead to confusion over ownership of information residing on corporate assets and would reduce the ability to recover and/or use such information.',null,1,2,null,null,2),
( 103,1,null,'Any attempt to circumvent %%short_company_name%% security policy statements and procedures (i.e., disconnecting or tunneling a protocol through a firewall) is strictly prohibited.','All security policy statements will be followed, and attempts to circumvent them will not be tolerated.  Failure to include this policy statement may lead users to incorrectly believe that they can circumvent policies.',null,1,3,null,null,3),
( 104,1,null,'Unauthorized use, destruction, modification, and/or distribution of %%short_company_name%% information or information systems is prohibited.','This defines some of the many restrictions on the use of %%short_company_name%% information systems.  Failure to include this policy statement may lead to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions against users who abuse company assets to the unauthorized use of company resources and eliminate the company''s ability to take disciplinary actions to users who abuse company assets.',null,1,4,null,null,4);

select count(*) from POLICY_STATEMENTS;

drop table POLICY_STATEMENTS;
