/* Generated By:JavaCC: Do not edit this line. SQLParser.java */
/*

   Derby - File org.apache.derby.impl.sql.compile.sqlgrammar.jj

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to you under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

*/

package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.StatementType;

/* aggregates */
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;

import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CallStatementNode;
import  org.apache.derby.impl.sql.compile.CharConstantNode;
import  org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ReplaceAggregatesWithCRVisitor;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TernaryOperatorNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PrivilegeNode;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.compile.TransactionStatementNode;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.IntersectOrExceptNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.UserTypeConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.CurrentDatetimeOperatorNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.AlterTableNode;

import org.apache.derby.impl.sql.compile.ParseException;
import org.apache.derby.impl.sql.compile.Token;
import org.apache.derby.impl.sql.compile.TokenMgrError;
import org.apache.derby.impl.sql.compile.SQLParserConstants;
import org.apache.derby.impl.sql.compile.CharStream;
import org.apache.derby.impl.sql.execute.TablePrivilegeInfo;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;

import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecutionContext;

import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;

import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;

import org.apache.derby.iapi.error.StandardException;

import org.apache.derby.iapi.reference.Property;
import org.apache.derby.iapi.reference.SQLState;
import org.apache.derby.iapi.reference.JDBC30Translation;
import org.apache.derby.iapi.reference.Limits;

import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.C_NodeTypes;

import org.apache.derby.iapi.services.context.ContextManager;

import org.apache.derby.iapi.sql.compile.NodeFactory;

import org.apache.derby.iapi.services.sanity.SanityManager;

import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;

import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.services.io.StoredFormatIds;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.util.StringUtil;

import java.sql.Types;
import java.util.List;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.lang.Character;

public class SQLParser implements SQLParserConstants {
        private static final String[] SAVEPOINT_CLAUSE_NAMES = {"UNIQUE", "ON ROLLBACK RETAIN LOCKS", "ON ROLLBACK RETAIN CURSORS"};
        private static final String[] ROUTINE_CLAUSE_NAMES =
                {null, "SPECIFIC", "RESULT SET", "LANGUAGE", "EXTERNAL NAME", "PARAMETER STYLE", "SQL", "ON NULL INPUT"};
        /**
	   Clauses required for Java routines. Numbers correspond
	   to offsets in ROUTINE_CLAUSE_NAMES.
	   3 - "LANGUAGE"
	   4 - "EXTERNAL NAME"
	   5 - "PARAMETER STYLE"
	*/
        private static final int[] JAVA_ROUTINE_CLAUSES = {3,4,5};
        private static final String[] TEMPORARY_TABLE_CLAUSE_NAMES = {"NOT LOGGED", "ON COMMIT", "ON ROLLBACK"};
        /* The default length of a char or bit if the length is omitted */
        private static final int        DEFAULT_STRING_COLUMN_LENGTH = 1;

        // Defines for ON or USING clauses
        private static final int        ON_OR_USING_CLAUSE_SIZE = 2;
        private static final int        ON_CLAUSE = 0;
        private static final int        USING_CLAUSE = 1;

        // Defines for optional table clauses
        private static final int        OPTIONAL_TABLE_CLAUSES_SIZE = 3;
        private static final int        OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES = 0;
        private static final int        OPTIONAL_TABLE_CLAUSES_DERIVED_RCL = 1;
        private static final int        OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME = 2;

        // Define for UTF8 max
        private static final int        MAX_UTF8_LENGTH = 65535;

    // Constants for set operator types
    private static final int NO_SET_OP = 0;
    private static final int UNION_OP = 1;
    private static final int UNION_ALL_OP = 2;
    private static final int EXCEPT_OP = 3;
    private static final int EXCEPT_ALL_OP = 4;
    private static final int INTERSECT_OP = 5;
    private static final int INTERSECT_ALL_OP = 6;

        private Object[]                                        paramDefaults;
        private String                                          statementSQLText;
        private NodeFactory                                     nodeFactory;
        private ContextManager                          cm;
        private CompilerContext                         compilerContext;

        /* The number of the next ? parameter */
        private int                     parameterNumber;

        /* The list of ? parameters */
        private Vector                  parameterList;

        /* Remember if the last identifier or keyword was a
	 * delimited identifier.  This is used for remembering
	 * if the xxx in SERIALIZE(xxx) was a delimited identifier
	 * because we need to know whether or not we can convert
	 * xxx to upper case if we try to resolve it as a class
	 * alias at bind time.
	 */
        private Boolean lastTokenDelimitedIdentifier = Boolean.FALSE;
        private Boolean nextToLastTokenDelimitedIdentifier = Boolean.FALSE;


        /*
	** Remember the last token we got that was an identifier
	*/
        private Token   lastIdentifierToken;
        private Token   nextToLastIdentifierToken;

        static final String SINGLEQUOTES = "\'\'";
        static final String DOUBLEQUOTES = "\"\"";

        static final String DEFAULT_INDEX_TYPE = "BTREE";

        //the following 2 booleans are used to make sure only null or not null is
        //defined for a column while creating a table or altering a table. Defining
        //both at the same time will be an error case.
        boolean explicitNotNull = false;
        boolean explicitNull = false;

        //this vector keeps a list of explicitly nullable columns, so that if they
        //get used in the table level primary key constraint, it will result in an
        //exception.	
        Vector explicitlyNullableColumnsList = new Vector();


        final void setCompilerContext(CompilerContext cc) {
                this.compilerContext = cc;
                this.cm = cc.getContextManager();
        }

        /**
	  *	Get the NodeFactory for this database.
	  *
	  *	@return	The NodeFactory for this database.
	  * @exception StandardException		Thrown on error
	  */
        private final NodeFactory       getNodeFactory()        throws StandardException
        {
                if ( nodeFactory == null )
                {
                        nodeFactory = getCompilerContext().getNodeFactory();
                }

                return  nodeFactory;
        }

        private final CompilerContext getCompilerContext()
        {
                return compilerContext;
        }

        private DataTypeDescriptor getDataTypeServices(int type, int precision, int scale,
                        int length)
        {
                return new DataTypeDescriptor(
                                        TypeId.getBuiltInTypeId(type),
                                        precision,
                                        scale,
                                        true, /* assume nullable for now, change it if not nullable */
                                        length
                                );
        }

        private DataTypeDescriptor getJavaClassDataTypeDescriptor(String javaClassName)
        {
                return new DataTypeDescriptor(
                                        TypeId.getUserDefinedTypeId(
                                                                javaClassName,
                                                                lastTokenDelimitedIdentifier.booleanValue()),
                                        true);
        }
        private LanguageConnectionContext getLanguageConnectionContext()
        {
                return (LanguageConnectionContext) getContextManager().getContext(
                                                                                LanguageConnectionContext.CONTEXT_ID);
        }

        /**
		Utility method for checking that the underlying database has been
		upgraded to the required level to use this functionality. Used to
		disallow SQL statements that would leave on-disk formats that would
		not be understood by a engine that matches the current upgrade level
		of the database. Throws an exception if the database is not a the required level.
		<P>
		Typically used for CREATE statements at the parser level. Called usually just
		before the node is created, or can be called in just a partial syntax fragment
		
		@param version Data Dictionary major version (DataDictionary.DD_ constant)
		@param feature SQL Feature name, for error text.
	*/
        private void checkVersion(int version, String feature) throws StandardException
        {
                getLanguageConnectionContext().getDataDictionary().checkVersion(
                                version, feature);
        }

    /**
		Utility method for checking that the underlying database uses SQL standard
		permission checking (GRANT/REVOKE).

		@param command "GRANT" or "REVOKE"
    */
        private void checkSqlStandardAccess( String command) throws StandardException
        {
                if( getLanguageConnectionContext().usesSqlAuthorization())
                        return;

                throw StandardException.newException(SQLState.LANG_GRANT_REVOKE_WITH_LEGACY_ACCESS,
                                                                                        command,
                                                                                        Property.SQL_AUTHORIZATION_PROPERTY,
                                                                                        "TRUE");
        }


        /**
		Check that the current mode supports internal extensions.

		@param feature Description of feature for exception.

		@exception StandardException current mode does not support statement
	*/
        private void checkInternalFeature(String feature) throws StandardException
        {
                CompilerContext cc = getCompilerContext();
                if ((cc.getReliability() & CompilerContext.INTERNAL_SQL_ILLEGAL) != 0)
                        throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, feature);
        }

        /**
	 * check if the type length is ok for the given type.
	 */
        private void checkTypeLimits(int type, int length)
                throws StandardException
        {
        boolean valid = true;


        switch (type) {
                case Types.BINARY:
                case Types.CHAR:
                        if (length  > Limits.DB2_CHAR_MAXWIDTH)
                                valid = false;
                        break;

                case Types.VARBINARY:
                case Types.VARCHAR:
                        if (length  > Limits.DB2_VARCHAR_MAXWIDTH)
                                valid = false;

                        break;
                default:
                        break;
        }
        if (!valid)  // If these limits are too big 
                {
                        DataTypeDescriptor charDTD =
                                DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);

                        throw StandardException.newException(SQLState.LANG_DB2_LENGTH_PRECISION_SCALE_VIOLATION, charDTD.getSQLstring());
                }
        }



        // Get the current ContextManager
        private final ContextManager getContextManager()
        {
                return cm;
        }

        /*
	** Compress 2 adjacent (single or double) quotes into a single (s or d) quote when
	** found in the middle of a String.
	** NOTE:  """" or '''' will be compressed into "" or ''.
	** 		  This function assumes that the leading and trailing quote from a
	** 		  string or delimited identifier have already been removed.
	*/
        private static String compressQuotes(String source, String quotes)
        {
                String  result = source;
                int             index;

                /* Find the first occurrence of adjacent quotes. */
                index = result.indexOf(quotes);

                /* Replace each occurrence with a single quote and begin the
		 * search for the next occurrence from where we left off.
		 */
                while (index != -1)
                {
                        result = result.substring(0, index + 1) + result.substring(index + 2);

                        index = result.indexOf(quotes, index + 1);
                }

                return result;
        }

        private static void verifyImageLength(String image) throws StandardException
                {
                // beetle 2758.  For right now throw an error for literals > 64K
                if (image.length() > MAX_UTF8_LENGTH)
                        {
                throw StandardException.newException(SQLState.LANG_INVALID_LITERAL_LENGTH);
                        }
                }

        /*
	** Converts a delimited id to a canonical form.
	** Post process delimited identifiers to eliminate leading and
	** trailing " and convert all occurrences of "" to ".
	*/
        private static String normalizeDelimitedID(String str)
        {
                str = compressQuotes(str, DOUBLEQUOTES);
                return str;
        }
        private static boolean isDATETIME(int val)
        {
                if (val == DATE || val == TIME || val == TIMESTAMP)
                        return true;
                else
                        return false;
        }

        /*
	 * Generate a multiplicative operator node, if necessary.
	 *
	 * If there are two operands, generate the multiplicative operator
	 * that corresponds to the multiplicativeOperator parameter.  If there
	 * is no left operand, just return the right operand.
	 *
	 * @param leftOperand	The left operand, null if no operator
	 * @param rightOperand	The right operand
	 * @param multiplicativeOperator	An identifier from BinaryOperatorNode
	 *									telling what operator to generate.
	 *
	 * @return	The multiplicative operator, or the right operand if there is
	 *			no operator.
	 *
	 * @exception StandardException		Thrown on error
	 */

        ValueNode multOp(ValueNode leftOperand,
                                                        ValueNode rightOperand,
                                                        int multiplicativeOperator)
                                        throws StandardException
        {
                if (leftOperand == null)
                {
                        return rightOperand;
                }

                switch (multiplicativeOperator)
                {
                  case BinaryOperatorNode.TIMES:
                        return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.BINARY_TIMES_OPERATOR_NODE,
                                                                        leftOperand,
                                                                        rightOperand,
                                                                        getContextManager());

                  case BinaryOperatorNode.DIVIDE:
                        return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.BINARY_DIVIDE_OPERATOR_NODE,
                                                                        leftOperand,
                                                                        rightOperand,
                                                                        getContextManager());
                  case BinaryOperatorNode.CONCATENATE:
                        return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.CONCATENATION_OPERATOR_NODE,
                                                                        leftOperand,
                                                                        rightOperand,
                                                                        getContextManager());

                  default:
                        if (SanityManager.DEBUG)
                        SanityManager.THROWASSERT("Unexpected multiplicative operator " +
                                                                                multiplicativeOperator);
                        return null;
                }
        }

        /**
	 * Set up and like the parameters to the descriptors.
	 * Set all the ParameterNodes to point to the array of
	 * parameter descriptors.
	 * 
	 *	@exception	StandardException
	 */
         private void setUpAndLinkParameters()
                        throws StandardException
         {
                CompilerContext cc = getCompilerContext();
                cc.setParameterList(parameterList);
                /* Link the untyped parameters to the array of parameter descriptors */

                DataTypeDescriptor[] descriptors = cc.getParameterTypes();

                ParameterNode                           newNode;
                ParameterNode                           oldNode;
                int                                                     paramCount;

                /*
		** Iterate through the list of untyped parameter nodes, set each one
		** to point to the array of parameter descriptors.
		*/
                paramCount = -1;
                int plSize = parameterList.size();
                for (int index = 0; index < plSize; index++)
                {
                        paramCount++;

                        newNode = (ParameterNode) parameterList.elementAt(index);
                        newNode.setDescriptors(descriptors );
                }
        }

        /**
	 *  Initializes the list of unnamed parameters, i.e., "?" parameters
	 *
	 *	Usually, this routine just gets an empty list for the unnamed parameters.
	 *
	 *
	 */
        void    initUnnamedParameterList()
        {
                parameterList = new Vector();
        }

        /**
	 * Makes a new unnamed ParameterNode and chains it onto parameterList.
	 *
	 *	@return	new unnamed parameter.
	 *
	 *	@exception	StandardException
	 */
        ParameterNode   makeParameterNode(  )
                                        throws StandardException
        {
                ParameterNode   parm;
                DataValueDescriptor sdv = null;

                if ((paramDefaults != null) && (parameterNumber < paramDefaults.length))
                {
                        sdv = (DataValueDescriptor) paramDefaults[parameterNumber];
                }

                parm = (ParameterNode) nodeFactory.getNode(
                                                                C_NodeTypes.PARAMETER_NODE,
                                                                ReuseFactory.getInteger(parameterNumber),
                                                                sdv,
                                                                getContextManager());

                parameterNumber++;
                parameterList.addElement(parm);

                return parm;
        }

        /**
	 * Looks up an unnamed parameter given its parameter number.
	 *
	 *	@param	paramNumber		Number of parameter in unnamed
	 *							parameter list.
	 *
	 *	@return	corresponding unnamed parameter.
	 *
	 */
        ParameterNode   lookupUnnamedParameter( int paramNumber )
        {
                ParameterNode           unnamedParameter;

                unnamedParameter = (ParameterNode) parameterList.elementAt( paramNumber );
                return unnamedParameter;
        }

        /**
	 * Translate a String containing a number into the appropriate type
	 * of Numeric node.
	 *
	 * @exception StandardException		Thrown on error
	 */
        ValueNode getNumericNode(String num) throws StandardException
        {
                ContextManager cm = getContextManager();

                // first, see if it might be an integer
                try
                {
                        return (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.INT_CONSTANT_NODE,
                                                                                new Integer(num),
                                                                                cm);
                }
                catch (NumberFormatException nfe)
                {
                        // we catch because we want to continue on below
                }

                // next, see if it might be a long
                try
                {
                        return (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.LONGINT_CONSTANT_NODE,
                                                                                new Long(num),
                                                                                cm);
                }
                catch (NumberFormatException nfe)
                {
                        // we catch because we want to continue on below
                }

                return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.DECIMAL_CONSTANT_NODE,
                                                                        num,
                                                                        cm);
        }
        /**
	 * Determine whether the current token represents one of
	 * the built-in aliases.
	 *
	 * @return	TRUE iff the current token names a built-in alias
	 */
        private boolean isBuiltInAlias()
        {
                boolean retval = false;

                switch (token.kind)
                {
                  case UCASE:
                  case LCASE:
                  case SQRT:
                  case LOCATE:
                  case ABS:
                  case ABSVAL:
                  case SUBSTR:
                  case MOD:
                        retval = true;
                        break;

                  default:
                        retval = false;
                        break;
                }


                return retval;
        }


        /**
	 * Determine whether the next sequence of tokens represents one of
	 * the common (built-in) datatypes.
	 *
	 * @param checkFollowingToken true if additonal token for NATIONAL
	 *        or LONG should be checked
	 * @return	TRUE iff the next set of tokens names a common datatype
	 */
        boolean commonDatatypeName(boolean checkFollowingToken)
        {
            return commonDatatypeName(1, checkFollowingToken);
        }

        /**
	 * Determine whether a sequence of tokens represents one of
	 * the common (built-in) datatypes.
	 *
	 * @param checkFollowingToken true if additonal token for NATIONAL
	 *        or LONG should be checked
	 * @param start starting token index of the sequence
	 * @return	TRUE iff the next set of tokens names a common datatype
	 */
        boolean commonDatatypeName(int start, boolean checkFollowingToken)
        {
                boolean retval = false;

                switch (getToken(start).kind)
                {
                  case CHARACTER:
                  case CHAR:
                  case VARCHAR:
                  case NVARCHAR:
                  case NCHAR:
                  case BIT:
                  case NUMERIC:
                  case DECIMAL:
                  case DEC:
                  case INTEGER:
                  case INT:
                  case SMALLINT:
                  case LONGINT:
                  case FLOAT:
                  case REAL:
                  case DATE:
                  case TIME:
                  case TIMESTAMP:
                  case BOOLEAN:
                  case DOUBLE:
                  case BLOB:
                  case CLOB:
                  case NCLOB:
                  case BINARY: // LARGE OBJECT
                  case XML:
                        retval = true;
                        break;

                  case LONG:
                        if (checkFollowingToken == true)
                        {
                                switch (getToken(start+1).kind)
                                {
                                  case VARCHAR:
                                  case NVARCHAR:
                                  case BINARY:
                                  case VARBINARY:
                                  case BIT:
                                        retval = true;
                                        break;
                                }
                                break;
                        }
                        else
                        {
                                retval = true;
                                break;
                        }

                  case NATIONAL:
                        if (checkFollowingToken == true)
                        {
                                switch (getToken(start+1).kind)
                                {
                                  case CHAR:
                                  case CHARACTER:
                                        retval = true;
                                        break;
                                }
                                break;
                        }
                        else
                        {
                                retval = true;
                                break;
                        }
                }

                return retval;
        }

        /**
	 * Get a DELETE node given the pieces.
	 *
	 *
	 *	@exception	StandardException
	 */
         private StatementNode getDeleteNode(FromTable fromTable,
                                                                                 TableName tableName,
                                                                                 ValueNode whereClause)
                throws StandardException
        {
                FromList   fromList = (FromList) nodeFactory.getNode(
                                                                C_NodeTypes.FROM_LIST,
                                                                getContextManager());

                fromList.addFromTable(fromTable);

                SelectNode resultSet = (SelectNode) nodeFactory.getNode(
                                                                                C_NodeTypes.SELECT_NODE,
                                                                                null,
                                                                                null,   /* AGGREGATE list */
                                                                                fromList, /* FROM list */
                                                                                whereClause, /* WHERE clause */
                                                                                null, /* GROUP BY list */
                                                                                null, /* having clause */
                                                                                getContextManager());

                StatementNode retval =
                        (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.DELETE_NODE,
                                                        tableName,
                                                        resultSet,
                                                        getContextManager());

                setUpAndLinkParameters();

                return retval;
        }

        /**
	 * Get an UPDATE node given the pieces.
	 *
	 *
	 *	@exception	StandardException
	 */
         private StatementNode getUpdateNode(FromTable fromTable,
                                                                                 TableName tableName,
                                                                                 ResultColumnList setClause,
                                                                                 ValueNode whereClause)
                throws StandardException
        {
                FromList   fromList = (FromList) nodeFactory.getNode(
                                                                C_NodeTypes.FROM_LIST,
                                                                getContextManager());

                fromList.addFromTable(fromTable);

                SelectNode resultSet = (SelectNode) nodeFactory.getNode(
                                                                                C_NodeTypes.SELECT_NODE,
                                                                                setClause,
                                                                                null,   /* AGGREGATE list */
                                                                                fromList, /* FROM list */
                                                                                whereClause, /* WHERE clause */
                                                                                null, /* GROUP BY list */
                                                                                null, /* having clause */
                                                                                getContextManager());

                StatementNode retval =
                        (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.UPDATE_NODE,
                                                        tableName,
                                                        resultSet,
                                                        getContextManager());

                setUpAndLinkParameters();

                return retval;
        }

    /**
     * Generate a trim operator node
     * @param trimSpec one of Leading, Trailing or Both.
     * @param trimChar the character to trim. Can be null in which case it defaults
     * to ' '.
     * @param trimSource expression to be trimmed.
     */
    private ValueNode getTrimOperatorNode(Integer trimSpec, ValueNode trimChar,
        ValueNode trimSource, ContextManager cm) throws StandardException
    {
        if (trimChar == null)
        {
                trimChar = (CharConstantNode) nodeFactory.getNode(
                                                        C_NodeTypes.CHAR_CONSTANT_NODE,
                                                        " ",
                                                        getContextManager());
        }
        return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.TRIM_OPERATOR_NODE,
                                                        trimSource, // receiver
                                                        trimChar,   // leftOperand.
                                                        null,
                                                        ReuseFactory.getInteger(TernaryOperatorNode.TRIM),
                                                        trimSpec,
                                                        cm == null ? getContextManager() : cm);
    }

    private boolean ansiTrimSpecFollows()
    {
        return (getToken(2).kind == LEADING || getToken(2).kind == TRAILING
                || getToken(2).kind == BOTH);
    }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a remainingPredicate() rule.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			remainingPredicate()
	 */
        private boolean remainingPredicateFollows()
        {
                boolean retval = false;

                switch (getToken(1).kind)
                {
                  case EQUALS_OPERATOR:
                  case NOT_EQUALS_OPERATOR:
                  case NOT_EQUALS_OPERATOR2: // !=
                  case LESS_THAN_OPERATOR:
                  case GREATER_THAN_OPERATOR:
                  case LESS_THAN_OR_EQUALS_OPERATOR:
                  case GREATER_THAN_OR_EQUALS_OPERATOR:
                  case IN:
                  case LIKE:
                  case BETWEEN:
                        retval = true;
                        break;

                  case NOT:
                        switch (getToken(2).kind)
                        {
                          case IN:
                          case LIKE:
                          case BETWEEN:
                                retval = true;
                        }
                        break;
                }

                return retval;
        }


        /**
	 * Determine whether the next token is a DROP
	 *
	 * @return	TRUE iff the next token is DROP
	 */
        private boolean dropFollows()
        {
                if (getToken(1).kind == DROP)
                { return true; }
                else { return false; }
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a escapedValueFunction().
	 *
	 * We check only for the punctuation here, because identifiers are
	 * very hard to check for in semantic lookahead.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			escapedValueFunction()
	 */
        private boolean escapedValueFunctionFollows()
        {
                if (getToken(1).kind != LEFT_BRACE)
                {
                        return false;
                }

                return getToken(2).kind == FN;
        }


    /**
       List of JDBC escape functions that map directly onto
       a function in the SYSFUN schema.
    */
        private static final String[] ESCAPED_SYSFUN_FUNCTIONS =
        {"ACOS", "ASIN", "ATAN", "COS", "SIN", "TAN", "PI",
         "DEGREES", "RADIANS", "EXP", "LOG", "LOG10", "CEILING", "FLOOR",
         "SIGN", "RAND", "COT" };

    /**
       Convert a JDBC escaped function name to a function
       name in the SYSFUC schema. Returns null if no such
       function exists.
    */
        private String getEscapedSYSFUN(String name)
        {
            name = StringUtil.SQLToUpperCase(name);

            for (int i = 0; i < ESCAPED_SYSFUN_FUNCTIONS.length; i++)
            {
                if (ESCAPED_SYSFUN_FUNCTIONS[i].equals(name))
                    return name;
            }
            return null;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a columnInvocation() rule.  columnInvocations start with
	 * [ [ id . ] id . ] id . id (
	 *
	 * We check only for the punctuation here, because identifiers are
	 * very hard to check for in semantic lookahead.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			columnInvocation()
	 */
        private boolean columnMethodInvocationFollows()
        {
                int tokKind;

                // First token must not be a built-in function name that can be
                // followed immediately by a PERIOD. There are only a few of
                // these - most built-in functions have a LEFT_PAREN following
                // the function name.

                // if we run out of token, it's probably a syntax error,  
                // in fact
                tokKind = getToken(1).kind;
                if ( tokKind == EOF ) { return false; }

                // disambiguate from named parameter reference
                if ( getToken(1).image.charAt(0) == '?' ) { return false; }

                if (tokKind == CURRENT_DATE ||
                        tokKind == CURRENT_TIME ||
                        tokKind == CURRENT_TIMESTAMP ||
                        tokKind == CURRENT && (isDATETIME(getToken(2).kind)) )
                {
                        return false;
                }

                // Second token must be a PERIOD
                if (getToken(2).kind != PERIOD)
                {
                        return false;
                }

                // We have established that we start with " id . "
                tokKind = getToken(4).kind;
                if (tokKind == LEFT_PAREN)
                {
                        // id.id(
                        return true;
                }

                // Not id.id(, so 4th token must be PERIOD
                if (tokKind != PERIOD)
                {
                        return false;
                }

                tokKind = getToken(6).kind;
                if (tokKind == LEFT_PAREN)
                {
                        // id.id.id(
                        return true;
                }

                // Not id.id.id(, so 6th token must be PERIOD
                if (tokKind != PERIOD)
                {
                        return false;
                }

                tokKind = getToken(8).kind;
                if (tokKind == LEFT_PAREN)
                {
                        // id.id.id.id(
                        return true;
                }

                return false;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of an aggregateNode()() rule.  aggregateNodes() start with one
	 * of the built-in aggregate names, or with an identifier followed
	 * by "( DISTINCT". A non-distinct user-defined aggregate invocation
	 * is treated as a staticMethodInvocationAlias() by the parser,
	 * and the binding phase figures out what it really is by looking
	 * at the data dictionary.
	 *
	 * We check only for the punctuation here, because identifiers are
	 * very hard to check for in semantic lookahead.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			aggregateNode()
	 */
        private boolean aggregateFollows()
        {
                boolean retval = false;

                switch (getToken(1).kind)
                {
                  case MAX:
                  case AVG:
                  case MIN:
                  case SUM:
                        // This is a built-in aggregate
                        retval = true;
                        break;

                  case COUNT:
                        // COUNT is not a reserved word
                        // This may eclipse use of COUNT as a function or a procedure that is probably what we want
                        if (getToken(2).kind == LEFT_PAREN)
                                retval = true;
                  default:
                        // Not a built-in aggregate - assume the first token is an
                        // identifier, and see whether it is followed by " ( DISTINCT "
                        if (getToken(2).kind == LEFT_PAREN && getToken(3).kind == DISTINCT)
                                retval = true;
                        break;
                }

                return retval;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a miscBuiltins().
	 *
	 * We check only for the punctuation here, because identifiers are
	 * very hard to check for in semantic lookahead.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			aggregateNode()
	 */
        private boolean miscBuiltinFollows()
        {
                boolean retval = false;
                int tokKind = getToken(1).kind;

                if (getToken(0).kind == CALL)
                        retval = true;

                switch (tokKind)
                {
                  case GET_CURRENT_CONNECTION:
                  case CURRENT_DATE:
                  case CURRENT_TIME:
                  case CURRENT_TIMESTAMP:
                        retval = true;
                        break;

                  case CURRENT:
                        if (isDATETIME(getToken(2).kind))
                                retval = true;
                        break;

                  case CAST:
                  case LEFT_PAREN:
                        retval = false;
                        break;

                  default:
                    if (getToken(2).kind == LEFT_PAREN)
                                retval = true;
                        break;
                }

                return retval;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a subquery. A subquery can begin with an arbitrary number of
	 * left parentheses, followed by either SELECT or VALUES.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			subquery.
	 */
        private boolean subqueryFollows()
        {
                int tokKind;
                boolean retval = false;

                for (int i = 1; true; i++)
                {
                        tokKind = getToken(i).kind;
                        if (tokKind == LEFT_PAREN)
                        {
                                // A subquery can start with an arbitrary number of left
                                // parentheses.
                                continue;
                        }
                        else if (tokKind == SELECT || tokKind == VALUES)
                        {
                                // If the first token we find after all the left parentheses
                                // is SELECT or VALUES, it's a subquery.
                                retval = true;
                                break;
                        }
                        else
                        {
                                // If the first token we find after all the left parentheses
                                // is neither SELECT nor VALUES, it's not a subquery.
                                break;
                        }
                }

                return retval;
        }


        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a rowValueConstructorList. A rowValueConstructorList is a comma-
	 * separated list of expressions enclosed in parentheses. This presents
	 * special problems, because an expression be nested within an
	 * arbitrary number of parentheses. To determine whether a left
	 * parenthesis introduces a rowValueConstructorList or an expression,
	 * we need to find the closing parenthesis, and determine whether
	 * the next token is a comma.
	 *
	 * For example, the following is a rowValueConstructorList:
	 *
	 *		(((1)), 2)
	 *
	 * and the following is just an expression:
	 *
	 *		(((1)))
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			subquery.
	 */
        private boolean rowValueConstructorListFollows()
        {
                int nesting;
                boolean retval = false;

                // A rowValueConstructorList starts with a left parenthesis
                if (getToken(1).kind == LEFT_PAREN)
                {
                        // Keep track of the nesting of parens while looking ahead
                        nesting = 1;
                        for (int i = 2; true; i++)
                        {
                                int tokKind = getToken(i).kind;

                                // Special case for NULL/DEFAULT because they are not allowed in
                                // a parenthesized expression, so (null)/(default) must be seen
                                // as a rowValueConstructorList with one element.
                                if (i == 2 && (tokKind == NULL || tokKind == _DEFAULT))
                                {
                                        retval = true;
                                        break;
                                }

                                // There must be a COMMA at nesting level 1 (i.e. outside of
                                // the first expression) for it to be a rowValueConstructorList
                                if (nesting == 1 && tokKind == COMMA)
                                {
                                        retval = true;
                                        break;
                                }

                                // If we run out of tokens before finding the last closing
                                // parenthesis, it's not a rowValueConstructorList (it's
                                // probably a syntax error, in fact)
                                if (tokKind == EOF)
                                {
                                        break;
                                }

                                // Increase the nesting for each (, and decrease it for each )
                                if (tokKind == LEFT_PAREN)
                                {
                                        nesting++;
                                }
                                else if (tokKind == RIGHT_PAREN)
                                {
                                        nesting--;
                                }

                                // Don't look any farther than the last closing parenthesis
                                if (nesting == 0)
                                {
                                        break;
                                }
                        }
                }

                return retval;
        }

        /**
	 * Determine whether the next token is the beginning of a propertyList(). 
	 * A properties list is the comment "--derby-properties" followed by a 
	 * dot-separated list, followed by an =, followed by a value all on that 
	 * comment line. This means that the comment should start with the word
	 * "derby-properties".
	 *
	 * @return	TRUE iff the next token is derby-properties 
	 */
        private boolean derbyPropertiesListFollows()
        {
                return
                        getToken(1).kind == DERBYDASHPROPERTIES;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a newInvocation(). A newInvocation() begins with the word "new"
	 * followed by a dot-separated list of identifiers, followed
	 * by a left parenthesis.
	 *
	 * @param startToken	Token to look for new at
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			newInvocation().
	 */
        private boolean newInvocationFollows(int startToken)
        {
                boolean retval = false;

                // newInvocation() starts with the word "new"
                if (getToken(startToken).kind == NEW)
                {
                        // Look at every other token. Ignore the identifiers, because
                        // they are hard to test for.
                        for (int i = 2 + startToken; true; i += 2)
                        {
                                int tokKind = getToken(i).kind;

                                // If we find a left parenthesis without any intervening
                                // cruft, we have found a newInvocation()
                                if (tokKind == LEFT_PAREN)
                                {
                                        retval = true;
                                        break;
                                }
                                else if (tokKind != PERIOD)
                                {
                                        // Anything other than a PERIOD is "cruft"
                                        break;
                                }
                        }
                }

                return retval;
        }
        /**
	 * Determine whether the next sequence of tokens is a class name
	 *
	 * @return	TRUE iff the next set of tokens is the java class name
	 */
        boolean javaClassFollows()
        {
                boolean retval = false;

                // Look at every other token. Ignore the identifiers, because
                // they are hard to test for.
                for (int i = 2; true; i += 2)
                {
                        int tokKind = getToken(i).kind;

                        // If we find a '::' without any intervening
                        // cruft, we have found a javaClass
                        if (tokKind == DOUBLE_COLON)
                        {
                                retval = true;
                                break;
                        }
                        else if (tokKind != PERIOD)
                        {
                                // Anything other than a PERIOD is "cruft"
                                break;
                        }
                }

                return retval;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a FROM newInvocation(). A FROM newInvocation() begins with the words "from new"
	 * followed by a dot-separated list of identifiers, followed
	 * by a left parenthesis.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			FROM newInvocation().
	 */
        private boolean fromNewInvocationFollows()
        {
                boolean retval = false;

                // FROM newInvocation() starts with the words "from new"
                return (getToken(1).kind == FROM && newInvocationFollows(2));
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a joinedTableExpression(). A joinedTableExpression() begins
	 * with one of:
	 *
	 *	JOIN
	 *	INNER JOIN
	 *	LEFT OUTER JOIN
	 *	RIGHT OUTER JOIN
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			joinedTableExpression().
	 */
        private boolean joinedTableExpressionFollows()
        {
                boolean retval = false;

                int tokKind1 = getToken(1).kind;
                int tokKind2 = getToken(2).kind;

                if (tokKind1 == JOIN)
                {
                        retval = true;
                }
                else if (tokKind1 == INNER && tokKind2 == JOIN)
                {
                        retval = true;
                }
                else if ((tokKind1 == LEFT || tokKind1 == RIGHT) && tokKind2 == OUTER)
                {
                        if (getToken(3).kind == JOIN)
                        {
                                retval = true;
                        }
                }
                else if ((tokKind1 == LEFT || tokKind1 == RIGHT) && tokKind2 == JOIN)
                {
                        retval = true;
                }

                return retval;
        }

        /**
	 * Translate a token for the name of a built-in aggregate to a String
	 * containing an aggregate name.
	 */
        private static String aggName(Token token)
        {
                String  retval = null;

                switch (token.kind)
                {
                  case MAX:
                        retval = "MAX";
                        break;

                  case AVG:
                    retval = "AVG";
                        break;

                  case MIN:
                    retval = "MIN";
                        break;

                  case SUM:
                    retval = "SUM";
                        break;

                  case COUNT:
                    retval = "COUNT";
                        break;

                  default:
                        if (SanityManager.DEBUG)
                        {
                                SanityManager.THROWASSERT("Unexpected token type in aggName: " +
                                                                                        token.kind);
                        }
                        break;
                }

                return retval;
        }

        /**
	 * Translate a token for the name of a built-in aggregate to an
	 * aggregate definition class.
	 */
        private static Class aggClass(Token token)
        {
                Class   retval = null;

                switch (token.kind)
                {
                  case MAX:
                  case MIN:
                        retval = MaxMinAggregateDefinition.class;
                        break;

                  case AVG:
                  case SUM:
                        retval = SumAvgAggregateDefinition.class;
                        break;

                  case COUNT:
                    retval = CountAggregateDefinition.class;
                        break;

                  default:
                        if (SanityManager.DEBUG)
                        {
                                SanityManager.THROWASSERT("Unexpected token type in aggClass: "
                                                                                        + token.kind);
                        }
                        break;
                }

                return retval;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of another element in a PROPERTY list. These elements are of the
	 * form:
	 *
	 *		COMMA dot.separated.list = ...
	 *
	 * Look for the COMMA, the dots in the dot-separated list, and the =
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			another element in a PROPERTY list.
	 */
        private boolean anotherPropertyFollows()
        {
                boolean retval = false;

                // Element must start with COMMA
                if (getToken(1).kind == COMMA)
                {
                        // Rest of element is dot-separated list with = at end
                        int i = 3;
                        int tokKind;
                        do
                        {
                                tokKind = getToken(i).kind;

                                // If we've found nothing but PERIODs until the EQUALS_OPERATOR
                                // it is the beginning of another property list element.
                                if (tokKind == EQUALS_OPERATOR)
                                {
                                        retval = true;
                                        break;
                                }

                                i += 2;
                        } while (tokKind == PERIOD);
                }

                return retval;
        }

        /**
	 * Get one of the several types of create alias nodes.
	 *
	 * @param aliasName	The name of the alias
	 * @param fullStaticMethodName	The full path/method name
	 * @param aliasSpecificInfo	 Information specific to the type of alias being created.
	 * @param aliasType	The type of alias to create
	 * @param delimitedIdentifier	Whether or not to treat the class name
	 *								as a delimited identifier if trying to
	 *								resolve it as a class alias.
	 *
	 * @return	A CreateAliasNode matching the given parameters
	 *
	 * @exception StandardException		Thrown on error
	 */
        StatementNode
        getCreateAliasNode(
                Object aliasName,
                String fullStaticMethodName,
                Object aliasSpecificInfo,
                char aliasType,
                Boolean delimitedIdentifier)
                throws StandardException
        {

                StatementNode aliasNode = (StatementNode) getNodeFactory().getCreateAliasNode
                        (
                                aliasName,
                                fullStaticMethodName,
                                aliasSpecificInfo,
                                aliasType,
                                delimitedIdentifier,
                                getContextManager()
                        );

                return aliasNode;
        }

        /**
		Create a node for the drop alias/procedure call.
	*/
        StatementNode
        dropAliasNode(Object aliasName, char type) throws StandardException
        {

                StatementNode stmt = (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_ALIAS_NODE,
                                                                aliasName,
                                                                new Character(type),
                                                                getContextManager());

                return stmt;
        }

    /**
     * Get a substring node from
     *      - the string
     *      - the start position
     *      - the length
     *      - a boolean values for specifying the kind of substring function
     * @exception StandardException  Thrown on error
     */
    ValueNode getSubstringNode( ValueNode stringValue, ValueNode startPosition,
                         ValueNode length, Boolean boolVal ) throws StandardException
    {
        return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.SUBSTRING_OPERATOR_NODE,
                                                stringValue,
                                                startPosition,
                                                length,
                                                ReuseFactory.getInteger(TernaryOperatorNode.SUBSTRING),
                                                null,
                                                    getContextManager());
    }

    final public TableName
    qualifiedName(int id_length_limit) throws ParseException, StandardException
    {
        return qualifiedName( C_NodeTypes.TABLE_NAME, id_length_limit);
    }

    private void initStatement( String statementSQLText, Object[] paramDefaults)
        throws StandardException
    {
        /* Do per-statement initialization here */
        parameterNumber = 0;
       this.statementSQLText = statementSQLText;
        this.paramDefaults = paramDefaults;
        nodeFactory = getNodeFactory();
        initUnnamedParameterList();
    } // End of initStatement

    private void checkIdentifierLengthLimit( String identifier, int identifier_length_limit)
        throws StandardException
    {
        if (identifier.length() > identifier_length_limit)
                throw StandardException.newException(SQLState.LANG_IDENTIFIER_TOO_LONG, identifier, String.valueOf(identifier_length_limit));
    }

    private ValueNode getJdbcIntervalNode( int intervalType) throws StandardException
    {
        return (ValueNode) nodeFactory.getNode( C_NodeTypes.INT_CONSTANT_NODE,
                                                ReuseFactory.getInteger( intervalType),
                                                getContextManager());
    }

        private void checkAuthorizationLength( String authorization)
                throws StandardException
        {
                checkIdentifierLengthLimit( authorization, Limits.DB2_MAX_USERID_LENGTH);
        }

    /**
        Check to see if the required claues have been added
        to a procedure or function defintion.
        
        @param required int array of require clauses
        @param  clauses the array of declared clauses.
    */
    void checkRequiredRoutineClause(int[] required, Object[] clauses)
        throws StandardException
    {
        for (int i = 0; i < required.length; i++)
        {
            int re = required[i];
            if (clauses[re] == null)
            {
                throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR,
                                 ROUTINE_CLAUSE_NAMES[re]);
                    }
                }
    }

/*
 * <A NAME="Statement">Statement</A>
 */
  final public StatementNode Statement(String statementSQLText, Object[] paramDefaults) throws ParseException, StandardException {
        StatementNode   statementNode;

        initStatement(statementSQLText, paramDefaults);
    statementNode = StatementPart(null);
    jj_consume_token(0);
                {if (true) return statementNode;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode proceduralStatement(Token[] tokenHolder) throws ParseException, StandardException {
        StatementNode statementNode;
        tokenHolder[0] = getToken(1);
    switch (jj_nt.kind) {
    case INSERT:
      statementNode = insertStatement();
      break;
    case UPDATE:
      statementNode = preparableUpdateStatement();
      break;
    case DELETE:
      statementNode = preparableDeleteStatement();
      break;
    case SELECT:
    case VALUES:
    case LEFT_PAREN:
      statementNode = preparableSelectStatement(true);
      break;
    case CALL:
    case LEFT_BRACE:
    case QUESTION_MARK:
      statementNode = callStatement();
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return statementNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="StatementPart">StatementPart</A>
 * 
 * @param tokenHolder returns the token that starts
 * the statement.  If null, ignored.
 */
  final public StatementNode StatementPart(Token[] tokenHolder) throws ParseException, StandardException {
        StatementNode   statementNode;
        //before starting new statements, initialize this variables. Otherwise, the left
        //over values from previously failed sql will affect the next sql. 
        explicitNotNull = false;
        explicitNull = false;
        explicitlyNullableColumnsList = new Vector();

        /*
	** Grab the token preceding this production
	*/
        if (tokenHolder != null)
        {
                tokenHolder[0] = getToken(1);
        }
    switch (jj_nt.kind) {
    case LOCK:
    case RENAME:
      switch (jj_nt.kind) {
      case RENAME:
        statementNode = spsRenameStatement();
        break;
      case LOCK:
        // statementNode = SQLTransactionStatement() |
                statementNode = lockStatement();
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return statementNode;}
      break;
    default:
      jj_la1[4] = jj_gen;
      if (jj_2_2(1)) {
        switch (jj_nt.kind) {
        case CREATE:
          statementNode = createStatements();
          break;
        case DROP:
          statementNode = dropStatements();
          break;
        case ALTER:
          statementNode = spsAlterStatement();
          break;
        case DECLARE:
          statementNode = globalTemporaryTableDeclaration();
          break;
        case DELETE:
        case INSERT:
        case ROLLBACK:
        case SELECT:
        case UPDATE:
        case VALUES:
        case RELEASE:
        case SAVEPOINT:
        case CALL:
        case LEFT_BRACE:
        case LEFT_PAREN:
        case QUESTION_MARK:
          statementNode = preparableSQLDataStatement();
          break;
        default:
          jj_la1[2] = jj_gen;
          if (jj_2_1(1)) {
            statementNode = spsSetStatement();
          } else {
            switch (jj_nt.kind) {
            case TRUNCATE:
              statementNode = truncateTableStatement();
              break;
            case GRANT:
              statementNode = grantStatement();
              break;
            case REVOKE:
              statementNode = revokeStatement();
              break;
            case EXECUTE:
              statementNode = execStatement();
              break;
            default:
              jj_la1[3] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        {if (true) return statementNode;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="createStatements">spsCreateStatement</A>
 */
  final public StatementNode createStatements() throws ParseException, StandardException {
        StatementNode statementNode;
        Token beginToken;
        int tokKind;
    beginToken = jj_consume_token(CREATE);
    switch (jj_nt.kind) {
    case SCHEMA:
    case VIEW:
    case SYNONYM:
    case TRIGGER:
      switch (jj_nt.kind) {
      case SCHEMA:
        statementNode = schemaDefinition();
        break;
      case VIEW:
        statementNode = viewDefinition(beginToken);
        break;
      case TRIGGER:
        statementNode = triggerDefinition();
        break;
      case SYNONYM:
        statementNode = synonymDefinition();
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }

      break;
    case TABLE:
      statementNode = tableDefinition();

      break;
    case PROCEDURE:
      statementNode = procedureDefinition();
      break;
    case FUNCTION:
      statementNode = functionDefinition();
      break;
    case UNIQUE:
    case INDEX:
      statementNode = indexDefinition();

      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return statementNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dropStatements">spsDropStatement</A>
 */
  final public StatementNode dropStatements() throws ParseException, StandardException {
        StatementNode statementNode;
    jj_consume_token(DROP);
    switch (jj_nt.kind) {
    case SCHEMA:
      statementNode = dropSchemaStatement();
      break;
    case TABLE:
      statementNode = dropTableStatement();
      break;
    case INDEX:
      statementNode = dropIndexStatement();
      break;
    case FUNCTION:
    case PROCEDURE:
    case SYNONYM:
      statementNode = dropAliasStatement();
      break;
    case VIEW:
      statementNode = dropViewStatement();
      break;
    case TRIGGER:
      statementNode = dropTriggerStatement();
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return statementNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="spsAlterStatement">spsAlterStatement</A>
 */
  final public StatementNode spsAlterStatement() throws ParseException, StandardException {
        StatementNode statementNode;
    jj_consume_token(ALTER);
    statementNode = alterTableStatement();
                {if (true) return statementNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="spsSetStatement">spsSetStatement</A>
 */
  final public StatementNode spsSetStatement() throws ParseException, StandardException {
        StatementNode statementNode;
    if (getToken(1).kind == SET && getToken(2).kind != CURRENT) {
      jj_consume_token(SET);
      if (jj_2_3(1)) {
        statementNode = setIsolationStatement();
      } else if (jj_2_4(1)) {
        statementNode = setSchemaStatement();
      } else {
        switch (jj_nt.kind) {
        case MESSAGE_LOCALE:
          statementNode = setMessageLocaleStatement();
          break;
        default:
          jj_la1[8] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
                {if (true) return statementNode;}
    } else if (getToken(1).kind == SET && getToken(2).kind == CURRENT) {
      jj_consume_token(SET);
      if (jj_2_5(1)) {
        statementNode = setSchemaStatement();
      } else if (jj_2_6(1)) {
        statementNode = setIsolationStatement();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
                {if (true) return statementNode;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="preparableSQLDataStatement">preparableSQLDataStatement</A>
 *
 * preparableSQLDataStatement differs from
 * directSQLDataStatement in that it
 * supports positioned update and delete
 * and a preparable select (with FOR UPDATE)
 * instead of a direct select (without FOR UPDATE)
 */
  final public StatementNode preparableSQLDataStatement() throws ParseException, StandardException {
        StatementNode   dmlStatement;
    switch (jj_nt.kind) {
    case DELETE:
      /*
      	** RESOLVE: Ignoring temporary table declarations for now.
      	*/
              dmlStatement = preparableDeleteStatement();
                {if (true) return dmlStatement;}
      break;
    case SELECT:
    case VALUES:
    case LEFT_PAREN:
      dmlStatement = preparableSelectStatement(true);
                {if (true) return dmlStatement;}
      break;
    case INSERT:
      dmlStatement = insertStatement();
                {if (true) return dmlStatement;}
      break;
    case UPDATE:
      dmlStatement = preparableUpdateStatement();
                {if (true) return dmlStatement;}
      break;
    case CALL:
    case LEFT_BRACE:
    case QUESTION_MARK:
      dmlStatement = callStatement();
                {if (true) return dmlStatement;}
      break;
    case ROLLBACK:
    case RELEASE:
    case SAVEPOINT:
      dmlStatement = savepointStatement();
                {if (true) return dmlStatement;}
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="preparableDeleteStatement">preparableDeleteStatement</A>
 *
 *	This may be a search or positioned delete statement.
 */
  final public StatementNode preparableDeleteStatement() throws ParseException, StandardException {
        StatementNode qtn;
    jj_consume_token(DELETE);
    qtn = deleteBody();
                {if (true) return qtn;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode deleteBody() throws ParseException, StandardException {
        JavaToSQLValueNode      javaToSQLNode = null;
        String                          correlationName = null;
        TableName  tableName = null;
        ValueNode  whereClause = null;
        FromTable  fromTable = null;
        QueryTreeNode retval;
        Properties targetProperties = null;
        Token      whereToken = null;
    if (fromNewInvocationFollows()) {
      jj_consume_token(FROM);
      javaToSQLNode = newInvocation();
      switch (jj_nt.kind) {
      case WHERE:
        whereToken = jj_consume_token(WHERE);
        whereClause = whereClause(whereToken);
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
                fromTable =  (FromTable) nodeFactory.getNode(
                                                                        C_NodeTypes.FROM_VTI,
                                                                        javaToSQLNode.getJavaValueNode(),
                                                                        (String) null,
                                                                        null,
                                                                        (Properties) null,
                                                                        getContextManager());

                {if (true) return getDeleteNode(fromTable, tableName, whereClause);}
    } else {
      switch (jj_nt.kind) {
      case FROM:
        jj_consume_token(FROM);
        tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
        if ((getToken(1).kind != EOF) && (getToken(1).kind != WHERE) && !derbyPropertiesListFollows()) {
          switch (jj_nt.kind) {
          case AS:
            jj_consume_token(AS);
            break;
          default:
            jj_la1[11] = jj_gen;
            ;
          }
          correlationName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
        } else {
          ;
        }
        switch (jj_nt.kind) {
        case DERBYDASHPROPERTIES:
          targetProperties = propertyList(false);
          jj_consume_token(CHECK_PROPERTIES);
          break;
        default:
          jj_la1[12] = jj_gen;
          ;
        }
        switch (jj_nt.kind) {
        case WHERE:
          whereToken = jj_consume_token(WHERE);
          if ((getToken(1).kind == CURRENT) &&
                                                   (getToken(2).kind == OF)) {
            fromTable = currentOfClause(correlationName);
          } else if (jj_2_7(1)) {
            whereClause = whereClause(whereToken);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[13] = jj_gen;
          ;
        }
                /* Fabricate a ResultSetNode (SelectNode) under the DeleteNode.
		 * For a searched delete,
		 * The FromList is simply the table that we are deleting from.
		 * (NOTE - we mark the table as the one that we are deleting from.)
		 * For a positioned delete,
		 * the FromList is a CurrentOfNode holding the cursor name.
		 * The select list will be null for now.  We will generate it at
	 	 * bind time, in keeping with the design decision that the parser's
	  	 * output should look like the language.
		 */
                if (fromTable == null)
                        fromTable = (FromTable) nodeFactory.getNode(
                                                                                C_NodeTypes.FROM_BASE_TABLE,
                                                                                tableName,
                                                                                correlationName,
                                                                                ReuseFactory.getInteger(
                                                                                                FromBaseTable.DELETE),
                                                                                null,
                                                                                getContextManager());

                /* Update the FromTable with any properties, if non-null */
                if (targetProperties != null)
                {
                        if (SanityManager.DEBUG)
                        {
                                if (((FromBaseTable) fromTable).getProperties() != null)
                                {
                                        SanityManager.THROWASSERT(
                                                "Overwriting existing properties");
                                }
                        }
                        ((FromBaseTable) fromTable).setTableProperties(targetProperties);
                }

                {if (true) return getDeleteNode(fromTable, tableName, whereClause);}
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="currentOfClause">currentOfClause</A>
 */
  final public FromTable currentOfClause(String correlationName) throws ParseException, StandardException {
        String cursorName = null;
    jj_consume_token(CURRENT);
    jj_consume_token(OF);
    cursorName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                {if (true) return (FromTable) nodeFactory.getNode(
                                                                C_NodeTypes.CURRENT_OF_NODE,
                                                                correlationName,
                                                                cursorName,
                                                                null,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="preparableSelectStatement">preparableSelectStatement</A>
 *
 *
 *	The preparable select statement is a superset of
 *	the directSelectStatementMultipleRows in that it
 *	allows both the preparable single row select statement
 *	(a query expression that returns one row, although it
 *	is also handled like a cursor) and the preparable
 *	multiple row select statement, which allows not only
 *	an order by clause but also a for update clause.
 */
  final public CursorNode preparableSelectStatement(boolean checkParams) throws ParseException, StandardException {
        ResultSetNode     queryExpression;
        Vector  updateColumns = new Vector();
        int               forUpdateState = CursorNode.UNSPECIFIED;
        int                               isolationLevel = ExecutionContext.UNSPECIFIED_ISOLATION_LEVEL;
        CursorNode                retval;
        OrderByList orderCols = null;
    queryExpression = queryExpression(null, NO_SET_OP);
    switch (jj_nt.kind) {
    case ORDER:
      orderCols = orderByClause();
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case FOR:
      jj_consume_token(FOR);
      forUpdateState = forUpdateClause(updateColumns);
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case WITH:
      isolationLevel = atIsolationLevel();
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
                // Note: if order by is specified, the for update clause
                // must be READ ONLY or empty, and the cursor
                // is implicitly READ_ONLY.

                retval = (CursorNode) nodeFactory.getNode(
                                C_NodeTypes.CURSOR_NODE,
                                "SELECT",
                                queryExpression,
                                null,
                                orderCols,
                                ReuseFactory.getInteger(forUpdateState),
                                (forUpdateState == CursorNode.READ_ONLY ? null : updateColumns ),
                                getContextManager());

                if (checkParams)
                {
                        setUpAndLinkParameters();
                }

                /* Set the isolation levels for the scans if specified */
                if (isolationLevel != ExecutionContext.UNSPECIFIED_ISOLATION_LEVEL)
                {
                        getCompilerContext().setScanIsolationLevel(isolationLevel);
                }

                {if (true) return retval;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="insertStatement">insertStatement</A>
 */
  final public StatementNode insertStatement() throws ParseException, StandardException {
        StatementNode   insertNode;
        QueryTreeNode   targetTable;
    jj_consume_token(INSERT);
    jj_consume_token(INTO);
    targetTable = targetTable();
    insertNode = insertColumnsAndSource(targetTable);
                setUpAndLinkParameters();

                {if (true) return insertNode;}
    throw new Error("Missing return statement in function");
  }

  final public QueryTreeNode targetTable() throws ParseException, StandardException {
        JavaToSQLValueNode      javaToSQLNode = null;
        String                          correlationName = null;
        TableName                       tableName;
    if (newInvocationFollows(1)) {
      javaToSQLNode = newInvocation();
                {if (true) return nodeFactory.getNode(
                                                                C_NodeTypes.FROM_VTI,
                                                                javaToSQLNode.getJavaValueNode(),
                                                                correlationName,
                                                                null,
                                                                (Properties) null,
                                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case BINARY:
      case COALESCE:
      case COUNT:
      case D:
      case MODULE:
      case T:
      case TS:
      case VALUE:
      case VARBINARY:
      case ABS:
      case ABSVAL:
      case ACTION:
      case ALWAYS:
      case BLOB:
      case C:
      case CALLED:
      case CLOB:
      case COBOL:
      case COMMITTED:
      case CONCAT:
      case CONTAINS:
      case DATA:
      case DATE:
      case DAY:
      case DYNAMIC:
      case FORTRAN:
      case GENERATED:
      case IDENTITY_VAL_LOCAL:
      case INCREMENT:
      case INITIAL:
      case INTERVAL:
      case LANGUAGE:
      case LARGE:
      case LENGTH:
      case LEVEL:
      case LOCKS:
      case LOCKSIZE:
      case LOGGED:
      case MOD:
      case MODIFIES:
      case MODIFY:
      case MONTH:
      case _MORE:
      case MUMPS:
      case NAME:
      case NCLOB:
      case NULLABLE:
      case NUMBER:
      case OBJECT:
      case PASCAL:
      case PLI:
      case PRECISION:
      case RELEASE:
      case REPEATABLE:
      case RESTART:
      case RETURNS:
      case ROW:
      case SAVEPOINT:
      case SCALE:
      case SERIALIZABLE:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case START:
      case STATEMENT:
      case SYNONYM:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TRUNCATE:
      case TYPE:
      case UNCOMMITTED:
      case USAGE:
      case WHEN:
      case CURDATE:
      case CURTIME:
      case DATABASE:
      case LONG:
      case AFTER:
      case BEFORE:
      case CLASS:
      case COMPRESS:
      case CONTENT:
      case CS:
      case DB2SQL:
      case DIRTY:
      case DOCUMENT:
      case EACH:
      case EMPTY:
      case EXCLUSIVE:
      case FN:
      case INDEX:
      case JAVA:
      case LCASE:
      case LOCATE:
      case LOCK:
      case MESSAGE_LOCALE:
      case METHOD:
      case MODE:
      case NEW:
      case NEW_TABLE:
      case OJ:
      case OFF:
      case OLD:
      case OLD_TABLE:
      case PARAMETER:
      case PASSING:
      case PROPERTIES:
      case READS:
      case REF:
      case REFERENCING:
      case RENAME:
      case RESET:
      case RESULT:
      case RETAIN:
      case RETURNING:
      case RR:
      case RS:
      case SEQUENCE:
      case SEQUENTIAL:
      case SETS:
      case SHARE:
      case SQLID:
      case SPECIFIC:
      case SQRT:
      case STABILITY:
      case STRIP:
      case STYLE:
      case TRIGGER:
      case UCASE:
      case UR:
      case WHITESPACE:
      case IDENTIFIER:
      case DELIMITED_IDENTIFIER:
        tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return tableName;}
        break;
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="preparableUpdateStatement">preparableUpdateStatement</A>
 */
  final public StatementNode preparableUpdateStatement() throws ParseException, StandardException {
        StatementNode qtn;
    jj_consume_token(UPDATE);
    qtn = updateBody();
                {if (true) return qtn;}
    throw new Error("Missing return statement in function");
  }

  final public boolean tableOrIndex() throws ParseException {
    switch (jj_nt.kind) {
    case TABLE:
      jj_consume_token(TABLE);
                {if (true) return true;}
      break;
    case INDEX:
      jj_consume_token(INDEX);
                {if (true) return false;}
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public StatementNode updateBody() throws ParseException, StandardException {
        ResultColumnList        columnList;
        String                          correlationName = null;
        JavaToSQLValueNode      javaToSQLNode = null;
        TableName  tableName = null;
        ValueNode  whereClause = null;
        FromTable  fromTable = null;
        Properties targetProperties = null;
        Token      whereToken = null;
    if (newInvocationFollows(1)) {
      javaToSQLNode = newInvocation();
      jj_consume_token(SET);
      columnList = setClauseList();
      switch (jj_nt.kind) {
      case WHERE:
        whereToken = jj_consume_token(WHERE);
        whereClause = whereClause(whereToken);
        break;
      default:
        jj_la1[20] = jj_gen;
        ;
      }
                fromTable =  (FromTable) nodeFactory.getNode(
                                                                        C_NodeTypes.FROM_VTI,
                                                                        javaToSQLNode.getJavaValueNode(),
                                                                        (String) null,
                                                                        null,
                                                                        (Properties) null,
                                                                        getContextManager());

                {if (true) return getUpdateNode(fromTable, tableName, columnList, whereClause);}
    } else {
      switch (jj_nt.kind) {
      case BINARY:
      case COALESCE:
      case COUNT:
      case D:
      case MODULE:
      case T:
      case TS:
      case VALUE:
      case VARBINARY:
      case ABS:
      case ABSVAL:
      case ACTION:
      case ALWAYS:
      case BLOB:
      case C:
      case CALLED:
      case CLOB:
      case COBOL:
      case COMMITTED:
      case CONCAT:
      case CONTAINS:
      case DATA:
      case DATE:
      case DAY:
      case DYNAMIC:
      case FORTRAN:
      case GENERATED:
      case IDENTITY_VAL_LOCAL:
      case INCREMENT:
      case INITIAL:
      case INTERVAL:
      case LANGUAGE:
      case LARGE:
      case LENGTH:
      case LEVEL:
      case LOCKS:
      case LOCKSIZE:
      case LOGGED:
      case MOD:
      case MODIFIES:
      case MODIFY:
      case MONTH:
      case _MORE:
      case MUMPS:
      case NAME:
      case NCLOB:
      case NULLABLE:
      case NUMBER:
      case OBJECT:
      case PASCAL:
      case PLI:
      case PRECISION:
      case RELEASE:
      case REPEATABLE:
      case RESTART:
      case RETURNS:
      case ROW:
      case SAVEPOINT:
      case SCALE:
      case SERIALIZABLE:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case START:
      case STATEMENT:
      case SYNONYM:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TRUNCATE:
      case TYPE:
      case UNCOMMITTED:
      case USAGE:
      case WHEN:
      case CURDATE:
      case CURTIME:
      case DATABASE:
      case LONG:
      case AFTER:
      case BEFORE:
      case CLASS:
      case COMPRESS:
      case CONTENT:
      case CS:
      case DB2SQL:
      case DIRTY:
      case DOCUMENT:
      case EACH:
      case EMPTY:
      case EXCLUSIVE:
      case FN:
      case INDEX:
      case JAVA:
      case LCASE:
      case LOCATE:
      case LOCK:
      case MESSAGE_LOCALE:
      case METHOD:
      case MODE:
      case NEW:
      case NEW_TABLE:
      case OJ:
      case OFF:
      case OLD:
      case OLD_TABLE:
      case PARAMETER:
      case PASSING:
      case PROPERTIES:
      case READS:
      case REF:
      case REFERENCING:
      case RENAME:
      case RESET:
      case RESULT:
      case RETAIN:
      case RETURNING:
      case RR:
      case RS:
      case SEQUENCE:
      case SEQUENTIAL:
      case SETS:
      case SHARE:
      case SQLID:
      case SPECIFIC:
      case SQRT:
      case STABILITY:
      case STRIP:
      case STYLE:
      case TRIGGER:
      case UCASE:
      case UR:
      case WHITESPACE:
      case IDENTIFIER:
      case DELIMITED_IDENTIFIER:
        tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
        if ((getToken(1).kind != SET) && !derbyPropertiesListFollows()) {
          switch (jj_nt.kind) {
          case AS:
            jj_consume_token(AS);
            break;
          default:
            jj_la1[21] = jj_gen;
            ;
          }
          correlationName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
        } else {
          ;
        }
        switch (jj_nt.kind) {
        case DERBYDASHPROPERTIES:
          targetProperties = propertyList(false);
          jj_consume_token(CHECK_PROPERTIES);
          break;
        default:
          jj_la1[22] = jj_gen;
          ;
        }
        jj_consume_token(SET);
        columnList = setClauseList();
        switch (jj_nt.kind) {
        case WHERE:
          whereToken = jj_consume_token(WHERE);
          if (jj_2_8(1)) {
            whereClause = whereClause(whereToken);
          } else {
            switch (jj_nt.kind) {
            case CURRENT:
              fromTable = currentOfClause(correlationName);
              break;
            default:
              jj_la1[23] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
        default:
          jj_la1[24] = jj_gen;
          ;
        }
                /* Fabricate a ResultSetNode (SelectNode) under the UpdateNode.
		 * For a searched update,
		 * The FromList is simply the table that we are updating.
		 * For a positioned update,
		 * the FromList is a CurrentOfNode holding the cursor name.
		 * (NOTE - we mark the table as the one that we are updating.)
		 * The select list is the columns in the SET clause.  At bind time,
	 	 * we will prepend the CurrentRowLocation() in keeping with the design 
		 * decision that the parser's output should look like the language.
		 */
                if (fromTable == null)
                        fromTable = (FromTable) nodeFactory.getNode(
                                                                                C_NodeTypes.FROM_BASE_TABLE,
                                                                                tableName,
                                                                                correlationName,
                                                                                ReuseFactory.getInteger(
                                                                                                                FromBaseTable.UPDATE),
                                                                                null,
                                                                                getContextManager());

                /* Update the FromTable with any properties, if non-null */
                if (targetProperties != null)
                {
                        if (SanityManager.DEBUG)
                        {
                                if (((FromBaseTable) fromTable).getProperties() != null)
                                {
                                        SanityManager.THROWASSERT(
                                                "Overwriting existing properties");
                                }
                        }
                        ((FromBaseTable) fromTable).setTableProperties(targetProperties);
                }
                {if (true) return getUpdateNode(fromTable, tableName, columnList, whereClause);}
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="callStatement">callStatement</A>
 */
  final public StatementNode callStatement() throws ParseException, StandardException {
        StatementNode retval;
    switch (jj_nt.kind) {
    case CALL:
    case QUESTION_MARK:
      retval = bareCallStatement();
      break;
    case LEFT_BRACE:
      jj_consume_token(LEFT_BRACE);
      retval = bareCallStatement();
      jj_consume_token(RIGHT_BRACE);
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return retval;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="bareCallStatement">baseCallStatement</A>
 */
  final public StatementNode bareCallStatement() throws ParseException, StandardException {
        ParameterNode           returnParam;

        ValueNode                       value;

        ResultSetNode           resultSetNode;
    switch (jj_nt.kind) {
    case CALL:
      jj_consume_token(CALL);
      value = primaryExpression(true);
                if (! (value instanceof JavaToSQLValueNode) ||
                        ! (((JavaToSQLValueNode) value).getJavaValueNode() instanceof MethodCallNode))
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_CALL_STATEMENT);}
                }

                StatementNode callStatement =
                                                                        (StatementNode) nodeFactory.getNode(
                                                                                                C_NodeTypes.CALL_STATEMENT_NODE,
                                                                                                value,
                                                                                                getContextManager());

                setUpAndLinkParameters();

                {if (true) return callStatement;}
      break;
    case QUESTION_MARK:
      returnParam = dynamicParameterSpecification();
                getCompilerContext().setReturnParameterFlag(); //bug4450

      jj_consume_token(EQUALS_OPERATOR);
      jj_consume_token(CALL);
      resultSetNode = rowValueConstructor(null);
                // validate that we have something that is an appropriate call statement
                ResultColumnList rcl = resultSetNode.getResultColumns();

                // we can have only 1 return value/column
                if (rcl == null || rcl.size() > 1)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_CALL_STATEMENT);}
                }

                // we must have a method call node
                value = ((ResultColumn) rcl.elementAt(0)).getExpression();
                if (! (value instanceof JavaToSQLValueNode) ||
                        ! (((JavaToSQLValueNode) value).getJavaValueNode() instanceof MethodCallNode))
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_CALL_STATEMENT);}
                }

                // wrap the row result set in a cursor node
                StatementNode cursorNode =
                                        (StatementNode) nodeFactory.getNode(
                                                C_NodeTypes.CURSOR_NODE,
                                                "SELECT",
                                                resultSetNode,
                                                null,
                                                null,
                                                ReuseFactory.getInteger(CursorNode.READ_ONLY),
                                                null,
                                                getContextManager());

                // set the 0th param to be a RETURN param
                returnParam.setReturnOutputParam(value);

                setUpAndLinkParameters();

                {if (true) return cursorNode;}
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="primaryExpression">primaryExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode primaryExpression(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode                       value = null;
    if (getToken(2).kind == PERIOD &&
                    getToken(4).kind == LEFT_PAREN) {
      value = routineInvocation();
                {if (true) return value;}
    } else if (jj_2_9(1)) {
      value = primaryExpressionXX(inSelectClause);
                {if (true) return value;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/* 
 * <A NAME="savepointStatement">savepointStatement</A>

	savepointStatementClauses contains the UNIQUE, ON ROLLBACK RETAIN LOCKS, ON ROLLBACK RETAIN CURSORS clauses.

	0 - Boolean - UNIQUE clause
	1 - Boolean - ON ROLLBACK RETAIN LOCKS clause
	2 - Boolean - ON ROLLBACK RETAIN CURSORS clause
 */
  final public StatementNode savepointStatement() throws ParseException, StandardException {
        String                  savepointName = null;
        int                     savepointStatementType;
        Object[] savepointStatementClauses = new Object[3];
    switch (jj_nt.kind) {
    case SAVEPOINT:
      jj_consume_token(SAVEPOINT);
      savepointName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      label_1:
      while (true) {
        savepointStatementClause(savepointStatementClauses);
        switch (jj_nt.kind) {
        case ON:
        case UNIQUE:
          ;
          break;
        default:
          jj_la1[28] = jj_gen;
          break label_1;
        }
      }
                //ON ROLLBACK RETAIN CURSORS is mandatory
                if (savepointStatementClauses[2] == null)
                                {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "MISSING ON ROLLBACK RETAIN CURSORS");}
                savepointStatementType = 1;
      break;
    case ROLLBACK:
      jj_consume_token(ROLLBACK);
      switch (jj_nt.kind) {
      case WORK:
        jj_consume_token(WORK);
        break;
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      jj_consume_token(TO);
      jj_consume_token(SAVEPOINT);
      switch (jj_nt.kind) {
      case BINARY:
      case COALESCE:
      case COUNT:
      case D:
      case MODULE:
      case T:
      case TS:
      case VALUE:
      case VARBINARY:
      case ABS:
      case ABSVAL:
      case ACTION:
      case ALWAYS:
      case BLOB:
      case C:
      case CALLED:
      case CLOB:
      case COBOL:
      case COMMITTED:
      case CONCAT:
      case CONTAINS:
      case DATA:
      case DATE:
      case DAY:
      case DYNAMIC:
      case FORTRAN:
      case GENERATED:
      case IDENTITY_VAL_LOCAL:
      case INCREMENT:
      case INITIAL:
      case INTERVAL:
      case LANGUAGE:
      case LARGE:
      case LENGTH:
      case LEVEL:
      case LOCKS:
      case LOCKSIZE:
      case LOGGED:
      case MOD:
      case MODIFIES:
      case MODIFY:
      case MONTH:
      case _MORE:
      case MUMPS:
      case NAME:
      case NCLOB:
      case NULLABLE:
      case NUMBER:
      case OBJECT:
      case PASCAL:
      case PLI:
      case PRECISION:
      case RELEASE:
      case REPEATABLE:
      case RESTART:
      case RETURNS:
      case ROW:
      case SAVEPOINT:
      case SCALE:
      case SERIALIZABLE:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case START:
      case STATEMENT:
      case SYNONYM:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TRUNCATE:
      case TYPE:
      case UNCOMMITTED:
      case USAGE:
      case WHEN:
      case CURDATE:
      case CURTIME:
      case DATABASE:
      case LONG:
      case AFTER:
      case BEFORE:
      case CLASS:
      case COMPRESS:
      case CONTENT:
      case CS:
      case DB2SQL:
      case DIRTY:
      case DOCUMENT:
      case EACH:
      case EMPTY:
      case EXCLUSIVE:
      case FN:
      case INDEX:
      case JAVA:
      case LCASE:
      case LOCATE:
      case LOCK:
      case MESSAGE_LOCALE:
      case METHOD:
      case MODE:
      case NEW:
      case NEW_TABLE:
      case OJ:
      case OFF:
      case OLD:
      case OLD_TABLE:
      case PARAMETER:
      case PASSING:
      case PROPERTIES:
      case READS:
      case REF:
      case REFERENCING:
      case RENAME:
      case RESET:
      case RESULT:
      case RETAIN:
      case RETURNING:
      case RR:
      case RS:
      case SEQUENCE:
      case SEQUENTIAL:
      case SETS:
      case SHARE:
      case SQLID:
      case SPECIFIC:
      case SQRT:
      case STABILITY:
      case STRIP:
      case STYLE:
      case TRIGGER:
      case UCASE:
      case UR:
      case WHITESPACE:
      case IDENTIFIER:
      case DELIMITED_IDENTIFIER:
        savepointName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
                savepointStatementType = 2;
      break;
    case RELEASE:
      jj_consume_token(RELEASE);
      switch (jj_nt.kind) {
      case TO:
        jj_consume_token(TO);
        break;
      default:
        jj_la1[31] = jj_gen;
        ;
      }
      jj_consume_token(SAVEPOINT);
      savepointName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                savepointStatementType = 3;
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SAVEPOINT_NODE,
                                                                savepointName,
                                                                ReuseFactory.getInteger(savepointStatementType),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void savepointStatementClause(Object[] savepointStatementClauses) throws ParseException, StandardException {
        int clausePosition = -1;
    switch (jj_nt.kind) {
    case UNIQUE:
      jj_consume_token(UNIQUE);
                          clausePosition = 0;
      break;
    case ON:
      jj_consume_token(ON);
      jj_consume_token(ROLLBACK);
      jj_consume_token(RETAIN);
      clausePosition = LocksOrCursors();
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if (clausePosition != -1) {
                        // check for repeated clause
                        if (savepointStatementClauses[clausePosition] != null) {

                                String which = SAVEPOINT_CLAUSE_NAMES[clausePosition];
                                {if (true) throw StandardException.newException(SQLState.LANG_DB2_MULTIPLE_ELEMENTS, which);}
                        }

                        savepointStatementClauses[clausePosition] = Boolean.TRUE;
                }
  }

/*
 * <A NAME="LocksOrCursors">LocksOrCursors</A>
 */
  final public int LocksOrCursors() throws ParseException {
    switch (jj_nt.kind) {
    case LOCKS:
      jj_consume_token(LOCKS);
                {if (true) return (1);}
      break;
    case CURSORS:
      jj_consume_token(CURSORS);
                {if (true) return (2);}
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/* 
 * <A NAME="globalTemporaryTableDeclaration">globalTemporaryTableDeclaration</A>

	declareTableClauses contains the NOT LOGGED, on commit and on rollback clauses.

	0 - Boolean - NOT LOGGED clause
	1 - Boolean - on commit behavior
	2 - Boolean - on rollback behavior
 */
  final public StatementNode globalTemporaryTableDeclaration() throws ParseException, StandardException {
        TableName                       tableName;
        TableElementList tableElementList;
        Object[] declareTableClauses = new Object[3];
    jj_consume_token(DECLARE);
    jj_consume_token(GLOBAL);
    jj_consume_token(TEMPORARY);
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    tableElementList = tableElementList();
    label_2:
    while (true) {
      declareTableClause(declareTableClauses);
      if (jj_2_10(1)) {
        ;
      } else {
        break label_2;
      }
    }
                // NOT LOGGED is mandatory
                if (declareTableClauses[0] == null)
                                {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "MISSING NOT LOGGED");}
                // if ON COMMIT behavior not explicitly specified in DECLARE command, resort to default ON COMMIT DELETE ROWS
                if (declareTableClauses[1] == null)
                                declareTableClauses[1] = Boolean.TRUE;
                // if ON ROLLBACK behavior not explicitly specified in DECLARE command, resort to default ON ROLLBACK DELETE ROWS
                if (declareTableClauses[2] == null)
                                declareTableClauses[2] = Boolean.TRUE;
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_TABLE_NODE,
                                                                tableName,
                                                                tableElementList,
                                                                (Properties)null,
                                                                (Boolean) declareTableClauses[1],
                                                                (Boolean) declareTableClauses[2],
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void declareTableClause(Object[] declareTableClauses) throws ParseException, StandardException {
        int clausePosition = -1;
        Object clauseValue = null;
    switch (jj_nt.kind) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(LOGGED);
                                clauseValue = Boolean.TRUE; clausePosition = 0;
      break;
    default:
      jj_la1[35] = jj_gen;
      if (getToken(1).kind == ON && getToken(2).kind == COMMIT) {
        jj_consume_token(ON);
        jj_consume_token(COMMIT);
        clauseValue = onCommit();
        jj_consume_token(ROWS);
                                                                    clausePosition = 1;
      } else if (getToken(1).kind == ON && getToken(2).kind == ROLLBACK) {
        jj_consume_token(ON);
        jj_consume_token(ROLLBACK);
        jj_consume_token(DELETE);
        jj_consume_token(ROWS);
                                                  clauseValue = Boolean.TRUE; clausePosition = 2;
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                if (clausePosition != -1) {
                        // check for repeated clause
                        if (declareTableClauses[clausePosition] != null) {

                                String which = TEMPORARY_TABLE_CLAUSE_NAMES[clausePosition];
                                {if (true) throw StandardException.newException(SQLState.LANG_DB2_MULTIPLE_ELEMENTS, which);}
                        }

                        declareTableClauses[clausePosition] = clauseValue;
                }
  }

/*
 * <A NAME="onCommit">onCommit</A>
 */
  final public Boolean onCommit() throws ParseException {
    switch (jj_nt.kind) {
    case PRESERVE:
      jj_consume_token(PRESERVE);
                {if (true) return (Boolean.FALSE);}
      break;
    case DELETE:
      jj_consume_token(DELETE);
                {if (true) return (Boolean.TRUE);}
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableElementList">tableElementList</A>
 */
  final public TableElementList tableElementList() throws ParseException, StandardException {
        TableElementList        tableElementList =
                                        (TableElementList) nodeFactory.getNode(
                                                                        C_NodeTypes.TABLE_ELEMENT_LIST,
                                                                        getContextManager());
    jj_consume_token(LEFT_PAREN);
    tableElement(tableElementList);
    label_3:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[37] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      tableElement(tableElementList);
    }
    jj_consume_token(RIGHT_PAREN);
                {if (true) return tableElementList;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableElement">tableElement</A>
 */
  final public void tableElement(TableElementList tableElementList) throws ParseException, StandardException {
        TableElementNode        tableElement;
        //initialize following two booleans for every new table element so that the
        //values from previous tableElement doesn't impact the next tableElement
        explicitNotNull = false;
        explicitNull = false;
    switch (jj_nt.kind) {
    case BINARY:
    case COALESCE:
    case COUNT:
    case D:
    case MODULE:
    case T:
    case TS:
    case VALUE:
    case VARBINARY:
    case ABS:
    case ABSVAL:
    case ACTION:
    case ALWAYS:
    case BLOB:
    case C:
    case CALLED:
    case CLOB:
    case COBOL:
    case COMMITTED:
    case CONCAT:
    case CONTAINS:
    case DATA:
    case DATE:
    case DAY:
    case DYNAMIC:
    case FORTRAN:
    case GENERATED:
    case IDENTITY_VAL_LOCAL:
    case INCREMENT:
    case INITIAL:
    case INTERVAL:
    case LANGUAGE:
    case LARGE:
    case LENGTH:
    case LEVEL:
    case LOCKS:
    case LOCKSIZE:
    case LOGGED:
    case MOD:
    case MODIFIES:
    case MODIFY:
    case MONTH:
    case _MORE:
    case MUMPS:
    case NAME:
    case NCLOB:
    case NULLABLE:
    case NUMBER:
    case OBJECT:
    case PASCAL:
    case PLI:
    case PRECISION:
    case RELEASE:
    case REPEATABLE:
    case RESTART:
    case RETURNS:
    case ROW:
    case SAVEPOINT:
    case SCALE:
    case SERIALIZABLE:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case START:
    case STATEMENT:
    case SYNONYM:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TRUNCATE:
    case TYPE:
    case UNCOMMITTED:
    case USAGE:
    case WHEN:
    case CURDATE:
    case CURTIME:
    case DATABASE:
    case LONG:
    case AFTER:
    case BEFORE:
    case CLASS:
    case COMPRESS:
    case CONTENT:
    case CS:
    case DB2SQL:
    case DIRTY:
    case DOCUMENT:
    case EACH:
    case EMPTY:
    case EXCLUSIVE:
    case FN:
    case INDEX:
    case JAVA:
    case LCASE:
    case LOCATE:
    case LOCK:
    case MESSAGE_LOCALE:
    case METHOD:
    case MODE:
    case NEW:
    case NEW_TABLE:
    case OJ:
    case OFF:
    case OLD:
    case OLD_TABLE:
    case PARAMETER:
    case PASSING:
    case PROPERTIES:
    case READS:
    case REF:
    case REFERENCING:
    case RENAME:
    case RESET:
    case RESULT:
    case RETAIN:
    case RETURNING:
    case RR:
    case RS:
    case SEQUENCE:
    case SEQUENTIAL:
    case SETS:
    case SHARE:
    case SQLID:
    case SPECIFIC:
    case SQRT:
    case STABILITY:
    case STRIP:
    case STYLE:
    case TRIGGER:
    case UCASE:
    case UR:
    case WHITESPACE:
    case IDENTIFIER:
    case DELIMITED_IDENTIFIER:
      tableElement = columnDefinition(tableElementList);
                tableElementList.addTableElement(tableElement);
      break;
    case CHECK:
    case CONSTRAINT:
    case FOREIGN:
    case PRIMARY:
    case UNIQUE:
      tableElement = tableConstraintDefinition();
                tableElementList.addTableElement(tableElement);
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="columnDefinition">columnDefinition</A>
 */
  final public TableElementNode columnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        DataTypeDescriptor      typeDescriptor = null;
        ValueNode                       defaultNode = null;
        String                          columnName;
        long[]                          autoIncrementInfo = new long[4];
    /*
    	** RESOLVE: We are ignoring domains and collation.
    	*/
    
            /* identifier() used to be columnName() */
            columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    typeDescriptor = dataTypeDDL();
    switch (jj_nt.kind) {
    case CHECK:
    case CONSTRAINT:
    case _DEFAULT:
    case NOT:
    case PRIMARY:
    case REFERENCES:
    case UNIQUE:
    case WITH:
    case GENERATED:
      defaultNode = defaultAndConstraints(typeDescriptor, tableElementList, columnName, autoIncrementInfo);
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
                // Only pass autoincrement info for autoincrement columns
                if (autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_AUTOINCREMENT_INDEX] == 0)
                {
                        autoIncrementInfo = null;
                }

                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                                C_NodeTypes.COLUMN_DEFINITION_NODE,
                                                                columnName,
                                                                defaultNode,
                                                                typeDescriptor,
                                                                autoIncrementInfo,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="defaultAndConstraints">defaultAndConstraints</A>
 */
  final public ValueNode defaultAndConstraints(DataTypeDescriptor typeDescriptor,
                                          TableElementList tableElementList,
                                          String columnName,
                                          long[] autoIncrementInfo) throws ParseException, StandardException {
        ValueNode               defaultNode = null;
    switch (jj_nt.kind) {
    case CHECK:
    case CONSTRAINT:
    case NOT:
    case PRIMARY:
    case REFERENCES:
    case UNIQUE:
      columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
      label_4:
      while (true) {
        switch (jj_nt.kind) {
        case CHECK:
        case CONSTRAINT:
        case NOT:
        case PRIMARY:
        case REFERENCES:
        case UNIQUE:
          ;
          break;
        default:
          jj_la1[40] = jj_gen;
          break label_4;
        }
        columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
      }
      switch (jj_nt.kind) {
      case _DEFAULT:
      case WITH:
      case GENERATED:
        defaultNode = defaultClause(autoIncrementInfo, columnName);
        label_5:
        while (true) {
          switch (jj_nt.kind) {
          case CHECK:
          case CONSTRAINT:
          case NOT:
          case PRIMARY:
          case REFERENCES:
          case UNIQUE:
            ;
            break;
          default:
            jj_la1[41] = jj_gen;
            break label_5;
          }
          columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
        }
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
                {if (true) return defaultNode;}
      break;
    case _DEFAULT:
    case WITH:
    case GENERATED:
      defaultNode = defaultClause(autoIncrementInfo, columnName);
      label_6:
      while (true) {
        switch (jj_nt.kind) {
        case CHECK:
        case CONSTRAINT:
        case NOT:
        case PRIMARY:
        case REFERENCES:
        case UNIQUE:
          ;
          break;
        default:
          jj_la1[43] = jj_gen;
          break label_6;
        }
        columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
      }
                {if (true) return defaultNode;}
      break;
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dataTypeDDL">dataTypeDDL</A>
 */
  final public DataTypeDescriptor dataTypeDDL() throws ParseException, StandardException {
        DataTypeDescriptor      typeDescriptor;
    if (commonDatatypeName(false)) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    typeDescriptor = dataTypeCommon();
                {if (true) return typeDescriptor;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dataTypeCast">dataTypeCast</A>
 */
  final public DataTypeDescriptor dataTypeCast() throws ParseException, StandardException {
        DataTypeDescriptor      typeDescriptor;
    if (commonDatatypeName(true)) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    typeDescriptor = dataTypeCommon();
                {if (true) return typeDescriptor;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dataTypeCommon">dataTypeCommon</A>
 */
  final public DataTypeDescriptor dataTypeCommon() throws ParseException, StandardException {
        DataTypeDescriptor      typeDescriptor;
        boolean checkCS = false;
    if (jj_2_11(1)) {
      if (getToken(2).kind != LARGE) {

      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      typeDescriptor = characterStringType();
    } else if (jj_2_12(1)) {
      if (getToken(3).kind != LARGE) {

      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      typeDescriptor = nationalCharacterStringType();
    } else if (jj_2_13(1)) {
      typeDescriptor = numericType();
    } else {
      switch (jj_nt.kind) {
      case DATE:
      case TIME:
      case TIMESTAMP:
        typeDescriptor = datetimeType();
        break;
      case BOOLEAN:
        jj_consume_token(BOOLEAN);
        checkInternalFeature(TypeId.BOOLEAN_NAME);
        typeDescriptor = new DataTypeDescriptor(TypeId.BOOLEAN_ID, true);
        break;
      case LONG:
        typeDescriptor = longType();
        break;
      case BINARY:
      case CHAR:
      case CHARACTER:
      case NATIONAL:
      case BLOB:
      case CLOB:
      case NCLOB:
        typeDescriptor = LOBType();
        break;
      case XML:
        typeDescriptor = XMLType();
        break;
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                {if (true) return typeDescriptor;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="characterStringType">characterStringType</A>
 */
  final public DataTypeDescriptor characterStringType() throws ParseException, StandardException {
        int                                     length = DEFAULT_STRING_COLUMN_LENGTH;
        Token                           varyingToken = null;
        int type;
    switch (jj_nt.kind) {
    case VARCHAR:
      jj_consume_token(VARCHAR);
      length = charLength();
                type = Types.VARCHAR;
      break;
    case CHAR:
    case CHARACTER:
      charOrCharacter();
      switch (jj_nt.kind) {
      case VARYING:
        // Length is optional for CHARACTER, not for plain CHARACTER VARYING
                        varyingToken = jj_consume_token(VARYING);
        length = charLength();
        break;
      default:
        jj_la1[47] = jj_gen;
        switch (jj_nt.kind) {
        case LEFT_PAREN:
          length = charLength();
          break;
        default:
          jj_la1[46] = jj_gen;
          ;
        }
      }
                // If the user says CHARACTER VARYING, it's really VARCHAR
                type = (varyingToken == null ? Types.CHAR : Types.VARCHAR);
      break;
    default:
      jj_la1[48] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_nt.kind) {
    case FOR:
      type = forBitData(type);
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
                checkTypeLimits(type,length);
                DataTypeDescriptor charDTD = DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);
                {if (true) return charDTD;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="charOrCharacter">charOrCharacter</A>
 */
  final public void charOrCharacter() throws ParseException {
    switch (jj_nt.kind) {
    case CHAR:
      jj_consume_token(CHAR);
      break;
    case CHARACTER:
      jj_consume_token(CHARACTER);
      break;
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="charType">charType</A>
 */
  final public int charLength() throws ParseException, StandardException {
        int length;
    jj_consume_token(LEFT_PAREN);
    length = length();
    jj_consume_token(RIGHT_PAREN);
                {if (true) return length;}
    throw new Error("Missing return statement in function");
  }

/*
** <A NAME="forBitData">forBitData</A>
*/
  final public int forBitData(int charType) throws ParseException {
    jj_consume_token(FOR);
    jj_consume_token(BIT);
    jj_consume_token(DATA);
                if (charType == Types.CHAR)
                        charType = Types.BINARY;
                else if (charType == Types.VARCHAR)
                        charType = Types.VARBINARY;
                else if (charType == Types.LONGVARCHAR)
                        charType = Types.LONGVARBINARY;

                {if (true) return charType;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nationalCharacterStringType">nationalCharacterStringType</A>
 */
  final public DataTypeDescriptor nationalCharacterStringType() throws ParseException, StandardException {
        DataTypeDescriptor      dataTypeDescriptor;
        int                                     length = DEFAULT_STRING_COLUMN_LENGTH;
        String                          type = null;
        Token                           varyingToken = null;
    switch (jj_nt.kind) {
    case NATIONAL:
      jj_consume_token(NATIONAL);
      charOrCharacter();
      switch (jj_nt.kind) {
      case VARYING:
        // Length is optional for NATIONAL CHARACTER , not for NATIONAL CHARACTER VARYING
                        varyingToken = jj_consume_token(VARYING);
        length = charLength();
        break;
      default:
        jj_la1[52] = jj_gen;
        switch (jj_nt.kind) {
        case LEFT_PAREN:
          length = charLength();
          break;
        default:
          jj_la1[51] = jj_gen;
          ;
        }
      }
                // If the user says NATIONAL CHARACTER VARYING, it's really NATIONALVARCHAR
                type = (varyingToken == null ? TypeId.NATIONAL_CHAR_NAME :
                                TypeId.NATIONAL_VARCHAR_NAME);
      break;
    case NCHAR:
      jj_consume_token(NCHAR);
      switch (jj_nt.kind) {
      case VARYING:
        // Length is optional for NCHAR, not for NCHAR VARYING
                        varyingToken = jj_consume_token(VARYING);
        length = charLength();
        break;
      default:
        jj_la1[54] = jj_gen;
        switch (jj_nt.kind) {
        case LEFT_PAREN:
          length = charLength();
          break;
        default:
          jj_la1[53] = jj_gen;
          ;
        }
      }
                // If the user says NCHAR VARYING, it's really NATIONALVARCHAR
                type = (varyingToken == null ? TypeId.NATIONAL_CHAR_NAME :
                                TypeId.NATIONAL_VARCHAR_NAME);
      break;
    case NVARCHAR:
      jj_consume_token(NVARCHAR);
      length = charLength();
                type = TypeId.NATIONAL_VARCHAR_NAME;
      break;
    default:
      jj_la1[55] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                // need to re-enable according to SQL standard
                {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, type);}
                // return DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);

    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="LOBType">lobType</A>
 */
  final public DataTypeDescriptor LOBType() throws ParseException, StandardException {
        int     length = 2147483647; // default to 2GB-1 if no length specified
        String  type;
    switch (jj_nt.kind) {
    case BLOB:
      jj_consume_token(BLOB);
      switch (jj_nt.kind) {
      case LEFT_PAREN:
        length = lengthAndModifier();
        break;
      default:
        jj_la1[56] = jj_gen;
        ;
      }
                        type = TypeId.BLOB_NAME;
      break;
    case CLOB:
      jj_consume_token(CLOB);
      switch (jj_nt.kind) {
      case LEFT_PAREN:
        length = lengthAndModifier();
        break;
      default:
        jj_la1[57] = jj_gen;
        ;
      }
                        type = TypeId.CLOB_NAME;
      break;
    case NCLOB:
      jj_consume_token(NCLOB);
      length = lengthAndModifier();
                        type = TypeId.NCLOB_NAME;
                        // need to re-enable according to SQL standard
                        {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, type);}
      break;
    case BINARY:
      jj_consume_token(BINARY);
      jj_consume_token(LARGE);
      jj_consume_token(OBJECT);
      switch (jj_nt.kind) {
      case LEFT_PAREN:
        length = lengthAndModifier();
        break;
      default:
        jj_la1[58] = jj_gen;
        ;
      }
                        type = TypeId.BLOB_NAME;
      break;
    case CHAR:
    case CHARACTER:
      charOrCharacter();
      jj_consume_token(LARGE);
      jj_consume_token(OBJECT);
      switch (jj_nt.kind) {
      case LEFT_PAREN:
        length = lengthAndModifier();
        break;
      default:
        jj_la1[59] = jj_gen;
        ;
      }
                        type = TypeId.CLOB_NAME;
      break;
    case NATIONAL:
      jj_consume_token(NATIONAL);
      jj_consume_token(CHARACTER);
      jj_consume_token(LARGE);
      jj_consume_token(OBJECT);
      length = lengthAndModifier();
                        type = TypeId.NCLOB_NAME;
                        // need to re-enable according to SQL standard
                        {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, type);}
      break;
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);

                {if (true) return dtd;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="numericType">numericType</A>
 */
  final public DataTypeDescriptor numericType() throws ParseException, StandardException {
        DataTypeDescriptor      typeDescriptor;
    switch (jj_nt.kind) {
    case DEC:
    case DECIMAL:
    case INT:
    case INTEGER:
    case NUMERIC:
    case SMALLINT:
    case LONGINT:
      typeDescriptor = exactNumericType();
                {if (true) return typeDescriptor;}
      break;
    default:
      jj_la1[61] = jj_gen;
      if (jj_2_14(1)) {
        typeDescriptor = approximateNumericType();
                {if (true) return typeDescriptor;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="exactNumericType">exactNumericType</A>
 */
  final public DataTypeDescriptor exactNumericType() throws ParseException, StandardException {
        int precision = TypeCompiler.DEFAULT_DECIMAL_PRECISION;
        int scale = TypeCompiler.DEFAULT_DECIMAL_SCALE;
        int type = Types.DECIMAL;
        String typeStr = "DECIMAL";
        int maxWidth;
        DataTypeDescriptor dtd =  null;
    switch (jj_nt.kind) {
    case DEC:
    case DECIMAL:
    case NUMERIC:
      switch (jj_nt.kind) {
      case NUMERIC:
        jj_consume_token(NUMERIC);
                type = Types.NUMERIC;
                typeStr = "NUMERIC";
        break;
      case DECIMAL:
        jj_consume_token(DECIMAL);
        break;
      case DEC:
        jj_consume_token(DEC);
        break;
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_nt.kind) {
      case LEFT_PAREN:
        jj_consume_token(LEFT_PAREN);
        precision = precision();
        switch (jj_nt.kind) {
        case COMMA:
          jj_consume_token(COMMA);
          scale = scale();
          break;
        default:
          jj_la1[63] = jj_gen;
          ;
        }
        jj_consume_token(RIGHT_PAREN);
        break;
      default:
        jj_la1[64] = jj_gen;
        ;
      }
                if ((precision <= 0) ||
                        (precision > TypeCompiler.MAX_DECIMAL_PRECISION_SCALE))
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_PRECISION,
                                typeStr, String.valueOf(precision));}
                }
                else if ((scale < 0) ||
                                 (scale > TypeCompiler.MAX_DECIMAL_PRECISION_SCALE))
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_DECIMAL_SCALE,
                                typeStr, String.valueOf(scale));}
                }
                else if (scale > precision)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_DECIMAL_PRECISION_SCALE,
                                String.valueOf(scale),
                                String.valueOf(precision));}
                }
                /*
		** If we have a decimal point, need to count it
		** towards maxwidth.  Max width needs to account
		** for the possible leading '0' and '-' and the
		** decimal point.  e.g., DEC(1,1) has a maxwidth
		** of 4 (to handle "-0.1").
		*/
                maxWidth = DataTypeUtilities.computeMaxWidth( precision, scale);
                {if (true) return getDataTypeServices(type, precision, scale, maxWidth);}
      break;
    case INT:
    case INTEGER:
    case SMALLINT:
    case LONGINT:
      dtd = exactIntegerType();
                        {if (true) return dtd;}
      break;
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="exactNumericType">exactNumericType</A>
 */
  final public DataTypeDescriptor exactIntegerType() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case INT:
    case INTEGER:
      switch (jj_nt.kind) {
      case INTEGER:
        jj_consume_token(INTEGER);
        break;
      case INT:
        jj_consume_token(INT);
        break;
      default:
        jj_la1[66] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                {if (true) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.INTEGER);}
      break;
    case SMALLINT:
      jj_consume_token(SMALLINT);
                {if (true) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.SMALLINT);}
      break;
    case LONGINT:
      jj_consume_token(LONGINT);
                {if (true) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.BIGINT);}
      break;
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="approximateNumericType">approximateNumericType</A>
 */
  final public DataTypeDescriptor approximateNumericType() throws ParseException, StandardException {
        int type = 0, scale = 0, width = 0;
        int prec = -1;
        DataTypeDescriptor dts = null;
    switch (jj_nt.kind) {
    case FLOAT:
      jj_consume_token(FLOAT);
      switch (jj_nt.kind) {
      case LEFT_PAREN:
        jj_consume_token(LEFT_PAREN);
        prec = precision();
        jj_consume_token(RIGHT_PAREN);
        break;
      default:
        jj_la1[68] = jj_gen;
        ;
      }
                /*
			When not specified, default is DOUBLE_PRECISION
		 */
                if (prec == -1)
                        prec = TypeId.DOUBLE_PRECISION;

                if (prec > 0 && prec <= TypeId.REAL_PRECISION)
                {
                        type = Types.REAL;
                        prec = TypeId.REAL_PRECISION;
                        scale = TypeId.REAL_SCALE;
                        width = TypeId.REAL_MAXWIDTH;
                }
                else if (prec > TypeId.REAL_PRECISION &&
                                 prec <= TypeId.DOUBLE_PRECISION)
                {
                        type = Types.DOUBLE;
                        prec = TypeId.DOUBLE_PRECISION;
                        scale = TypeId.DOUBLE_SCALE;
                        width = TypeId.DOUBLE_MAXWIDTH;
                }
                else
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_PRECISION, "FLOAT", String.valueOf(prec));}

                /*
			REMIND: this is a slight hack, in that exacting reading of
			the InformationSchema requires that the type the user typed
			in be visible to them in the InformationSchema views. But
			most implementations use synonyms or mappings at some point,
			and this is one of those places, for us.
		 */
                {if (true) return getDataTypeServices(type, prec, scale, width);}
      break;
    case REAL:
      jj_consume_token(REAL);
                {if (true) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.REAL);}
      break;
    default:
      jj_la1[69] = jj_gen;
      if (jj_2_15(1)) {
        dts = doubleType();
                {if (true) return dts;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="doubleType">doubleType</A>
 */
  final public DataTypeDescriptor doubleType() throws ParseException, StandardException {
    if (getToken(2).kind == PRECISION) {
      jj_consume_token(DOUBLE);
      jj_consume_token(PRECISION);
    } else {
      switch (jj_nt.kind) {
      case DOUBLE:
        jj_consume_token(DOUBLE);
        break;
      default:
        jj_la1[70] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                {if (true) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.DOUBLE);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="longType">longType</A>
 */
  final public DataTypeDescriptor longType() throws ParseException, StandardException {
        DataTypeDescriptor      dataTypeDescriptor;
    jj_consume_token(LONG);
    dataTypeDescriptor = longSubType();
                {if (true) return dataTypeDescriptor;}
    throw new Error("Missing return statement in function");
  }

  final public DataTypeDescriptor longSubType() throws ParseException, StandardException {
        int lvcType = Types.LONGVARCHAR;
    switch (jj_nt.kind) {
    case VARCHAR:
      jj_consume_token(VARCHAR);
      switch (jj_nt.kind) {
      case FOR:
        lvcType = forBitData(lvcType);
        break;
      default:
        jj_la1[71] = jj_gen;
        ;
      }
                {if (true) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(lvcType);}
      break;
    case NVARCHAR:
      jj_consume_token(NVARCHAR);
                // need to re-enable according to SQL standard
                {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, TypeId.NATIONAL_LONGVARCHAR_NAME);}
                // return DataTypeDescriptor.getBuiltInDataTypeDescriptor(TypeId.NATIONAL_LONGVARCHAR_NAME);

      break;
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="XMLType">XMLType</A>
 */
  final public DataTypeDescriptor XMLType() throws ParseException, StandardException {
        DataTypeDescriptor value;
    jj_consume_token(XML);
                checkVersion(DataDictionary.DD_VERSION_DERBY_10_1, "XML");
                {if (true) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(
                        StoredFormatIds.XML_TYPE_ID);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlDocOrContent">xmlDocOrContent</A>
 *
 * Parse the XML keywords DOCUMENT and CONTENT.  We don't
 * support CONTENT yet, so we throw an appropriate error
 * if we see it.
 *
 */
  final public void xmlDocOrContent() throws ParseException, StandardException {
    if ((getToken(1).kind != DOCUMENT) &&
                    (getToken(1).kind != CONTENT)) {
                {if (true) throw StandardException.newException(
                        SQLState.LANG_XML_KEYWORD_MISSING, "DOCUMENT",
                        ReuseFactory.getInteger(getToken(1).beginLine),
                        ReuseFactory.getInteger(getToken(1).beginColumn));}
    } else if (getToken(1).kind == CONTENT) {
      jj_consume_token(CONTENT);
                {if (true) throw StandardException.newException(
                        SQLState.LANG_UNSUPPORTED_XML_FEATURE, "CONTENT");}
    } else if (getToken(1).kind == DOCUMENT) {
      jj_consume_token(DOCUMENT);
                {if (true) return;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="javaType">javaType</A>
 */
  final public DataTypeDescriptor javaType() throws ParseException, StandardException {
        String  javaClassName;
    javaClassName = javaClassName();
                {if (true) return getJavaClassDataTypeDescriptor(javaClassName);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME = "javaDSL">javaDSL</A>
 *
 * A Java dot-separated list.
 */
  final public String javaDSL() throws ParseException {
        String dotSeparatedList;
    dotSeparatedList = caseSensitiveIdentifierPlusReservedWords();
    label_7:
    while (true) {
      switch (jj_nt.kind) {
      case PERIOD:
        ;
        break;
      default:
        jj_la1[73] = jj_gen;
        break label_7;
      }
      dotSeparatedList = javaDSLNameExtender(dotSeparatedList);
    }
                {if (true) return dotSeparatedList;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="javaClassName">javaClassName</A>
 */
  final public String javaClassName() throws ParseException {
        String javaClassName;
    javaClassName = javaDSL();
                {if (true) return javaClassName;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="javaDSLNameExtender">javaDSLNameExtender</A>
 */
  final public String javaDSLNameExtender(String dotSeparatedList) throws ParseException {
        String  extender;
    jj_consume_token(PERIOD);
    extender = caseSensitiveIdentifierPlusReservedWords();
                {if (true) return dotSeparatedList + "." + extender;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="length">lengthAndModifier</A>
 */
  final public int lengthAndModifier() throws ParseException, StandardException {
        Token   tok;
        Token   tokmod = null;
    jj_consume_token(LEFT_PAREN);
    switch (jj_nt.kind) {
    case LENGTH_MODIFIER:
      tok = jj_consume_token(LENGTH_MODIFIER);
      break;
    case EXACT_NUMERIC:
      tok = jj_consume_token(EXACT_NUMERIC);
      switch (jj_nt.kind) {
      case IDENTIFIER:
        tokmod = jj_consume_token(IDENTIFIER);
        break;
      default:
        jj_la1[74] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RIGHT_PAREN);
                String s = tok.image + (tokmod==null ? "" : tokmod.image); // colapse cases;
                try
                {
                        char modifier = s.charAt(s.length()-1);
                        String number = s.substring(0, s.length()-1); // in case of ending w. letter
                        long mul;
                        switch (modifier) {
                        case 'G':
                        case 'g':
                                mul =1073741824L;       //1 Giga
                                break;
                        case 'M':
                        case 'm':
                                mul=1048576L;           // 1 Mega
                                break;
                        case 'K':
                        case 'k':
                                mul=1024L;              // 1 Kilo
                                break;
                        default:
                                mul=1;
                                number = s; // no letter in end, need whole string
                                break;
                        }
                        long    specifiedLength = Long.parseLong(number) * mul;

                        // match DB2 limits of 1 to 2147483647
                        if ((specifiedLength > 0L) &&
                (specifiedLength <= Limits.DB2_LOB_MAXWIDTH))
            {
                                {if (true) return (int)specifiedLength;}
            }

                        // DB2 allows 2G or 2048M or 2097152k that calculate out to 
            // 2147483648, but sets the length to be one less.
                        if (mul != 1 && specifiedLength == 2147483648L)
                                {if (true) return Limits.DB2_LOB_MAXWIDTH;}

                }
                catch (NumberFormatException nfe)
                {
                }

                {if (true) throw StandardException.newException(
            SQLState.LANG_INVALID_COLUMN_LENGTH, s);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="length">length</A>
 */
  final public int length() throws ParseException, StandardException {
        Token   tok;
        int     retval;
    tok = jj_consume_token(EXACT_NUMERIC);
                try
                {
                        retval = Integer.parseInt(tok.image);

                        if (retval > 0)
                                {if (true) return retval;}
                }
                catch (NumberFormatException nfe)
                {
                }
                {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH, tok.image);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="exactNumber">exactNumber</A>
*/
  final public long exactNumber() throws ParseException, StandardException {
        Token longToken;
        String sign = "";
    switch (jj_nt.kind) {
    case PLUS_SIGN:
    case MINUS_SIGN:
      sign = sign();
      break;
    default:
      jj_la1[76] = jj_gen;
      ;
    }
    longToken = jj_consume_token(EXACT_NUMERIC);
                try
                {
                        long longvalue = Long.parseLong(longToken.image);
                        if (sign.equals("-"))
                        {
                                {if (true) return -longvalue;}
                        }
                        else
                        {
                                {if (true) return longvalue;}
                        }
                }
                catch (NumberFormatException nfe)
                {
                        {if (true) throw
                        StandardException.newException(
                                   SQLState.LANG_INVALID_INTEGER_LITERAL, longToken.image);}
                }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="precision">precision</A>
 */
  final public int precision() throws ParseException, StandardException {
        int uintValue;
    uintValue = uint_value();
                {if (true) return uintValue;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="uint_value">uint_value</A>
 */
  final public int uint_value() throws ParseException, StandardException {
        Token uintToken;
    /*
    		because the parser won't match to UINT, we use EXACT_NUMERIC.
    	 */
            uintToken = jj_consume_token(EXACT_NUMERIC);
                try {
                        {if (true) return Integer.parseInt(uintToken.image);}
                } catch (NumberFormatException nfe) {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_INTEGER_LITERAL, uintToken.image);}
                }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="scale">scale</A>
 */
  final public int scale() throws ParseException, StandardException {
        int uintValue;
    uintValue = uint_value();
                {if (true) return uintValue;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="datetimeType">datetimeType</A>
 */
  final public DataTypeDescriptor datetimeType() throws ParseException, StandardException {
        Token tzTok = null;
        int prec = -1;
    switch (jj_nt.kind) {
    case DATE:
      jj_consume_token(DATE);
                {if (true) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.DATE);}
      break;
    case TIME:
      jj_consume_token(TIME);
                /*
			We do not try to set up a precision for time/timestamp
			values because this field gets mapped to the precision
			field in the JDBC driver that is for the number of
			decimal digits in the value.  Precision for time is
			actually the scale of the seconds value.

			If/when precision for times is supported, we may need
			to migrate the system catalog information to fill in
			the default values appropriately (the default for
			time is 0, fortunately; but for timestamp it is
			actually 9 due to java.sql.Timestamp's precision).
		 */
                {if (true) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.TIME);}
      break;
    case TIMESTAMP:
      jj_consume_token(TIMESTAMP);
                {if (true) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.TIMESTAMP);}
      break;
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="timePrecision">timePrecision</A>
 */
  final public void qualifiedNameList(Vector list, int id_length_limit) throws ParseException, StandardException {
    qualifiedNameElement(list, id_length_limit);
    label_8:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[78] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      qualifiedNameElement(list, id_length_limit);
    }
  }

  final public void qualifiedNameElement(Vector list, int id_length_limit) throws ParseException, StandardException {
        TableName qualifiedName = null;
    qualifiedName = qualifiedName(id_length_limit);
                list.addElement(qualifiedName);
  }

/*
 * <A NAME="qualifiedName">qualifiedName</A>
 */
  final public TableName qualifiedName(int nodeType, int id_length_limit) throws ParseException, StandardException {
        //String	catalogName = null;
        String  schemaName = null;
        String  qualifiedId;
        String  firstName = null;
        String  secondName = null;
    firstName = identifier(Limits.MAX_IDENTIFIER_LENGTH, false);
    if (getToken(1).kind == PERIOD &&
                                                                    getToken(2).kind != ASTERISK) {
      jj_consume_token(PERIOD);
      secondName = identifier(Limits.MAX_IDENTIFIER_LENGTH, false);
    } else {
      ;
    }
                if (secondName == null)
                {
                        qualifiedId = firstName;
                }
                else
                {
                        schemaName = firstName;
                        qualifiedId = secondName;
                }

                //limit the qualifiedId to the id length limit passed to this method
                checkIdentifierLengthLimit(qualifiedId, id_length_limit);
                if (schemaName != null)
                        checkIdentifierLengthLimit(schemaName, Limits.MAX_IDENTIFIER_LENGTH);

                {if (true) return (TableName) nodeFactory.getNode(
                                                                nodeType,
                                                                schemaName,
                                                                qualifiedId,
                                                                new Integer(lastIdentifierToken.beginOffset),
                                                                new Integer(lastIdentifierToken.endOffset),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="queryExpression">queryExpression</A>
 *
 * We have to be carefull to get the associativity correct. According to the SQL spec
 *   <non-join query expression> ::=
 *     <non-join query term>
 *    | <query expression body> UNION [ ALL ] <query term>
 *    | <query expression body> EXCEPT [ ALL ] <query term>
 * Meaning that
 *   t1 UNION ALL t2 UNION t3
 * is equivalent to
 *   (t1 UNION ALL t2) UNION t3
 * However recursive descent parsers want recursion to be on the right, so this kind of associativity is unnatural
 * for our parser. The queryExpression method must know whether it is being called as the right hand side of a
 * set operator to produce a query tree with the correct associativity.
 */
  final public ResultSetNode queryExpression(ResultSetNode leftSide, int operatorType) throws ParseException, StandardException {
        ResultSetNode   term;
    term = nonJoinQueryTerm(leftSide, operatorType);
    switch (jj_nt.kind) {
    case EXCEPT:
    case UNION:
      term = unionOrExcept(term);
      break;
    default:
      jj_la1[79] = jj_gen;
      ;
    }
                {if (true) return term;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="unionOrExcept">unionOrExcept</A>
 */
  final public ResultSetNode unionOrExcept(ResultSetNode term) throws ParseException, StandardException {
        ResultSetNode   expression;
        Token                   tok = null;
    switch (jj_nt.kind) {
    case UNION:
      jj_consume_token(UNION);
      switch (jj_nt.kind) {
      case ALL:
      case DISTINCT:
        switch (jj_nt.kind) {
        case ALL:
          tok = jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
          break;
        default:
          jj_la1[80] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[81] = jj_gen;
        ;
      }
      expression = queryExpression(term,
                                                                      (tok != null) ? UNION_ALL_OP : UNION_OP);
                {if (true) return expression;}
      break;
    case EXCEPT:
      jj_consume_token(EXCEPT);
      switch (jj_nt.kind) {
      case ALL:
      case DISTINCT:
        switch (jj_nt.kind) {
        case ALL:
          tok = jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
          break;
        default:
          jj_la1[82] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[83] = jj_gen;
        ;
      }
      expression = queryExpression(term,
                                                                      (tok != null) ? EXCEPT_ALL_OP : EXCEPT_OP);
                {if (true) return expression;}
      break;
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nonJoinQueryTerm">nonJoinQueryTerm</A>
 *
 * Be careful with the associativity of INTERSECT. According to the SQL spec
 *   t1 INTERSECT t2 INTERSECT ALL t3
 * is equivalent to
 *   (t1 INTERSECT t2) INTERSECT ALL t3
 * which is not the same as
 *   t1 INTERSECT (t2 INTERSECT ALL t3)
 * See the comment on queryExpression.
 */
  final public ResultSetNode nonJoinQueryTerm(ResultSetNode leftSide, int operatorType) throws ParseException, StandardException {
        ResultSetNode   term;
    term = nonJoinQueryPrimary();
    switch (jj_nt.kind) {
    case INTERSECT:
      term = intersect(term);
      break;
    default:
      jj_la1[85] = jj_gen;
      ;
    }
        switch( operatorType)
        {
        case NO_SET_OP:
            {if (true) return term;}

        case UNION_OP:
            {if (true) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.UNION_NODE,
                leftSide,
                term,
                Boolean.FALSE,
                Boolean.FALSE,
                null,
                getContextManager());}

        case UNION_ALL_OP:
            {if (true) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.UNION_NODE,
                leftSide,
                term,
                Boolean.TRUE,
                Boolean.FALSE,
                null,
                getContextManager());}

        case EXCEPT_OP:
            {if (true) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.INTERSECT_OR_EXCEPT_NODE,
                ReuseFactory.getInteger( IntersectOrExceptNode.EXCEPT_OP),
                leftSide,
                term,
                Boolean.FALSE,
                null,
                getContextManager());}

        case EXCEPT_ALL_OP:
            {if (true) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.INTERSECT_OR_EXCEPT_NODE,
                ReuseFactory.getInteger( IntersectOrExceptNode.EXCEPT_OP),
                leftSide,
                term,
                Boolean.TRUE,
                null,
                getContextManager());}

        case INTERSECT_OP:
            {if (true) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.INTERSECT_OR_EXCEPT_NODE,
                ReuseFactory.getInteger( IntersectOrExceptNode.INTERSECT_OP),
                leftSide,
                term,
                Boolean.FALSE,
                null,
                getContextManager());}

        case INTERSECT_ALL_OP:
            {if (true) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.INTERSECT_OR_EXCEPT_NODE,
                ReuseFactory.getInteger( IntersectOrExceptNode.INTERSECT_OP),
                leftSide,
                term,
                Boolean.TRUE,
                null,
                getContextManager());}


        default:
            if (SanityManager.DEBUG)
            {
                SanityManager.THROWASSERT( "Invalid set operator type: " + operatorType);
            }
            {if (true) return null;}
        }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="intersect">intersect</A>
 */
  final public ResultSetNode intersect(ResultSetNode term) throws ParseException, StandardException {
        ResultSetNode   expression;
        Token                   tok = null;
    jj_consume_token(INTERSECT);
    switch (jj_nt.kind) {
    case ALL:
    case DISTINCT:
      switch (jj_nt.kind) {
      case ALL:
        tok = jj_consume_token(ALL);
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
        break;
      default:
        jj_la1[86] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[87] = jj_gen;
      ;
    }
    expression = nonJoinQueryTerm(term, (tok != null) ? INTERSECT_ALL_OP : INTERSECT_OP);
                {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nonJoinQueryPrimary">nonJoinQueryPrimary</A>
 */
  final public ResultSetNode nonJoinQueryPrimary() throws ParseException, StandardException {
        ResultSetNode   primary;
    switch (jj_nt.kind) {
    case SELECT:
    case VALUES:
      primary = simpleTable();
                {if (true) return primary;}
      break;
    case LEFT_PAREN:
      jj_consume_token(LEFT_PAREN);
      primary = queryExpression(null, NO_SET_OP);
      jj_consume_token(RIGHT_PAREN);
                {if (true) return primary;}
      break;
    default:
      jj_la1[88] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="simpleTable">simpleTable</A>
 */
  final public ResultSetNode simpleTable() throws ParseException, StandardException {
        ResultSetNode   resultSetNode;
    switch (jj_nt.kind) {
    case SELECT:
      resultSetNode = querySpecification();
                {if (true) return resultSetNode;}
      break;
    case VALUES:
      resultSetNode = tableValueConstructor();
                {if (true) return resultSetNode;}
      break;
    default:
      jj_la1[89] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="querySpecification">querySpecification</A>
 */
  final public ResultSetNode querySpecification() throws ParseException, StandardException {
        ResultColumnList        selectList;
        SelectNode                      selectNode;
        boolean isDistinct = false;
    jj_consume_token(SELECT);
    if (jj_2_16(1)) {
      isDistinct = setQuantifier();
    } else {
      ;
    }
    selectList = selectList();
    selectNode = tableExpression(selectList);
                if (isDistinct) selectNode.makeDistinct();
                {if (true) return selectNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="setQuantifier">setQuantifier</A>
 */
  final public boolean setQuantifier() throws ParseException {
    if (getToken(1).kind == DISTINCT &&
                            !(
                                    getToken(2).kind == PERIOD ||
                                    getToken(2).kind == DOUBLE_COLON
                            )) {
      jj_consume_token(DISTINCT);
                {if (true) return true;}
    } else if (getToken(1).kind == ALL &&
                            !(
                                    getToken(2).kind == PERIOD ||
                                    getToken(2).kind == DOUBLE_COLON
                            )) {
      jj_consume_token(ALL);
                {if (true) return false;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="selectList">selectList</A>
 */
  final public ResultColumnList selectList() throws ParseException, StandardException {
        ResultColumn    allResultColumn;
        ResultColumnList        resultColumns = (ResultColumnList) nodeFactory.getNode(
                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                        getContextManager());
    switch (jj_nt.kind) {
    case ASTERISK:
      jj_consume_token(ASTERISK);
                allResultColumn = (ResultColumn) nodeFactory.getNode(
                                                                                C_NodeTypes.ALL_RESULT_COLUMN,
                                                                                null,
                                                                                getContextManager());
                /* Add the new AllResultColumn to the end of the list */
                resultColumns.addResultColumn(allResultColumn);
                {if (true) return resultColumns;}
      break;
    default:
      jj_la1[90] = jj_gen;
      if (jj_2_17(1)) {
        selectColumnList(resultColumns);
                {if (true) return resultColumns;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void selectColumnList(ResultColumnList resultColumns) throws ParseException, StandardException {
    selectSublist(resultColumns);
    label_9:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[91] = jj_gen;
        break label_9;
      }
      jj_consume_token(COMMA);
      selectSublist(resultColumns);
    }
  }

/*
 * <A NAME="selectSublist">selectSublist</A>
 */
  final public void selectSublist(ResultColumnList resultColumns) throws ParseException, StandardException {
        ResultColumn    resultColumn;
        ResultColumn    allResultColumn;
        TableName       tableName;
    if (getToken(2).kind == PERIOD &&
                            (
                                    getToken(3).kind == ASTERISK ||
                                    (getToken(4).kind == PERIOD && getToken(5).kind == ASTERISK)
                            )) {
      tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
      jj_consume_token(PERIOD);
      jj_consume_token(ASTERISK);
                allResultColumn = (ResultColumn) nodeFactory.getNode(
                                                                                C_NodeTypes.ALL_RESULT_COLUMN,
                                                                                tableName,
                                                                                getContextManager());
                /* Add the new AllResultColumn to the end of the list */
                resultColumns.addResultColumn(allResultColumn);
    } else if (jj_2_18(1)) {
      resultColumn = derivedColumn(resultColumns);
                /* Add the new ResultColumn to the end of the list */
                resultColumns.addResultColumn(resultColumn);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="derivedColumn">derivedColumn</A>
 */
  final public ResultColumn derivedColumn(ResultColumnList resultColumns) throws ParseException, StandardException {
        ValueNode       columnExpression;
        String          columnName = null;
    //true to additiveExpression ensures that for the derived columns, we will not allow boolean values inside (), 
            //eg (2 > 1) should be disallowed in the select clause
            columnExpression = additiveExpression(null, 0, true);
    switch (jj_nt.kind) {
    case AS:
    case BINARY:
    case COALESCE:
    case COUNT:
    case D:
    case MODULE:
    case T:
    case TS:
    case VALUE:
    case VARBINARY:
    case ABS:
    case ABSVAL:
    case ACTION:
    case ALWAYS:
    case BLOB:
    case C:
    case CALLED:
    case CLOB:
    case COBOL:
    case COMMITTED:
    case CONCAT:
    case CONTAINS:
    case DATA:
    case DATE:
    case DAY:
    case DYNAMIC:
    case FORTRAN:
    case GENERATED:
    case IDENTITY_VAL_LOCAL:
    case INCREMENT:
    case INITIAL:
    case INTERVAL:
    case LANGUAGE:
    case LARGE:
    case LENGTH:
    case LEVEL:
    case LOCKS:
    case LOCKSIZE:
    case LOGGED:
    case MOD:
    case MODIFIES:
    case MODIFY:
    case MONTH:
    case _MORE:
    case MUMPS:
    case NAME:
    case NCLOB:
    case NULLABLE:
    case NUMBER:
    case OBJECT:
    case PASCAL:
    case PLI:
    case PRECISION:
    case RELEASE:
    case REPEATABLE:
    case RESTART:
    case RETURNS:
    case ROW:
    case SAVEPOINT:
    case SCALE:
    case SERIALIZABLE:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case START:
    case STATEMENT:
    case SYNONYM:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TRUNCATE:
    case TYPE:
    case UNCOMMITTED:
    case USAGE:
    case WHEN:
    case CURDATE:
    case CURTIME:
    case DATABASE:
    case LONG:
    case AFTER:
    case BEFORE:
    case CLASS:
    case COMPRESS:
    case CONTENT:
    case CS:
    case DB2SQL:
    case DIRTY:
    case DOCUMENT:
    case EACH:
    case EMPTY:
    case EXCLUSIVE:
    case FN:
    case INDEX:
    case JAVA:
    case LCASE:
    case LOCATE:
    case LOCK:
    case MESSAGE_LOCALE:
    case METHOD:
    case MODE:
    case NEW:
    case NEW_TABLE:
    case OJ:
    case OFF:
    case OLD:
    case OLD_TABLE:
    case PARAMETER:
    case PASSING:
    case PROPERTIES:
    case READS:
    case REF:
    case REFERENCING:
    case RENAME:
    case RESET:
    case RESULT:
    case RETAIN:
    case RETURNING:
    case RR:
    case RS:
    case SEQUENCE:
    case SEQUENTIAL:
    case SETS:
    case SHARE:
    case SQLID:
    case SPECIFIC:
    case SQRT:
    case STABILITY:
    case STRIP:
    case STYLE:
    case TRIGGER:
    case UCASE:
    case UR:
    case WHITESPACE:
    case IDENTIFIER:
    case DELIMITED_IDENTIFIER:
      columnName = asClause();
      break;
    default:
      jj_la1[92] = jj_gen;
      ;
    }
                /*
		** If there is no AS clause, and the expression is a simple
		** column, use the name of the column as the result column
		** name.
		*/
                if ((columnName == null) && (columnExpression instanceof ColumnReference))
                {
                        columnName = ((ColumnReference) columnExpression).columnName;
                }

                {if (true) return (ResultColumn) nodeFactory.getNode(
                                                C_NodeTypes.RESULT_COLUMN,
                                                columnName,
                                                columnExpression,
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="asClause">asClause</A>
 */
  final public String asClause() throws ParseException, StandardException {
        String  columnName;
    switch (jj_nt.kind) {
    case AS:
      jj_consume_token(AS);
      break;
    default:
      jj_la1[93] = jj_gen;
      ;
    }
    columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                {if (true) return columnName;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="valueExpression">valueExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode valueExpression(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode       leftOperand;
    leftOperand = orExpression(null, inSelectClause);
    label_10:
    while (true) {
      switch (jj_nt.kind) {
      case OR:
        ;
        break;
      default:
        jj_la1[94] = jj_gen;
        break label_10;
      }
      jj_consume_token(OR);
      leftOperand = orExpression(leftOperand, inSelectClause);
    }
                {if (true) return leftOperand;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="orExpression">orExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode orExpression(ValueNode farLeftOperand, boolean inSelectClause) throws ParseException, StandardException {
        ValueNode       leftOperand;
    leftOperand = andExpression(null, inSelectClause);
    label_11:
    while (true) {
      switch (jj_nt.kind) {
      case AND:
        ;
        break;
      default:
        jj_la1[95] = jj_gen;
        break label_11;
      }
      jj_consume_token(AND);
      leftOperand = andExpression(leftOperand, inSelectClause);
    }
                if (farLeftOperand == null)
                {
                        {if (true) return leftOperand;}
                }
                else
                {
                        {if (true) return (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.OR_NODE,
                                                                                farLeftOperand,
                                                                                leftOperand,
                                                                                getContextManager());}
                }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="andExpression">andExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode andExpression(ValueNode farLeftOperand, boolean inSelectClause) throws ParseException, StandardException {
        Token           tok = null;
        ValueNode       test;
    if (getToken(1).kind == NOT && !(getToken(2).kind == PERIOD ||
                            getToken(2).kind == DOUBLE_COLON)) {
      tok = jj_consume_token(NOT);
    } else {
      ;
    }
    test = isSearchCondition(inSelectClause);
                /* Put the NOT on top of test */
                if (tok != null)
                {
                        test = (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.NOT_NODE,
                                                                        test,
                                                                        getContextManager());
                }

                if (farLeftOperand != null)
                {
                        test = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.AND_NODE,
                                                                                farLeftOperand,
                                                                                test,
                                                                                getContextManager());
                }
                {if (true) return test;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="isSearchCondition">isSearchCondition</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode isSearchCondition(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode       result;
        ValueNode       booleanPrimary;
        Token           isToken = null;
        Token           notToken = null;
        Token           truthValue = null;
    booleanPrimary = booleanPrimary(inSelectClause);
    switch (jj_nt.kind) {
    case IS:
      isToken = jj_consume_token(IS);
      switch (jj_nt.kind) {
      case NOT:
        notToken = jj_consume_token(NOT);
        break;
      default:
        jj_la1[96] = jj_gen;
        ;
      }
      jj_consume_token(NULL);
      break;
    default:
      jj_la1[97] = jj_gen;
      ;
    }
                if ( isToken != null )
                {
                                result = (ValueNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.IS_NULL_NODE,
                                                                                        booleanPrimary,
                                                                                        getContextManager());

                                /* Put the NOT on top of the tree */
                                if (notToken != null)
                                {
                                        result = (ValueNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.NOT_NODE,
                                                                                        result,
                                                                                        getContextManager());
                                }
                }
                else { result = booleanPrimary; }

                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="booleanPrimary">booleanPrimary</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode booleanPrimary(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode       primary;
        ValueNode       searchCondition;
    primary = predicate(inSelectClause);
                {if (true) return  primary;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="predicate">predicate</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode predicate(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode       value;
    if (jj_2_19(1)) {
      value = additiveExpression(null, 0, inSelectClause);
    } else {
      switch (jj_nt.kind) {
      case EXISTS:
        value = existsExpression();
        break;
      default:
        jj_la1[98] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_12:
    while (true) {
      if (remainingPredicateFollows()) {
        ;
      } else {
        break label_12;
      }
      value = remainingPredicate(value, inSelectClause);
    }
                {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="remainingPredicates">remainingPredicates</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode remainingPredicate(ValueNode value, boolean inSelectClause) throws ParseException, StandardException {
        Token tok = null;
    switch (jj_nt.kind) {
    case LESS_THAN_OPERATOR:
    case LESS_THAN_OR_EQUALS_OPERATOR:
    case EQUALS_OPERATOR:
    case NOT_EQUALS_OPERATOR:
    case NOT_EQUALS_OPERATOR2:
    case GREATER_THAN_OPERATOR:
    case GREATER_THAN_OR_EQUALS_OPERATOR:
      value = remainingNonNegatablePredicate(value, inSelectClause);
                {if (true) return value;}
      break;
    case BETWEEN:
    case IN:
    case LIKE:
    case NOT:
      switch (jj_nt.kind) {
      case NOT:
        tok = jj_consume_token(NOT);
        break;
      default:
        jj_la1[99] = jj_gen;
        ;
      }
      value = remainingNegatablePredicate(value, inSelectClause);
                /* Put the NOT on top of the tree */
                if (tok != null)
                {
                        value = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.NOT_NODE,
                                                                                value,
                                                                                getContextManager());
                }

                {if (true) return value;}
      break;
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="remainingNonNegatablePredicate">remainingNonNegatablePredicate</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode remainingNonNegatablePredicate(ValueNode leftOperand, boolean inSelectClause) throws ParseException, StandardException {
        int                     operator;
        String          javaClassName;
        Token           tok = null;
        ValueNode       tree = null;
        ValueNode       likePattern;
        ValueNode       betweenLeft;
        ValueNode       betweenRight;
    operator = compOp();
    if ((getToken(1).kind == ALL || getToken(1).kind == ANY ||
                            getToken(1).kind == SOME) && getToken(2).kind == LEFT_PAREN) {
      operator = quantifier(operator);
      jj_consume_token(LEFT_PAREN);
      leftOperand = tableSubquery(operator, leftOperand);
      jj_consume_token(RIGHT_PAREN);
    } else if (jj_2_20(1)) {
      leftOperand = additiveExpression(leftOperand, operator, inSelectClause);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return leftOperand;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="remainingNegatablePredicate">remainingNegatablePredicate</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode remainingNegatablePredicate(ValueNode leftOperand, boolean inSelectClause) throws ParseException, StandardException {
        ValueNode       tree = null;
        ValueNode       likePattern;
        ValueNode       betweenLeft;
        ValueNode       betweenRight;
        ValueNode       escapeValue = null;
    switch (jj_nt.kind) {
    case IN:
      jj_consume_token(IN);
      tree = inPredicateValue(leftOperand);
                {if (true) return tree;}
      break;
    case LIKE:
      jj_consume_token(LIKE);
      likePattern = additiveExpression(null, 0, inSelectClause);
      switch (jj_nt.kind) {
      case ESCAPE:
      case LEFT_BRACE:
        switch (jj_nt.kind) {
        case ESCAPE:
          jj_consume_token(ESCAPE);
          escapeValue = additiveExpression(null, 0, inSelectClause);
          break;
        case LEFT_BRACE:
          jj_consume_token(LEFT_BRACE);
          jj_consume_token(ESCAPE);
          escapeValue = additiveExpression(null, 0, inSelectClause);
          jj_consume_token(RIGHT_BRACE);
          break;
        default:
          jj_la1[101] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[102] = jj_gen;
        ;
      }
                tree = (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.LIKE_OPERATOR_NODE,
                                                                leftOperand,
                                                                likePattern,
                                                                escapeValue,
                                                                getContextManager());

                {if (true) return tree;}
      break;
    case BETWEEN:
      jj_consume_token(BETWEEN);
      betweenLeft = additiveExpression(null, 0, inSelectClause);
      jj_consume_token(AND);
      betweenRight = additiveExpression(null, 0, inSelectClause);
                ValueNodeList betweenList = (ValueNodeList) nodeFactory.getNode(
                                                                                                        C_NodeTypes.VALUE_NODE_LIST,
                                                                                                        getContextManager());
                betweenList.addElement(betweenLeft);
                betweenList.addElement(betweenRight);
                tree = (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.BETWEEN_OPERATOR_NODE,
                                                                leftOperand,
                                                                betweenList,
                                                                getContextManager());

                {if (true) return tree;}
      break;
    default:
      jj_la1[103] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="compOp">compOp</A>
 */
  final public int compOp() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case EQUALS_OPERATOR:
      jj_consume_token(EQUALS_OPERATOR);
                {if (true) return BinaryOperatorNode.EQ;}
      break;
    case NOT_EQUALS_OPERATOR:
      jj_consume_token(NOT_EQUALS_OPERATOR);
                {if (true) return BinaryOperatorNode.NE;}
      break;
    case NOT_EQUALS_OPERATOR2:
      jj_consume_token(NOT_EQUALS_OPERATOR2);
                {if (true) return BinaryOperatorNode.NE;}
      break;
    case LESS_THAN_OPERATOR:
      jj_consume_token(LESS_THAN_OPERATOR);
                {if (true) return BinaryOperatorNode.LT;}
      break;
    case GREATER_THAN_OPERATOR:
      jj_consume_token(GREATER_THAN_OPERATOR);
                {if (true) return BinaryOperatorNode.GT;}
      break;
    case LESS_THAN_OR_EQUALS_OPERATOR:
      jj_consume_token(LESS_THAN_OR_EQUALS_OPERATOR);
                {if (true) return BinaryOperatorNode.LE;}
      break;
    case GREATER_THAN_OR_EQUALS_OPERATOR:
      jj_consume_token(GREATER_THAN_OR_EQUALS_OPERATOR);
                {if (true) return BinaryOperatorNode.GE;}
      break;
    default:
      jj_la1[104] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="additiveExpression">additiveExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode additiveExpression(ValueNode farLeftOperand, int compOp, boolean inSelectClause) throws ParseException, StandardException {
        ValueNode       leftOperand;
        int                     operator;
        int                     nodeType;
    leftOperand = multiplicativeExpression(null, 0, inSelectClause);
    label_13:
    while (true) {
      switch (jj_nt.kind) {
      case PLUS_SIGN:
      case MINUS_SIGN:
        ;
        break;
      default:
        jj_la1[105] = jj_gen;
        break label_13;
      }
      operator = additiveOperator();
      leftOperand = multiplicativeExpression(leftOperand, operator, inSelectClause);
    }
                if (farLeftOperand == null)
                        {if (true) return leftOperand;}

                switch (compOp)
                {
                  case BinaryOperatorNode.EQ:
                        nodeType = C_NodeTypes.BINARY_EQUALS_OPERATOR_NODE;
                        break;

                  case BinaryOperatorNode.NE:
                        nodeType = C_NodeTypes.BINARY_NOT_EQUALS_OPERATOR_NODE;
                        break;

                  case BinaryOperatorNode.LT:
                        nodeType = C_NodeTypes.BINARY_LESS_THAN_OPERATOR_NODE;
                        break;

                  case BinaryOperatorNode.GT:
                        nodeType = C_NodeTypes.BINARY_GREATER_THAN_OPERATOR_NODE;
                        break;

                  case BinaryOperatorNode.LE:
                        nodeType = C_NodeTypes.BINARY_LESS_EQUALS_OPERATOR_NODE;
                        break;

                  case BinaryOperatorNode.GE:
                        nodeType = C_NodeTypes.BINARY_GREATER_EQUALS_OPERATOR_NODE;
                        break;

                  default:
                        if (SanityManager.DEBUG)
                        SanityManager.THROWASSERT("Unknown comparison operator " + compOp);
                        nodeType = 0;
                        break;
                }

                {if (true) return (ValueNode) nodeFactory.getNode(
                                                        nodeType,
                                                        farLeftOperand,
                                                        leftOperand,
                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="additiveOperator">additiveOperator</A>
 */
  final public int additiveOperator() throws ParseException, StandardException {
        Token tok;
    switch (jj_nt.kind) {
    case PLUS_SIGN:
      tok = jj_consume_token(PLUS_SIGN);
                {if (true) return BinaryOperatorNode.PLUS;}
      break;
    case MINUS_SIGN:
      tok = jj_consume_token(MINUS_SIGN);
                {if (true) return BinaryOperatorNode.MINUS;}
      break;
    default:
      jj_la1[106] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="multiplicativeExpression">multiplicativeExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode multiplicativeExpression(ValueNode farLeftOperand, int additiveOperator, boolean inSelectClause) throws ParseException, StandardException {
        ValueNode       leftOperand;
        int                     multOp;
    leftOperand = unaryExpression(null, 0, inSelectClause);
    label_14:
    while (true) {
      switch (jj_nt.kind) {
      case ASTERISK:
      case SOLIDUS:
      case CONCATENATION_OPERATOR:
        ;
        break;
      default:
        jj_la1[107] = jj_gen;
        break label_14;
      }
      multOp = multiplicativeOperator();
      leftOperand = unaryExpression(leftOperand, multOp, inSelectClause);
    }
                if (farLeftOperand == null)
                        {if (true) return leftOperand;}

                switch (additiveOperator)
                {
                  case BinaryOperatorNode.PLUS:
                        {if (true) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.BINARY_PLUS_OPERATOR_NODE,
                                                                        farLeftOperand,
                                                                        leftOperand,
                                                                        getContextManager()
                                                                        );}

                  case BinaryOperatorNode.MINUS:
                        {if (true) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.BINARY_MINUS_OPERATOR_NODE,
                                                                        farLeftOperand,
                                                                        leftOperand,
                                                                        getContextManager()
                                                                        );}

                  default:
                        if (SanityManager.DEBUG)
                        SanityManager.THROWASSERT(
                                        "Unexpected operator value of " + additiveOperator);
                        {if (true) return null;}
                }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="multiplicativeOperator">multiplicativeOperator</A>
 */
  final public int multiplicativeOperator() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case ASTERISK:
      jj_consume_token(ASTERISK);
                {if (true) return BinaryOperatorNode.TIMES;}
      break;
    case SOLIDUS:
      jj_consume_token(SOLIDUS);
                {if (true) return BinaryOperatorNode.DIVIDE;}
      break;
    case CONCATENATION_OPERATOR:
      jj_consume_token(CONCATENATION_OPERATOR);
                {if (true) return BinaryOperatorNode.CONCATENATE;}
      break;
    default:
      jj_la1[108] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="unaryExpression">unaryExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode unaryExpression(ValueNode farLeftOperand, int multiplicativeOperator, boolean inSelectClause) throws ParseException, StandardException {
        ValueNode       value;
        String          sign = null;
        int                     tokKind1;
        int                     tokKind2;
    if (( (tokKind1 = getToken(1).kind) == PLUS_SIGN ||
                                               tokKind1 == MINUS_SIGN )
                                            &&
                                            ( (tokKind2 = getToken(2).kind) != EXACT_NUMERIC &&
                                               tokKind2 != APPROXIMATE_NUMERIC)) {
      sign = sign();
    } else {
      ;
    }
    value = primaryExpression(inSelectClause);
                if ("-".equals(sign))
                {
                        value = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.UNARY_MINUS_OPERATOR_NODE,
                                                                                value,
                                                                                getContextManager());
                }
                else if ("+".equals(sign))
                {
                        value = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.UNARY_PLUS_OPERATOR_NODE,
                                                                                value,
                                                                                getContextManager());
                }
                else if (SanityManager.DEBUG)
                {
                        if (sign != null)
                        {
                                SanityManager.THROWASSERT("Unknown unary operator '"
                                                                                        + sign
                                                                                        + "'");
                        }
                }

                {if (true) return multOp(farLeftOperand, value, multiplicativeOperator);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="sign">sign</A>
 */
  final public String sign() throws ParseException {
        Token   s;
    switch (jj_nt.kind) {
    case PLUS_SIGN:
      s = jj_consume_token(PLUS_SIGN);
                {if (true) return s.image;}
      break;
    case MINUS_SIGN:
      s = jj_consume_token(MINUS_SIGN);
                {if (true) return s.image;}
      break;
    default:
      jj_la1[109] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="primaryExpressionXX">primaryExpressionXX</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode primaryExpressionXX(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode       value;
    value = primary(inSelectClause);
    label_15:
    while (true) {
      if (jj_2_21(1)) {
        ;
      } else {
        break label_15;
      }
      value = nonStaticMethodCallOrFieldAccess(value);
    }
                {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public ValueNode nonStaticMethodCallOrFieldAccess(ValueNode receiver) throws ParseException, StandardException {
        ValueNode value;
    value = nonStaticMethodInvocation(receiver);
                {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nonStaticMethodInvocation">nonStaticMethodInvocation</A>
 */
  final public ValueNode nonStaticMethodInvocation(ValueNode receiver) throws ParseException, StandardException {
        Vector                                  parameterList = new Vector();
        MethodCallNode                  methodNode;
        ParameterNode                   parameterNode;
    if (getToken(3).kind == LEFT_PAREN) {
      switch (jj_nt.kind) {
      case FIELD_REFERENCE:
        jj_consume_token(FIELD_REFERENCE);
        break;
      case PERIOD:
        jj_consume_token(PERIOD);
        break;
      default:
        jj_la1[110] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      methodNode = methodName(receiver);
      methodCallParameterList(parameterList);
                /*
		** ? parameters are not allowed for the receiver --
		** unless the receiver is standing in for a named parameter,
		** whose type is therefore known.
		*/
                if (receiver instanceof ParameterNode)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_PARAMETER_RECEIVER,
                                                                                                methodNode.getMethodName());}
                }

                methodNode.addParms(parameterList);

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                methodNode,
                                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case PERIOD:
        jj_consume_token(PERIOD);
        methodNode = methodName(receiver);
                /*
		** ? parameters are not allowed for the receiver --
		** unless the receiver is standing in for a named parameter,
		** whose type is therefore known.
		*/
                if (receiver instanceof ParameterNode)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_PARAMETER_RECEIVER,
                                                                                                methodNode.getMethodName());}
                }

                methodNode.addParms(parameterList);

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                methodNode,
                                                                getContextManager());}
        break;
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="methodName">methodName</A>
 */
  final public MethodCallNode methodName(ValueNode receiver) throws ParseException, StandardException {
        String  methodName;
    /*
    	** NOTE: allowing a delimited identifier as a method name is necessary,
    	** because Java is case-sensitive.  But this also allows identifiers that
    	** do not match Java syntax.  This will probably not cause a problem
    	** in later phases, like binding and code generation.
    	*/
            methodName = caseSensitiveIdentifierPlusReservedWords();
                {if (true) return (MethodCallNode) nodeFactory.getNode(
                                                                                C_NodeTypes.NON_STATIC_METHOD_CALL_NODE,
                                                                                methodName,
                                                                                receiver,
                                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="staticMethodName">staticMethodName</A>
 */
  final public MethodCallNode staticMethodName(String javaClassName) throws ParseException, StandardException {
        String  methodName;
    /*
    	** NOTE: allowing a delimited identifier as a method name is necessary,
    	** because Java is case-sensitive.  But this also allows identifiers that
    	** do not match Java syntax.  This will probably not cause a problem
    	** in later phases, like binding and code generation.
    	*/
            methodName = caseSensitiveIdentifierPlusReservedWords();
                {if (true) return (MethodCallNode) nodeFactory.getNode(
                                                                C_NodeTypes.STATIC_METHOD_CALL_NODE,
                                                                methodName,
                                                                javaClassName,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="methodParameter">methodParameter</A>
 */
  final public void methodParameter(Vector parameterList) throws ParseException, StandardException {
        ValueNode       parameter;
    if (jj_2_22(1)) {
      parameter = additiveExpression(null,0, false);
                parameterList.addElement(parameter);
    } else {
      switch (jj_nt.kind) {
      case NULL:
        parameter = nullSpecification();
                parameterList.addElement(parameter);
        break;
      default:
        jj_la1[112] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * <A NAME="primary">primary</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode primary(boolean inSelectClause) throws ParseException, StandardException {
        String          javaClassName;
        ValueNode       value;
    if (javaClassFollows()) {
      value = staticClassReference();
                {if (true) return value;}
    } else if (jj_2_23(1)) {
      value = valueExpressionPrimary(inSelectClause);
                {if (true) return value;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="staticClassReference">staticClassReference</A>
 */
  final public ValueNode staticClassReference() throws ParseException, StandardException {
        String          javaClassName;
        ValueNode value;
    javaClassName = javaClass();
    jj_consume_token(DOUBLE_COLON);
    value = staticClassReferenceType(javaClassName);
                {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="staticClassReferenceType">staticClassReferenceType</A>
 */
  final public ValueNode staticClassReferenceType(String javaClassName) throws ParseException, StandardException {
        ValueNode value;
    if ((getToken(2).kind == LEFT_PAREN)) {
      value = staticMethodInvocation(javaClassName);
                {if (true) return value;}
    } else {
      switch (jj_nt.kind) {
      case ADD:
      case ALL:
      case ALLOCATE:
      case ALTER:
      case AND:
      case ANY:
      case ARE:
      case AS:
      case ASC:
      case ASSERTION:
      case AT:
      case AUTHORIZATION:
      case AVG:
      case BEGIN:
      case BETWEEN:
      case BINARY:
      case BIT:
      case BOTH:
      case BY:
      case CASCADE:
      case CASCADED:
      case CASE:
      case CAST:
      case CHAR:
      case CHARACTER:
      case CHECK:
      case CLOSE:
      case COALESCE:
      case COLLATE:
      case COLLATION:
      case COLUMN:
      case COMMIT:
      case CONNECT:
      case CONNECTION:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTINUE:
      case CONVERT:
      case CORRESPONDING:
      case COUNT:
      case CREATE:
      case CURRENT:
      case CURRENT_DATE:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case D:
      case DEALLOCATE:
      case DEC:
      case DECIMAL:
      case DECLARE:
      case _DEFAULT:
      case DEFERRABLE:
      case DEFERRED:
      case DELETE:
      case DESC:
      case DESCRIBE:
      case DIAGNOSTICS:
      case DISCONNECT:
      case DISTINCT:
      case DOUBLE:
      case DROP:
      case ELSE:
      case END:
      case ENDEXEC:
      case ESCAPE:
      case EXCEPT:
      case EXCEPTION:
      case EXEC:
      case EXECUTE:
      case EXISTS:
      case EXTERNAL:
      case FALSE:
      case FETCH:
      case FIRST:
      case FLOAT:
      case FOR:
      case FOREIGN:
      case FOUND:
      case FROM:
      case FULL:
      case FUNCTION:
      case GET:
      case GLOBAL:
      case GO:
      case GOTO:
      case GRANT:
      case GROUP:
      case HAVING:
      case HOUR:
      case IDENTITY:
      case IMMEDIATE:
      case IN:
      case INDICATOR:
      case INITIALLY:
      case INNER:
      case INPUT:
      case INSENSITIVE:
      case INSERT:
      case INT:
      case INTEGER:
      case INTERSECT:
      case INTO:
      case IS:
      case ISOLATION:
      case JOIN:
      case KEY:
      case LAST:
      case LEADING:
      case LEFT:
      case LIKE:
      case LOWER:
      case MATCH:
      case MAX:
      case MIN:
      case MINUTE:
      case MODULE:
      case NATIONAL:
      case NATURAL:
      case NCHAR:
      case NEXT:
      case NO:
      case NOT:
      case NULL:
      case NULLIF:
      case NUMERIC:
      case OF:
      case ON:
      case ONLY:
      case OPEN:
      case OPTION:
      case OR:
      case ORDER:
      case OUTER:
      case OUTPUT:
      case OVERLAPS:
      case PAD:
      case PARTIAL:
      case PREPARE:
      case PRESERVE:
      case PRIMARY:
      case PRIOR:
      case PRIVILEGES:
      case PROCEDURE:
      case PUBLIC:
      case READ:
      case REAL:
      case REFERENCES:
      case RELATIVE:
      case RESTRICT:
      case REVOKE:
      case RIGHT:
      case ROLLBACK:
      case ROWS:
      case SCHEMA:
      case SCROLL:
      case SECOND:
      case SELECT:
      case SESSION_USER:
      case SET:
      case SMALLINT:
      case SOME:
      case SPACE:
      case SQL:
      case SQLCODE:
      case SQLERROR:
      case SQLSTATE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case T:
      case TABLE:
      case TEMPORARY:
      case TIMEZONE_HOUR:
      case TIMEZONE_MINUTE:
      case TO:
      case TRANSACTION:
      case TRANSLATE:
      case TRANSLATION:
      case TRAILING:
      case TRIM:
      case TRUE:
      case TS:
      case UNION:
      case UNIQUE:
      case UNKNOWN:
      case UPDATE:
      case UPPER:
      case USER:
      case USING:
      case VALUE:
      case VALUES:
      case VARBINARY:
      case VARCHAR:
      case VARYING:
      case VIEW:
      case WHENEVER:
      case WHERE:
      case WITH:
      case WORK:
      case WRITE:
      case YEAR:
      case ABS:
      case ABSVAL:
      case ACTION:
      case ALWAYS:
      case BLOB:
      case C:
      case CALLED:
      case CLOB:
      case COBOL:
      case COMMITTED:
      case CONCAT:
      case CONTAINS:
      case DATA:
      case DATE:
      case DAY:
      case DYNAMIC:
      case FORTRAN:
      case GENERATED:
      case IDENTITY_VAL_LOCAL:
      case INCREMENT:
      case INITIAL:
      case INOUT:
      case INTERVAL:
      case LANGUAGE:
      case LARGE:
      case LENGTH:
      case LEVEL:
      case LOCKS:
      case LOCKSIZE:
      case LOGGED:
      case MOD:
      case MODIFIES:
      case MODIFY:
      case MONTH:
      case _MORE:
      case MUMPS:
      case NAME:
      case NCLOB:
      case NULLABLE:
      case NUMBER:
      case OBJECT:
      case PASCAL:
      case PLI:
      case PRECISION:
      case RELEASE:
      case REPEATABLE:
      case RESTART:
      case RETURNS:
      case ROW:
      case SAVEPOINT:
      case SCALE:
      case SERIALIZABLE:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case START:
      case STATEMENT:
      case SYNONYM:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TRUNCATE:
      case TYPE:
      case UNCOMMITTED:
      case USAGE:
      case WHEN:
      case BOOLEAN:
      case CALL:
      case CURDATE:
      case CURTIME:
      case DATABASE:
      case GET_CURRENT_CONNECTION:
      case EXPLAIN:
      case LONGINT:
      case LONG:
      case LTRIM:
      case RTRIM:
      case SUBSTR:
      case XML:
      case XMLEXISTS:
      case XMLPARSE:
      case XMLQUERY:
      case XMLSERIALIZE:
      case AFTER:
      case BEFORE:
      case CLASS:
      case COMPRESS:
      case CONTENT:
      case CS:
      case DB2SQL:
      case DIRTY:
      case DOCUMENT:
      case EACH:
      case EMPTY:
      case EXCLUSIVE:
      case FN:
      case INDEX:
      case JAVA:
      case LCASE:
      case LOCATE:
      case LOCK:
      case MESSAGE_LOCALE:
      case METHOD:
      case MODE:
      case NEW:
      case NEW_TABLE:
      case NVARCHAR:
      case OJ:
      case OFF:
      case OLD:
      case OLD_TABLE:
      case OUT:
      case PARAMETER:
      case PASSING:
      case PROPERTIES:
      case READS:
      case REF:
      case REFERENCING:
      case RENAME:
      case RESET:
      case RESULT:
      case RETAIN:
      case RETURNING:
      case RR:
      case RS:
      case SEQUENCE:
      case SEQUENTIAL:
      case SETS:
      case SHARE:
      case SQLID:
      case SPECIFIC:
      case SQRT:
      case STABILITY:
      case STRIP:
      case STYLE:
      case TRIGGER:
      case UCASE:
      case UR:
      case WHITESPACE:
      case IDENTIFIER:
      case DELIMITED_IDENTIFIER:
        value = staticClassFieldReference(javaClassName);
                {if (true) return value;}
        break;
      default:
        jj_la1[113] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="staticClassFieldReference">staticClassFieldReference</A>
 */
  final public ValueNode staticClassFieldReference(String javaClassName) throws ParseException, StandardException {
        String          fieldName = null;
    fieldName = caseSensitiveIdentifierPlusReservedWords();
                {if (true) return  (ValueNode) nodeFactory.getNode(
                                        C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                        nodeFactory.getNode(
                                                                C_NodeTypes.STATIC_CLASS_FIELD_REFERENCE_NODE,
                                                                javaClassName,
                                                                fieldName,
                                                                nextToLastTokenDelimitedIdentifier,
                                                                getContextManager()),
                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nonSecondDatetimeField">nonSecondDatetimeField</A>
 */
  final public int nonSecondDatetimeField() throws ParseException {
    switch (jj_nt.kind) {
    case YEAR:
      jj_consume_token(YEAR);
                {if (true) return DateTimeDataValue.YEAR_FIELD;}
      break;
    case MONTH:
      jj_consume_token(MONTH);
                {if (true) return DateTimeDataValue.MONTH_FIELD;}
      break;
    case DAY:
      jj_consume_token(DAY);
                {if (true) return DateTimeDataValue.DAY_FIELD;}
      break;
    case HOUR:
      jj_consume_token(HOUR);
                {if (true) return DateTimeDataValue.HOUR_FIELD;}
      break;
    case MINUTE:
      jj_consume_token(MINUTE);
                {if (true) return DateTimeDataValue.MINUTE_FIELD;}
      break;
    default:
      jj_la1[114] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode escapedValueFunction() throws ParseException, StandardException {
        ValueNode       value;
    ValueNode   str1;
    ValueNode   str2;
        ValueNode       startPosition;
    ValueNode   length = null;
    if (jj_2_24(1)) {
      value = miscBuiltinsCore(true /* is JDBC escape */);
                {if (true) return value;}
    } else {
      switch (jj_nt.kind) {
      case SUBSTRING:
        jj_consume_token(SUBSTRING);
        jj_consume_token(LEFT_PAREN);
        value = additiveExpression(null, 0, false);
        jj_consume_token(COMMA);
        startPosition = additiveExpression(null, 0, false);
        switch (jj_nt.kind) {
        case COMMA:
          jj_consume_token(COMMA);
          length = additiveExpression(null, 0, false);
          break;
        default:
          jj_la1[115] = jj_gen;
          ;
        }
        jj_consume_token(RIGHT_PAREN);
        {if (true) return getSubstringNode(value, startPosition, length, Boolean.FALSE);}
        break;
      case CURDATE:
        jj_consume_token(CURDATE);
        jj_consume_token(LEFT_PAREN);
        jj_consume_token(RIGHT_PAREN);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                                ReuseFactory.getInteger(
                                                                        CurrentDatetimeOperatorNode.CURRENT_DATE),
                                                                getContextManager());}
        break;
      case CURTIME:
        jj_consume_token(CURTIME);
        jj_consume_token(LEFT_PAREN);
        jj_consume_token(RIGHT_PAREN);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                        ReuseFactory.getInteger(
                                                                CurrentDatetimeOperatorNode.CURRENT_TIME),
                                                        getContextManager());}
        break;
      case CONCAT:
        jj_consume_token(CONCAT);
        jj_consume_token(LEFT_PAREN);
        str1 = additiveExpression(null,0, false);
        jj_consume_token(COMMA);
        str2 = additiveExpression(null,0, false);
        jj_consume_token(RIGHT_PAREN);
        {if (true) return (ValueNode) nodeFactory.getNode(
                            C_NodeTypes.CONCATENATION_OPERATOR_NODE,
                            str1,
                            str2,
                            getContextManager());}
        break;
      case CURRENT_USER:
      case SESSION_USER:
      case USER:
        /* Method versions of USER special registers
        	 * are ODBC remnants.  Only supported
        	 * when escaped.
        	 */
                value = userNode();
        jj_consume_token(LEFT_PAREN);
        jj_consume_token(RIGHT_PAREN);
                {if (true) return value;}
        break;
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
        value = timestampArithmeticFuncion();
        {if (true) return value;}
        break;
      default:
        jj_la1[116] = jj_gen;
        if (getEscapedSYSFUN(getToken(1).image) != null) {
          value = escapedSYSFUNFunction();
        {if (true) return value;}
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="numericValueFunction">numericValueFunction</A>
 */
  final public ValueNode escapedSYSFUNFunction() throws ParseException, StandardException {
    Vector      parameterList = new Vector();
        Token tok;
    tok = jj_consume_token(IDENTIFIER);
    methodCallParameterList(parameterList);
            String sysFunName = getEscapedSYSFUN(tok.image);

            TableName functionName = (TableName) nodeFactory.getNode(
                                                                C_NodeTypes.TABLE_NAME,
                                                                SchemaDescriptor.IBM_SYSTEM_FUN_SCHEMA_NAME,
                                                                sysFunName,
                                                                new Integer(0),
                                                                new Integer(0),
                                                                getContextManager());

                MethodCallNode methodNode = (MethodCallNode) nodeFactory.getNode(
                                                                C_NodeTypes.STATIC_METHOD_CALL_NODE,
                                                                functionName,
                                                                null,
                                                                getContextManager());

                methodNode.addParms(parameterList);

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                methodNode,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="timestampArithmeticFuncion">timestampArithmeticFuncion</A>
 */
  final public ValueNode timestampArithmeticFuncion() throws ParseException, StandardException {
    ValueNode intervalType;
    ValueNode tstamp1;
    ValueNode tstamp2;
    ValueNode count;
    switch (jj_nt.kind) {
    case TIMESTAMPADD:
      jj_consume_token(TIMESTAMPADD);
      jj_consume_token(LEFT_PAREN);
      intervalType = jdbcIntervalType();
      jj_consume_token(COMMA);
      count = additiveExpression(null,0,false);
      jj_consume_token(COMMA);
      tstamp1 = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
        {if (true) return (ValueNode) nodeFactory.getNode( C_NodeTypes.TIMESTAMP_ADD_FN_NODE,
                                                tstamp1,
                                                intervalType,
                                                count,
                                                ReuseFactory.getInteger( TernaryOperatorNode.TIMESTAMPADD),
                                                null,
                                                getContextManager());}
      break;
    case TIMESTAMPDIFF:
      jj_consume_token(TIMESTAMPDIFF);
      jj_consume_token(LEFT_PAREN);
      intervalType = jdbcIntervalType();
      jj_consume_token(COMMA);
      tstamp1 = additiveExpression(null,0,false);
      jj_consume_token(COMMA);
      tstamp2 = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
        {if (true) return (ValueNode) nodeFactory.getNode( C_NodeTypes.TIMESTAMP_DIFF_FN_NODE,
                                                tstamp2,
                                                intervalType,
                                                tstamp1,
                                                ReuseFactory.getInteger( TernaryOperatorNode.TIMESTAMPDIFF),
                                                null,
                                                getContextManager());}
      break;
    default:
      jj_la1[117] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="jdbcIntervalType">jdbcIntervalType</A>
 */
  final public ValueNode jdbcIntervalType() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case SQL_TSI_FRAC_SECOND:
      jj_consume_token(SQL_TSI_FRAC_SECOND);
        {if (true) return getJdbcIntervalNode( DateTimeDataValue.FRAC_SECOND_INTERVAL);}
      break;
    case SQL_TSI_SECOND:
      jj_consume_token(SQL_TSI_SECOND);
        {if (true) return getJdbcIntervalNode( DateTimeDataValue.SECOND_INTERVAL);}
      break;
    case SQL_TSI_MINUTE:
      jj_consume_token(SQL_TSI_MINUTE);
        {if (true) return getJdbcIntervalNode( DateTimeDataValue.MINUTE_INTERVAL);}
      break;
    case SQL_TSI_HOUR:
      jj_consume_token(SQL_TSI_HOUR);
        {if (true) return getJdbcIntervalNode( DateTimeDataValue.HOUR_INTERVAL);}
      break;
    case SQL_TSI_DAY:
      jj_consume_token(SQL_TSI_DAY);
        {if (true) return getJdbcIntervalNode( DateTimeDataValue.DAY_INTERVAL);}
      break;
    case SQL_TSI_WEEK:
      jj_consume_token(SQL_TSI_WEEK);
        {if (true) return getJdbcIntervalNode( DateTimeDataValue.WEEK_INTERVAL);}
      break;
    case SQL_TSI_MONTH:
      jj_consume_token(SQL_TSI_MONTH);
        {if (true) return getJdbcIntervalNode( DateTimeDataValue.MONTH_INTERVAL);}
      break;
    case SQL_TSI_QUARTER:
      jj_consume_token(SQL_TSI_QUARTER);
        {if (true) return getJdbcIntervalNode( DateTimeDataValue.QUARTER_INTERVAL);}
      break;
    case SQL_TSI_YEAR:
      jj_consume_token(SQL_TSI_YEAR);
        {if (true) return getJdbcIntervalNode( DateTimeDataValue.YEAR_INTERVAL);}
      break;
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="numericValueFunction">numericValueFunction</A>
 */
  final public ValueNode numericValueFunction() throws ParseException, StandardException {
        ValueNode       value;
        int                     field;
    switch (jj_nt.kind) {
    case ABS:
      jj_consume_token(ABS);
      value = absFunction();
                {if (true) return value;}
      break;
    case ABSVAL:
      jj_consume_token(ABSVAL);
      value = absFunction();
                {if (true) return value;}
      break;
    case SQRT:
      jj_consume_token(SQRT);
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
        {if (true) return (ValueNode)nodeFactory.getNode(
                C_NodeTypes.SQRT_OPERATOR_NODE,
                value,
                getContextManager());}
      break;
    case MOD:
      jj_consume_token(MOD);
      value = modFunction();
                {if (true) return value;}
      break;
    case IDENTITY_VAL_LOCAL:
      jj_consume_token(IDENTITY_VAL_LOCAL);
      jj_consume_token(LEFT_PAREN);
      jj_consume_token(RIGHT_PAREN);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.IDENTITY_VAL_NODE,
                                                getContextManager());}
      break;
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="coalesceFunction">coalesceFunction</A>
 */
  final public ValueNode coalesceFunction(String coalesceOrValue) throws ParseException, StandardException {
    ValueNodeList expressionList = (ValueNodeList) nodeFactory.getNode(
        C_NodeTypes.VALUE_NODE_LIST,
        getContextManager());
    jj_consume_token(LEFT_PAREN);
    coalesceExpression(expressionList);
    label_16:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[120] = jj_gen;
        break label_16;
      }
      jj_consume_token(COMMA);
      coalesceExpression(expressionList);
    }
    jj_consume_token(RIGHT_PAREN);
        {if (true) return (ValueNode)nodeFactory.getNode(
                C_NodeTypes.COALESCE_FUNCTION_NODE,
                coalesceOrValue,
                expressionList,
                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="coalesceExpression">coalesceExpression</A>
 */
  final public void coalesceExpression(ValueNodeList expressionList) throws ParseException, StandardException {
        ValueNode       expression;
    expression = additiveExpression(null,0,false);
                expressionList.addElement(expression);
  }

/*
 * <A NAME="absFunction">absFunction</A>
 */
  final public ValueNode absFunction() throws ParseException, StandardException {
    ValueNode value;
    jj_consume_token(LEFT_PAREN);
    value = additiveExpression(null,0, false);
    jj_consume_token(RIGHT_PAREN);
        {if (true) return (ValueNode)nodeFactory.getNode(
                C_NodeTypes.ABSOLUTE_OPERATOR_NODE,
                value,
                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="modFunction">modFunction</A>
 */
  final public ValueNode modFunction() throws ParseException, StandardException {
    ValueNode int1;
        ValueNode int2;
    jj_consume_token(LEFT_PAREN);
    int1 = additiveExpression(null,0,false);
    jj_consume_token(COMMA);
    int2 = additiveExpression(null,0,false);
    jj_consume_token(RIGHT_PAREN);
        {if (true) return (ValueNode)nodeFactory.getNode(
                C_NodeTypes.MOD_OPERATOR_NODE,
                int1, int2,
                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="datetimeField">datetimeField</A>
 */
  final public int datetimeField() throws ParseException {
        int field;
    switch (jj_nt.kind) {
    case HOUR:
    case MINUTE:
    case YEAR:
    case DAY:
    case MONTH:
      field = nonSecondDatetimeField();
                {if (true) return field;}
      break;
    case SECOND:
      jj_consume_token(SECOND);
                {if (true) return DateTimeDataValue.SECOND_FIELD;}
      break;
    default:
      jj_la1[121] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode characterValueFunction() throws ParseException, StandardException {
        ValueNode       value = null;
        ValueNode       str1;
        ValueNode       str2;
        Token           upperTok = null;
        Token           lowerTok = null;
        ValueNode       startPosition;
    ValueNode   length = null;
    switch (jj_nt.kind) {
    case SUBSTR:
      jj_consume_token(SUBSTR);
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0,false);
      jj_consume_token(COMMA);
      startPosition = additiveExpression(null,0,false);
      switch (jj_nt.kind) {
      case COMMA:
        jj_consume_token(COMMA);
        length = additiveExpression(null,0,false);
        break;
      default:
        jj_la1[122] = jj_gen;
        ;
      }
      jj_consume_token(RIGHT_PAREN);
        {if (true) return getSubstringNode( value, startPosition, length, Boolean.FALSE );}
      break;
    case LOWER:
    case UPPER:
      switch (jj_nt.kind) {
      case UPPER:
        upperTok = jj_consume_token(UPPER);
        break;
      case LOWER:
        lowerTok = jj_consume_token(LOWER);
        break;
      default:
        jj_la1[123] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                        C_NodeTypes.SIMPLE_STRING_OPERATOR_NODE,
                                        value,
                                        (upperTok != null) ? "upper" : "lower",
                                        getContextManager());}
      break;
    case LCASE:
    case UCASE:
      switch (jj_nt.kind) {
      case UCASE:
        upperTok = jj_consume_token(UCASE);
        break;
      case LCASE:
        lowerTok = jj_consume_token(LCASE);
        break;
      default:
        jj_la1[124] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                        C_NodeTypes.SIMPLE_STRING_OPERATOR_NODE,
                                        value,
                                        (upperTok != null) ? "upper" : "lower",
                                        getContextManager());}
      break;
    case TRIM:
    case LTRIM:
    case RTRIM:
      value = trimFunction();
                {if (true) return value;}
      break;
    case LOCATE:
      jj_consume_token(LOCATE);
      jj_consume_token(LEFT_PAREN);
      str1 = additiveExpression(null,0,false);
      jj_consume_token(COMMA);
      str2 = additiveExpression(null,0,false);
      switch (jj_nt.kind) {
      case COMMA:
        jj_consume_token(COMMA);
        value = additiveExpression(null,0,false);
        break;
      default:
        jj_la1[125] = jj_gen;
        ;
      }
      jj_consume_token(RIGHT_PAREN);
                // if start is missing, start is equal to 1
        {if (true) return (ValueNode) nodeFactory.getNode(
                            C_NodeTypes.LOCATE_FUNCTION_NODE,
                            str1,
                            str2,
                            (value == null) ? getNodeFactory().getNode(
                                        C_NodeTypes.INT_CONSTANT_NODE,
                                        ReuseFactory.getInteger(1),
                                        getContextManager() )
                                                                                        : value,
                            ReuseFactory.getInteger(TernaryOperatorNode.LOCATE),
                            null,
                            getContextManager());}
      break;
    default:
      jj_la1[126] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode trimFunction() throws ParseException, StandardException {
        ValueNode       source;
        Integer         trimType;
        ValueNode       ansiTrimNode;
    switch (jj_nt.kind) {
    case LTRIM:
    case RTRIM:
      trimType = trimType();
      jj_consume_token(LEFT_PAREN);
      source = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
                {if (true) return getTrimOperatorNode(trimType, null, source, null);}
      break;
    case TRIM:
      jj_consume_token(TRIM);
      ansiTrimNode = ansiTrim();
                {if (true) return ansiTrimNode;}
      break;
    default:
      jj_la1[127] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode ansiTrim() throws ParseException, StandardException {
    Integer trimSpec = ReuseFactory.getInteger(StringDataValue.BOTH);
    ValueNode trimChar = null;
    ValueNode trimSource = null;
    if (ansiTrimSpecFollows()) {
      jj_consume_token(LEFT_PAREN);
      trimSpec = ansiTrimSpec();
      if (jj_2_25(2147483647)) {
        jj_consume_token(FROM);
        trimSource = additiveExpression(null,0,false);
        jj_consume_token(RIGHT_PAREN);
             {if (true) return getTrimOperatorNode(trimSpec, trimChar, trimSource, null);}
      } else if (jj_2_26(1)) {
        // LEADING <char> FROM <source>
                 trimChar = additiveExpression(null,0,false);
        jj_consume_token(FROM);
        trimSource = additiveExpression(null,0,false);
        jj_consume_token(RIGHT_PAREN);
             {if (true) return getTrimOperatorNode(trimSpec, trimChar, trimSource, null);}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else if (!ansiTrimSpecFollows()) {
      jj_consume_token(LEFT_PAREN);
      trimChar = additiveExpression(null,0,false);
      switch (jj_nt.kind) {
      case FROM:
        jj_consume_token(FROM);
        trimSource = additiveExpression(null,0,false);
        jj_consume_token(RIGHT_PAREN);
            {if (true) return getTrimOperatorNode(trimSpec, trimChar, trimSource, null);}
        break;
      case RIGHT_PAREN:
        jj_consume_token(RIGHT_PAREN);
            // expr was trim(e)-- we assigned e to trimChar but it is really the trimSource
            {if (true) return getTrimOperatorNode(trimSpec, null, trimChar, null);}
        break;
      default:
        jj_la1[128] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Integer ansiTrimSpec() throws ParseException {
    switch (jj_nt.kind) {
    case TRAILING:
      jj_consume_token(TRAILING);
                {if (true) return ReuseFactory.getInteger(StringDataValue.TRAILING);}
      break;
    case LEADING:
      jj_consume_token(LEADING);
                {if (true) return ReuseFactory.getInteger(StringDataValue.LEADING);}
      break;
    case BOTH:
      jj_consume_token(BOTH);
                {if (true) return ReuseFactory.getInteger(StringDataValue.BOTH);}
      break;
    default:
      jj_la1[129] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Integer trimType() throws ParseException {
    switch (jj_nt.kind) {
    case RTRIM:
      jj_consume_token(RTRIM);
                {if (true) return ReuseFactory.getInteger(StringDataValue.TRAILING);}
      break;
    case LTRIM:
      jj_consume_token(LTRIM);
                {if (true) return ReuseFactory.getInteger(StringDataValue.LEADING);}
      break;
    default:
      jj_la1[130] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="valueExpressionPrimary">valueExpressionPrimary</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode valueExpressionPrimary(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode       value;
        int                     tokKind;
    if (escapedValueFunctionFollows()) {
      jj_consume_token(LEFT_BRACE);
      jj_consume_token(FN);
      value = escapedValueFunction();
      jj_consume_token(RIGHT_BRACE);
                {if (true) return value;}
    } else if (getToken(2).kind == SCHEMA || getToken(2).kind == SQLID) {
      jj_consume_token(CURRENT);
      switch (jj_nt.kind) {
      case SCHEMA:
        jj_consume_token(SCHEMA);
        break;
      case SQLID:
        jj_consume_token(SQLID);
        break;
      default:
        jj_la1[131] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.CURRENT_SCHEMA_NODE,
                                                getContextManager());}
    } else if (getToken(2).kind == ISOLATION) {
      jj_consume_token(CURRENT);
      jj_consume_token(ISOLATION);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.CURRENT_ISOLATION_NODE,
                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case CASE:
      case CURRENT_USER:
      case FALSE:
      case NULLIF:
      case SESSION_USER:
      case TRUE:
      case USER:
      case LEFT_BRACE:
      case PLUS_SIGN:
      case MINUS_SIGN:
      case QUESTION_MARK:
      case EXACT_NUMERIC:
      case STRING:
      case HEX_STRING:
      case APPROXIMATE_NUMERIC:
        /* Omitted "case_expression" */
                value = valueSpecification();
                {if (true) return value;}
        break;
      default:
        jj_la1[132] = jj_gen;
        if (newInvocationFollows(1)) {
          value = newInvocation();
                {if (true) return value;}
        } else if (aggregateFollows()) {
          value = aggregateNode();
                {if (true) return value;}
        } else if (miscBuiltinFollows()) {
          value = miscBuiltins();
                {if (true) return value;}
        } else {
          switch (jj_nt.kind) {
          case BINARY:
          case COALESCE:
          case COUNT:
          case D:
          case MODULE:
          case T:
          case TS:
          case VALUE:
          case VARBINARY:
          case ABS:
          case ABSVAL:
          case ACTION:
          case ALWAYS:
          case BLOB:
          case C:
          case CALLED:
          case CLOB:
          case COBOL:
          case COMMITTED:
          case CONCAT:
          case CONTAINS:
          case DATA:
          case DATE:
          case DAY:
          case DYNAMIC:
          case FORTRAN:
          case GENERATED:
          case IDENTITY_VAL_LOCAL:
          case INCREMENT:
          case INITIAL:
          case INTERVAL:
          case LANGUAGE:
          case LARGE:
          case LENGTH:
          case LEVEL:
          case LOCKS:
          case LOCKSIZE:
          case LOGGED:
          case MOD:
          case MODIFIES:
          case MODIFY:
          case MONTH:
          case _MORE:
          case MUMPS:
          case NAME:
          case NCLOB:
          case NULLABLE:
          case NUMBER:
          case OBJECT:
          case PASCAL:
          case PLI:
          case PRECISION:
          case RELEASE:
          case REPEATABLE:
          case RESTART:
          case RETURNS:
          case ROW:
          case SAVEPOINT:
          case SCALE:
          case SERIALIZABLE:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case START:
          case STATEMENT:
          case SYNONYM:
          case THEN:
          case TIME:
          case TIMESTAMP:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case TRUNCATE:
          case TYPE:
          case UNCOMMITTED:
          case USAGE:
          case WHEN:
          case CURDATE:
          case CURTIME:
          case DATABASE:
          case LONG:
          case AFTER:
          case BEFORE:
          case CLASS:
          case COMPRESS:
          case CONTENT:
          case CS:
          case DB2SQL:
          case DIRTY:
          case DOCUMENT:
          case EACH:
          case EMPTY:
          case EXCLUSIVE:
          case FN:
          case INDEX:
          case JAVA:
          case LCASE:
          case LOCATE:
          case LOCK:
          case MESSAGE_LOCALE:
          case METHOD:
          case MODE:
          case NEW:
          case NEW_TABLE:
          case OJ:
          case OFF:
          case OLD:
          case OLD_TABLE:
          case PARAMETER:
          case PASSING:
          case PROPERTIES:
          case READS:
          case REF:
          case REFERENCING:
          case RENAME:
          case RESET:
          case RESULT:
          case RETAIN:
          case RETURNING:
          case RR:
          case RS:
          case SEQUENCE:
          case SEQUENTIAL:
          case SETS:
          case SHARE:
          case SQLID:
          case SPECIFIC:
          case SQRT:
          case STABILITY:
          case STRIP:
          case STYLE:
          case TRIGGER:
          case UCASE:
          case UR:
          case WHITESPACE:
          case IDENTIFIER:
          case DELIMITED_IDENTIFIER:
            value = columnReference();
                {if (true) return value;}
            break;
          case LEFT_PAREN:
            jj_consume_token(LEFT_PAREN);
            if (getToken(1).kind == SELECT || getToken(1).kind == VALUES) {
              value = subquery(SubqueryNode.EXPRESSION_SUBQUERY, null);
            } else if (inSelectClause) {
              value = additiveExpression(null,0, inSelectClause);
            } else if (jj_2_27(1)) {
              //following will happen if we are not coming here for select/values clause
                              value = valueExpression(inSelectClause);
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
            jj_consume_token(RIGHT_PAREN);
                {if (true) return value;}
            break;
          case CAST:
            value = castSpecification();
                {if (true) return value;}
            break;
          default:
            jj_la1[133] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="miscBuiltins">miscBuiltins</A>
 */
  final public ValueNode miscBuiltins() throws ParseException, StandardException {
        ValueNode value;
    if (( (getToken(1).kind == GET_CURRENT_CONNECTION ||
                    getToken(1).kind == ABS ||
                    getToken(1).kind == ABSVAL ||
                    getToken(1).kind == SQRT ||
                    getToken(1).kind == MOD ||
                    getToken(1).kind == COALESCE ||
                    getToken(1).kind == VALUE ||
                    getToken(1).kind == IDENTITY_VAL_LOCAL ||
                    getToken(1).kind == SUBSTRING ||
                    getToken(1).kind == SUBSTR ||
                    getToken(1).kind == UPPER ||
                    getToken(1).kind == LOWER ||
                    getToken(1).kind == UCASE ||
                    getToken(1).kind == LCASE ||
                    getToken(1).kind == LTRIM ||
                    getToken(1).kind == RTRIM ||
                    getToken(1).kind == TRIM ||
                    getToken(1).kind == DATE ||
                    getToken(1).kind == TIME ||
                    getToken(1).kind == TIMESTAMP ||
                    getToken(1).kind == DOUBLE ||
                    getToken(1).kind == CHAR ||
                    getToken(1).kind == VARCHAR ||
                    getToken(1).kind == INTEGER ||
                    getToken(1).kind == INT ||
                    getToken(1).kind == SMALLINT ||
                    getToken(1).kind == LONGINT ||
                    getToken(1).kind == YEAR ||
                    getToken(1).kind == MONTH ||
                    getToken(1).kind == DAY ||
                    getToken(1).kind == HOUR ||
                    getToken(1).kind == MINUTE ||
                    getToken(1).kind == SECOND ||
                    getToken(1).kind == LENGTH ||
                    getToken(1).kind == LOCATE ||
                    getToken(1).kind == XMLPARSE ||
                    getToken(1).kind == XMLSERIALIZE ||
                    getToken(1).kind == XMLEXISTS ||
                    getToken(1).kind == XMLQUERY ) &&
                  getToken(2).kind == LEFT_PAREN
                  )) {
      /* miscBuiltins() are composed of the core
      	 * system, string and numeric functions,
      	 * date functions
      	 * and static method calls.
      	 */
              value = miscBuiltinsCore(false /* not JDBC escape */);
                {if (true) return value;}
    } else if (jj_2_28(1)) {
      value = datetimeValueFunction();
                {if (true) return value;}
    } else {
      switch (jj_nt.kind) {
      case BINARY:
      case COALESCE:
      case COUNT:
      case D:
      case MODULE:
      case T:
      case TS:
      case VALUE:
      case VARBINARY:
      case ABS:
      case ABSVAL:
      case ACTION:
      case ALWAYS:
      case BLOB:
      case C:
      case CALLED:
      case CLOB:
      case COBOL:
      case COMMITTED:
      case CONCAT:
      case CONTAINS:
      case DATA:
      case DATE:
      case DAY:
      case DYNAMIC:
      case FORTRAN:
      case GENERATED:
      case IDENTITY_VAL_LOCAL:
      case INCREMENT:
      case INITIAL:
      case INTERVAL:
      case LANGUAGE:
      case LARGE:
      case LENGTH:
      case LEVEL:
      case LOCKS:
      case LOCKSIZE:
      case LOGGED:
      case MOD:
      case MODIFIES:
      case MODIFY:
      case MONTH:
      case _MORE:
      case MUMPS:
      case NAME:
      case NCLOB:
      case NULLABLE:
      case NUMBER:
      case OBJECT:
      case PASCAL:
      case PLI:
      case PRECISION:
      case RELEASE:
      case REPEATABLE:
      case RESTART:
      case RETURNS:
      case ROW:
      case SAVEPOINT:
      case SCALE:
      case SERIALIZABLE:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case START:
      case STATEMENT:
      case SYNONYM:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TRUNCATE:
      case TYPE:
      case UNCOMMITTED:
      case USAGE:
      case WHEN:
      case CURDATE:
      case CURTIME:
      case DATABASE:
      case LONG:
      case AFTER:
      case BEFORE:
      case CLASS:
      case COMPRESS:
      case CONTENT:
      case CS:
      case DB2SQL:
      case DIRTY:
      case DOCUMENT:
      case EACH:
      case EMPTY:
      case EXCLUSIVE:
      case FN:
      case INDEX:
      case JAVA:
      case LCASE:
      case LOCATE:
      case LOCK:
      case MESSAGE_LOCALE:
      case METHOD:
      case MODE:
      case NEW:
      case NEW_TABLE:
      case OJ:
      case OFF:
      case OLD:
      case OLD_TABLE:
      case PARAMETER:
      case PASSING:
      case PROPERTIES:
      case READS:
      case REF:
      case REFERENCING:
      case RENAME:
      case RESET:
      case RESULT:
      case RETAIN:
      case RETURNING:
      case RR:
      case RS:
      case SEQUENCE:
      case SEQUENTIAL:
      case SETS:
      case SHARE:
      case SQLID:
      case SPECIFIC:
      case SQRT:
      case STABILITY:
      case STRIP:
      case STYLE:
      case TRIGGER:
      case UCASE:
      case UR:
      case WHITESPACE:
      case IDENTIFIER:
      case DELIMITED_IDENTIFIER:
        /* This is where we build a node for static method aliases */
                value = routineInvocation();
                {if (true) return value;}
        break;
      default:
        jj_la1[134] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode miscBuiltinsCore(boolean isJDBCEscape) throws ParseException, StandardException {
        ValueNode value;
    switch (jj_nt.kind) {
    case GET_CURRENT_CONNECTION:
      jj_consume_token(GET_CURRENT_CONNECTION);
      jj_consume_token(LEFT_PAREN);
      jj_consume_token(RIGHT_PAREN);
                checkInternalFeature("GETCURRENTCONNECTION()");
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                nodeFactory.getNode(
                                                                        C_NodeTypes.GET_CURRENT_CONNECTION_NODE,
                                                                        getContextManager()),
                                                                getContextManager());}
      break;
    case ABS:
    case ABSVAL:
    case IDENTITY_VAL_LOCAL:
    case MOD:
    case SQRT:
      value = numericValueFunction();
                {if (true) return value;}
      break;
    case LOWER:
    case TRIM:
    case UPPER:
    case LTRIM:
    case RTRIM:
    case SUBSTR:
    case LCASE:
    case LOCATE:
    case UCASE:
      value = characterValueFunction();
                {if (true) return value;}
      break;
    default:
      jj_la1[135] = jj_gen;
      if (jj_2_29(1)) {
        value = dataTypeScalarFunction();
                {if (true) return value;}
      } else {
        switch (jj_nt.kind) {
        case COALESCE:
          jj_consume_token(COALESCE);
          value = coalesceFunction("COALESCE");
                {if (true) return value;}
          break;
        case VALUE:
          jj_consume_token(VALUE);
          value = coalesceFunction("VALUE");
                {if (true) return value;}
          break;
        case LENGTH:
          jj_consume_token(LENGTH);
          jj_consume_token(LEFT_PAREN);
          value = additiveExpression(null,0, false);
          jj_consume_token(RIGHT_PAREN);
                ContextManager  localCM = getContextManager();
                if( isJDBCEscape)
                        {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.CHAR_LENGTH_OPERATOR_NODE,
                                                                getTrimOperatorNode(
                                                                        ReuseFactory.getInteger(StringDataValue.TRAILING),
                                                                        null,
                                                                        value,
                                                                        localCM),
                                                                localCM);}
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.DB2_LENGTH_OPERATOR_NODE,
                                                        value,
                                                        localCM);}
          break;
        case XMLEXISTS:
        case XMLPARSE:
        case XMLQUERY:
        case XMLSERIALIZE:
          value = xmlFunction();
                {if (true) return value;}
          break;
        default:
          jj_la1[136] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dataTypeScalarFunction">dataTypeScalarFunction</A>
 */
  final public ValueNode dataTypeScalarFunction() throws ParseException, StandardException {
        DataTypeDescriptor dts;
        ValueNode value;           //converted result
        ValueNode operand;
        int charType;
        int length = -1;
    switch (jj_nt.kind) {
    case HOUR:
    case MINUTE:
    case SECOND:
    case YEAR:
    case DATE:
    case DAY:
    case MONTH:
    case TIME:
    case TIMESTAMP:
      //Note: When you add a new data type function, in addition to adding it 
              // here, you need to add it to miscBuiltins()
              value = dateTimeScalarFunction();
                {if (true) return value;}
      break;
    default:
      jj_la1[138] = jj_gen;
      if (jj_2_30(1)) {
        dts = numericFunctionType();
        jj_consume_token(LEFT_PAREN);
        operand = additiveExpression(null,0, false);
        jj_consume_token(RIGHT_PAREN);
                        value = (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.CAST_NODE,
                                                                        operand,
                                                                        dts,
                                                                        getContextManager());
                        ((CastNode) value).setForDataTypeFunction(true);
                        ((CastNode) value).setForExternallyGeneratedCASTnode();

                        {if (true) return value;}
      } else {
        switch (jj_nt.kind) {
        case CHAR:
        case VARCHAR:
          charType = charOrVarchar();
          jj_consume_token(LEFT_PAREN);
          operand = additiveExpression(null,0, false);
          switch (jj_nt.kind) {
          case COMMA:
            jj_consume_token(COMMA);
            length = length();
            break;
          default:
            jj_la1[137] = jj_gen;
            ;
          }
          jj_consume_token(RIGHT_PAREN);
                // Always check db2 limits for this function. It's new
                checkTypeLimits(charType,length);
                value = (ValueNode) nodeFactory.getNode(
                                                                                                C_NodeTypes.CAST_NODE,
                                                                                                operand,
                                                                                                new Integer(charType),
                                                                                                new Integer(length),
                                                                                                getContextManager());

                ((CastNode) value).setForDataTypeFunction(true);
                ((CastNode) value).setForExternallyGeneratedCASTnode();
                {if (true) return value;}
          break;
        default:
          jj_la1[139] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlFunction">xmlFunction</A>
 *
 * This method parses the built-in functions used with
 * the XML datatype.
 *
 */
  final public ValueNode xmlFunction() throws ParseException, StandardException {
        ValueNode value;
        checkVersion(DataDictionary.DD_VERSION_DERBY_10_1, "XML");

        // We only allow XML operations if the classpath has all
        // of the required external classes (namley, JAXP and Xalan).
        org.apache.derby.iapi.types.XML.checkXMLRequirements();
    switch (jj_nt.kind) {
    case XMLPARSE:
      jj_consume_token(XMLPARSE);
      jj_consume_token(LEFT_PAREN);
      xmlDocOrContent();
      value = xmlParseValue();
      jj_consume_token(RIGHT_PAREN);
                {if (true) return value;}
      break;
    case XMLSERIALIZE:
      jj_consume_token(XMLSERIALIZE);
      jj_consume_token(LEFT_PAREN);
      value = xmlSerializeValue();
      jj_consume_token(RIGHT_PAREN);
                {if (true) return value;}
      break;
    case XMLEXISTS:
      jj_consume_token(XMLEXISTS);
      jj_consume_token(LEFT_PAREN);
      value = xmlQueryValue(true);
      jj_consume_token(RIGHT_PAREN);
                {if (true) return value;}
      break;
    case XMLQUERY:
      jj_consume_token(XMLQUERY);
      jj_consume_token(LEFT_PAREN);
      value = xmlQueryValue(false);
      jj_consume_token(RIGHT_PAREN);
                {if (true) return value;}
      break;
    default:
      jj_la1[140] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlParseValue">xmlParseValue</A>
 *
 * Syntax is as follows:
 *
 *     XMLPARSE( DOCUMENT <string-value-expression> PRESERVE WHITESPACE )
 *
 * The result of this operation will be an XML value, which can either
 * be used transiently or else can be stored persistently in a table that
 * has an XML column.  For example:
 *
 * ij> CREATE TABLE x_table (id INT, xdoc XML);
 * 0 rows inserted/updated/deleted
 * ij> INSERT INTO x_table VALUES (1, XMLPARSE(DOCUMENT '<simp> doc </simp>'
 * PRESERVE WHITESPACE));
 * 1 row inserted/updated/deleted
 *
 * We only allow XML documents (as opposed to XML content) to be
 * parsed into XML values.  Note that we require the "PRESERVE WHITESPACE"
 * keyword to be explicit; this is because the SQL/XML (2003) spec says that
 * if no whitespace option is given, the default is "STRIP WHITESPACE", which
 * we don't support (yet).
 *
 * By the time we get to this method, the "DOCUMENT" keyword has already
 * been parsed.
 *
 */
  final public ValueNode xmlParseValue() throws ParseException, StandardException {
        ValueNode value;
        boolean wsOption;
    value = additiveExpression(null,0,false);
    wsOption = xmlPreserveWhitespace();
                {if (true) return (ValueNode) nodeFactory.getNode(
                                        C_NodeTypes.XML_PARSE_OPERATOR_NODE,
                                        value,
                                        ReuseFactory.getInteger(UnaryOperatorNode.XMLPARSE_OP),
                                        new Object[] {(wsOption ? Boolean.TRUE : Boolean.FALSE)},
                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlPreserveWhitespace">xmlPreserveWhitespace</A>
 *
 * For now, we only support the PRESERVE WHITESPACE option.
 *
 */
  final public boolean xmlPreserveWhitespace() throws ParseException, StandardException {
    if ((getToken(1).kind != STRIP) &&
                    (getToken(1).kind != PRESERVE)) {
                {if (true) throw StandardException.newException(
                        SQLState.LANG_XML_KEYWORD_MISSING, "PRESERVE WHITESPACE",
                        ReuseFactory.getInteger(getToken(1).beginLine),
                        ReuseFactory.getInteger(getToken(1).beginColumn));}
    } else {
      switch (jj_nt.kind) {
      case STRIP:
        jj_consume_token(STRIP);
        jj_consume_token(WHITESPACE);
          // don't preserve whitespace.
                {if (true) throw StandardException.newException(
                        SQLState.LANG_UNSUPPORTED_XML_FEATURE, "STRIP WHITESPACE");}
        break;
      case PRESERVE:
        jj_consume_token(PRESERVE);
        jj_consume_token(WHITESPACE);
          // must preserve whitespace.
                {if (true) return true;}
        break;
      default:
        jj_la1[141] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlSerializeValue">xmlSerializeValue</A>
 *
 * Syntax is as follows:
 *
 *   XMLSERIALIZE( <xml-value-expression> AS <string-data-type> )
 *
 * The result of this operation will be a string value with the type specified
 * by the user.  For example:
 *
 * ij> SELECT id, XMLSERIALIZE(xdoc AS varchar(30)) FROM x_table;
 * ID         |2
 * ------------------------------------------
 * 1          |<simp> doc </simp>
 *
 */
  final public ValueNode xmlSerializeValue() throws ParseException, StandardException {
        ValueNode value;
        DataTypeDescriptor targetType;
    value = additiveExpression(null,0,false);
    targetType = xmlSerializeTargetType();
                {if (true) return (ValueNode) nodeFactory.getNode(
                                        C_NodeTypes.XML_SERIALIZE_OPERATOR_NODE,
                                        value,
                                        ReuseFactory.getInteger(UnaryOperatorNode.XMLSERIALIZE_OP),
                                        new Object[] {targetType},
                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlSerializeTargetType">xmlSerializeTargetType</A>
 *
 * Parse the target type of an XMLSERIALIZE operation.
 *
 */
  final public DataTypeDescriptor xmlSerializeTargetType() throws ParseException, StandardException {
        DataTypeDescriptor targetType;
    if ((getToken(1).kind != AS)) {
                {if (true) throw StandardException.newException(
                        SQLState.LANG_XML_KEYWORD_MISSING, "AS",
                        ReuseFactory.getInteger(getToken(1).beginLine),
                        ReuseFactory.getInteger(getToken(1).beginColumn));}
    } else {
      switch (jj_nt.kind) {
      case AS:
        jj_consume_token(AS);
        targetType = dataTypeDDL();
                {if (true) return targetType;}
        break;
      default:
        jj_la1[142] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlQueryValue">xmlQueryValue</A>
 *
 * This method is used for parsing the XMLEXISTS and XMLQUERY operators
 * (which operator depends on the received boolean parameter).
 *
 * For XMLEXISTS, the syntax is as follows:
 *
 *   XMLEXISTS( <xpath-expression> PASSING BY REF <xml-value-expression> )
 *
 * The result of this operation will be a boolean true/false/unknown value:
 *   -- Unknown if either <xquery-expression> or <xml-value-expression> is null;
 *   -- True if evaluation of the given query expression against the
 *      given xml-value returns at least one node.
 *   -- False otherwise.
 *
 * For example:
 *
 * ij> SELECT id FROM x_table WHERE XMLEXISTS('/simple' PASSING BY REF xdoc);
 * ID
 * -----------
 * 1
 *
 * ====
 *
 * For XMLQUERY, the syntax is as follows:
 *
 *   XMLQUERY( <xquery-expression>
 *      PASSING BY REF <xml-value-expression>
 *      [ RETURNING SEQUENCE [ BY REF ] ]
 *      EMPTY ON EMPTY
 *   )
 *
 * The result of this operation will be an XMLDataValue.
 *
 * For example:
 *
 * ij> SELECT XMLSERIALIZE(
 *       XMLQUERY('/simple' PASSING BY REF xdoc EMPTY ON EMPTY) AS CHAR(100));
 * ID
 * -----------
 * <simp> doc </simp>
 *
 */
  final public ValueNode xmlQueryValue(boolean existsOnly) throws ParseException, StandardException {
        // The query expression (currently must be an expression
        // supported by Xalan--i.e. XPath only).
        ValueNode xqueryExpr = null;

        // Context item for the query; not required by SQL/XML spec,
        // but required by Derby for now.
        ValueNode xmlValue = null;

        // User-specified default passing mechanism.  Since Derby only
        // supports one type of passing mechanism--BY REF--this value
        // isn't currently used.
        short defaultPassingMech = -1;
    xqueryExpr = additiveExpression(null, 0, false);
    jj_consume_token(PASSING);
    defaultPassingMech = xmlPassingMechanism();
    xmlValue = xqVarList();
    if (!existsOnly) {
      if (jj_2_32(1)) {
        xqReturningClause();
        if (jj_2_31(1)) {
          xmlPassingMechanism();
        } else {
          ;
        }
      } else {
        ;
      }
      xqEmptyHandlingClause();

    } else if (existsOnly) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
                ValueNode vNode = (ValueNode) nodeFactory.getNode(
                        (existsOnly
                                ? C_NodeTypes.XML_EXISTS_OPERATOR_NODE
                                : C_NodeTypes.XML_QUERY_OPERATOR_NODE),
                        xqueryExpr,
                        xmlValue,
                        (existsOnly
                                ? ReuseFactory.getInteger(BinaryOperatorNode.XMLEXISTS_OP)
                                : ReuseFactory.getInteger(BinaryOperatorNode.XMLQUERY_OP)),
                        getContextManager());

                {if (true) return vNode;}
    throw new Error("Missing return statement in function");
  }

/**
 * <A NAME="xqVarList">xqVarList</A>
 *
 * Parse a list of XML query variables, which can include at most one
 * XML value to be used as the "context item" for the query.  If
 * such a context item was found, return that item; for all other
 * variable declarations we currently throw a "not supported" error
 * because Xalan doesn't allowing binding of variables.
 */
  final public ValueNode xqVarList() throws ParseException, StandardException {
        // Placeholder for the XML context item as we parse the
        // argument list.
        ValueNode [] xmlValue = new ValueNode [] { (ValueNode)null };
    xqVariable(xmlValue);
    label_17:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[143] = jj_gen;
        break label_17;
      }
      jj_consume_token(COMMA);
      xqVariable(xmlValue);
    }
                {if (true) return xmlValue[0];}
    throw new Error("Missing return statement in function");
  }

/**
 * <A NAME="xqVariable">xqVariable</A>
 *
 * Parse an XML query variable.  If the argument is an XML value
 * to be used as the "context item" for a query, then store the
 * value in the first slot of the received ValueNode array;
 * otherwise, throw a "not supported" errror (for now).
 */
  final public void xqVariable(ValueNode [] xmlVal) throws ParseException, StandardException {
        ValueNode curVal;
        String varName = null;
        short passingMech = -1;
    curVal = additiveExpression(null,0, false);
    if (getToken(1).kind == AS) {
      jj_consume_token(AS);
      varName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                        /* From XQuery 1.0: "The <identifier> I contained in XQV
			 * shall be an XML 1.1 NCName."  From XML 1.1:
			 *
			 *   [4] NCName ::= (Letter | '_') (NCNameChar)*
			 *   [5] NCNameChar ::= Letter | Digit | '.' | '-' | '_' |
			 *                    CombiningChar | Extender
			 *
			 * Since Derby's definition of an "identifier" is a subset
			 * of NCName, we just use Derby's definition.  This means
			 * that some valid NCNames won't be recognized by Derby--
			 * but since the ones we _do_ recognize are all still valid
			 * NCNames, we're not breaking any rules.
			 */

                        /* All of that said, since we use Xalan as the underlying
			 * query engine and Xalan doesn't support variable binding,
			 * there's no point in letting the user specify variables
			 * right now.  So we disallow it.  In the future we'll have
			 * to add logic here to store the variables and pass them
			 * to the correct operator for binding/execution.
			 */
                        {if (true) throw StandardException.newException(
                                SQLState.LANG_UNSUPPORTED_XML_FEATURE, "PASSING ... AS");}
    } else {
      ;
    }
    if (jj_2_33(1)) {
      passingMech = xmlPassingMechanism();
    } else {
      ;
    }
                        if (varName == null)
                        {
                                /* We get here if we just parsed an XML context item.
				 * That said, if we already have one (xmlVal[0] is not
				 * null) then we can't allow second one, per SQL/XML[2006]
				 * (6.17: Syntax Rules:5.b.i): "XMQ shall contain exactly
				 * one <XML query context item> XQCI."
				 */
                                if (xmlVal[0] != null)
                                {
                                        {if (true) throw StandardException.newException(
                                                SQLState.LANG_MULTIPLE_XML_CONTEXT_ITEMS);}
                                }

                                xmlVal[0] = curVal;

                                /* Note: It's possible that a passing mechanism was
				 * specified for the context item; if so its value is
				 * stored in passingMech.  However, we don't actually
			 	 * store that passing mechanism anywhere because we
				 * (currently) only support BY REF, so we know what
			 	 * it has to be.  If we add support for other passing
			 	 * mechanisms (namely, BY VALUE) in the future, we'll
			 	 * have to store the passing mechanism provided by
			 	 * the user and process it at compilation/execution
				 * time.
				 */
                        }

  }

/*
 * <A NAME="xmlPassingMechanism">xmlPassingMechanism</A>
 *
 * For now, we only support the BY REF option because
 * that gives us better performance (allows us to avoid
 * performing potentially deep copies of XML nodes).  This
 * means that if the same XML value is passed BY REF into
 * two different XML arguments for a single operator, then
 * every node in the first XML argument must have an
 * identical node in the second XML argument, and the
 * ids for both nodes must be the same.  That said,
 * since we don't support variable binding yet, this
 * becomes a non-issue because we can't pass XML values.
 * In the future, though, we may choose to support the
 * passing/binding of variables (the only reason we
 * don't now is because Xalan doesn't support it) and
 * if we do, BY REF should provide better performance
 * due to lack of deep copying.
 */
  final public short xmlPassingMechanism() throws ParseException, StandardException {
    if (getToken(2).kind == REF) {
      jj_consume_token(BY);
      jj_consume_token(REF);
          // pass the XML value by reference
                {if (true) return org.apache.derby.iapi.types.XML.XQ_PASS_BY_REF;}
    } else {
      switch (jj_nt.kind) {
      case BY:
        jj_consume_token(BY);
        jj_consume_token(VALUE);
          // pass a 'copy' of the XML value.
                {if (true) throw StandardException.newException(
                        SQLState.LANG_UNSUPPORTED_XML_FEATURE, "BY VALUE");}
        break;
      default:
        jj_la1[144] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xqReturningClause">xqReturningClause</A>
 *
 * For now we only support "RETURNING SEQUENCE".  The reason
 * is that this applies to the XMLQUERY operator and the
 * results of evaluating a query expression in Xalan against
 * an XML value can be an arbritary sequence of items--including
 * atomic values.  For simplicity we just return the values
 * as they are, without doing any further work.  SQL/XML[2006]
 * says that if we supported RETURNING CONTENT then we'd have
 * to construct an XQuery document from the results--but we don't
 * do that extra work for now, so we just say that we return
 * SEQUENCE.
 *
 * NOTE: This means that we may not be able to store the results
 * of an XMLQUERY operation into a Derby XML column.  Right now
 * an XML column can only hold valid DOCUMENT nodes, which we
 * we define as an XML value whose serialized form can be parsed
 * by a JAXP DocumentBuilder (because that's what Derby's XMLPARSE
 * operator uses and the result is always a Document node).
 * Internally this means that we can only store a sequence if it
 * contains exactly one org.w3c.dom.Node that is an instance of
 * org.w3c.dom.Document.  If the result of an XMLQUERY operation
 * does not fit this criteria then it will *not* be storable into
 * Derby XML columns.
 */
  final public short xqReturningClause() throws ParseException, StandardException {
    if (getToken(2).kind == SEQUENCE) {
      jj_consume_token(RETURNING);
      jj_consume_token(SEQUENCE);
          // XMLQUERY should return result as a sequence.
          // NOTE: since Derby XML columns only allow DOCUMENT(UNTYPED),
          // the result of an XMLQUERY operator that returns SEQUENCE
          // might not be storable into an XML column.
                {if (true) return org.apache.derby.iapi.types.XML.XQ_RETURN_SEQUENCE;}
    } else {
      switch (jj_nt.kind) {
      case RETURNING:
        jj_consume_token(RETURNING);
        jj_consume_token(CONTENT);
          // XMLQUERY should return 'content'.
                {if (true) throw StandardException.newException(
                        SQLState.LANG_UNSUPPORTED_XML_FEATURE, "RETURNING CONTENT");}
        break;
      default:
        jj_la1[145] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xqEmptyHandlingClause">xqEmptyHandlingClause</A>
 *
 * Defines what the behavior should be when an XMLQUERY operator
 * results in an empty sequence.  For now we just return the
 * empty sequence.
 */
  final public short xqEmptyHandlingClause() throws ParseException, StandardException {
    if (getToken(1).kind == EMPTY) {
      jj_consume_token(EMPTY);
      jj_consume_token(ON);
      jj_consume_token(EMPTY);
          // XMLQUERY should return an empty sequence when result of
          // the query is an empty sequence (i.e. when there are no
          // results).
                {if (true) return org.apache.derby.iapi.types.XML.XQ_EMPTY_ON_EMPTY;}
    } else {
      switch (jj_nt.kind) {
      case NULL:
        jj_consume_token(NULL);
        jj_consume_token(ON);
        jj_consume_token(EMPTY);
          // XMLQUERY should return a null XML value when result of
          // the query is an empty sequence (i.e. when there are no
          // results).
                {if (true) throw StandardException.newException(
                        SQLState.LANG_UNSUPPORTED_XML_FEATURE, "NULL ON EMPTY");}
        break;
      default:
        jj_la1[146] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="numericFunctionType">numericFunctionType</A>
 */
  final public DataTypeDescriptor numericFunctionType() throws ParseException, StandardException {
        DataTypeDescriptor dts;
    if (jj_2_34(1)) {
      dts = doubleType();
                {if (true) return dts;}
    } else {
      switch (jj_nt.kind) {
      case INT:
      case INTEGER:
      case SMALLINT:
      case LONGINT:
        dts = exactIntegerType();
                {if (true) return dts;}
        break;
      default:
        jj_la1[147] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dateTimeScalarFunction">dateTimeScalarFunction</A>
 */
  final public ValueNode dateTimeScalarFunction() throws ParseException, StandardException {
        ValueNode       value;
        ValueNode       timestampNode;
        int             field;
    switch (jj_nt.kind) {
    case TIME:
      jj_consume_token(TIME);
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0, false);
      jj_consume_token(RIGHT_PAREN);
                ValueNode castValue = (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CAST_NODE,
                                                        value,
                                                        DataTypeDescriptor.getBuiltInDataTypeDescriptor( Types.TIME),
                                                        getContextManager());
                ((CastNode) castValue).setForExternallyGeneratedCASTnode();
                {if (true) return castValue;}
      break;
    case DATE:
      jj_consume_token(DATE);
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0, false);
      jj_consume_token(RIGHT_PAREN);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.UNARY_DATE_TIMESTAMP_OPERATOR_NODE,
                                                        value,
                                                        DataTypeDescriptor.getBuiltInDataTypeDescriptor( Types.DATE),
                                                        getContextManager());}
      break;
    case TIMESTAMP:
      jj_consume_token(TIMESTAMP);
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0, false);
      timestampNode = timestampFunctionCompletion(value);
                {if (true) return timestampNode;}
      break;
    case HOUR:
    case MINUTE:
    case SECOND:
    case YEAR:
    case DAY:
    case MONTH:
      field = datetimeField();
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0, false);
      jj_consume_token(RIGHT_PAREN);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.EXTRACT_OPERATOR_NODE,
                                                                ReuseFactory.getInteger(field),
                                                                value,
                                                                getContextManager());}
      break;
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="timestampFunctionCompletion">timestampFunctionCompletion</A>
 */
  final public ValueNode timestampFunctionCompletion(ValueNode firstArg) throws ParseException, StandardException {
        ValueNode timeValue;
    switch (jj_nt.kind) {
    case RIGHT_PAREN:
      jj_consume_token(RIGHT_PAREN);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.UNARY_DATE_TIMESTAMP_OPERATOR_NODE,
                                                        firstArg,
                                                        DataTypeDescriptor.getBuiltInDataTypeDescriptor( Types.TIMESTAMP),
                                                        getContextManager());}
      break;
    case COMMA:
      jj_consume_token(COMMA);
      timeValue = additiveExpression(null,0, false);
      jj_consume_token(RIGHT_PAREN);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.TIMESTAMP_OPERATOR_NODE,
                                                        firstArg,
                                                        timeValue,
                                                        getContextManager());}
      break;
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="booleanLiteral">booleanLiteral</A>
 */
  final public Token booleanLiteral() throws ParseException {
        Token tok;
    switch (jj_nt.kind) {
    case TRUE:
      tok = jj_consume_token(TRUE);
                {if (true) return tok;}
      break;
    case FALSE:
      tok = jj_consume_token(FALSE);
                {if (true) return tok;}
      break;
    default:
      jj_la1[150] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="generalValueSpecification">generalValueSpecification</A>
 */
  final public ValueNode generalValueSpecification() throws ParseException, StandardException {
                ValueNode       parm;
    switch (jj_nt.kind) {
    case QUESTION_MARK:
      parm = dynamicParameterSpecification();
                {if (true) return parm;}
      break;
    case CURRENT_USER:
    case SESSION_USER:
    case USER:
      parm = userNode();
                {if (true) return parm;}
      break;
    default:
      jj_la1[151] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode userNode() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case USER:
      jj_consume_token(USER);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.USER_NODE,
                                                                getContextManager());}
      break;
    case CURRENT_USER:
      jj_consume_token(CURRENT_USER);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.CURRENT_USER_NODE,
                                                getContextManager());}
      break;
    case SESSION_USER:
      jj_consume_token(SESSION_USER);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.SESSION_USER_NODE,
                                                getContextManager());}
      break;
    default:
      jj_la1[152] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="newInvocation">newInvocation</A>
 */
  final public JavaToSQLValueNode newInvocation() throws ParseException, StandardException {
        QueryTreeNode   newNode;
        Vector  parameterList = new Vector();
        String  javaClassName;
    jj_consume_token(NEW);
    javaClassName = javaClassName();
    methodCallParameterList(parameterList);
                if (!javaClassName.startsWith("org.apache.derby.diag.") && !javaClassName.startsWith("org.apache.derby.catalog.") && !javaClassName.startsWith("com.ibm.db2j."))
                {
                        checkInternalFeature(javaClassName);
                }
                newNode =  nodeFactory.getNode(C_NodeTypes.NEW_INVOCATION_NODE,
                                                                           javaClassName,
                                                                           parameterList,
                                                                           lastTokenDelimitedIdentifier,
                                                                           getContextManager());

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if (true) return (JavaToSQLValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                newNode,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="vtiTableConstruct">vtiTableConstruct</A>
 *
 * Parse a TABLE() constructor that corresponds to an internal
 * VTI invocation.  For example:
 *
 *    TABLE ( <qualifiedName> (arg1, arg2, ...) )
 *
 * where <qualifiedName> is a table name that Derby will map internally
 * to a VTI (ex. "SYSCS_DIAG.SPACE_TABLE").  The list of arguments
 * will then be passed to the VTI when it is invoked (DERBY-2152).
 *
 * An example query where this might occur is as follows:
 *
 *   SELECT * FROM TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'T1')) x
 *
 * in which case SYSCS_DIAG.SPACE_TABLE will be mapped (internally)
 * to the "org.apache.derby.diag.SpaceTable" diagnostic VTI.  Thus
 * the equivalent call prior to DERBY-2152 would have been:
 *
 *   SELECT * FROM NEW org.apache.derby.diag.SpaceTable('APP', 'T1')) x
 *
 * Note that this latter syntax is still supported.
 */
  final public JavaToSQLValueNode vtiTableConstruct() throws ParseException, StandardException {
    QueryTreeNode newNode = null;
    Vector parameterList = new Vector();
    TableName vtiTableName = null;
    jj_consume_token(TABLE);
    jj_consume_token(LEFT_PAREN);
    vtiTableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    methodCallParameterList(parameterList);
    jj_consume_token(RIGHT_PAREN);
                /* The fact that we pass a NULL table descriptor to the
		 * following call is an indication that we are mapping to a
		 * VTI table function (i.e. one that accepts arguments).
		 * Since we have the table name we do not need to pass in a
		 * TableDescriptor--we'll just create one from the table
		 * name. See NewInvocationNode for more.
		 */
        newNode = nodeFactory.getNode(C_NodeTypes.NEW_INVOCATION_NODE,
                    vtiTableName,  // TableName
                    null,          // TableDescriptor
                    parameterList,
                    lastTokenDelimitedIdentifier,
                    getContextManager());

        /*
        ** Assume this is being returned to the SQL domain.  If it turns
        ** out that this is being returned to the Java domain, we will
        ** get rid of this node.
        */
        {if (true) return (JavaToSQLValueNode) nodeFactory.getNode(
                    C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                    newNode,
                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="staticMethodInvocation">staticMethodInvocation</A>
 */
  final public ValueNode staticMethodInvocation(String javaClassName) throws ParseException, StandardException {
        Vector  parameterList = new Vector();
        MethodCallNode  methodNode;
    methodNode = staticMethodName(javaClassName);
    methodCallParameterList(parameterList);
                methodNode.addParms(parameterList);

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                methodNode,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/**
 * <A NAME="methodCallParameterList">methodCallParameterList</A>
*/
  final public void methodCallParameterList(Vector parameterList) throws ParseException, StandardException {
    jj_consume_token(LEFT_PAREN);
    if (jj_2_35(1)) {
      methodParameter(parameterList);
      label_18:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[153] = jj_gen;
          break label_18;
        }
        jj_consume_token(COMMA);
        methodParameter(parameterList);
      }
    } else {
      ;
    }
    jj_consume_token(RIGHT_PAREN);
  }

/*
 * <A NAME="routineInvocation">routineInvocation</A>
 */
  final public ValueNode routineInvocation() throws ParseException, StandardException {
        Vector  parameterList = new Vector();
        TableName       routineName;
        MethodCallNode  methodNode;
    routineName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    methodCallParameterList(parameterList);
                methodNode = (MethodCallNode) nodeFactory.getNode(
                                                                C_NodeTypes.STATIC_METHOD_CALL_NODE,
                                                                routineName,
                                                                null,
                                                                getContextManager());

                methodNode.addParms(parameterList);

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                methodNode,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="javaClass">javaClass</A>
 */
  final public String javaClass() throws ParseException, StandardException {
        String javaClassName;
    javaClassName = javaClassName();
                {if (true) return javaClassName;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnMethodInvocation">columnMethodInvocation</A>
 */
  final public ValueNode columnMethodInvocation() throws ParseException, StandardException {
        ValueNode       columnReference;
        ValueNode       methodNode;
    columnReference = columnNameForInvocation();
    methodNode = nonStaticMethodInvocation(columnReference);
                {if (true) return methodNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnNameForInvocation">columnNameForInvocation</A>
 */
  final public ValueNode columnNameForInvocation() throws ParseException, StandardException {
        String firstName;
        String secondName = null;
        String thirdName = null;
        String          columnName = null;
        String          tableName = null;
        String          schemaName = null;
        TableName       tabName = null;
        ValueNode       retval;
    firstName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    if (getToken(1).kind == PERIOD &&
                                            getToken(3).kind == PERIOD) {
      jj_consume_token(PERIOD);
      secondName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      if (getToken(1).kind == PERIOD &&
                                                      getToken(3).kind == PERIOD) {
        jj_consume_token(PERIOD);
        thirdName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      } else {
        ;
      }
    } else {
      ;
    }
                // Figure out what each identifier stands for
                if (thirdName == null)
                {
                        if (secondName == null)
                        {
                                // There's only one identifier, so it must be a column name
                                columnName = firstName;
                        }
                        else
                        {
                                // There are two identifiers, so they are table and column names
                                tableName = firstName;
                                columnName = secondName;
                        }
                }
                else
                {
                        // There are three identifiers,
                        // so they are schema, table, and column names
                        schemaName = firstName;
                        tableName = secondName;
                        columnName = thirdName;
                }

                if (tableName != null)
                {
                        // There is a table name, so get a TableName node
                        tabName =
                                (TableName) nodeFactory.getNode(
                                                        C_NodeTypes.TABLE_NAME,
                                                        schemaName,
                                                        tableName,
                                                        new Integer(nextToLastIdentifierToken.beginOffset),
                                                        new Integer(nextToLastIdentifierToken.endOffset),
                                                        getContextManager());
                }

                // Get the column reference
                retval = (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.COLUMN_REFERENCE,
                                                                        columnName,
                                                                        tabName,
                                                                        new Integer(lastIdentifierToken.beginOffset),
                                                                        new Integer(lastIdentifierToken.endOffset),
                                                                        getContextManager());

                {if (true) return retval;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnReference">columnReference</A>
 */
  final public ColumnReference columnReference() throws ParseException, StandardException {
        String          firstName;
        String          secondName = null;
        String          thirdName = null;
        String          columnName = null;
        String          tableName = null;
        String          schemaName = null;
        TableName       tabName = null;
    firstName = identifier(Limits.MAX_IDENTIFIER_LENGTH, false);
    if (getToken(1).kind == PERIOD &&
                                            getToken(3).kind != LEFT_PAREN) {
      jj_consume_token(PERIOD);
      secondName = identifier(Limits.MAX_IDENTIFIER_LENGTH, false);
      if (getToken(1).kind == PERIOD &&
                                                      getToken(3).kind != LEFT_PAREN) {
        jj_consume_token(PERIOD);
        thirdName = identifier(Limits.MAX_IDENTIFIER_LENGTH, false);
      } else {
        ;
      }
    } else {
      ;
    }
                // Figure out what each name stands for
                if (thirdName == null)
                {
                        if (secondName == null)
                        {
                                // Only one name, must be column name
                                columnName = firstName;
                        }
                        else
                        {
                                // Two names: table.column
                                tableName = firstName;
                                columnName = secondName;
                        }
                }
                else
                {
                        // Three names: schema.table.column
                        schemaName = firstName;
                        tableName = secondName;
                        columnName = thirdName;
                }

                checkIdentifierLengthLimit(columnName, Limits.MAX_IDENTIFIER_LENGTH);
                if (schemaName != null)
                        checkIdentifierLengthLimit(schemaName, Limits.MAX_IDENTIFIER_LENGTH);
                if (tableName != null)
                        checkIdentifierLengthLimit(tableName, Limits.MAX_IDENTIFIER_LENGTH);

                if (tableName != null)
                {
                        tabName = (TableName) nodeFactory.getNode(
                                                        C_NodeTypes.TABLE_NAME,
                                                        schemaName,
                                                        tableName,
                                                        new Integer(nextToLastIdentifierToken.beginOffset),
                                                        new Integer(nextToLastIdentifierToken.endOffset),
                                                        getContextManager());
                }

                {if (true) return (ColumnReference) nodeFactory.getNode(
                                                                C_NodeTypes.COLUMN_REFERENCE,
                                                                columnName,
                                                                tabName,
                                                                new Integer(lastIdentifierToken.beginOffset),
                                                                new Integer(lastIdentifierToken.endOffset),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
void
columnReference() throws StandardException :
{}
{
	/*
	**
	** I re-wrote the above rule because it caused a grammar ambiguitity.
	** The problem is that we are parsing a dot-separated list of identifiers,
	** and the grammar doesn't know what the identifiers stand for, but the
	** syntax assumed that it did.  For example, in schema.table.column,
	** the grammar doesn't know when it parses the first identifier whether
	** it will be a catalog name, schema name, table name, or column name.
	**
	** I think this problem could be solved by increasing the lookahead.
	** I will try that solution next.  I like that solution better because,
	** if it works, it will be easier for the grammar to figure out what
	** each identifier stands for.
	**

	[ <MODULE> <PERIOD> <IDENTIFIER> |
	  [ [ [ <IDENTIFIER> <PERIOD> ] <IDENTIFIER> <PERIOD> ] <IDENTIFIER> <PERIOD> ]
	]
	<IDENTIFIER>
}
*/
  final public OrderByList orderByClause() throws ParseException, StandardException {
        OrderByList orderCols;
    jj_consume_token(ORDER);
    jj_consume_token(BY);
    orderCols = sortSpecificationList();
                {if (true) return orderCols;}
    throw new Error("Missing return statement in function");
  }

  final public int atIsolationLevel() throws ParseException, StandardException {
        int isolationLevel;
    jj_consume_token(WITH);
    isolationLevel = isolationLevelDB2Abbrev();
                {if (true) return isolationLevel;}
    throw new Error("Missing return statement in function");
  }

  final public OrderByList sortSpecificationList() throws ParseException, StandardException {
        OrderByList orderCols = (OrderByList) nodeFactory.getNode(
                                                                                        C_NodeTypes.ORDER_BY_LIST,
                                                                                        getContextManager());
    sortSpecification(orderCols);
    label_19:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[154] = jj_gen;
        break label_19;
      }
      jj_consume_token(COMMA);
      sortSpecification(orderCols);
    }
                {if (true) return orderCols;}
    throw new Error("Missing return statement in function");
  }

  final public void sortSpecification(OrderByList orderCols) throws ParseException, StandardException {
        OrderByColumn orderCol;
    orderCol = sortKey();
    switch (jj_nt.kind) {
    case ASC:
    case DESC:
      orderingSpecification(orderCol);
      break;
    default:
      jj_la1[155] = jj_gen;
      ;
    }
                orderCols.addOrderByColumn(orderCol);
  }

  final public OrderByColumn sortKey() throws ParseException, StandardException {
        ValueNode columnExpression;
    columnExpression = additiveExpression(null,0,true);
                {if (true) return (OrderByColumn) nodeFactory.getNode(
                                                                C_NodeTypes.ORDER_BY_COLUMN,
                                                                columnExpression,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void orderingSpecification(OrderByColumn orderCol) throws ParseException {
    switch (jj_nt.kind) {
    case ASC:
      jj_consume_token(ASC);
      break;
    case DESC:
      jj_consume_token(DESC);
                orderCol.setDescending();
      break;
    default:
      jj_la1[156] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="forUpdateClause">forUpdateClause</A>
 */
  final public int forUpdateClause(Vector columnList) throws ParseException, StandardException {
        int     retval;
    switch (jj_nt.kind) {
    case UPDATE:
      jj_consume_token(UPDATE);
      switch (jj_nt.kind) {
      case OF:
        jj_consume_token(OF);
        forUpdateColumnList(columnList);
        break;
      default:
        jj_la1[157] = jj_gen;
        ;
      }
                {if (true) return CursorNode.UPDATE;}
      break;
    case READ:
      jj_consume_token(READ);
      jj_consume_token(ONLY);
                {if (true) return CursorNode.READ_ONLY;}
      break;
    case FETCH:
      jj_consume_token(FETCH);
      jj_consume_token(ONLY);
                {if (true) return CursorNode.READ_ONLY;}
      break;
    default:
      jj_la1[158] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="forUpdateColumnList">forUpdateColumnList</A>
 */
  final public void forUpdateColumnList(Vector columnList) throws ParseException, StandardException {
    forUpdateColumn(columnList);
    label_20:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[159] = jj_gen;
        break label_20;
      }
      jj_consume_token(COMMA);
      forUpdateColumn(columnList);
    }
  }

/*
 * <A NAME="forUpdateColumn">forUpdateColumn</A>
 */
  final public void forUpdateColumn(Vector columnList) throws ParseException, StandardException {
        String           columnName;
    /* identifier() used to be columnName() */
            columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                columnList.addElement(columnName);
  }

/*
 * <A NAME="setClauseList">setClauseList</A>
 */
  final public ResultColumnList setClauseList() throws ParseException, StandardException {
        ResultColumnList        columnList = (ResultColumnList) nodeFactory.getNode(
                                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                                getContextManager());
    setClause(columnList);
    label_21:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[160] = jj_gen;
        break label_21;
      }
      jj_consume_token(COMMA);
      setClause(columnList);
    }
                {if (true) return columnList;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="setClause">setClause</A>
 */
  final public void setClause(ResultColumnList columnList) throws ParseException, StandardException {
        ResultColumn resultColumn;
        ColumnReference  columnName;
        ValueNode        valueNode;
    /* identifier() used to be objectColumn() */
            /*
    		SQL92 only wants identifiers here (column names)
    		but JBuilder expects table.column, so we allow the
    		general form.
    	 */
            columnName = columnReference();
    jj_consume_token(EQUALS_OPERATOR);
    valueNode = updateSource(columnName.getColumnName());
                resultColumn = (ResultColumn) nodeFactory.getNode(
                                                                                C_NodeTypes.RESULT_COLUMN,
                                                                                columnName,
                                                                                valueNode,
                                                                                getContextManager());
                columnList.addResultColumn(resultColumn);
  }

/*
 * <A NAME="updateSource">updateSource</A>
 */
  final public ValueNode updateSource(String columnName) throws ParseException, StandardException {
        ValueNode       valueNode;
    if (jj_2_36(1)) {
      valueNode = additiveExpression(null,0, false);
                {if (true) return valueNode;}
    } else {
      switch (jj_nt.kind) {
      case NULL:
        valueNode = nullSpecification();
                {if (true) return valueNode;}
        break;
      case _DEFAULT:
        jj_consume_token(_DEFAULT);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.DEFAULT_NODE,
                                                                columnName,
                                                                getContextManager());}
        break;
      default:
        jj_la1[161] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nullSpecification">nullSpecification</A>
 */
  final public ValueNode nullSpecification() throws ParseException, StandardException {
    jj_consume_token(NULL);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="insertColumnsAndSource">insertColumnsAndSource</A>
 */
  final public StatementNode insertColumnsAndSource(QueryTreeNode targetTable) throws ParseException, StandardException {
        Properties                      targetProperties = null;
        ResultSetNode   queryExpression;
        ResultColumnList        columnList = null;
    if (getToken(1).kind == LEFT_PAREN && ! subqueryFollows()) {
      jj_consume_token(LEFT_PAREN);
      columnList = insertColumnList();
      jj_consume_token(RIGHT_PAREN);
    } else {
      ;
    }
    switch (jj_nt.kind) {
    case DERBYDASHPROPERTIES:
      targetProperties = propertyList(false);
      jj_consume_token(CHECK_PROPERTIES);
      break;
    default:
      jj_la1[162] = jj_gen;
      ;
    }
    queryExpression = queryExpression(null, NO_SET_OP);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.INSERT_NODE,
                                                        targetTable,
                                                        columnList,
                                                        queryExpression,
                                                        targetProperties,
                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="insertColumnList">insertColumnList</A>
 */
  final public ResultColumnList insertColumnList() throws ParseException, StandardException {
        ResultColumnList        columnList = (ResultColumnList) nodeFactory.getNode(
                                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                                getContextManager());
    columnQualifiedNameList(columnList);
                {if (true) return columnList;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnQualifiedNameList">columnQualifiedNameList</A>
 */
  final public void columnQualifiedNameList(ResultColumnList columnList) throws ParseException, StandardException {
    columnQualifiedNameItem(columnList);
    label_22:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[163] = jj_gen;
        break label_22;
      }
      jj_consume_token(COMMA);
      columnQualifiedNameItem(columnList);
    }
  }

/*
 * <A NAME="columnQualifiedNameItem">columnQualifiedNameItem</A>
 */
  final public void columnQualifiedNameItem(ResultColumnList columnList) throws ParseException, StandardException {
        ColumnReference         columnRef;
        ResultColumn    resultColumn;
    /*
    		SQL92 only wants identifiers here (column names)
    		but JBuilder expects table.column, so we allow the
    		general form.
    	 */
            columnRef = columnReference();
                /*
		** Store the column names for the result columns in the
		** result column list.  We don't know yet what valueNodes
		** should be hooked up to each result column, so set that
		** to null for now.
		*/
                resultColumn = (ResultColumn) nodeFactory.getNode(
                                                                                C_NodeTypes.RESULT_COLUMN,
                                                                                columnRef,
                                                                                null,
                                                                                getContextManager());
                columnList.addResultColumn(resultColumn);
  }

/*
 * <A NAME="rowValueConstructor">rowValueConstructor</A>
 */
  final public ResultSetNode rowValueConstructor(ResultSetNode leftRSN) throws ParseException, StandardException {
        ResultColumnList        resultColumns = (ResultColumnList) nodeFactory.getNode(
                                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                                getContextManager());
        ResultSetNode           newRSN;
    if (rowValueConstructorListFollows()) {
      jj_consume_token(LEFT_PAREN);
      rowValueConstructorList(resultColumns);
      jj_consume_token(RIGHT_PAREN);
                /* If leftRSN is null, simply return the newRSN, else generate and
		 * return a UNION ALL above the 2 RSNs, after verifying that the size()
		 * of both RSNs RCLs is the same.
		 */
                newRSN = (ResultSetNode) nodeFactory.getNode(
                                                                C_NodeTypes.ROW_RESULT_SET_NODE,
                                                                resultColumns,
                                                                null,
                                                                getContextManager());
                if (leftRSN != null)
                {
                        if (leftRSN.getResultColumns().size() !=
                                newRSN.getResultColumns().size())
                        {
                                {if (true) throw StandardException.newException(SQLState.LANG_ROW_VALUE_CONSTRUCTOR_UNMATCHED_COLUMNS);}
                        }

                        newRSN = (ResultSetNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNION_NODE,
                                                                        leftRSN,
                                                                        newRSN,
                                                                        Boolean.TRUE,
                                                                        Boolean.TRUE,
                                                                        null,
                                                                        getContextManager());
                }
                {if (true) return newRSN;}
    } else {
      rowValueConstructorElement(resultColumns);
                /* If leftRSN is null, simply return the newRSN, else generate and
		 * return a UNION ALL above the 2 RSNs, after verifying that the size()
		 * of both RSNs RCLs is the same.
		 */
                newRSN = (ResultSetNode) nodeFactory.getNode(
                                                                C_NodeTypes.ROW_RESULT_SET_NODE,
                                                                resultColumns,
                                                                null,
                                                                getContextManager());
                if (leftRSN != null)
                {
                        if (leftRSN.getResultColumns().size() !=
                                newRSN.getResultColumns().size())
                        {
                                {if (true) throw StandardException.newException(SQLState.LANG_ROW_VALUE_CONSTRUCTOR_UNMATCHED_COLUMNS);}
                        }

                        newRSN = (ResultSetNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNION_NODE,
                                                                        leftRSN,
                                                                        newRSN,
                                                                        Boolean.TRUE,
                                                                        Boolean.TRUE,
                                                                        null,
                                                                        getContextManager());
                }
                {if (true) return newRSN;}
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="rowValueConstructorElement">rowValueConstructorElement</A>
 */
  final public void rowValueConstructorElement(ResultColumnList resultColumns) throws ParseException, StandardException {
        ValueNode       value;
    if (jj_2_37(1)) {
      value = additiveExpression(null, 0, true);
                resultColumns.addResultColumn(
                        (ResultColumn) nodeFactory.getNode(
                                                        C_NodeTypes.RESULT_COLUMN,
                                                        null,
                                                        value,
                                                        getContextManager())
                                );
    } else {
      switch (jj_nt.kind) {
      case NULL:
        value = nullSpecification();
                resultColumns.addResultColumn(
                        (ResultColumn) nodeFactory.getNode(
                                                        C_NodeTypes.RESULT_COLUMN,
                                                        null,
                                                        value,
                                                        getContextManager())
                                );
        break;
      case _DEFAULT:
        jj_consume_token(_DEFAULT);
                resultColumns.addResultColumn(
                        (ResultColumn) nodeFactory.getNode(
                                                        C_NodeTypes.RESULT_COLUMN,
                                                        null,
                                                        (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.DEFAULT_NODE,
                                                                null,
                                                                getContextManager()),
                                                        getContextManager())
                                );
        break;
      default:
        jj_la1[164] = jj_gen;
                {if (true) throw StandardException.newException(SQLState.LANG_EMPTY_VALUES_CLAUSE);}
      }
    }
  }

/*
 * <A NAME="rowValueConstructorList">rowValueConstructorList</A>
 */
  final public void rowValueConstructorList(ResultColumnList resultColumns) throws ParseException, StandardException {
    rowValueConstructorElement(resultColumns);
    label_23:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[165] = jj_gen;
        break label_23;
      }
      jj_consume_token(COMMA);
      rowValueConstructorElement(resultColumns);
    }
  }

/*
 * <A NAME="tableSubquery">tableSubquery</A>
 */
  final public SubqueryNode tableSubquery(int subqueryType, ValueNode leftOperand) throws ParseException, StandardException {
        SubqueryNode    subqueryNode;
    subqueryNode = subquery(subqueryType, leftOperand);
                {if (true) return subqueryNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="subquery">subquery</A>
 */
  final public SubqueryNode subquery(int subqueryType, ValueNode leftOperand) throws ParseException, StandardException {
        ResultSetNode   queryExpression;
        SubqueryNode    subqueryNode;
    queryExpression = queryExpression(null, NO_SET_OP);
                subqueryNode = (SubqueryNode) nodeFactory.getNode(
                                                                                C_NodeTypes.SUBQUERY_NODE,
                                                                                queryExpression,
                                                                                ReuseFactory.getInteger(subqueryType),
                                                                                leftOperand,
                                                                                getContextManager());
                {if (true) return subqueryNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="inPredicateValue">inPredicateValue</A>
 */
  final public ValueNode inPredicateValue(ValueNode leftOperand) throws ParseException, StandardException {
        ValueNode               retval;
        int                             tokKind;
    jj_consume_token(LEFT_PAREN);
    if (subqueryFollows()) {
      retval = tableSubquery(SubqueryNode.IN_SUBQUERY, leftOperand);
    } else if (jj_2_38(1)) {
      retval = inValueList(leftOperand);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RIGHT_PAREN);
                {if (true) return retval;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="inValueList">inValueList</A>
 */
  final public ValueNode inValueList(ValueNode leftOperand) throws ParseException, StandardException {
        ValueNodeList   inList = (ValueNodeList) nodeFactory.getNode(
                                                                                        C_NodeTypes.VALUE_NODE_LIST,
                                                                                        getContextManager());
    inElement(inList);
    label_24:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[166] = jj_gen;
        break label_24;
      }
      jj_consume_token(COMMA);
      inElement(inList);
    }
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.IN_LIST_OPERATOR_NODE,
                                                                leftOperand,
                                                                inList,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="inElement">inElement</A>
 */
  final public void inElement(ValueNodeList inList) throws ParseException, StandardException {
        ValueNode valueNode;
    valueNode = additiveExpression(null, 0, false);
                inList.addElement(valueNode);
  }

/*
 * <A NAME="quantifier">quantifier</A>
 */
  final public int quantifier(int opType) throws ParseException, StandardException {
        int retval = 0;
    switch (jj_nt.kind) {
    case ALL:
      jj_consume_token(ALL);
                switch (opType)
                {
                        case BinaryOperatorNode.EQ:
                                retval = SubqueryNode.EQ_ALL_SUBQUERY;
                                break;

                        case BinaryOperatorNode.NE:
                                retval = SubqueryNode.NE_ALL_SUBQUERY;
                                break;

                        case BinaryOperatorNode.LE:
                                retval = SubqueryNode.LE_ALL_SUBQUERY;
                                break;

                        case BinaryOperatorNode.LT:
                                retval = SubqueryNode.LT_ALL_SUBQUERY;
                                break;

                        case BinaryOperatorNode.GE:
                                retval = SubqueryNode.GE_ALL_SUBQUERY;
                                break;

                        case BinaryOperatorNode.GT:
                                retval = SubqueryNode.GT_ALL_SUBQUERY;
                                break;

                        default:
                                if (SanityManager.DEBUG)
                                SanityManager.THROWASSERT(
                                                "Invalid value for opType (" + opType +
                                                ") passed to quantifier()");
                }
                {if (true) return retval;}
      break;
    case ANY:
    case SOME:
      some();
                switch (opType)
                {
                        case BinaryOperatorNode.EQ:
                                retval = SubqueryNode.EQ_ANY_SUBQUERY;
                                break;

                        case BinaryOperatorNode.NE:
                                retval = SubqueryNode.NE_ANY_SUBQUERY;
                                break;

                        case BinaryOperatorNode.LE:
                                retval = SubqueryNode.LE_ANY_SUBQUERY;
                                break;

                        case BinaryOperatorNode.LT:
                                retval = SubqueryNode.LT_ANY_SUBQUERY;
                                break;

                        case BinaryOperatorNode.GE:
                                retval = SubqueryNode.GE_ANY_SUBQUERY;
                                break;

                        case BinaryOperatorNode.GT:
                                retval = SubqueryNode.GT_ANY_SUBQUERY;
                                break;

                        default:
                                if (SanityManager.DEBUG)
                                SanityManager.THROWASSERT(
                                                "Invalid value for opType (" + opType +
                                                ") passed to quantifier()");
                }
                {if (true) return retval;}
      break;
    default:
      jj_la1[167] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="some">some</A>
 */
  final public void some() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case SOME:
      jj_consume_token(SOME);
      break;
    case ANY:
      jj_consume_token(ANY);
      break;
    default:
      jj_la1[168] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="existsExpression">existsExpression</A>
 */
  final public SubqueryNode existsExpression() throws ParseException, StandardException {
        SubqueryNode    subqueryNode;
    jj_consume_token(EXISTS);
    jj_consume_token(LEFT_PAREN);
    subqueryNode = tableSubquery(SubqueryNode.EXISTS_SUBQUERY, null);
    jj_consume_token(RIGHT_PAREN);
                {if (true) return subqueryNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableExpression">tableExpression</A>
 */
  final public SelectNode tableExpression(ResultColumnList selectList) throws ParseException, StandardException {
        SelectNode      selectNode;
        FromList        fromList;
        ValueNode       whereClause = null;
        GroupByList     groupByList = null;
        ValueNode       havingClause = null;
        Token           whereToken;
    fromList = fromClause();
    switch (jj_nt.kind) {
    case WHERE:
      whereToken = jj_consume_token(WHERE);
      whereClause = whereClause(whereToken);
      break;
    default:
      jj_la1[169] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case GROUP:
      groupByList = groupByClause();
      break;
    default:
      jj_la1[170] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case HAVING:
      havingClause = havingClause();
      break;
    default:
      jj_la1[171] = jj_gen;
      ;
    }
                // fix for HAVING without GROUP BY, makes sure we get one
                // aggregate operator by adding a count(*), this fixes beetle 5853, 5890
                if (havingClause != null && groupByList == null) {
                        ValueNode vn = (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.AGGREGATE_NODE,
                                                                null,
                                                                org.apache.derby.impl.sql.compile.CountAggregateDefinition.class,
                                                                Boolean.FALSE, // distinct Boolean.TRUE?
                                                                "COUNT(*)",
                                                                getContextManager());
                        AggregateNode n = (AggregateNode) vn;
                        n.replaceAggregatesWithColumnReferences(selectList, 0);
                }

                selectNode = (SelectNode) nodeFactory.getNode(
                                                        C_NodeTypes.SELECT_NODE,
                                                        selectList,
                                                        null,           /* AGGREGATE list */
                                                        fromList,
                                                        whereClause,
                                                        groupByList,
                                                        havingClause,
                                                        getContextManager());

                {if (true) return selectNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="fromClause">fromClause</A>
 */
  final public FromList fromClause() throws ParseException, StandardException {
        FromList fromList = (FromList) nodeFactory.getNode(
                                                                        C_NodeTypes.FROM_LIST,
                                                                        getNodeFactory().doJoinOrderOptimization(),
                                                                        getContextManager());
        int     tokKind;
        Token   beginToken;
        Token   endToken;
    jj_consume_token(FROM);
                beginToken = getToken(1);
    switch (jj_nt.kind) {
    case DERBYDASHPROPERTIES:
      fromListProperties(fromList);
      break;
    default:
      jj_la1[172] = jj_gen;
      ;
    }
    dummyTableReferenceRule(fromList);
    label_25:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[173] = jj_gen;
        break label_25;
      }
      jj_consume_token(COMMA);
      dummyTableReferenceRule(fromList);
    }
                                                                         endToken = getToken(0);
                fromList.setBeginOffset( beginToken.beginOffset);
                fromList.setEndOffset( endToken.endOffset);
                {if (true) return fromList;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="fromListProperties">fromListProperties</A>
 */
  final public void fromListProperties(FromList fromList) throws ParseException, StandardException {
        Properties properties;
    properties = propertyList(true);
    jj_consume_token(CHECK_PROPERTIES);
                fromList.setProperties(properties);
  }

/* This rule created simply as a way to add the result of tableReference()
 * to the fromList.
 */
  final public void dummyTableReferenceRule(FromList fromList) throws ParseException, StandardException {
        FromTable tableReference;
    if (getToken(1).kind == TABLE &&
                                    getToken(2).kind == LEFT_PAREN &&
                                    (
                                            getToken(3).kind == SELECT ||
                                            getToken(3).kind == VALUES
                                    )) {
      jj_consume_token(TABLE);
      tableReference = tableReferenceTypes(false);
                fromList.addFromTable(tableReference);
    } else if (jj_2_39(1)) {
      tableReference = tableReferenceTypes(false);
                fromList.addFromTable(tableReference);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public FromTable tableReferenceTypes(boolean nestedInParens) throws ParseException, StandardException {
        FromTable tableReference;
    if (jj_2_40(1)) {
      tableReference = tableReference(nestedInParens);
                {if (true) return tableReference ;}
    } else {
      switch (jj_nt.kind) {
      case LEFT_BRACE:
        jj_consume_token(LEFT_BRACE);
        jj_consume_token(OJ);
        tableReference = tableReference(nestedInParens);
        jj_consume_token(RIGHT_BRACE);
                {if (true) return tableReference;}
        break;
      default:
        jj_la1[174] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Object[] optionalTableClauses() throws ParseException, StandardException {
        Object[]                         otc = null;
        Properties                      tableProperties = null;
        ResultColumnList        derivedRCL = null;
        String                          correlationName = null;
    switch (jj_nt.kind) {
    case DERBYDASHPROPERTIES:
      otc = optionalTableProperties();
                otc[OPTIONAL_TABLE_CLAUSES_DERIVED_RCL] = derivedRCL;
                otc[OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME] = correlationName;
                {if (true) return otc;}
      break;
    default:
      jj_la1[179] = jj_gen;
      switch (jj_nt.kind) {
      case AS:
      case BINARY:
      case COALESCE:
      case COUNT:
      case D:
      case MODULE:
      case T:
      case TS:
      case VALUE:
      case VARBINARY:
      case ABS:
      case ABSVAL:
      case ACTION:
      case ALWAYS:
      case BLOB:
      case C:
      case CALLED:
      case CLOB:
      case COBOL:
      case COMMITTED:
      case CONCAT:
      case CONTAINS:
      case DATA:
      case DATE:
      case DAY:
      case DYNAMIC:
      case FORTRAN:
      case GENERATED:
      case IDENTITY_VAL_LOCAL:
      case INCREMENT:
      case INITIAL:
      case INTERVAL:
      case LANGUAGE:
      case LARGE:
      case LENGTH:
      case LEVEL:
      case LOCKS:
      case LOCKSIZE:
      case LOGGED:
      case MOD:
      case MODIFIES:
      case MODIFY:
      case MONTH:
      case _MORE:
      case MUMPS:
      case NAME:
      case NCLOB:
      case NULLABLE:
      case NUMBER:
      case OBJECT:
      case PASCAL:
      case PLI:
      case PRECISION:
      case RELEASE:
      case REPEATABLE:
      case RESTART:
      case RETURNS:
      case ROW:
      case SAVEPOINT:
      case SCALE:
      case SERIALIZABLE:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case START:
      case STATEMENT:
      case SYNONYM:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TRUNCATE:
      case TYPE:
      case UNCOMMITTED:
      case USAGE:
      case WHEN:
      case CURDATE:
      case CURTIME:
      case DATABASE:
      case LONG:
      case AFTER:
      case BEFORE:
      case CLASS:
      case COMPRESS:
      case CONTENT:
      case CS:
      case DB2SQL:
      case DIRTY:
      case DOCUMENT:
      case EACH:
      case EMPTY:
      case EXCLUSIVE:
      case FN:
      case INDEX:
      case JAVA:
      case LCASE:
      case LOCATE:
      case LOCK:
      case MESSAGE_LOCALE:
      case METHOD:
      case MODE:
      case NEW:
      case NEW_TABLE:
      case OJ:
      case OFF:
      case OLD:
      case OLD_TABLE:
      case PARAMETER:
      case PASSING:
      case PROPERTIES:
      case READS:
      case REF:
      case REFERENCING:
      case RENAME:
      case RESET:
      case RESULT:
      case RETAIN:
      case RETURNING:
      case RR:
      case RS:
      case SEQUENCE:
      case SEQUENTIAL:
      case SETS:
      case SHARE:
      case SQLID:
      case SPECIFIC:
      case SQRT:
      case STABILITY:
      case STRIP:
      case STYLE:
      case TRIGGER:
      case UCASE:
      case UR:
      case WHITESPACE:
      case IDENTIFIER:
      case DELIMITED_IDENTIFIER:
        switch (jj_nt.kind) {
        case AS:
          jj_consume_token(AS);
          break;
        default:
          jj_la1[175] = jj_gen;
          ;
        }
        correlationName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
        switch (jj_nt.kind) {
        case LEFT_PAREN:
          jj_consume_token(LEFT_PAREN);
          derivedRCL = derivedColumnList();
          jj_consume_token(RIGHT_PAREN);
          break;
        default:
          jj_la1[176] = jj_gen;
          ;
        }
        switch (jj_nt.kind) {
        case DERBYDASHPROPERTIES:
          tableProperties = propertyList(true);
          jj_consume_token(CHECK_PROPERTIES);
          break;
        default:
          jj_la1[177] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[178] = jj_gen;
        ;
      }
                otc = new Object[OPTIONAL_TABLE_CLAUSES_SIZE];
                otc[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] = tableProperties;
                otc[OPTIONAL_TABLE_CLAUSES_DERIVED_RCL] = derivedRCL;
                otc[OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME] = correlationName;
                {if (true) return otc;}
    }
    throw new Error("Missing return statement in function");
  }

  final public Object[] optionalTableProperties() throws ParseException, StandardException {
        Object[]                        otc = null;
        Properties                      tableProperties = null;
    tableProperties = propertyList(true);
    jj_consume_token(CHECK_PROPERTIES);
                otc = new Object[OPTIONAL_TABLE_CLAUSES_SIZE];
                otc[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] = tableProperties;
                {if (true) return otc;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableReference">tableReference</A>
 */
  final public FromTable tableReference(boolean nestedInParens) throws ParseException, StandardException {
        JavaToSQLValueNode      javaToSQLNode = null;
        TableName                       tableName;
        String                          correlationName = null;
        ResultColumnList        derivedRCL = null;
        FromTable                       fromTable;
        TableOperatorNode       joinTable = null;
        FromTable                       tableReference;
        Object[]                        optionalTableClauses = new Object[OPTIONAL_TABLE_CLAUSES_SIZE];
        Properties                      tableProperties = null;
        ResultSetNode           derivedTable;
    if (jj_2_41(1)) {
      if (newInvocationFollows(1)) {
        javaToSQLNode = newInvocation();
      } else {
        switch (jj_nt.kind) {
        case TABLE:
          javaToSQLNode = vtiTableConstruct();
          break;
        default:
          jj_la1[180] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch (jj_nt.kind) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[181] = jj_gen;
        ;
      }
      correlationName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      switch (jj_nt.kind) {
      case LEFT_PAREN:
        jj_consume_token(LEFT_PAREN);
        derivedRCL = derivedColumnList();
        jj_consume_token(RIGHT_PAREN);
        break;
      default:
        jj_la1[182] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case DERBYDASHPROPERTIES:
        optionalTableClauses = optionalTableProperties();
        break;
      default:
        jj_la1[183] = jj_gen;
        ;
      }
      label_26:
      while (true) {
        if (joinedTableExpressionFollows()) {
          ;
        } else {
          break label_26;
        }
        joinTable = joinedTableExpression((joinTable != null) ?
                                                                                        joinTable :
                                                                                        (FromTable) nodeFactory.getNode(
                                                                                                C_NodeTypes.FROM_VTI,
                                                                                                javaToSQLNode.getJavaValueNode(),
                                                                                                correlationName,
                                                                                                derivedRCL,
                                                                                                ((optionalTableClauses != null) ?
                                                                                                        (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] :
                                                                                                        (Properties) null),
                                                                                                getContextManager()),
                                                                                nestedInParens);
      }
                /* Build a derived table if not a join expression */
                if (joinTable == null)
                {
                        fromTable = (FromTable) nodeFactory.getNode(
                                                                C_NodeTypes.FROM_VTI,
                                                                javaToSQLNode.getJavaValueNode(),
                                                                correlationName,
                                                                derivedRCL,
                                                                ((optionalTableClauses != null) ?
                                                                        (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] :
                                                                        (Properties) null),
                                                                getContextManager());
                }
                else
                {
                        fromTable = joinTable;
                }

                {if (true) return fromTable;}
    } else {
      switch (jj_nt.kind) {
      case BINARY:
      case COALESCE:
      case COUNT:
      case D:
      case MODULE:
      case T:
      case TS:
      case VALUE:
      case VARBINARY:
      case ABS:
      case ABSVAL:
      case ACTION:
      case ALWAYS:
      case BLOB:
      case C:
      case CALLED:
      case CLOB:
      case COBOL:
      case COMMITTED:
      case CONCAT:
      case CONTAINS:
      case DATA:
      case DATE:
      case DAY:
      case DYNAMIC:
      case FORTRAN:
      case GENERATED:
      case IDENTITY_VAL_LOCAL:
      case INCREMENT:
      case INITIAL:
      case INTERVAL:
      case LANGUAGE:
      case LARGE:
      case LENGTH:
      case LEVEL:
      case LOCKS:
      case LOCKSIZE:
      case LOGGED:
      case MOD:
      case MODIFIES:
      case MODIFY:
      case MONTH:
      case _MORE:
      case MUMPS:
      case NAME:
      case NCLOB:
      case NULLABLE:
      case NUMBER:
      case OBJECT:
      case PASCAL:
      case PLI:
      case PRECISION:
      case RELEASE:
      case REPEATABLE:
      case RESTART:
      case RETURNS:
      case ROW:
      case SAVEPOINT:
      case SCALE:
      case SERIALIZABLE:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case START:
      case STATEMENT:
      case SYNONYM:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TRUNCATE:
      case TYPE:
      case UNCOMMITTED:
      case USAGE:
      case WHEN:
      case CURDATE:
      case CURTIME:
      case DATABASE:
      case LONG:
      case AFTER:
      case BEFORE:
      case CLASS:
      case COMPRESS:
      case CONTENT:
      case CS:
      case DB2SQL:
      case DIRTY:
      case DOCUMENT:
      case EACH:
      case EMPTY:
      case EXCLUSIVE:
      case FN:
      case INDEX:
      case JAVA:
      case LCASE:
      case LOCATE:
      case LOCK:
      case MESSAGE_LOCALE:
      case METHOD:
      case MODE:
      case NEW:
      case NEW_TABLE:
      case OJ:
      case OFF:
      case OLD:
      case OLD_TABLE:
      case PARAMETER:
      case PASSING:
      case PROPERTIES:
      case READS:
      case REF:
      case REFERENCING:
      case RENAME:
      case RESET:
      case RESULT:
      case RETAIN:
      case RETURNING:
      case RR:
      case RS:
      case SEQUENCE:
      case SEQUENTIAL:
      case SETS:
      case SHARE:
      case SQLID:
      case SPECIFIC:
      case SQRT:
      case STABILITY:
      case STRIP:
      case STYLE:
      case TRIGGER:
      case UCASE:
      case UR:
      case WHITESPACE:
      case IDENTIFIER:
      case DELIMITED_IDENTIFIER:
        /* identifier() used to be correlationName() */
                tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
        optionalTableClauses = optionalTableClauses();
        label_27:
        while (true) {
          if (joinedTableExpressionFollows()) {
            ;
          } else {
            break label_27;
          }
          joinTable = joinedTableExpression((joinTable != null) ?
                                                                                          joinTable :
                                                                                          (FromTable) nodeFactory.getNode(
                                                                                                          C_NodeTypes.FROM_BASE_TABLE,
                                                                                                          tableName,
                                                                                                          (String) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME],
                                                                                                          (ResultColumnList) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_DERIVED_RCL],
                                                                                                          (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES],
                                                                                                          getContextManager()),
                                                                                  nestedInParens);
        }
                /* Build a from table if not a join expression */
                if (joinTable == null)
                {
                        fromTable = (FromTable) nodeFactory.getNode(
                                                                                        C_NodeTypes.FROM_BASE_TABLE,
                                                                                        tableName,
                                                                                                (String) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME],
                                                                                                (ResultColumnList) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_DERIVED_RCL],
                                                                                                (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES],
                                                                                        getContextManager());
                }
                else
                {
                        fromTable = joinTable;
                }
                {if (true) return fromTable;}
        break;
      default:
        jj_la1[187] = jj_gen;
        if (getToken(1).kind == LEFT_PAREN &&
                                        (
                                                getToken(2).kind == SELECT ||
                                                getToken(2).kind == VALUES
                                        )) {
          derivedTable = derivedTable();
          switch (jj_nt.kind) {
          case AS:
            jj_consume_token(AS);
            break;
          default:
            jj_la1[184] = jj_gen;
            ;
          }
          correlationName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
          switch (jj_nt.kind) {
          case LEFT_PAREN:
            jj_consume_token(LEFT_PAREN);
            derivedRCL = derivedColumnList();
            jj_consume_token(RIGHT_PAREN);
            break;
          default:
            jj_la1[185] = jj_gen;
            ;
          }
          switch (jj_nt.kind) {
          case DERBYDASHPROPERTIES:
            optionalTableClauses = optionalTableProperties();
            break;
          default:
            jj_la1[186] = jj_gen;
            ;
          }
          label_28:
          while (true) {
            if (joinedTableExpressionFollows()) {
              ;
            } else {
              break label_28;
            }
            joinTable = joinedTableExpression((joinTable != null) ?
                                                                                            joinTable :
                                                                                            (FromTable) nodeFactory.getNode(
                                                                                                                    C_NodeTypes.FROM_SUBQUERY,
                                                                                                                    derivedTable,
                                                                                                                    correlationName,
                                                                                                                    derivedRCL,
                                                                                                                    ((optionalTableClauses != null) ?
                                                                                                                            (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] :
                                                                                                                            (Properties) null),
                                                                                                                    getContextManager()),
                                                                                    nestedInParens);
          }
                /* Build a derived table if not a join expression */
                if (joinTable == null)
                {
                        fromTable = (FromTable) nodeFactory.getNode(
                                                                                        C_NodeTypes.FROM_SUBQUERY,
                                                                                        derivedTable,
                                                                                        correlationName,
                                                                                        derivedRCL,
                                                                                        ((optionalTableClauses != null) ?
                                                                                                (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] :
                                                                                                (Properties) null),
                                                                                        getContextManager());
                }
                else
                {
                        fromTable = joinTable;
                }

                {if (true) return fromTable;}
        } else {
          switch (jj_nt.kind) {
          case LEFT_PAREN:
            jj_consume_token(LEFT_PAREN);
            tableReference = tableReferenceTypes(true);
            jj_consume_token(RIGHT_PAREN);
            label_29:
            while (true) {
              if (joinedTableExpressionFollows()) {
                ;
              } else {
                break label_29;
              }
              joinTable = joinedTableExpression((joinTable != null) ?
                                                                                              joinTable :
                                                                                              tableReference,
                                                                                      nestedInParens);
            }
                if (joinTable == null)
                {
                        fromTable = tableReference;
                }
                else
                {
                        fromTable = joinTable;
                }

                {if (true) return fromTable;}
            break;
          default:
            jj_la1[188] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="derivedColumnList">derivedColumnList</A>
 */
  final public ResultColumnList derivedColumnList() throws ParseException, StandardException {
        ResultColumnList        resultColumns =
                                                                        (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
    columnNameList(resultColumns);
                {if (true) return resultColumns;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnNameList">columnNameList</A>
 */
  final public void columnNameList(ResultColumnList columnList) throws ParseException, StandardException {
    columnNameItem(columnList);
    label_30:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[189] = jj_gen;
        break label_30;
      }
      jj_consume_token(COMMA);
      columnNameItem(columnList);
    }
  }

/*
 * <A NAME="columnNameItem">columnNameItem</A>
 */
  final public void columnNameItem(ResultColumnList columnList) throws ParseException, StandardException {
        String          columnName;
        ResultColumn    resultColumn;
    /* identifier() used to be columnName() */
            columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                /*
		** Store the column names for the result columns in the
		** result column list.  We don't know yet what valueNodes
		** should be hooked up to each result column, so set that
		** to null for now.
		*/
                resultColumn = (ResultColumn) nodeFactory.getNode(
                                                                        C_NodeTypes.RESULT_COLUMN,
                                                                        columnName,
                                                                        null,
                                                                        getContextManager());
                columnList.addResultColumn(resultColumn);
  }

/*
 * <A NAME="indexColumnList">indexColumnList</A>
 */
  final public void indexColumnList(Vector columnList) throws ParseException, StandardException {
    indexColumnItem(columnList);
    label_31:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[190] = jj_gen;
        break label_31;
      }
      jj_consume_token(COMMA);
      indexColumnItem(columnList);
    }
  }

/*
 * <A NAME="indexColumnItem">indexColumnItem</A>
 */
  final public void indexColumnItem(Vector columnList) throws ParseException, StandardException {
        String          columnName;
    /* identifier never ends with a space; appending a space meaning desc */
            columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    switch (jj_nt.kind) {
    case ASC:
    case DESC:
      switch (jj_nt.kind) {
      case ASC:
        jj_consume_token(ASC);
        break;
      case DESC:
        jj_consume_token(DESC);
                                                                                     columnName = columnName + ' ';
        break;
      default:
        jj_la1[191] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[192] = jj_gen;
      ;
    }
                /*
		** Store the column names for the index columns in the
		** index column list.
		*/
                columnList.addElement(columnName);
  }

/*
 * <A NAME="derivedTable">derivedTable</A>
 */
  final public ResultSetNode derivedTable() throws ParseException, StandardException {
        SubqueryNode tableSubquery;
    jj_consume_token(LEFT_PAREN);
    tableSubquery = tableSubquery(SubqueryNode.FROM_SUBQUERY, null);
    jj_consume_token(RIGHT_PAREN);
                {if (true) return tableSubquery.getResultSet();}
    throw new Error("Missing return statement in function");
  }

  final public TableOperatorNode joinedTableExpression(ResultSetNode leftRSN, boolean nestedInParens) throws ParseException, StandardException {
        TableOperatorNode joinNode;
    joinNode = qualifiedJoin(leftRSN, nestedInParens);
                {if (true) return joinNode;}
    throw new Error("Missing return statement in function");
  }

  final public TableOperatorNode qualifiedJoin(ResultSetNode leftRSN, boolean nestedInParens) throws ParseException, StandardException {
        int                                     joinType = JoinNode.INNERJOIN;
        ResultSetNode           rightRSN;
        TableOperatorNode       ton = null;
        Object[]                        onOrUsingClause = null;
        ResultColumnList        usingClause = null;
        ValueNode                       onClause;
    switch (jj_nt.kind) {
    case INNER:
    case LEFT:
    case RIGHT:
      joinType = joinType();
      break;
    default:
      jj_la1[193] = jj_gen;
      ;
    }
    jj_consume_token(JOIN);
    rightRSN = tableReferenceTypes(nestedInParens);
    onOrUsingClause = joinSpecification(leftRSN, rightRSN);
                /* If NATURAL OR UNION is specified, then no joinSpecification()
		 * is required, otherwise it is required.
		 */

                /* RESOLVE - Since we don't support NATURAL or UNION joins yet,
		 * onOrUsingClause must be non-null.  (Change error message if and
		 * when grammar changes.)
		 */

                /* Figure out whether an ON or USING clause was used */
                onClause = (ValueNode) onOrUsingClause[ON_CLAUSE];
                usingClause = (ResultColumnList) onOrUsingClause[USING_CLAUSE];

                if (onClause == null && usingClause == null)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_MISSING_JOIN_SPECIFICATION,
                                                        JoinNode.joinTypeToString(joinType));}
                }

                switch(joinType)
                {
                        case JoinNode.INNERJOIN:
                                ton = (TableOperatorNode) nodeFactory.getNode(
                                                                        C_NodeTypes.JOIN_NODE,
                                                                        leftRSN,
                                                                        rightRSN,
                                                                        onClause,
                                                                        usingClause,
                                                                        null,
                                                                        null,
                                                                        null,
                                                                        getContextManager());
                                break;

                        case JoinNode.LEFTOUTERJOIN:
                                ton = (TableOperatorNode) nodeFactory.getNode(
                                                                                C_NodeTypes.HALF_OUTER_JOIN_NODE,
                                                                                leftRSN,
                                                                                rightRSN,
                                                                                onClause,
                                                                                usingClause,
                                                                                Boolean.FALSE,
                                                                                null,
                                                                                getContextManager());
                                break;

                        case JoinNode.RIGHTOUTERJOIN:
                                ton = (TableOperatorNode) nodeFactory.getNode(
                                                                                C_NodeTypes.HALF_OUTER_JOIN_NODE,
                                                                                leftRSN,
                                                                                rightRSN,
                                                                                onClause,
                                                                                usingClause,
                                                                                Boolean.TRUE,
                                                                                null,
                                                                                getContextManager());
                                break;


                        default:
                                if (SanityManager.DEBUG)
                                {
                                        SanityManager.ASSERT(false, "Unexpected joinType");
                                }
                                {if (true) return null;}
                }

                /* Mark whether or not we are nested within parens */
                ton.setNestedInParens(nestedInParens);
                {if (true) return ton;}
    throw new Error("Missing return statement in function");
  }

  final public int joinType() throws ParseException, StandardException {
        int joinType;
    switch (jj_nt.kind) {
    case INNER:
      jj_consume_token(INNER);
                {if (true) return JoinNode.INNERJOIN;}
      break;
    case LEFT:
    case RIGHT:
      joinType = outerJoinType();
      switch (jj_nt.kind) {
      case OUTER:
        jj_consume_token(OUTER);
        break;
      default:
        jj_la1[194] = jj_gen;
        ;
      }
                {if (true) return joinType;}
      break;
    default:
      jj_la1[195] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int outerJoinType() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case LEFT:
      jj_consume_token(LEFT);
                {if (true) return JoinNode.LEFTOUTERJOIN;}
      break;
    case RIGHT:
      jj_consume_token(RIGHT);
                {if (true) return JoinNode.RIGHTOUTERJOIN;}
      break;
    default:
      jj_la1[196] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Object[] joinSpecification(ResultSetNode leftRSN, ResultSetNode rightRSN) throws ParseException, StandardException {
        Object[]                        onOrUsingClause = new Object[ON_OR_USING_CLAUSE_SIZE];
        ResultColumnList        usingClause = null;
        ValueNode                       joinClause = null;
    joinClause = joinCondition();
                onOrUsingClause[ON_CLAUSE] = joinClause;
                onOrUsingClause[USING_CLAUSE] = usingClause;
                {if (true) return onOrUsingClause;}
    throw new Error("Missing return statement in function");
  }

  final public ValueNode joinCondition() throws ParseException, StandardException {
        ValueNode joinClause;
    jj_consume_token(ON);
    joinClause = valueExpression(false);
                {if (true) return joinClause;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableValueConstructor">tableValueConstructor</A>
 */
  final public ResultSetNode tableValueConstructor() throws ParseException, StandardException {
        ResultSetNode   resultSetNode;
    jj_consume_token(VALUES);
    resultSetNode = tableValueConstructorList();
                {if (true) return resultSetNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableValueConstructorList">tableValueConstructorList</A>
 */
  final public ResultSetNode tableValueConstructorList() throws ParseException, StandardException {
        ResultSetNode   resultSetNode;
    resultSetNode = rowValueConstructor(null);
    label_32:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[197] = jj_gen;
        break label_32;
      }
      jj_consume_token(COMMA);
      resultSetNode = rowValueConstructor(resultSetNode);
    }
                if (resultSetNode instanceof UnionNode)
                {
                        ((UnionNode) resultSetNode).markTopTableConstructor();
                }

                {if (true) return resultSetNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="explicitTable">explicitTable</A>
 */

/*
 * <A NAME="datetimeValueFunction">datetimeValueFunction</A>
 */
  final public ValueNode datetimeValueFunction() throws ParseException, StandardException {
        int prec = -1;
    if ((getToken(1).kind == CURRENT && getToken(2).kind == DATE)) {
      jj_consume_token(CURRENT);
      jj_consume_token(DATE);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                                ReuseFactory.getInteger(
                                                                        CurrentDatetimeOperatorNode.CURRENT_DATE),
                                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case CURRENT_DATE:
        jj_consume_token(CURRENT_DATE);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                                ReuseFactory.getInteger(
                                                                        CurrentDatetimeOperatorNode.CURRENT_DATE),
                                                                getContextManager());}
        break;
      default:
        jj_la1[198] = jj_gen;
        if ((getToken(1).kind == CURRENT && getToken(2).kind == TIME)) {
          jj_consume_token(CURRENT);
          jj_consume_token(TIME);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                        ReuseFactory.getInteger(
                                                                CurrentDatetimeOperatorNode.CURRENT_TIME),
                                                        getContextManager());}
        } else {
          switch (jj_nt.kind) {
          case CURRENT_TIME:
            jj_consume_token(CURRENT_TIME);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                        ReuseFactory.getInteger(
                                                                CurrentDatetimeOperatorNode.CURRENT_TIME),
                                                        getContextManager());}
            break;
          default:
            jj_la1[199] = jj_gen;
            if ((getToken(1).kind == CURRENT && getToken(2).kind == TIMESTAMP)) {
              jj_consume_token(CURRENT);
              jj_consume_token(TIMESTAMP);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                        ReuseFactory.getInteger(
                                                                CurrentDatetimeOperatorNode.CURRENT_TIMESTAMP),
                                                        getContextManager());}
            } else {
              switch (jj_nt.kind) {
              case CURRENT_TIMESTAMP:
                jj_consume_token(CURRENT_TIMESTAMP);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                        ReuseFactory.getInteger(
                                                                CurrentDatetimeOperatorNode.CURRENT_TIMESTAMP),
                                                        getContextManager());}
                break;
              default:
                jj_la1[200] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
** Note that set function and aggregate are used
** interchangeably in the parser.  The tree has
** aggregate nodes.
*/
  final public ValueNode aggregateNode() throws ParseException, StandardException {
        ValueNode agg;
    switch (jj_nt.kind) {
    case COUNT:
      jj_consume_token(COUNT);
      jj_consume_token(LEFT_PAREN);
      switch (jj_nt.kind) {
      case ASTERISK:
        jj_consume_token(ASTERISK);
                        agg = (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.AGGREGATE_NODE,
                                                                null,
                                                                CountAggregateDefinition.class,
                                                                Boolean.FALSE,
                                                                "COUNT(*)",
                                                                getContextManager());
        break;
      default:
        jj_la1[201] = jj_gen;
        if (jj_2_42(1)) {
          agg = aggregateExpression("COUNT", CountAggregateDefinition.class);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RIGHT_PAREN);
                {if (true) return agg;}
      break;
    case AVG:
    case MAX:
    case MIN:
    case SUM:
      agg = generalAggregate();
                {if (true) return agg;}
      break;
    default:
      jj_la1[202] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode aggregateExpression(String aggName, Class aggClass) throws ParseException, StandardException {
        boolean         distinct = false;
        ValueNode       value;
    if (jj_2_43(1)) {
      distinct = setQuantifier();
    } else {
      ;
    }
    value = additiveExpression(null, 0, false);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.AGGREGATE_NODE,
                                                                value,
                                                                aggClass,
                                                                distinct ? Boolean.TRUE : Boolean.FALSE,
                                                                aggName,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public ValueNode generalAggregate() throws ParseException, StandardException {
        Token                   aggToken;
        String                  methodAliasString;
        ValueNode       aggExpr;
        ValueNode               value;
    aggToken = builtInAggregateType();
    jj_consume_token(LEFT_PAREN);
    aggExpr = aggregateExpression(aggName(aggToken), aggClass(aggToken));
    jj_consume_token(RIGHT_PAREN);
                {if (true) return aggExpr;}
    throw new Error("Missing return statement in function");
  }

/*
** All built in aggregates are pretty similar to user
** defined aggregates, except we know what to map to
** without looking up the class name.
**
** NOTE: COUNT is omitted here because the COUNT aggregate is
** factored into a different rule, to distinguish between
** COUNT(*) and COUNT(<expression>).
*/
  final public Token builtInAggregateType() throws ParseException, StandardException {
        Token   retval;
    switch (jj_nt.kind) {
    case MAX:
      retval = jj_consume_token(MAX);
      break;
    case AVG:
      retval = jj_consume_token(AVG);
      break;
    case MIN:
      retval = jj_consume_token(MIN);
      break;
    case SUM:
      retval = jj_consume_token(SUM);
      break;
    default:
      jj_la1[203] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return retval;}
    throw new Error("Missing return statement in function");
  }

  final public ValueNode castSpecification() throws ParseException, StandardException {
        DataTypeDescriptor dts;
        ValueNode                treeTop;
        ValueNode                value;
        int                              charType;
        int                              length = -1;
    jj_consume_token(CAST);
    jj_consume_token(LEFT_PAREN);
    value = castOperand();
    jj_consume_token(AS);
    dts = dataTypeCast();
    jj_consume_token(RIGHT_PAREN);
                treeTop = (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.CAST_NODE,
                                                                        value,
                                                                        dts,
                                                                        getContextManager());
                ((CastNode) treeTop).setForExternallyGeneratedCASTnode();

                /* We need to generate a SQL->Java conversion tree above us if
		 * the dataTypeCast is a user type.
		 */
                if (dts.getTypeId().userType())
                {
                        treeTop = (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                        nodeFactory.getNode(
                                                                                        C_NodeTypes.SQL_TO_JAVA_VALUE_NODE,
                                                                                        treeTop,
                                                                                        getContextManager()),
                                                        getContextManager());
                }

                {if (true) return treeTop;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="charOrVarchar">charOrVarchar</A>
 */
  final public int charOrVarchar() throws ParseException {
    switch (jj_nt.kind) {
    case CHAR:
      jj_consume_token(CHAR);
                {if (true) return Types.CHAR;}
      break;
    case VARCHAR:
      jj_consume_token(VARCHAR);
                {if (true) return Types.VARCHAR;}
      break;
    default:
      jj_la1[204] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode castOperand() throws ParseException, StandardException {
        ValueNode value;
    if (jj_2_44(1)) {
      value = additiveExpression(null, 0, false);
                {if (true) return value;}
    } else {
      switch (jj_nt.kind) {
      case NULL:
        jj_consume_token(NULL);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                        getContextManager());}
        break;
      default:
        jj_la1[205] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dynamicParameterSpecification">dynamicParameterSpecification</A>
 */
  final public ParameterNode dynamicParameterSpecification() throws ParseException, StandardException {
    jj_consume_token(QUESTION_MARK);
                {if (true) return makeParameterNode( );}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="whereClause">whereClause</A>
 */
  final public ValueNode whereClause(Token beginToken) throws ParseException, StandardException {
        ValueNode       value;
        Token           endToken;
    /* valueExpression() was searchCondition() */
            value = valueExpression(false);
                endToken = getToken(0);

                value.setBeginOffset( beginToken.endOffset + 1 );
                value.setEndOffset( endToken.endOffset );

                {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public GroupByList groupByClause() throws ParseException, StandardException {
        GroupByList groupingCols;
    jj_consume_token(GROUP);
    jj_consume_token(BY);
    groupingCols = groupingColumnReferenceList();
                {if (true) return groupingCols;}
    throw new Error("Missing return statement in function");
  }

  final public GroupByList groupingColumnReferenceList() throws ParseException, StandardException {
        GroupByList groupingCols = (GroupByList) nodeFactory.getNode(
                                                                        C_NodeTypes.GROUP_BY_LIST,
                                                                        getContextManager());
    groupingColumnReference(groupingCols);
    label_33:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[206] = jj_gen;
        break label_33;
      }
      jj_consume_token(COMMA);
      groupingColumnReference(groupingCols);
    }
                {if (true) return groupingCols;}
    throw new Error("Missing return statement in function");
  }

  final public void groupingColumnReference(GroupByList groupingCols) throws ParseException, StandardException {
        ValueNode columnExpression;
    columnExpression = additiveExpression(null, 0, false);
                if (columnExpression.isParameterNode())
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "?");}
                }
                if (columnExpression instanceof AggregateNode)
                {
                        AggregateNode agNode = (AggregateNode)columnExpression;
                        {if (true) throw StandardException.newException(
                                SQLState.LANG_AGGREGATE_IN_GROUPBY_LIST,
                                agNode.getAggregateName());}
                }
                groupingCols.addGroupByColumn(
                        (GroupByColumn) nodeFactory.getNode(
                                                        C_NodeTypes.GROUP_BY_COLUMN,
                                                        columnExpression,
                                                        getContextManager()));
  }

  final public ValueNode havingClause() throws ParseException, StandardException {
        ValueNode value;
    jj_consume_token(HAVING);
    value = valueExpression(false);
                {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode schemaDefinition() throws ParseException, StandardException {
        String  schemaName = null;
        String  authName = null;
    jj_consume_token(SCHEMA);
    switch (jj_nt.kind) {
    case BINARY:
    case COALESCE:
    case COUNT:
    case D:
    case MODULE:
    case T:
    case TS:
    case VALUE:
    case VARBINARY:
    case ABS:
    case ABSVAL:
    case ACTION:
    case ALWAYS:
    case BLOB:
    case C:
    case CALLED:
    case CLOB:
    case COBOL:
    case COMMITTED:
    case CONCAT:
    case CONTAINS:
    case DATA:
    case DATE:
    case DAY:
    case DYNAMIC:
    case FORTRAN:
    case GENERATED:
    case IDENTITY_VAL_LOCAL:
    case INCREMENT:
    case INITIAL:
    case INTERVAL:
    case LANGUAGE:
    case LARGE:
    case LENGTH:
    case LEVEL:
    case LOCKS:
    case LOCKSIZE:
    case LOGGED:
    case MOD:
    case MODIFIES:
    case MODIFY:
    case MONTH:
    case _MORE:
    case MUMPS:
    case NAME:
    case NCLOB:
    case NULLABLE:
    case NUMBER:
    case OBJECT:
    case PASCAL:
    case PLI:
    case PRECISION:
    case RELEASE:
    case REPEATABLE:
    case RESTART:
    case RETURNS:
    case ROW:
    case SAVEPOINT:
    case SCALE:
    case SERIALIZABLE:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case START:
    case STATEMENT:
    case SYNONYM:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TRUNCATE:
    case TYPE:
    case UNCOMMITTED:
    case USAGE:
    case WHEN:
    case CURDATE:
    case CURTIME:
    case DATABASE:
    case LONG:
    case AFTER:
    case BEFORE:
    case CLASS:
    case COMPRESS:
    case CONTENT:
    case CS:
    case DB2SQL:
    case DIRTY:
    case DOCUMENT:
    case EACH:
    case EMPTY:
    case EXCLUSIVE:
    case FN:
    case INDEX:
    case JAVA:
    case LCASE:
    case LOCATE:
    case LOCK:
    case MESSAGE_LOCALE:
    case METHOD:
    case MODE:
    case NEW:
    case NEW_TABLE:
    case OJ:
    case OFF:
    case OLD:
    case OLD_TABLE:
    case PARAMETER:
    case PASSING:
    case PROPERTIES:
    case READS:
    case REF:
    case REFERENCING:
    case RENAME:
    case RESET:
    case RESULT:
    case RETAIN:
    case RETURNING:
    case RR:
    case RS:
    case SEQUENCE:
    case SEQUENTIAL:
    case SETS:
    case SHARE:
    case SQLID:
    case SPECIFIC:
    case SQRT:
    case STABILITY:
    case STRIP:
    case STYLE:
    case TRIGGER:
    case UCASE:
    case UR:
    case WHITESPACE:
    case IDENTIFIER:
    case DELIMITED_IDENTIFIER:
      schemaName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      switch (jj_nt.kind) {
      case AUTHORIZATION:
        jj_consume_token(AUTHORIZATION);
        authName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
        break;
      default:
        jj_la1[207] = jj_gen;
        ;
      }
                        if (authName != null)
                                checkVersion( DataDictionary.DD_VERSION_DERBY_10_2, "AUTHORIZATION");

                        if (schemaName.startsWith("SYS"))
                                {if (true) throw StandardException.newException(SQLState.INVALID_SCHEMA_SYS, schemaName);}

                        {if (true) return (StatementNode) nodeFactory.getNode(
                                        C_NodeTypes.CREATE_SCHEMA_NODE,
                                        schemaName,
                                        authName,
                                        getContextManager()
                                        );}
      break;
    case AUTHORIZATION:
      jj_consume_token(AUTHORIZATION);
      authName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                        checkVersion( DataDictionary.DD_VERSION_DERBY_10_2, "AUTHORIZATION");
                        if (authName.startsWith("SYS"))
                                {if (true) throw StandardException.newException(SQLState.INVALID_SCHEMA_SYS, authName);}

                        {if (true) return (StatementNode) nodeFactory.getNode(
                                        C_NodeTypes.CREATE_SCHEMA_NODE,
                                        authName,
                                        authName,
                                        getContextManager()
                                        );}
      break;
    default:
      jj_la1[208] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableDefinition">tableDefinition</A>
 */
  final public StatementNode tableDefinition() throws ParseException, StandardException {
        char                            lockGranularity = TableDescriptor.DEFAULT_LOCK_GRANULARITY;
        Properties                      properties = null;
        TableName                       tableName;
        TableElementList        tableElementList;
        ResultColumnList        resultColumns = null;
        ResultSetNode           queryExpression;
        boolean                         withData = true;
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    if (getToken(1).kind == LEFT_PAREN &&
                               getToken(3).kind != COMMA &&
                               getToken(3).kind != RIGHT_PAREN) {
      tableElementList = tableElementList();
      switch (jj_nt.kind) {
      case DERBYDASHPROPERTIES:
        properties = propertyList(false);
        jj_consume_token(CHECK_PROPERTIES);
        break;
      default:
        jj_la1[209] = jj_gen;
        ;
      }
                                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                                C_NodeTypes.CREATE_TABLE_NODE,
                                                                                tableName,
                                                                                tableElementList,
                                                                                properties,
                                                                                new Character(lockGranularity),
                                                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case AS:
      case LEFT_PAREN:
        switch (jj_nt.kind) {
        case LEFT_PAREN:
          jj_consume_token(LEFT_PAREN);
          resultColumns = tableColumnList();
          jj_consume_token(RIGHT_PAREN);
          break;
        default:
          jj_la1[210] = jj_gen;
          ;
        }
        jj_consume_token(AS);
        queryExpression = queryExpression(null, NO_SET_OP);
        jj_consume_token(WITH);
        switch (jj_nt.kind) {
        case NO:
          jj_consume_token(NO);
                                        withData = false;
          break;
        default:
          jj_la1[211] = jj_gen;
          ;
        }
        jj_consume_token(DATA);
                                // Raise error if WITH DATA is specified
                                // (until it is implemented)
                                if (withData) {
                                        {if (true) throw StandardException.newException(
                                                SQLState.NOT_IMPLEMENTED, "WITH DATA");}
                                }
                                /* Parameters not allowed in create table */
                                HasNodeVisitor visitor =
                                        new HasNodeVisitor(ParameterNode.class);
                                queryExpression.accept(visitor);
                                if (visitor.hasNode())
                                {
                                        {if (true) throw StandardException.newException(
                                                SQLState.LANG_NO_PARAMS_IN_TABLES);}
                                }

                                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                                C_NodeTypes.CREATE_TABLE_NODE,
                                                                                tableName,
                                                                                resultColumns,
                                                                                queryExpression,
                                                                                getContextManager());}
        break;
      default:
        jj_la1[212] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public ResultColumnList tableColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumns = (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
    columnNameList(resultColumns);
                {if (true) return resultColumns;}
    throw new Error("Missing return statement in function");
  }

/*
 * This method is called when a comment starting with --derby-properties is found.
 * Such a comment is a special directive to Derby and allows a sql to pass optimizer
 * overrides. Derby looks for propertyName=value [,propertyName=value]* after
 * --derby-properties and returns these properties in a Properties object as a return 
 * value of this method.
 * The param propertiesUseAllowed true indicates that users are allowed to 
 * specify optimizer overrides in the given context. 
 * False means optimizer overrides in the given context are allowed internally 
 * only eg impl/load/import.java specifies property insertMode=replace/bulkInsert
 * in the insert statement. This same property will not be acceptable from an 
 * insert statement from a user sql.
 */
  final public Properties propertyList(boolean propertiesUseAllowed) throws ParseException, StandardException {
        Properties properties = new FormatableProperties();
        StringTokenizer commaSeparatedProperties;
        StringTokenizer equalOperatorSeparatedProperty;
    jj_consume_token(DERBYDASHPROPERTIES);
                //first use StringTokenizer to get tokens which are delimited by ,s
                commaSeparatedProperties = new StringTokenizer(getToken(1).image,",");
                while (commaSeparatedProperties.hasMoreTokens()) {
                        //Now verify that tokens delimited by ,s follow propertyName=value pattern
                        String currentProperty = commaSeparatedProperties.nextToken();
                        equalOperatorSeparatedProperty = new StringTokenizer(currentProperty,"=", true);
                        if (equalOperatorSeparatedProperty.countTokens() != 3)
                                {if (true) throw StandardException.newException(SQLState.PROPERTY_SYNTAX_INVALID);}
                        else {
                                String key = equalOperatorSeparatedProperty.nextToken().trim();
                                if (!equalOperatorSeparatedProperty.nextToken().equals("="))
                                        {if (true) throw StandardException.newException(SQLState.PROPERTY_SYNTAX_INVALID);}
                                String value = equalOperatorSeparatedProperty.nextToken().trim();
                                verifyImageLength(value);
                                /* Trim off the leading and trailing ', and compress all '' to ' */
                                if (value.startsWith("'") && value.endsWith("'"))
                                        value = compressQuotes(value.substring(1, value.length() - 1), SINGLEQUOTES);
                                /* Trim off the leading and trailing ", and compress all "" to " */
                                else if (value.startsWith("\"") && value.endsWith("\""))
                                        value = compressQuotes(value.substring(1, value.length() - 1), DOUBLEQUOTES);
                                else
                                        value = value.toUpperCase();
                                // Do not allow user to specify multiple values for the same key
                                if (properties.put(key, value) != null)
                                {
                                        {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, key);}
                                }
                }
        }
        //if this property override is supported in internal mode only, then do that verification here.
        if (!propertiesUseAllowed)
                checkInternalFeature("DERBY-PROPERTIES");
        {if (true) return properties;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="DB2lockGranularityClause">DB2lockGranularityClause</A>
 */
  final public char DB2lockGranularityClause() throws ParseException, StandardException {
        char lockGranularity;
    jj_consume_token(LOCKSIZE);
    lockGranularity = lockGranularity();
                {if (true) return lockGranularity;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="lockGranularity">lockGranularity</A>
 */
  final public char lockGranularity() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case TABLE:
      jj_consume_token(TABLE);
                {if (true) return TableDescriptor.TABLE_LOCK_GRANULARITY;}
      break;
    case ROW:
      jj_consume_token(ROW);
                {if (true) return TableDescriptor.ROW_LOCK_GRANULARITY;}
      break;
    default:
      jj_la1[213] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="indexDefinition">indexDefinition</A>
 */
  final public StatementNode indexDefinition() throws ParseException, StandardException {
        Boolean         unique = Boolean.FALSE;
        Properties      properties = null;
        TableName       indexName;
        TableName       tableName;
        Vector  indexColumnList = new Vector();
    switch (jj_nt.kind) {
    case UNIQUE:
      unique = unique();
      break;
    default:
      jj_la1[214] = jj_gen;
      ;
    }
    jj_consume_token(INDEX);
    indexName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(ON);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(LEFT_PAREN);
    indexColumnList(indexColumnList);
    jj_consume_token(RIGHT_PAREN);
    switch (jj_nt.kind) {
    case DERBYDASHPROPERTIES:
      properties = propertyList(false);
      jj_consume_token(CHECK_PROPERTIES);
      break;
    default:
      jj_la1[215] = jj_gen;
      ;
    }
                /* User allowed to specify schema name on table and index.
		 * If no schema name specified for index, then it "inherits" 
		 * its schema name from the table.
		 * If index has a schema name and table does not, then
		 * table "inherits" its schema name from the index.
		 * If schema names are specified for both objects, then the
		 * schema names must be the same.
		 */
                if (indexName.getSchemaName() == null)
                {
                        indexName.setSchemaName(tableName.getSchemaName());
                }
                else if (tableName.getSchemaName() == null)
                {
                        tableName.setSchemaName(indexName.getSchemaName());
                }
                else
                {
                        /* schema name specified for both */
                        if (! (indexName.getSchemaName().equals(
                                                tableName.getSchemaName())))
                        {
                                {if (true) throw StandardException.newException(SQLState.LANG_INDEX_AND_TABLE_IN_DIFFERENT_SCHEMAS,
                                                        indexName,
                                                        tableName);}
                        }
                }
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_INDEX_NODE,
                                                                unique,
                                                                DEFAULT_INDEX_TYPE,
                                                                indexName,
                                                                tableName,
                                                                indexColumnList,
                                                                properties,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="unique">unique</A>
 */
  final public Boolean unique() throws ParseException, StandardException {
    jj_consume_token(UNIQUE);
                {if (true) return Boolean.TRUE;}
    throw new Error("Missing return statement in function");
  }

/**
	CREATE PROCEDURE

	procedureElements contains the description of the procedure.
	(CREATE FUNCTIONS shares this lyout), see functionDefinition

	0 - Object[] 3 element array for parameters
	1 - TableName - specific name
	2 - Integer - dynamic result set count
	3 - String language (always java) - ignore
	4 - String external name (also passed directly to create alias node - ignore
	5 - Short parameter style (always java) - ignore 
	6 - Short - SQL allowed.
	7 - Boolean - CALLED ON NULL INPUT (always TRUE for procedures)
	8 - TypeDescriptor - return type (always NULL for procedures)
*/
  final public StatementNode procedureDefinition() throws ParseException, StandardException {
        TableName procedureName;
        Object[] procedureElements = new Object[9];
    jj_consume_token(PROCEDURE);
    procedureName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    procedureElements[0] = procedureParameterList();
    label_34:
    while (true) {
      routineElement(true, procedureElements);
      switch (jj_nt.kind) {
      case EXTERNAL:
      case NO:
      case CALLED:
      case CONTAINS:
      case DYNAMIC:
      case LANGUAGE:
      case MODIFIES:
      case RETURNS:
      case PARAMETER:
      case READS:
      case RESULT:
      case SPECIFIC:
        ;
        break;
      default:
        jj_la1[216] = jj_gen;
        break label_34;
      }
    }
                    checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, procedureElements);

                        {if (true) return getCreateAliasNode(
                                                        procedureName,
                                                        (String) procedureElements[4],
                                                        procedureElements,
                                                        AliasInfo.ALIAS_TYPE_PROCEDURE_AS_CHAR,
                                                        Boolean.FALSE);}
    throw new Error("Missing return statement in function");
  }

  final public void routineElement(boolean isProcedure, Object[] routineElements) throws ParseException, StandardException {
        int drs;
        int clausePosition = -1;
        Object clauseValue = null;
    switch (jj_nt.kind) {
    case SPECIFIC:
      jj_consume_token(SPECIFIC);
      clauseValue = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                          clausePosition = 1; {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, "SPECIFIC identifier");}
      break;
    case DYNAMIC:
    case RESULT:
      switch (jj_nt.kind) {
      case DYNAMIC:
        jj_consume_token(DYNAMIC);
        break;
      default:
        jj_la1[217] = jj_gen;
        ;
      }
      jj_consume_token(RESULT);
      jj_consume_token(SETS);
      drs = uint_value();
                        if (!isProcedure)
                                {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "RESULT SETS");}
                        clauseValue = ReuseFactory.getInteger(drs); clausePosition = 2;
      break;
    case LANGUAGE:
      jj_consume_token(LANGUAGE);
      jj_consume_token(JAVA);
                                     clauseValue = "JAVA"; clausePosition = 3;
      break;
    case EXTERNAL:
      jj_consume_token(EXTERNAL);
      jj_consume_token(NAME);
      clauseValue = string();
                                                           clausePosition = 4;
      break;
    case PARAMETER:
      jj_consume_token(PARAMETER);
      jj_consume_token(STYLE);
      clauseValue = parameterStyle();
                                                                     clausePosition = 5;
      break;
    case NO:
      jj_consume_token(NO);
      jj_consume_token(SQL);
                                                          clauseValue = ReuseFactory.getShort(RoutineAliasInfo.NO_SQL); clausePosition = 6;
      break;
    case CONTAINS:
      jj_consume_token(CONTAINS);
      jj_consume_token(SQL);
                                                  clauseValue = ReuseFactory.getShort(RoutineAliasInfo.CONTAINS_SQL); clausePosition = 6;
      break;
    case READS:
      jj_consume_token(READS);
      jj_consume_token(SQL);
      jj_consume_token(DATA);
                                          clauseValue = ReuseFactory.getShort(RoutineAliasInfo.READS_SQL_DATA); clausePosition = 6;
      break;
    case MODIFIES:
      jj_consume_token(MODIFIES);
      jj_consume_token(SQL);
      jj_consume_token(DATA);
                        if (!isProcedure)
                                {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "MODIFIES SQL DATA");}
                        clauseValue = ReuseFactory.getShort(RoutineAliasInfo.MODIFIES_SQL_DATA); clausePosition = 6;
      break;
    case CALLED:
    case RETURNS:
      clauseValue = calledOnNullInput(isProcedure);
                                                           clausePosition = 7;
      break;
    default:
      jj_la1[218] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if (clausePosition != -1) {
                        // check for repeated clause
                        if (routineElements[clausePosition] != null) {

                                String which = ROUTINE_CLAUSE_NAMES[clausePosition];
                                {if (true) throw StandardException.newException(SQLState.LANG_DB2_MULTIPLE_ELEMENTS, which);}
                        }

                        routineElements[clausePosition] = clauseValue;
                }
  }

  final public Boolean calledOnNullInput(boolean isProcedure) throws ParseException, StandardException {
        Boolean calledOnNull;
    switch (jj_nt.kind) {
    case CALLED:
      jj_consume_token(CALLED);
                           calledOnNull = Boolean.TRUE;
      break;
    case RETURNS:
      jj_consume_token(RETURNS);
      jj_consume_token(NULL);
                   if (isProcedure)
                     {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR,
                             "RETURNS NULL ON NULL INPUT");}

                   calledOnNull = Boolean.FALSE;
      break;
    default:
      jj_la1[219] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    jj_consume_token(NULL);
    jj_consume_token(INPUT);
                {if (true) return calledOnNull;}
    throw new Error("Missing return statement in function");
  }

  final public Short parameterStyle() throws ParseException {
    jj_consume_token(JAVA);
                                 {if (true) return ReuseFactory.getShort(RoutineAliasInfo.PS_JAVA);}
    throw new Error("Missing return statement in function");
  }

  final public Object[] procedureParameterList() throws ParseException, StandardException {
        Vector[] list = new Vector[3];
        list[0] = new Vector(); // name
        list[1] = new Vector(); // type
        list[2] = new Vector();
    jj_consume_token(LEFT_PAREN);
    if (jj_2_45(1)) {
      procedureParameterDefinition(list);
      label_35:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[220] = jj_gen;
          break label_35;
        }
        jj_consume_token(COMMA);
        procedureParameterDefinition(list);
      }
    } else {
      ;
    }
    jj_consume_token(RIGHT_PAREN);
                {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="Definition">procedureParameterDefinition</A>
 */
  final public void procedureParameterDefinition(Vector[] list) throws ParseException, StandardException {
        DataTypeDescriptor      typeDescriptor;
        String                          parameterName = "";
        Integer                         inout;
    inout = inoutParameter();
    if (commonDatatypeName(2, false)) {
      parameterName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    } else {
      ;
    }
    typeDescriptor = dataTypeDDL();
                list[0].addElement(parameterName);
                list[1].addElement(typeDescriptor);
                list[2].addElement(inout);
  }

  final public Integer inoutParameter() throws ParseException {
        int mode = JDBC30Translation.PARAMETER_MODE_IN;
    switch (jj_nt.kind) {
    case IN:
    case INOUT:
    case OUT:
      switch (jj_nt.kind) {
      case IN:
        jj_consume_token(IN);

        break;
      case OUT:
        jj_consume_token(OUT);
                          mode = JDBC30Translation.PARAMETER_MODE_OUT;
        break;
      case INOUT:
        jj_consume_token(INOUT);
                            mode = JDBC30Translation.PARAMETER_MODE_IN_OUT;
        break;
      default:
        jj_la1[221] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[222] = jj_gen;
      ;
    }
          {if (true) return ReuseFactory.getInteger(mode);}
    throw new Error("Missing return statement in function");
  }

/**
	CREATE FUNCTION

	functionElements contains the description of the function.

	0 - Object[] 3 element array for parameters
	1 - TableName - specific name
	2 - Integer - dynamic result set count - always 0
	3 - String language (always java) - required to be set
	4 - String external name (also passed directly to create alias node - ignore
	5 - Short parameter style (always java) - required to be set 
	6 - Short - SQL allowed.
	7 - Boolean - CALLED ON NULL INPUT
	8 - TypeDescriptor - return type
*/
  final public StatementNode functionDefinition() throws ParseException, StandardException {
        TableName functionName;
        Object[] functionElements = new Object[9];
    jj_consume_token(FUNCTION);
    functionName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    functionElements[0] = functionParameterList();
    jj_consume_token(RETURNS);
    functionElements[8] = dataTypeCommon();
    label_36:
    while (true) {
      routineElement(false, functionElements);
      switch (jj_nt.kind) {
      case EXTERNAL:
      case NO:
      case CALLED:
      case CONTAINS:
      case DYNAMIC:
      case LANGUAGE:
      case MODIFIES:
      case RETURNS:
      case PARAMETER:
      case READS:
      case RESULT:
      case SPECIFIC:
        ;
        break;
      default:
        jj_la1[223] = jj_gen;
        break label_36;
      }
    }
                    checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, functionElements);

                        {if (true) return getCreateAliasNode(
                                                        functionName,
                                                        (String) functionElements[4],
                                                        functionElements,
                                                        AliasInfo.ALIAS_TYPE_FUNCTION_AS_CHAR,
                                                        Boolean.FALSE);}
    throw new Error("Missing return statement in function");
  }

  final public Object[] functionParameterList() throws ParseException, StandardException {
        Vector[] list = new Vector[3];
        list[0] = new Vector(); // name
        list[1] = new Vector(); // type
        list[2] = new Vector();
    jj_consume_token(LEFT_PAREN);
    if (jj_2_46(1)) {
      functionParameterDefinition(list);
      label_37:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[224] = jj_gen;
          break label_37;
        }
        jj_consume_token(COMMA);
        functionParameterDefinition(list);
      }
    } else {
      ;
    }
    jj_consume_token(RIGHT_PAREN);
                {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="Definition">functionParameterDefinition</A>
 */
  final public void functionParameterDefinition(Vector[] list) throws ParseException, StandardException {
        DataTypeDescriptor      typeDescriptor;
        String                          parameterName = "";
        Integer                         inout;
    if (commonDatatypeName(2, false)) {
      parameterName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    } else {
      ;
    }
    typeDescriptor = dataTypeDDL();
                list[0].addElement(parameterName);
                list[1].addElement(typeDescriptor);
                list[2].addElement(ReuseFactory.getInteger(JDBC30Translation.PARAMETER_MODE_IN));
  }

  final public StatementNode viewDefinition(Token beginToken) throws ParseException, StandardException {
        int                                     checkOptionType;
        ResultColumnList        resultColumns = null;
        ResultSetNode           queryExpression;
        TableName                       tableName;
        Token                           checkTok = null;
        Token                           endToken;
    jj_consume_token(VIEW);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    switch (jj_nt.kind) {
    case LEFT_PAREN:
      jj_consume_token(LEFT_PAREN);
      resultColumns = viewColumnList();
      jj_consume_token(RIGHT_PAREN);
      break;
    default:
      jj_la1[225] = jj_gen;
      ;
    }
    jj_consume_token(AS);
    queryExpression = queryExpression(null, NO_SET_OP);
                checkOptionType = ViewDescriptor.NO_CHECK_OPTION;
                endToken = getToken(0);
                /* Parameters not allowed in create view */
                HasNodeVisitor visitor = new HasNodeVisitor(ParameterNode.class);
                queryExpression.accept(visitor);
                if (visitor.hasNode())
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_NO_PARAMS_IN_VIEWS);}
                }

                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_VIEW_NODE,
                                                                tableName,
                                                                resultColumns,
                                                                queryExpression,
                                                                ReuseFactory.getInteger(checkOptionType),
                                                                StringUtil.slice(statementSQLText,
                                                                                                beginToken.beginOffset,
                                                                                                endToken.endOffset,false),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public ResultColumnList viewColumnList() throws ParseException, StandardException {
        ResultColumnList        resultColumns = (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
    columnNameList(resultColumns);
                {if (true) return resultColumns;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode triggerDefinition() throws ParseException, StandardException {
        Boolean                         isBefore;
        Boolean                         isRow = Boolean.FALSE;  // STATEMENT implicit by default
        TableName                       tableName;
        TableName                       triggerName;
        Token[]                         tokenHolder = new Token[1];
        Token                           beginToken;
        Token                           checkTok = null;
        Token                           endToken;
        int                                     actionBegin;
        int                                     actionEnd;
        int                                     triggerEvent;
        QueryTreeNode           actionNode;
        ResultColumnList        triggerColumns = (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
        Vector                          refClause = null;
    jj_consume_token(TRIGGER);
    triggerName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    isBefore = beforeOrAfter();
    triggerEvent = triggerEvent(triggerColumns);
    jj_consume_token(ON);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    switch (jj_nt.kind) {
    case REFERENCING:
      refClause = triggerReferencingClause();
      break;
    default:
      jj_la1[226] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case FOR:
      jj_consume_token(FOR);
      jj_consume_token(EACH);
      isRow = rowOrStatement();
      break;
    default:
      jj_la1[227] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case MODE:
      jj_consume_token(MODE);
      jj_consume_token(DB2SQL);
      break;
    default:
      jj_la1[228] = jj_gen;
      ;
    }
    //we are not top level statement
                    actionNode = proceduralStatement(tokenHolder);
                actionEnd = getToken(0).endOffset;
                actionBegin = tokenHolder[0].beginOffset;

                // No DML in action node for BEFORE triggers.
                if (isBefore.booleanValue() && (actionNode instanceof DMLModStatementNode)) {
                                {if (true) throw StandardException.newException(
                                        SQLState.LANG_UNSUPPORTED_TRIGGER_STMT,
                                        ((StatementNode) actionNode).statementToString(), "BEFORE");}
                                        }


                // no params in trigger action
                HasNodeVisitor visitor = new HasNodeVisitor(ParameterNode.class);
                actionNode.accept(visitor);
                if (visitor.hasNode())
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_NO_PARAMS_IN_TRIGGER_ACTION);}
                }

                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_TRIGGER_NODE,
                                                                triggerName,
                                                                tableName,
                                                                ReuseFactory.getInteger(triggerEvent),
                                                                triggerColumns,
                                                                isBefore,
                                                                isRow,
                                                                Boolean.TRUE,                           // enabled
                                                                refClause,                      // referencing clause
                                                                null,// when clause node
                                                                null,           // when clause text
                                                                ReuseFactory.getInteger(0),
                                                                                        // when clause begin offset
                                                                actionNode,
                                                                StringUtil.slice(statementSQLText,
                                                                        actionBegin,
                                                                        actionEnd,false),
                                                                ReuseFactory.getInteger(actionBegin),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode synonymDefinition() throws ParseException, StandardException {
        TableName synonymName;
        TableName targetName;
    jj_consume_token(SYNONYM);
    synonymName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(FOR);
    targetName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                checkVersion(DataDictionary.DD_VERSION_DERBY_10_1,
                             "CREATE SYNONYM");

                {if (true) return  (StatementNode) getNodeFactory().getCreateAliasNode
                        (
                                synonymName,
                                targetName,
                                null,
                                AliasInfo.ALIAS_TYPE_SYNONYM_AS_CHAR,
                                Boolean.FALSE,
                                getContextManager()
                        );}
    throw new Error("Missing return statement in function");
  }

  final public Boolean beforeOrAfter() throws ParseException {
    switch (jj_nt.kind) {
    case NO:
      jj_consume_token(NO);
      jj_consume_token(CASCADE);
      jj_consume_token(BEFORE);
                {if (true) return Boolean.TRUE;}
      break;
    case AFTER:
      jj_consume_token(AFTER);
                {if (true) return Boolean.FALSE;}
      break;
    default:
      jj_la1[229] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int triggerEvent(ResultColumnList rcl) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case INSERT:
      jj_consume_token(INSERT);
                {if (true) return TriggerDescriptor.TRIGGER_EVENT_INSERT;}
      break;
    case DELETE:
      jj_consume_token(DELETE);
                {if (true) return TriggerDescriptor.TRIGGER_EVENT_DELETE;}
      break;
    case UPDATE:
      jj_consume_token(UPDATE);
      switch (jj_nt.kind) {
      case OF:
        jj_consume_token(OF);
        columnNameList(rcl);
        break;
      default:
        jj_la1[230] = jj_gen;
        ;
      }
                {if (true) return TriggerDescriptor.TRIGGER_EVENT_UPDATE;}
      break;
    default:
      jj_la1[231] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Boolean rowOrStatement() throws ParseException {
    switch (jj_nt.kind) {
    case ROW:
      token = jj_consume_token(ROW);
                {if (true) return Boolean.TRUE;}
      break;
    case STATEMENT:
      token = jj_consume_token(STATEMENT);
                {if (true) return Boolean.FALSE;}
      break;
    default:
      jj_la1[232] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Vector triggerReferencingClause() throws ParseException, StandardException {
        Vector vector = new Vector();
    jj_consume_token(REFERENCING);
    triggerReferencingExpression(vector);
    label_38:
    while (true) {
      switch (jj_nt.kind) {
      case NEW:
      case NEW_TABLE:
      case OLD:
      case OLD_TABLE:
        ;
        break;
      default:
        jj_la1[233] = jj_gen;
        break label_38;
      }
      triggerReferencingExpression(vector);
    }
                {if (true) return vector;}
    throw new Error("Missing return statement in function");
  }

  final public void triggerReferencingExpression(Vector vector) throws ParseException, StandardException {
        String  identifier;
        boolean isNew = true;
        boolean isRow = true;
    switch (jj_nt.kind) {
    case NEW:
      jj_consume_token(NEW);
      break;
    case OLD:
      jj_consume_token(OLD);
                 isNew = false;
      break;
    case NEW_TABLE:
      jj_consume_token(NEW_TABLE);
                        isRow = false;
      break;
    case OLD_TABLE:
      jj_consume_token(OLD_TABLE);
                        isNew = false; isRow = false;
      break;
    default:
      jj_la1[234] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(AS);
    identifier = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                vector.addElement(new TriggerReferencingStruct(isRow, isNew, identifier));
  }

/*
 * <A NAME="defaultClause">defaultClause</A>
 */
  final public ValueNode defaultClause(long[] autoIncrementInfo, String columnName) throws ParseException, StandardException {
        ValueNode       value;
        Token           beginToken;
        Token           endToken;
    switch (jj_nt.kind) {
    case _DEFAULT:
    case WITH:
      switch (jj_nt.kind) {
      case WITH:
        jj_consume_token(WITH);
        break;
      default:
        jj_la1[235] = jj_gen;
        ;
      }
      beginToken = jj_consume_token(_DEFAULT);
      value = defaultOption(beginToken, autoIncrementInfo, columnName);
                {if (true) return value;}
      break;
    case GENERATED:
      value = generatedColumnOption(autoIncrementInfo);
                {if (true) return value;}
      break;
    default:
      jj_la1[236] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="defaultNullOnlyClause">defaultNullOnlyClause</A>
 */
  final public ValueNode defaultNullOnlyClause() throws ParseException, StandardException {
    jj_consume_token(_DEFAULT);
    jj_consume_token(NULL);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="generatedColumnOption">generatedColumnOption</A>
 */

//ToCleanUp
//A specific class not such long[] should exists for autoIncrementInfo ...
  final public ValueNode generatedColumnOption(long[] autoIncrementInfo) throws ParseException, StandardException {
        ValueNode       value = null;
        autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_START_INDEX] = 1;
        autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_INC_INDEX] = 1;
        autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_AUTOINCREMENT_INDEX] = 1;
        autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_CREATE_MODIFY] = ColumnDefinitionNode.CREATE_AUTOINCREMENT;
    jj_consume_token(GENERATED);
    switch (jj_nt.kind) {
    case ALWAYS:
      jj_consume_token(ALWAYS);
                value = null;
      break;
    case BY:
      jj_consume_token(BY);
      jj_consume_token(_DEFAULT);
                checkVersion(DataDictionary.DD_VERSION_DERBY_10_1,
                             "GENERATED BY DEFAULT");

                value = (ValueNode) nodeFactory.getNode(C_NodeTypes.DEFAULT_NODE,
                                                        getContextManager()) ;
      break;
    default:
      jj_la1[237] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(AS);
    jj_consume_token(IDENTITY);
    switch (jj_nt.kind) {
    case LEFT_PAREN:
      jj_consume_token(LEFT_PAREN);
      autoIncrementBeginEnd(autoIncrementInfo);
      jj_consume_token(RIGHT_PAREN);
      break;
    default:
      jj_la1[238] = jj_gen;
      ;
    }
                {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="autoIncrementBeginEnd">autoIncrementBeginEnd</A>
 */
  final public void autoIncrementBeginEnd(long[] autoIncrementInfo) throws ParseException, StandardException {
        long            autoIncrementInitial = 1;
        long            autoIncrementIncrement = 1;
    switch (jj_nt.kind) {
    case INCREMENT:
      jj_consume_token(INCREMENT);
      jj_consume_token(BY);
      autoIncrementIncrement = exactNumber();
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_INC_INDEX] = autoIncrementIncrement;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_CREATE_MODIFY] = ColumnDefinitionNode.CREATE_AUTOINCREMENT;
                {if (true) return;}
      break;
    case START:
      jj_consume_token(START);
      jj_consume_token(WITH);
      autoIncrementInitial = exactNumber();
      switch (jj_nt.kind) {
      case COMMA:
        jj_consume_token(COMMA);
        jj_consume_token(INCREMENT);
        jj_consume_token(BY);
        autoIncrementIncrement = exactNumber();
        break;
      default:
        jj_la1[239] = jj_gen;
        ;
      }
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_START_INDEX] = autoIncrementInitial;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_INC_INDEX] = autoIncrementIncrement;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_CREATE_MODIFY] = ColumnDefinitionNode.CREATE_AUTOINCREMENT;
                {if (true) return;}
      break;
    default:
      jj_la1[240] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="defaultOption">defaultOption</A>
 */
  final public ValueNode defaultOption(Token beginToken, long[] autoIncrementInfo,
        String columnName) throws ParseException, StandardException {
        Token           endToken;
        Token           errorTok = null;
        Token           initialTok = null;
        ValueNode       value;
    if (getToken(1).kind == NULL && !(getToken(2).kind == PERIOD ||
                            getToken(2).kind == DOUBLE_COLON)) {
      jj_consume_token(NULL);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                        getContextManager());}
    } else if (jj_2_47(1)) {
      value = DB2DefaultOption(columnName);
                endToken = getToken(0);
                value.setBeginOffset( beginToken.beginOffset );
                value.setEndOffset( endToken.endOffset );
                value = (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.DEFAULT_NODE,
                                                                value,
                                                                StringUtil.slice(statementSQLText,
                                                                        beginToken.beginOffset + 7,
                                                                        endToken.endOffset,true),
                                                                getContextManager()
                                                        );
                {if (true) return value;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="DB2DefaultOption">DB2DefaultOption</A>
 */
  final public ValueNode DB2DefaultOption(String columnName) throws ParseException, StandardException {
        ValueNode       value;
    if (getToken(2).kind == SCHEMA || getToken(2).kind == SQLID) {
      jj_consume_token(CURRENT);
      switch (jj_nt.kind) {
      case SCHEMA:
        jj_consume_token(SCHEMA);
        break;
      case SQLID:
        jj_consume_token(SQLID);
        break;
      default:
        jj_la1[241] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.CURRENT_SCHEMA_NODE,
                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case USER:
        jj_consume_token(USER);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.USER_NODE,
                                                                getContextManager());}
        break;
      default:
        jj_la1[242] = jj_gen;
        if (getToken(1).kind == DATE ||
                        getToken(1).kind == TIME ||
                        getToken(1).kind == TIMESTAMP) {
          value = miscBuiltins();
          // these functions are allowed as valid <cast-function> defaults.
          // Once "BLOB" is allowed as a cast-function (5281), a case should be
          // added for that, as well.
                {if (true) return value;}
        } else if (getToken(2).kind == LEFT_PAREN ||
                               (getToken(4).kind == LEFT_PAREN &&
                                getToken(2).kind != COMMA)) {
          // Check against comma: see Derby-331 
                          // Before adding this, the following was erroneously
                          // flagged as invalid: 
                          //	   create table foo(.., b int default 0, unique (a))
                  value = miscBuiltins();
                // If we have a function (as indicated by an open paren,
                // which can be either the 2nd token (w/ normal function name)
                // or the 4th token (w/ qualified function name)), then
                // it's not valid.  Catch it here and throw an "invalid
                // default" error (42894) instead of letting it go as
                // a syntax error (this matches DB2 UDB behavior).
                {if (true) throw StandardException.newException(
                        SQLState.LANG_DB2_INVALID_DEFAULT_VALUE,
                        columnName);}
        } else if (jj_2_48(1)) {
          value = datetimeValueFunction();
                {if (true) return value;}
        } else {
          switch (jj_nt.kind) {
          case FALSE:
          case TRUE:
          case LEFT_BRACE:
          case PLUS_SIGN:
          case MINUS_SIGN:
          case EXACT_NUMERIC:
          case STRING:
          case HEX_STRING:
          case APPROXIMATE_NUMERIC:
            // Only (valid) thing left is literals (i.e. actual constants).
                    value = literal();
                {if (true) return value;}
            break;
          default:
            jj_la1[243] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="literal">literal</A>
 */
  final public ValueNode literal() throws ParseException, StandardException {
        String  sign = "";
        Token   tok;
        String  datetimeString;
        String  bitString;
        ValueNode               constantNode;
    switch (jj_nt.kind) {
    case PLUS_SIGN:
    case MINUS_SIGN:
    case EXACT_NUMERIC:
    case APPROXIMATE_NUMERIC:
      switch (jj_nt.kind) {
      case PLUS_SIGN:
      case MINUS_SIGN:
        sign = sign();
        break;
      default:
        jj_la1[244] = jj_gen;
        ;
      }
      constantNode = numericLiteral(sign);
                {if (true) return constantNode;}
      break;
    case STRING:
      constantNode = stringLiteral();
                {if (true) return  constantNode;}
      break;
    case HEX_STRING:
      constantNode = hexLiteral();
                {if (true) return  constantNode;}
      break;
    case LEFT_BRACE:
      constantNode = dateTimeLiteral();
                {if (true) return constantNode;}
      break;
    case FALSE:
    case TRUE:
      tok = booleanLiteral();
                checkInternalFeature(tok.image);
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.BOOLEAN_CONSTANT_NODE,
                                                                        StringUtil.SQLEqualsIgnoreCase(tok.image, "true") ?
                                                                                Boolean.TRUE : Boolean.FALSE,
                                                                        getContextManager());}
      break;
    default:
      jj_la1[245] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="numericLiteral">numericLiteral</A>
 */
  final public ValueNode numericLiteral(String sign) throws ParseException, StandardException {
        Token   tok;
    switch (jj_nt.kind) {
    case EXACT_NUMERIC:
      tok = jj_consume_token(EXACT_NUMERIC);
                /*
		** The various java parse utilities can't handle leading +,
		** so only concatenate leading -.
		*/

                String num = tok.image;

                if (sign.equals("-"))
                        num = sign.concat(num);

                {if (true) return getNumericNode(num);}
      break;
    case APPROXIMATE_NUMERIC:
      tok = jj_consume_token(APPROXIMATE_NUMERIC);
                StringBuffer doubleImage;
                String doubleString;
                int ePosn, dotPosn; // Position of letter e and '.' in value
                Double          doubleValue;

                doubleImage = new StringBuffer(sign);
                doubleImage.append(tok.image);
                doubleString = doubleImage.toString();

                ePosn = doubleString.indexOf('E');
                if (ePosn == -1)
                        ePosn = doubleString.indexOf('e');
                if (SanityManager.DEBUG)
                        SanityManager.ASSERT(ePosn != -1, "no E or e in approximate numeric");

                // there is a limit on the length of a floatingpoint literal in DB2
                if (doubleString.length() > Limits.DB2_MAX_FLOATINGPOINT_LITERAL_LENGTH)
                        {if (true) throw StandardException.newException(SQLState.LANG_DB2_TOO_LONG_FLOATING_POINT_LITERAL, doubleString, TypeId.DOUBLE_NAME);}
                // if there is no '.' before the e, put one in
                dotPosn = doubleString.substring(0,ePosn).indexOf('.');
                if (dotPosn == -1) {
                        doubleImage.insert(ePosn,'.');
                        doubleString = doubleImage.toString();
                        ePosn++;
                }

                try
                {
                        doubleValue = Double.valueOf(doubleString);

                }
                catch (NumberFormatException nfe)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_FORMAT_EXCEPTION, TypeId.DOUBLE_NAME);}
                }

                double dv = doubleValue.doubleValue();

                // When the value is 0 it's possible rounded, try to detect it by checking if the mantissa is 0.0
                //   "proof of correctness": any nonzero value (mantissa) with less than 30 characters will not be
                //                           rounded to 0.0 by a float/real. This correctly detects the case when
                //                           the radix/exponent being "too small" (1e-900) giving a value rounded to zero.
                if ( (dv == 0.0d) && (Double.parseDouble(doubleString.substring(0, ePosn-1)) != 0.0d) )
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_OUTSIDE_RANGE_FOR_DATATYPE, TypeId.DOUBLE_NAME);}
                }

                if (Double.isNaN(dv) || Double.isInfinite(dv))
                        {if (true) throw StandardException.newException(SQLState.LANG_OUTSIDE_RANGE_FOR_DATATYPE, TypeId.DOUBLE_NAME);}

                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.DOUBLE_CONSTANT_NODE,
                                                                        doubleValue,
                                                                        getContextManager());}
      break;
    default:
      jj_la1[246] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dateTimeLiteral">dateTimeLiteral</A>
 */
  final public ValueNode dateTimeLiteral() throws ParseException, StandardException {
        ValueNode       constantNode;
    jj_consume_token(LEFT_BRACE);
    constantNode = escapedDateTimeLiteral();
    jj_consume_token(RIGHT_BRACE);
                {if (true) return constantNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="escapedDateTimeLiteral">escapedDateTimeLiteral</A>
 */
  final public ValueNode escapedDateTimeLiteral() throws ParseException, StandardException {
        ValueNode constantNode;
    switch (jj_nt.kind) {
    case D:
      jj_consume_token(D);
      constantNode = bareDateLiteral();
                {if (true) return constantNode;}
      break;
    case T:
      jj_consume_token(T);
      constantNode = bareTimeLiteral();
                {if (true) return constantNode;}
      break;
    case TS:
      jj_consume_token(TS);
      constantNode = bareTimestampLiteral();
                {if (true) return constantNode;}
      break;
    default:
      jj_la1[247] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="bareDateLiteral">bareDateLiteral</A>
 */
  final public ValueNode bareDateLiteral() throws ParseException, StandardException {
        String dateString;
    dateString = string();
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.USERTYPE_CONSTANT_NODE,
                                                getLanguageConnectionContext().getDataValueFactory().getDateValue(dateString, true),
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="bareTimeLiteral">bareTimeLiteral</A>
 */
  final public ValueNode bareTimeLiteral() throws ParseException, StandardException {
        String timeString;
    timeString = string();
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.USERTYPE_CONSTANT_NODE,
                                                getLanguageConnectionContext().getDataValueFactory().getTimeValue(timeString, true),
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="bareTimestampLiteral">bareTimestampLiteral</A>
 */
  final public ValueNode bareTimestampLiteral() throws ParseException, StandardException {
        String timestampString;
    timestampString = string();
                {if (true) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.USERTYPE_CONSTANT_NODE,
                                                getLanguageConnectionContext().getDataValueFactory().getTimestampValue(timestampString, true),
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="string">string</A>
 */
  final public String string() throws ParseException, StandardException {
        Token   tok;
    tok = jj_consume_token(STRING);
                verifyImageLength(tok.image);
                /* Trim off the leading and trailing ', and compress all '' to ' */
                {if (true) return compressQuotes(tok.image.substring(1, tok.image.length() - 1),
                                                          SINGLEQUOTES);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="stringLiteral">stringLiteral</A>
 */
  final public CharConstantNode stringLiteral() throws ParseException, StandardException {
        Token   tok;
        String  string;
    tok = jj_consume_token(STRING);
                //there is a maximum limit on the length of the string
                if (tok.image.length()-2 > Limits.DB2_MAX_CHARACTER_LITERAL_LENGTH)//-2 is for the beginning and ending quote
                        {if (true) throw StandardException.newException(SQLState.LANG_DB2_STRING_CONSTANT_TOO_LONG, StringUtil.formatForPrint(tok.image));}
                string = compressQuotes(tok.image.substring(1, tok.image.length() - 1), SINGLEQUOTES);
                /* Trim quotes from string. */
                {if (true) return (CharConstantNode) nodeFactory.getNode(
                                                                C_NodeTypes.CHAR_CONSTANT_NODE,
                                                                string,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="hexLiteral">hexLiteral</A>
 */
  final public ValueNode hexLiteral() throws ParseException, StandardException {
        Token   tok;
    tok = jj_consume_token(HEX_STRING);
                String hexLiteral = tok.image;

                //there is a maximum limit on the length of the hex constant
                if (hexLiteral.length()-3 > Limits.DB2_MAX_HEX_LITERAL_LENGTH)//-3 is for X' at the beginning and ' at the end
                        {if (true) throw StandardException.newException(SQLState.LANG_DB2_STRING_CONSTANT_TOO_LONG, StringUtil.formatForPrint(hexLiteral));}
                if ((hexLiteral.length()-3)%2 == 1)
                        {if (true) throw StandardException.newException(SQLState.LANG_DB2_INVALID_HEXADECIMAL_CONSTANT, StringUtil.formatForPrint(hexLiteral));}

                int bitLength = ((hexLiteral.length() - 3) / 2);
                {if (true) return (ValueNode)
                                nodeFactory.getNode(C_NodeTypes.VARBIT_CONSTANT_NODE,
                                                                        hexLiteral.substring(2, hexLiteral.length() - 1), ReuseFactory.getInteger(bitLength),
                                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public TableName constraintNameDefinition() throws ParseException, StandardException {
        TableName constraintName;
    jj_consume_token(CONSTRAINT);
    constraintName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return constraintName;}
    throw new Error("Missing return statement in function");
  }

/*
 * DB2 requires column check constraints to refer to only that column. Derby
 * doesn't care if check constraints are column level or table level. For DB2 compatibility
 * check that column check constraints only refer to that column.
 */
  final public ConstraintDefinitionNode checkConstraintDefinition(TableName constraintName, String columnName) throws ParseException, StandardException {
        Token           beginToken;
        Token           endToken;
        ValueNode       value;
        ResultColumnList rclList = null;
    jj_consume_token(CHECK);
    beginToken = jj_consume_token(LEFT_PAREN);
    value = valueExpression(false);
    endToken = jj_consume_token(RIGHT_PAREN);
                if (columnName != null)
                {
                        /* Column check constraint */
                        rclList = (ResultColumnList) nodeFactory.getNode(
                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                        getContextManager());
                        rclList.addElement((ResultColumn) nodeFactory.getNode(
                                                                        C_NodeTypes.RESULT_COLUMN,
                                                                        columnName,
                                                                        null,
                                                                        getContextManager()));
                }

                value.setBeginOffset( beginToken.beginOffset );
                value.setEndOffset( endToken.endOffset );
                {if (true) return (ConstraintDefinitionNode) nodeFactory.getNode(
                                        C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                        constraintName,
                                        ReuseFactory.getInteger(DataDictionary.CHECK_CONSTRAINT),
                                        rclList,
                                        null,
                                        value,
                                        StringUtil.slice(statementSQLText,
                                                beginToken.beginOffset,
                                                endToken.endOffset,true),
                                        getContextManager()
                                        );}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="spsRenameStatement">spsRenameStatement</A>
 */
  final public StatementNode spsRenameStatement() throws ParseException, StandardException {
        StatementNode qtn;
    jj_consume_token(RENAME);
    switch (jj_nt.kind) {
    case TABLE:
      qtn = renameTableStatement();
      break;
    case INDEX:
      qtn = renameIndexStatement();
      break;
    case COLUMN:
      qtn = renameColumnStatement();
      break;
    default:
      jj_la1[248] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return qtn;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="renameTableStatement">renameTableStatement</A>
 */
  final public StatementNode renameTableStatement() throws ParseException, StandardException {
        StatementNode qtn;
        TableName tableName;
        String newTableName;
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(TO);
    newTableName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.RENAME_NODE,
                                                                tableName,
                                                                null,
                                                                newTableName,
                                                                Boolean.FALSE,
                                                                ReuseFactory.getInteger(StatementType.RENAME_TABLE),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="renameIndexStatement">renameIndexStatement</A>
 */
  final public StatementNode renameIndexStatement() throws ParseException, StandardException {
        String oldIndexName;
        String newIndexName;
    jj_consume_token(INDEX);
    oldIndexName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    jj_consume_token(TO);
    newIndexName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                StatementNode qtn = (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.RENAME_NODE,
                                                                null,
                                                                oldIndexName,
                                                                newIndexName,
                                                                Boolean.FALSE,
ReuseFactory.getInteger(StatementType.RENAME_INDEX),
                                                                getContextManager());

                {if (true) return qtn;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode renameColumnStatement() throws ParseException, StandardException {
        String newColumnName;
        ColumnReference oldColumnReference;
    jj_consume_token(COLUMN);
    oldColumnReference = columnReference();
    jj_consume_token(TO);
    newColumnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                if (oldColumnReference.getTableNameNode() == null)
                        {if (true) throw StandardException.newException(
                                SQLState.LANG_OBJECT_DOES_NOT_EXIST,
                                "RENAME COLUMN",
                                oldColumnReference.getColumnName());}
                {if (true) return (StatementNode) nodeFactory.getNode(
                        C_NodeTypes.RENAME_NODE,
                        oldColumnReference.getTableNameNode(),
                        oldColumnReference.getColumnName(),
                        newColumnName,
                        Boolean.FALSE,
                        ReuseFactory.getInteger(StatementType.RENAME_COLUMN),
                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode lockStatement() throws ParseException, StandardException {
        Boolean                                         exclusiveMode;
        TableName                                       tableName;
    jj_consume_token(LOCK);
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(IN);
    exclusiveMode = lockMode();
    jj_consume_token(MODE);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.LOCK_TABLE_NODE,
                                                                tableName,
                                                                exclusiveMode,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public Boolean lockMode() throws ParseException {
    switch (jj_nt.kind) {
    case EXCLUSIVE:
      jj_consume_token(EXCLUSIVE);
                {if (true) return Boolean.TRUE;}
      break;
    case SHARE:
      jj_consume_token(SHARE);
                {if (true) return Boolean.FALSE;}
      break;
    default:
      jj_la1[249] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public StatementNode execStatement() throws ParseException, StandardException {
        TableName       stmtName;
    jj_consume_token(EXECUTE);
    jj_consume_token(STATEMENT);
    stmtName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.EXEC_SPS_NODE,
                                                                stmtName,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public TransactionStatementNode setIsolationStatement() throws ParseException, StandardException {
        TransactionStatementNode tranNode;
    setIsolationHeader();
    switch (jj_nt.kind) {
    case TO:
    case EQUALS_OPERATOR:
      switch (jj_nt.kind) {
      case EQUALS_OPERATOR:
        jj_consume_token(EQUALS_OPERATOR);
        break;
      case TO:
        jj_consume_token(TO);
        break;
      default:
        jj_la1[250] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[251] = jj_gen;
      ;
    }
    tranNode = transactionMode();
                {if (true) return tranNode;}
    throw new Error("Missing return statement in function");
  }

  final public void setIsolationHeader() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case ISOLATION:
      jj_consume_token(ISOLATION);
      break;
    default:
      jj_la1[252] = jj_gen;
      if (getToken(1).kind == CURRENT && getToken(2).kind == ISOLATION) {
        jj_consume_token(CURRENT);
        jj_consume_token(ISOLATION);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public TransactionStatementNode transactionMode() throws ParseException, StandardException {
        int isolationLevel;
    isolationLevel = isolationLevelDB2OrReset();
                {if (true) return (TransactionStatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SET_TRANSACTION_ISOLATION_NODE,
                                                                ReuseFactory.getInteger(isolationLevel),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public int isolationLevelDB2OrReset() throws ParseException {
        int isolationLevel;
    switch (jj_nt.kind) {
    case RESET:
      jj_consume_token(RESET);
                          {if (true) return ExecutionContext.UNSPECIFIED_ISOLATION_LEVEL;}
      break;
    default:
      jj_la1[253] = jj_gen;
      if (jj_2_49(1)) {
        isolationLevel = isolationLevelDB2();
                                                         {if (true) return isolationLevel;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public int isolationLevelDB2() throws ParseException {
        int isolationLevel;
    switch (jj_nt.kind) {
    case CS:
    case RR:
    case RS:
    case UR:
      isolationLevel = isolationLevelDB2Abbrev();
                                                             {if (true) return isolationLevel;}
      break;
    case REPEATABLE:
    case SERIALIZABLE:
      switch (jj_nt.kind) {
      case REPEATABLE:
        jj_consume_token(REPEATABLE);
        jj_consume_token(READ);
        break;
      case SERIALIZABLE:
        jj_consume_token(SERIALIZABLE);
        break;
      default:
        jj_la1[254] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                          {if (true) return ExecutionContext.SERIALIZABLE_ISOLATION_LEVEL;}
      break;
    case CURSOR:
      jj_consume_token(CURSOR);
      jj_consume_token(STABILITY);
                          {if (true) return ExecutionContext.READ_COMMITTED_ISOLATION_LEVEL;}
      break;
    case DIRTY:
      jj_consume_token(DIRTY);
      jj_consume_token(READ);
                          {if (true) return ExecutionContext.READ_UNCOMMITTED_ISOLATION_LEVEL;}
      break;
    default:
      jj_la1[255] = jj_gen;
      if (getToken(1).kind == READ && getToken(2).kind == COMMITTED) {
        jj_consume_token(READ);
        jj_consume_token(COMMITTED);
                          {if (true) return ExecutionContext.READ_COMMITTED_ISOLATION_LEVEL;}
      } else if (getToken(1).kind == READ && getToken(2).kind == UNCOMMITTED) {
        jj_consume_token(READ);
        jj_consume_token(UNCOMMITTED);
                          {if (true) return ExecutionContext.READ_UNCOMMITTED_ISOLATION_LEVEL;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public int isolationLevelDB2Abbrev() throws ParseException {
    switch (jj_nt.kind) {
    case RR:
      jj_consume_token(RR);
                          {if (true) return ExecutionContext.SERIALIZABLE_ISOLATION_LEVEL;}
      break;
    case RS:
      jj_consume_token(RS);
                         {if (true) return ExecutionContext.REPEATABLE_READ_ISOLATION_LEVEL;}
      break;
    case CS:
      jj_consume_token(CS);
                          {if (true) return ExecutionContext.READ_COMMITTED_ISOLATION_LEVEL;}
      break;
    case UR:
      jj_consume_token(UR);
                          {if (true) return ExecutionContext.READ_UNCOMMITTED_ISOLATION_LEVEL;}
      break;
    default:
      jj_la1[256] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int isolationLevel() throws ParseException {
        int isolationLevel;
    jj_consume_token(ISOLATION);
    jj_consume_token(LEVEL);
    isolationLevel = levelOfIsolation();
                {if (true) return isolationLevel;}
    throw new Error("Missing return statement in function");
  }

  final public int levelOfIsolation() throws ParseException {
    switch (jj_nt.kind) {
    case READ:
      jj_consume_token(READ);
                {if (true) return levelOfIsolationRead();}
      break;
    case REPEATABLE:
      jj_consume_token(REPEATABLE);
      jj_consume_token(READ);
                {if (true) return ExecutionContext.REPEATABLE_READ_ISOLATION_LEVEL;}
      break;
    case SERIALIZABLE:
      jj_consume_token(SERIALIZABLE);
                {if (true) return ExecutionContext.SERIALIZABLE_ISOLATION_LEVEL;}
      break;
    default:
      jj_la1[257] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int levelOfIsolationRead() throws ParseException {
    switch (jj_nt.kind) {
    case UNCOMMITTED:
      jj_consume_token(UNCOMMITTED);
                {if (true) return ExecutionContext.READ_UNCOMMITTED_ISOLATION_LEVEL;}
      break;
    case COMMITTED:
      jj_consume_token(COMMITTED);
                {if (true) return ExecutionContext.READ_COMMITTED_ISOLATION_LEVEL;}
      break;
    default:
      jj_la1[258] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="simpleValueSpecification">simpleValueSpecification</A>
 */
  final public ValueNode simpleValueSpecification() throws ParseException, StandardException {
        ValueNode       value;
    value = literal();
                {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode setSchemaStatement() throws ParseException, StandardException {
        StatementNode setSchema;
    setSchemaHeader();
    switch (jj_nt.kind) {
    case EQUALS_OPERATOR:
      jj_consume_token(EQUALS_OPERATOR);
      break;
    default:
      jj_la1[259] = jj_gen;
      ;
    }
    setSchema = setSchemaValues();
                if (parameterList != null && parameterList.size() > 0)
                {
                        setUpAndLinkParameters();
                        // set the type of parameter node, it should be a varchar max Limits.MAX_IDENTIFIER_LENGTH - non nullable
                        ParameterNode p = (ParameterNode)parameterList.elementAt(0);
                        p.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(Types.VARCHAR), false, Limits.MAX_IDENTIFIER_LENGTH));
                }
                {if (true) return setSchema;}
    throw new Error("Missing return statement in function");
  }

  final public void setSchemaHeader() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case SCHEMA:
      jj_consume_token(SCHEMA);
      break;
    default:
      jj_la1[261] = jj_gen;
      if (getToken(1).kind == CURRENT && ( getToken(2).kind == SCHEMA ||  getToken(2).kind == SQLID )) {
        jj_consume_token(CURRENT);
        switch (jj_nt.kind) {
        case SCHEMA:
          jj_consume_token(SCHEMA);
          break;
        case SQLID:
          jj_consume_token(SQLID);
          break;
        default:
          jj_la1[260] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public StatementNode setSchemaValues() throws ParseException, StandardException {
        String schemaName;
    switch (jj_nt.kind) {
    case BINARY:
    case COALESCE:
    case COUNT:
    case D:
    case MODULE:
    case T:
    case TS:
    case VALUE:
    case VARBINARY:
    case ABS:
    case ABSVAL:
    case ACTION:
    case ALWAYS:
    case BLOB:
    case C:
    case CALLED:
    case CLOB:
    case COBOL:
    case COMMITTED:
    case CONCAT:
    case CONTAINS:
    case DATA:
    case DATE:
    case DAY:
    case DYNAMIC:
    case FORTRAN:
    case GENERATED:
    case IDENTITY_VAL_LOCAL:
    case INCREMENT:
    case INITIAL:
    case INTERVAL:
    case LANGUAGE:
    case LARGE:
    case LENGTH:
    case LEVEL:
    case LOCKS:
    case LOCKSIZE:
    case LOGGED:
    case MOD:
    case MODIFIES:
    case MODIFY:
    case MONTH:
    case _MORE:
    case MUMPS:
    case NAME:
    case NCLOB:
    case NULLABLE:
    case NUMBER:
    case OBJECT:
    case PASCAL:
    case PLI:
    case PRECISION:
    case RELEASE:
    case REPEATABLE:
    case RESTART:
    case RETURNS:
    case ROW:
    case SAVEPOINT:
    case SCALE:
    case SERIALIZABLE:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case START:
    case STATEMENT:
    case SYNONYM:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TRUNCATE:
    case TYPE:
    case UNCOMMITTED:
    case USAGE:
    case WHEN:
    case CURDATE:
    case CURTIME:
    case DATABASE:
    case LONG:
    case AFTER:
    case BEFORE:
    case CLASS:
    case COMPRESS:
    case CONTENT:
    case CS:
    case DB2SQL:
    case DIRTY:
    case DOCUMENT:
    case EACH:
    case EMPTY:
    case EXCLUSIVE:
    case FN:
    case INDEX:
    case JAVA:
    case LCASE:
    case LOCATE:
    case LOCK:
    case MESSAGE_LOCALE:
    case METHOD:
    case MODE:
    case NEW:
    case NEW_TABLE:
    case OJ:
    case OFF:
    case OLD:
    case OLD_TABLE:
    case PARAMETER:
    case PASSING:
    case PROPERTIES:
    case READS:
    case REF:
    case REFERENCING:
    case RENAME:
    case RESET:
    case RESULT:
    case RETAIN:
    case RETURNING:
    case RR:
    case RS:
    case SEQUENCE:
    case SEQUENTIAL:
    case SETS:
    case SHARE:
    case SQLID:
    case SPECIFIC:
    case SQRT:
    case STABILITY:
    case STRIP:
    case STYLE:
    case TRIGGER:
    case UCASE:
    case UR:
    case WHITESPACE:
    case IDENTIFIER:
    case DELIMITED_IDENTIFIER:
      schemaName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SET_SCHEMA_NODE,
                                                                schemaName,
                                                                null,
                                                                getContextManager());}
      break;
    case USER:
      jj_consume_token(USER);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SET_SCHEMA_NODE,
                                                                null,
                                                                ReuseFactory.getInteger(StatementType.SET_SCHEMA_USER),
                                                                getContextManager());}
      break;
    case QUESTION_MARK:
      dynamicParameterSpecification();
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SET_SCHEMA_NODE,
                                                                null,
                                                                ReuseFactory.getInteger(StatementType.SET_SCHEMA_DYNAMIC),
                                                                getContextManager());}
      break;
    case STRING:
      schemaName = string();
                /* Max length for schema name is Limits.MAX_IDENTIFIER_LENGTH */
                checkIdentifierLengthLimit(schemaName, Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SET_SCHEMA_NODE,
                                                                schemaName,
                                                                null,
                                                                getContextManager());}
      break;
    default:
      jj_la1[262] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Set the locale for messages coming from the database system. This
// is for support only, so we can get messages in our preferred language
// (usually English). I didn't want to create all the execution wiring
// to do this, so this command executes in the parser
  final public StatementNode setMessageLocaleStatement() throws ParseException, StandardException {
        String messageLocale;
    jj_consume_token(MESSAGE_LOCALE);
    messageLocale = string();
                getContextManager().setMessageLocale(messageLocale);

                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.NOP_STATEMENT_NODE,
                                                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="valueSpecification">valueSpecification</A>
 */
  final public ValueNode valueSpecification() throws ParseException, StandardException {
        ValueNode          value;
        ValueNode          leftExpression;
        ValueNode          rightExpression;
    switch (jj_nt.kind) {
    case FALSE:
    case TRUE:
    case LEFT_BRACE:
    case PLUS_SIGN:
    case MINUS_SIGN:
    case EXACT_NUMERIC:
    case STRING:
    case HEX_STRING:
    case APPROXIMATE_NUMERIC:
      value = literal();
                {if (true) return value;}
      break;
    case CURRENT_USER:
    case SESSION_USER:
    case USER:
    case QUESTION_MARK:
      value = generalValueSpecification();
                {if (true) return value;}
      break;
    case NULLIF:
      jj_consume_token(NULLIF);
      jj_consume_token(LEFT_PAREN);
      leftExpression = additiveExpression(null, 0, false);
      jj_consume_token(COMMA);
      rightExpression = additiveExpression(null, 0, false);
      jj_consume_token(RIGHT_PAREN);
                // "NULLIF(L, R)" is the same as "L=R ? untyped NULL : L"
                // An impl assumption here is that Derby can promote CHAR to any comparable datatypes such as numeric
                ContextManager cm = getContextManager();
                ValueNodeList thenElseList = (ValueNodeList) nodeFactory.getNode(C_NodeTypes.VALUE_NODE_LIST, cm);

                //Use untyped null for then clause at this point. At the bind time, we will cast it to the datatype of L 
                thenElseList.addElement((ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                        cm));
                thenElseList.addElement(leftExpression);

                {if (true) return (ValueNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.CONDITIONAL_NODE,
                                                                                        (ValueNode) nodeFactory.getNode(
                                                                                                                C_NodeTypes.BINARY_EQUALS_OPERATOR_NODE,
                                                                                                                leftExpression,
                                                                                                                rightExpression,
                                                                                                                cm),
                                                                                        thenElseList,
                                                                                        Boolean.TRUE,//this node is for nullif 
                                                                                        cm);}
      break;
    case CASE:
      jj_consume_token(CASE);
      value = whenThenExpression();
                {if (true) return value;}
      break;
    default:
      jj_la1[263] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="caseExpression">caseExpression</A>
 */
  final public ValueNode caseExpression() throws ParseException, StandardException {
        ValueNode          expr;
    switch (jj_nt.kind) {
    case END:
      jj_consume_token(END);
                ValueNode value = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.CAST_NODE,
                                                                                (ValueNode) nodeFactory.getNode(C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                                                                                                getContextManager()),
                                                                                DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.CHAR, 1),
                                                                                getContextManager());
                ((CastNode) value).setForExternallyGeneratedCASTnode();
                {if (true) return value;}
      break;
    case ELSE:
      jj_consume_token(ELSE);
      expr = thenElseExpression();
      jj_consume_token(END);
                {if (true) return expr;}
      break;
    case WHEN:
      expr = whenThenExpression();
                {if (true) return expr;}
      break;
    default:
      jj_la1[264] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="whenThenExpression">whenThenExpression</A>
 */
  final public ValueNode whenThenExpression() throws ParseException, StandardException {
        ValueNode          expr;
        ValueNode          thenExpr;
        ValueNode          elseExpr;
    jj_consume_token(WHEN);
    expr = orExpression(null, false);
    label_39:
    while (true) {
      switch (jj_nt.kind) {
      case OR:
        ;
        break;
      default:
        jj_la1[265] = jj_gen;
        break label_39;
      }
      jj_consume_token(OR);
      expr = orExpression(expr, false);
    }
    jj_consume_token(THEN);
    thenExpr = thenElseExpression();
    elseExpr = caseExpression();
                ContextManager cm = getContextManager();
                ValueNodeList thenElseList = (ValueNodeList) nodeFactory.getNode(C_NodeTypes.VALUE_NODE_LIST, cm);
                thenElseList.addElement(thenExpr); // then
                thenElseList.addElement(elseExpr); // else

                {if (true) return((ValueNode) nodeFactory.getNode(C_NodeTypes.CONDITIONAL_NODE,
                                                                                                expr,
                                                                                                thenElseList,
                                                                                                Boolean.FALSE,
                                                                                                cm));}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="thenElseExpression">thenElseExpression</A>
 */
  final public ValueNode thenElseExpression() throws ParseException, StandardException {
        ValueNode          expr;
    if (getToken(1).kind == NULL) {
      jj_consume_token(NULL);
                ValueNode value = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.CAST_NODE,
                                                                                (ValueNode) nodeFactory.getNode(C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                                                                                                getContextManager()),
                                                                                DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.CHAR, 1),
                                                                                getContextManager());
                ((CastNode) value).setForExternallyGeneratedCASTnode();
                {if (true) return value;}
    } else if (jj_2_50(1)) {
      expr = additiveExpression(null, 0, false);
                {if (true) return expr;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TableElementNode tableConstraintDefinition() throws ParseException, StandardException {
        Properties properties = null;
        ConstraintDefinitionNode tcdn;
        TableName               constraintName = null;
        //initialize following two booleans before handling table level constraints
        explicitNotNull = false;
        explicitNull = false;
    switch (jj_nt.kind) {
    case CONSTRAINT:
      constraintName = constraintNameDefinition();
      break;
    default:
      jj_la1[266] = jj_gen;
      ;
    }
    tcdn = tableConstraint(constraintName);
    switch (jj_nt.kind) {
    case DERBYDASHPROPERTIES:
      properties = propertyList(false);
      jj_consume_token(CHECK_PROPERTIES);
      break;
    default:
      jj_la1[267] = jj_gen;
      ;
    }
                if (properties != null)
                {
                        tcdn.setProperties(properties);
                }
                {if (true) return tcdn;}
    throw new Error("Missing return statement in function");
  }

  final public ConstraintDefinitionNode tableConstraint(TableName constraintName) throws ParseException, StandardException {
        ConstraintDefinitionNode tcdn;
    switch (jj_nt.kind) {
    case PRIMARY:
    case UNIQUE:
      tcdn = uniqueConstraintDefinition(constraintName);
                {if (true) return tcdn;}
      break;
    case FOREIGN:
      tcdn = referentialConstraintDefinition(constraintName);
                {if (true) return tcdn;}
      break;
    case CHECK:
      tcdn = checkConstraintDefinition(constraintName, null);
                {if (true) return tcdn;}
      break;
    default:
      jj_la1[268] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ConstraintDefinitionNode uniqueConstraintDefinition(TableName constraintName) throws ParseException, StandardException {
        int constraintType;
        ResultColumnList uniqueColumnList;
    //for table level constraint, second parameter will be null
            constraintType = uniqueSpecification((DataTypeDescriptor) null, null);
    jj_consume_token(LEFT_PAREN);
    uniqueColumnList = uniqueColumnList();
    jj_consume_token(RIGHT_PAREN);
                //go through the unique columns list and if any of the columns in the
                //list is explicitly defined null, throw an exception for this. Columns
                //for which no nullability is defined are by default nullable. But in
                //case of create table, there nullability changes automatically to 
                //non-nullable if primary key is defined on it. But if user explicitly
                //defines the nullability, then defining a primary key on it in create
                //table will result in an exception.
                if (constraintType ==  DataDictionary.PRIMARYKEY_CONSTRAINT)
                {
                        for (int index = 0; index < uniqueColumnList.size(); index++)
                        {
                                String primaryKeyColumnName = ((ResultColumn) uniqueColumnList.elementAt(index)).getName();
                                if (explicitlyNullableColumnsList.contains(primaryKeyColumnName))
                                {
                                        String errorState = SQLState.LANG_DB2_ADD_UNIQUE_OR_PRIMARY_KEY_ON_NULL_COLS;
                                        {if (true) throw StandardException.newException(errorState, primaryKeyColumnName);}
                                }
                        }
                }
                {if (true) return (ConstraintDefinitionNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(constraintType),
                                                uniqueColumnList,
                                                null,
                                                null,
                                                null,
                                                getContextManager()
                                                );}
    throw new Error("Missing return statement in function");
  }

//the second parameter to the following method will always be null for a table level
//constraint but not for a column level constraint
  final public int uniqueSpecification(DataTypeDescriptor dataTypeDescriptor,
String columnName) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case UNIQUE:
      jj_consume_token(UNIQUE);
                {if (true) return DataDictionary.UNIQUE_CONSTRAINT;}
      break;
    case PRIMARY:
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
                //explicitNull can be true only if it's column level constraint and
                //that column has null constraint defined on it. In that case, defining
                //a column-level constraint of primary key on it will result in an error.
                if (explicitNull)
                {
                        String errorState = SQLState.LANG_DB2_ADD_UNIQUE_OR_PRIMARY_KEY_ON_NULL_COLS;
                        {if (true) throw StandardException.newException(errorState, columnName);}
                }
                {if (true) return DataDictionary.PRIMARYKEY_CONSTRAINT;}
      break;
    default:
      jj_la1[269] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ResultColumnList uniqueColumnList() throws ParseException, StandardException {
        ResultColumnList        resultColumns = (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
    columnNameList(resultColumns);
                {if (true) return resultColumns;}
    throw new Error("Missing return statement in function");
  }

  final public ConstraintDefinitionNode referentialConstraintDefinition(TableName constraintName) throws ParseException, StandardException {
        ResultColumnList fkRcl = (ResultColumnList) nodeFactory.getNode(
                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                getContextManager());
        ResultColumnList refRcl = (ResultColumnList) nodeFactory.getNode(
                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                getContextManager());
        TableName referencedTable;
        int[] refActions = {StatementType.RA_NOACTION,
                            StatementType.RA_NOACTION};
    jj_consume_token(FOREIGN);
    jj_consume_token(KEY);
    jj_consume_token(LEFT_PAREN);
    columnNameList(fkRcl);
    jj_consume_token(RIGHT_PAREN);
    referencedTable = referencesSpecification(refRcl, refActions);
                {if (true) return (ConstraintDefinitionNode) nodeFactory.getNode(
                                                C_NodeTypes.FK_CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                referencedTable,
                                                fkRcl,
                                                refRcl,
                                                refActions,
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public TableName referencesSpecification(ResultColumnList rcl, int[] refActions) throws ParseException, StandardException {
        TableName tableName = null;
    jj_consume_token(REFERENCES);
    tableName = referencedTableAndColumns(rcl);
    switch (jj_nt.kind) {
    case ON:
      jj_consume_token(ON);
      referentialTriggeredAction(refActions);
      break;
    default:
      jj_la1[270] = jj_gen;
      ;
    }
                {if (true) return tableName;}
    throw new Error("Missing return statement in function");
  }

  final public TableName referencedTableAndColumns(ResultColumnList rcl) throws ParseException, StandardException {
        TableName       tableName = null;
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    switch (jj_nt.kind) {
    case LEFT_PAREN:
      jj_consume_token(LEFT_PAREN);
      columnNameList(rcl);
      jj_consume_token(RIGHT_PAREN);
      break;
    default:
      jj_la1[271] = jj_gen;
      ;
    }
                {if (true) return tableName;}
    throw new Error("Missing return statement in function");
  }

  final public void referentialTriggeredAction(int [] refActions) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case UPDATE:
      refActions[1] = updateRule();
      switch (jj_nt.kind) {
      case ON:
        jj_consume_token(ON);
        refActions[0] = deleteRule();
        break;
      default:
        jj_la1[272] = jj_gen;
        ;
      }
      break;
    case DELETE:
      refActions[0] = deleteRule();
      switch (jj_nt.kind) {
      case ON:
        jj_consume_token(ON);
        refActions[1] = updateRule();
        break;
      default:
        jj_la1[273] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[274] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public int updateRule() throws ParseException {
        int action;
    jj_consume_token(UPDATE);
    action = updateReferentialAction();
                {if (true) return action;}
    throw new Error("Missing return statement in function");
  }

  final public int deleteRule() throws ParseException {
        int action;
    jj_consume_token(DELETE);
    action = deleteReferentialAction();
                {if (true) return action;}
    throw new Error("Missing return statement in function");
  }

  final public int updateReferentialAction() throws ParseException {
    switch (jj_nt.kind) {
    case RESTRICT:
      jj_consume_token(RESTRICT);
                      {if (true) return StatementType.RA_RESTRICT;}
      break;
    case NO:
      jj_consume_token(NO);
      jj_consume_token(ACTION);
                         {if (true) return StatementType.RA_NOACTION;}
      break;
    default:
      jj_la1[275] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int deleteReferentialAction() throws ParseException {
    switch (jj_nt.kind) {
    case CASCADE:
      jj_consume_token(CASCADE);
                   {if (true) return StatementType.RA_CASCADE;}
      break;
    case RESTRICT:
      jj_consume_token(RESTRICT);
                      {if (true) return StatementType.RA_RESTRICT;}
      break;
    case NO:
      jj_consume_token(NO);
      jj_consume_token(ACTION);
                         {if (true) return StatementType.RA_NOACTION;}
      break;
    case SET:
      jj_consume_token(SET);
      switch (jj_nt.kind) {
      case NULL:
        jj_consume_token(NULL);
                      {if (true) return StatementType.RA_SETNULL;}
        break;
      case _DEFAULT:
        jj_consume_token(_DEFAULT);
                            {if (true) return StatementType.RA_SETDEFAULT;}
        break;
      default:
        jj_la1[276] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[277] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnConstraintDefinition">columnConstraintDefinition</A>
 */
  final public void columnConstraintDefinition(DataTypeDescriptor dataTypeDescriptor,
                                                   TableElementList tableElementList,
                                                   String columnName) throws ParseException, StandardException {
        int constraintType;
        TableElementNode tcdn;
        TableName constraintName = null;
    switch (jj_nt.kind) {
    case CONSTRAINT:
      constraintName = constraintNameDefinition();
      break;
    default:
      jj_la1[278] = jj_gen;
      ;
    }
    tcdn = columnConstraint(constraintName, dataTypeDescriptor, columnName);
                /* NOT NULL constraints are handled by marking the dataTypeDescriptor
		 * as being non-nullable.
		 */
                if (tcdn == null)
                {
                        {if (true) return;}
                }

                /* All other constraints, whether column or table will be added as
		 * table constraints.  We do this to facilitate the handling of
		 * multiple column constraints on the same column.
		 */
                tableElementList.addTableElement(tcdn);
  }

/*
 * <A NAME="columnConstraint">columnConstraint</A>
 */
  final public ConstraintDefinitionNode columnConstraint(TableName constraintName,
                                 DataTypeDescriptor dataTypeDescriptor,
                                 String columnName) throws ParseException, StandardException {
        int constraintType;
        Properties properties = null;
        ConstraintDefinitionNode tcdn;
        ResultColumnList refRcl = (ResultColumnList) nodeFactory.getNode(
                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                getContextManager());
        TableName referencedTable;
        int[] refActions = {StatementType.RA_NOACTION,
                            StatementType.RA_NOACTION} ;
    switch (jj_nt.kind) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                //if column is explicitly defined not nullable, set following flag
                explicitNotNull = true;
                //if both null and not null constraints are defined for a column,
                //throw an exception
                if (explicitNull)
                   {if (true) throw StandardException.newException(SQLState.LANG_ADDING_COLUMN_WITH_NULL_AND_NOT_NULL_CONSTRAINT, columnName);}
                dataTypeDescriptor.setNullability(false);
                {if (true) return null;}
      break;
    case PRIMARY:
    case UNIQUE:
      //pass the columnname as the second parameter. It will be used to throw an
              //exception if null constraint is defined for this column-level primary 
              //key constraint
              constraintType = uniqueSpecification(dataTypeDescriptor,columnName);
      switch (jj_nt.kind) {
      case DERBYDASHPROPERTIES:
        properties = propertyList(false);
        jj_consume_token(CHECK_PROPERTIES);
        break;
      default:
        jj_la1[279] = jj_gen;
        ;
      }
                ResultColumnList uniqueColumnList =
                                                                                (ResultColumnList) nodeFactory.getNode(
                                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                                getContextManager());
                uniqueColumnList.addElement(
                        (ResultColumn) nodeFactory.getNode(
                                                        C_NodeTypes.RESULT_COLUMN,
                                                        columnName,
                                                        null,
                                                        getContextManager()));

                {if (true) return (ConstraintDefinitionNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(constraintType),
                                                uniqueColumnList,
                                                properties,
                                                null,
                                                null,
                                                getContextManager()
                                                );}
      break;
    case REFERENCES:
      referencedTable = referencesSpecification(refRcl, refActions);
      switch (jj_nt.kind) {
      case DERBYDASHPROPERTIES:
        properties = propertyList(false);
        jj_consume_token(CHECK_PROPERTIES);
        break;
      default:
        jj_la1[280] = jj_gen;
        ;
      }
                ResultColumnList fkRcl = (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
                fkRcl.addElement(
                                        (ResultColumn) nodeFactory.getNode(
                                                                        C_NodeTypes.RESULT_COLUMN,
                                                                        columnName,
                                                                        null,
                                                                        getContextManager())
                                );
                tcdn = (ConstraintDefinitionNode) nodeFactory.getNode(
                                                C_NodeTypes.FK_CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                referencedTable,
                                                fkRcl,
                                                refRcl,
                                                refActions,
                                                getContextManager());
                if (properties != null)
                {
                        tcdn.setProperties(properties);
                }
                {if (true) return tcdn;}
      break;
    case CHECK:
      tcdn = checkConstraintDefinition(constraintName, columnName);
                {if (true) return tcdn;}
      break;
    default:
      jj_la1[281] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public StatementNode dropSchemaStatement() throws ParseException, StandardException {
        String schemaName;
    jj_consume_token(SCHEMA);
    schemaName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    jj_consume_token(RESTRICT);
                StatementNode stmt =  (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.DROP_SCHEMA_NODE,
                                                        schemaName,
                                                        new Integer(StatementType.DROP_RESTRICT),
                                                        getContextManager());

                {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode alterTableStatement() throws ParseException, StandardException {
        StatementNode           node;
        TableName                       tableName;
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    node = alterTableBody(tableName);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode alterTableBody(TableName tableName) throws ParseException, StandardException {
        StatementNode qtn;
        char                            lockGranularity = '\0';
        String               newTableName;
        TableElementList        tableElementList =
                                                                        (TableElementList) nodeFactory.getNode(
                                                                                                C_NodeTypes.TABLE_ELEMENT_LIST,
                                                                                                getContextManager());
        Token                           tok = null;
        int[]                           changeType = new int[1];
        int[]                           behavior = new int[1];
        boolean[]                       sequential = new boolean[1];
    switch (jj_nt.kind) {
    case COMPRESS:
      jj_consume_token(COMPRESS);
      switch (jj_nt.kind) {
      case SEQUENTIAL:
        tok = jj_consume_token(SEQUENTIAL);
        break;
      default:
        jj_la1[282] = jj_gen;
        ;
      }
                checkInternalFeature("COMPRESS");
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.ALTER_TABLE_NODE,
                                                        tableName,
                                                        new Boolean(tok != null),
                                                        getContextManager());}
      break;
    case ADD:
    case ALTER:
    case DROP:
    case LOCKSIZE:
      lockGranularity = alterTableAction(tableElementList, changeType, behavior, sequential);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.ALTER_TABLE_NODE,
                                                        tableName,
                                                        tableElementList,
                                                        new Character(lockGranularity),
                                                        changeType,
                                                        behavior,
                                                        sequential,
                                                        getContextManager());}
      break;
    default:
      jj_la1[283] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="alterTableRenameTableStatement">alterTableRenameTableStatement</A>
 */
/*
StatementNode
alterTableRenameTableStatement(TableName tableName) throws StandardException :
{
	String newTableName;
}
{
	<TO> newTableName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true)
	{
		return (StatementNode) nodeFactory.getNode(
							C_NodeTypes.RENAME_NODE,
							tableName,
							null,
							newTableName,
							Boolean.TRUE,
ReuseFactory.getInteger(StatementType.RENAME_TABLE),
							getContextManager());
	}
}
*/

/*
 * <A NAME="alterTableRenameColumnStatement">alterTableRenameColumnStatement</A>
 */
/*
StatementNode
alterTableRenameColumnStatement(TableName tableName) throws StandardException :
{
	String oldColumnName;
	String newColumnName;
}
{
	oldColumnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true) <TO> newColumnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true)
	{
		return (StatementNode) nodeFactory.getNode(
							C_NodeTypes.RENAME_NODE,
							tableName,
							oldColumnName,
							newColumnName,
							Boolean.TRUE,
ReuseFactory.getInteger(StatementType.RENAME_COLUMN),
							getContextManager());
	}
}
*/
  final public char alterTableAction(TableElementList tableElementList, int[] changeType, int[] behavior, boolean[] sequential) throws ParseException, StandardException {
        char                            lockGranularity = '\0';
        TableElementNode        tableElement;
        DataTypeDescriptor      typeDescriptor;
        Token                           tok = null;
        String                          columnName;
        long[]                          autoIncrementInfo = new long[4];
    switch (jj_nt.kind) {
    case ADD:
      jj_consume_token(ADD);
      switch (jj_nt.kind) {
      case BINARY:
      case COALESCE:
      case COLUMN:
      case COUNT:
      case D:
      case MODULE:
      case T:
      case TS:
      case VALUE:
      case VARBINARY:
      case ABS:
      case ABSVAL:
      case ACTION:
      case ALWAYS:
      case BLOB:
      case C:
      case CALLED:
      case CLOB:
      case COBOL:
      case COMMITTED:
      case CONCAT:
      case CONTAINS:
      case DATA:
      case DATE:
      case DAY:
      case DYNAMIC:
      case FORTRAN:
      case GENERATED:
      case IDENTITY_VAL_LOCAL:
      case INCREMENT:
      case INITIAL:
      case INTERVAL:
      case LANGUAGE:
      case LARGE:
      case LENGTH:
      case LEVEL:
      case LOCKS:
      case LOCKSIZE:
      case LOGGED:
      case MOD:
      case MODIFIES:
      case MODIFY:
      case MONTH:
      case _MORE:
      case MUMPS:
      case NAME:
      case NCLOB:
      case NULLABLE:
      case NUMBER:
      case OBJECT:
      case PASCAL:
      case PLI:
      case PRECISION:
      case RELEASE:
      case REPEATABLE:
      case RESTART:
      case RETURNS:
      case ROW:
      case SAVEPOINT:
      case SCALE:
      case SERIALIZABLE:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case START:
      case STATEMENT:
      case SYNONYM:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TRUNCATE:
      case TYPE:
      case UNCOMMITTED:
      case USAGE:
      case WHEN:
      case CURDATE:
      case CURTIME:
      case DATABASE:
      case LONG:
      case AFTER:
      case BEFORE:
      case CLASS:
      case COMPRESS:
      case CONTENT:
      case CS:
      case DB2SQL:
      case DIRTY:
      case DOCUMENT:
      case EACH:
      case EMPTY:
      case EXCLUSIVE:
      case FN:
      case INDEX:
      case JAVA:
      case LCASE:
      case LOCATE:
      case LOCK:
      case MESSAGE_LOCALE:
      case METHOD:
      case MODE:
      case NEW:
      case NEW_TABLE:
      case OJ:
      case OFF:
      case OLD:
      case OLD_TABLE:
      case PARAMETER:
      case PASSING:
      case PROPERTIES:
      case READS:
      case REF:
      case REFERENCING:
      case RENAME:
      case RESET:
      case RESULT:
      case RETAIN:
      case RETURNING:
      case RR:
      case RS:
      case SEQUENCE:
      case SEQUENTIAL:
      case SETS:
      case SHARE:
      case SQLID:
      case SPECIFIC:
      case SQRT:
      case STABILITY:
      case STRIP:
      case STYLE:
      case TRIGGER:
      case UCASE:
      case UR:
      case WHITESPACE:
      case IDENTIFIER:
      case DELIMITED_IDENTIFIER:
        tableElement = addColumnDefinition(tableElementList);
        break;
      case CHECK:
      case CONSTRAINT:
      case FOREIGN:
      case PRIMARY:
      case UNIQUE:
        tableElement = tableConstraintDefinition();
        break;
      default:
        jj_la1[284] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                if (tableElement instanceof ColumnDefinitionNode)
                {
                        //bug 5724 - auto increment columns not allowed in ALTER TABLE statement
                        ColumnDefinitionNode cdn = (ColumnDefinitionNode) tableElement;
                        if ( cdn.isAutoincrementColumn())
                                {if (true) throw StandardException.newException(SQLState.LANG_ALTER_TABLE_AUTOINCREMENT_COLUMN_NOT_ALLOWED);}
                }
                changeType[0] = DDLStatementNode.ADD_TYPE;
                tableElementList.addTableElement(tableElement);
                {if (true) return lockGranularity;}
      break;
    case ALTER:
      jj_consume_token(ALTER);
      switch (jj_nt.kind) {
      case COLUMN:
        jj_consume_token(COLUMN);
        break;
      default:
        jj_la1[285] = jj_gen;
        ;
      }
      columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      tableElement = columnAlterClause(columnName);
                changeType[0] = DDLStatementNode.MODIFY_TYPE;
                tableElementList.addTableElement(tableElement);
                {if (true) return lockGranularity;}
      break;
    case DROP:
      jj_consume_token(DROP);
      switch (jj_nt.kind) {
      case BINARY:
      case COALESCE:
      case COLUMN:
      case COUNT:
      case D:
      case MODULE:
      case T:
      case TS:
      case VALUE:
      case VARBINARY:
      case ABS:
      case ABSVAL:
      case ACTION:
      case ALWAYS:
      case BLOB:
      case C:
      case CALLED:
      case CLOB:
      case COBOL:
      case COMMITTED:
      case CONCAT:
      case CONTAINS:
      case DATA:
      case DATE:
      case DAY:
      case DYNAMIC:
      case FORTRAN:
      case GENERATED:
      case IDENTITY_VAL_LOCAL:
      case INCREMENT:
      case INITIAL:
      case INTERVAL:
      case LANGUAGE:
      case LARGE:
      case LENGTH:
      case LEVEL:
      case LOCKS:
      case LOCKSIZE:
      case LOGGED:
      case MOD:
      case MODIFIES:
      case MODIFY:
      case MONTH:
      case _MORE:
      case MUMPS:
      case NAME:
      case NCLOB:
      case NULLABLE:
      case NUMBER:
      case OBJECT:
      case PASCAL:
      case PLI:
      case PRECISION:
      case RELEASE:
      case REPEATABLE:
      case RESTART:
      case RETURNS:
      case ROW:
      case SAVEPOINT:
      case SCALE:
      case SERIALIZABLE:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case START:
      case STATEMENT:
      case SYNONYM:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TRUNCATE:
      case TYPE:
      case UNCOMMITTED:
      case USAGE:
      case WHEN:
      case CURDATE:
      case CURTIME:
      case DATABASE:
      case LONG:
      case AFTER:
      case BEFORE:
      case CLASS:
      case COMPRESS:
      case CONTENT:
      case CS:
      case DB2SQL:
      case DIRTY:
      case DOCUMENT:
      case EACH:
      case EMPTY:
      case EXCLUSIVE:
      case FN:
      case INDEX:
      case JAVA:
      case LCASE:
      case LOCATE:
      case LOCK:
      case MESSAGE_LOCALE:
      case METHOD:
      case MODE:
      case NEW:
      case NEW_TABLE:
      case OJ:
      case OFF:
      case OLD:
      case OLD_TABLE:
      case PARAMETER:
      case PASSING:
      case PROPERTIES:
      case READS:
      case REF:
      case REFERENCING:
      case RENAME:
      case RESET:
      case RESULT:
      case RETAIN:
      case RETURNING:
      case RR:
      case RS:
      case SEQUENCE:
      case SEQUENTIAL:
      case SETS:
      case SHARE:
      case SQLID:
      case SPECIFIC:
      case SQRT:
      case STABILITY:
      case STRIP:
      case STYLE:
      case TRIGGER:
      case UCASE:
      case UR:
      case WHITESPACE:
      case IDENTIFIER:
      case DELIMITED_IDENTIFIER:
        tableElement = dropColumnDefinition(behavior);
        break;
      default:
        jj_la1[286] = jj_gen;
        if (jj_2_51(1)) {
          tableElement = dropTableConstraintDefinition();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
                changeType[0] = DDLStatementNode.DROP_TYPE;
                tableElementList.addTableElement(tableElement);
                {if (true) return lockGranularity;}
      break;
    case LOCKSIZE:
      lockGranularity = DB2lockGranularityClause();
                changeType[0] = DDLStatementNode.LOCKING_TYPE;
                {if (true) return lockGranularity;}
      break;
    default:
      jj_la1[287] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * Handle
 *
 *    ALTER TABLE tablename DROP [ COLUMN ] columnname [ CASCADE | RESTRICT ]
 */
  final public TableElementNode dropColumnDefinition(int []behavior) throws ParseException, StandardException {
        String columnName;
        TableElementNode tableElement;
    switch (jj_nt.kind) {
    case COLUMN:
      jj_consume_token(COLUMN);
      break;
    default:
      jj_la1[288] = jj_gen;
      ;
    }
    columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    dropColumnReferentialAction(behavior);
                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.DROP_COLUMN_NODE,
                                                columnName, null,
                                                null, null,
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void dropColumnReferentialAction(int []behavior) throws ParseException {
        int refBehavior = StatementType.DROP_CASCADE;
    switch (jj_nt.kind) {
    case CASCADE:
    case RESTRICT:
      switch (jj_nt.kind) {
      case CASCADE:
        jj_consume_token(CASCADE);
                     refBehavior = StatementType.DROP_CASCADE;
        break;
      case RESTRICT:
        jj_consume_token(RESTRICT);
                        refBehavior = StatementType.DROP_RESTRICT;
        break;
      default:
        jj_la1[289] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[290] = jj_gen;
      ;
    }
                behavior[0] = refBehavior;
  }

  final public TableElementNode addColumnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        TableElementNode        tableElement;
    switch (jj_nt.kind) {
    case COLUMN:
      jj_consume_token(COLUMN);
      break;
    default:
      jj_la1[291] = jj_gen;
      ;
    }
    tableElement = columnDefinition(tableElementList);
                {if (true) return tableElement;}
    throw new Error("Missing return statement in function");
  }

/*
 * Various variants of the ALTER TABLE ALTER COLUMN statement.
 *
 * By the type we get here, we've parsed
 *    ALTER TABLE tablename ALTER [COLUMN] columnname
 * and here we parse the remainder of the ALTER COLUMN clause, one of:
 *		SET DATA TYPE data_type
 *		SET INCREMENT BY increment_value
 *		RESTART WITH increment_restart_value
 *		[WITH] DEFAULT default_value
 *      [NOT] NULL
 */
  final public TableElementNode columnAlterClause(String columnName) throws ParseException, StandardException {
        ValueNode       defaultNode;
        long[]                          autoIncrementInfo = new long[4];
        long                            autoIncrementIncrement = 1;
        long                            autoIncrementRestartWith = 1;
        DataTypeDescriptor      typeDescriptor = null;
    if (getToken(2).kind == DATA) {
      jj_consume_token(SET);
      jj_consume_token(DATA);
      jj_consume_token(TYPE);
      typeDescriptor = dataTypeDDL();
                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.MODIFY_COLUMN_TYPE_NODE,
                                                columnName, null,
                                                typeDescriptor, null,
                                                getContextManager());}
    } else if (getToken(2).kind == INCREMENT) {
      jj_consume_token(SET);
      jj_consume_token(INCREMENT);
      jj_consume_token(BY);
      autoIncrementIncrement = exactNumber();
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_INC_INDEX] = autoIncrementIncrement;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_CREATE_MODIFY] = ColumnDefinitionNode.MODIFY_AUTOINCREMENT_INC_VALUE;
                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.MODIFY_COLUMN_DEFAULT_NODE,
                                                columnName,
                                                null, null, autoIncrementInfo,
                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case RESTART:
        jj_consume_token(RESTART);
        jj_consume_token(WITH);
        autoIncrementRestartWith = exactNumber();
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_START_INDEX] = autoIncrementRestartWith;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_CREATE_MODIFY] = ColumnDefinitionNode.MODIFY_AUTOINCREMENT_RESTART_VALUE;
                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.MODIFY_COLUMN_DEFAULT_NODE,
                                                columnName,
                                                null, null, autoIncrementInfo,
                                                getContextManager());}
        break;
      default:
        jj_la1[292] = jj_gen;
        if (getToken(1).kind == WITH || getToken(1).kind == _DEFAULT) {
          defaultNode = defaultClause(autoIncrementInfo, columnName);
                if (autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_AUTOINCREMENT_INDEX]
                                 == 0)
                {
                        autoIncrementInfo = null;
                }

                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                                C_NodeTypes.MODIFY_COLUMN_DEFAULT_NODE,
                                                                columnName,
                                                                defaultNode, null, autoIncrementInfo,
                                                                getContextManager());}
        } else if (getToken(1).kind == NULL) {
          jj_consume_token(NULL);
                // for a MODIFY column NULL clause form a modify_column node
                // with all null values. In a column definition a [NOT] NULL
                // column constraint is specified by setting the right value
                // in the nullability field of the data type but we don't have
                // a datatype here.
                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                                C_NodeTypes.MODIFY_COLUMN_CONSTRAINT_NODE,
                                                                columnName, null, null, null,
                                                                getContextManager());}
        } else if (getToken(1).kind == NOT) {
          jj_consume_token(NOT);
          jj_consume_token(NULL);
                // for a MODIFY column NOT NULL clause form a modify_column node
                // with all null values. In a column definition a [NOT] NULL
                // column constraint is specified by setting the right value
                // in the nullability field of the data type but we don't have
                // a datatype here.
                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                                C_NodeTypes.MODIFY_COLUMN_CONSTRAINT_NOT_NULL_NODE,
                                                                columnName, null, null, null,
                                                                getContextManager());}
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public TableElementNode dropTableConstraintDefinition() throws ParseException, StandardException {
        TableName                constraintName;
    if (getToken(1).kind == CONSTRAINT) {
      jj_consume_token(CONSTRAINT);
      constraintName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(DataDictionary.DROP_CONSTRAINT),
                                                null,
                                                null,
                                                null,
                                                null,
                                                ReuseFactory.getInteger(StatementType.DROP_DEFAULT),
                                                getContextManager()
                                                );}
    } else if (getToken(1).kind == PRIMARY) {
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                null,
                                                ReuseFactory.getInteger(DataDictionary.DROP_CONSTRAINT),
                                                null,
                                                null,
                                                null,
                                                null,
                                                ReuseFactory.getInteger(StatementType.DROP_DEFAULT),
                                                getContextManager()
                                                );}
    } else if (getToken(1).kind == FOREIGN) {
      jj_consume_token(FOREIGN);
      jj_consume_token(KEY);
      constraintName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(DataDictionary.DROP_CONSTRAINT),
                                                null,
                                                null,
                                                null,
                                                null,
                                                ReuseFactory.getInteger(StatementType.DROP_DEFAULT),
                                                ReuseFactory.getInteger(DataDictionary.FOREIGNKEY_CONSTRAINT),
                                                getContextManager()
                                                );}
    } else if (getToken(1).kind == UNIQUE) {
      jj_consume_token(UNIQUE);
      constraintName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(DataDictionary.DROP_CONSTRAINT),
                                                null,
                                                null,
                                                null,
                                                null,
                                                ReuseFactory.getInteger(StatementType.DROP_DEFAULT),
                                                ReuseFactory.getInteger(DataDictionary.UNIQUE_CONSTRAINT),
                                                getContextManager()
                                                );}
    } else {
      switch (jj_nt.kind) {
      case CHECK:
        jj_consume_token(CHECK);
        constraintName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(DataDictionary.DROP_CONSTRAINT),
                                                null,
                                                null,
                                                null,
                                                null,
                                                ReuseFactory.getInteger(StatementType.DROP_DEFAULT),
                                                ReuseFactory.getInteger(DataDictionary.CHECK_CONSTRAINT),
                                                getContextManager()
                                                );}
        break;
      default:
        jj_la1[293] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dropTableStatement">dropTableStatement</A>
 */
  final public StatementNode dropTableStatement() throws ParseException, StandardException {
        TableName tableName;
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                // DB2 does not support a drop behaviour
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.DROP_TABLE_NODE,
                                                                                        tableName,
                                                                                        new Integer(StatementType.DROP_DEFAULT),
                                                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dropIndexStatement">dropIndexStatement</A>
 */
  final public StatementNode dropIndexStatement() throws ParseException, StandardException {
        TableName indexName;
    jj_consume_token(INDEX);
    indexName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_INDEX_NODE,
                                                                indexName,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dropAliasStatement">dropAliasStatement</A>
 */
  final public StatementNode dropAliasStatement() throws ParseException, StandardException {
        Object aliasName;
    switch (jj_nt.kind) {
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
      aliasName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return dropAliasNode(aliasName, AliasInfo.ALIAS_TYPE_PROCEDURE_AS_CHAR);}
      break;
    case FUNCTION:
      jj_consume_token(FUNCTION);
      aliasName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return dropAliasNode(aliasName, AliasInfo.ALIAS_TYPE_FUNCTION_AS_CHAR);}
      break;
    case SYNONYM:
      jj_consume_token(SYNONYM);
      aliasName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                checkVersion(DataDictionary.DD_VERSION_DERBY_10_1, "DROP SYNONYM");

                {if (true) return dropAliasNode(aliasName, AliasInfo.ALIAS_TYPE_SYNONYM_AS_CHAR);}
      break;
    default:
      jj_la1[294] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public StatementNode dropViewStatement() throws ParseException, StandardException {
        TableName viewName;
    jj_consume_token(VIEW);
    viewName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_VIEW_NODE,
                                                                viewName,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode dropTriggerStatement() throws ParseException, StandardException {
        TableName triggerName;
    jj_consume_token(TRIGGER);
    triggerName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_TRIGGER_NODE,
                                                                triggerName,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode truncateTableStatement() throws ParseException, StandardException {
        TableName tableName;
    jj_consume_token(TRUNCATE);
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
                {if (true) return (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.ALTER_TABLE_NODE,
                                                        tableName,
                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="grantStatement">grantStatement</A>
 */
  final public StatementNode grantStatement() throws ParseException, StandardException {
    StatementNode node;
    jj_consume_token(GRANT);
                checkVersion( DataDictionary.DD_VERSION_DERBY_10_2, "GRANT");
                checkSqlStandardAccess( "GRANT");
    switch (jj_nt.kind) {
    case ALL:
    case DELETE:
    case INSERT:
    case REFERENCES:
    case SELECT:
    case UPDATE:
    case TRIGGER:
      node = tableGrantStatement();
      break;
    case EXECUTE:
      node = routineGrantStatement();
      break;
    default:
      jj_la1[295] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableGrantStatement">tableGrantStatement</A>
 */
  final public StatementNode tableGrantStatement() throws ParseException, StandardException {
    PrivilegeNode privileges;
    List grantees;
    privileges = tablePrivileges();
    jj_consume_token(TO);
    grantees = granteeList();
        {if (true) return (StatementNode) nodeFactory.getNode( C_NodeTypes.GRANT_NODE,
                                    privileges, grantees,
                                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

 // end of tableGrantStatement

/*
 * <A NAME="tablePrivileges">tablePrivileges</A>
 */
  final public PrivilegeNode tablePrivileges() throws ParseException, StandardException {
    TablePrivilegesNode tablePrivilegesNode = null;
    TableName objectName = null;
    tablePrivilegesNode = tableActions();
    jj_consume_token(ON);
    switch (jj_nt.kind) {
    case TABLE:
      jj_consume_token(TABLE);
      break;
    default:
      jj_la1[296] = jj_gen;
      ;
    }
    objectName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
        {if (true) return (PrivilegeNode) nodeFactory.getNode( C_NodeTypes.PRIVILEGE_NODE,
                                                    ReuseFactory.getInteger( PrivilegeNode.TABLE_PRIVILEGES),
                                                    objectName, tablePrivilegesNode,
                                                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

  // end of   tablePrivilege                               

/*
 * <A NAME="tableActions">tableActions</A>
 */
  final public TablePrivilegesNode tableActions() throws ParseException, StandardException {
    TablePrivilegesNode tableActionsNode = (TablePrivilegesNode)
      nodeFactory.getNode( C_NodeTypes.TABLE_PRIVILEGES_NODE, getContextManager());
    switch (jj_nt.kind) {
    case ALL:
      jj_consume_token(ALL);
      jj_consume_token(PRIVILEGES);
        tableActionsNode.addAll();
        {if (true) return tableActionsNode;}
      break;
    case DELETE:
    case INSERT:
    case REFERENCES:
    case SELECT:
    case UPDATE:
    case TRIGGER:
      tableAction(tableActionsNode);
      label_40:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[297] = jj_gen;
          break label_40;
        }
        jj_consume_token(COMMA);
        tableAction(tableActionsNode);
      }
        {if (true) return tableActionsNode;}
      break;
    default:
      jj_la1[298] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  // end of tableActions

/*
 * <A NAME="routineGrantStatement">routineGrantStatement</A>
 */
  final public StatementNode routineGrantStatement() throws ParseException, StandardException {
    List grantees;
    RoutineDesignator routine;
    jj_consume_token(EXECUTE);
    jj_consume_token(ON);
    routine = routineDesignator();
    jj_consume_token(TO);
    grantees = granteeList();
        PrivilegeNode routinePrivilege = (PrivilegeNode)
          nodeFactory.getNode( C_NodeTypes.PRIVILEGE_NODE,
                               ReuseFactory.getInteger( PrivilegeNode.ROUTINE_PRIVILEGES),
                               routine, null,
                               getContextManager());
        {if (true) return (StatementNode) nodeFactory.getNode( C_NodeTypes.GRANT_NODE,
                                    routinePrivilege, grantees,
                                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

 // end of routineGrantStatement

/*
 * <A NAME="routineAlias">routineAlias</A>
 */
  final public RoutineDesignator routineDesignator() throws ParseException, StandardException {
    Token procOrFunction;
    RoutineDesignator routine = null;
    TableName name = null;
    List paramTypeList = null;
    switch (jj_nt.kind) {
    case FUNCTION:
      procOrFunction = jj_consume_token(FUNCTION);
      break;
    case PROCEDURE:
      procOrFunction = jj_consume_token(PROCEDURE);
      break;
    default:
      jj_la1[299] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    switch (jj_nt.kind) {
    case LEFT_PAREN:
      jj_consume_token(LEFT_PAREN);
      paramTypeList = parameterTypeList();
      jj_consume_token(RIGHT_PAREN);
      break;
    default:
      jj_la1[300] = jj_gen;
      ;
    }
        {if (true) return new RoutineDesignator( false,
                                      name,
                                      (procOrFunction.kind == FUNCTION),
                                      paramTypeList);}
    throw new Error("Missing return statement in function");
  }

  // end of routineDesignator


/*
 * <A NAME="parameterTypeList">parameterTypeList</A>
 */
  final public List parameterTypeList() throws ParseException, StandardException {
    ArrayList list = new ArrayList();
    DataTypeDescriptor dtd;
    if (jj_2_52(1)) {
      dtd = dataTypeCommon();
            list.add( dtd);
      label_41:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[301] = jj_gen;
          break label_41;
        }
        jj_consume_token(COMMA);
        dtd = dataTypeCommon();
            list.add( dtd);
      }
    } else {
      ;
    }
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  // end of parameterTypeList


/*
 * <A NAME="tableAction">tableAction</A>
 */
  final public void tableAction(TablePrivilegesNode tablePrivilegesNode) throws ParseException, StandardException {
    ResultColumnList columnList = null;
    switch (jj_nt.kind) {
    case SELECT:
      jj_consume_token(SELECT);
      switch (jj_nt.kind) {
      case LEFT_PAREN:
        columnList = privilegeColumnList();
        break;
      default:
        jj_la1[302] = jj_gen;
        ;
      }
        tablePrivilegesNode.addAction( TablePrivilegeInfo.SELECT_ACTION, columnList);
      break;
    case DELETE:
      jj_consume_token(DELETE);
        tablePrivilegesNode.addAction( TablePrivilegeInfo.DELETE_ACTION, (ResultColumnList) null);
      break;
    case INSERT:
      jj_consume_token(INSERT);
        tablePrivilegesNode.addAction( TablePrivilegeInfo.INSERT_ACTION, (ResultColumnList) null);
      break;
    case UPDATE:
      jj_consume_token(UPDATE);
      switch (jj_nt.kind) {
      case LEFT_PAREN:
        columnList = privilegeColumnList();
        break;
      default:
        jj_la1[303] = jj_gen;
        ;
      }
        tablePrivilegesNode.addAction( TablePrivilegeInfo.UPDATE_ACTION, columnList);
      break;
    case REFERENCES:
      jj_consume_token(REFERENCES);
      switch (jj_nt.kind) {
      case LEFT_PAREN:
        columnList = privilegeColumnList();
        break;
      default:
        jj_la1[304] = jj_gen;
        ;
      }
        tablePrivilegesNode.addAction( TablePrivilegeInfo.REFERENCES_ACTION, columnList);
      break;
    case TRIGGER:
      jj_consume_token(TRIGGER);
        tablePrivilegesNode.addAction( TablePrivilegeInfo.TRIGGER_ACTION, (ResultColumnList) null);
      break;
    default:
      jj_la1[305] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  // end of tableAction

/*
 * <A NAME="privilegeColumnList">privilegeColumnList</A>
 */
  final public ResultColumnList privilegeColumnList() throws ParseException, StandardException {
    ResultColumnList cl = (ResultColumnList) nodeFactory.getNode( C_NodeTypes.RESULT_COLUMN_LIST,
                                                                  getContextManager());
    jj_consume_token(LEFT_PAREN);
    columnNameList(cl);
    jj_consume_token(RIGHT_PAREN);
        {if (true) return cl;}
    throw new Error("Missing return statement in function");
  }

  // end of privilegeColumnList

/*
 * <A NAME="granteeList">granteeList</A>
 */
  final public List granteeList() throws ParseException, StandardException {
    ArrayList list = new ArrayList();
    grantee(list);
    label_42:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[306] = jj_gen;
        break label_42;
      }
      jj_consume_token(COMMA);
      grantee(list);
    }
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public void grantee(List list) throws ParseException, StandardException {
    String str;
    switch (jj_nt.kind) {
    case BINARY:
    case COALESCE:
    case COUNT:
    case D:
    case MODULE:
    case T:
    case TS:
    case VALUE:
    case VARBINARY:
    case ABS:
    case ABSVAL:
    case ACTION:
    case ALWAYS:
    case BLOB:
    case C:
    case CALLED:
    case CLOB:
    case COBOL:
    case COMMITTED:
    case CONCAT:
    case CONTAINS:
    case DATA:
    case DATE:
    case DAY:
    case DYNAMIC:
    case FORTRAN:
    case GENERATED:
    case IDENTITY_VAL_LOCAL:
    case INCREMENT:
    case INITIAL:
    case INTERVAL:
    case LANGUAGE:
    case LARGE:
    case LENGTH:
    case LEVEL:
    case LOCKS:
    case LOCKSIZE:
    case LOGGED:
    case MOD:
    case MODIFIES:
    case MODIFY:
    case MONTH:
    case _MORE:
    case MUMPS:
    case NAME:
    case NCLOB:
    case NULLABLE:
    case NUMBER:
    case OBJECT:
    case PASCAL:
    case PLI:
    case PRECISION:
    case RELEASE:
    case REPEATABLE:
    case RESTART:
    case RETURNS:
    case ROW:
    case SAVEPOINT:
    case SCALE:
    case SERIALIZABLE:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case START:
    case STATEMENT:
    case SYNONYM:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TRUNCATE:
    case TYPE:
    case UNCOMMITTED:
    case USAGE:
    case WHEN:
    case CURDATE:
    case CURTIME:
    case DATABASE:
    case LONG:
    case AFTER:
    case BEFORE:
    case CLASS:
    case COMPRESS:
    case CONTENT:
    case CS:
    case DB2SQL:
    case DIRTY:
    case DOCUMENT:
    case EACH:
    case EMPTY:
    case EXCLUSIVE:
    case FN:
    case INDEX:
    case JAVA:
    case LCASE:
    case LOCATE:
    case LOCK:
    case MESSAGE_LOCALE:
    case METHOD:
    case MODE:
    case NEW:
    case NEW_TABLE:
    case OJ:
    case OFF:
    case OLD:
    case OLD_TABLE:
    case PARAMETER:
    case PASSING:
    case PROPERTIES:
    case READS:
    case REF:
    case REFERENCING:
    case RENAME:
    case RESET:
    case RESULT:
    case RETAIN:
    case RETURNING:
    case RR:
    case RS:
    case SEQUENCE:
    case SEQUENTIAL:
    case SETS:
    case SHARE:
    case SQLID:
    case SPECIFIC:
    case SQRT:
    case STABILITY:
    case STRIP:
    case STYLE:
    case TRIGGER:
    case UCASE:
    case UR:
    case WHITESPACE:
    case IDENTIFIER:
    case DELIMITED_IDENTIFIER:
      str = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
        checkAuthorizationLength(str);
        list.add(str);
      break;
    case PUBLIC:
      jj_consume_token(PUBLIC);
        list.add( Authorizer.PUBLIC_AUTHORIZATION_ID);
      break;
    default:
      jj_la1[307] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="revokeStatement">revokeStatement</A>
 */
  final public StatementNode revokeStatement() throws ParseException, StandardException {
    StatementNode node;
    jj_consume_token(REVOKE);
          checkVersion( DataDictionary.DD_VERSION_DERBY_10_2, "REVOKE");
          checkSqlStandardAccess( "REVOKE");
    switch (jj_nt.kind) {
    case ALL:
    case DELETE:
    case INSERT:
    case REFERENCES:
    case SELECT:
    case UPDATE:
    case TRIGGER:
      node = tableRevokeStatement();
      break;
    case EXECUTE:
      node = routineRevokeStatement();
      break;
    default:
      jj_la1[308] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableRevokeStatement">tableRevokeStatement</A>
 */
  final public StatementNode tableRevokeStatement() throws ParseException, StandardException {
    PrivilegeNode privileges = null;
    List grantees;
    privileges = tablePrivileges();
    jj_consume_token(FROM);
    grantees = granteeList();
        {if (true) return (StatementNode) nodeFactory.getNode( C_NodeTypes.REVOKE_NODE,
                                    privileges, grantees,
                                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

 // end of tableRevokeStatement

/*
 * <A NAME="routineRevokeStatement">routineRevokeStatement</A>
 */
  final public StatementNode routineRevokeStatement() throws ParseException, StandardException {
    List grantees;
    RoutineDesignator routine = null;
    jj_consume_token(EXECUTE);
    jj_consume_token(ON);
    routine = routineDesignator();
    jj_consume_token(FROM);
    grantees = granteeList();
    jj_consume_token(RESTRICT);
        PrivilegeNode routinePrivilege = (PrivilegeNode)
          nodeFactory.getNode( C_NodeTypes.PRIVILEGE_NODE,
                               ReuseFactory.getInteger( PrivilegeNode.ROUTINE_PRIVILEGES),
                               routine, null,
                               getContextManager());
        {if (true) return (StatementNode) nodeFactory.getNode( C_NodeTypes.REVOKE_NODE,
                                    routinePrivilege, grantees,
                                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

 // end of routineRevokeStatement

/*
 * <A NAME="identifier">identifier</A>
 */
  final public String internalIdentifier(int id_length_limit, boolean useANSICasing, boolean checkLength) throws ParseException, StandardException {
        String  str;
        Token   tok;
    switch (jj_nt.kind) {
    case IDENTIFIER:
      tok = jj_consume_token(IDENTIFIER);
        if( useANSICasing)
            str = StringUtil.SQLToUpperCase(tok.image);
        else
            str = getLanguageConnectionContext().convertIdentifierCase( tok.image);
                if (checkLength) {//if checkLength false, then calling method would do the length limit checks
                        //limit the identifier to the id length limit passed to this method
                        checkIdentifierLengthLimit(str, id_length_limit);
                }
                // Remember whether last token was a delimited identifier
                nextToLastTokenDelimitedIdentifier = lastTokenDelimitedIdentifier;
                lastTokenDelimitedIdentifier = Boolean.FALSE;
                nextToLastIdentifierToken = lastIdentifierToken;
                lastIdentifierToken = tok;
                {if (true) return str;}
      break;
    case DELIMITED_IDENTIFIER:
      str = delimitedIdentifier();
                if (checkLength) {//if checkLength false, then calling method would do the length limit checks
                        //limit the identifier to the id length limit passed to this method
                        checkIdentifierLengthLimit(str, id_length_limit);
                }
                {if (true) return str;}
      break;
    case BINARY:
    case COALESCE:
    case COUNT:
    case D:
    case MODULE:
    case T:
    case TS:
    case VALUE:
    case VARBINARY:
    case ABS:
    case ABSVAL:
    case ACTION:
    case ALWAYS:
    case BLOB:
    case C:
    case CALLED:
    case CLOB:
    case COBOL:
    case COMMITTED:
    case CONCAT:
    case CONTAINS:
    case DATA:
    case DATE:
    case DAY:
    case DYNAMIC:
    case FORTRAN:
    case GENERATED:
    case IDENTITY_VAL_LOCAL:
    case INCREMENT:
    case INITIAL:
    case INTERVAL:
    case LANGUAGE:
    case LARGE:
    case LENGTH:
    case LEVEL:
    case LOCKS:
    case LOCKSIZE:
    case LOGGED:
    case MOD:
    case MODIFIES:
    case MODIFY:
    case MONTH:
    case _MORE:
    case MUMPS:
    case NAME:
    case NCLOB:
    case NULLABLE:
    case NUMBER:
    case OBJECT:
    case PASCAL:
    case PLI:
    case PRECISION:
    case RELEASE:
    case REPEATABLE:
    case RESTART:
    case RETURNS:
    case ROW:
    case SAVEPOINT:
    case SCALE:
    case SERIALIZABLE:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case START:
    case STATEMENT:
    case SYNONYM:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TRUNCATE:
    case TYPE:
    case UNCOMMITTED:
    case USAGE:
    case WHEN:
    case CURDATE:
    case CURTIME:
    case DATABASE:
    case LONG:
    case AFTER:
    case BEFORE:
    case CLASS:
    case COMPRESS:
    case CONTENT:
    case CS:
    case DB2SQL:
    case DIRTY:
    case DOCUMENT:
    case EACH:
    case EMPTY:
    case EXCLUSIVE:
    case FN:
    case INDEX:
    case JAVA:
    case LCASE:
    case LOCATE:
    case LOCK:
    case MESSAGE_LOCALE:
    case METHOD:
    case MODE:
    case NEW:
    case NEW_TABLE:
    case OJ:
    case OFF:
    case OLD:
    case OLD_TABLE:
    case PARAMETER:
    case PASSING:
    case PROPERTIES:
    case READS:
    case REF:
    case REFERENCING:
    case RENAME:
    case RESET:
    case RESULT:
    case RETAIN:
    case RETURNING:
    case RR:
    case RS:
    case SEQUENCE:
    case SEQUENTIAL:
    case SETS:
    case SHARE:
    case SQLID:
    case SPECIFIC:
    case SQRT:
    case STABILITY:
    case STRIP:
    case STYLE:
    case TRIGGER:
    case UCASE:
    case UR:
    case WHITESPACE:
      str = nonReservedKeyword();
                {if (true) return getLanguageConnectionContext().convertIdentifierCase( str);}
      break;
    default:
      jj_la1[309] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String identifier(int id_length_limit, boolean checkLength) throws ParseException, StandardException {
        String  id;
    id = internalIdentifier(id_length_limit, false, checkLength);
        {if (true) return id;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="delimitedIdentifier">delimitedIdentifier</A>
 */
  final public String delimitedIdentifier() throws ParseException {
        String  str;
        Token   tok;
    tok = jj_consume_token(DELIMITED_IDENTIFIER);
                str = tok.image.substring(1, tok.image.length() -1);
                str = normalizeDelimitedID( str );
                // Remember whether last token was a delimited identifier
                nextToLastTokenDelimitedIdentifier = lastTokenDelimitedIdentifier;
                lastTokenDelimitedIdentifier = Boolean.TRUE;
                nextToLastIdentifierToken = lastIdentifierToken;
                lastIdentifierToken = tok;

                {if (true) return str;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="reservedKeyword">reservedKeyword</A>
 */
  final public String reservedKeyword() throws ParseException {
        Token   tok;
    switch (jj_nt.kind) {
    case ADD:
      /* SQL92 reserved Keywords */
              tok = jj_consume_token(ADD);
      break;
    case ALL:
      tok = jj_consume_token(ALL);
      break;
    case ALLOCATE:
      tok = jj_consume_token(ALLOCATE);
      break;
    case ALTER:
      tok = jj_consume_token(ALTER);
      break;
    case AND:
      tok = jj_consume_token(AND);
      break;
    case ANY:
      tok = jj_consume_token(ANY);
      break;
    case ARE:
      tok = jj_consume_token(ARE);
      break;
    case AS:
      tok = jj_consume_token(AS);
      break;
    case ASC:
      tok = jj_consume_token(ASC);
      break;
    case ASSERTION:
      tok = jj_consume_token(ASSERTION);
      break;
    case AT:
      tok = jj_consume_token(AT);
      break;
    case AUTHORIZATION:
      tok = jj_consume_token(AUTHORIZATION);
      break;
    case AVG:
      tok = jj_consume_token(AVG);
      break;
    case BEGIN:
      tok = jj_consume_token(BEGIN);
      break;
    case BETWEEN:
      tok = jj_consume_token(BETWEEN);
      break;
    case BIT:
      tok = jj_consume_token(BIT);
      break;
    case BOTH:
      tok = jj_consume_token(BOTH);
      break;
    case BY:
      tok = jj_consume_token(BY);
      break;
    case CASCADE:
      tok = jj_consume_token(CASCADE);
      break;
    case CASCADED:
      tok = jj_consume_token(CASCADED);
      break;
    case CASE:
      tok = jj_consume_token(CASE);
      break;
    case CAST:
      tok = jj_consume_token(CAST);
      break;
    case CHAR:
      tok = jj_consume_token(CHAR);
      break;
    case CHARACTER:
      tok = jj_consume_token(CHARACTER);
      break;
    case CHECK:
      tok = jj_consume_token(CHECK);
      break;
    case CLOSE:
      tok = jj_consume_token(CLOSE);
      break;
    case COLLATE:
      tok = jj_consume_token(COLLATE);
      break;
    case COLLATION:
      tok = jj_consume_token(COLLATION);
      break;
    case COLUMN:
      tok = jj_consume_token(COLUMN);
      break;
    case COMMIT:
      tok = jj_consume_token(COMMIT);
      break;
    case CONNECT:
      tok = jj_consume_token(CONNECT);
      break;
    case CONNECTION:
      tok = jj_consume_token(CONNECTION);
      break;
    case CONSTRAINT:
      tok = jj_consume_token(CONSTRAINT);
      break;
    case CONSTRAINTS:
      tok = jj_consume_token(CONSTRAINTS);
      break;
    case CONTINUE:
      tok = jj_consume_token(CONTINUE);
      break;
    case CONVERT:
      tok = jj_consume_token(CONVERT);
      break;
    case CORRESPONDING:
      tok = jj_consume_token(CORRESPONDING);
      break;
    case CREATE:
      tok = jj_consume_token(CREATE);
      break;
    case CURRENT:
      tok = jj_consume_token(CURRENT);
      break;
    case CURRENT_DATE:
      tok = jj_consume_token(CURRENT_DATE);
      break;
    case CURRENT_TIME:
      tok = jj_consume_token(CURRENT_TIME);
      break;
    case CURRENT_TIMESTAMP:
      tok = jj_consume_token(CURRENT_TIMESTAMP);
      break;
    case CURRENT_USER:
      tok = jj_consume_token(CURRENT_USER);
      break;
    case CURSOR:
      tok = jj_consume_token(CURSOR);
      break;
    case DEALLOCATE:
      tok = jj_consume_token(DEALLOCATE);
      break;
    case DEC:
      tok = jj_consume_token(DEC);
      break;
    case DECIMAL:
      tok = jj_consume_token(DECIMAL);
      break;
    case DECLARE:
      tok = jj_consume_token(DECLARE);
      break;
    case _DEFAULT:
      tok = jj_consume_token(_DEFAULT);
      break;
    case DEFERRABLE:
      tok = jj_consume_token(DEFERRABLE);
      break;
    case DEFERRED:
      tok = jj_consume_token(DEFERRED);
      break;
    case DELETE:
      tok = jj_consume_token(DELETE);
      break;
    case DESC:
      tok = jj_consume_token(DESC);
      break;
    case DESCRIBE:
      tok = jj_consume_token(DESCRIBE);
      break;
    case DIAGNOSTICS:
      tok = jj_consume_token(DIAGNOSTICS);
      break;
    case DISCONNECT:
      tok = jj_consume_token(DISCONNECT);
      break;
    case DISTINCT:
      tok = jj_consume_token(DISTINCT);
      break;
    case DOUBLE:
      tok = jj_consume_token(DOUBLE);
      break;
    case DROP:
      tok = jj_consume_token(DROP);
      break;
    case ELSE:
      tok = jj_consume_token(ELSE);
      break;
    case END:
      tok = jj_consume_token(END);
      break;
    case ENDEXEC:
      tok = jj_consume_token(ENDEXEC);
      break;
    case ESCAPE:
      tok = jj_consume_token(ESCAPE);
      break;
    case EXCEPT:
      tok = jj_consume_token(EXCEPT);
      break;
    case EXCEPTION:
      tok = jj_consume_token(EXCEPTION);
      break;
    case EXEC:
      tok = jj_consume_token(EXEC);
      break;
    case EXECUTE:
      tok = jj_consume_token(EXECUTE);
      break;
    case EXISTS:
      tok = jj_consume_token(EXISTS);
      break;
    case EXTERNAL:
      tok = jj_consume_token(EXTERNAL);
      break;
    case FALSE:
      tok = jj_consume_token(FALSE);
      break;
    case FETCH:
      tok = jj_consume_token(FETCH);
      break;
    case FIRST:
      tok = jj_consume_token(FIRST);
      break;
    case FLOAT:
      tok = jj_consume_token(FLOAT);
      break;
    case FOR:
      tok = jj_consume_token(FOR);
      break;
    case FOREIGN:
      tok = jj_consume_token(FOREIGN);
      break;
    case FOUND:
      tok = jj_consume_token(FOUND);
      break;
    case FROM:
      tok = jj_consume_token(FROM);
      break;
    case FULL:
      tok = jj_consume_token(FULL);
      break;
    case FUNCTION:
      tok = jj_consume_token(FUNCTION);
      break;
    case GET:
      tok = jj_consume_token(GET);
      break;
    case GET_CURRENT_CONNECTION:
      tok = jj_consume_token(GET_CURRENT_CONNECTION);
      break;
    case GLOBAL:
      tok = jj_consume_token(GLOBAL);
      break;
    case GO:
      tok = jj_consume_token(GO);
      break;
    case GOTO:
      tok = jj_consume_token(GOTO);
      break;
    case GRANT:
      tok = jj_consume_token(GRANT);
      break;
    case GROUP:
      tok = jj_consume_token(GROUP);
      break;
    case HAVING:
      tok = jj_consume_token(HAVING);
      break;
    case HOUR:
      tok = jj_consume_token(HOUR);
      break;
    case IDENTITY:
      tok = jj_consume_token(IDENTITY);
      break;
    case IMMEDIATE:
      tok = jj_consume_token(IMMEDIATE);
      break;
    case IN:
      tok = jj_consume_token(IN);
      break;
    case INDICATOR:
      tok = jj_consume_token(INDICATOR);
      break;
    case INITIALLY:
      tok = jj_consume_token(INITIALLY);
      break;
    case INNER:
      tok = jj_consume_token(INNER);
      break;
    case INOUT:
      tok = jj_consume_token(INOUT);
      break;
    case INPUT:
      tok = jj_consume_token(INPUT);
      break;
    case INSENSITIVE:
      tok = jj_consume_token(INSENSITIVE);
      break;
    case INSERT:
      tok = jj_consume_token(INSERT);
      break;
    case INT:
      tok = jj_consume_token(INT);
      break;
    case INTEGER:
      tok = jj_consume_token(INTEGER);
      break;
    case INTERSECT:
      tok = jj_consume_token(INTERSECT);
      break;
    case INTO:
      tok = jj_consume_token(INTO);
      break;
    case IS:
      tok = jj_consume_token(IS);
      break;
    case ISOLATION:
      tok = jj_consume_token(ISOLATION);
      break;
    case JOIN:
      tok = jj_consume_token(JOIN);
      break;
    case KEY:
      tok = jj_consume_token(KEY);
      break;
    case LAST:
      tok = jj_consume_token(LAST);
      break;
    case LEADING:
      tok = jj_consume_token(LEADING);
      break;
    case LEFT:
      tok = jj_consume_token(LEFT);
      break;
    case LIKE:
      tok = jj_consume_token(LIKE);
      break;
    case LOWER:
      tok = jj_consume_token(LOWER);
      break;
    case MATCH:
      tok = jj_consume_token(MATCH);
      break;
    case MAX:
      tok = jj_consume_token(MAX);
      break;
    case MIN:
      tok = jj_consume_token(MIN);
      break;
    case MINUTE:
      tok = jj_consume_token(MINUTE);
      break;
    case NATIONAL:
      tok = jj_consume_token(NATIONAL);
      break;
    case NATURAL:
      tok = jj_consume_token(NATURAL);
      break;
    case NCHAR:
      tok = jj_consume_token(NCHAR);
      break;
    case NVARCHAR:
      tok = jj_consume_token(NVARCHAR);
      break;
    case NEXT:
      tok = jj_consume_token(NEXT);
      break;
    case NO:
      tok = jj_consume_token(NO);
      break;
    case NOT:
      tok = jj_consume_token(NOT);
      break;
    case NULL:
      tok = jj_consume_token(NULL);
      break;
    case NULLIF:
      tok = jj_consume_token(NULLIF);
      break;
    case NUMERIC:
      tok = jj_consume_token(NUMERIC);
      break;
    case OF:
      tok = jj_consume_token(OF);
      break;
    case ON:
      tok = jj_consume_token(ON);
      break;
    case ONLY:
      tok = jj_consume_token(ONLY);
      break;
    case OPEN:
      tok = jj_consume_token(OPEN);
      break;
    case OPTION:
      tok = jj_consume_token(OPTION);
      break;
    case OR:
      tok = jj_consume_token(OR);
      break;
    case ORDER:
      tok = jj_consume_token(ORDER);
      break;
    case OUT:
      tok = jj_consume_token(OUT);
      break;
    case OUTER:
      tok = jj_consume_token(OUTER);
      break;
    case OUTPUT:
      tok = jj_consume_token(OUTPUT);
      break;
    case OVERLAPS:
      tok = jj_consume_token(OVERLAPS);
      break;
    case PAD:
      tok = jj_consume_token(PAD);
      break;
    case PARTIAL:
      tok = jj_consume_token(PARTIAL);
      break;
    case PREPARE:
      tok = jj_consume_token(PREPARE);
      break;
    case PRESERVE:
      tok = jj_consume_token(PRESERVE);
      break;
    case PRIMARY:
      tok = jj_consume_token(PRIMARY);
      break;
    case PRIOR:
      tok = jj_consume_token(PRIOR);
      break;
    case PRIVILEGES:
      tok = jj_consume_token(PRIVILEGES);
      break;
    case PROCEDURE:
      tok = jj_consume_token(PROCEDURE);
      break;
    case PUBLIC:
      tok = jj_consume_token(PUBLIC);
      break;
    case READ:
      tok = jj_consume_token(READ);
      break;
    case REAL:
      tok = jj_consume_token(REAL);
      break;
    case REFERENCES:
      tok = jj_consume_token(REFERENCES);
      break;
    case RELATIVE:
      tok = jj_consume_token(RELATIVE);
      break;
    case RESTRICT:
      tok = jj_consume_token(RESTRICT);
      break;
    case REVOKE:
      tok = jj_consume_token(REVOKE);
      break;
    case RIGHT:
      tok = jj_consume_token(RIGHT);
      break;
    case ROLLBACK:
      tok = jj_consume_token(ROLLBACK);
      break;
    case ROWS:
      tok = jj_consume_token(ROWS);
      break;
    case SCHEMA:
      tok = jj_consume_token(SCHEMA);
      break;
    case SCROLL:
      tok = jj_consume_token(SCROLL);
      break;
    case SECOND:
      tok = jj_consume_token(SECOND);
      break;
    case SELECT:
      tok = jj_consume_token(SELECT);
      break;
    case SESSION_USER:
      tok = jj_consume_token(SESSION_USER);
      break;
    case SET:
      tok = jj_consume_token(SET);
      break;
    case SMALLINT:
      tok = jj_consume_token(SMALLINT);
      break;
    case SOME:
      tok = jj_consume_token(SOME);
      break;
    case SPACE:
      tok = jj_consume_token(SPACE);
      break;
    case SQL:
      tok = jj_consume_token(SQL);
      break;
    case SQLCODE:
      tok = jj_consume_token(SQLCODE);
      break;
    case SQLERROR:
      tok = jj_consume_token(SQLERROR);
      break;
    case SQLSTATE:
      tok = jj_consume_token(SQLSTATE);
      break;
    case SUBSTRING:
      tok = jj_consume_token(SUBSTRING);
      break;
    case SUM:
      tok = jj_consume_token(SUM);
      break;
    case SYSTEM_USER:
      tok = jj_consume_token(SYSTEM_USER);
      break;
    case TABLE:
      tok = jj_consume_token(TABLE);
      break;
    case TEMPORARY:
      tok = jj_consume_token(TEMPORARY);
      break;
    case TIMEZONE_HOUR:
      tok = jj_consume_token(TIMEZONE_HOUR);
      break;
    case TIMEZONE_MINUTE:
      tok = jj_consume_token(TIMEZONE_MINUTE);
      break;
    case TO:
      tok = jj_consume_token(TO);
      break;
    case TRAILING:
      tok = jj_consume_token(TRAILING);
      break;
    case TRANSACTION:
      tok = jj_consume_token(TRANSACTION);
      break;
    case TRANSLATE:
      tok = jj_consume_token(TRANSLATE);
      break;
    case TRANSLATION:
      tok = jj_consume_token(TRANSLATION);
      break;
    case TRUE:
      tok = jj_consume_token(TRUE);
      break;
    case UNION:
      tok = jj_consume_token(UNION);
      break;
    case UNIQUE:
      tok = jj_consume_token(UNIQUE);
      break;
    case UNKNOWN:
      tok = jj_consume_token(UNKNOWN);
      break;
    case UPDATE:
      tok = jj_consume_token(UPDATE);
      break;
    case UPPER:
      tok = jj_consume_token(UPPER);
      break;
    case USER:
      tok = jj_consume_token(USER);
      break;
    case USING:
      tok = jj_consume_token(USING);
      break;
    case VALUES:
      tok = jj_consume_token(VALUES);
      break;
    case VARCHAR:
      tok = jj_consume_token(VARCHAR);
      break;
    case VARYING:
      tok = jj_consume_token(VARYING);
      break;
    case VIEW:
      tok = jj_consume_token(VIEW);
      break;
    case WHENEVER:
      tok = jj_consume_token(WHENEVER);
      break;
    case WHERE:
      tok = jj_consume_token(WHERE);
      break;
    case WITH:
      tok = jj_consume_token(WITH);
      break;
    case WORK:
      tok = jj_consume_token(WORK);
      break;
    case WRITE:
      tok = jj_consume_token(WRITE);
      break;
    case YEAR:
      tok = jj_consume_token(YEAR);
      break;
    case BOOLEAN:
      tok = jj_consume_token(BOOLEAN);
      break;
    case CALL:
      tok = jj_consume_token(CALL);
      break;
    case EXPLAIN:
      tok = jj_consume_token(EXPLAIN);
      break;
    case LONGINT:
      tok = jj_consume_token(LONGINT);
      break;
    case LTRIM:
      tok = jj_consume_token(LTRIM);
      break;
    case RTRIM:
      tok = jj_consume_token(RTRIM);
      break;
    case TRIM:
      tok = jj_consume_token(TRIM);
      break;
    case SUBSTR:
      tok = jj_consume_token(SUBSTR);
      break;
    case XML:
      tok = jj_consume_token(XML);
      break;
    case XMLPARSE:
      tok = jj_consume_token(XMLPARSE);
      break;
    case XMLSERIALIZE:
      tok = jj_consume_token(XMLSERIALIZE);
      break;
    case XMLEXISTS:
      tok = jj_consume_token(XMLEXISTS);
      break;
    case XMLQUERY:
      tok = jj_consume_token(XMLQUERY);
      break;
    default:
      jj_la1[310] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                // Remember whether last token was a delimited identifier
                nextToLastTokenDelimitedIdentifier = lastTokenDelimitedIdentifier;
                lastTokenDelimitedIdentifier = Boolean.FALSE;
                {if (true) return tok.image;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nonReservedKeyword">nonReservedKeyword</A>
 */
  final public String nonReservedKeyword() throws ParseException {
        Token   tok;
    switch (jj_nt.kind) {
    case ABS:
      tok = jj_consume_token(ABS);
      break;
    case ABSVAL:
      tok = jj_consume_token(ABSVAL);
      break;
    case ACTION:
      tok = jj_consume_token(ACTION);
      break;
    case AFTER:
      tok = jj_consume_token(AFTER);
      break;
    case ALWAYS:
      tok = jj_consume_token(ALWAYS);
      break;
    case BEFORE:
      tok = jj_consume_token(BEFORE);
      break;
    case BINARY:
      tok = jj_consume_token(BINARY);
      break;
    case BLOB:
      tok = jj_consume_token(BLOB);
      break;
    case C:
      tok = jj_consume_token(C);
      break;
    case CALLED:
      tok = jj_consume_token(CALLED);
      break;
    case CLASS:
      tok = jj_consume_token(CLASS);
      break;
    case CLOB:
      tok = jj_consume_token(CLOB);
      break;
    case COALESCE:
      tok = jj_consume_token(COALESCE);
      break;
    case COBOL:
      tok = jj_consume_token(COBOL);
      break;
    case COMMITTED:
      tok = jj_consume_token(COMMITTED);
      break;
    case COMPRESS:
      tok = jj_consume_token(COMPRESS);
      break;
    case CONCAT:
      tok = jj_consume_token(CONCAT);
      break;
    case CONTAINS:
      tok = jj_consume_token(CONTAINS);
      break;
    case CONTENT:
      tok = jj_consume_token(CONTENT);
      break;
    case COUNT:
      tok = jj_consume_token(COUNT);
      break;
    case CS:
      tok = jj_consume_token(CS);
      break;
    case CURDATE:
      tok = jj_consume_token(CURDATE);
      break;
    case CURTIME:
      tok = jj_consume_token(CURTIME);
      break;
    case D:
      tok = jj_consume_token(D);
      break;
    case DATA:
      tok = jj_consume_token(DATA);
      break;
    case DATE:
      tok = jj_consume_token(DATE);
      break;
    case DAY:
      tok = jj_consume_token(DAY);
      break;
    case DIRTY:
      tok = jj_consume_token(DIRTY);
      break;
    case DYNAMIC:
      tok = jj_consume_token(DYNAMIC);
      break;
    case DATABASE:
      tok = jj_consume_token(DATABASE);
      break;
    case DB2SQL:
      tok = jj_consume_token(DB2SQL);
      break;
    case DOCUMENT:
      tok = jj_consume_token(DOCUMENT);
      break;
    case EACH:
      tok = jj_consume_token(EACH);
      break;
    case EMPTY:
      tok = jj_consume_token(EMPTY);
      break;
    case EXCLUSIVE:
      tok = jj_consume_token(EXCLUSIVE);
      break;
    case FN:
      tok = jj_consume_token(FN);
      break;
    case FORTRAN:
      tok = jj_consume_token(FORTRAN);
      break;
    case GENERATED:
      tok = jj_consume_token(GENERATED);
      break;
    case IDENTITY_VAL_LOCAL:
      tok = jj_consume_token(IDENTITY_VAL_LOCAL);
      break;
    case INCREMENT:
      tok = jj_consume_token(INCREMENT);
      break;
    case INDEX:
      tok = jj_consume_token(INDEX);
      break;
    case INITIAL:
      tok = jj_consume_token(INITIAL);
      break;
    case INTERVAL:
      tok = jj_consume_token(INTERVAL);
      break;
    case JAVA:
      tok = jj_consume_token(JAVA);
      break;
    case LANGUAGE:
      tok = jj_consume_token(LANGUAGE);
      break;
    case LARGE:
      tok = jj_consume_token(LARGE);
      break;
    case LCASE:
      tok = jj_consume_token(LCASE);
      break;
    case LENGTH:
      tok = jj_consume_token(LENGTH);
      break;
    case LEVEL:
      tok = jj_consume_token(LEVEL);
      break;
    case LOCATE:
      tok = jj_consume_token(LOCATE);
      break;
    case LOCK:
      tok = jj_consume_token(LOCK);
      break;
    case LOCKS:
      tok = jj_consume_token(LOCKS);
      break;
    case LOCKSIZE:
      tok = jj_consume_token(LOCKSIZE);
      break;
    case LOGGED:
      tok = jj_consume_token(LOGGED);
      break;
    case LONG:
      tok = jj_consume_token(LONG);
      break;
    case MESSAGE_LOCALE:
      tok = jj_consume_token(MESSAGE_LOCALE);
      break;
    case METHOD:
      tok = jj_consume_token(METHOD);
      break;
    case MOD:
      tok = jj_consume_token(MOD);
      break;
    case MODE:
      tok = jj_consume_token(MODE);
      break;
    case MODIFIES:
      tok = jj_consume_token(MODIFIES);
      break;
    case MODIFY:
      tok = jj_consume_token(MODIFY);
      break;
    case MODULE:
      tok = jj_consume_token(MODULE);
      break;
    case MONTH:
      tok = jj_consume_token(MONTH);
      break;
    case _MORE:
      tok = jj_consume_token(_MORE);
      break;
    case MUMPS:
      tok = jj_consume_token(MUMPS);
      break;
    case NAME:
      tok = jj_consume_token(NAME);
      break;
    case NCLOB:
      tok = jj_consume_token(NCLOB);
      break;
    case NEW:
      tok = jj_consume_token(NEW);
      break;
    case NEW_TABLE:
      tok = jj_consume_token(NEW_TABLE);
      break;
    case NULLABLE:
      tok = jj_consume_token(NULLABLE);
      break;
    case NUMBER:
      tok = jj_consume_token(NUMBER);
      break;
    case OBJECT:
      tok = jj_consume_token(OBJECT);
      break;
    case OFF:
      tok = jj_consume_token(OFF);
      break;
    case OLD:
      tok = jj_consume_token(OLD);
      break;
    case OLD_TABLE:
      tok = jj_consume_token(OLD_TABLE);
      break;
    case OJ:
      tok = jj_consume_token(OJ);
      break;
    case PASCAL:
      tok = jj_consume_token(PASCAL);
      break;
    case PASSING:
      tok = jj_consume_token(PASSING);
      break;
    case PLI:
      tok = jj_consume_token(PLI);
      break;
    case PRECISION:
      tok = jj_consume_token(PRECISION);
      break;
    case PROPERTIES:
      tok = jj_consume_token(PROPERTIES);
      break;
    case READS:
      tok = jj_consume_token(READS);
      break;
    case REF:
      tok = jj_consume_token(REF);
      break;
    case RELEASE:
      tok = jj_consume_token(RELEASE);
      break;
    case RENAME:
      tok = jj_consume_token(RENAME);
      break;
    case REPEATABLE:
      tok = jj_consume_token(REPEATABLE);
      break;
    case REFERENCING:
      tok = jj_consume_token(REFERENCING);
      break;
    case RESET:
      tok = jj_consume_token(RESET);
      break;
    case RESTART:
      tok = jj_consume_token(RESTART);
      break;
    case RESULT:
      tok = jj_consume_token(RESULT);
      break;
    case RETAIN:
      tok = jj_consume_token(RETAIN);
      break;
    case RETURNING:
      tok = jj_consume_token(RETURNING);
      break;
    case RETURNS:
      tok = jj_consume_token(RETURNS);
      break;
    case ROW:
      tok = jj_consume_token(ROW);
      break;
    case RR:
      tok = jj_consume_token(RR);
      break;
    case RS:
      tok = jj_consume_token(RS);
      break;
    case SCALE:
      tok = jj_consume_token(SCALE);
      break;
    case SAVEPOINT:
      tok = jj_consume_token(SAVEPOINT);
      break;
    case SEQUENCE:
      tok = jj_consume_token(SEQUENCE);
      break;
    case SEQUENTIAL:
      tok = jj_consume_token(SEQUENTIAL);
      break;
    case SERIALIZABLE:
      tok = jj_consume_token(SERIALIZABLE);
      break;
    case SETS:
      tok = jj_consume_token(SETS);
      break;
    case SHARE:
      tok = jj_consume_token(SHARE);
      break;
    case SPECIFIC:
      tok = jj_consume_token(SPECIFIC);
      break;
    case SQLID:
      tok = jj_consume_token(SQLID);
      break;
    case SQL_TSI_FRAC_SECOND:
      tok = jj_consume_token(SQL_TSI_FRAC_SECOND);
      break;
    case SQL_TSI_SECOND:
      tok = jj_consume_token(SQL_TSI_SECOND);
      break;
    case SQL_TSI_MINUTE:
      tok = jj_consume_token(SQL_TSI_MINUTE);
      break;
    case SQL_TSI_HOUR:
      tok = jj_consume_token(SQL_TSI_HOUR);
      break;
    case SQL_TSI_DAY:
      tok = jj_consume_token(SQL_TSI_DAY);
      break;
    case SQL_TSI_WEEK:
      tok = jj_consume_token(SQL_TSI_WEEK);
      break;
    case SQL_TSI_MONTH:
      tok = jj_consume_token(SQL_TSI_MONTH);
      break;
    case SQL_TSI_QUARTER:
      tok = jj_consume_token(SQL_TSI_QUARTER);
      break;
    case SQL_TSI_YEAR:
      tok = jj_consume_token(SQL_TSI_YEAR);
      break;
    case SQRT:
      tok = jj_consume_token(SQRT);
      break;
    case STABILITY:
      tok = jj_consume_token(STABILITY);
      break;
    case START:
      tok = jj_consume_token(START);
      break;
    case STATEMENT:
      tok = jj_consume_token(STATEMENT);
      break;
    case STRIP:
      tok = jj_consume_token(STRIP);
      break;
    case SYNONYM:
      tok = jj_consume_token(SYNONYM);
      break;
    case STYLE:
      tok = jj_consume_token(STYLE);
      break;
    case T:
      tok = jj_consume_token(T);
      break;
    case THEN:
      tok = jj_consume_token(THEN);
      break;
    case TIME:
      tok = jj_consume_token(TIME);
      break;
    case TIMESTAMP:
      tok = jj_consume_token(TIMESTAMP);
      break;
    case TIMESTAMPADD:
      tok = jj_consume_token(TIMESTAMPADD);
      break;
    case TIMESTAMPDIFF:
      tok = jj_consume_token(TIMESTAMPDIFF);
      break;
    case TRIGGER:
      tok = jj_consume_token(TRIGGER);
      break;
    case TRUNCATE:
      tok = jj_consume_token(TRUNCATE);
      break;
    case TS:
      tok = jj_consume_token(TS);
      break;
    case TYPE:
      tok = jj_consume_token(TYPE);
      break;
    case UCASE:
      tok = jj_consume_token(UCASE);
      break;
    case UNCOMMITTED:
      tok = jj_consume_token(UNCOMMITTED);
      break;
    case UR:
      tok = jj_consume_token(UR);
      break;
    case USAGE:
      tok = jj_consume_token(USAGE);
      break;
    case VALUE:
      tok = jj_consume_token(VALUE);
      break;
    case VARBINARY:
      tok = jj_consume_token(VARBINARY);
      break;
    case PARAMETER:
      tok = jj_consume_token(PARAMETER);
      break;
    case WHEN:
      tok = jj_consume_token(WHEN);
      break;
    case WHITESPACE:
      tok = jj_consume_token(WHITESPACE);
      break;
    default:
      jj_la1[311] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                // Remember whether last token was a delimited identifier
                nextToLastTokenDelimitedIdentifier = lastTokenDelimitedIdentifier;
                lastTokenDelimitedIdentifier = Boolean.FALSE;
                nextToLastIdentifierToken = lastIdentifierToken;
                lastIdentifierToken = tok;
                {if (true) return tok.image;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="caseSensitiveIdentifierPlusReservedWords">caseSensitiveIdentifierPlusReservedWords</A>
 */
  final public String caseSensitiveIdentifierPlusReservedWords() throws ParseException {
        String str;
    switch (jj_nt.kind) {
    case BINARY:
    case COALESCE:
    case COUNT:
    case D:
    case MODULE:
    case T:
    case TS:
    case VALUE:
    case VARBINARY:
    case ABS:
    case ABSVAL:
    case ACTION:
    case ALWAYS:
    case BLOB:
    case C:
    case CALLED:
    case CLOB:
    case COBOL:
    case COMMITTED:
    case CONCAT:
    case CONTAINS:
    case DATA:
    case DATE:
    case DAY:
    case DYNAMIC:
    case FORTRAN:
    case GENERATED:
    case IDENTITY_VAL_LOCAL:
    case INCREMENT:
    case INITIAL:
    case INTERVAL:
    case LANGUAGE:
    case LARGE:
    case LENGTH:
    case LEVEL:
    case LOCKS:
    case LOCKSIZE:
    case LOGGED:
    case MOD:
    case MODIFIES:
    case MODIFY:
    case MONTH:
    case _MORE:
    case MUMPS:
    case NAME:
    case NCLOB:
    case NULLABLE:
    case NUMBER:
    case OBJECT:
    case PASCAL:
    case PLI:
    case PRECISION:
    case RELEASE:
    case REPEATABLE:
    case RESTART:
    case RETURNS:
    case ROW:
    case SAVEPOINT:
    case SCALE:
    case SERIALIZABLE:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case START:
    case STATEMENT:
    case SYNONYM:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TRUNCATE:
    case TYPE:
    case UNCOMMITTED:
    case USAGE:
    case WHEN:
    case CURDATE:
    case CURTIME:
    case DATABASE:
    case LONG:
    case AFTER:
    case BEFORE:
    case CLASS:
    case COMPRESS:
    case CONTENT:
    case CS:
    case DB2SQL:
    case DIRTY:
    case DOCUMENT:
    case EACH:
    case EMPTY:
    case EXCLUSIVE:
    case FN:
    case INDEX:
    case JAVA:
    case LCASE:
    case LOCATE:
    case LOCK:
    case MESSAGE_LOCALE:
    case METHOD:
    case MODE:
    case NEW:
    case NEW_TABLE:
    case OJ:
    case OFF:
    case OLD:
    case OLD_TABLE:
    case PARAMETER:
    case PASSING:
    case PROPERTIES:
    case READS:
    case REF:
    case REFERENCING:
    case RENAME:
    case RESET:
    case RESULT:
    case RETAIN:
    case RETURNING:
    case RR:
    case RS:
    case SEQUENCE:
    case SEQUENTIAL:
    case SETS:
    case SHARE:
    case SQLID:
    case SPECIFIC:
    case SQRT:
    case STABILITY:
    case STRIP:
    case STYLE:
    case TRIGGER:
    case UCASE:
    case UR:
    case WHITESPACE:
    case IDENTIFIER:
    case DELIMITED_IDENTIFIER:
      str = caseSensitiveIdentifier();
                {if (true) return str;}
      break;
    case ADD:
    case ALL:
    case ALLOCATE:
    case ALTER:
    case AND:
    case ANY:
    case ARE:
    case AS:
    case ASC:
    case ASSERTION:
    case AT:
    case AUTHORIZATION:
    case AVG:
    case BEGIN:
    case BETWEEN:
    case BIT:
    case BOTH:
    case BY:
    case CASCADE:
    case CASCADED:
    case CASE:
    case CAST:
    case CHAR:
    case CHARACTER:
    case CHECK:
    case CLOSE:
    case COLLATE:
    case COLLATION:
    case COLUMN:
    case COMMIT:
    case CONNECT:
    case CONNECTION:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTINUE:
    case CONVERT:
    case CORRESPONDING:
    case CREATE:
    case CURRENT:
    case CURRENT_DATE:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case DEALLOCATE:
    case DEC:
    case DECIMAL:
    case DECLARE:
    case _DEFAULT:
    case DEFERRABLE:
    case DEFERRED:
    case DELETE:
    case DESC:
    case DESCRIBE:
    case DIAGNOSTICS:
    case DISCONNECT:
    case DISTINCT:
    case DOUBLE:
    case DROP:
    case ELSE:
    case END:
    case ENDEXEC:
    case ESCAPE:
    case EXCEPT:
    case EXCEPTION:
    case EXEC:
    case EXECUTE:
    case EXISTS:
    case EXTERNAL:
    case FALSE:
    case FETCH:
    case FIRST:
    case FLOAT:
    case FOR:
    case FOREIGN:
    case FOUND:
    case FROM:
    case FULL:
    case FUNCTION:
    case GET:
    case GLOBAL:
    case GO:
    case GOTO:
    case GRANT:
    case GROUP:
    case HAVING:
    case HOUR:
    case IDENTITY:
    case IMMEDIATE:
    case IN:
    case INDICATOR:
    case INITIALLY:
    case INNER:
    case INPUT:
    case INSENSITIVE:
    case INSERT:
    case INT:
    case INTEGER:
    case INTERSECT:
    case INTO:
    case IS:
    case ISOLATION:
    case JOIN:
    case KEY:
    case LAST:
    case LEADING:
    case LEFT:
    case LIKE:
    case LOWER:
    case MATCH:
    case MAX:
    case MIN:
    case MINUTE:
    case NATIONAL:
    case NATURAL:
    case NCHAR:
    case NEXT:
    case NO:
    case NOT:
    case NULL:
    case NULLIF:
    case NUMERIC:
    case OF:
    case ON:
    case ONLY:
    case OPEN:
    case OPTION:
    case OR:
    case ORDER:
    case OUTER:
    case OUTPUT:
    case OVERLAPS:
    case PAD:
    case PARTIAL:
    case PREPARE:
    case PRESERVE:
    case PRIMARY:
    case PRIOR:
    case PRIVILEGES:
    case PROCEDURE:
    case PUBLIC:
    case READ:
    case REAL:
    case REFERENCES:
    case RELATIVE:
    case RESTRICT:
    case REVOKE:
    case RIGHT:
    case ROLLBACK:
    case ROWS:
    case SCHEMA:
    case SCROLL:
    case SECOND:
    case SELECT:
    case SESSION_USER:
    case SET:
    case SMALLINT:
    case SOME:
    case SPACE:
    case SQL:
    case SQLCODE:
    case SQLERROR:
    case SQLSTATE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TEMPORARY:
    case TIMEZONE_HOUR:
    case TIMEZONE_MINUTE:
    case TO:
    case TRANSACTION:
    case TRANSLATE:
    case TRANSLATION:
    case TRAILING:
    case TRIM:
    case TRUE:
    case UNION:
    case UNIQUE:
    case UNKNOWN:
    case UPDATE:
    case UPPER:
    case USER:
    case USING:
    case VALUES:
    case VARCHAR:
    case VARYING:
    case VIEW:
    case WHENEVER:
    case WHERE:
    case WITH:
    case WORK:
    case WRITE:
    case YEAR:
    case INOUT:
    case BOOLEAN:
    case CALL:
    case GET_CURRENT_CONNECTION:
    case EXPLAIN:
    case LONGINT:
    case LTRIM:
    case RTRIM:
    case SUBSTR:
    case XML:
    case XMLEXISTS:
    case XMLPARSE:
    case XMLQUERY:
    case XMLSERIALIZE:
    case NVARCHAR:
    case OUT:
      str = reservedKeyword();
                {if (true) return str;}
      break;
    default:
      jj_la1[312] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="caseInsensitiveIdentifierPlusReservedWords">caseInsensitiveIdentifierPlusReservedWords</A>
 */
  final public String caseInsensitiveIdentifierPlusReservedWords() throws ParseException, StandardException {
        String str;
    switch (jj_nt.kind) {
    case BINARY:
    case COALESCE:
    case COUNT:
    case D:
    case MODULE:
    case T:
    case TS:
    case VALUE:
    case VARBINARY:
    case ABS:
    case ABSVAL:
    case ACTION:
    case ALWAYS:
    case BLOB:
    case C:
    case CALLED:
    case CLOB:
    case COBOL:
    case COMMITTED:
    case CONCAT:
    case CONTAINS:
    case DATA:
    case DATE:
    case DAY:
    case DYNAMIC:
    case FORTRAN:
    case GENERATED:
    case IDENTITY_VAL_LOCAL:
    case INCREMENT:
    case INITIAL:
    case INTERVAL:
    case LANGUAGE:
    case LARGE:
    case LENGTH:
    case LEVEL:
    case LOCKS:
    case LOCKSIZE:
    case LOGGED:
    case MOD:
    case MODIFIES:
    case MODIFY:
    case MONTH:
    case _MORE:
    case MUMPS:
    case NAME:
    case NCLOB:
    case NULLABLE:
    case NUMBER:
    case OBJECT:
    case PASCAL:
    case PLI:
    case PRECISION:
    case RELEASE:
    case REPEATABLE:
    case RESTART:
    case RETURNS:
    case ROW:
    case SAVEPOINT:
    case SCALE:
    case SERIALIZABLE:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case START:
    case STATEMENT:
    case SYNONYM:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TRUNCATE:
    case TYPE:
    case UNCOMMITTED:
    case USAGE:
    case WHEN:
    case CURDATE:
    case CURTIME:
    case DATABASE:
    case LONG:
    case AFTER:
    case BEFORE:
    case CLASS:
    case COMPRESS:
    case CONTENT:
    case CS:
    case DB2SQL:
    case DIRTY:
    case DOCUMENT:
    case EACH:
    case EMPTY:
    case EXCLUSIVE:
    case FN:
    case INDEX:
    case JAVA:
    case LCASE:
    case LOCATE:
    case LOCK:
    case MESSAGE_LOCALE:
    case METHOD:
    case MODE:
    case NEW:
    case NEW_TABLE:
    case OJ:
    case OFF:
    case OLD:
    case OLD_TABLE:
    case PARAMETER:
    case PASSING:
    case PROPERTIES:
    case READS:
    case REF:
    case REFERENCING:
    case RENAME:
    case RESET:
    case RESULT:
    case RETAIN:
    case RETURNING:
    case RR:
    case RS:
    case SEQUENCE:
    case SEQUENTIAL:
    case SETS:
    case SHARE:
    case SQLID:
    case SPECIFIC:
    case SQRT:
    case STABILITY:
    case STRIP:
    case STYLE:
    case TRIGGER:
    case UCASE:
    case UR:
    case WHITESPACE:
    case IDENTIFIER:
    case DELIMITED_IDENTIFIER:
      str = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
                {if (true) return str;}
      break;
    case ADD:
    case ALL:
    case ALLOCATE:
    case ALTER:
    case AND:
    case ANY:
    case ARE:
    case AS:
    case ASC:
    case ASSERTION:
    case AT:
    case AUTHORIZATION:
    case AVG:
    case BEGIN:
    case BETWEEN:
    case BIT:
    case BOTH:
    case BY:
    case CASCADE:
    case CASCADED:
    case CASE:
    case CAST:
    case CHAR:
    case CHARACTER:
    case CHECK:
    case CLOSE:
    case COLLATE:
    case COLLATION:
    case COLUMN:
    case COMMIT:
    case CONNECT:
    case CONNECTION:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTINUE:
    case CONVERT:
    case CORRESPONDING:
    case CREATE:
    case CURRENT:
    case CURRENT_DATE:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case DEALLOCATE:
    case DEC:
    case DECIMAL:
    case DECLARE:
    case _DEFAULT:
    case DEFERRABLE:
    case DEFERRED:
    case DELETE:
    case DESC:
    case DESCRIBE:
    case DIAGNOSTICS:
    case DISCONNECT:
    case DISTINCT:
    case DOUBLE:
    case DROP:
    case ELSE:
    case END:
    case ENDEXEC:
    case ESCAPE:
    case EXCEPT:
    case EXCEPTION:
    case EXEC:
    case EXECUTE:
    case EXISTS:
    case EXTERNAL:
    case FALSE:
    case FETCH:
    case FIRST:
    case FLOAT:
    case FOR:
    case FOREIGN:
    case FOUND:
    case FROM:
    case FULL:
    case FUNCTION:
    case GET:
    case GLOBAL:
    case GO:
    case GOTO:
    case GRANT:
    case GROUP:
    case HAVING:
    case HOUR:
    case IDENTITY:
    case IMMEDIATE:
    case IN:
    case INDICATOR:
    case INITIALLY:
    case INNER:
    case INPUT:
    case INSENSITIVE:
    case INSERT:
    case INT:
    case INTEGER:
    case INTERSECT:
    case INTO:
    case IS:
    case ISOLATION:
    case JOIN:
    case KEY:
    case LAST:
    case LEADING:
    case LEFT:
    case LIKE:
    case LOWER:
    case MATCH:
    case MAX:
    case MIN:
    case MINUTE:
    case NATIONAL:
    case NATURAL:
    case NCHAR:
    case NEXT:
    case NO:
    case NOT:
    case NULL:
    case NULLIF:
    case NUMERIC:
    case OF:
    case ON:
    case ONLY:
    case OPEN:
    case OPTION:
    case OR:
    case ORDER:
    case OUTER:
    case OUTPUT:
    case OVERLAPS:
    case PAD:
    case PARTIAL:
    case PREPARE:
    case PRESERVE:
    case PRIMARY:
    case PRIOR:
    case PRIVILEGES:
    case PROCEDURE:
    case PUBLIC:
    case READ:
    case REAL:
    case REFERENCES:
    case RELATIVE:
    case RESTRICT:
    case REVOKE:
    case RIGHT:
    case ROLLBACK:
    case ROWS:
    case SCHEMA:
    case SCROLL:
    case SECOND:
    case SELECT:
    case SESSION_USER:
    case SET:
    case SMALLINT:
    case SOME:
    case SPACE:
    case SQL:
    case SQLCODE:
    case SQLERROR:
    case SQLSTATE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TEMPORARY:
    case TIMEZONE_HOUR:
    case TIMEZONE_MINUTE:
    case TO:
    case TRANSACTION:
    case TRANSLATE:
    case TRANSLATION:
    case TRAILING:
    case TRIM:
    case TRUE:
    case UNION:
    case UNIQUE:
    case UNKNOWN:
    case UPDATE:
    case UPPER:
    case USER:
    case USING:
    case VALUES:
    case VARCHAR:
    case VARYING:
    case VIEW:
    case WHENEVER:
    case WHERE:
    case WITH:
    case WORK:
    case WRITE:
    case YEAR:
    case INOUT:
    case BOOLEAN:
    case CALL:
    case GET_CURRENT_CONNECTION:
    case EXPLAIN:
    case LONGINT:
    case LTRIM:
    case RTRIM:
    case SUBSTR:
    case XML:
    case XMLEXISTS:
    case XMLPARSE:
    case XMLQUERY:
    case XMLSERIALIZE:
    case NVARCHAR:
    case OUT:
      str = reservedKeyword();
                {if (true) return getLanguageConnectionContext().convertIdentifierCase( str);}
      break;
    default:
      jj_la1[313] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="caseSensitiveIdentifier">caseSensitiveIdentifier</A>
 */
  final public String caseSensitiveIdentifier() throws ParseException {
        String  str;
        Token   tok;
    switch (jj_nt.kind) {
    case IDENTIFIER:
      tok = jj_consume_token(IDENTIFIER);
                // Remember whether last token was a delimited identifier
                nextToLastTokenDelimitedIdentifier = lastTokenDelimitedIdentifier;
                lastTokenDelimitedIdentifier = Boolean.FALSE;
                {if (true) return tok.image;}
      break;
    case DELIMITED_IDENTIFIER:
      str = delimitedIdentifier();
                {if (true) return str;}
      break;
    case BINARY:
    case COALESCE:
    case COUNT:
    case D:
    case MODULE:
    case T:
    case TS:
    case VALUE:
    case VARBINARY:
    case ABS:
    case ABSVAL:
    case ACTION:
    case ALWAYS:
    case BLOB:
    case C:
    case CALLED:
    case CLOB:
    case COBOL:
    case COMMITTED:
    case CONCAT:
    case CONTAINS:
    case DATA:
    case DATE:
    case DAY:
    case DYNAMIC:
    case FORTRAN:
    case GENERATED:
    case IDENTITY_VAL_LOCAL:
    case INCREMENT:
    case INITIAL:
    case INTERVAL:
    case LANGUAGE:
    case LARGE:
    case LENGTH:
    case LEVEL:
    case LOCKS:
    case LOCKSIZE:
    case LOGGED:
    case MOD:
    case MODIFIES:
    case MODIFY:
    case MONTH:
    case _MORE:
    case MUMPS:
    case NAME:
    case NCLOB:
    case NULLABLE:
    case NUMBER:
    case OBJECT:
    case PASCAL:
    case PLI:
    case PRECISION:
    case RELEASE:
    case REPEATABLE:
    case RESTART:
    case RETURNS:
    case ROW:
    case SAVEPOINT:
    case SCALE:
    case SERIALIZABLE:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case START:
    case STATEMENT:
    case SYNONYM:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TRUNCATE:
    case TYPE:
    case UNCOMMITTED:
    case USAGE:
    case WHEN:
    case CURDATE:
    case CURTIME:
    case DATABASE:
    case LONG:
    case AFTER:
    case BEFORE:
    case CLASS:
    case COMPRESS:
    case CONTENT:
    case CS:
    case DB2SQL:
    case DIRTY:
    case DOCUMENT:
    case EACH:
    case EMPTY:
    case EXCLUSIVE:
    case FN:
    case INDEX:
    case JAVA:
    case LCASE:
    case LOCATE:
    case LOCK:
    case MESSAGE_LOCALE:
    case METHOD:
    case MODE:
    case NEW:
    case NEW_TABLE:
    case OJ:
    case OFF:
    case OLD:
    case OLD_TABLE:
    case PARAMETER:
    case PASSING:
    case PROPERTIES:
    case READS:
    case REF:
    case REFERENCING:
    case RENAME:
    case RESET:
    case RESULT:
    case RETAIN:
    case RETURNING:
    case RR:
    case RS:
    case SEQUENCE:
    case SEQUENTIAL:
    case SETS:
    case SHARE:
    case SQLID:
    case SPECIFIC:
    case SQRT:
    case STABILITY:
    case STRIP:
    case STYLE:
    case TRIGGER:
    case UCASE:
    case UR:
    case WHITESPACE:
      str = nonReservedKeyword();
                {if (true) return str;}
      break;
    default:
      jj_la1[314] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  final private boolean jj_3R_145() {
    if (jj_scan_token(CURRENT_TIMESTAMP)) return true;
    return false;
  }

  final private boolean jj_3R_291() {
    if (jj_3R_316()) return true;
    return false;
  }

  final private boolean jj_3R_144() {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3R_271() {
    if (jj_scan_token(INOUT)) return true;
    return false;
  }

  final private boolean jj_3R_270() {
    if (jj_scan_token(OUT)) return true;
    return false;
  }

  final private boolean jj_3R_216() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_269()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) {
    jj_scanpos = xsp;
    if (jj_3R_271()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_269() {
    if (jj_scan_token(IN)) return true;
    return false;
  }

  final private boolean jj_3R_143() {
    if (jj_scan_token(CURRENT_TIME)) return true;
    return false;
  }

  final private boolean jj_3R_249() {
    if (jj_scan_token(IDENTITY_VAL_LOCAL)) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_3R_120()) return true;
    return false;
  }

  final private boolean jj_3R_195() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) return true;
    }
    return false;
  }

  final private boolean jj_3R_161() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_216()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_248() {
    if (jj_scan_token(MOD)) return true;
    return false;
  }

  final private boolean jj_3R_142() {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3R_141() {
    if (jj_scan_token(CURRENT_DATE)) return true;
    return false;
  }

  final private boolean jj_3R_162() {
    if (jj_3R_217()) return true;
    return false;
  }

  final private boolean jj_3R_247() {
    if (jj_scan_token(SQRT)) return true;
    return false;
  }

  final private boolean jj_3R_246() {
    if (jj_scan_token(ABSVAL)) return true;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_3R_161()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_162()) jj_scanpos = xsp;
    if (jj_3R_163()) return true;
    return false;
  }

  final private boolean jj_3R_73() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = (getToken(1).kind == CURRENT && getToken(2).kind == DATE);
    lookingAhead = false;
    if (!jj_semLA || jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = (getToken(1).kind == CURRENT && getToken(2).kind == TIME);
    lookingAhead = false;
    if (!jj_semLA || jj_3R_142()) {
    jj_scanpos = xsp;
    if (jj_3R_143()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = (getToken(1).kind == CURRENT && getToken(2).kind == TIMESTAMP);
    lookingAhead = false;
    if (!jj_semLA || jj_3R_144()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_140() {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3R_206() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) {
    jj_scanpos = xsp;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_245() {
    if (jj_scan_token(ABS)) return true;
    return false;
  }

  final private boolean jj_3R_109() {
    if (jj_3R_195()) return true;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_3R_85()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3R_108() {
    if (jj_scan_token(VARCHAR)) return true;
    return false;
  }

  final private boolean jj_3R_214() {
    if (jj_3R_217()) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) return true;
    }
    return false;
  }

  final private boolean jj_3R_185() {
    if (jj_3R_225()) return true;
    return false;
  }

  final private boolean jj_3R_184() {
    if (jj_3R_224()) return true;
    return false;
  }

  final private boolean jj_3R_183() {
    if (jj_3R_223()) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    return false;
  }

  final private boolean jj_3R_366() {
    if (jj_scan_token(VALUES)) return true;
    return false;
  }

  final private boolean jj_3R_154() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    return false;
  }

  final private boolean jj_3R_181() {
    if (jj_3R_222()) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_62()) return true;
    return false;
  }

  final private boolean jj_3R_314() {
    if (jj_scan_token(LEFT_BRACE)) return true;
    return false;
  }

  final private boolean jj_3R_182() {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  final private boolean jj_3_12() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(3).kind != LARGE;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_60()) return true;
    if (jj_3R_61()) return true;
    return false;
  }

  final private boolean jj_3_11() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(2).kind != LARGE;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_58()) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3R_180() {
    if (jj_scan_token(CHECK)) return true;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_330() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) {
    jj_scanpos = xsp;
    if (jj_scan_token(265)) {
    jj_scanpos = xsp;
    if (jj_scan_token(357)) {
    jj_scanpos = xsp;
    if (jj_scan_token(266)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(267)) {
    jj_scanpos = xsp;
    if (jj_scan_token(268)) {
    jj_scanpos = xsp;
    if (jj_scan_token(269)) {
    jj_scanpos = xsp;
    if (jj_scan_token(359)) {
    jj_scanpos = xsp;
    if (jj_scan_token(270)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) {
    jj_scanpos = xsp;
    if (jj_scan_token(272)) {
    jj_scanpos = xsp;
    if (jj_scan_token(360)) {
    jj_scanpos = xsp;
    if (jj_scan_token(273)) {
    jj_scanpos = xsp;
    if (jj_scan_token(274)) {
    jj_scanpos = xsp;
    if (jj_scan_token(361)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(362)) {
    jj_scanpos = xsp;
    if (jj_scan_token(342)) {
    jj_scanpos = xsp;
    if (jj_scan_token(343)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(275)) {
    jj_scanpos = xsp;
    if (jj_scan_token(276)) {
    jj_scanpos = xsp;
    if (jj_scan_token(277)) {
    jj_scanpos = xsp;
    if (jj_scan_token(365)) {
    jj_scanpos = xsp;
    if (jj_scan_token(279)) {
    jj_scanpos = xsp;
    if (jj_scan_token(344)) {
    jj_scanpos = xsp;
    if (jj_scan_token(364)) {
    jj_scanpos = xsp;
    if (jj_scan_token(366)) {
    jj_scanpos = xsp;
    if (jj_scan_token(367)) {
    jj_scanpos = xsp;
    if (jj_scan_token(368)) {
    jj_scanpos = xsp;
    if (jj_scan_token(369)) {
    jj_scanpos = xsp;
    if (jj_scan_token(370)) {
    jj_scanpos = xsp;
    if (jj_scan_token(280)) {
    jj_scanpos = xsp;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(282)) {
    jj_scanpos = xsp;
    if (jj_scan_token(283)) {
    jj_scanpos = xsp;
    if (jj_scan_token(371)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) {
    jj_scanpos = xsp;
    if (jj_scan_token(286)) {
    jj_scanpos = xsp;
    if (jj_scan_token(372)) {
    jj_scanpos = xsp;
    if (jj_scan_token(288)) {
    jj_scanpos = xsp;
    if (jj_scan_token(289)) {
    jj_scanpos = xsp;
    if (jj_scan_token(373)) {
    jj_scanpos = xsp;
    if (jj_scan_token(290)) {
    jj_scanpos = xsp;
    if (jj_scan_token(291)) {
    jj_scanpos = xsp;
    if (jj_scan_token(374)) {
    jj_scanpos = xsp;
    if (jj_scan_token(375)) {
    jj_scanpos = xsp;
    if (jj_scan_token(292)) {
    jj_scanpos = xsp;
    if (jj_scan_token(293)) {
    jj_scanpos = xsp;
    if (jj_scan_token(294)) {
    jj_scanpos = xsp;
    if (jj_scan_token(348)) {
    jj_scanpos = xsp;
    if (jj_scan_token(376)) {
    jj_scanpos = xsp;
    if (jj_scan_token(377)) {
    jj_scanpos = xsp;
    if (jj_scan_token(295)) {
    jj_scanpos = xsp;
    if (jj_scan_token(378)) {
    jj_scanpos = xsp;
    if (jj_scan_token(296)) {
    jj_scanpos = xsp;
    if (jj_scan_token(297)) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) {
    jj_scanpos = xsp;
    if (jj_scan_token(298)) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_scan_token(300)) {
    jj_scanpos = xsp;
    if (jj_scan_token(301)) {
    jj_scanpos = xsp;
    if (jj_scan_token(302)) {
    jj_scanpos = xsp;
    if (jj_scan_token(379)) {
    jj_scanpos = xsp;
    if (jj_scan_token(380)) {
    jj_scanpos = xsp;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_scan_token(304)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) {
    jj_scanpos = xsp;
    if (jj_scan_token(383)) {
    jj_scanpos = xsp;
    if (jj_scan_token(384)) {
    jj_scanpos = xsp;
    if (jj_scan_token(385)) {
    jj_scanpos = xsp;
    if (jj_scan_token(382)) {
    jj_scanpos = xsp;
    if (jj_scan_token(306)) {
    jj_scanpos = xsp;
    if (jj_scan_token(388)) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(308)) {
    jj_scanpos = xsp;
    if (jj_scan_token(389)) {
    jj_scanpos = xsp;
    if (jj_scan_token(390)) {
    jj_scanpos = xsp;
    if (jj_scan_token(391)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) {
    jj_scanpos = xsp;
    if (jj_scan_token(393)) {
    jj_scanpos = xsp;
    if (jj_scan_token(310)) {
    jj_scanpos = xsp;
    if (jj_scan_token(392)) {
    jj_scanpos = xsp;
    if (jj_scan_token(394)) {
    jj_scanpos = xsp;
    if (jj_scan_token(311)) {
    jj_scanpos = xsp;
    if (jj_scan_token(395)) {
    jj_scanpos = xsp;
    if (jj_scan_token(396)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(398)) {
    jj_scanpos = xsp;
    if (jj_scan_token(399)) {
    jj_scanpos = xsp;
    if (jj_scan_token(315)) {
    jj_scanpos = xsp;
    if (jj_scan_token(314)) {
    jj_scanpos = xsp;
    if (jj_scan_token(400)) {
    jj_scanpos = xsp;
    if (jj_scan_token(401)) {
    jj_scanpos = xsp;
    if (jj_scan_token(317)) {
    jj_scanpos = xsp;
    if (jj_scan_token(402)) {
    jj_scanpos = xsp;
    if (jj_scan_token(403)) {
    jj_scanpos = xsp;
    if (jj_scan_token(405)) {
    jj_scanpos = xsp;
    if (jj_scan_token(404)) {
    jj_scanpos = xsp;
    if (jj_scan_token(318)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(320)) {
    jj_scanpos = xsp;
    if (jj_scan_token(321)) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) {
    jj_scanpos = xsp;
    if (jj_scan_token(324)) {
    jj_scanpos = xsp;
    if (jj_scan_token(325)) {
    jj_scanpos = xsp;
    if (jj_scan_token(326)) {
    jj_scanpos = xsp;
    if (jj_scan_token(406)) {
    jj_scanpos = xsp;
    if (jj_scan_token(407)) {
    jj_scanpos = xsp;
    if (jj_scan_token(327)) {
    jj_scanpos = xsp;
    if (jj_scan_token(328)) {
    jj_scanpos = xsp;
    if (jj_scan_token(408)) {
    jj_scanpos = xsp;
    if (jj_scan_token(329)) {
    jj_scanpos = xsp;
    if (jj_scan_token(409)) {
    jj_scanpos = xsp;
    if (jj_scan_token(231)) {
    jj_scanpos = xsp;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_scan_token(331)) {
    jj_scanpos = xsp;
    if (jj_scan_token(332)) {
    jj_scanpos = xsp;
    if (jj_scan_token(333)) {
    jj_scanpos = xsp;
    if (jj_scan_token(334)) {
    jj_scanpos = xsp;
    if (jj_scan_token(410)) {
    jj_scanpos = xsp;
    if (jj_scan_token(335)) {
    jj_scanpos = xsp;
    if (jj_scan_token(243)) {
    jj_scanpos = xsp;
    if (jj_scan_token(336)) {
    jj_scanpos = xsp;
    if (jj_scan_token(411)) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) {
    jj_scanpos = xsp;
    if (jj_scan_token(412)) {
    jj_scanpos = xsp;
    if (jj_scan_token(338)) {
    jj_scanpos = xsp;
    if (jj_scan_token(251)) {
    jj_scanpos = xsp;
    if (jj_scan_token(253)) {
    jj_scanpos = xsp;
    if (jj_scan_token(387)) {
    jj_scanpos = xsp;
    if (jj_scan_token(339)) {
    jj_scanpos = xsp;
    if (jj_scan_token(413)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_3R_154()) return true;
    return false;
  }

  final private boolean jj_3R_297() {
    if (jj_3R_318()) return true;
    return false;
  }

  final private boolean jj_3R_284() {
    if (jj_scan_token(TIMESTAMP)) return true;
    return false;
  }

  final private boolean jj_3R_90() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_3R_79()) return true;
    return false;
  }

  final private boolean jj_3R_179() {
    if (jj_scan_token(UNIQUE)) return true;
    return false;
  }

  final private boolean jj_3R_283() {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  final private boolean jj_3R_282() {
    if (jj_scan_token(DATE)) return true;
    return false;
  }

  final private boolean jj_3R_222() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_282()) {
    jj_scanpos = xsp;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_218() {
    return false;
  }

  final private boolean jj_3R_226() {
    if (jj_scan_token(DELETE)) return true;
    return false;
  }

  final private boolean jj_3R_178() {
    if (jj_scan_token(FOREIGN)) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_303() {
    if (jj_3R_214()) return true;
    return false;
  }

  final private boolean jj_3R_163() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = commonDatatypeName(false);
    lookingAhead = false;
    if (!jj_semLA || jj_3R_218()) return true;
    if (jj_3R_90()) return true;
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3R_191() {
    if (jj_3R_231()) return true;
    return false;
  }

  final private boolean jj_3R_177() {
    if (jj_scan_token(PRIMARY)) return true;
    return false;
  }

  final private boolean jj_3R_190() {
    if (jj_3R_230()) return true;
    return false;
  }

  final private boolean jj_3R_189() {
    if (jj_3R_229()) return true;
    return false;
  }

  final private boolean jj_3R_188() {
    if (jj_3R_228()) return true;
    return false;
  }

  final private boolean jj_3R_258() {
    if (jj_scan_token(XMLQUERY)) return true;
    return false;
  }

  final private boolean jj_3R_332() {
    if (jj_scan_token(APPROXIMATE_NUMERIC)) return true;
    return false;
  }

  final private boolean jj_3R_89() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == CONSTRAINT;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_176()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == PRIMARY;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_177()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == FOREIGN;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_178()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == UNIQUE;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_176() {
    if (jj_scan_token(CONSTRAINT)) return true;
    return false;
  }

  final private boolean jj_3R_187() {
    if (jj_3R_227()) return true;
    return false;
  }

  final private boolean jj_3R_257() {
    if (jj_scan_token(XMLEXISTS)) return true;
    return false;
  }

  final private boolean jj_3R_97() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) {
    jj_scanpos = xsp;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_186() {
    if (jj_3R_226()) return true;
    return false;
  }

  final private boolean jj_3R_256() {
    if (jj_scan_token(XMLSERIALIZE)) return true;
    return false;
  }

  final private boolean jj_3R_331() {
    if (jj_scan_token(EXACT_NUMERIC)) return true;
    return false;
  }

  final private boolean jj_3R_311() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_331()) {
    jj_scanpos = xsp;
    if (jj_3R_332()) return true;
    }
    return false;
  }

  final private boolean jj_3R_208() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_255()) {
    jj_scanpos = xsp;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_255() {
    if (jj_scan_token(XMLPARSE)) return true;
    return false;
  }

  final private boolean jj_3R_240() {
    if (jj_scan_token(CASE)) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_scan_token(SET)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3R_277() {
    if (jj_3R_315()) return true;
    return false;
  }

  final private boolean jj_3R_147() {
    if (jj_3R_211()) return true;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_scan_token(SET)) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == SET && getToken(2).kind != CURRENT;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_91()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == SET && getToken(2).kind == CURRENT;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_92()) return true;
    }
    return false;
  }

  final private boolean jj_3R_276() {
    if (jj_3R_314()) return true;
    return false;
  }

  final private boolean jj_3R_239() {
    if (jj_scan_token(NULLIF)) return true;
    return false;
  }

  final private boolean jj_3R_275() {
    if (jj_3R_313()) return true;
    return false;
  }

  final private boolean jj_3R_238() {
    if (jj_3R_301()) return true;
    return false;
  }

  final private boolean jj_3R_342() {
    if (jj_3R_352()) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_3R_75()) return true;
    return false;
  }

  final private boolean jj_3R_160() {
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  final private boolean jj_3R_274() {
    if (jj_3R_312()) return true;
    return false;
  }

  final private boolean jj_3R_201() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_237() {
    if (jj_3R_219()) return true;
    return false;
  }

  final private boolean jj_3R_310() {
    if (jj_3R_299()) return true;
    return false;
  }

  final private boolean jj_3R_219() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_273()) {
    jj_scanpos = xsp;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_273() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_310()) jj_scanpos = xsp;
    if (jj_3R_311()) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_146()) {
    jj_scanpos = xsp;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3R_147()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_146() {
    if (jj_3R_210()) return true;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_scan_token(ALTER)) return true;
    return false;
  }

  final private boolean jj_3R_326() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3R_342()) return true;
    }
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_169() {
    if (jj_3R_219()) return true;
    return false;
  }

  final private boolean jj_3R_305() {
    if (jj_3R_326()) return true;
    return false;
  }

  final private boolean jj_3R_138() {
    if (jj_3R_208()) return true;
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_scan_token(DROP)) return true;
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_3R_73()) return true;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_215() {
    if (jj_scan_token(LEFT_PAREN)) return true;
    return false;
  }

  final private boolean jj_3R_137() {
    if (jj_scan_token(LENGTH)) return true;
    return false;
  }

  final private boolean jj_3R_136() {
    if (jj_scan_token(VALUE)) return true;
    return false;
  }

  final private boolean jj_3R_168() {
    if (jj_3R_203()) return true;
    return false;
  }

  final private boolean jj_3R_159() {
    if (jj_scan_token(NEW)) return true;
    return false;
  }

  final private boolean jj_3R_357() {
    if (jj_scan_token(MINUTE)) return true;
    return false;
  }

  final private boolean jj_3R_135() {
    if (jj_scan_token(COALESCE)) return true;
    return false;
  }

  final private boolean jj_3R_356() {
    if (jj_scan_token(HOUR)) return true;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3R_355() {
    if (jj_scan_token(DAY)) return true;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_scan_token(ON)) return true;
    return false;
  }

  final private boolean jj_3R_167() {
    if (jj_3R_203()) return true;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_scan_token(CREATE)) return true;
    return false;
  }

  final private boolean jj_3R_106() {
    if (jj_scan_token(ON)) return true;
    return false;
  }

  final private boolean jj_3R_259() {
    if (jj_3R_305()) return true;
    return false;
  }

  final private boolean jj_3R_134() {
    if (jj_3R_207()) return true;
    return false;
  }

  final private boolean jj_3R_354() {
    if (jj_scan_token(MONTH)) return true;
    return false;
  }

  final private boolean jj_3R_105() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3R_166() {
    if (jj_scan_token(USER)) return true;
    return false;
  }

  final private boolean jj_3R_133() {
    if (jj_3R_206()) return true;
    return false;
  }

  final private boolean jj_3R_353() {
    if (jj_scan_token(YEAR)) return true;
    return false;
  }

  final private boolean jj_3R_343() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_353()) {
    jj_scanpos = xsp;
    if (jj_3R_354()) {
    jj_scanpos = xsp;
    if (jj_3R_355()) {
    jj_scanpos = xsp;
    if (jj_3R_356()) {
    jj_scanpos = xsp;
    if (jj_3R_357()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_349() {
    if (jj_scan_token(SESSION_USER)) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_101()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_3R_100()) return true;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_3R_99()) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == ON && getToken(2).kind == COMMIT;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_106()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == ON && getToken(2).kind == ROLLBACK;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_107()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(2).kind == SCHEMA || getToken(2).kind == SQLID;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == DATE ||
                getToken(1).kind == TIME ||
                getToken(1).kind == TIMESTAMP;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_167()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(2).kind == LEFT_PAREN ||
                       (getToken(4).kind == LEFT_PAREN &&
                        getToken(2).kind != COMMA);
    lookingAhead = false;
    if (!jj_semLA || jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_165() {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3R_348() {
    if (jj_scan_token(CURRENT_USER)) return true;
    return false;
  }

  final private boolean jj_3R_193() {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3R_132() {
    if (jj_scan_token(GET_CURRENT_CONNECTION)) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_103() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(215)) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == CURRENT && ( getToken(2).kind == SCHEMA ||  getToken(2).kind == SQLID );
    lookingAhead = false;
    if (!jj_semLA || jj_3R_193()) return true;
    }
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_43()) return true;
    return false;
  }

  final private boolean jj_3R_347() {
    if (jj_scan_token(USER)) return true;
    return false;
  }

  final private boolean jj_3R_340() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_347()) {
    jj_scanpos = xsp;
    if (jj_3R_348()) {
    jj_scanpos = xsp;
    if (jj_3R_349()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_3R_97()) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_3R_95()) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_94()) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_322() {
    if (jj_3R_340()) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_3R_103()) return true;
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_3R_89()) return true;
    return false;
  }

  final private boolean jj_3R_321() {
    if (jj_3R_339()) return true;
    return false;
  }

  final private boolean jj_3R_301() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_3R_322()) return true;
    }
    return false;
  }

  final private boolean jj_3R_244() {
    if (jj_3R_303()) return true;
    return false;
  }

  final private boolean jj_3R_209() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(183)) jj_scanpos = xsp;
    if (jj_3R_259()) return true;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_scan_token(DECLARE)) return true;
    return false;
  }

  final private boolean jj_3R_318() {
    if (jj_3R_338()) return true;
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_3R_73()) return true;
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_3R_87()) return true;
    return false;
  }

  final private boolean jj_3R_364() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_scan_token(140)) {
    jj_scanpos = xsp;
    if (jj_scan_token(141)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(345)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) {
    jj_scanpos = xsp;
    if (jj_scan_token(173)) {
    jj_scanpos = xsp;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_scan_token(381)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(184)) {
    jj_scanpos = xsp;
    if (jj_scan_token(185)) {
    jj_scanpos = xsp;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) {
    jj_scanpos = xsp;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(193)) {
    jj_scanpos = xsp;
    if (jj_scan_token(386)) {
    jj_scanpos = xsp;
    if (jj_scan_token(194)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(196)) {
    jj_scanpos = xsp;
    if (jj_scan_token(197)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(199)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(203)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(208)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(212)) {
    jj_scanpos = xsp;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(215)) {
    jj_scanpos = xsp;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_scan_token(217)) {
    jj_scanpos = xsp;
    if (jj_scan_token(218)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) {
    jj_scanpos = xsp;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_scan_token(221)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(224)) {
    jj_scanpos = xsp;
    if (jj_scan_token(225)) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(230)) {
    jj_scanpos = xsp;
    if (jj_scan_token(232)) {
    jj_scanpos = xsp;
    if (jj_scan_token(233)) {
    jj_scanpos = xsp;
    if (jj_scan_token(234)) {
    jj_scanpos = xsp;
    if (jj_scan_token(235)) {
    jj_scanpos = xsp;
    if (jj_scan_token(236)) {
    jj_scanpos = xsp;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(237)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) {
    jj_scanpos = xsp;
    if (jj_scan_token(239)) {
    jj_scanpos = xsp;
    if (jj_scan_token(242)) {
    jj_scanpos = xsp;
    if (jj_scan_token(244)) {
    jj_scanpos = xsp;
    if (jj_scan_token(245)) {
    jj_scanpos = xsp;
    if (jj_scan_token(246)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) {
    jj_scanpos = xsp;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(249)) {
    jj_scanpos = xsp;
    if (jj_scan_token(250)) {
    jj_scanpos = xsp;
    if (jj_scan_token(252)) {
    jj_scanpos = xsp;
    if (jj_scan_token(254)) {
    jj_scanpos = xsp;
    if (jj_scan_token(255)) {
    jj_scanpos = xsp;
    if (jj_scan_token(256)) {
    jj_scanpos = xsp;
    if (jj_scan_token(257)) {
    jj_scanpos = xsp;
    if (jj_scan_token(258)) {
    jj_scanpos = xsp;
    if (jj_scan_token(259)) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(261)) {
    jj_scanpos = xsp;
    if (jj_scan_token(262)) {
    jj_scanpos = xsp;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(341)) {
    jj_scanpos = xsp;
    if (jj_scan_token(346)) {
    jj_scanpos = xsp;
    if (jj_scan_token(347)) {
    jj_scanpos = xsp;
    if (jj_scan_token(349)) {
    jj_scanpos = xsp;
    if (jj_scan_token(350)) {
    jj_scanpos = xsp;
    if (jj_scan_token(241)) {
    jj_scanpos = xsp;
    if (jj_scan_token(351)) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(354)) {
    jj_scanpos = xsp;
    if (jj_scan_token(356)) {
    jj_scanpos = xsp;
    if (jj_scan_token(353)) {
    jj_scanpos = xsp;
    if (jj_scan_token(355)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_334() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  final private boolean jj_3R_333() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3R_315() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_333()) {
    jj_scanpos = xsp;
    if (jj_3R_334()) return true;
    }
    return false;
  }

  final private boolean jj_3R_338() {
    if (jj_3R_346()) return true;
    return false;
  }

  final private boolean jj_3R_232() {
    if (jj_3R_297()) return true;
    return false;
  }

  final private boolean jj_3R_139() {
    if (jj_3R_209()) return true;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_3R_70()) return true;
    return false;
  }

  final private boolean jj_3R_329() {
    if (jj_scan_token(DELIMITED_IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_104() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = javaClassFollows();
    lookingAhead = false;
    if (!jj_semLA || jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3_23()) return true;
    }
    return false;
  }

  final private boolean jj_3R_194() {
    if (jj_3R_232()) return true;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_3R_139()) return true;
    return false;
  }

  final private boolean jj_3R_158() {
    if (jj_scan_token(LEFT_PAREN)) return true;
    return false;
  }

  final private boolean jj_3R_281() {
    if (jj_scan_token(UR)) return true;
    return false;
  }

  final private boolean jj_3R_203() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = ( (getToken(1).kind == GET_CURRENT_CONNECTION ||
                getToken(1).kind == ABS ||
                getToken(1).kind == ABSVAL ||
                getToken(1).kind == SQRT ||
                getToken(1).kind == MOD ||
                getToken(1).kind == COALESCE ||
                getToken(1).kind == VALUE ||
                getToken(1).kind == IDENTITY_VAL_LOCAL ||
                getToken(1).kind == SUBSTRING ||
                getToken(1).kind == SUBSTR ||
                getToken(1).kind == UPPER ||
                getToken(1).kind == LOWER ||
                getToken(1).kind == UCASE ||
                getToken(1).kind == LCASE ||
                getToken(1).kind == LTRIM ||
                getToken(1).kind == RTRIM ||
                getToken(1).kind == TRIM ||
                getToken(1).kind == DATE ||
                getToken(1).kind == TIME ||
                getToken(1).kind == TIMESTAMP ||
                getToken(1).kind == DOUBLE ||
                getToken(1).kind == CHAR ||
                getToken(1).kind == VARCHAR ||
                getToken(1).kind == INTEGER ||
                getToken(1).kind == INT ||
                getToken(1).kind == SMALLINT ||
                getToken(1).kind == LONGINT ||
                getToken(1).kind == YEAR ||
                getToken(1).kind == MONTH ||
                getToken(1).kind == DAY ||
                getToken(1).kind == HOUR ||
                getToken(1).kind == MINUTE ||
                getToken(1).kind == SECOND ||
                getToken(1).kind == LENGTH ||
                getToken(1).kind == LOCATE ||
                getToken(1).kind == XMLPARSE ||
                getToken(1).kind == XMLSERIALIZE ||
                getToken(1).kind == XMLEXISTS ||
                getToken(1).kind == XMLQUERY ) &&
              getToken(2).kind == LEFT_PAREN
              );
    lookingAhead = false;
    if (!jj_semLA || jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_243() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_217() {
    if (jj_3R_272()) return true;
    return false;
  }

  final private boolean jj_3R_280() {
    if (jj_scan_token(CS)) return true;
    return false;
  }

  final private boolean jj_3R_263() {
    if (jj_3R_306()) return true;
    return false;
  }

  final private boolean jj_3R_279() {
    if (jj_scan_token(RS)) return true;
    return false;
  }

  final private boolean jj_3R_153() {
    if (jj_3R_213()) return true;
    return false;
  }

  final private boolean jj_3R_262() {
    if (jj_scan_token(TIMESTAMP)) return true;
    return false;
  }

  final private boolean jj_3R_309() {
    if (jj_3R_330()) return true;
    return false;
  }

  final private boolean jj_3R_278() {
    if (jj_scan_token(RR)) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) return true;
    }
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_296() {
    if (jj_scan_token(RELEASE)) return true;
    return false;
  }

  final private boolean jj_3R_175() {
    if (jj_scan_token(READ)) return true;
    return false;
  }

  final private boolean jj_3R_295() {
    if (jj_scan_token(ROLLBACK)) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_72()) return true;
    return false;
  }

  final private boolean jj_3R_131() {
    if (jj_3R_205()) return true;
    return false;
  }

  final private boolean jj_3R_261() {
    if (jj_scan_token(DATE)) return true;
    return false;
  }

  final private boolean jj_3R_308() {
    if (jj_3R_329()) return true;
    return false;
  }

  final private boolean jj_3R_174() {
    if (jj_scan_token(READ)) return true;
    return false;
  }

  final private boolean jj_3R_220() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_278()) {
    jj_scanpos = xsp;
    if (jj_3R_279()) {
    jj_scanpos = xsp;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_294() {
    if (jj_scan_token(SAVEPOINT)) return true;
    return false;
  }

  final private boolean jj_3R_231() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_225() {
    if (jj_scan_token(XML)) return true;
    return false;
  }

  final private boolean jj_3R_210() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_260()) {
    jj_scanpos = xsp;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_260() {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  final private boolean jj_3R_173() {
    if (jj_scan_token(DIRTY)) return true;
    return false;
  }

  final private boolean jj_3R_172() {
    if (jj_scan_token(CURSOR)) return true;
    return false;
  }

  final private boolean jj_3R_221() {
    if (jj_scan_token(REPEATABLE)) return true;
    return false;
  }

  final private boolean jj_3R_171() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_221()) {
    jj_scanpos = xsp;
    if (jj_scan_token(317)) return true;
    }
    return false;
  }

  final private boolean jj_3R_307() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_170() {
    if (jj_3R_220()) return true;
    return false;
  }

  final private boolean jj_3R_272() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) {
    jj_scanpos = xsp;
    if (jj_3R_309()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_157() {
    if (jj_3R_215()) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_213() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3R_130() {
    if (jj_scan_token(LEFT_PAREN)) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == READ && getToken(2).kind == COMMITTED;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_174()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == READ && getToken(2).kind == UNCOMMITTED;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_175()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_49() {
    if (jj_3R_88()) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_56()) return true;
    return false;
  }

  final private boolean jj_3R_148() {
    if (jj_3R_212()) return true;
    return false;
  }

  final private boolean jj_3R_129() {
    if (jj_3R_204()) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) return true;
    }
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_3R_64()) return true;
    return false;
  }

  final private boolean jj_3R_128() {
    if (jj_3R_203()) return true;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_3R_67()) return true;
    return false;
  }

  final private boolean jj_3R_300() {
    if (jj_3R_303()) return true;
    return false;
  }

  final private boolean jj_3R_236() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(2).kind == PERIOD &&
                getToken(4).kind == LEFT_PAREN;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_300()) {
    jj_scanpos = xsp;
    if (jj_3_9()) return true;
    }
    return false;
  }

  final private boolean jj_3R_223() {
    if (jj_scan_token(LONG)) return true;
    return false;
  }

  final private boolean jj_3R_127() {
    if (jj_3R_202()) return true;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_126() {
    if (jj_3R_159()) return true;
    return false;
  }

  final private boolean jj_3R_116() {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  final private boolean jj_3R_119() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(2).kind == PERIOD &&
                        (
                                getToken(3).kind == ASTERISK ||
                                (getToken(4).kind == PERIOD && getToken(5).kind == ASTERISK)
                        );
    lookingAhead = false;
    if (!jj_semLA || jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3_18()) return true;
    }
    return false;
  }

  final private boolean jj_3R_197() {
    if (jj_3R_214()) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(2).kind == PRECISION;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) return true;
    }
    return false;
  }

  final private boolean jj_3R_125() {
    if (jj_3R_201()) return true;
    return false;
  }

  final private boolean jj_3R_192() {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3R_102() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == CURRENT && getToken(2).kind == ISOLATION;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_192()) return true;
    }
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_3R_64()) return true;
    return false;
  }

  final private boolean jj_3R_156() {
    if (jj_3R_214()) return true;
    return false;
  }

  final private boolean jj_3R_124() {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_102()) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_3R_119()) return true;
    return false;
  }

  final private boolean jj_3R_123() {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3R_115() {
    if (jj_scan_token(REAL)) return true;
    return false;
  }

  final private boolean jj_3R_200() {
    if (jj_scan_token(PERIOD)) return true;
    return false;
  }

  final private boolean jj_3R_152() {
    if (jj_scan_token(RETURNING)) return true;
    return false;
  }

  final private boolean jj_3R_122() {
    if (jj_scan_token(LEFT_BRACE)) return true;
    return false;
  }

  final private boolean jj_3R_70() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = escapedValueFunctionFollows();
    lookingAhead = false;
    if (!jj_semLA || jj_3R_122()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(2).kind == SCHEMA || getToken(2).kind == SQLID;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_123()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(2).kind == ISOLATION;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = newInvocationFollows(1);
    lookingAhead = false;
    if (!jj_semLA || jj_3R_126()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = aggregateFollows();
    lookingAhead = false;
    if (!jj_semLA || jj_3R_127()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = miscBuiltinFollows();
    lookingAhead = false;
    if (!jj_semLA || jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_scan_token(REVOKE)) return true;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(2).kind == SEQUENCE;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) return true;
    }
    return false;
  }

  final private boolean jj_3R_151() {
    if (jj_scan_token(RETURNING)) return true;
    return false;
  }

  final private boolean jj_3R_101() {
    if (jj_scan_token(EXECUTE)) return true;
    return false;
  }

  final private boolean jj_3R_337() {
    if (jj_3R_339()) return true;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_3R_160()) return true;
    return false;
  }

  final private boolean jj_3R_351() {
    if (jj_scan_token(LTRIM)) return true;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_3R_159()) return true;
    return false;
  }

  final private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == LEFT_PAREN &&
                                (
                                        getToken(2).kind == SELECT ||
                                        getToken(2).kind == VALUES
                                );
    lookingAhead = false;
    if (!jj_semLA || jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_41() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = newInvocationFollows(1);
    lookingAhead = false;
    if (!jj_semLA || jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    }
    return false;
  }

  final private boolean jj_3R_350() {
    if (jj_scan_token(RTRIM)) return true;
    return false;
  }

  final private boolean jj_3R_341() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_350()) {
    jj_scanpos = xsp;
    if (jj_3R_351()) return true;
    }
    return false;
  }

  final private boolean jj_3R_336() {
    if (jj_scan_token(CALL)) return true;
    return false;
  }

  final private boolean jj_3R_317() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) return true;
    }
    return false;
  }

  final private boolean jj_3R_121() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(3).kind == LEFT_PAREN;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) return true;
    }
    return false;
  }

  final private boolean jj_3R_199() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(444)) {
    jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    }
    return false;
  }

  final private boolean jj_3R_114() {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3_15()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_293() {
    if (jj_scan_token(LEFT_BRACE)) return true;
    return false;
  }

  final private boolean jj_3R_292() {
    if (jj_3R_317()) return true;
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  final private boolean jj_3R_150() {
    if (jj_scan_token(BY)) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_3R_121()) return true;
    return false;
  }

  final private boolean jj_3R_268() {
    if (jj_scan_token(LONGINT)) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(2).kind == REF;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    return false;
  }

  final private boolean jj_3R_149() {
    if (jj_scan_token(BY)) return true;
    return false;
  }

  final private boolean jj_3R_230() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_292()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) return true;
    }
    return false;
  }

  final private boolean jj_3R_267() {
    if (jj_scan_token(SMALLINT)) return true;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_3R_69()) return true;
    return false;
  }

  final private boolean jj_3R_212() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_266() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) return true;
    }
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_3R_72()) return true;
    return false;
  }

  final private boolean jj_3R_117() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == DISTINCT &&
                        !(
                                getToken(2).kind == PERIOD ||
                                getToken(2).kind == DOUBLE_COLON
                        );
    lookingAhead = false;
    if (!jj_semLA || jj_3R_117()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == ALL &&
                        !(
                                getToken(2).kind == PERIOD ||
                                getToken(2).kind == DOUBLE_COLON
                        );
    lookingAhead = false;
    if (!jj_semLA || jj_3R_118()) return true;
    }
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_3R_104()) return true;
    return false;
  }

  final private boolean jj_3R_234() {
    if (jj_3R_212()) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_3R_65()) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  final private boolean jj_3R_339() {
    if (jj_scan_token(QUESTION_MARK)) return true;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_365() {
    if (jj_scan_token(SELECT)) return true;
    return false;
  }

  final private boolean jj_3R_320() {
    if (jj_scan_token(MINUS_SIGN)) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3R_319() {
    if (jj_scan_token(PLUS_SIGN)) return true;
    return false;
  }

  final private boolean jj_3R_299() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_319()) {
    jj_scanpos = xsp;
    if (jj_3R_320()) return true;
    }
    return false;
  }

  final private boolean jj_3R_362() {
    if (jj_3R_366()) return true;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_155() {
    if (jj_scan_token(LEFT_BRACE)) return true;
    return false;
  }

  final private boolean jj_3R_361() {
    if (jj_3R_365()) return true;
    return false;
  }

  final private boolean jj_3R_358() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_361()) {
    jj_scanpos = xsp;
    if (jj_3R_362()) return true;
    }
    return false;
  }

  final private boolean jj_3R_80() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) return true;
    }
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_3R_81()) return true;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3R_325() {
    if (jj_scan_token(TRIM)) return true;
    return false;
  }

  final private boolean jj_3R_298() {
    if (jj_scan_token(NUMERIC)) return true;
    return false;
  }

  final private boolean jj_3R_265() {
    if (jj_scan_token(VARCHAR)) return true;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_3R_90()) return true;
    return false;
  }

  final private boolean jj_3R_324() {
    if (jj_3R_341()) return true;
    return false;
  }

  final private boolean jj_3R_304() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_324()) {
    jj_scanpos = xsp;
    if (jj_3R_325()) return true;
    }
    return false;
  }

  final private boolean jj_3R_196() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) return true;
    }
    return false;
  }

  final private boolean jj_3R_233() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_298()) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_211() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) return true;
    }
    return false;
  }

  final private boolean jj_3R_264() {
    if (jj_scan_token(CHAR)) return true;
    return false;
  }

  final private boolean jj_3R_345() {
    if (jj_scan_token(LEFT_PAREN)) return true;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_3R_80()) return true;
    return false;
  }

  final private boolean jj_3R_344() {
    if (jj_3R_358()) return true;
    return false;
  }

  final private boolean jj_3R_335() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_344()) {
    jj_scanpos = xsp;
    if (jj_3R_345()) return true;
    }
    return false;
  }

  final private boolean jj_3R_235() {
    if (jj_3R_299()) return true;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_3R_63()) return true;
    return false;
  }

  final private boolean jj_3R_113() {
    if (jj_3R_196()) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3_14()) return true;
    }
    return false;
  }

  final private boolean jj_3R_198() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_235()) jj_scanpos = xsp;
    if (jj_3R_236()) return true;
    return false;
  }

  final private boolean jj_3R_254() {
    if (jj_scan_token(LOCATE)) return true;
    return false;
  }

  final private boolean jj_3R_253() {
    if (jj_3R_304()) return true;
    return false;
  }

  final private boolean jj_3R_205() {
    if (jj_scan_token(CAST)) return true;
    return false;
  }

  final private boolean jj_3R_290() {
    if (jj_scan_token(NATIONAL)) return true;
    return false;
  }

  final private boolean jj_3R_369() {
    if (jj_3R_330()) return true;
    return false;
  }

  final private boolean jj_3R_289() {
    if (jj_3R_195()) return true;
    return false;
  }

  final private boolean jj_3R_368() {
    if (jj_3R_329()) return true;
    return false;
  }

  final private boolean jj_3R_252() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(411)) {
    jj_scanpos = xsp;
    if (jj_scan_token(373)) return true;
    }
    return false;
  }

  final private boolean jj_3R_288() {
    if (jj_scan_token(BINARY)) return true;
    return false;
  }

  final private boolean jj_3R_367() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_363() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_367()) {
    jj_scanpos = xsp;
    if (jj_3R_368()) {
    jj_scanpos = xsp;
    if (jj_3R_369()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_251() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) return true;
    }
    return false;
  }

  final private boolean jj_3R_229() {
    if (jj_scan_token(UPDATE)) return true;
    return false;
  }

  final private boolean jj_3R_287() {
    if (jj_scan_token(NCLOB)) return true;
    return false;
  }

  final private boolean jj_3R_323() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_207() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_250() {
    if (jj_scan_token(SUBSTR)) return true;
    return false;
  }

  final private boolean jj_3R_286() {
    if (jj_scan_token(CLOB)) return true;
    return false;
  }

  final private boolean jj_3R_285() {
    if (jj_scan_token(BLOB)) return true;
    return false;
  }

  final private boolean jj_3R_224() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) {
    jj_scanpos = xsp;
    if (jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_328() {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3R_327() {
    if (jj_3R_343()) return true;
    return false;
  }

  final private boolean jj_3R_306() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_327()) {
    jj_scanpos = xsp;
    if (jj_3R_328()) return true;
    }
    return false;
  }

  final private boolean jj_3R_302() {
    if (jj_3R_323()) return true;
    return false;
  }

  final private boolean jj_3R_360() {
    if (jj_3R_364()) return true;
    return false;
  }

  final private boolean jj_3R_359() {
    if (jj_3R_363()) return true;
    return false;
  }

  final private boolean jj_3R_346() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_359()) {
    jj_scanpos = xsp;
    if (jj_3R_360()) return true;
    }
    return false;
  }

  final private boolean jj_3R_120() {
    if (jj_3R_198()) return true;
    return false;
  }

  final private boolean jj_3R_164() {
    if (jj_3R_217()) return true;
    return false;
  }

  final private boolean jj_3R_112() {
    if (jj_scan_token(NVARCHAR)) return true;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_3R_65()) return true;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_3R_77()) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_164()) jj_scanpos = xsp;
    if (jj_3R_163()) return true;
    return false;
  }

  final private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_43()) jj_scanpos = xsp;
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_228() {
    if (jj_scan_token(INSERT)) return true;
    return false;
  }

  final private boolean jj_3R_313() {
    if (jj_scan_token(HEX_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_316() {
    if (jj_3R_335()) return true;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3R_111() {
    if (jj_scan_token(NCHAR)) return true;
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_3R_84()) return true;
    return false;
  }

  final private boolean jj_3R_242() {
    if (jj_3R_302()) return true;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_scan_token(GRANT)) return true;
    return false;
  }

  final private boolean jj_3R_110() {
    if (jj_scan_token(NATIONAL)) return true;
    return false;
  }

  final private boolean jj_3R_352() {
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  final private boolean jj_3R_204() {
    if (jj_3R_217()) return true;
    return false;
  }

  final private boolean jj_3R_312() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_202() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) return true;
    }
    return false;
  }

  final private boolean jj_3R_241() {
    if (jj_scan_token(COUNT)) return true;
    return false;
  }

  final private boolean jj_3R_98() {
    if (jj_scan_token(TRUNCATE)) return true;
    return false;
  }

  final private boolean jj_3R_227() {
    if (jj_3R_291()) return true;
    return false;
  }

  public SQLParserTokenManager token_source;
  public Token token, jj_nt;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[315];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static private int[] jj_la1_11;
  static private int[] jj_la1_12;
  static private int[] jj_la1_13;
  static private int[] jj_la1_14;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
      jj_la1_4();
      jj_la1_5();
      jj_la1_6();
      jj_la1_7();
      jj_la1_8();
      jj_la1_9();
      jj_la1_10();
      jj_la1_11();
      jj_la1_12();
      jj_la1_13();
      jj_la1_14();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x10000000,0x10000000,0x10000000,0x0,0x0,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x200000,0x0,0x200000,0x0,0x0,0x0,0x200000,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x48000000,0x0,0x0,0x0,0x48000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0xf8000000,0x0,0xf8000000,0xf8000000,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x800400,0x0,0x0,0x4,0x0,0x0,0x0,0x800400,0x0,0x0,0x0,0x0,0x800400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40a00400,0x40200000,0x40200000,0x40200000,0x0,0x40200000,0x40200000,0xc0400,0x0,0x0,0xc0000,0x0,0xc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800404,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffefffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x10000,0x820400,0x800400,0x0,0x800000,0x0,0x0,0x40000,0x0,0x0,0x4,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x800404,0x0,0x0,0x4,0x0,0x0,0x4,0x0,0x0,0x800400,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x40000,0x0,0x0,0x40,0x800440,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800400,0x10000,0x0,0x0,0x40000000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x40000000,0x0,0x0,0x200000,0x0,0x0,0x44a00400,0x4000000,0x4800400,0x0,0x4000000,0x4000,0x4000,0x4000000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800400,0x0,0x800400,0xff6ffbff,0x800400,0xffefffff,0xffefffff,0x800400,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x80000,0x0,0x4088010,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x808,0x0,0x0,0x0,0x0,0x20,0x0,0x808,0x0,0x0,0x0,0x0,0x808,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x808,0x10000,0x0,0x0,0x10000,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000,0x6000,0x0,0x0,0x6000,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x1000000,0x1000000,0x1000000,0x1000000,0x80000000,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x808,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x808,0x808,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x808,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x808,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x40,0x80,0x100,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x808,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x808,0x200,0x18000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x808,0x0,0x808,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x808,0x80000,0x808,0xfffff7f7,0x808,0xffffffff,0xffffffff,0x808,};
   }
   private static void jj_la1_4() {
      jj_la1_4 = new int[] {0x80000000,0x0,0x80000000,0x80004,0x0,0x0,0x4000,0x4000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x1000,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x2000000,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x10,0x0,0x0,0x2000000,0x2000000,0x10,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x80000004,0x0,0x0,0x80000000,0x4000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x80000004,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,};
   }
   private static void jj_la1_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x10000000,0x0,0x20000,0x0,0x0,0x10000000,0x0,0x800000,0x0,0x0,0x20000,0x800000,0x800000,0x800000,0x0,0x800000,0x800000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x140000,0x0,0x0,0x0,0x0,0x40000,0x4000003,0x4000000,0x0,0x0,0x4000003,0x3,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x800000,0x10,0x0,0x800000,0x800800,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0xffffffff,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x1000,0x0,0x0,0x1000,0x0,0x0,0x200,0x0,0x0,0x2000000,0x20000,0x20000,0x1000,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x3,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0xc000,0xc000,0x0,0x1000000,0x0,0x0,0x20000,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x400000,0x0,0x400000,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x400000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x10000000,0x10000000,0x0,0x400000,0x1000000,0x400000,0x0,0x0,0x0,0x800000,0x0,0x0,0x20000,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x20000,0xfffdffff,0x20000,0xffffffff,0xffffffff,0x20000,};
   }
   private static void jj_la1_6() {
      jj_la1_6 = new int[] {0x4000000,0x0,0x4200000,0x80000,0x0,0x800000,0x801000,0x801000,0x0,0x4200000,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x100,0x0,0x200,0x10200,0x10200,0x10200,0x0,0x10200,0x10200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x20000000,0x0,0x20000000,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x20000000,0x2000000,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x4,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x800000,0x800000,0x0,0x8000000,0x0,0x1,0x0,0x0,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x10040000,0x0,0x0,0x0,0x10200,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x40000,0x40000,0x0,0x0,0x0,0x1000,0x4010000,0x0,0x0,0x4010000,0x1000,0x0,0x0,0x0,0x0,0x0,0x4010000,0x0,0x2000,0x4010000,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,};
   }
   private static void jj_la1_7() {
      jj_la1_7 = new int[] {0x10800000,0x0,0x10800000,0x0,0x0,0x0,0x200100,0x100,0x0,0x10800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28080080,0x100,0x0,0x0,0x0,0x0,0x0,0x28080080,0x0,0x0,0x200000,0x0,0x28080080,0x1000,0x0,0x200000,0x0,0x0,0x0,0x0,0x28280080,0x200000,0x200000,0x200000,0x0,0x200000,0x200000,0x0,0x0,0x80000000,0x40000000,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x10000000,0x10000000,0x0,0x0,0x28080080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x2000010,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x1020000,0x20000,0x0,0x10000,0x0,0x0,0x2040000,0x28080080,0x28080080,0x1020000,0x8000000,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28080080,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x28080080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x40000000,0x0,0x0,0x0,0x28080080,0x0,0x0,0x0,0x0,0x100,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x40000,0x0,0x40000,0x0,0x80080,0x100,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2a080080,0x2040000,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x28280080,0x0,0x28080080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x100,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x28080080,0x800000,0x28080080,0xd7f7ff7f,0x28080080,0xffffffff,0xffffffff,0x28080080,};
   }
   private static void jj_la1_8() {
      jj_la1_8 = new int[] {0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x1,0x0,0x0,0x4,0x0,0x0,0x4,0x0,0x0,0x0,0x8,0x5fbfff80,0x0,0x4,0x0,0x0,0x0,0x4,0x5fbfff80,0x0,0x0,0x0,0x10,0x5fbfff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5fbfff80,0x2000008,0x0,0x0,0x2000008,0x0,0x2000008,0x104800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5fbfff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fbfffff,0x200040,0x0,0x20000,0x0,0x0,0x4000180,0x0,0x200040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5fbfff80,0x5fbfff80,0x4000180,0x0,0x0,0x300040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x300040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5fbfff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5fbfff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5fbfff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x842000,0x800000,0x842000,0x2000,0x0,0x20000000,0x20000000,0x842000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x2000008,0x400,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x5fbfff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5fbfff80,0x0,0x5fbfff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5fbfff80,0x0,0x5fbfff80,0x2000007f,0x5fbfff80,0x7fbfffff,0x7fbfffff,0x5fbfff80,};
   }
   private static void jj_la1_9() {
      jj_la1_9 = new int[] {0x0,0x0,0x4200000,0x0,0x0,0x0,0x0,0x0,0x0,0x4200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xefffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xefffffff,0x0,0x0,0x0,0x0,0xefffffff,0x0,0x4200000,0x0,0x10,0x0,0x0,0x0,0xefffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xefffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xefffffff,0x400,0x0,0x0,0x0,0xc0000000,0x80,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xefffffff,0xefffffff,0x80,0x4,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xefffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xefffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xefffffff,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x1000101,0x0,0x1000101,0x1000000,0x0,0x0,0x0,0x1000101,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20400000,0x20400000,0x0,0x20400000,0x0,0x0,0x0,0x0,0xefffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0xefffffff,0x0,0xefffffff,0x20,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xefffffff,0x0,0xefffffff,0x0,0xefffffff,0xefffffff,0xefffffff,0xefffffff,};
   }
   private static void jj_la1_10() {
      jj_la1_10 = new int[] {0x200000,0x0,0x200000,0x8000,0x0,0x200,0x200,0x200,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11cfffff,0x0,0x0,0x0,0x0,0x0,0x0,0x11cfffff,0x200000,0x200000,0x0,0x0,0x11cfffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11cfffff,0x0,0x0,0x0,0x0,0x0,0x0,0x10101800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x8000000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11cfffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xc06000,0x6000,0x7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x60000000,0x0,0x0,0x60000000,0x0,0x0,0x11cfffff,0x11cfffff,0xe2000000,0x0,0x0,0x1800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x1800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11cfffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11cfffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11cfffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x11cfffff,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11cfffff,0x0,0x11cfffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11cfffff,0x0,0x11cfffff,0xee300000,0x11cfffff,0xffffffff,0xffffffff,0x11cfffff,};
   }
   private static void jj_la1_11() {
      jj_la1_11 = new int[] {0x0,0x800000,0x0,0x0,0x800000,0x0,0x80000,0x80000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdffff7e0,0x80000,0x0,0x0,0x0,0x0,0x0,0xdffff7e0,0x0,0x0,0x0,0x0,0xdffff7e0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0xdffff7e0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdffff7e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffff7ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x600000,0x0,0x0,0x0,0x0,0x0,0x0,0xdffff7e0,0xdffff7e0,0x600000,0x1e,0x0,0x0,0x0,0x1e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdffff7e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdffff7e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdffff7e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x20,0x0,0x0,0x0,0x18000000,0x18000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x20000,0x0,0x0,0x0,0x0,0x0,0x2400,0x400,0x0,0x0,0x0,0x0,0x0,0xdffff7e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0xdffff7e0,0x0,0xdffff7e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdffff7e0,0x0,0xdffff7e0,0x2000001f,0xdffff7e0,0xfffff7ff,0xfffff7ff,0xdffff7e0,};
   }
   private static void jj_la1_12() {
      jj_la1_12 = new int[] {0x0,0x200,0x0,0x0,0x200,0x4000000,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffffffb,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffffffb,0x0,0x0,0x0,0x0,0x3ffffffb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffffffb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffffffb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fffffff,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x8000000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x100000,0x0,0x3ffffffb,0x3ffffffb,0x8400000,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffffffb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffffffb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffffffb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200848,0x0,0x200848,0x0,0x0,0x4,0x4,0x200848,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x400,0x0,0x1000c000,0x1000c000,0x0,0x0,0x0,0x100000,0x0,0x3ffffffb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x3ffffffb,0x0,0x3ffffffb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x3ffffffb,0x4000000,0x3ffffffb,0x4,0x3ffffffb,0x3fffffff,0x3fffffff,0x3ffffffb,};
   }
   private static void jj_la1_13() {
      jj_la1_13 = new int[] {0x400014,0x0,0x400014,0x0,0x0,0x0,0x0,0x0,0x0,0x400014,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x400004,0x400000,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x10,0x0,0x10,0x0,0x0,0x10,0x10,0x10,0x10,0x0,0x0,0x0,0x100,0x10,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x400,0x20000000,0x0,0x280,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x40,0x100,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f8000,0x4,0x4,0x0,0x3f8000,0x280,0x280,0x8000840,0x8000840,0x280,0x10000400,0x400,0x0,0x20000000,0x0,0x100,0x0,0x0,0x0,0x0,0x100,0x0,0x100,0x0,0x0,0x100,0x0,0x0,0x20,0x0,0x0,0x0,0x400284,0x20000010,0x20000000,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x120,0x0,0x400000,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x100,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x4,0x0,0x10,0x0,0x20000000,0x0,0x0,0x0,0x10,0x0,0x0,0x10,0x0,0x20000000,0x10,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x100,0x0,0x20000000,0x0,0x10,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x100,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x100,0x0,0x0,0x0,0x284,0x280,0x284,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x20400000,0x400284,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x10,0x100,0x10,0x10,0x10,0x0,0x100,0x20000000,0x0,0x20000000,0x0,0x0,0x20000000,0x20000000,0x20000000,};
   }
   private static void jj_la1_14() {
      jj_la1_14 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x50,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x390,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x390,0x0,0x390,0x210,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x88,0x390,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x0,0x0,0x8,0x8,0x8,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[52];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public SQLParser(CharStream stream) {
    token_source = new SQLParserTokenManager(stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 315; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 315; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SQLParser(SQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 315; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(SQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 315; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken = token;
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[470];
    for (int i = 0; i < 470; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 315; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
          if ((jj_la1_8[i] & (1<<j)) != 0) {
            la1tokens[256+j] = true;
          }
          if ((jj_la1_9[i] & (1<<j)) != 0) {
            la1tokens[288+j] = true;
          }
          if ((jj_la1_10[i] & (1<<j)) != 0) {
            la1tokens[320+j] = true;
          }
          if ((jj_la1_11[i] & (1<<j)) != 0) {
            la1tokens[352+j] = true;
          }
          if ((jj_la1_12[i] & (1<<j)) != 0) {
            la1tokens[384+j] = true;
          }
          if ((jj_la1_13[i] & (1<<j)) != 0) {
            la1tokens[416+j] = true;
          }
          if ((jj_la1_14[i] & (1<<j)) != 0) {
            la1tokens[448+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 470; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, SQLParserConstants.tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 52; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
