/*
 * Token.java   Version 1.0 02/17/97 rrh
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 */
package spec.benchmarks._210_si; 

import java.io.*;

public class Token
   {
   PushbackInputStream ps;
   public final static int TT_EOF = -1;
   public final static int TT_WORD = -2;
   public final static int TT_NUMBER = -3;
   public final static int TT_EOL = -4;
   public double nval;
   public String sval;
   public int ttype;
   int pbb[] = new int[4];
   int pbbi = 0;


   Token(InputStream is)
      {
      ps = new PushbackInputStream(is); 
      }


   private int read() throws IOException
      {
      if ( pbbi > 0 )
	 return pbb[--pbbi];
      
      return ps.read();
      }

   public void nextToken() throws IOException
      {
      int i;
      int c = 0;
      byte  buffer[] = new byte[512];
      int rc = 0;
      boolean cf = true;


      while ( cf )
	 {
         do { c = read(); }
         while ( (c == ' ') || (c == '\t') || (c == '\n') || (c == '\r') );
  
	 if ( c == '/' )
	    {
	    c = read();
            
	    if ( c == '/' )
	       while ( (c != '\n') && (c != -1) && (c != '\r') ) c = read();
	    else
	       {
	       pushBack(c);
	       c = '/';
	       break;
	       }
	    }
         else
	    break;
         }


      i = 0;
      while ( ((c >= 'A') && (c <= 'Z')) || ((c >= 'a') && (c <= 'z')) ||
	      (c == '_') || ((c >= '0') && (c <= '9')) || (c == '.') )
         {
         buffer[i++] = (byte)c;
	 c = read();
	 }


      if ( i > 0 )
	 {
	 pushBack(c);

	 if ( ((buffer[0] >= '0') && (buffer[0] <= '9')) || (buffer[0] == '.') )
	    {
	    nval = Double.valueOf(new String(buffer, 0, 0, i)).doubleValue();

	    ttype = TT_NUMBER;
	    }
         else
	    {
	    sval = new String(buffer, 0, 0, i);

	    ttype = TT_WORD;
	    }
	 }
      else
         {
	 switch(c)
	    {
	    case '"':
	       i = 0;
	       c = read();
	       while ( c != '"' )
		  {
		  if ( c == '\\' )
		     {
		     c = read();

		     switch(c)
			{
			case 'n': buffer[i++]  = 0xA;        break;
			case 't': buffer[i++]  = 0x8;        break;
			case '\\': buffer[i++] = (byte)'\\'; break;
			case '"': buffer[i++]  = (byte)'"';  break;
			}
		     }
                  else
		     buffer[i++] = (byte)c;

                  c = read();		      
		  }

	       sval = new String(buffer, 0, 0, i);
	       c = '"';
	    break;
	    }

	 ttype = (int)c;
	 }
      
      }

   private void pushback(int c) throws IOException
      {
      if ( pbbi < pbb.length )
	 pbb[pbbi++] = c;
      else
	 throw new IOException();
      }

   public void pushBack(int c) throws IOException
      {
      pushback(c);
      }

   public void pushBack() throws IOException
      {
      pushback(ttype);
      }
   }

