/*
 * Printf.java   Version 1.0 02/17/97 rrh
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 */

//
// C like printf
//
// written by Randy Heisch   02/17/97
//
// Printf.out(String fmt, int value);
// Printf.out(String fmt, long value);
// Printf.out(String fmt, float value);
// Printf.out(String fmt, double value);
// Printf.out(String fmt, String s);
//
// Format string fmt:
//
//   "%[-][0][n]d"
//   "%[-][n][.p]f"
//   "%[-][n][.p]e"
//   "%[-][n][.p]E"
//   "%[-][n][.p]t"
//   "%[-][n][.p]$"
//   "%[-][0][n]x"
//   "%[-][0][n]X"
//   "%[-][n]s"
//
//   -   left justified
//   0   left zero fill
//   n   number of digits in field
//   p   precision (number of digits to right of decimal point
//   d   decimal (int or long)
//   f   float or double
//   e   float or double exponential notation
//   E   Engineering exponential notation (exp powers of 3)
//   x   lower case hex
//   X   upper case hex
//   t   add commas to multiple's of 1000
//   $   commas, dollar sign, and () for negative (monetary format)
//   s   string
//
//

package spec.benchmarks._210_si;

import java.util.*;
import java.lang.*;

class Printf
   {
   static String spc = "                                                                               ";
   static String zero = "000000000000000000000000000000000000000000000000000000000000000000000000000000";

   static public void out(String s, int v)
      {
      spec.harness.Context.out.print(str(s, v));
      spec.harness.Context.out.flush();
      }

   static public void out(String s, long v)
      {
      spec.harness.Context.out.print(str(s, v));
      spec.harness.Context.out.flush();
      }

   static public void out(String s, String str)
      {
      spec.harness.Context.out.print(str(s, str));
      spec.harness.Context.out.flush();
      }

   static public void out(String s, float f)
      {
      spec.harness.Context.out.print(str(s, f));
      spec.harness.Context.out.flush();
      }

   static public void out(String s, double d)
      {
      spec.harness.Context.out.print(str(s, d));
      spec.harness.Context.out.flush();
      }

   static public String str(String s, int v)
      {
      return str(s, new Integer(v));
      }

   static public String str(String s, long v)
      {
      return str(s, new Long(v));
      }

   static public String str(String s, float f)
      {
      return str(s, new Double(f));
      }

   static public String str(String s, double d)
      {
      return str(s, new Double(d));
      }


   static private String addcommas(String s)
      {
      int i, c;
      String rs = "";

      for (c = 0; c < s.length(); c++)
	 if ( s.charAt(c) == (char)'.' )
	    break;

      i = 0; 
      while ( c > 0 )
	 {
	 if ( (i > 0) && (c % 3) == 0 )
	    rs += ",";

         rs += s.charAt(i++);
         c--;
	 }

      while ( i < s.length() )
	 rs += s.charAt(i++);

      return rs;
      }


   static private String str(String s, Object o)
      {
      int i, l, j;
      byte b[];
      int width, prec;
      String vs = "";
      String rs = "";
      String ls = "";
      String fs;
      String ts = "";
      String sign;
      boolean lj = false;
      int v;
      long lv;
      double d, f, mant = 0.0, r;
      int exp;
      boolean prec_set = false;
      byte rf;


      boolean debug = false;


      l = s.length();

      //b = String.getBytes(s);
      b = new byte[l];
      for (i = 0; i < l; i++)
         b[i] = (byte)s.charAt(i);

      for (i = 0; i < l; i++)
         if ( b[i] == '%' )
            break;

      ls = spc;

      if ( i > 0 )
         rs = new String(b, 0, 0, i);
      else
         rs = "";

      if ( (i < l) && (b[i] == '%') )
         {
         i++;

         if ( b[i] == '-' )
            {
            lj = true;
            i++;
            }

         if ( b[i] == '0' )
            {
            if ( !lj )
               ls = zero;
            i++;
            }

         width = 0;
         while ( (b[i] >= '0') && (b[i] <= '9') )
            {
            width = (width * 10) + (b[i]-'0');
            i++;
            }

         prec = 0;
         if ( b[i] == '.' )
            {
            prec_set = true;
            i++;
            while ( (b[i] >= '0') && (b[i] <= '9') )
               {
               prec = (prec * 10) + (b[i] - '0');
               i++;
               }
            }

         rf = 0;
         if ( (b[i] == '$') || (b[i] == 't') )
	    {
	    rf = b[i];
	    b[i] = (byte)'f';
	    }

         switch(b[i])
            {
            case 'f': case 'e': case 'E':

               if ( o instanceof Double )
		  d = ((Double)o).doubleValue();
               else
               if ( o instanceof Integer )
		  d = ((Integer)o).doubleValue();
               else
	       if ( o instanceof Float )
		  d = ((Float)o).doubleValue();
               else
	       if ( o instanceof Long )
		  d = ((Long)o).doubleValue();
               else
                  {
                  spec.harness.Context.out.println("Expecting number");
                  rs = null;
                  i++;
                  break;
                  }

               if ( !prec_set )
                  {
                  prec = 18;
                  r = 0.0;
                  }
               else
                  {
                  r = 0.5;
                  for (j = 0; j < prec; j++)
                     r /= 10.0;
                  }

               if ( debug )
                  spec.harness.Context.out.println("    D:width="+width+", prec="+prec);


               if ( d < 0 )
                  {
                  sign = "-";
                  d = -d;
                  }
               else
                  sign = "";


               if ( debug )
                  spec.harness.Context.out.println("    D:d="+d+"  r="+r+"  d+r="+(d+r));

               if ( (d > 1e18) || (((d < 1e-18)||(b[i] != 'f')) && (d != 0.0)) )
                  {
                  mant = d;
                  exp = 0;

		  if ( d != 0.0 )
		     {
                 
                     while ( mant >= 10.0 )
                        {
                        mant /= 10.0;
                        exp++;
                        }

                     while ( mant < 1.0 )
                        {
                        mant *= 10.0;
                        exp--;
                        }
                     }

                  if ( (b[i] == 'E') && (d != 0.0) )
                     {
                     while ( (exp % 3) != 0 )
                        {
                        exp--;
                        mant *= 10.0;
                        }
                     }

                  mant += r;

                  if ( (b[i] == 'E') && (d != 0.0) )
                     {
                     if ( mant >= 1000.0 )
                        {
                        mant /= 1000.0;
                        exp += 3;
                        }
                     }
                  else
                     {
                     if ( mant >= 10.0 )
                        {
                        mant /= 10.0;
                        exp++;
                        }
                     }

                  if ( debug )
                     spec.harness.Context.out.println("    D:mant="+mant+", exp="+exp);

                  lv = (long)mant;
                  f = mant - lv;

                  ts = "e";

                  if ( exp >= 0 ) ts += "+";
                  else
                     {
                     ts += "-";
                     exp = -exp;
                     }

                  String ts0 = "";
                  for (j = 0; j < 3; j++)
                     {
                     ts0 = exp%10 + ts0;
                     exp /= 10;
                     }

                  ts += ts0;


		  if ( debug )
		     spec.harness.Context.out.println("    D:ts="+ts);
                  }
               else
                  {
                  lv = (long)(d + r);
                  f = (d + r) - lv;

                  ts = "";
                  }

               if ( debug )
                  spec.harness.Context.out.println("    D:lv="+lv+", f="+f);

               vs = Long.toString(lv);

	       f += 0.0000000000000000001;

               if ( prec > 0 )
		  {
		  vs += ".";
		  int pc = prec;
		  while ( pc > 0 )
		     {
		     f *= 10.0;

		     vs += (int)f;

		     f = f - (int)f;
		     pc--;
		     }
		  }

               if ( debug )
                  spec.harness.Context.out.println("    D:vs="+vs);

               vs += ts;

               if ( width == 0 )
                  width = vs.length();

               if ( debug )
                  spec.harness.Context.out.println("    D:vs="+vs);

               if ( rf > 0 )
		  {
                  vs = addcommas(vs);

                  if ( rf == '$' )
		     {
		     vs = "$" + vs;

		     if ( sign == "-" )
			vs = "(" + vs + ")";
                     else
			// Add trailing space to align with negative ")"
			vs = vs + " "; 
		     }
		     
                  }
               else
                  vs = sign + vs;

               if ( (vs.length() < width) && !lj )
                  rs = rs + spc.substring(0, (width-vs.length()));

               rs = rs + vs;

               i++;
            break;

            case 'd':

               if ( o instanceof Integer )
                  vs = ((Integer)o).toString();

               if ( o instanceof Long )
                  vs = ((Long)o).toString();

               if ( (vs.length() < width) && !lj )
                  rs = rs + ls.substring(0, (width-vs.length()));

               rs = rs + vs;

               i++;
            break;

            case 's':
               vs = (String)o;

               if ( (vs.length() < width) && !lj )
                  rs = rs + spc.substring(0, (width-vs.length()));

               rs = rs + vs;

               i++;
            break;

            case 'X': case 'x':

               if ( o instanceof Integer )
                  {
                  v = ((Integer)o).intValue();

                  if ( b[i] == 'X' )
                     vs = (Integer.toString(v, 16)).toUpperCase();
                  else
                     vs = Integer.toString(v, 16);
                  }

               if ( o instanceof Long )
                  {
                  lv = ((Long)o).longValue();

                  if ( b[i] == 'X' )
                     vs = (Long.toString(lv, 16)).toUpperCase();
                  else
                     vs = Long.toString(lv, 16);
                  }

               if ( (vs.length() < width) && !lj )
                  rs = rs + ls.substring(0, (width-vs.length()));

               rs = rs + vs;

               i++;
            break;
            }

         if ( lj && (vs.length() < width) )
            rs = rs + spc.substring(0, (width-vs.length()));

         rs = rs + new String(b, 0, i, l-i);
         }

      return rs;
      }

   }


