/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.logging.Level;
import spec.jbb.JBButil;
import spec.reporter.Metrics;
import spec.reporter.ReportProps;
import spec.reporter.TableGroupCompare;
import spec.reporter.Template;
import spec.reporter.TemplateCompare;
import spec.reporter.Title;

public class Report {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    private static String logo = "<IMG SRC=\"spec-sm.gif\" WIDTH=\"57\" HEIGHT=\"72\"\nALT=\"[SPEC logo]\" ALIGN=MIDDLE>";
    private static final String version = "@(#)Report.java\t1.18 08/03/98";
    public String graphTable;
    public String hardware;
    public String metric;
    public String name;
    public String software;
    public String base;
    private String category;
    public boolean SPECInternalUse;
    public boolean echoRaw;
    public String issue;
    private String memory;
    private String memoryDescription;
    public Metrics metrics;
    public Metrics metrics_2;
    public ReportProps results = new ReportProps();
    public ReportProps results_2 = new ReportProps();
    public Template template;
    public ReportProps titles = new ReportProps();
    public boolean useJavaGraph;
    public boolean useHtml;
    public boolean verbose;
    public String label;
    public String output_directory;

    public Report(boolean bl, boolean bl2, String string, String string2, boolean bl3, String string3, String string4, boolean bl4, String string5) {
        this.echoRaw = bl;
        this.SPECInternalUse = bl2;
        this.issue = string;
        this.verbose = bl3;
        this.label = string4;
        this.output_directory = string5;
        try {
            StringReader stringReader = new StringReader(new Title().getTitleString());
            this.titles.load(stringReader);
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "Error loading titles for report\n", iOException);
            System.exit(1);
        }
        try {
            if (string2 == null) {
                this.results.load(new InputStreamReader(System.in));
            } else {
                this.results.load(string2);
            }
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "Error reading results file " + string2 + ": " + iOException, iOException);
            System.exit(1);
        }
        this.metrics = new Metrics(this.results, bl2);
        try {
            if (string3 != null) {
                this.results_2.load(string3);
                this.metrics_2 = new Metrics(this.results_2, bl2);
            } else {
                this.metrics_2 = null;
            }
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "Error reading comparison results file " + string3 + ": " + iOException, iOException);
            System.exit(1);
        }
        this.graphTable = this.metrics_2 == null ? this.metrics.tableAndGraph(string4, bl4, string5) : this.metrics.compareTableAndGraph(this.metrics_2, string4, bl4, string5);
        this.name = this.results.get("input.suite");
        this.hardware = this.results.get("config.hw.vendor") + " " + this.results.get("config.hw.model");
        if (this.metric == null) {
            this.metric = " " + this.metrics.metric();
        }
        if (this.metrics.valid) {
            if (!bl2) {
                this.metrics.results_buf.append("\nValid run, Score is " + this.metric + "\n");
            }
        } else if (this.metrics.print_score) {
            this.metrics.results_buf.append("INVALID run; Score is " + this.metric + "\n");
        } else {
            this.metrics.results_buf.append("INVALID run preventing score calculation.\n");
        }
        this.software = this.results.get("config.sw.vendor") + " " + this.results.get("config.sw.JVM");
        this.memory = this.results.get("config.hw.memory");
        this.memoryDescription = this.results.get("config.hw.memory_description");
    }

    public void print(String string) {
        try {
            this.print(new PrintStream(new BufferedOutputStream(new FileOutputStream(string))));
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "Error creating output: " + iOException, iOException);
        }
    }

    public void print(PrintStream printStream) {
        try {
            TableGroupCompare tableGroupCompare;
            printStream.println("<HTML><HEAD>\n<META NAME=\"GENERATOR\" CONTENT=\"SPEC Java Reporter\">\n<TITLE> " + this.name + "</TITLE>\n" + "</HEAD>");
            printStream.print("<BODY ");
            if (this.metrics.valid) {
                printStream.print(this.results.get("spec.report.bodyAttributes", ""));
            } else {
                this.metrics.relocateImageResource("invalid.gif", this.output_directory);
                printStream.print("BACKGROUND=\"invalid.gif\"");
            }
            printStream.print(">\n");
            printStream.print("<TABLE WIDTH=100%>\n<TR><TD COLSPAN=2>");
            if (this.issue != null && !this.issue.equals("")) {
                this.metrics.relocateImageResource("spec-sm.gif", this.output_directory);
                printStream.print(logo);
            } else {
                printStream.print("<FONT SIZE=+2></FONT>&nbsp;");
            }
            if (!this.metrics.valid) {
                printStream.print("<FONT SIZE=+2> Invalid</FONT>");
            }
            printStream.print("<FONT SIZE=+2>" + this.name + "2005</FONT></TD>\n" + "<TD COLSPAN=2 ALIGN=RIGHT bgcolor=FFFF00>" + "    <FONT SIZE=+2 COLOR=000000><B>SPECjbb2005 bops = " + this.metric + ", SPECjbb2005 bops/JVM = " + this.metric + "</B></FONT></TD></TR>\n" + "<TR><TD COLSPAN=3><FONT SIZE=+1>" + this.hardware + "</FONT></TD></TR>\n");
            if (this.software != null) {
                printStream.print("<TR><TD COLSPAN=3><FONT SIZE=+1>" + this.software + "</FONT></TD></TR>\n");
            }
            printStream.println("</TABLE>");
            printStream.println(this.graphTable);
            this.testBar(printStream);
            printStream.print("<P>\n");
            if (this.metrics_2 != null) {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(new TemplateCompare().getTemplateString()));
                BufferedReader bufferedReader2 = new BufferedReader(new StringReader(new TemplateCompare().getTemplateString()));
                tableGroupCompare = new TableGroupCompare(bufferedReader, bufferedReader2, this.results, this.results_2, this.titles);
            } else {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(new Template().getTemplateString()));
                BufferedReader bufferedReader3 = new BufferedReader(new StringReader(new Template().getTemplateString()));
                tableGroupCompare = new TableGroupCompare(bufferedReader, bufferedReader3, this.results, null, this.titles);
            }
            printStream.println(tableGroupCompare.toString());
            if (this.metrics_2 == null) {
                printStream.println(this.metrics.detail());
            }
            if (this.verbose) {
                this.printOtherProperties(printStream);
            }
            printStream.println("<HR><FONT SIZE=-1>\n");
            printStream.println("SPECjbb2005 Version: [" + this.results.get("config.benchmark_version", "N/A") + ", " + this.results.get("config.benchmark_versionDate", "-") + "]");
            printStream.println("<BR><I>\n");
            if (this.issue != null && !this.issue.equals("") && this.metrics.valid) {
                printStream.println("Published by SPEC " + this.issue + "<br>");
            }
            printStream.println("Reporting page, Copyright &copy; 2005 SPEC. All rights reserved\n</I></FONT>");
            printStream.println("<!-- ");
            printStream.println("Reporting Page Generator @(#)Report.java\t1.18 08/03/98");
            if (this.echoRaw) {
                this.results.store(printStream, "Raw Results");
            }
            printStream.println(" -->");
            printStream.print("</BODY></HTML>\n");
            printStream.close();
        }
        catch (Exception exception) {
            JBButil.getLog().log(Level.WARNING, "Error: " + exception, exception);
        }
    }

    public String messages() {
        return this.metrics.results_buf.toString();
    }

    private void printOtherProperties(PrintStream printStream) {
        printStream.println("<H4>Optional Information</H4>\n<I>This information is for internal documentation purposes\nand is not required for SPEC reporting\n</I><BR>");
        Enumeration<?> enumeration = this.results.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("config.testx.") && !string.startsWith("config.initial.")) continue;
            String string2 = this.results.get(string);
            if (string.equals("config.testx.internalReference") && (string2.startsWith("http://") || string2.startsWith("file:/"))) {
                string2 = "<A HREF=\"" + string2 + "\">" + string2 + "</A>";
            }
            printStream.println("<BR>" + string + "=" + string2);
        }
    }

    public void testBar(PrintStream printStream) throws IOException {
        String string = this.results.get("config.test.specLicense", "MISSING");
        String string2 = this.results.get("config.test.testedBy", "MISSING");
        String string3 = this.results.get("config.test.date", "MISSING");
        printStream.println("<TABLE WIDTH=\"100%\" BORDER=1 CELLSPACING=2 CELLPADDING=0><tr>\n<td width=33%><b>SPEC license # </b>" + string + "</td>\n" + "<td width=33%><b>Tested by: </b>" + string2 + "</td>\n" + "<td><b>Test date: </b>" + string3 + "</td>\n" + "</tr></TABLE>");
    }
}

