/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import spec.jbb.JBButil;
import spec.reporter.GraphImage;
import spec.reporter.ReportProps;
import spec.reporter.Result;

public class Metrics {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    private static int maxBarWidth = 0;
    private static int digits = 3;
    private static final int widthAdj1 = 80;
    private static final int widthAdj2 = -80;
    private static final int MAXINT = 2000000000;
    private static final String IMAGE_PIX = "pix.jpg";
    private static final String IMAGE_PIX_2 = "pix2.jpg";
    private static final String IMAGE_INVALID = "invalid.gif";
    private static final String IMAGE_RESOURCE_PATH = "images/";
    public double highestScore;
    public int maxWarehouses;
    public int measuredPeakWarehouse = 0;
    public int expectedPeakWh = 0;
    public int jvm_instances = 1;
    public Result check;
    public String[] name;
    public ReportProps props;
    public Result[] result;
    public double[] score_at;
    private long[] rampup_millis;
    private long[] rampdown_millis;
    private long[] start_millis;
    private long[] end_millis;
    public int maximum_warehouses;
    private int warehousesTested = 0;
    public boolean valid;
    public boolean print_score;
    public boolean SPECInternalUse;
    private String o_directory;
    public StringBuffer buf;
    public StringBuffer invalid_buf;
    public StringBuffer results_buf;
    public StringBuffer check_all_buf;

    public Metrics(ReportProps reportProps, boolean bl) {
        this.props = reportProps;
        this.SPECInternalUse = bl;
        this.valid = true;
        this.buf = new StringBuffer();
        this.invalid_buf = new StringBuffer();
        this.results_buf = new StringBuffer();
        this.name = Metrics.benchmarkList(reportProps);
        this.result = new Result[this.name.length];
        for (int i = 0; i < this.result.length; ++i) {
            this.result[i] = new Result(this.name[i], reportProps);
        }
        String string = reportProps.get("input.jvm_instances");
        this.jvm_instances = Integer.parseInt(string.trim());
        this.warehousesTested = this.name.length;
        this.create_warehouse_array();
        this.calculate();
        this.check_all_buf = new StringBuffer();
        this.check_all_buf.append(this.check_all());
    }

    public String wrap(String string) {
        return "<h1>" + string + "</h1>";
    }

    public String check_all() {
        boolean bl;
        boolean bl2;
        this.buf = new StringBuffer();
        String string = this.props.get("result.validity.200_check");
        if (string != null) {
            if (!string.equals("true")) {
                this.valid = false;
            }
        } else {
            this.valid = false;
        }
        this.print_score = true;
        if (!this.valid) {
            this.output_properly("INVALID because conformance checking returned negative.\n");
        }
        if ((string = this.props.get("result.validity.999_checkit")) != null && string.equals("false")) {
            this.valid = false;
            this.output_properly("INVALID because benchmark recompiled or jbb.jar not first in CLASSPATH.");
        }
        boolean bl3 = (string = this.props.get("result.validity.jbb_operation")) != null ? string.equals("true") : true;
        boolean bl4 = this.valid = this.valid && bl3;
        if (!bl3) {
            String string2 = "INVALID: JVM failed operational validity check.\n";
            this.output_properly(string2);
        }
        if (!(bl2 = this.checkElapsed())) {
            String string3 = "INVALID: measurement interval failing to end in close enough time limits.";
            this.output_properly(string3);
            this.valid = false;
        }
        if (!(bl = this.check_points_before_metric())) {
            this.output_properly("INVALID: all points up to the peak are required");
            this.valid = false;
        }
        if (this.maximum_warehouses < 8) {
            String string4 = "INVALID: at least the points from 1 to 8 are needed for a publishable run.";
            this.output_properly(string4);
            this.valid = false;
        }
        boolean bl5 = this.check_points_for_metric();
        if (this.valid && !this.SPECInternalUse) {
            this.output_properly("No errors.  Valid run.");
        }
        return this.buf.toString();
    }

    public void output_properly(String string) {
        this.buf.append(this.wrap(string));
        this.invalid_buf.append(this.wrap(string));
        this.results_buf.append(string + "\n");
    }

    public int get_whAtPeak() {
        return this.expectedPeakWh;
    }

    public double getHighestScore() {
        return this.highestScore;
    }

    public int getWarehousesTested() {
        return this.warehousesTested;
    }

    public static String score_format(double d) {
        String string;
        try {
            if (d < 0.01) {
                string = "0";
            } else if (d < 0.1) {
                int n = (int)(1000.0 * d + 0.5);
                String string2 = Integer.toString(n);
                string = ".0" + string2;
            } else if (d < 1.0) {
                int n = (int)(1000.0 * d + 0.5);
                String string3 = Integer.toString(n);
                string = "." + string3;
            } else if (d < 10.0) {
                int n = (int)(100.0 * d + 0.5);
                String string4 = Integer.toString(n);
                string = string4.substring(0, 1) + "." + string4.substring(1, 3);
            } else if (d < 100.0) {
                int n = (int)(10.0 * d + 0.5);
                String string5 = Integer.toString(n);
                string = string5.substring(0, 2) + "." + string5.substring(2, 3);
            } else {
                int n = (int)(d + 0.5);
                string = Integer.toString(n);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            string = "n/a";
        }
        return string;
    }

    public static String format(double d) {
        String string;
        try {
            if (d < 0.01) {
                string = "<0.01";
            } else if (d < 0.1) {
                int n = (int)(1000.0 * d + 0.5);
                String string2 = Integer.toString(n);
                string = ".0" + string2;
            } else if (d < 1.0) {
                int n = (int)(1000.0 * d + 0.5);
                String string3 = Integer.toString(n);
                string = "." + string3;
            } else if (d < 10.0) {
                int n = (int)(100.0 * d + 0.5);
                String string4 = Integer.toString(n);
                string = string4.substring(0, 1) + "." + string4.substring(1, 3);
            } else if (d < 100.0) {
                int n = (int)(10.0 * d + 0.5);
                String string5 = Integer.toString(n);
                string = string5.substring(0, 2) + "." + string5.substring(2, 3);
            } else {
                int n = (int)(d + 0.5);
                string = Integer.toString(n);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            string = "n/a";
        }
        return string;
    }

    public Result[] getResults() {
        return this.result;
    }

    public boolean checkElapsed() {
        for (int i = 0; i < this.result.length; ++i) {
            double d = this.result[i].elapsed();
            double d2 = this.result[i].meas_int();
            double d3 = this.result[i].ramp_up_int();
            double d4 = this.result[i].expected_peak();
            if (!((double)i >= d4 - 1.0)) continue;
            if (d / d2 > 1150.0) {
                this.output_properly(" INVALID: for point " + i + ", elapsed ms =" + d + " specified measurement interval seconds = " + d2 + ".\n");
                this.output_properly(" elapsed / intended =" + d / (10.0 * d2) + " > 115% \n");
                return false;
            }
            if (!(d / d2 < 995.0)) continue;
            this.output_properly(" INVALID: for point " + i + ", elapsed ms =" + d + " specified measurement interval seconds = " + d2 + ".\n");
            this.output_properly(" elapsed / intended =" + d / (10.0 * d2) + " < 99.5% \n");
            return false;
        }
        return true;
    }

    public static String[] benchmarkList(ReportProps reportProps) {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        int n = 1;
        while ((stringArray = reportProps.get("result.test" + n + ".warehouses")) != null) {
            vector.addElement("test" + n);
            ++n;
        }
        n = vector.size();
        if (n == 0) {
            return new String[0];
        }
        stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private void calculate() {
        double d;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 0.0;
        this.highestScore = 0.0;
        this.maxWarehouses = 0;
        this.expectedPeakWh = this.props.getInt("input.expected_peak_warehouse");
        int n = 1;
        while ((d = this.props.getDouble("result.test" + n + ".company.score")) != 0.0) {
            int n2;
            if (d > this.highestScore) {
                this.highestScore = d;
                this.measuredPeakWarehouse = this.props.getInt("result.test" + n + ".warehouses");
            }
            if ((n2 = this.props.getInt("result.test" + n + ".warehouses")) > this.maxWarehouses) {
                this.maxWarehouses = n2;
            }
            ++n;
        }
    }

    public String detail() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.valid) {
            stringBuffer.append("<H4>Invalid Result</H4>\n");
            stringBuffer.append("This result is not valid for the following reason(s):\n");
            stringBuffer.append("<PRE>\n");
            stringBuffer.append(this.invalid_buf);
            stringBuffer.append("</PRE>\n");
        } else {
            stringBuffer.append(this.invalid_buf);
        }
        stringBuffer.append("<H4>Details of Runs</H4>\n");
        stringBuffer.append("<TABLE BORDER WIDTH=100%>\n");
        stringBuffer.append("<TR><TH ROWSPAN=2>Warehouses</TH>\n");
        stringBuffer.append("  <TH ROWSPAN=2>Thrput</TH>\n");
        stringBuffer.append("  <TH COLSPAN=2>Total heap (MB)</TH>\n");
        stringBuffer.append("  <TH ROWSPAN=2>Thread spread %</TH>\n");
        stringBuffer.append("  <TH ROWSPAN=2>% > 120s</TH>\n");
        stringBuffer.append("  <TH ROWSPAN=2>transaction type</TH>\n");
        stringBuffer.append("  <TH ROWSPAN=2>Count</TH>\n");
        stringBuffer.append("  <TH COLSPAN=4>Time (in seconds)</TH>\n");
        stringBuffer.append("</TR>\n");
        stringBuffer.append("<TR><TH>Size</TH><TH>Used</TH>\n");
        stringBuffer.append("<TH>total</TH><TH>max</TH></TR>\n");
        for (int i = 0; i < this.result.length; ++i) {
            stringBuffer.append(this.result[i].toDetailRows());
        }
        stringBuffer.append("</TABLE>\n");
        return stringBuffer.toString();
    }

    private String JasonGraph(String string) {
        GraphImage graphImage = new GraphImage(400, 400);
        graphImage.setPixelSize(6);
        graphImage.setPixelType(0);
        graphImage.setForeground(Color.red);
        graphImage.setBackground(Color.white);
        graphImage.setConnectPointsEnabled(true);
        graphImage.setXAxisLabelsPrecision(1, 0);
        graphImage.setYAxisLabelsPrecision(3, 0);
        double d = (double)this.maxWarehouses * 1.15;
        double d2 = this.highestScore * 1.15;
        graphImage.setScale(new double[]{graphImage.getSuggestedMinXScale(d, d2), d, graphImage.getSuggestedMinYScale(d, d2), d2});
        graphImage.plotXYAxes(Color.gray);
        graphImage.plotXAxisTicks(4.0, Color.gray, "warehouses");
        graphImage.plotYAxisTicks(graphImage.getSuggestedYAxisTickInterval(10, d2), Color.gray, "scores");
        double d3 = 0.0;
        for (int i = 0; i < this.result.length; ++i) {
            double d4 = this.result[i].warehouses();
            if (d4 > d3) {
                d3 = d4;
            }
            double d5 = this.result[i].score();
            if (d4 >= (double)this.expectedPeakWh && d4 <= (double)(2 * this.expectedPeakWh)) {
                graphImage.plot(d4, d5, Color.red);
                continue;
            }
            graphImage.plot(d4, d5, Color.orange);
        }
        if (d3 > (double)(2 * this.expectedPeakWh - 1)) {
            graphImage.plotFlatLine(this.expectedPeakWh, 2 * this.expectedPeakWh, Integer.parseInt(this.metric()), Color.red);
        }
        graphImage.drawLegend("Included in score calculation", 2.0, 4.0, Color.red, Color.gray, "Dot");
        graphImage.drawLegend("Not included in score calculation", 2.0, 6.0, Color.orange, Color.gray, "Dot");
        graphImage.setImageQuality(0.85f);
        if (string == null) {
            Random random = new Random();
            string = "" + (10000 + random.nextInt() % 10000);
        }
        String string2 = this.SPECInternalUse ? string + ".jpg" : "SPECjbb." + string + ".jpg";
        graphImage.make(this.o_directory + File.separator + string2);
        return " <UL><IMG SRC=\"" + string2 + "\" WIDTH=400 HEIGHT=400></UL>";
    }

    private String JasonGraph(Metrics metrics, String string) {
        GraphImage graphImage = new GraphImage(400, 400);
        graphImage.setPixelSize(8);
        graphImage.setPixelType(0);
        graphImage.setForeground(Color.blue);
        graphImage.setBackground(Color.white);
        graphImage.setConnectPointsEnabled(true);
        graphImage.setXAxisLabelsPrecision(1, 0);
        graphImage.setYAxisLabelsPrecision(3, 0);
        int n = Math.max(this.maxWarehouses, metrics.maxWarehouses);
        double d = Math.max(this.highestScore, metrics.highestScore);
        double d2 = (double)n * 1.15;
        double d3 = d * 1.15;
        graphImage.setScale(new double[]{graphImage.getSuggestedMinXScale(d2, d3), d2, graphImage.getSuggestedMinYScale(d2, d3), d3});
        graphImage.plotXYAxes(Color.gray);
        graphImage.plotXAxisTicks(4.0, Color.gray, "warehouses");
        graphImage.plotYAxisTicks(graphImage.getSuggestedYAxisTickInterval(10, d3), Color.gray, "scores");
        for (int i = 0; i < this.result.length; ++i) {
            double d4 = this.result[i].warehouses();
            double d5 = this.result[i].score();
            graphImage.plot(d4, d5, Color.red);
        }
        Result[] resultArray = metrics.getResults();
        graphImage.setForeground(Color.white);
        for (int i = 0; i < resultArray.length; ++i) {
            if (1 == i) {
                graphImage.setForeground(Color.green);
            }
            double d6 = resultArray[i].warehouses();
            double d7 = resultArray[i].score();
            graphImage.plot(d6, d7, Color.cyan);
        }
        graphImage.setImageQuality(0.85f);
        if (string == null) {
            Random random = new Random();
            string = "" + (10000 + random.nextInt() % 10000);
        }
        String string2 = this.SPECInternalUse ? string + ".jpg" : "SPECjbb." + string + ".jpg";
        graphImage.make(this.o_directory + File.separator + string2);
        return " <UL><IMG SRC=\"" + string2 + "\" WIDTH=400 HEIGHT=400></UL>";
    }

    public static String multiCurvesGraph(Metrics[] metricsArray, String string, boolean bl, String string2) {
        int n;
        GraphImage graphImage = new GraphImage(400, 400);
        graphImage.setPixelSize(6);
        graphImage.setPixelType(0);
        graphImage.setForeground(Color.blue);
        graphImage.setBackground(Color.white);
        graphImage.setConnectPointsEnabled(true);
        graphImage.setXAxisLabelsPrecision(1, 0);
        graphImage.setYAxisLabelsPrecision(3, 0);
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        for (int i = 0; i < metricsArray.length; ++i) {
            if (d < (double)metricsArray[i].maxWarehouses) {
                d = metricsArray[i].maxWarehouses;
            }
            d2 += metricsArray[i].highestScore;
            if (n2 >= metricsArray[i].maximum_warehouses) continue;
            n2 = metricsArray[i].maximum_warehouses;
        }
        double d3 = d * 1.15;
        double d4 = d2 * 1.15;
        graphImage.setScale(new double[]{graphImage.getSuggestedMinXScale(d3, d4), d3, graphImage.getSuggestedMinYScale(d3, d4), d4});
        graphImage.plotXYAxes(Color.gray);
        graphImage.plotXAxisTicks(4.0, Color.gray, "warehouses");
        graphImage.plotYAxisTicks(graphImage.getSuggestedYAxisTickInterval(10, d4), Color.gray, "scores");
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < metricsArray.length; ++n) {
            int n3 = metricsArray[n].expectedPeakWh;
            Result[] resultArray = metricsArray[n].getResults();
            Color color = Color.green;
            int n4 = 0;
            while (n4 < resultArray.length) {
                if (1 == n4) {
                    graphImage.setForeground(color.darker());
                }
                double d5 = resultArray[n4].warehouses();
                double d6 = resultArray[n4].score();
                if (d5 >= (double)n3 && d5 <= (double)(2 * n3)) {
                    graphImage.plot(d5, d6, Color.red);
                } else {
                    graphImage.plot(d5, d6, Color.orange);
                }
                dArray[n4] = d5;
                int n5 = n4++;
                dArray2[n5] = dArray2[n5] + d6;
            }
            graphImage.setForeground(Color.white);
        }
        for (n = 0; n < dArray.length; ++n) {
            if (n == 1) {
                graphImage.setForeground(Color.magenta);
            }
            graphImage.plot(dArray[n], dArray2[n], Color.blue);
        }
        graphImage.drawLegend("Instance result", 2.0, 4.0, Color.green, Color.gray, "Line");
        graphImage.drawLegend("Aggregated result", 2.0, 6.0, Color.magenta, Color.gray, "Line");
        graphImage.setImageQuality(0.85f);
        if (string == null) {
            Random random = new Random();
            string = "" + (10000 + random.nextInt() % 10000);
        }
        String string3 = bl ? string + ".jpg" : "SPECjbb." + string + ".jpg";
        graphImage.make(string2 + File.separator + string3);
        return " <UL><IMG SRC=\"" + string3 + "\" WIDTH=400 HEIGHT=400></UL>";
    }

    private String dotsGraph(Metrics metrics) {
        int n;
        int n2;
        int n3;
        int n4;
        double d;
        int n5;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int[][] nArray = new int[101][101];
        if (metrics != null) {
            n5 = Math.max(this.maxWarehouses, metrics.maxWarehouses);
            d = Math.max(this.highestScore, metrics.highestScore);
        } else {
            n5 = this.maxWarehouses;
            d = this.highestScore;
        }
        int n6 = Math.max(50, n5);
        int n7 = 50;
        double d2 = (double)n6 / (double)n5;
        double d3 = (double)n7 * 0.9 / d;
        for (n4 = 0; n4 < this.result.length; ++n4) {
            n3 = (int)((double)this.result[n4].warehouses() * d2) - 1;
            n2 = (int)(this.result[n4].score() * d3);
            nArray[n3][n2] = 1;
        }
        if (metrics != null) {
            for (n4 = 0; n4 < metrics.result.length; ++n4) {
                n3 = (int)((double)metrics.result[n4].warehouses() * d2) - 1;
                n2 = (int)(metrics.result[n4].score() * d3);
                nArray[n3][n2] = 2;
            }
        }
        n4 = this.getSuggestedYAxisTickInterval(6, 1.1 * d);
        stringBuffer.append("<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>");
        stringBuffer.append("<TR><TD NOWRAP>");
        stringBuffer.append("<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 HEIGHT=100%>");
        stringBuffer.append("<TR><TD ALIGN=center VALIGN=middle NOWRAP>");
        stringBuffer.append("<FONT FACE=courier>&nbsp;o&nbsp;<BR>&nbsp;p&nbsp;<BR>&nbsp;s&nbsp;<BR>&nbsp;/&nbsp;<BR>&nbsp;s&nbsp;</FONT>");
        stringBuffer.append("</TD>");
        stringBuffer.append("<TD VALIGN=top>");
        stringBuffer.append("<TABLE BORDER=0 CELLSPACING=2 CELLPADDING=0 HEIGHT=100%>");
        n3 = (int)(1.1 * (d / (double)n4));
        for (n2 = n7; n2 > 0; --n2) {
            stringBuffer.append("<TR>");
            if ((double)n2 / d3 < (double)(n4 * n3)) {
                stringBuffer.append("<TD BGCOLOR=white NOWRAP VALIGN=top ALIGN=right VALIGN=top><FONT SIZE=1 COLOR=#ff0000>");
                stringBuffer.append(n4 * n3);
                --n3;
                stringBuffer.append("</FONT></TD>");
            } else {
                stringBuffer.append("<td></td>");
            }
            stringBuffer.append("</TR>");
        }
        stringBuffer.append("</TABLE></TD></TR></TABLE></TD><TD>");
        stringBuffer.append("<TABLE BORDER=1 CELLSPACING=2 CELLPADDING=0 WIDTH=100%>");
        for (n2 = n7; n2 > 0; --n2) {
            stringBuffer.append("<TR>");
            for (n = 1; n < n6; ++n) {
                if (nArray[n][n2] == 1) {
                    stringBuffer.append("<TD BGCOLOR=#000000 WIDTH=2><IMG SRC=pix.jpg WIDTH=2 HEIGHT=2></TD>\n");
                    continue;
                }
                if (nArray[n][n2] == 2) {
                    stringBuffer.append("<TD BGCOLOR=#000000 WIDTH=2><IMG SRC=pix2.jpg WIDTH=2 HEIGHT=2></TD>\n");
                    continue;
                }
                stringBuffer.append("<TD WIDTH=2></TD>\n");
            }
            stringBuffer.append("</TR>");
        }
        stringBuffer.append("</TABLE>");
        stringBuffer.append("</td></TR><TR><TD></TD><TD>");
        stringBuffer.append("<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=100%>");
        stringBuffer.append("<TR>\n");
        n2 = n5 < 8 ? 1 : (n5 < 120 ? 4 : 10);
        stringBuffer.append("<TD BGCOLOR=white ALIGN=left><FONT SIZE=1 COLOR=red>0</FONT></TD>\n");
        for (n = 1; n <= n5; ++n) {
            if (n5 <= 8 || n5 > 8 && n % n2 == 0) {
                if (n + n2 > n5) {
                    stringBuffer.append("<TD BGCOLOR=white ALIGN=right><FONT SIZE=1 COLOR=red>");
                } else {
                    stringBuffer.append("<TD BGCOLOR=white ALIGN=center><FONT SIZE=1 COLOR=red>");
                }
                if (n < 10) {
                    stringBuffer.append("0" + n);
                } else {
                    stringBuffer.append("" + n);
                }
                stringBuffer.append("</FONT></TD>\n");
                continue;
            }
            stringBuffer.append("<TD>&nbsp&nbsp</TD>\n");
        }
        stringBuffer.append("</TR><TR>");
        stringBuffer.append("<TD COLSPAN=" + n5 + " ALIGN=center BGCOLOR=white>" + "<FONT FACE=courier>warehouses</FONT></TD></TR>");
        stringBuffer.append("</TABLE>");
        stringBuffer.append("</TD></TR></TABLE>");
        return stringBuffer.toString();
    }

    double score_at_wh(int n) {
        if (n < this.score_at.length) {
            return this.score_at[n];
        }
        return 0.0;
    }

    public long rampup_millis_at_wh(int n) {
        if (n < this.rampup_millis.length) {
            return this.rampup_millis[n];
        }
        return 0L;
    }

    public long rampdown_millis_at_wh(int n) {
        if (n < this.rampdown_millis.length) {
            return this.rampdown_millis[n];
        }
        return 0L;
    }

    public long start_millis_at_wh(int n) {
        if (n < this.start_millis.length) {
            return this.start_millis[n];
        }
        return 0L;
    }

    public long end_millis_at_wh(int n) {
        if (n < this.end_millis.length) {
            return this.end_millis[n];
        }
        return 0L;
    }

    private void create_warehouse_array() {
        int n;
        for (n = 0; n < this.result.length; ++n) {
            if (this.result[n].warehouses() <= this.maximum_warehouses) continue;
            this.maximum_warehouses = this.result[n].warehouses();
        }
        this.score_at = new double[this.maximum_warehouses + 2];
        this.rampup_millis = new long[this.maximum_warehouses + 2];
        this.rampdown_millis = new long[this.maximum_warehouses + 2];
        this.start_millis = new long[this.maximum_warehouses + 2];
        this.end_millis = new long[this.maximum_warehouses + 2];
        for (n = 0; n <= this.maximum_warehouses + 1; ++n) {
            this.score_at[n] = 0.0;
            this.rampup_millis[n] = 0L;
            this.rampdown_millis[n] = 0L;
            this.start_millis[n] = 0L;
            this.end_millis[n] = 0L;
        }
        for (n = 0; n < this.result.length; ++n) {
            if (this.score_at[this.result[n].warehouses()] != 0.0) {
                this.output_properly("INVALID: cannot repeat points");
                this.valid = false;
                continue;
            }
            this.score_at[this.result[n].warehouses()] = this.result[n].score();
            if (this.jvm_instances <= 1) continue;
            this.rampup_millis[this.result[n].warehouses()] = this.result[n].rampup_millis();
            this.rampdown_millis[this.result[n].warehouses()] = this.result[n].rampdown_millis();
            this.start_millis[this.result[n].warehouses()] = this.result[n].start_millis();
            this.end_millis[this.result[n].warehouses()] = this.result[n].end_millis();
        }
    }

    private boolean check_points_before_metric() {
        boolean bl = true;
        for (int i = 1; i < this.expectedPeakWh; ++i) {
            if (this.getScoreAt(i) != 0.0) continue;
            this.output_properly("INVALID: Missing point: " + i + " required for publication; all points up to the peak, " + this.expectedPeakWh + ", are required.");
            bl = false;
        }
        return bl;
    }

    private boolean check_points_for_metric() {
        boolean bl = true;
        if (this.maximum_warehouses < 2 * this.expectedPeakWh) {
            String string = "Warning: all points from " + this.expectedPeakWh + " to " + 2 * this.expectedPeakWh + " are averaged for metric; 0's will be used for missing points.";
            this.output_properly(string);
            return false;
        }
        for (int i = this.expectedPeakWh; i <= 2 * this.expectedPeakWh; ++i) {
            if (this.score_at[i] != 0.0) continue;
            this.output_properly("Warning: Missing point: 0 will used for point " + i + ".");
            bl = false;
        }
        return bl;
    }

    public String metric() {
        int n = this.expectedPeakWh;
        double d = 0.0;
        int n2 = 2 * n;
        if (this.maximum_warehouses < 2 * n) {
            n2 = this.maximum_warehouses;
        }
        for (int i = n; i <= n2; ++i) {
            d += this.score_at[i];
        }
        return this.ratioOrNa(d / (double)(n + 1));
    }

    public String ratioOrNa(double d) {
        if (!this.print_score || d <= 0.0) {
            return "n/a";
        }
        if (this.valid && this.print_score) {
            return Metrics.format(d);
        }
        return Metrics.format(d);
    }

    public String tableAndGraph(String string, boolean bl, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.o_directory = string2;
        stringBuffer.append(this.check_all_buf);
        int n = 5;
        stringBuffer.append("<TABLE BORDER WIDTH=\"100%\">\n    <TH COLSPAN=" + n + "></TH>\n");
        int n2 = this.result.length + 3;
        stringBuffer.append("    <TH ROWSPAN=" + n2 + ">\n");
        if (bl) {
            this.relocateImageResource(IMAGE_PIX, string2);
            this.relocateImageResource(IMAGE_PIX_2, string2);
            stringBuffer.append(this.dotsGraph(null));
        } else {
            try {
                Class.forName("java.awt.image.BufferedImage");
                stringBuffer.append(this.JasonGraph(string));
            }
            catch (InternalError internalError) {
                stringBuffer.append(this.dotsGraph(null));
            }
            catch (Exception exception) {
                stringBuffer.append(this.dotsGraph(null));
            }
        }
        stringBuffer.append("</TH></TR>\n");
        stringBuffer.append("<TR><TH ALIGN=RIGHT>Warehouses</TH>\n    <TH ALIGN=RIGHT>SPECjbb2005 bops</TH>\n    <TH ALIGN=RIGHT>Incl. in metric</TH></TR>\n");
        for (int i = 0; i < this.result.length; ++i) {
            stringBuffer.append(this.result[i].toRow(this.expectedPeakWh));
        }
        stringBuffer.append("<TR><TH ALIGN=LEFT>SPECjbb2005 </TH>\n    <TH ALIGN=RIGHT>  (from " + this.expectedPeakWh + " to " + 2 * this.expectedPeakWh + ") " + "</TH>\n" + "    <TH ALIGN=RIGHT>" + this.metric() + " SPECjbb2005 bops</TH>\n" + "</TR>\n</TABLE>\n");
        stringBuffer.append("</TR>\n</TABLE>\n");
        return stringBuffer.toString();
    }

    public String compareTableAndGraph(Metrics metrics, String string, boolean bl, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 5;
        if (metrics == null) {
            return this.tableAndGraph(string, bl, string2);
        }
        this.o_directory = string2;
        stringBuffer.append(this.check_all_buf);
        stringBuffer.append("<TABLE BORDER WIDTH=\"100%\">\n    <TH COLSPAN=" + n + "></TH>\n");
        int n2 = this.result.length + 3;
        stringBuffer.append("    <TH ROWSPAN=" + n2 + ">\n");
        if (bl) {
            this.relocateImageResource(IMAGE_PIX, string2);
            this.relocateImageResource(IMAGE_PIX_2, string2);
            stringBuffer.append(this.dotsGraph(metrics));
        } else {
            try {
                Class.forName("java.awt.image.BufferedImage");
                if (metrics != null) {
                    stringBuffer.append(this.JasonGraph(metrics, string));
                } else {
                    stringBuffer.append(this.JasonGraph(string));
                }
            }
            catch (InternalError internalError) {
                stringBuffer.append(this.dotsGraph(metrics));
            }
            catch (Exception exception) {
                stringBuffer.append(this.dotsGraph(metrics));
            }
        }
        stringBuffer.append("</TH></TR>\n");
        stringBuffer.append("<TR><TH ALIGN=RIGHT>Warehouses</TH>\n    <TH ALIGN=RIGHT>SPECjbb2005 bops</TH>\n    <TH ALIGN=RIGHT>Incl. in metric</TH>\n    <TH ALIGN=RIGHT>SPECjbb2005 bops</TH>\n    <TH ALIGN=RIGHT>Incl. in metric</TH></TR>\n");
        Result[] resultArray = metrics.getResults();
        int n3 = Math.max(this.maxWarehouses, metrics.maxWarehouses);
        double d = Math.max(this.highestScore, metrics.highestScore);
        int n4 = Math.min(this.result.length, resultArray.length);
        int n5 = Math.max(this.result.length, resultArray.length);
        for (int i = 1; i <= n3; ++i) {
            stringBuffer.append(this.BothScore(i, this.score_at_wh(i), metrics.score_at_wh(i), this.expectedPeakWh, metrics.get_whAtPeak()));
        }
        stringBuffer.append("<TR><TH ALIGN=LEFT>SPECjbb2005 = </TH>\n    <TH ALIGN=RIGHT>" + this.metric() + "SPECjbb2005 bops</TH>\n<TH> &nbsp </TH>" + "    <TH ALIGN=RIGHT>" + metrics.metric() + "SPECjbb2005 bops</TH>\n<TH> &nbsp </TH>" + "<P>\n");
        stringBuffer.append("</TR>\n</TABLE>\n");
        return stringBuffer.toString();
    }

    public void relocateImageResource(String string, String string2) {
        String string3 = IMAGE_RESOURCE_PATH + string;
        InputStream inputStream = this.getClass().getResourceAsStream(string3);
        if (inputStream == null) {
            return;
        }
        try {
            int n = -1;
            File file = new File(string2 + File.separator + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read()) > -1) {
                fileOutputStream.write(n);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "IOException:" + iOException.getMessage(), iOException);
        }
    }

    public int getSuggestedYAxisTickInterval(int n, double d) {
        double d2;
        int n2;
        double d3 = d / (double)n;
        int n3 = (int)(Math.log(d3) / Math.log(10.0));
        int n4 = n3 + 1;
        int[] nArray = new int[10];
        nArray[0] = (int)Math.pow(10.0, n3);
        nArray[9] = (int)Math.pow(10.0, n4);
        for (n2 = 0; n2 < nArray.length - 1; ++n2) {
            nArray[n2 + 1] = nArray[n2] + nArray[0];
        }
        n2 = 9;
        int n5 = Integer.MAX_VALUE;
        for (int i = nArray.length - 1; i >= 0 && !((d2 = (double)nArray[i] - d3) < 0.0); --i) {
            int n6 = (int)d2;
            if (n6 > n5 && n5 >= 0) continue;
            n5 = n6;
            n2 = i;
        }
        return nArray[n2];
    }

    public String BothScore(int n, double d, double d2, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer("<TR>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + n + "</TD>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + Metrics.score_format(d) + "</TD>\n");
        if (n2 <= n && n <= 2 * n2) {
            stringBuffer.append("  <TD ALIGN=RIGHT> *  </TD>\n");
        } else {
            stringBuffer.append("  <TD ALIGN=RIGHT>  &nbsp   </TD>\n");
        }
        stringBuffer.append("  <TD ALIGN=RIGHT>" + Metrics.score_format(d2) + "</TD>\n");
        if (n3 <= n && n <= 2 * n3) {
            stringBuffer.append("  <TD ALIGN=RIGHT> *  </TD>\n");
        } else {
            stringBuffer.append("  <TD ALIGN=RIGHT>   &nbsp  </TD>\n");
        }
        stringBuffer.append("</TR>\n");
        return stringBuffer.toString();
    }

    private double getScoreAt(int n) {
        if (n < this.score_at.length) {
            return this.score_at[n];
        }
        return 0.0;
    }
}

