/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Random;
import spec.jbb.Address;
import spec.jbb.Company;
import spec.jbb.Customer;
import spec.jbb.District;
import spec.jbb.History;
import spec.jbb.Infrastructure;
import spec.jbb.Item;
import spec.jbb.JBBDataStorage;
import spec.jbb.JBButil;
import spec.jbb.Stock;
import spec.jbb.Transaction;

public class Warehouse {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private String name;
    private Address address;
    private BigDecimal taxRate;
    private BigDecimal ytd;
    private short warehouseId;
    private Company company;
    private JBBDataStorage stockTable;
    private JBBDataStorage itemTable;
    private Object[] districts;
    private int distCount;
    private Random per_wh_r;
    private JBBDataStorage historyTable;
    private long historyCount;
    private long oldestHistory;
    private Object updateHistorySynch = new Object();
    private Object removeOldestHistorySynch = new Object();

    public Warehouse(Company company, JBBDataStorage jBBDataStorage) {
        this.company = company;
        this.districts = new Object[20];
        this.stockTable = Infrastructure.createStorage();
        this.itemTable = jBBDataStorage;
        this.address = new Address();
        this.historyTable = Infrastructure.createSortedStorage();
        this.historyCount = 0L;
        this.oldestHistory = 0L;
        this.ytd = BigDecimal.valueOf(0L, 2);
        this.loadStockTable();
    }

    public Warehouse() {
    }

    public void initWarehouse(Company company, JBBDataStorage jBBDataStorage, short s) {
        this.per_wh_r = JBButil.derived_random_init(s);
        JBButil.register_warehouse_Random_stream(s, this.per_wh_r);
        this.warehouseId = s;
        this.ytd = BigDecimal.valueOf(0L, 2);
        this.company = company;
        this.districts = new Object[20];
        this.stockTable = Infrastructure.createStorage();
        this.itemTable = jBBDataStorage;
        this.address = new Address();
        this.historyTable = Infrastructure.createSortedStorage();
        this.historyCount = 0L;
        this.oldestHistory = 0L;
        this.ytd = BigDecimal.valueOf(0L, 2);
        this.loadStockTable();
    }

    public boolean validDistrict(byte by) {
        for (int i = 0; i < this.distCount; ++i) {
            District district = (District)this.districts[i];
            if (district.getId() != by) continue;
            return true;
        }
        return false;
    }

    public short getId() {
        return this.warehouseId;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public Address getAddress() {
        return this.address;
    }

    public District getDistrictPtr(byte by, boolean bl) {
        District district = null;
        if (by > 0 && (by = (byte)(by - 1)) < this.distCount) {
            district = (District)this.districts[by];
        }
        return district;
    }

    public Stock retrieveStock(int n) {
        return (Stock)this.stockTable.get(n);
    }

    public Item retrieveItem(int n) {
        return (Item)this.itemTable.get(n);
    }

    public synchronized void receivePayment(BigDecimal bigDecimal) {
        this.ytd = this.ytd.add(bigDecimal);
    }

    public District getDistrict(int n) {
        District district = null;
        if (n > 0 && --n < this.distCount) {
            district = (District)this.districts[n];
        }
        return district;
    }

    public int getDistrictCount() {
        return this.distCount;
    }

    public synchronized void trimOrdersForSteadyState() {
        int n = this.company.getInitialOrders();
        int n2 = this.company.getInitialNewOrders();
        this.trimOrdersForSteadyState(n, n2);
    }

    public synchronized void trimOrdersForSteadyState(int n, int n2) {
        int n3 = this.getDistrictCount();
        for (int i = 1; i <= n3; ++i) {
            District district = this.getDistrict(i);
            if (!Transaction.steadyStateMem) continue;
            district.removeOldNewOrders(n - n2);
            district.removeOldOrders(n);
        }
    }

    public synchronized void setUsingRandom(short s) {
        this.warehouseId = s;
        this.name = new String(JBButil.create_random_a_string(6, 10, this.per_wh_r));
        this.address.setUsingRandom(this.per_wh_r);
        float f = JBButil.create_random_float_val_return(0.0f, 0.2f, 1.0E-4f, this.per_wh_r);
        this.taxRate = new BigDecimal(f).setScale(4, 4);
        this.ytd = BigDecimal.valueOf(30000000L, 2);
        this.distCount = this.company.getMaxDistrictsPerWarehouse();
        for (int i = 0; i < this.distCount; ++i) {
            byte by = (byte)(i + 1);
            District district = new District(this.warehouseId, by);
            district.setUsingRandom();
            this.districts[i] = district;
        }
    }

    public String getName() {
        return new String(this.name);
    }

    public void loadStockTable() {
        int n = this.itemTable.size();
        for (int i = 1; i <= n; ++i) {
            Item item = (Item)this.itemTable.get(i);
            Stock stock = new Stock(this.company, item.getId(), this.warehouseId);
            this.stockTable.put(stock.getId(), stock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHistory(History history) {
        Object object = this.updateHistorySynch;
        synchronized (object) {
            ++this.historyCount;
            this.historyTable.put(this.historyCount, history);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldestHistory() {
        Object object = this.removeOldestHistorySynch;
        synchronized (object) {
            ++this.oldestHistory;
            this.historyTable.remove(this.oldestHistory);
        }
    }

    public synchronized void loadHistoryTable() {
        for (byte by = 1; by <= this.company.getMaxDistrictsPerWarehouse(); by = (byte)((byte)(by + 1))) {
            for (short s = 1; s <= this.company.getMaxCustomersPerDistrict(); s = (short)(s + 1)) {
                long l = this.company.buildUniqueCustomerKey(this.warehouseId, by, s);
                Customer customer = this.company.getCustomer(l, false);
                BigDecimal bigDecimal = BigDecimal.valueOf(1000L, 2);
                String string = new String(JBButil.create_random_a_string(12, 25, this.warehouseId));
                Date date = new Date();
                History history = new History(s, customer.getDistrictId(), customer.getWarehouseId(), by, this.warehouseId, date, bigDecimal, string);
                this.updateHistory(history);
            }
        }
    }

    public synchronized JBBDataStorage getHistoryTable() {
        return this.historyTable;
    }
}

