/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.io.PrintStream;
import spec.jbb.Transaction;
import spec.jbb.infra.Util.TransactionLogBuffer;

public class TimerData {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private static byte menu = 0;
    private static byte typing = 1;
    private static byte thinking = (byte)2;
    private static byte maxWaitTypes = (byte)3;
    private TransactionLogBuffer timerLog;
    private long[] wait_times_menu;
    private long[] wait_times_typing;
    private long[] wait_times_thinking;
    private long[] transactionCount;
    private long[] totalTime;
    private long[] minimumTime;
    private long[] maximumTime;
    private float[] averageTime;
    private long[] totalTimeSquare;
    private double[] standardDeviationTime;
    private double[] coefficientOfVariationTime;
    private long min_transaction_count = Long.MAX_VALUE;
    private long max_transaction_count = Long.MIN_VALUE;
    private long rampup_time = 0L;
    private long measurement_time = 0L;
    private double tpmc = 0.0;
    private double btps = 0.0;
    private short timer_flag;
    private boolean useWaits = false;

    public TimerData() {
        this.wait_times_menu = new long[Transaction.maxTxnTypes];
        this.wait_times_typing = new long[Transaction.maxTxnTypes];
        this.wait_times_thinking = new long[Transaction.maxTxnTypes];
        this.transactionCount = new long[Transaction.maxTxnTypes];
        this.totalTime = new long[Transaction.maxTxnTypes];
        this.minimumTime = new long[Transaction.maxTxnTypes];
        this.maximumTime = new long[Transaction.maxTxnTypes];
        this.averageTime = new float[Transaction.maxTxnTypes];
        this.totalTimeSquare = new long[Transaction.maxTxnTypes];
        this.standardDeviationTime = new double[Transaction.maxTxnTypes];
        this.coefficientOfVariationTime = new double[Transaction.maxTxnTypes];
        for (int i = 0; i < Transaction.maxTxnTypes; ++i) {
            this.wait_times_menu[i] = 0L;
            this.wait_times_typing[i] = 0L;
            this.wait_times_thinking[i] = 0L;
            this.transactionCount[i] = 0L;
            this.totalTime[i] = 0L;
            this.minimumTime[i] = Long.MAX_VALUE;
            this.maximumTime[i] = 0L;
            this.averageTime[i] = 0.0f;
            this.totalTimeSquare[i] = 0L;
            this.standardDeviationTime[i] = 0.0;
            this.coefficientOfVariationTime[i] = 0.0;
        }
        this.min_transaction_count = Long.MAX_VALUE;
        this.max_transaction_count = Long.MIN_VALUE;
        this.buildDisplay();
    }

    public void initialize() {
        this.wait_times_menu = new long[Transaction.maxTxnTypes];
        this.wait_times_typing = new long[Transaction.maxTxnTypes];
        this.wait_times_thinking = new long[Transaction.maxTxnTypes];
        this.transactionCount = new long[Transaction.maxTxnTypes];
        this.totalTime = new long[Transaction.maxTxnTypes];
        this.minimumTime = new long[Transaction.maxTxnTypes];
        this.maximumTime = new long[Transaction.maxTxnTypes];
        this.averageTime = new float[Transaction.maxTxnTypes];
        this.totalTimeSquare = new long[Transaction.maxTxnTypes];
        this.standardDeviationTime = new double[Transaction.maxTxnTypes];
        this.coefficientOfVariationTime = new double[Transaction.maxTxnTypes];
        this.rampup_time = 0L;
        this.measurement_time = 0L;
        this.useWaits = false;
        this.tpmc = 0.0;
        this.btps = 0.0;
        for (int i = 0; i < Transaction.maxTxnTypes; ++i) {
            this.wait_times_menu[i] = 0L;
            this.wait_times_typing[i] = 0L;
            this.wait_times_thinking[i] = 0L;
            this.transactionCount[i] = 0L;
            this.totalTime[i] = 0L;
            this.minimumTime[i] = Long.MAX_VALUE;
            this.maximumTime[i] = 0L;
            this.averageTime[i] = 0.0f;
            this.totalTimeSquare[i] = 0L;
            this.standardDeviationTime[i] = 0.0;
            this.coefficientOfVariationTime[i] = 0.0;
        }
        this.min_transaction_count = Long.MAX_VALUE;
        this.max_transaction_count = Long.MIN_VALUE;
        this.buildDisplay();
    }

    public synchronized void zeroTimerData() {
        this.tpmc = 0.0;
        this.btps = 0.0;
        for (int i = 0; i < Transaction.maxTxnTypes; ++i) {
            this.transactionCount[i] = 0L;
            this.totalTime[i] = 0L;
            this.minimumTime[i] = Long.MAX_VALUE;
            this.maximumTime[i] = 0L;
            this.averageTime[i] = 0.0f;
            this.totalTimeSquare[i] = 0L;
            this.standardDeviationTime[i] = 0.0;
            this.coefficientOfVariationTime[i] = 0.0;
        }
        this.min_transaction_count = Long.MAX_VALUE;
        this.max_transaction_count = Long.MIN_VALUE;
        this.buildDisplay();
    }

    public synchronized void useWaitTimesPercentage(int n) {
        this.useWaits = true;
        this.wait_times_typing[0] = 18000 * n / 100;
        this.wait_times_typing[1] = 3000 * n / 100;
        this.wait_times_typing[2] = 2000 * n / 100;
        this.wait_times_typing[3] = 2000 * n / 100;
        this.wait_times_typing[4] = 2000 * n / 100;
        this.wait_times_typing[5] = 2000 * n / 100;
        this.wait_times_thinking[0] = 12000 * n / 100;
        this.wait_times_thinking[1] = 12000 * n / 100;
        this.wait_times_thinking[2] = 10000 * n / 100;
        this.wait_times_thinking[3] = 5000 * n / 100;
        this.wait_times_thinking[4] = 5000 * n / 100;
        this.wait_times_thinking[5] = 5000 * n / 100;
    }

    public synchronized void setRampUpTime(long l) {
        this.rampup_time = l;
    }

    public synchronized void setMeasurementTime(long l) {
        this.measurement_time = l;
    }

    public synchronized long getRampUpTime() {
        long l = this.rampup_time;
        return l;
    }

    public synchronized long getMeasurementTime() {
        long l = this.measurement_time;
        return l;
    }

    public synchronized long[][] getWaitTimes() {
        long[][] lArrayArray = new long[maxWaitTypes][];
        lArrayArray[TimerData.menu] = this.wait_times_menu;
        lArrayArray[TimerData.typing] = this.wait_times_typing;
        lArrayArray[TimerData.thinking] = this.wait_times_thinking;
        return lArrayArray;
    }

    public synchronized void setWaitTimes(long[][] lArray) {
        for (int i = 0; i < Transaction.maxTxnTypes; ++i) {
            this.wait_times_menu[i] = lArray[menu][i];
            this.wait_times_typing[i] = lArray[typing][i];
            this.wait_times_thinking[i] = lArray[thinking][i];
        }
    }

    public synchronized long getMenuWaitTime(int n) {
        long l = this.wait_times_menu[n];
        return l;
    }

    public synchronized long getTypingWaitTime(int n) {
        long l = this.wait_times_typing[n];
        return l;
    }

    public synchronized long getThinkingWaitTime(int n) {
        long l = this.wait_times_thinking[n];
        return l;
    }

    public synchronized void updateTimerData(int n, long l) {
        int n2 = n;
        this.transactionCount[n2] = this.transactionCount[n2] + 1L;
        int n3 = n;
        this.totalTime[n3] = this.totalTime[n3] + l;
        int n4 = n;
        this.totalTimeSquare[n4] = this.totalTimeSquare[n4] + l * l;
        if (l < this.minimumTime[n]) {
            this.minimumTime[n] = l;
        }
        if (l > this.maximumTime[n]) {
            this.maximumTime[n] = l;
        }
    }

    public synchronized void calculateResponseTimeStats() {
        for (int i = 0; i < Transaction.maxTxnTypes; ++i) {
            if (this.transactionCount[i] != 0L) {
                this.averageTime[i] = (float)this.totalTime[i] / (float)this.transactionCount[i] / 1000.0f;
                this.standardDeviationTime[i] = Math.sqrt(((double)this.transactionCount[i] * (double)this.totalTimeSquare[i] - (double)this.totalTime[i] * (double)this.totalTime[i]) / ((double)this.transactionCount[i] * ((double)this.transactionCount[i] - 1.0)));
                this.coefficientOfVariationTime[i] = 100.0 * this.standardDeviationTime[i] / ((double)this.totalTime[i] / (double)this.transactionCount[i]);
                continue;
            }
            this.averageTime[i] = 0.0f;
            this.standardDeviationTime[i] = 0.0;
            this.coefficientOfVariationTime[i] = 0.0;
        }
    }

    public synchronized long getTransactionCount(int n) {
        long l = this.transactionCount[n];
        return l;
    }

    public synchronized long getTotalTime(int n) {
        long l = this.totalTime[n];
        return l;
    }

    public synchronized long getTotalTimeSquare(int n) {
        long l = this.totalTimeSquare[n];
        return l;
    }

    public synchronized long getMinimumTime(int n) {
        long l = this.minimumTime[n];
        return l;
    }

    public synchronized long getMaximumTime(int n) {
        long l = this.maximumTime[n];
        return l;
    }

    public synchronized void rollupTimerData(int n, long l, long l2, long l3, long l4, long l5) {
        int n2 = n;
        this.transactionCount[n2] = this.transactionCount[n2] + l;
        int n3 = n;
        this.totalTime[n3] = this.totalTime[n3] + l2;
        int n4 = n;
        this.totalTimeSquare[n4] = this.totalTimeSquare[n4] + l3;
        if (l4 < this.minimumTime[n] || this.minimumTime[n] == 0L) {
            this.minimumTime[n] = l4;
        }
        if (l5 > this.maximumTime[n]) {
            this.maximumTime[n] = l5;
        }
    }

    public synchronized void accumulateTransactionStats(long l) {
        if (l < this.min_transaction_count) {
            this.min_transaction_count = l;
        }
        if (l > this.max_transaction_count) {
            this.max_transaction_count = l;
        }
    }

    public synchronized double getTPMC() {
        double d = this.tpmc;
        return d;
    }

    public synchronized double updateTPMC(double d) {
        this.tpmc += d;
        return this.tpmc;
    }

    public synchronized double updateTPMC(long l) {
        double d = (double)this.getTransactionCount(0) / ((double)l / 1000.0) * 60.0;
        this.tpmc += d;
        return this.tpmc;
    }

    public synchronized double getBTPS() {
        double d = this.btps;
        return d;
    }

    public synchronized double updateBTPS(double d) {
        this.btps += d;
        return this.btps;
    }

    public synchronized double updateBTPS(long l) {
        int n = 0;
        for (int i = 0; i < Transaction.maxTxnTypes; ++i) {
            n = (int)((long)n + this.transactionCount[i]);
        }
        double d = (double)n / ((double)l / 1000.0);
        this.btps += d;
        return this.btps;
    }

    private void buildDisplay() {
        this.timerLog = new TransactionLogBuffer(12, 80);
        this.timerLog.putCharFill('=', 0, 0, 79);
        this.timerLog.putText("TOTALS FOR:", 0, 1, 12);
        int n = "SPECjbb2005 1.07".length();
        int n2 = 1 + n + 1 + 25 + 1;
        int n3 = (79 - n2) / 2;
        this.timerLog.putCharFill('.', 0, 2, n3);
        this.timerLog.putText("SPECjbb2005 1.07", n3 + 1, 2, n);
        this.timerLog.putText("Results (time in seconds)", n3 + 1 + n + 1, 2, 25);
        this.timerLog.putCharFill('.', n3 + 1 + n + 1 + 25 + 1, 2, n3);
        this.timerLog.putText("Count", 19, 3, 5);
        this.timerLog.putText("Total", 29, 3, 5);
        this.timerLog.putText("Min", 38, 3, 3);
        this.timerLog.putText("Max", 46, 3, 3);
        this.timerLog.putText("Avg", 54, 3, 3);
        this.timerLog.putText("New Order:", 0, 4, 14, (short)2);
        this.timerLog.putText("Payment:", 0, 5, 14, (short)2);
        this.timerLog.putText("OrderStatus:", 0, 6, 14, (short)2);
        this.timerLog.putText("Delivery:", 0, 7, 14, (short)2);
        this.timerLog.putText("Stock Level:", 0, 8, 14, (short)2);
        this.timerLog.putText("Cust Report:", 0, 9, 14, (short)2);
        this.timerLog.putText("throughput =", 11, 11, 12);
        this.timerLog.putText("SPECjbb2005 bops", 38, 11, 17);
    }

    public void formatResults(TransactionLogBuffer transactionLogBuffer) {
        transactionLogBuffer.putLong(this.transactionCount[0], 16, 4, 8);
        transactionLogBuffer.putDouble((double)this.totalTime[0] / 1000.0, 26, 4, 8, 2);
        transactionLogBuffer.putDouble((double)this.minimumTime[0] / 1000.0, 36, 4, 6, 3);
        transactionLogBuffer.putDouble((double)this.maximumTime[0] / 1000.0, 44, 4, 6, 3);
        transactionLogBuffer.putDouble(this.averageTime[0], 52, 4, 6, 3);
        transactionLogBuffer.putLong(this.transactionCount[1], 16, 5, 8);
        transactionLogBuffer.putDouble((double)this.totalTime[1] / 1000.0, 26, 5, 8, 2);
        transactionLogBuffer.putDouble((double)this.minimumTime[1] / 1000.0, 36, 5, 6, 3);
        transactionLogBuffer.putDouble((double)this.maximumTime[1] / 1000.0, 44, 5, 6, 3);
        transactionLogBuffer.putDouble(this.averageTime[1], 52, 5, 6, 3);
        transactionLogBuffer.putLong(this.transactionCount[2], 16, 6, 8);
        transactionLogBuffer.putDouble((double)this.totalTime[2] / 1000.0, 26, 6, 8, 2);
        transactionLogBuffer.putDouble((double)this.minimumTime[2] / 1000.0, 36, 6, 6, 3);
        transactionLogBuffer.putDouble((double)this.maximumTime[2] / 1000.0, 44, 6, 6, 3);
        transactionLogBuffer.putDouble(this.averageTime[2], 52, 6, 6, 3);
        transactionLogBuffer.putLong(this.transactionCount[3], 16, 7, 8);
        transactionLogBuffer.putDouble((double)this.totalTime[3] / 1000.0, 26, 7, 8, 2);
        transactionLogBuffer.putDouble((double)this.minimumTime[3] / 1000.0, 36, 7, 6, 3);
        transactionLogBuffer.putDouble((double)this.maximumTime[3] / 1000.0, 44, 7, 6, 3);
        transactionLogBuffer.putDouble(this.averageTime[3], 52, 7, 6, 3);
        transactionLogBuffer.putLong(this.transactionCount[4], 16, 8, 8);
        transactionLogBuffer.putDouble((double)this.totalTime[4] / 1000.0, 26, 8, 8, 2);
        transactionLogBuffer.putDouble((double)this.minimumTime[4] / 1000.0, 36, 8, 6, 3);
        transactionLogBuffer.putDouble((double)this.maximumTime[4] / 1000.0, 44, 8, 6, 3);
        transactionLogBuffer.putDouble(this.averageTime[4], 52, 8, 6, 3);
        transactionLogBuffer.putLong(this.transactionCount[5], 16, 9, 8);
        transactionLogBuffer.putDouble((double)this.totalTime[5] / 1000.0, 26, 9, 8, 2);
        transactionLogBuffer.putDouble((double)this.minimumTime[5] / 1000.0, 36, 9, 6, 3);
        transactionLogBuffer.putDouble((double)this.maximumTime[5] / 1000.0, 44, 9, 6, 3);
        transactionLogBuffer.putDouble(this.averageTime[5], 52, 9, 6, 3);
        transactionLogBuffer.putDouble(this.btps, 25, 11, 12, 2);
    }

    public synchronized void displayResults(String string, long l, long l2) {
        long l3 = l - l2;
        double d = (double)l / 1048576.0;
        double d2 = (double)l3 / 1048576.0;
        this.timerLog.putText(string, 12, 1, 60);
        this.formatResults(this.timerLog);
        this.timerLog.putText("Heap Space", 61, 3, 10);
        this.timerLog.putDouble(d, 66, 4, 11, 1);
        this.timerLog.putText("total", 61, 4, 5);
        this.timerLog.putText("MB", 77, 4, 2);
        this.timerLog.putDouble(d2, 66, 5, 11, 1);
        this.timerLog.putText(" used", 61, 5, 5);
        this.timerLog.putText("MB", 77, 5, 2);
        this.timerLog.display(System.out);
    }

    public synchronized void propResults(String string, PrintStream printStream) {
        printStream.println(string + "new_order.count=" + this.transactionCount[0]);
        printStream.println(string + "new_order.totaltime=" + (double)this.totalTime[0] / 1000.0);
        printStream.println(string + "new_order.minimumtime=" + (double)this.minimumTime[0] / 1000.0);
        printStream.println(string + "new_order.maximumtime=" + (double)this.maximumTime[0] / 1000.0);
        printStream.println(string + "new_order.averagetime=" + this.averageTime[0]);
        printStream.println(string + "new_order.stddevtime=" + this.standardDeviationTime[0] / 1000.0);
        printStream.println(string + "new_order.coeffvartime=" + this.coefficientOfVariationTime[0]);
        printStream.println(string + "payment.count=" + this.transactionCount[1]);
        printStream.println(string + "payment.totaltime=" + (double)this.totalTime[1] / 1000.0);
        printStream.println(string + "payment.minimumtime=" + (double)this.minimumTime[1] / 1000.0);
        printStream.println(string + "payment.maximumtime=" + (double)this.maximumTime[1] / 1000.0);
        printStream.println(string + "payment.averagetime=" + this.averageTime[1]);
        printStream.println(string + "payment.stddevtime=" + this.standardDeviationTime[1] / 1000.0);
        printStream.println(string + "payment.coeffvartime=" + this.coefficientOfVariationTime[1]);
        printStream.println(string + "order_status.count=" + this.transactionCount[2]);
        printStream.println(string + "order_status.totaltime=" + (double)this.totalTime[2] / 1000.0);
        printStream.println(string + "order_status.minimumtime=" + (double)this.minimumTime[2] / 1000.0);
        printStream.println(string + "order_status.maximumtime=" + (double)this.maximumTime[2] / 1000.0);
        printStream.println(string + "order_status.averagetime=" + this.averageTime[2]);
        printStream.println(string + "order_status.stddevtime=" + this.standardDeviationTime[2] / 1000.0);
        printStream.println(string + "order_status.coeffvartime=" + this.coefficientOfVariationTime[2]);
        printStream.println(string + "delivery.count=" + this.transactionCount[3]);
        printStream.println(string + "delivery.totaltime=" + (double)this.totalTime[3] / 1000.0);
        printStream.println(string + "delivery.minimumtime=" + (double)this.minimumTime[3] / 1000.0);
        printStream.println(string + "delivery.maximumtime=" + (double)this.maximumTime[3] / 1000.0);
        printStream.println(string + "delivery.averagetime=" + this.averageTime[3]);
        printStream.println(string + "delivery.stddevtime=" + this.standardDeviationTime[3] / 1000.0);
        printStream.println(string + "delivery.coeffvartime=" + this.coefficientOfVariationTime[3]);
        printStream.println(string + "stock_level.count=" + this.transactionCount[4]);
        printStream.println(string + "stock_level.totaltime=" + (double)this.totalTime[4] / 1000.0);
        printStream.println(string + "stock_level.minimumtime=" + (double)this.minimumTime[4] / 1000.0);
        printStream.println(string + "stock_level.maximumtime=" + (double)this.maximumTime[4] / 1000.0);
        printStream.println(string + "stock_level.averagetime=" + this.averageTime[4]);
        printStream.println(string + "stock_level.stddevtime=" + this.standardDeviationTime[4] / 1000.0);
        printStream.println(string + "stock_level.coeffvartime=" + this.coefficientOfVariationTime[4]);
        printStream.println(string + "cust_report.count=" + this.transactionCount[5]);
        printStream.println(string + "cust_report.totaltime=" + (double)this.totalTime[5] / 1000.0);
        printStream.println(string + "cust_report.minimumtime=" + (double)this.minimumTime[5] / 1000.0);
        printStream.println(string + "cust_report.maximumtime=" + (double)this.maximumTime[5] / 1000.0);
        printStream.println(string + "cust_report.averagetime=" + this.averageTime[5]);
        printStream.println(string + "cust_report.stddevtime=" + this.standardDeviationTime[5] / 1000.0);
        printStream.println(string + "cust_report.coeffvartime=" + this.coefficientOfVariationTime[5]);
        printStream.println(string + "score=" + this.btps);
    }

    public synchronized void propResults(String string, PrintStream printStream, long l, long l2) {
        this.propResults(string, printStream);
        long l3 = l - l2;
        double d = (double)l / 1048576.0;
        double d2 = (double)l3 / 1048576.0;
        printStream.println(string + "heapsize=" + d);
        printStream.println(string + "heapused=" + d2);
    }

    public synchronized void displayThreadResults() {
        long l = this.max_transaction_count - this.min_transaction_count;
        float f = 100.0f * (float)l / (float)this.min_transaction_count;
    }

    public synchronized void propThreadResults(String string, PrintStream printStream) {
        printStream.println(string + "min_thread_transactions=" + this.min_transaction_count);
        printStream.println(string + "max_thread_transactions=" + this.max_transaction_count);
    }
}

