/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.math.BigDecimal;
import java.util.Date;
import spec.jbb.Company;
import spec.jbb.Customer;
import spec.jbb.District;
import spec.jbb.JBButil;
import spec.jbb.NewOrder;
import spec.jbb.Order;
import spec.jbb.Orderline;
import spec.jbb.Transaction;
import spec.jbb.Warehouse;
import spec.jbb.infra.Util.TransactionLogBuffer;
import spec.jbb.infra.Util.XMLTransactionLog;

class NewOrderTransaction
extends Transaction {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private Company company;
    private short warehouseId;
    private byte districtId;
    private short customerId;
    private Warehouse warehousePtr;
    private District districtPtr;
    private short number_of_orderlines;
    private boolean rollback;
    private BigDecimal warehouseTaxRate;
    private BigDecimal districtTaxRate;
    private int orderId;
    private BigDecimal customerDiscountRate;
    private String customerLastName;
    private String customerCreditStatus;
    private short orderline_count;
    private Order thisOrder;
    private TransactionLogBuffer backLog;
    private TransactionLogBuffer initLog;
    private TransactionLogBuffer orderLog;
    private XMLTransactionLog xmlOrderLog;
    String[] validationLog = new String[]{"                                   New Order", "Warehouse:    1   District:  6                        Date: 13-04-2000 10:10:51", "Customer:    17   Name: BAROUGHTANTI       Credit: GC   %Disc: 43.11", "Order Number:       31  Number of Lines: 15        W_tax: 10.30   D_tax:  6.62", "", " Supp_W  Item_Id  Item Name                 Qty  Stock  B/G  Price    Amount   ", "     1    12117   rk9rIQP9q52FiN4FWuihzNT    5     59    G    $61.73   $308.65 ", "     1    19072   0VOgv21kW1ZS3pv1IzirxrmH   5     79    G    $26.62   $133.10 ", "     1     4260   clRd7h9zm9eGwqtvKblk1q     5     53    G    $85.08   $425.40 ", "     1     5772   b96nAb1I7qPaOA             5     73    G    $50.24   $251.20 ", "     1      587   98ILzFnfHy8rwch            5     79    G     $3.44    $17.20 ", "     1     2790   yrZXzgfPRKxNQW             5     71    G    $33.70   $168.50 ", "     1      687   G1GcZl0h1P7gJ4GxZhnuT      5     57    G    $46.26   $231.30 ", "     1     5258   b9PfVfw5TcKQe0iEZaPEWkt    5     14    G    $45.62   $228.10 ", "     1    12238   w0Tu7bleXb7XXY03           5     33    G    $70.20   $351.00 ", "     1     4933   TvoMqL3eITHLzearKdECH      5     89    G    $93.19   $465.95 ", "     1     4186   LNDK2oajzLA29ICevp8eBx     5     34    G    $49.22   $246.10 ", "     1     6996   450trcQ3zvuPwWHGb6i        5     56    G     $6.11    $30.55 ", "     1     9925   Vh0KacEuowjiT8ey           5     10    G    $72.28   $361.40 ", "     1    12042   m7ryJMNGNEaOaKEG           5     19    G    $65.31   $326.55 ", "     1     9471   hAdDzcbhMhlOQTUecrfFCym    5    100    G    $68.54   $342.70 ", "Execution Status: ---- Order is valid ----                   Total:   $2585.93 ", "", ""};
    boolean[] checkLine = new boolean[]{true, false, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, false, true, true, true, true, true, true};

    public NewOrderTransaction(Company company, short s) {
        this.company = company;
        this.warehouseId = s;
        this.warehousePtr = this.company.getWarehousePtr(this.warehouseId, false);
        this.orderLog = new TransactionLogBuffer();
        this.setupOrderLog();
        this.xmlOrderLog = new XMLTransactionLog();
        this.initLog = new TransactionLogBuffer(this.orderLog);
        this.setupInitLog();
    }

    private void setupOrderLog() {
        this.orderLog.putText("New Order", 35, 0, 9);
        this.orderLog.putText("Warehouse:", 0, 1, 10);
        this.orderLog.putInt(this.warehouseId, 11, 1, 4);
        this.orderLog.putText("District:", 18, 1, 9);
        this.orderLog.putText("Date:", 54, 1, 5);
        this.orderLog.putText("Customer:", 0, 2, 10);
        this.orderLog.putText("Name:", 18, 2, 5);
        this.orderLog.putText("Credit:", 43, 2, 7);
        this.orderLog.putText("%Disc:", 56, 2, 6);
        this.orderLog.putText("Order Number:", 0, 3, 14);
        this.orderLog.putText("Number of Lines:", 24, 3, 26);
        this.orderLog.putText("W_tax:", 51, 3, 6);
        this.orderLog.putText("D_tax:", 66, 3, 6);
        this.orderLog.putText(" Supp_W  Item_Id  Item Name                 Qty  Stock  B/G  Price    Amount", 0, 5, 79);
        this.orderLog.putText("Execution Status:", 0, 21, 17);
        this.orderLog.putText("Total:", 61, 21, 6);
    }

    private void setupInitLog() {
        this.initLog.putCharFill('9', 28, 1, 2);
        this.initLog.putText("DD-MM-YYYY hh:mm:ss", 60, 1, 19);
        this.initLog.putCharFill('9', 11, 2, 4);
        this.initLog.putCharFill('X', 24, 2, 16);
        this.initLog.putCharFill('X', 51, 2, 2);
        this.initLog.putText("99.99", 63, 2, 5);
        this.initLog.putCharFill('9', 14, 3, 8);
        this.initLog.putCharFill('9', 41, 3, 2);
        this.initLog.putText("99.99", 58, 3, 5);
        this.initLog.putText("99.99", 73, 3, 5);
        for (int i = 6; i < 21; ++i) {
            this.initLog.putCharFill('9', 2, i, 4);
            this.initLog.putCharFill('9', 9, i, 6);
            this.initLog.putCharFill('X', 18, i, 24);
            this.initLog.putCharFill('9', 44, i, 2);
            this.initLog.putCharFill('9', 50, i, 3);
            this.initLog.putChar('X', 57, i);
            this.initLog.putText("$999.99", 61, i, 7);
            this.initLog.putText("$9999.99", 70, i, 8);
        }
        this.initLog.putCharFill('X', 18, 21, 24);
        this.initLog.putText("$99999.99", 69, 21, 9);
    }

    public String getMenuName() {
        return "New-Order";
    }

    public void delete() {
    }

    public void init() {
        JBButil.getLog().entering("spec.jbb.NewOrderTransaction", "init");
        this.districtId = (byte)JBButil.random(1, (int)this.company.getMaxDistrictsPerWarehouse(), this.warehouseId);
        this.customerId = JBButil.create_random_customer_id(this.company.getMaxCustomersPerDistrict(), this.warehouseId);
        this.number_of_orderlines = (short)JBButil.random(Transaction.minOrderlines, Transaction.maxOrderlines, this.warehouseId);
        this.rollback = JBButil.random(1, 100, this.warehouseId) == 1;
        this.rollback = false;
        this.districtPtr = this.warehousePtr.getDistrictPtr(this.districtId, false);
        JBButil.getLog().exiting("spec.jbb.NewOrderTransaction", "init");
    }

    public boolean process() {
        JBButil.getLog().entering("spec.jbb.NewOrderTransaction", "process");
        this.warehouseTaxRate = this.warehousePtr.getTaxRate();
        this.districtTaxRate = this.districtPtr.getTaxRate();
        this.orderId = this.districtPtr.nextOrderId();
        long l = this.company.buildUniqueCustomerKey(this.warehouseId, this.districtId, this.customerId);
        Customer customer = this.company.getCustomer(l, false);
        this.customerDiscountRate = customer.getDiscountRate();
        this.customerLastName = customer.getLastName();
        this.customerCreditStatus = customer.getCreditStatus();
        this.thisOrder = new Order(this.company, this.orderId, this.districtId, this.warehouseId, this.customerId, customer, this.districtTaxRate, this.warehouseTaxRate, this.customerDiscountRate);
        NewOrder newOrder = new NewOrder(this.thisOrder, this.orderId, this.districtId, this.warehouseId);
        if (this.thisOrder.processLines(this.warehousePtr, this.number_of_orderlines, this.rollback)) {
            this.orderline_count = this.thisOrder.getOrderlineCount();
            this.districtPtr.addOrder(this.thisOrder);
            this.districtPtr.addNewOrder(newOrder);
            customer.addOrder(this.thisOrder);
        } else {
            this.orderline_count = 0;
        }
        JBButil.getLog().exiting("spec.jbb.NewOrderTransaction", "process");
        return true;
    }

    public synchronized void display() {
        System.out.println("**** NewOrderTransaction Display **********************");
        System.out.println("*       Warehouse ID is " + this.warehouseId + "                      *");
        System.out.println("*       District  ID is " + this.districtId + "                      *");
        System.out.println("*       Customer  ID is " + this.customerId + "                      *");
        System.out.println("*******************************************************");
    }

    public void initializeTransactionLog() {
        JBButil.getLog().entering("spec.jbb.NewOrderTransaction", "initializeTransactionLog");
        if (Transaction.enableLogWrite) {
            this.initLog.display();
        }
        JBButil.getLog().exiting("spec.jbb.NewOrderTransaction", "initializeTransactionLog");
    }

    public synchronized void processTransactionLog() {
        int n;
        Object[] objectArray;
        JBButil.getLog().entering("spec.jbb.NewOrderTransaction", "processTransactionLog");
        this.orderLog.clearBuffer();
        this.xmlOrderLog.clear();
        this.setupOrderLog();
        Date date = this.thisOrder.getEntryTime();
        this.orderLog.putInt(this.districtId, 28, 1, 2);
        this.orderLog.putDate(date, 60, 1, 10);
        this.orderLog.putTime(date, 71, 1, 8);
        this.orderLog.putInt(this.customerId, 11, 2, 4);
        this.orderLog.putText(this.customerLastName, 24, 2, 16);
        this.orderLog.putText(this.customerCreditStatus, 51, 2, 2);
        this.orderLog.putDouble(this.customerDiscountRate.movePointRight(2).toString(), 63, 2, 5);
        this.orderLog.putInt(this.orderId, 14, 3, 8);
        this.orderLog.putInt(this.orderline_count, 41, 3, 2);
        this.orderLog.putDouble(this.warehouseTaxRate.movePointRight(2).toString(), 58, 3, 5);
        this.orderLog.putDouble(this.districtTaxRate.movePointRight(2).toString(), 73, 3, 5);
        if (this.orderline_count > 0) {
            objectArray = this.thisOrder.getOrderlineList();
            n = this.thisOrder.getOrderlineCount();
            for (int i = 0; i < n; ++i) {
                int n2 = i + 6;
                if (i >= 15) {
                    n2 = 20;
                }
                Orderline orderline = objectArray[i];
                this.orderLog.putInt(orderline.getSupplyWarehouse(), 2, n2, 4);
                this.orderLog.putInt(orderline.getItemId(), 9, n2, 6);
                this.orderLog.putText(orderline.getItemName(), 18, n2, 24);
                this.orderLog.putInt(orderline.getQuantity(), 44, n2, 2);
                this.orderLog.putInt(orderline.getStockQuantity(), 50, n2, 3);
                this.orderLog.putChar(orderline.getBrandGeneric(), 57, n2);
                this.orderLog.putDollars(orderline.getItemPrice(), 62, n2, 7);
                this.orderLog.putDollars(orderline.getAmount(), 71, n2, 8);
            }
        }
        if (this.orderline_count > 0) {
            this.orderLog.putText("---- Order is valid ----", 18, 21, 24);
            this.orderLog.putDollars(this.thisOrder.getTotalAmount(), 70, 21, 9);
        } else {
            this.orderLog.putText("ITEM NUMBER IS NOT VALID", 18, 21, 24);
            this.orderLog.putDollars(0.0, 69, 21, 9);
        }
        this.xmlOrderLog.populateXML(this.orderLog);
        if (Transaction.enableLogWrite) {
            this.orderLog.display();
        }
        if (Transaction.validationFlag) {
            objectArray = this.orderLog.validate();
            if (objectArray.length != this.validationLog.length) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("VALIDATION ERROR:  mismatch in screen lengths for NewOrderTransaction");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Screen length should be:  " + this.validationLog.length);
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Screen length is:  " + objectArray.length);
                JBButil.getLog().warning(stringBuffer.toString());
                Transaction.invalidateRun();
            }
            for (n = 0; n < this.validationLog.length; ++n) {
                if (!this.checkLine[n] || ((String)objectArray[n]).equals(this.validationLog[n])) continue;
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("VALIDATION ERROR:  incorrect output for NewOrderTransaction");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Line " + (n + 1) + " should be:  |" + this.validationLog[n] + "|");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Line " + (n + 1) + " is:  |" + (String)objectArray[n] + "|");
                JBButil.getLog().warning(stringBuffer.toString());
                Transaction.invalidateRun();
            }
        }
        JBButil.getLog().exiting("spec.jbb.NewOrderTransaction", "processTransactionLog");
    }

    public synchronized void processPreloadedOrders() {
        this.orderId = this.districtPtr.nextOrderId();
        long l = this.company.buildUniqueCustomerKey(this.warehouseId, this.districtId, this.customerId);
        Customer customer = this.company.getCustomer(l, false);
        BigDecimal bigDecimal = BigDecimal.valueOf(0L, 2);
        this.thisOrder = new Order(this.company, this.orderId, this.districtId, this.warehouseId, this.customerId, customer, bigDecimal, bigDecimal, bigDecimal);
        this.districtPtr.addOrder(this.thisOrder);
        customer.addOrder(this.thisOrder);
        Date date = new Date();
        this.thisOrder.setEntryDateTime(date);
        if (this.orderId <= this.company.getInitialOrders() - this.company.getInitialNewOrders()) {
            byte by = (byte)JBButil.random(1, 10, this.warehouseId);
            this.thisOrder.setCarrierId(by);
        }
        this.thisOrder.setAllLocal(true);
        this.thisOrder.processLines(this.warehousePtr, this.number_of_orderlines, false);
        this.orderline_count = this.thisOrder.getOrderlineCount();
        if (this.orderId > this.company.getInitialOrders() - this.company.getInitialNewOrders()) {
            NewOrder newOrder = new NewOrder(this.thisOrder, this.orderId, this.districtId, this.warehouseId);
            this.districtPtr.addNewOrder(newOrder);
        }
    }

    public synchronized void setDistrictandCustomer(byte by, short s) {
        this.districtId = by;
        this.customerId = s;
        this.districtPtr = this.warehousePtr.getDistrictPtr(this.districtId, false);
    }
}

