/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.suites;

import at.jku.ssw.mevss.benchmarks.AbstractBenchmarkSuite;
import at.jku.ssw.mevss.benchmarks.BenchmarkSuite;
import at.jku.ssw.mevss.benchmarks.FileUtil;
import at.jku.ssw.mevss.benchmarks.ProcessExecutor;
import at.jku.ssw.mevss.benchmarks.Settings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class SPECjvmBenchmarkSuite
extends AbstractBenchmarkSuite
implements BenchmarkSuite {
    private static final String JAR_NAME = "SPECjvm" + File.separator + "SPECjvm2008.jar";
    private static final boolean SHORTEN_HEAVY = true;
    private static final boolean SHORTEN_NORMAL = true;

    public SPECjvmBenchmarkSuite(String string, boolean bl, Settings settings) {
        super(string, bl, settings);
    }

    private String getJarPath() {
        return this.getDirectory() + JAR_NAME;
    }

    @Override
    public String getName() {
        return "SPECjvm";
    }

    @Override
    public String[] getBenchmarks() {
        Object[] objectArray;
        try {
            String[] stringArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray = FileUtil.readAll(ProcessExecutor.execute((boolean)(!this.getSettings().forceLoudProcesses ? true : false), (String)".", (long)10000L, null, null, (String[])new String[]{"java", "-jar", this.getJarPath(), "--help"}).out).split("\n")) {
                if (!string.startsWith("Benchmarks:")) continue;
                for (String string2 : string.substring("Benchmarks:".length()).trim().split(" ")) {
                    if (string2.startsWith("startup")) continue;
                    arrayList.add(string2);
                }
            }
            objectArray = arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IOException | InterruptedException exception) {
            exception.printStackTrace(System.err);
            objectArray = new String[]{};
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    @Override
    public String[] getSystemProperties(String string) {
        return new String[]{"-Dspecjvm.home.dir=" + this.getDirectory() + File.separator + "SPECjvm" + File.separator};
    }

    @Override
    public String[] getClassPath() {
        return new String[]{this.getJarPath()};
    }

    @Override
    public String getMainClass() {
        return "spec.harness.Launch";
    }

    @Override
    public String[] getParameters(String string, int n) {
        String[] stringArray = new String[]{"-Dspecjvm.benchmark.analyzer.names=at.jku.ssw.mevss.benchmarks.agent.suites.SPECjvmManagedAgent", "-Dspecjvm.result.dir=scratch", "-crf", "false", "-ctf", "false", "-chf", "false", "-ict", "-ikv", string};
        String string2 = System.getProperty("benchmarkexecutor.SPECjvm.iterationtime");
        if (string2 != null) {
            stringArray = SPECjvmBenchmarkSuite.insert(stringArray, stringArray.length - 1, "--iterationTime");
            stringArray = SPECjvmBenchmarkSuite.insert(stringArray, stringArray.length - 1, string2);
        } else {
            int n2 = this.isFast() ? 1 : (string.equals("scimark.monte_carlo") ? Math.max(1, this.getOperations(string) / 100) : (string.startsWith("scimark.") || string.startsWith("crypto.") || string.equals("compress") || string.equals("mpegaudio") ? Math.max(1, this.getOperations(string) / 10) : 0));
            String string3 = System.getProperty("benchmarkexecutor.SPECjvm.operationfactor");
            if (string3 != null && string3.length() > 0) {
                double d = Double.parseDouble(string3);
                if (n2 == 0) {
                    n2 = this.getOperations(string);
                }
                n2 = (int)((double)n2 * d);
                boolean bl = n > 0;
                n = (int)((double)n / d);
                if (bl && n == 0) {
                    n = 0;
                }
            }
            if (n2 > 0) {
                String string4 = "-Dspecjvm.fixed.operations." + string + "=" + n2;
                stringArray = SPECjvmBenchmarkSuite.insert(stringArray, stringArray.length - 1, string4);
            }
            stringArray = SPECjvmBenchmarkSuite.insert(stringArray, stringArray.length - 1, "--lagom");
        }
        stringArray = SPECjvmBenchmarkSuite.insert(stringArray, stringArray.length - 1, "--iterations");
        stringArray = SPECjvmBenchmarkSuite.insert(stringArray, stringArray.length - 1, String.valueOf(n + 1));
        return stringArray;
    }

    private static String[] insert(String[] stringArray, int n, String ... stringArray2) {
        int n2;
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            stringArray3[n3++] = stringArray[n2];
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArray3[n3++] = stringArray2[n2];
        }
        for (n2 = n; n2 < stringArray.length; ++n2) {
            stringArray3[n3++] = stringArray[n2];
        }
        assert (n3 == stringArray3.length);
        return stringArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getOperations(String string) {
        try {
            String string2 = "# specjvm.fixed.operations." + string + "=!,";
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getDirectory() + File.separator + "SPECjvm" + File.separator + "props" + File.separator + "specjvm.properties"));){
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    if (string3.startsWith(string2)) {
                        int n;
                        int n2 = 0;
                        for (n = string2.length(); n < string3.length() && Character.isDigit(string3.charAt(n)); ++n) {
                            char c = string3.charAt(n);
                            int n3 = c - 48;
                            n2 = n2 * 10 + n3;
                        }
                        n = n2;
                        return n;
                    }
                    string3 = bufferedReader.readLine();
                }
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public String[] getPrepareCommand(String string, int n) {
        return this.getCleanupCommand(string);
    }

    @Override
    public String[] getCleanupCommand(String string) {
        return new String[]{"rm", "-r", "scratch"};
    }

    @Override
    public boolean isLauncher() {
        return false;
    }

    @Override
    public boolean deploysCallback() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        return new File(this.getJarPath()).exists();
    }
}

