/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.suites;

import at.jku.ssw.mevss.benchmarks.AbstractBenchmarkSuite;
import at.jku.ssw.mevss.benchmarks.BenchmarkSuite;
import at.jku.ssw.mevss.benchmarks.ProcessExecutor;
import at.jku.ssw.mevss.benchmarks.Settings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class DynaTraceBenchmarkSuite
extends AbstractBenchmarkSuite
implements BenchmarkSuite {
    public DynaTraceBenchmarkSuite(String string, boolean bl, Settings settings) {
        super(string, bl, settings);
    }

    @Override
    protected String getDirectory() {
        return super.getDirectory() + File.separator + "dynaTrace";
    }

    @Override
    public String getName() {
        return "dynaTrace";
    }

    @Override
    public String[] getBenchmarks() {
        return new String[]{"server", "collector"};
    }

    @Override
    public String[] getExclusiveResources(String string) {
        return new String[]{"networking", "dynatrace"};
    }

    @Override
    public String[] getPrepareCommand(String string, int n) {
        return this.getCleanupCommand(string);
    }

    @Override
    public String[] getCleanupCommand(String string) {
        return null;
    }

    @Override
    public boolean isLauncher() {
        return true;
    }

    @Override
    public boolean deploysCallback() {
        return false;
    }

    @Override
    public String[] getSystemProperties(String string) {
        return new String[]{"-Dbenchmarkexecutor.agent.operationimplementation=" + this.readOperations()};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readOperations() {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getDirectory() + File.separator + "operation_definitions.ini"));){
            StringBuilder stringBuilder = new StringBuilder();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
                string = bufferedReader.readLine();
            }
            string = stringBuilder.toString().trim().replace('\n', ',');
            return string;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public String[] getClassPath() {
        return new String[0];
    }

    @Override
    public String getMainClass() {
        return "bash";
    }

    @Override
    public String[] getParameters(String string, int n) {
        return new String[]{this.getDirectory() + File.separator + "run.sh", string, String.valueOf((this.isFast() ? 5 : 30) * 60)};
    }

    @Override
    public boolean isAvailable() {
        try {
            return System.getProperty("os.name").toLowerCase().contains("linux") && ProcessExecutor.execute((boolean)(!this.getSettings().forceLoudProcesses ? true : false), (String[])new String[]{"bash", new StringBuilder().append((String)this.getDirectory()).append((String)File.separator).append((String)"is_available.sh").toString()}).exitValue == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }
}

