/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.suites;

import at.jku.ssw.mevss.benchmarks.AbstractBenchmarkSuite;
import at.jku.ssw.mevss.benchmarks.BenchmarkSuite;
import at.jku.ssw.mevss.benchmarks.FileUtil;
import at.jku.ssw.mevss.benchmarks.ProcessExecutor;
import at.jku.ssw.mevss.benchmarks.Settings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DacapoBenchmarkSuite
extends AbstractBenchmarkSuite
implements BenchmarkSuite {
    private static final String JAR_NAME = "DaCapo" + File.separator + "dacapo-9.12-bach.jar";
    private static final String[] SIZES = new String[]{"gargantuan", "huge", "large", "default", "small", "tiny"};
    private static final int LARGE_SIZE_INDEX = 0;
    private static final int DEFAULT_SIZE_INDEX = 2;
    private static final int FAST_SIZE_INDEX = 4;
    private final Map<String, Integer> sizes = new HashMap<String, Integer>();
    private final String executable;

    public DacapoBenchmarkSuite(String string, String string2, boolean bl, Settings settings) {
        super(string, bl, settings);
        this.executable = string2;
    }

    protected String getJarName() {
        return JAR_NAME;
    }

    private String getJarPath() {
        return this.getDirectory() + this.getJarName();
    }

    private int getBenchmarkBiggestInput(String string) {
        return this.getBenchmarkBiggestInput(string, 1);
    }

    private synchronized int getBenchmarkBiggestInput(String string, int n) {
        Integer n2 = this.sizes.get(string);
        if (n2 == null) {
            int n3;
            int n4 = n3 = this.isFast() ? 4 : 0;
            while (n2 == null && n3 < SIZES.length) {
                try {
                    for (int i = 0; i < n; ++i) {
                        ProcessExecutor.Result result = ProcessExecutor.execute(!this.getSettings().forceLoudProcesses, ".", 900000L, null, null, this.executable, "-jar", this.getJarPath(), "--iterations", "2", "--size", SIZES[n3], string);
                        if (FileUtil.contains(new File[]{result.err}, "PASSED") || result.timeout) {
                            n2 = n3;
                        } else if (FileUtil.contains(new File[]{result.err}, "FAILED")) {
                            Thread.sleep(5000L);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException | InterruptedException exception) {
                    exception.printStackTrace(System.err);
                }
                ++n3;
            }
            if (n2 == null) {
                if (--n <= 0) {
                    throw new IllegalArgumentException("No valid size for benchmark '" + string + "'!");
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.getBenchmarkBiggestInput(string, n);
            }
            this.sizes.put(string, n2);
        }
        return n2;
    }

    @Override
    public String getName() {
        return "DaCapo";
    }

    @Override
    public String[] getExclusiveResources(String string) {
        switch (string) {
            case "tomcat": 
            case "tradebeans": 
            case "tradesoap": {
                return new String[]{"networking"};
            }
        }
        return super.getExclusiveResources(string);
    }

    @Override
    public String[] getBenchmarks() {
        try {
            Object[] objectArray = FileUtil.readAll(ProcessExecutor.execute((boolean)(!this.getSettings().forceLoudProcesses ? true : false), (String)".", (long)10000L, null, null, (String[])new String[]{this.executable, "-jar", this.getJarPath(), "-l"}).out).split(" ");
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = ((String)objectArray[i]).trim();
            }
            Arrays.sort(objectArray);
            return objectArray;
        }
        catch (IOException | InterruptedException exception) {
            exception.printStackTrace(System.err);
            return new String[0];
        }
    }

    @Override
    public String[] getSystemProperties(String string) {
        if (string.equals("lusearch")) {
            return new String[]{"-Dbenchmarkexecutor.agent.invalidate_on=org.apache.lucene.store.AlreadyClosedException"};
        }
        if (string.equals("batik")) {
            return new String[]{"-Xbootclasspath/a:" + this.getDirectory() + File.separator + "DaCapoPatches" + File.separator + "batik"};
        }
        return new String[0];
    }

    @Override
    public String[] getClassPath() {
        return new String[]{this.getJarPath()};
    }

    @Override
    public String getMainClass() {
        return "Harness";
    }

    @Override
    public String[] getParameters(String string, int n) {
        int n2;
        try {
            n2 = this.getBenchmarkBiggestInput(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n2 = -1;
        }
        if (n2 >= 0 && !this.isFast()) {
            int n3;
            for (n3 = n2; n3 > 2; --n3) {
                n *= 2;
            }
            for (n3 = n2; n3 < 2 && n > 1; n /= 2, ++n3) {
            }
        }
        return new String[]{"--callback", "at.jku.ssw.mevss.benchmarks.agent.suites.DacapoManagedAgent", "--iterations", String.valueOf(n + 1), "--size", n2 >= 0 ? SIZES[n2] : "default", string};
    }

    @Override
    public String[] getPrepareCommand(String string, int n) {
        return this.getCleanupCommand(string);
    }

    @Override
    public long getWaitTime(String string) {
        return string.startsWith("trade") && !this.isFast() ? 900L : super.getWaitTime(string);
    }

    @Override
    public String[] getCleanupCommand(String string3) {
        return new String[]{"bash", "-c", "rm -r " + Arrays.stream(this.getScratchDirectories()).reduce((string, string2) -> string + " " + string2).orElse("")};
    }

    protected String[] getScratchDirectories() {
        return new String[]{"scratch"};
    }

    @Override
    public boolean isLauncher() {
        return false;
    }

    @Override
    public boolean deploysCallback() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        return new File(this.getJarPath()).exists();
    }
}

