/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.specific;

import at.jku.ssw.mevss.benchmarks.ArraysUtil;
import at.jku.ssw.mevss.benchmarks.BenchmarkAgent;
import at.jku.ssw.mevss.benchmarks.BenchmarkSpecificParameters;
import at.jku.ssw.mevss.benchmarks.BenchmarkSuite;
import at.jku.ssw.mevss.benchmarks.FileUtil;
import at.jku.ssw.mevss.benchmarks.ProcessExecutor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BenchmarkSpecificMemoryPressure
implements BenchmarkSpecificParameters {
    private static final boolean SAMPLING = true;
    private static final long FACTOR = 1024L;
    private static final long B = 1L;
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long DEFAULT_MIN_SIZE = 0L;
    private static final long DEFAULT_MAX_SIZE = 0x1000000000L;
    private static final long DEFAULT_START_SIZE = 0x80000000L;
    private static final long PRECISION_ABSOLUTE = 0x800000L;
    private static final double PRECISION_RELATIVE = 0.01;
    private static final int TRIES = 3;
    private static final String[] ERROR_INDICATORS = new String[]{"java.lang.OutOfMemoryError:", "Error occurred during initialization of VM"};
    private static final String FIXED_PARAMETER = "-XX:OnOutOfMemoryError=kill -9 %p";
    private static final Logger LOGGER = Logger.getLogger(BenchmarkSpecificMemoryPressure.class.getName());
    private final double factor;
    private final File output;
    private final Map<BenchmarkSuite, Map<String, Long>> sizes;

    public BenchmarkSpecificMemoryPressure() {
        this(1.0, null);
    }

    public BenchmarkSpecificMemoryPressure(double d, File file) {
        this.factor = d;
        this.output = file;
        this.sizes = new HashMap<BenchmarkSuite, Map<String, Long>>();
    }

    @Override
    public synchronized String[] get(String string, BenchmarkSuite benchmarkSuite, String string2, String[] stringArray, long l, boolean bl) throws InterruptedException, IOException {
        if (this.factor != 0.0) {
            Long l2 = this.getLiveSize(benchmarkSuite, string2);
            if (l2 == null) {
                LOGGER.log(Level.INFO, "calibrating memory pressure for " + benchmarkSuite.getName() + "." + string2);
                l2 = this.sampleLiveSize(string, benchmarkSuite, string2, stringArray, l, bl);
                if (l2 == 0L) {
                    l2 = this.searchLiveSize(string, benchmarkSuite, string2, stringArray, l, 0L, bl);
                } else {
                    LOGGER.log(Level.FINE, "verifying sampling result");
                    long l3 = Math.max((long)((double)l2.longValue() * 0.01), 0x800000L);
                    long l4 = Math.max(l2 - l3, 1L);
                    if (this.tryExecuteWithHeapSize(string, benchmarkSuite, string2, stringArray, l, l4, bl) > 0L) {
                        LOGGER.log(Level.FINE, "sampling failed because error is too big, falling back to searching");
                        l2 = this.searchLiveSize(string, benchmarkSuite, string2, stringArray, l, l4 / 2L, 0L, l4, bl);
                    } else if (this.tryExecuteWithHeapSize(string, benchmarkSuite, string2, stringArray, l, l2, bl) == 0L) {
                        LOGGER.log(Level.FINE, "sampling failed because size is too small, falling back to searching");
                        l2 = this.searchLiveSize(string, benchmarkSuite, string2, stringArray, l, l2 * 3L / 2L, l2, 0x1000000000L, bl);
                    }
                }
                if (l2 != 0L) {
                    LOGGER.log(Level.INFO, "calibration of memory pressure for " + benchmarkSuite.getName() + "." + string2 + " (" + l2 + "b)");
                } else {
                    LOGGER.log(Level.WARNING, "could not determine memory pressure for " + benchmarkSuite.getName() + "." + string2);
                }
                this.sizes.get(benchmarkSuite).put(string2, l2);
            }
            assert (l2 != null);
            if (this.output != null) {
                this.dump(benchmarkSuite, string2, l2);
            }
            return this.getParameters(l2);
        }
        return this.getParameters(0L);
    }

    private Long getLiveSize(BenchmarkSuite benchmarkSuite, String string) {
        Map<String, Long> map = this.sizes.get(benchmarkSuite);
        if (map == null) {
            map = new HashMap<String, Long>();
            this.sizes.put(benchmarkSuite, map);
        }
        return map.get(string);
    }

    private long sampleLiveSize(String string, BenchmarkSuite benchmarkSuite, String string2, String[] stringArray, long l, boolean bl) throws InterruptedException, IOException {
        LOGGER.log(Level.FINE, "sampling live size");
        File file = File.createTempFile(this.getClass().getName(), ".result");
        File file2 = File.createTempFile(this.getClass().getName(), ".livesizes");
        String[] stringArray2 = ArraysUtil.merge(String.class, {string}, stringArray, BenchmarkAgent.getAgentParameterString(new File("/dev/null"), new File("/dev/null"), file, !benchmarkSuite.deploysCallback(), 0L), {"-classpath", ArraysUtil.toString(':', benchmarkSuite.getClassPath())}, benchmarkSuite.getSystemProperties(string2), {"at.jku.ssw.mevss.benchmarks.agent.livememory.LiveMemorySearcher", String.valueOf(0), file2.getAbsolutePath()}, {benchmarkSuite.getMainClass()}, benchmarkSuite.getParameters(string2, 0));
        long[] lArray = new long[3];
        for (int i = 0; i < 3; ++i) {
            LOGGER.log(Level.FINEST, "sampling live size (" + i + ")");
            ProcessExecutor.execute(!bl, benchmarkSuite.getPrepareCommand(string2, 0));
            ProcessExecutor.execute(false, ".", l, null, null, stringArray2);
            ProcessExecutor.execute(!bl, benchmarkSuite.getCleanupCommand(string2));
            Thread.sleep(benchmarkSuite.getWaitTime(string2) * 1000L);
            if (file.exists() && FileUtil.readAll(file).equals("valid")) {
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));){
                    ParseLiveSizeResult parseLiveSizeResult = this.parseLiveSize(bufferedReader);
                    LOGGER.log(Level.FINEST, "sampled live size (" + parseLiveSizeResult.samples + " samples -> " + parseLiveSizeResult.liveSize + "b)");
                    lArray[i] = parseLiveSizeResult.liveSize;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "could not read sampling file", iOException);
                    lArray[i] = 0L;
                }
            } else {
                LOGGER.log(Level.WARNING, "sampling live size failed");
            }
            file2.delete();
            file.delete();
        }
        long l2 = lArray[0];
        long l3 = lArray[0];
        for (long l4 : lArray) {
            l2 = Math.max(l2, l4);
            l3 = Math.min(l3, l4);
        }
        l3 = l2 - l3;
        LOGGER.log(Level.FINE, "sampling finished (" + file + "b, error " + l3 + "b)");
        return l2;
    }

    private ParseLiveSizeResult parseLiveSize(BufferedReader bufferedReader) throws IOException {
        long l = 0L;
        long l2 = 0L;
        String string = bufferedReader.readLine();
        while (string != null) {
            l = Math.max(l, Long.parseLong(string));
            ++l2;
            string = bufferedReader.readLine();
        }
        return new ParseLiveSizeResult(l2, l);
    }

    private long searchLiveSize(String string, BenchmarkSuite benchmarkSuite, String string2, String[] stringArray, long l, long l2, boolean bl) throws InterruptedException, IOException {
        return this.searchLiveSize(string, benchmarkSuite, string2, stringArray, l, l2, 0L, 0x1000000000L, bl);
    }

    private long searchLiveSize(String string, BenchmarkSuite benchmarkSuite, String string2, String[] stringArray, long l, long l2, long l3, long l4, boolean bl) throws InterruptedException, IOException {
        long l5;
        LOGGER.log(Level.FINE, "searching live size (" + l2 + "b e ]" + l3 + "b, " + l4 + "b])");
        boolean bl2 = false;
        long l6 = l5 = l2 > 0L ? l2 : 0x80000000L;
        while (l4 - l3 > 0x800000L && (double)(l4 - l3) > (double)l4 * 0.01) {
            long l7 = this.tryExecuteWithHeapSize(string, benchmarkSuite, string2, stringArray, l, l5, bl);
            if (l7 > 0L) {
                LOGGER.log(Level.FINER, "decreasing upper bound of heap size range");
                long l8 = Math.min(l5, l7);
                l4 = l8 > l3 ? l8 : l5;
                bl2 = true;
            } else {
                LOGGER.log(Level.FINER, "increasing lower bound of heap size range");
                l3 = l5;
            }
            l5 = l3 + (l4 - l3) / 2L;
        }
        l5 = bl2 ? l4 : 0L;
        LOGGER.log(Level.FINE, "searching finished (" + l5 + "b)");
        return l5;
    }

    private long tryExecuteWithHeapSize(String string, BenchmarkSuite benchmarkSuite, String string2, String[] stringArray, long l, long l2, boolean bl) throws InterruptedException, IOException {
        LOGGER.log(Level.FINER, "trying heap size " + l2 + "b");
        File file = File.createTempFile(this.getClass().getName(), ".result");
        File file2 = File.createTempFile(this.getClass().getName(), ".result.all");
        String[] stringArray2 = ArraysUtil.merge(String.class, {string, FIXED_PARAMETER, BenchmarkSpecificMemoryPressure.getSizeParameter(l2)}, stringArray, BenchmarkAgent.getAgentParameterString(new File("/dev/null"), file2, file, !benchmarkSuite.deploysCallback(), 0L), benchmarkSuite.getSystemProperties(string2), {"-classpath", ArraysUtil.toString(':', benchmarkSuite.getClassPath())}, {benchmarkSuite.getMainClass()}, benchmarkSuite.getParameters(string2, 0));
        long l3 = Long.MAX_VALUE;
        for (int i = 0; i < 3 && l3 > 0L; ++i) {
            LOGGER.log(Level.FINEST, "trying heap size " + l2 + "b (" + i + ")");
            ProcessExecutor.execute(!bl, benchmarkSuite.getPrepareCommand(string2, 0));
            ProcessExecutor.Result result = ProcessExecutor.execute(false, ".", l, null, null, stringArray2);
            ProcessExecutor.execute(!bl, benchmarkSuite.getCleanupCommand(string2));
            Thread.sleep(benchmarkSuite.getWaitTime(string2) * 1000L);
            if (result.timeout || FileUtil.contains(new File[]{result.out, result.err}, ERROR_INDICATORS)) {
                LOGGER.log(Level.FINEST, "execution failed with memory error");
                l3 = 0L;
            } else if (file.exists() && FileUtil.readAll(file).equals("valid")) {
                LOGGER.log(Level.FINEST, "execution succeeded");
                l3 = this.parsePeakMemoryUsage(file2, l3);
            } else {
                LOGGER.log(Level.WARNING, "execution failed");
                l3 = 0L;
            }
            file.delete();
            file2.delete();
        }
        return l3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long parsePeakMemoryUsage(File file, long l) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = bufferedReader.readLine();
            while (string != null) {
                int n;
                String string2;
                if (!string.trim().startsWith("#") && (string2 = string.substring(0, n = string.indexOf(61))).equals("peak_memory_usage_heap")) {
                    String string3 = string.substring(n + 1);
                    long l2 = 0L;
                    for (String string4 : string3.split(";")) {
                        l2 = Math.max(l2, Long.parseLong(string4));
                    }
                    long l3 = l2 > 0L ? Math.min(l, l2) : l;
                    return l3;
                }
                string = bufferedReader.readLine();
            }
            long l4 = l;
            return l4;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "an error occured when reading properties", iOException);
            return 0L;
        }
    }

    public String[] getParameters(long l) {
        if (l == 0L) {
            return new String[]{FIXED_PARAMETER};
        }
        return new String[]{FIXED_PARAMETER, BenchmarkSpecificMemoryPressure.getSizeParameter((long)Math.ceil((double)l * this.factor))};
    }

    private static String getSizeParameter(long l) {
        return l != 0L ? "-Xmx" + l : null;
    }

    private void dump(BenchmarkSuite benchmarkSuite, String string, Long l) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.output, true));){
            bufferedWriter.append(benchmarkSuite.getName());
            bufferedWriter.append(".");
            bufferedWriter.append(string);
            bufferedWriter.append("=");
            bufferedWriter.append(String.valueOf(l));
            bufferedWriter.append("\n");
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "an error occured when writing size to a file", iOException);
        }
    }

    private static class ParseLiveSizeResult {
        public final long samples;
        public final long liveSize;

        public ParseLiveSizeResult(long l, long l2) {
            this.samples = l;
            this.liveSize = l2;
        }
    }
}

