/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks;

import at.jku.ssw.mevss.benchmarks.WindowsProcess;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessExecutor {
    private static final Logger LOGGER = Logger.getLogger(ProcessExecutor.class.getName());

    public static Result execute(boolean bl, String ... stringArray) throws InterruptedException, IOException {
        return ProcessExecutor.execute(bl, ".", 0L, null, null, stringArray);
    }

    public static Result execute(boolean bl, String string, long l, File file, File file2, String ... stringArray) throws InterruptedException, IOException {
        if (stringArray == null) {
            return null;
        }
        if (file == null) {
            file = File.createTempFile(ProcessExecutor.class.getSimpleName(), "out");
            file.deleteOnExit();
        }
        if (file2 == null) {
            file2 = File.createTempFile(ProcessExecutor.class.getSimpleName(), "err");
            file2.deleteOnExit();
        }
        if (!bl) {
            LOGGER.log(Level.INFO, String.format("executing command %s (%s)", Arrays.toString(stringArray), l > 0L ? String.format("timeout = %,d[ms]", l) : "no timeout"));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(new File(string));
        processBuilder.command(stringArray);
        processBuilder.redirectOutput(file);
        if (file == file2) {
            processBuilder.redirectErrorStream(true);
        } else {
            processBuilder.redirectError(file2);
        }
        long l2 = System.currentTimeMillis();
        Process process = processBuilder.start();
        try {
            if (!bl) {
                LOGGER.log(Level.FINE, "waiting for process");
            }
            if (l == 0L) {
                process.waitFor();
            } else {
                boolean bl2 = process.waitFor(l, TimeUnit.MILLISECONDS);
                while (!bl2) {
                    if (!bl) {
                        LOGGER.log(Level.WARNING, "timeout reached, trying to destroy ...");
                    }
                    bl2 = ProcessExecutor.destroy(bl, process);
                }
            }
            assert (!process.isAlive());
            long l3 = System.currentTimeMillis() - l2;
            int n = process.exitValue();
            if (!bl) {
                LOGGER.log(Level.INFO, "execution finished in " + l3 + "[ms] => " + n);
            }
            return new Result(file, file2, l3, l > 0L && l3 >= l, n);
        }
        catch (Error | InterruptedException | RuntimeException throwable) {
            LOGGER.log(Level.SEVERE, "execution failed", throwable);
            throw throwable;
        }
    }

    private static boolean destroy(boolean bl, Process process) throws InterruptedException {
        String string = System.getProperty("os.name").toLowerCase();
        int n = 1;
        while (n != 0 && process.isAlive()) {
            switch (n) {
                case 1: {
                    long l;
                    Field field;
                    try {
                        if (string.contains("linux") || string.contains("mac")) {
                            field = process.getClass().getDeclaredField("pid");
                            field.setAccessible(true);
                            if (!bl) {
                                LOGGER.log(Level.INFO, "trying to destroy tree using recursive script");
                            }
                            long l2 = ((Number)field.get(process)).longValue();
                            ProcessExecutor.execute(bl, "resources", 0L, null, null, "bash", "kill_process_tree.sh", String.valueOf(l2));
                            break;
                        }
                        if (!string.contains("windows")) break;
                        field = process.getClass().getDeclaredField("handle");
                        field.setAccessible(true);
                        if (!bl) {
                            LOGGER.log(Level.INFO, "trying to destroy tree using windows taskkill command");
                        }
                        long l3 = ((Number)field.get(process)).longValue();
                        l = WindowsProcess.getPID(l3);
                        ProcessExecutor.execute(bl, "taskkill", "/pid", String.valueOf(l), "/f", "/t");
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.WARNING, "failed", throwable);
                    }
                    break;
                }
                case 2: {
                    long l;
                    Field field;
                    try {
                        if (string.contains("linux") || string.contains("mac")) {
                            field = process.getClass().getDeclaredField("pid");
                            field.setAccessible(true);
                            if (!bl) {
                                LOGGER.log(Level.INFO, "trying to destroy using Unix kill command");
                            }
                            String string2 = field.get(process).toString();
                            ProcessExecutor.execute(bl, "kill", "-9", string2);
                            break;
                        }
                        if (!string.contains("windows")) break;
                        field = process.getClass().getDeclaredField("handle");
                        field.setAccessible(true);
                        if (!bl) {
                            LOGGER.log(Level.INFO, "trying to destroy using Windows taskkill command");
                        }
                        long l4 = ((Number)field.get(process)).longValue();
                        l = WindowsProcess.getPID(l4);
                        ProcessExecutor.execute(bl, "taskkill", "/pid", String.valueOf(l), "/f");
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.WARNING, "failed", throwable);
                    }
                    break;
                }
                case 3: {
                    if (!bl) {
                        LOGGER.log(Level.INFO, "trying to destroy using Process.destroy()");
                    }
                    process.destroy();
                    break;
                }
                case 4: {
                    if (!bl) {
                        LOGGER.log(Level.INFO, "trying to destroy forcibly using Process.destroyForcibly()");
                    }
                    process.destroyForcibly();
                    break;
                }
                default: {
                    LOGGER.log(Level.SEVERE, "destroying process failed");
                    return false;
                }
            }
            if (process.waitFor(1L, TimeUnit.SECONDS)) {
                n = 0;
                continue;
            }
            ++n;
        }
        if (!bl) {
            LOGGER.log(Level.INFO, "process destroyed successfully");
        }
        return true;
    }

    public static class Result {
        public final File out;
        public final File err;
        public final long fullRuntime;
        public final boolean timeout;
        public final int exitValue;

        private Result(File file, File file2, long l, boolean bl, int n) {
            this.out = file;
            this.err = file2;
            this.fullRuntime = l;
            this.timeout = bl;
            this.exitValue = n;
        }
    }
}

