/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class PermutationIterator<T>
implements Iterator<T[]> {
    private final T[] elements;
    private final int maxElements;
    private final int minElements;
    private final Set<Integer> includedPermutations;
    private Long permutation;

    public PermutationIterator(T[] TArray, int n, int n2, Set<Integer> set) {
        if (TArray.length > 64) {
            throw new IllegalArgumentException();
        }
        this.elements = TArray;
        this.maxElements = n;
        this.minElements = n2;
        this.includedPermutations = set;
        this.permutation = PermutationIterator.nextPermutation(-1L, TArray.length, n, n2, set, false);
    }

    @Override
    public boolean hasNext() {
        return this.permutation != null;
    }

    @Override
    public T[] next() {
        try {
            T[] TArray = PermutationIterator.toElements(this.permutation, this.elements);
            return TArray;
        }
        finally {
            this.permutation = PermutationIterator.nextPermutation(this.permutation, this.elements.length, this.maxElements, this.minElements, this.includedPermutations, true);
        }
    }

    private static <T> T[] toElements(long l, T[] TArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < TArray.length; ++i) {
            if ((l & (long)(1 << i)) == 0L) continue;
            arrayList.add(TArray[i]);
        }
        return arrayList.toArray((Object[])Array.newInstance(TArray.getClass().getComponentType(), arrayList.size()));
    }

    private static Long nextPermutation(long l, int n, int n2, int n3, Set<Integer> set, boolean bl) {
        boolean bl2;
        do {
            int n4 = 0;
            bl2 = false;
            ++l;
            for (int i = 0; i < n; ++i) {
                if ((l & (long)(1 << i)) == 0L) continue;
                ++n4;
            }
            if (n4 == 0 && bl) {
                return null;
            }
            if (n4 <= n2 || n4 >= n - n3 || set.contains(n4)) continue;
            bl2 = true;
            bl = true;
        } while (bl2);
        return bl2 ? null : Long.valueOf(l);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

