/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InputBuffer
implements Closeable {
    private final InputStream source;
    private final StringBuilder buffer;
    private final Thread worker;
    private final Logger logger;

    public InputBuffer(String string, boolean bl, InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        this.source = inputStream;
        this.buffer = new StringBuilder();
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                InputBuffer.this.run();
            }
        }, string);
        this.logger = bl ? Logger.getLogger(string) : null;
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public String getName() {
        return this.worker.getName();
    }

    public String getBuffer() {
        return this.buffer.toString();
    }

    public void join() throws InterruptedException {
        this.worker.join();
    }

    private void run() {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.source));){
            String string = bufferedReader.readLine();
            while (string != null) {
                this.buffer.append(string);
                this.buffer.append(System.lineSeparator());
                if (this.logger != null) {
                    this.logger.log(Level.INFO, string);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            this.buffer.append("# Exception while reading stream: " + iOException + "\n");
        }
    }

    @Override
    public void close() {
        this.worker.interrupt();
    }
}

