/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks;

import at.jku.ssw.mevss.benchmarks.ArraysUtil;
import at.jku.ssw.mevss.benchmarks.Benchmark;
import at.jku.ssw.mevss.benchmarks.BenchmarkAgent;
import at.jku.ssw.mevss.benchmarks.BenchmarkConfiguration;
import at.jku.ssw.mevss.benchmarks.BenchmarkResult;
import at.jku.ssw.mevss.benchmarks.BenchmarkSpecificParameters;
import at.jku.ssw.mevss.benchmarks.BenchmarkSuite;
import at.jku.ssw.mevss.benchmarks.BenchmarkSuiteFactory;
import at.jku.ssw.mevss.benchmarks.FileUtil;
import at.jku.ssw.mevss.benchmarks.ProcessExecutor;
import at.jku.ssw.mevss.benchmarks.Results;
import at.jku.ssw.mevss.benchmarks.Settings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.channels.FileLock;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class BenchmarkExecutor {
    private static final String RESOURCES_DIRECTORY = BenchmarkExecutor.toAbsolutePath("." + File.separator + "resources" + File.separator);
    private static final Logger LOGGER = Logger.getLogger(BenchmarkExecutor.class.getName());
    private static final String CRASH_INDICATOR = "# A fatal error has been detected by the Java Runtime Environment";
    private static final String KNOWN_VM_BUG = "PSParallelCompact::IsAliveClosure::do_object_b(oopDesc*)";
    private final Settings settings;
    public final Results results;
    private File xmlExecutionOverviewFile;
    private int id = 0;
    private BenchmarkSuite suite;
    private Benchmark benchmark;
    private BenchmarkConfiguration configuration;
    private String[] fixedParameters;
    private String[] specificParameters;
    private String[] parameters;
    private String[] classPath;
    private String[] suiteSystemProperties;
    private String suiteMainClass;
    private String[] suiteBenchmarkParameters;
    private String[] suitePrepareCommand;
    private String[] suiteCleanupCommand;
    private long wait;
    private static final File LOCK_DIRECTORY = new File(System.getProperty("user.home") + File.separator + ".benchmarkexecutor");
    private static final File LOCK = new File(LOCK_DIRECTORY + File.separator + "lock");
    private static final File RESOURCES = new File(LOCK_DIRECTORY + File.separator + "resources");

    private static String toAbsolutePath(String string) {
        return new File(string).getAbsolutePath();
    }

    public BenchmarkExecutor(Settings settings) {
        this.settings = settings;
        this.results = new Results();
        this.xmlExecutionOverviewFile = new File(settings.outputDirectory + File.separator + "results.xml");
    }

    public void execute() throws IOException, InterruptedException {
        long l;
        BenchmarkAgent.init(RESOURCES_DIRECTORY);
        BenchmarkSuiteFactory benchmarkSuiteFactory = new BenchmarkSuiteFactory(RESOURCES_DIRECTORY, this.settings.executable, this.settings.fast, this.settings);
        this.fixedParameters = BenchmarkExecutor.getParameterArray(this.settings.fixedParameter.toArray(new String[this.settings.fixedParameter.size()]));
        String string = "Available suites:\n==========\n";
        for (String string2 : benchmarkSuiteFactory.getSuiteNames()) {
            string = string + "\n" + string2 + ":";
            for (String string3 : benchmarkSuiteFactory.getSuite(string2).getBenchmarks()) {
                string = string + " " + string3;
            }
        }
        LOGGER.info(string);
        this.xmlExecutionOverviewFile.createNewFile();
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.xmlExecutionOverviewFile, true));){
            bufferedWriter.write("<?xml version=\"1.0\"?>\n");
            bufferedWriter.write("<?xml-stylesheet type=\"text/xsl\" href=\"results.xsl\"?>\n");
            bufferedWriter.write("<Executions>\n");
        }
        try {
            Files.copy(Paths.get("resources", "results.xsl"), Paths.get(this.xmlExecutionOverviewFile.getParent(), "results.xsl"), new CopyOption[0]);
        }
        catch (Exception exception) {
            LOGGER.warning("Could not copy .xsl file");
        }
        do {
            l = System.currentTimeMillis();
            for (String string4 : benchmarkSuiteFactory.getSuiteNames()) {
                this.suite = benchmarkSuiteFactory.getSuite(string4);
                if (!this.suite.isAvailable()) continue;
                this.classPath = this.suite.getClassPath();
                for (String string5 : this.suite.getBenchmarks()) {
                    if (!BenchmarkExecutor.doExecute(this.settings.suite, string4, this.settings.benchmark, string5) || BenchmarkExecutor.isIgnoredBenchmark(this.suite.getName(), string5)) continue;
                    BenchmarkExecutor.lock(this.suite, string5);
                    this.suiteSystemProperties = this.suite.getSystemProperties(string5);
                    Map<String, Map<String, Benchmark>> map = this.results.benchmarks;
                    Map<String, Benchmark> map2 = map.get(this.suite.getName());
                    if (map2 == null) {
                        map2 = new HashMap<String, Benchmark>();
                        map.put(this.suite.getName(), map2);
                    }
                    this.benchmark = map2.get(string5);
                    if (this.benchmark == null) {
                        this.benchmark = new Benchmark(this.suite.getName(), string5);
                        map2.put(string5, this.benchmark);
                    }
                    LOGGER.log(Level.INFO, "executing benchmark '" + this.suite.getName() + "." + this.benchmark.getName() + "'");
                    this.suitePrepareCommand = this.suite.getPrepareCommand(string5, this.settings.warmups);
                    this.suiteCleanupCommand = this.suite.getCleanupCommand(string5);
                    this.wait = this.suite.getWaitTime(string5) * 1000L;
                    this.specificParameters = new String[0];
                    for (BenchmarkSpecificParameters benchmarkSpecificParameters : this.settings.specificParameters) {
                        this.specificParameters = ArraysUtil.merge(String.class, this.specificParameters, benchmarkSpecificParameters.get(this.settings.executable, this.suite, this.benchmark.getName(), this.fixedParameters, this.settings.timeout, this.settings.forceLoudProcesses));
                    }
                    this.suiteMainClass = this.suite.getMainClass();
                    this.suiteBenchmarkParameters = this.suite.getParameters(string5, this.settings.warmups);
                    int n = 0;
                    if (this.settings.referenceExecutable != null) {
                        this.configuration = this.benchmark.getConfiguration(n++, new String[0], true);
                        LOGGER.log(Level.INFO, "executing benchmark '" + this.suite.getName() + "." + this.benchmark.getName() + "' reference");
                        this.run();
                    }
                    for (String[] stringArray : this.settings.parameterPermutations) {
                        if (BenchmarkExecutor.isIgnoredBenchmark(this.suite.getName(), string5, stringArray)) continue;
                        this.parameters = BenchmarkExecutor.getParameterArray(stringArray);
                        this.configuration = this.benchmark.getConfiguration(n++, stringArray, false);
                        LOGGER.log(Level.INFO, "executing benchmark '" + this.suite.getName() + "." + this.benchmark.getName() + "' with parameters '" + this.configuration.getParamsString() + "'");
                        this.run();
                    }
                    BenchmarkExecutor.unlock(this.suite, string5);
                }
            }
            l = System.currentTimeMillis() - l;
            LOGGER.log(Level.INFO, "macro iteration took " + 1.0 * (double)l / 1000.0 + "s");
        } while (System.currentTimeMillis() + l < this.settings.untilTime);
        bufferedWriter = new BufferedWriter(new FileWriter(this.xmlExecutionOverviewFile, true));
        Throwable throwable = null;
        try {
            bufferedWriter.write("</Executions>");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (bufferedWriter != null) {
                if (throwable != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    bufferedWriter.close();
                }
            }
        }
    }

    private static boolean doExecute(List<String> list, String string, List<String> list2, String string2) {
        if (list.size() == 0 && list2.size() == 0) {
            return true;
        }
        if (list.size() > 0 && list2.size() == 0) {
            return BenchmarkExecutor.containsIgnoreCase(list, string);
        }
        if (list.size() == 0 && list2.size() > 0) {
            return BenchmarkExecutor.containsIgnoreCase(list2, string2);
        }
        if (list.size() > 0 && list2.size() > 0) {
            return BenchmarkExecutor.containsIgnoreCase(list, string) || BenchmarkExecutor.containsIgnoreCase(list2, string2);
        }
        assert (false);
        return false;
    }

    private static boolean containsIgnoreCase(Iterable<String> iterable, String string) {
        for (String string2 : iterable) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIgnoredBenchmark(String string, String string2) {
        String string3 = System.getProperty("benchmarkexecutor.ignored_benchmarks.prefixes");
        if (string3 != null) {
            for (String string4 : string3.split(" ")) {
                if ((string4 = string4.trim()).length() <= 0 || !string2.startsWith(string4) || string4.contains(";")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isIgnoredBenchmark(String string, String string3, String[] stringArray) {
        String string4 = System.getProperty("benchmarkexecutor.ignored_benchmarks.prefixes");
        if (string4 != null) {
            for (String string5 : string4.split(" ")) {
                String[] stringArray2 = (string5 = string5.trim()).split(";");
                if (stringArray2[0].length() <= 0 || !string3.startsWith(stringArray2[0].trim())) continue;
                if (stringArray2.length > 1) {
                    for (int i = 1; i < stringArray2.length; ++i) {
                        String string6 = stringArray2[i];
                        if (!Arrays.stream(stringArray).anyMatch(string2 -> string2.contains(string6))) continue;
                        return true;
                    }
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    private static String[] getParameterArray(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.startsWith("@@")) {
                if ((string = string.substring(2).trim()).length() <= 0) continue;
                arrayList.add(string);
                continue;
            }
            for (String string2 : string.split(" ")) {
                if (string2.length() <= 0) continue;
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private int run() throws IOException, InterruptedException {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        boolean bl2 = false;
        String string3 = System.getProperty("benchmarkexecutor.first_id");
        int n = string3 != null ? Integer.parseInt(string3) : 0;
        int n2 = 0;
        for (int i = 0; i < this.settings.iterations && !bl2; ++i) {
            boolean bl3;
            Object object2;
            boolean bl4;
            boolean bl5;
            long l;
            String[] stringArray;
            if (this.id < n) {
                ++this.id;
                continue;
            }
            LOGGER.log(Level.INFO, "executing benchmark '" + this.suite.getName() + "." + this.benchmark.getName() + "' with parameters '" + this.configuration.getParamsString() + "' #" + i);
            String string4 = this.suite.getName() + ";" + this.benchmark.getName() + ";" + Arrays.stream(this.parameters).reduce((string, string2) -> string + " " + string2).orElse("<default>").trim();
            System.out.println(string4);
            System.out.flush();
            String string5 = "<Execution suite=\"" + this.suite.getName() + "\" benchmark=\"" + this.benchmark.getName() + "\" parameters=\"" + Arrays.stream(this.parameters).reduce((string, string2) -> string + " " + string2).orElse("default").trim() + "\">\n";
            ProcessExecutor.execute(!this.settings.forceLoudProcesses, this.suitePrepareCommand);
            String string6 = this.settings.outputLogDirectory + File.separator + this.id + "_" + this.suite.getName() + "_" + this.benchmark.getName();
            File file = new File(string6 + ".log");
            File file2 = new File(string6 + ".out");
            File file3 = this.settings.mergeOutput ? file2 : new File(string6 + ".err");
            File file4 = new File(string6 + ".result");
            File file5 = new File(string6 + ".result.best");
            File file6 = new File(string6 + ".result.all");
            File file7 = new File(string6 + ".result.global");
            File file8 = new File(string6 + ".test");
            File file9 = new File(string6 + ".test.err");
            File file10 = new File(string6 + ".metrics.err");
            String[] stringArray2 = new String[]{};
            if (this.settings.allowOOM) {
                stringArray2 = ArraysUtil.append(String.class, stringArray2, "-XX:OnOutOfMemoryError=echo invalid > " + file4 + " && kill -9 %p");
            }
            if (this.suite.isLauncher()) {
                stringArray = ArraysUtil.merge(String.class, {this.suiteMainClass}, this.suiteBenchmarkParameters, {String.valueOf(this.settings.timeout / 1000L), this.settings.executable}, BenchmarkAgent.getAgentParameterString(file5, file6, file4, true, this.settings.timeout), stringArray2, this.fixedParameters, this.specificParameters, this.parameters, {"-Xbootclasspath/a:" + ArraysUtil.toString(File.pathSeparatorChar, this.classPath)}, this.suiteSystemProperties);
                l = this.settings.timeout * 2L;
            } else {
                stringArray = ArraysUtil.merge(String.class, {this.settings.executable}, BenchmarkAgent.getAgentParameterString(file5, file6, file4, !this.suite.deploysCallback(), this.settings.timeout), stringArray2, this.fixedParameters, this.specificParameters, this.parameters, {"-classpath", ArraysUtil.toString(File.pathSeparatorChar, this.classPath)}, this.suiteSystemProperties, {this.suiteMainClass}, this.suiteBenchmarkParameters);
                l = this.settings.timeout;
            }
            String string7 = String.valueOf(this.id);
            stringArray = (String[])Stream.of(stringArray).map(string2 -> string2.replace("$benchmarkexecutor_id", string7)).toArray(String[]::new);
            Object object3 = new BufferedWriter(new FileWriter(file));
            Object object4 = null;
            try {
                ((Writer)object3).write("command=" + ArraysUtil.toString(Arrays.stream(stringArray).map(string -> string.contains(" ") ? "\"" + string + "\"" : string).toArray(String[]::new)) + System.lineSeparator());
                ((Writer)object3).write("suite=" + this.suite.getName() + System.lineSeparator());
                ((Writer)object3).write("benchmark=" + this.benchmark.getName() + System.lineSeparator());
                ((Writer)object3).write("fixed_parameters=" + ArraysUtil.toString(this.fixedParameters) + System.lineSeparator());
                ((Writer)object3).write("specific_parameters=" + ArraysUtil.toString(this.specificParameters) + System.lineSeparator());
                ((Writer)object3).write("parameters=" + ArraysUtil.toString(this.parameters) + System.lineSeparator());
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (object4 != null) {
                        try {
                            ((BufferedWriter)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object4).addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedWriter)object3).close();
                    }
                }
            }
            System.gc();
            long l2 = System.currentTimeMillis() + this.wait;
            ProcessExecutor.Result result = ProcessExecutor.execute(false, ".", l, file2, file3, stringArray);
            if (result.exitValue != 0 && FileUtil.contains(new File[]{result.out, result.err}, KNOWN_VM_BUG)) {
                object3 = "crashed_with_known_bug";
                LOGGER.log(Level.WARNING, "Benchmark execution encountered known VM bug! (id=" + this.id + ")");
                bl5 = true;
                bl4 = false;
            } else if (result.timeout) {
                object3 = "timeout";
                LOGGER.log(Level.SEVERE, "Benchmark execution timed out! (id=" + this.id + ")");
                bl2 = (double)(++n2) >= (double)this.settings.iterations * 0.2;
                bl5 = true;
                bl4 = false;
            } else if (file4.exists() && !FileUtil.contains(new File[]{result.out, result.err}, CRASH_INDICATOR) && Stream.of("valid", "invalid").anyMatch(string -> string.equals(FileUtil.readAllSilently(file4, "crashed")))) {
                if (FileUtil.readAll(file4).equals("valid") && result.exitValue == 0) {
                    object3 = "succeeded";
                    object2 = new BenchmarkResult(true);
                    try {
                        BenchmarkAgent.readLogFromFile((BenchmarkResult)object2, file5);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, iOException.toString());
                    }
                    bl5 = bl;
                    bl4 = true;
                    this.configuration.addExecution((BenchmarkResult)object2);
                    this.results.metrics.addAll(((BenchmarkResult)object2).getMetrics());
                } else {
                    object3 = "failed";
                    LOGGER.log(Level.WARNING, "Benchmark execution failed! (id=" + this.id + ")");
                    bl5 = true;
                    bl4 = true;
                    bl2 = true;
                }
            } else {
                object3 = "crashed";
                LOGGER.log(Level.SEVERE, "Benchmark execution crashed! (id=" + this.id + ")");
                bl5 = true;
                bl4 = false;
                if (FileUtil.contains(new File[]{result.out, result.err}, "java.lang.OutOfMemoryError")) {
                    bl2 = true;
                }
            }
            object2 = new BufferedWriter(new FileWriter(file, true));
            Object object5 = null;
            try {
                ((Writer)object2).write("full_run_time=" + (double)result.fullRuntime * 1.0 / 1000.0 + "\n");
                ((Writer)object2).write("result=" + (String)object3 + "\n");
            }
            catch (Throwable throwable) {
                object5 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object5 != null) {
                        try {
                            ((BufferedWriter)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object5).addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedWriter)object2).close();
                    }
                }
            }
            System.out.println(string4 + ";run=" + (String)object3);
            System.out.flush();
            string5 = string5 + "<Run>" + (String)object3 + "</Run>\n";
            if (bl4 && this.settings.testCommand != null) {
                object5 = ProcessExecutor.execute(false, ".", this.settings.testTimeout, file8, file9, ArraysUtil.merge(String.class, this.settings.testCommand, {this.settings.outputLogDirectory, String.valueOf(this.id), this.suite.getName() + "." + this.benchmark.getName()}));
                if (((ProcessExecutor.Result)object5).timeout) {
                    LOGGER.log(Level.SEVERE, "Benchmark test timed out! (id=" + this.id + ")");
                    bl3 = true;
                    object4 = "timeout";
                } else if (FileUtil.contains(new File[]{file8}, "UNABLE")) {
                    bl3 = bl;
                    object4 = "unable";
                } else if (FileUtil.contains(new File[]{file8}, "FAILED") || !FileUtil.contains(new File[]{file8}, "PASSED")) {
                    LOGGER.log(Level.SEVERE, "Benchmark test failed! (id=" + this.id + ")");
                    bl5 = true;
                    bl3 = true;
                    object4 = "failed";
                } else {
                    bl3 = bl;
                    object4 = "succeeded";
                }
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, true));){
                    bufferedWriter.write("test=" + (String)object4 + "\n");
                }
                System.out.println(string4 + ";test=" + (String)object4);
                System.out.flush();
                string5 = string5 + "<Test>" + (String)object4 + "</Test>";
            } else {
                object4 = null;
                bl3 = true;
            }
            string5 = string5 + "</Execution>";
            object5 = new BufferedWriter(new FileWriter(this.xmlExecutionOverviewFile, true));
            Throwable throwable = null;
            try {
                ((Writer)object5).write(string5);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            finally {
                if (object5 != null) {
                    if (throwable != null) {
                        try {
                            ((BufferedWriter)object5).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((BufferedWriter)object5).close();
                    }
                }
            }
            for (String[] stringArray3 : this.settings.metricCommand) {
                ProcessExecutor.execute(false, ".", this.settings.metricTimeout, file7, file10, ArraysUtil.append(String.class, stringArray3, file.toString()));
            }
            if (!bl5) {
                result.out.delete();
                result.err.delete();
            }
            if (!bl3) {
                file8.delete();
                file9.delete();
            }
            file4.delete();
            if (this.suiteCleanupCommand != null) {
                ProcessExecutor.execute(true, this.suiteCleanupCommand);
            }
            if (this.settings.customCleanupCommand != null) {
                ProcessExecutor.execute(true, ArraysUtil.merge(String.class, this.settings.customCleanupCommand, {String.valueOf(this.id)}));
            }
            ++this.id;
            long l3 = l2 - System.currentTimeMillis();
            if (l3 <= 0L) continue;
            Thread.sleep(l3);
        }
        return this.id;
    }

    private static void lock(BenchmarkSuite benchmarkSuite, String string3) throws IOException, InterruptedException {
        String[] stringArray2 = benchmarkSuite.getExclusiveResources(string3);
        if (stringArray2 == null || stringArray2.length == 0) {
            return;
        }
        int n = 0;
        while (true) {
            block45: {
                BenchmarkExecutor.ensureLockExists();
                try (RandomAccessFile randomAccessFile = new RandomAccessFile(LOCK, "rw");
                     FileLock fileLock = randomAccessFile.getChannel().lock();){
                    String[] stringArray3 = FileUtil.readAll(RESOURCES).split(";");
                    if (Stream.of(stringArray3).filter(string -> Stream.of(stringArray2).anyMatch(string2 -> string.equals(string2))).count() != 0L) break block45;
                    try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(RESOURCES));){
                        bufferedWriter.write(Stream.of(stringArray3, stringArray2).flatMap(stringArray -> Stream.of(stringArray)).reduce((string, string2) -> string + ";" + string2).orElse(""));
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (n++ < 10) break block45;
                    throw new IOException(iOException);
                }
            }
            Thread.sleep(10000L);
        }
    }

    /*
     * Exception decompiling
     */
    private static void unlock(BenchmarkSuite var0, String var1_1) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void ensureLockExists() throws IOException {
        if (!LOCK_DIRECTORY.exists()) {
            LOCK_DIRECTORY.mkdirs();
        }
        if (!LOCK.exists()) {
            LOCK.createNewFile();
        }
        if (!RESOURCES.exists()) {
            RESOURCES.createNewFile();
        }
    }

    private static /* synthetic */ String lambda$unlock$14(String string, String string2) {
        return string + ";" + string2;
    }

    private static /* synthetic */ boolean lambda$unlock$13(String[] stringArray, String string) {
        return !Stream.of(stringArray).anyMatch(string2 -> string.equals(string2));
    }
}

