/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks;

import at.jku.ssw.mevss.benchmarks.BenchmarkResult;
import java.util.ArrayList;
import java.util.List;

public class BenchmarkConfiguration {
    private final int id;
    private final String[] params;
    private final boolean isReference;
    private final List<BenchmarkResult> results;

    public BenchmarkConfiguration(int n, String[] stringArray, boolean bl) {
        this.id = n;
        this.params = stringArray;
        this.isReference = bl;
        this.results = new ArrayList<BenchmarkResult>();
    }

    public int getId() {
        return this.id;
    }

    public String[] getParams() {
        return (String[])this.params.clone();
    }

    public String getParamsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.params) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString().trim();
    }

    public boolean isReference() {
        return this.isReference;
    }

    public void addExecution(BenchmarkResult benchmarkResult) {
        this.results.add(benchmarkResult);
    }

    public int getRunCount() {
        return this.results.size();
    }

    public Double getMetricAverage(String string) {
        double d = 0.0;
        int n = 0;
        for (BenchmarkResult benchmarkResult : this.results) {
            Number number = benchmarkResult.getMetricValue(string);
            if (number == null) continue;
            d += number.doubleValue();
            ++n;
        }
        return n > 0 ? Double.valueOf(d / (double)n) : null;
    }
}

