/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks;

import at.jku.ssw.mevss.benchmarks.ArraysUtil;
import at.jku.ssw.mevss.benchmarks.BenchmarkResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;

public class BenchmarkAgent {
    private static String directory = null;

    public static void init(String string) {
        if (string.contains(":")) {
            string = string.substring(string.indexOf(58) + 1);
        }
        if (!string.endsWith(File.separator)) {
            directory = string + File.separator;
        }
    }

    public static String getDirectory() {
        return directory;
    }

    public static String[] getAgentParameterString(File file, File file2, File file3, boolean bl, long l) {
        File file4 = new File(BenchmarkAgent.getDirectory() + File.separator + "agent." + BenchmarkAgent.getExtension());
        if (!file4.exists()) {
            throw new RuntimeException("Cannot find agent library at location " + file4);
        }
        file4.setExecutable(true, false);
        String[] stringArray = new String[]{"-agentpath:" + file4 + "=class-path-base=" + directory};
        if (bl) {
            stringArray = ArraysUtil.append(String.class, stringArray, "-Dbenchmarkexecutor.agent.class=at.jku.ssw.mevss.benchmarks.agent.suites.NoIterationsBenchmarkAgent");
        }
        if (l > 0L) {
            stringArray = ArraysUtil.append(String.class, stringArray, "-Dbenchmarkexecutor.agent.dump_delay=" + Math.max(0.0, 1.0 * (double)l / 1000.0 - 10.0));
        }
        stringArray = ArraysUtil.append(String.class, stringArray, "-Dbenchmarkexecutor.agent.result=" + file3);
        stringArray = ArraysUtil.append(String.class, stringArray, "-Dbenchmarkexecutor.agent.result.best=" + file);
        stringArray = ArraysUtil.append(String.class, stringArray, "-Dbenchmarkexecutor.agent.result.all=" + file2);
        return stringArray;
    }

    private static String getExtension() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("windows")) {
            return "dll";
        }
        if (string.contains("mac")) {
            return "dylib";
        }
        if (string.contains("linux")) {
            return "so";
        }
        return "?";
    }

    public static void readLogFromFile(BenchmarkResult benchmarkResult, File file) throws IOException {
        BenchmarkAgent.readLog(benchmarkResult, null, new FileReader(file));
    }

    public static void readLogFromString(BenchmarkResult benchmarkResult, Writer writer, String string) throws IOException {
        BenchmarkAgent.readLog(benchmarkResult, writer, new StringReader(string));
    }

    private static void readLog(BenchmarkResult benchmarkResult, Writer writer, Reader reader) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String string = bufferedReader.readLine();
            while (string != null) {
                if (writer != null) {
                    writer.write(string);
                    writer.write(10);
                }
                if (!string.trim().startsWith("#")) {
                    try {
                        Number number;
                        int n = string.indexOf(61);
                        String string2 = string.substring(0, n);
                        String string3 = string.substring(n + 1);
                        try {
                            number = new Long(Long.valueOf(string3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            number = new Double(Double.valueOf(string3));
                        }
                        benchmarkResult.setMetricValue(string2, number);
                    }
                    catch (Throwable throwable) {
                        throw new IOException("Exception while parsing line '" + string + "'!", throwable);
                    }
                }
                string = bufferedReader.readLine();
            }
        }
    }
}

