/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks;

import at.jku.ssw.mevss.benchmarks.BenchmarkConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Benchmark
implements Comparable<Benchmark> {
    private final String suite;
    private final String name;
    private final Map<Integer, BenchmarkConfiguration> configurations;

    public Benchmark(String string, String string2) {
        this.suite = string;
        this.name = string2;
        this.configurations = new HashMap<Integer, BenchmarkConfiguration>();
    }

    public String getSuiteName() {
        return this.suite;
    }

    public String getName() {
        return this.name;
    }

    public Collection<BenchmarkConfiguration> getConfigurations() {
        return Collections.unmodifiableMap(this.configurations).values();
    }

    public BenchmarkConfiguration getConfiguration(int n, String[] stringArray, boolean bl) {
        BenchmarkConfiguration benchmarkConfiguration = this.configurations.get(n);
        if (benchmarkConfiguration == null) {
            benchmarkConfiguration = new BenchmarkConfiguration(n, stringArray, bl);
            this.configurations.put(n, benchmarkConfiguration);
        } else {
            assert (Arrays.equals(benchmarkConfiguration.getParams(), stringArray));
            assert (benchmarkConfiguration.isReference() == bl);
        }
        return benchmarkConfiguration;
    }

    @Override
    public int compareTo(Benchmark benchmark) {
        int n = this.suite.compareTo(benchmark.suite);
        if (n != 0) {
            return n;
        }
        n = this.name.compareTo(benchmark.name);
        if (n != 0) {
            return n;
        }
        return n;
    }

    public boolean equals(Object object) {
        return object != null && Benchmark.class.equals(object.getClass()) && this.compareTo((Benchmark)object) == 0;
    }

    public int hashCode() {
        return this.suite.hashCode() ^ this.name.hashCode();
    }
}

